
/**
* Copyright (C) 2006-2011 Gaia Data Processing and Analysis Consortium
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*             THIS IS AN AUTOMATICALLY GENERATED FILE - DO NOT EDIT!
*
*    The file has been automatically generated from the contents of the
*    Gaia Parameter Database at the URL
*        https://gaia.esac.esa.int/gpdb/
*    on 2018-03-01T09:17:22.
*
*    Please report any problems arising from the usage of this file to
*    the Gaia Librarian gaia-helpdesk@cosmos.esa.int
*/
package gaia.cu1.params;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/**
 * ||WARNING|| PLEASE KEEP USING GaiaParam as PDB class baseline in your Java code.
 * DO NOT use directly this BasicParam class.
 * This BasicParam class was introduce following issues 7264 and 7432 and 
 * having the output here is for visualization only. 
 *
 * Container class to enclose the contents of the Gaia Parameter
 * Database at<br/>
 *     <code><a href="https://gaia.esac.esa.int/gpdb/">https://gaia.esac.esa.int/gpdb/</a></code><p>
 * A hierachy of nested classes below matches the parameter naming scheme
 * detailed in <code><a href="https://gaia.esac.esa.int/gpdb//docs/gaia-jdb-007.pdf">GAIA-JdB-007</a></code><br/>
 *
 * @author	Gaia SOC, ESA/ESTEC
 * @version	-live(r.599311)-2018-03-01T09:17:22
 */

public class BasicParam {
	// Define our annotation
	@Retention(RetentionPolicy.RUNTIME)
	public @interface ParamMetaData {
		String source();
		String unit();
		String description();
		String status();
		boolean scalar();
		boolean basic();
	}
public static final String DBVersion = "-live(r.599311)-2018-03-01T09:17:22";

public static class Nature {
    /**
     * Calibration function S_V(\lambda). This function can, alternatively, be used to define the zero point of the Johnson V magnitude scale by imposing the requirement that, for any stellar photon flux density N_\lambda (in photons s^-1 m^-2 nm^-1 above the Earth's atmosphere) with V = 0 mag, the integral from 470 to 740 nm (the support interval of the Johnson V band) of N_\lambda times S_V(\lambda) equals N_0 photons s^-1 m^-2. The function S_V(\lambda) and the normalisation constant N_0 depend on the value of Planck's constant (parameter :Nature:Planck_Constant), on the definition of the shape of the Johnson V band (parameter :Nature:FilterTransmissionCurve_JohnsonCousinsV_002), on the monochromatic calibration flux f_{0\lambda} (or f_{0\nu}; parameters :Nature:A0VStar_CalibrationFlux_Lambda and :Nature:A0VStar_CalibrationFlux_Nu) at \lambda_0 (parameter :Nature:A0VStar_CalibrationWavelength), and on the spectrum f_{0\nu}(\lambda) of the general unreddened A0V star (parameter :Nature:A0VStar_Spectrum_Nu_002). First column: wavelength \lambda (in nm; from 470.0 to 740.0). Second column: S_V(\lambda)    
     * <p>
     * Source: J.H.J. de Bruijne, 26 May 2003, 'Stellar fluxes: transformations and calibrations', GAIA-JdB-005, issue 1, revision 1, Appendix D<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: false
     */
    @ParamMetaData (
    description = "Calibration function S_V(\\lambda). This function can, alternatively, be used to define the zero point of the Johnson V magnitude scale by imposing the requirement that, for any stellar photon flux density N_\\lambda (in photons s^-1 m^-2 nm^-1 above the Earth's atmosphere) with V = 0 mag, the integral from 470 to 740 nm (the support interval of the Johnson V band) of N_\\lambda times S_V(\\lambda) equals N_0 photons s^-1 m^-2. The function S_V(\\lambda) and the normalisation constant N_0 depend on the value of Planck's constant (parameter :Nature:Planck_Constant), on the definition of the shape of the Johnson V band (parameter :Nature:FilterTransmissionCurve_JohnsonCousinsV_002), on the monochromatic calibration flux f_{0\\lambda} (or f_{0\\nu}; parameters :Nature:A0VStar_CalibrationFlux_Lambda and :Nature:A0VStar_CalibrationFlux_Nu) at \\lambda_0 (parameter :Nature:A0VStar_CalibrationWavelength), and on the spectrum f_{0\\nu}(\\lambda) of the general unreddened A0V star (parameter :Nature:A0VStar_Spectrum_Nu_002). First column: wavelength \\lambda (in nm; from 470.0 to 740.0). Second column: S_V(\\lambda)", 
     source = "J.H.J. de Bruijne, 26 May 2003, 'Stellar fluxes: transformations and calibrations', GAIA-JdB-005, issue 1, revision 1, Appendix D", 
     status = "CONF", 
     basic = true, 
     scalar = false, 
     unit = "") 
    public static final String A0VSTAR_CALIBRATIONFUNCTION; static { A0VSTAR_CALIBRATIONFUNCTION = "Nature/A0VStar_CalibrationFunction_002.fits"; } 

    /**
     * Spectrum f_{0\nu}(\lambda) of an unreddened A0V star: high-fidelity, Kurucz-model Vega spectrum (R = 500) with T_eff = 9400 K, log g = 3.90 dex, and [M/H] = -0.5 dex. The Kurucz model has been scaled to fit STIS data (over the interval 554.5-557.0 nm) by a factor 0.994242. First column: wavelength \lambda (in nm; from 115.0 to 1062.0). Second column: Eddington flux (in W m^-2 Hz^-1 steradian^-1). Note that the flux at 115.0 nm was obtained using linear interpolation between the available fluxes at 114.9721 and 115.0873 nm (2.521153898563741E-008 and 2.420265114233843E-008, respectively). Note that the flux at 1062.0 nm was obtained using linear interpolation between the available fluxes at 1061.1654 and 1062.2293 nm (2.508019694385564E-005 and 2.504881789424158E-005, respectively)    
     * <p>
     * Source: R.C. Bohlin, 2014, 'Hubble Space Telescope CALSPEC Flux Standards: Sirius (and Vega)', Astronomical Journal, Volume 147, 127; spectrum named alpha_lyr_mod_002.fits contained in CALSPEC Calibration Database (http://www.stsci.edu/hst/observatory/crds/calspec.html, last modified April 2015)<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: false
     */
    @ParamMetaData (
    description = "Spectrum f_{0\\nu}(\\lambda) of an unreddened A0V star: high-fidelity, Kurucz-model Vega spectrum (R = 500) with T_eff = 9400 K, log g = 3.90 dex, and [M/H] = -0.5 dex. The Kurucz model has been scaled to fit STIS data (over the interval 554.5-557.0 nm) by a factor 0.994242. First column: wavelength \\lambda (in nm; from 115.0 to 1062.0). Second column: Eddington flux (in W m^-2 Hz^-1 steradian^-1). Note that the flux at 115.0 nm was obtained using linear interpolation between the available fluxes at 114.9721 and 115.0873 nm (2.521153898563741E-008 and 2.420265114233843E-008, respectively). Note that the flux at 1062.0 nm was obtained using linear interpolation between the available fluxes at 1061.1654 and 1062.2293 nm (2.508019694385564E-005 and 2.504881789424158E-005, respectively)", 
     source = "R.C. Bohlin, 2014, 'Hubble Space Telescope CALSPEC Flux Standards: Sirius (and Vega)', Astronomical Journal, Volume 147, 127; spectrum named alpha_lyr_mod_002.fits contained in CALSPEC Calibration Database (http://www.stsci.edu/hst/observatory/crds/calspec.html, last modified April 2015)", 
     status = "CONF", 
     basic = true, 
     scalar = false, 
     unit = "") 
    public static final String A0VSTAR_SPECTRUM_NU; static { A0VSTAR_SPECTRUM_NU = "Nature/A0VStar_Spectrum_Nu_002.fits"; } 

    /**
     * Photon flux density N_{\lambda}(\lambda) of an unreddened A0V star (Pickles' star number 009) at V = 0 mag. Note that this unreddened A0V star refers to Pickles' star number 009, and not to the Kurucz Vega spectrum which has been used for flux normalisation and zero-point definition. First column: wavelength \lambda (in nm; from 115.0 to 1062.0). Second column: photon flux density above the Earth's atmosphere (in photons m^-2 s^-1 nm^-1; the photometric zero point is described in J.H.J. de Bruijne, 26 May 2003, 'Stellar fluxes: transformations and calibrations', GAIA-JdB-005, issue 1, revision 1)    
     * <p>
     * Source: A.J. Pickles, 1998, 'A stellar spectral flux library: 1150-25000 AA', PASP, 110, 863<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: false
     */
    @ParamMetaData (
    description = "Photon flux density N_{\\lambda}(\\lambda) of an unreddened A0V star (Pickles' star number 009) at V = 0 mag. Note that this unreddened A0V star refers to Pickles' star number 009, and not to the Kurucz Vega spectrum which has been used for flux normalisation and zero-point definition. First column: wavelength \\lambda (in nm; from 115.0 to 1062.0). Second column: photon flux density above the Earth's atmosphere (in photons m^-2 s^-1 nm^-1; the photometric zero point is described in J.H.J. de Bruijne, 26 May 2003, 'Stellar fluxes: transformations and calibrations', GAIA-JdB-005, issue 1, revision 1)", 
     source = "A.J. Pickles, 1998, 'A stellar spectral flux library: 1150-25000 AA', PASP, 110, 863", 
     status = "CONF", 
     basic = true, 
     scalar = false, 
     unit = "") 
    public static final String A0VSTAR_SPECTRUM_NUMBEROFPHOTONS; static { A0VSTAR_SPECTRUM_NUMBEROFPHOTONS = "Nature/A0VStar_Spectrum_NumberOfPhotons_001.fits"; } 

    /**
     * Reference wavelength at which the flux f_{0\lambda} of an unreddened A0V star is calibrated (see also J.H.J. de Bruijne, 26 May 2003, 'Stellar fluxes: transformations and calibrations', GAIA-JdB-005, issue 1, revision 1)    
     * <p>
     * Source: V. Straizys, 1992, 'Multicolor stellar photometry', Pachart Publ. House (Tucson), Table 21<br/>
     * Status: CONF<br/>
     * Unit: nm<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Reference wavelength at which the flux f_{0\\lambda} of an unreddened A0V star is calibrated (see also J.H.J. de Bruijne, 26 May 2003, 'Stellar fluxes: transformations and calibrations', GAIA-JdB-005, issue 1, revision 1)", 
     source = "V. Straizys, 1992, 'Multicolor stellar photometry', Pachart Publ. House (Tucson), Table 21", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "nm") 
    public static final double A0VSTAR_CALIBRATIONWAVELENGTH; static { A0VSTAR_CALIBRATIONWAVELENGTH = 550.0; } // [nm] 

    /**
     * Johnson V minus Gaia G (V-G) magnitude of an unreddened A0V star, applicable to any photometric band G    
     * <p>
     * Source: Definition of Gaia G band(s)<br/>
     * Status: CONF<br/>
     * Unit: mag<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Johnson V minus Gaia G (V-G) magnitude of an unreddened A0V star, applicable to any photometric band G", 
     source = "Definition of Gaia G band(s)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "mag") 
    public static final double A0VSTAR_VMING; static { A0VSTAR_VMING = 0.000; } // [mag] 

    /**
     * Johnson V minus Cousins R (V-R) magnitude of an unreddened A0V star    
     * <p>
     * Source: M.S. Bessell, S. Murphy, 2012, 'Spectrophotometric Libraries, Revised Photonic Passbands, and Zero Points for UBVRI, Hipparcos, and Tycho Photometry', PASP, 124, 140<br/>
     * Status: CONF<br/>
     * Unit: mag<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Johnson V minus Cousins R (V-R) magnitude of an unreddened A0V star", 
     source = "M.S. Bessell, S. Murphy, 2012, 'Spectrophotometric Libraries, Revised Photonic Passbands, and Zero Points for UBVRI, Hipparcos, and Tycho Photometry', PASP, 124, 140", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "mag") 
    public static final double A0VSTAR_VMINR; static { A0VSTAR_VMINR = 0.000; } // [mag] 

    /**
     * Johnson V minus Cousins I (V-I) magnitude of an unreddened A0V star    
     * <p>
     * Source: M.S. Bessell, S. Murphy, 2012, 'Spectrophotometric Libraries, Revised Photonic Passbands, and Zero Points for UBVRI, Hipparcos, and Tycho Photometry', PASP, 124, 140<br/>
     * Status: CONF<br/>
     * Unit: mag<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Johnson V minus Cousins I (V-I) magnitude of an unreddened A0V star", 
     source = "M.S. Bessell, S. Murphy, 2012, 'Spectrophotometric Libraries, Revised Photonic Passbands, and Zero Points for UBVRI, Hipparcos, and Tycho Photometry', PASP, 124, 140", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "mag") 
    public static final double A0VSTAR_VMINI; static { A0VSTAR_VMINI = -0.001; } // [mag] 

    /**
     * Johnson B minus V (B-V) magnitude of an unreddened A0V star    
     * <p>
     * Source: M.S. Bessell, S. Murphy, 2012, 'Spectrophotometric Libraries, Revised Photonic Passbands, and Zero Points for UBVRI, Hipparcos, and Tycho Photometry', PASP, 124, 140<br/>
     * Status: CONF<br/>
     * Unit: mag<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Johnson B minus V (B-V) magnitude of an unreddened A0V star", 
     source = "M.S. Bessell, S. Murphy, 2012, 'Spectrophotometric Libraries, Revised Photonic Passbands, and Zero Points for UBVRI, Hipparcos, and Tycho Photometry', PASP, 124, 140", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "mag") 
    public static final double A0VSTAR_BMINV; static { A0VSTAR_BMINV = -0.004; } // [mag] 

    /**
     * Cousins R minus I (R-I) magnitude of an unreddened A0V star    
     * <p>
     * Status: CONF<br/>
     * Unit: mag<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Cousins R minus I (R-I) magnitude of an unreddened A0V star", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "mag") 
    public static final double A0VSTAR_RMINI; static { A0VSTAR_RMINI = -0.001; } // [mag] 

    /**
     * Johnson V magnitude of Vega    
     * <p>
     * Source: R.C. Bohlin, 2007, 'HST Stellar Standards with 1\% Accuracy in Absolute Flux', in 'The Future of Photometric, Spectrophotometric and Polarimetric Standardization', ASP Conference Series, Vol. 364, p.315; see also CALSPEC Calibration Database, http://www.stsci.edu/hst/observatory/crds/calspec.html, last modified April 2015<br/>
     * Status: CONF<br/>
     * Unit: mag<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Johnson V magnitude of Vega", 
     source = "R.C. Bohlin, 2007, 'HST Stellar Standards with 1\\% Accuracy in Absolute Flux', in 'The Future of Photometric, Spectrophotometric and Polarimetric Standardization', ASP Conference Series, Vol. 364, p.315; see also CALSPEC Calibration Database, http://www.stsci.edu/hst/observatory/crds/calspec.html, last modified April 2015", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "mag") 
    public static final double A0VSTAR_VMAGNITUDE; static { A0VSTAR_VMAGNITUDE = 0.023; } // [mag] 

    /**
     * Weighted mean flux \langle f_{\nu} \rangle over the Johnson V passband (parameter :Nature:FilterTransmissionCurve_JohnsonCousinsV_002) of an unreddened A0V star (parameter :Nature:A0VStar_Spectrum) with V = :Nature:A0VStar_VMagnitude mag    
     * <p>
     * Source: P. Montegriffo, 26 January 2016, 'External calibration for Gaia DR1 integrated photometry', GAIA-C5-TN-OABO-PMN-009, issue 1, revision 0, depends on parameters :Nature:A0VStar_Spectrum and :Nature:FilterTransmissionCurve_JohnsonCousinsV_002<br/>
     * Status: CONF<br/>
     * Unit: W m^-2 Hz^-1<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Weighted mean flux \\langle f_{\\nu} \\rangle over the Johnson V passband (parameter :Nature:FilterTransmissionCurve_JohnsonCousinsV_002) of an unreddened A0V star (parameter :Nature:A0VStar_Spectrum) with V = :Nature:A0VStar_VMagnitude mag", 
     source = "P. Montegriffo, 26 January 2016, 'External calibration for Gaia DR1 integrated photometry', GAIA-C5-TN-OABO-PMN-009, issue 1, revision 0, depends on parameters :Nature:A0VStar_Spectrum and :Nature:FilterTransmissionCurve_JohnsonCousinsV_002", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "W m^-2 Hz^-1") 
    public static final double A0VSTAR_MEANFLUX_NU; static { A0VSTAR_MEANFLUX_NU = 3.58600e-23; } // [W m^-2 Hz^-1] 

    /**
     * Flux f_{0\nu} of an unreddened A0V star with V = 0 mag at the wavelength \lambda_0 (see also J.H.J. de Bruijne, 26 May 2003, 'Stellar fluxes: transformations and calibrations', GAIA-JdB-005, issue 1, revision 1 and R.C. Bohlin, 2014, 'Hubble Space Telescope CALSPEC Flux Standards: Sirius (and Vega)', Astronomical Journal, Volume 147, 127; spectrum named alpha_lyr_mod_002.fits contained in CALSPEC Calibration Database, http://www.stsci.edu/hst/observatory/crds/calspec.html, last modified April 2015)    
     * <p>
     * Source: P. Montegriffo, 26 January 2016, 'External calibration for Gaia DR1 integrated photometry', GAIA-C5-TN-OABO-PMN-009, issue 1, revision 0, depends on parameters :Nature:A0VStar_Spectrum, :Nature:Planck_Constant, :Nature:FilterTransmissionCurve_JohnsonCousinsV_002, and :Nature:A0VStar_VMagnitude<br/>
     * Status: CONF<br/>
     * Unit: W m^-2 Hz^-1<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Flux f_{0\\nu} of an unreddened A0V star with V = 0 mag at the wavelength \\lambda_0 (see also J.H.J. de Bruijne, 26 May 2003, 'Stellar fluxes: transformations and calibrations', GAIA-JdB-005, issue 1, revision 1 and R.C. Bohlin, 2014, 'Hubble Space Telescope CALSPEC Flux Standards: Sirius (and Vega)', Astronomical Journal, Volume 147, 127; spectrum named alpha_lyr_mod_002.fits contained in CALSPEC Calibration Database, http://www.stsci.edu/hst/observatory/crds/calspec.html, last modified April 2015)", 
     source = "P. Montegriffo, 26 January 2016, 'External calibration for Gaia DR1 integrated photometry', GAIA-C5-TN-OABO-PMN-009, issue 1, revision 0, depends on parameters :Nature:A0VStar_Spectrum, :Nature:Planck_Constant, :Nature:FilterTransmissionCurve_JohnsonCousinsV_002, and :Nature:A0VStar_VMagnitude", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "W m^-2 Hz^-1") 
    public static final double A0VSTAR_CALIBRATIONFLUX_NU; static { A0VSTAR_CALIBRATIONFLUX_NU = 3.65558e-23; } // [W m^-2 Hz^-1] 

    /**
     * Flux f_{0\lambda} f an unreddened A0V star with V = 0 mag at the wavelength \lambda_0    
     * <p>
     * Status: CONF<br/>
     * Unit: W m^-2 nm^-1<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Flux f_{0\\lambda} f an unreddened A0V star with V = 0 mag at the wavelength \\lambda_0", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "W m^-2 nm^-1") 
    public static final double A0VSTAR_CALIBRATIONFLUX_LAMBDA; static { A0VSTAR_CALIBRATIONFLUX_LAMBDA = 3.62286e-11; } // [W m^-2 nm^-1] 

    /**
     * Photon flux N_{0\lambda}(\lambda_0) of an unreddened A0V star with V = 0 mag at the wavelength \lambda_0 (see also J.H.J. de Bruijne, 26 May 2003, 'Stellar fluxes: transformations and calibrations', GAIA-JdB-005, issue 1, revision 1). Note that the parameter A0VStar_Spectrum_NumberOfPhotons refers to Pickles' star number 009, and not to the Kurucz Vega spectrum which has been used for flux normalisation/calibration and zero-point definition; the parameter A0VStar_Spectrum_NumberOfPhotons therefore does not precisely have A0VStar_CalibrationFlux photons s^-1 m^-2 nm^-1 at \lambda_0 = A0VStar_CalibrationWavelength    
     * <p>
     * Status: CONF<br/>
     * Unit: photons s^-1 m^-2 nm^-1<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Photon flux N_{0\\lambda}(\\lambda_0) of an unreddened A0V star with V = 0 mag at the wavelength \\lambda_0 (see also J.H.J. de Bruijne, 26 May 2003, 'Stellar fluxes: transformations and calibrations', GAIA-JdB-005, issue 1, revision 1). Note that the parameter A0VStar_Spectrum_NumberOfPhotons refers to Pickles' star number 009, and not to the Kurucz Vega spectrum which has been used for flux normalisation/calibration and zero-point definition; the parameter A0VStar_Spectrum_NumberOfPhotons therefore does not precisely have A0VStar_CalibrationFlux photons s^-1 m^-2 nm^-1 at \\lambda_0 = A0VStar_CalibrationWavelength", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "photons s^-1 m^-2 nm^-1") 
    public static final double A0VSTAR_CALIBRATIONFLUX_NUMBEROFPHOTONS; static { A0VSTAR_CALIBRATIONFLUX_NUMBEROFPHOTONS = 100308492.2552; } // [photons s^-1 m^-2 nm^-1] 

    /**
     * Calibration (function) normalisation constant N_0. This constant can be used to define the zero point of the Johnson V magnitude scale by imposing the requirement that, for any stellar photon flux density N_\lambda (in photons s^-1 m^-2 nm^-1 above the Earth's atmosphere) with V = 0 mag, the integral from 470 to 740 nm (the support interval of the Johnson V band) of N_\lambda times S_V(\lambda) equals N_0 photons s^-1 m^-2. The function S_V(\lambda) and the normalisation constant N_0 depend on the value of Planck's constant (parameter :Nature:Planck_Constant), on the definition of the shape of the Johnson V band (parameter :Nature:FilterTransmissionCurve_JohnsonCousinsV_002), on the monochromatic calibration flux f_{0\lambda} (or f_{0\nu}; parameters :Nature:A0VStar_CalibrationFlux_Lambda and :Nature:A0VStar_CalibrationFlux_Nu) at \lambda_0 (parameter :Nature:A0VStar_CalibrationWavelength), and on the spectrum f_{0\nu}(\lambda) of the general unreddened A0V star (parameter :Nature:A0VStar_Spectrum_Nu_002)    
     * <p>
     * Source: J.H.J. de Bruijne, 26 May 2003, 'Stellar fluxes: transformations and calibrations', GAIA-JdB-005, issue 1, revision 1, Appendix D<br/>
     * Status: CONF<br/>
     * Unit: photons s^-1 m^-2<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Calibration (function) normalisation constant N_0. This constant can be used to define the zero point of the Johnson V magnitude scale by imposing the requirement that, for any stellar photon flux density N_\\lambda (in photons s^-1 m^-2 nm^-1 above the Earth's atmosphere) with V = 0 mag, the integral from 470 to 740 nm (the support interval of the Johnson V band) of N_\\lambda times S_V(\\lambda) equals N_0 photons s^-1 m^-2. The function S_V(\\lambda) and the normalisation constant N_0 depend on the value of Planck's constant (parameter :Nature:Planck_Constant), on the definition of the shape of the Johnson V band (parameter :Nature:FilterTransmissionCurve_JohnsonCousinsV_002), on the monochromatic calibration flux f_{0\\lambda} (or f_{0\\nu}; parameters :Nature:A0VStar_CalibrationFlux_Lambda and :Nature:A0VStar_CalibrationFlux_Nu) at \\lambda_0 (parameter :Nature:A0VStar_CalibrationWavelength), and on the spectrum f_{0\\nu}(\\lambda) of the general unreddened A0V star (parameter :Nature:A0VStar_Spectrum_Nu_002)", 
     source = "J.H.J. de Bruijne, 26 May 2003, 'Stellar fluxes: transformations and calibrations', GAIA-JdB-005, issue 1, revision 1, Appendix D", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "photons s^-1 m^-2") 
    public static final double A0VSTAR_CALIBRATIONFUNCTION_NORMALISATION; static { A0VSTAR_CALIBRATIONFUNCTION_NORMALISATION = 8630065822.2737; } // [photons s^-1 m^-2] 

    /**
     * Photon flux density N_{\lambda}(\lambda) of an unreddened A3V star (Pickles' star number 011) at V = 0 mag. First column: wavelength \lambda (in nm; from 115.0 to 1062.0). Second column: photon flux density above the Earth's atmosphere (in photons m^-2 s^-1 nm^-1; the photometric zero point is described in J.H.J. de Bruijne, 26 May 2003, 'Stellar fluxes: transformations and calibrations', GAIA-JdB-005, issue 1, revision 1)    
     * <p>
     * Source: A.J. Pickles, 1998, 'A stellar spectral flux library: 1150-25000 AA', PASP, 110, 863<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: false
     */
    @ParamMetaData (
    description = "Photon flux density N_{\\lambda}(\\lambda) of an unreddened A3V star (Pickles' star number 011) at V = 0 mag. First column: wavelength \\lambda (in nm; from 115.0 to 1062.0). Second column: photon flux density above the Earth's atmosphere (in photons m^-2 s^-1 nm^-1; the photometric zero point is described in J.H.J. de Bruijne, 26 May 2003, 'Stellar fluxes: transformations and calibrations', GAIA-JdB-005, issue 1, revision 1)", 
     source = "A.J. Pickles, 1998, 'A stellar spectral flux library: 1150-25000 AA', PASP, 110, 863", 
     status = "CONF", 
     basic = true, 
     scalar = false, 
     unit = "") 
    public static final String A3VSTAR_SPECTRUM_NUMBEROFPHOTONS; static { A3VSTAR_SPECTRUM_NUMBEROFPHOTONS = "Nature/A3VStar_Spectrum_NumberOfPhotons_001.fits"; } 

    /**
     * Photon flux density N_{\lambda}(\lambda) of an unreddened A5V star (Pickles' star number 012) at V = 0 mag. First column: wavelength \lambda (in nm; from 115.0 to 1062.0). Second column: photon flux density above the Earth's atmosphere (in photons m^-2 s^-1 nm^-1; the photometric zero point is described in J.H.J. de Bruijne, 26 May 2003, 'Stellar fluxes: transformations and calibrations', GAIA-JdB-005, issue 1, revision 1)    
     * <p>
     * Source: A.J. Pickles, 1998, 'A stellar spectral flux library: 1150-25000 AA', PASP, 110, 863<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: false
     */
    @ParamMetaData (
    description = "Photon flux density N_{\\lambda}(\\lambda) of an unreddened A5V star (Pickles' star number 012) at V = 0 mag. First column: wavelength \\lambda (in nm; from 115.0 to 1062.0). Second column: photon flux density above the Earth's atmosphere (in photons m^-2 s^-1 nm^-1; the photometric zero point is described in J.H.J. de Bruijne, 26 May 2003, 'Stellar fluxes: transformations and calibrations', GAIA-JdB-005, issue 1, revision 1)", 
     source = "A.J. Pickles, 1998, 'A stellar spectral flux library: 1150-25000 AA', PASP, 110, 863", 
     status = "CONF", 
     basic = true, 
     scalar = false, 
     unit = "") 
    public static final String A5VSTAR_SPECTRUM_NUMBEROFPHOTONS; static { A5VSTAR_SPECTRUM_NUMBEROFPHOTONS = "Nature/A5VStar_Spectrum_NumberOfPhotons_001.fits"; } 

    /**
     * Constant of aberration, nowadays irrelevant as a fundamental constant, at the standard epoch J2000.0. The IAU (1976) System of Astronomical Constants (e.g., T. Lederle, 1980, MitAG, 48, 59, Table 1) lists 20.49552 arcsec    
     * <p>
     * Source: P.K. Seidelmann, 1992, 'Explanatory Supplement to the Astronomical Almanac', University Science Books, Mill Valley, Ca., ISBN 0-935702-68-7, Equation 3.253-4, page 131<br/>
     * Status: CONF<br/>
     * Unit: arcsec<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Constant of aberration, nowadays irrelevant as a fundamental constant, at the standard epoch J2000.0. The IAU (1976) System of Astronomical Constants (e.g., T. Lederle, 1980, MitAG, 48, 59, Table 1) lists 20.49552 arcsec", 
     source = "P.K. Seidelmann, 1992, 'Explanatory Supplement to the Astronomical Almanac', University Science Books, Mill Valley, Ca., ISBN 0-935702-68-7, Equation 3.253-4, page 131", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "arcsec") 
    public static final double ABERRATION_CONSTANT_J2000; static { ABERRATION_CONSTANT_J2000 = 20.49122; } // [arcsec] 

    /**
     * One Angstrom expressed in units of nm. Note that 'Angstrom' is a non-SI unit which should not be used    
     * <p>
     * Status: CONF<br/>
     * Unit: nm<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "One Angstrom expressed in units of nm. Note that 'Angstrom' is a non-SI unit which should not be used", 
     source = "", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "nm") 
    public static final double ANGSTROM_NANOMETER; static { ANGSTROM_NANOMETER = 0.1; } // [nm] 

    /**
     * One arcsecond in units of radians    
     * <p>
     * Status: CONF<br/>
     * Unit: rad<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "One arcsecond in units of radians", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "rad") 
    public static final double ARCSECOND_RADIAN; static { ARCSECOND_RADIAN = 4.848136811095360e-6; } // [rad] 

    /**
     * The velocity distribution of main-belt asteroids (MBOs) is very roughly Gaussian with zero mean and a standard deviation of 7.0 mas s^-1 along-scan (for a solar-aspect angle of 45 degrees)    
     * <p>
     * Source: F. Mignard, 2002, 'Observations of solar-system objects with Gaia. I. Detection of NEOs', A&A, 393, 727, Section 4.4 (2002A&A...393..727M). See also E. Hoeg, F. Arenou, P. Hjorth, U.G. Joergensen, F. Mignard, S. Wolff, 28 February 2003, 'Faint objects and NEOs with Gaia', GAIA-CUO-118, issue 1, revision 0 and F. Mignard, 22 June 2001, 'Observation of main-belt asteroids with Gaia', GAIA-FM-009, issue 1, revision 0. Current value, for a solar-aspect angle of 45 degrees, from F. Mignard, priv. comm., 10 August 2005<br/>
     * Status: CONF<br/>
     * Unit: mas s^-1<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "The velocity distribution of main-belt asteroids (MBOs) is very roughly Gaussian with zero mean and a standard deviation of 7.0 mas s^-1 along-scan (for a solar-aspect angle of 45 degrees)", 
     source = "F. Mignard, 2002, 'Observations of solar-system objects with Gaia. I. Detection of NEOs', A&A, 393, 727, Section 4.4 (2002A&A...393..727M). See also E. Hoeg, F. Arenou, P. Hjorth, U.G. Joergensen, F. Mignard, S. Wolff, 28 February 2003, 'Faint objects and NEOs with Gaia', GAIA-CUO-118, issue 1, revision 0 and F. Mignard, 22 June 2001, 'Observation of main-belt asteroids with Gaia', GAIA-FM-009, issue 1, revision 0. Current value, for a solar-aspect angle of 45 degrees, from F. Mignard, priv. comm., 10 August 2005", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "mas s^-1") 
    public static final double ASTEROID_VELOCITYDISTRIBUTIONSTANDARDDEVIATION_AL; static { ASTEROID_VELOCITYDISTRIBUTIONSTANDARDDEVIATION_AL = 7.0; } // [mas s^-1] 

    /**
     * The velocity distribution of main-belt asteroids (MBOs) is very roughly Gaussian with zero mean and a standard deviation of 13.0 mas s^-1 across-scan (for a solar-aspect angle of 45 degrees)    
     * <p>
     * Source: F. Mignard, 2002, 'Observations of solar-system objects with Gaia. I. Detection of NEOs', A&A, 393, 727, Section 4.4 (2002A&A...393..727M). See also E. Hoeg, F. Arenou, P. Hjorth, U.G. Joergensen, F. Mignard, S. Wolff, 28 February 2003, 'Faint objects and NEOs with Gaia', GAIA-CUO-118, issue 1, revision 0 and F. Mignard, 22 June 2001, 'Observation of main-belt asteroids with Gaia', GAIA-FM-009, issue 1, revision 0. Current value, for a solar-aspect angle of 45 degrees, from F. Mignard, priv. comm., 10 August 2005<br/>
     * Status: CONF<br/>
     * Unit: mas s^-1<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "The velocity distribution of main-belt asteroids (MBOs) is very roughly Gaussian with zero mean and a standard deviation of 13.0 mas s^-1 across-scan (for a solar-aspect angle of 45 degrees)", 
     source = "F. Mignard, 2002, 'Observations of solar-system objects with Gaia. I. Detection of NEOs', A&A, 393, 727, Section 4.4 (2002A&A...393..727M). See also E. Hoeg, F. Arenou, P. Hjorth, U.G. Joergensen, F. Mignard, S. Wolff, 28 February 2003, 'Faint objects and NEOs with Gaia', GAIA-CUO-118, issue 1, revision 0 and F. Mignard, 22 June 2001, 'Observation of main-belt asteroids with Gaia', GAIA-FM-009, issue 1, revision 0. Current value, for a solar-aspect angle of 45 degrees, from F. Mignard, priv. comm., 10 August 2005", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "mas s^-1") 
    public static final double ASTEROID_VELOCITYDISTRIBUTIONSTANDARDDEVIATION_AC; static { ASTEROID_VELOCITYDISTRIBUTIONSTANDARDDEVIATION_AC = 13.0; } // [mas s^-1] 

    /**
     * Post-Newtonian deflection angle of a limb-grazing light ray due to the spherically symmetric part of the gravitational field of 1 Ceres    
     * <p>
     * Source: S.A. Klioner, 2003, 'A Practical Relativistic Model for Microarcsecond Astrometry in Space', AJ, 125, 1580, Equation 64 with cot(x) = cos(x) / sin(x) approximated by x^-1; see also J.H.J. de Bruijne, 19 February 2002, 'Gravitational light deflection', GAIA-JdB-001, issue 1, revision 0<br/>
     * Status: CONF<br/>
     * Unit: 10^-6 arcsec<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Post-Newtonian deflection angle of a limb-grazing light ray due to the spherically symmetric part of the gravitational field of 1 Ceres", 
     source = "S.A. Klioner, 2003, 'A Practical Relativistic Model for Microarcsecond Astrometry in Space', AJ, 125, 1580, Equation 64 with cot(x) = cos(x) / sin(x) approximated by x^-1; see also J.H.J. de Bruijne, 19 February 2002, 'Gravitational light deflection', GAIA-JdB-001, issue 1, revision 0", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "10^-6 arcsec") 
    public static final double ASTEROID1CERES_LIGHTDEFLECTION_LIMB; static { ASTEROID1CERES_LIGHTDEFLECTION_LIMB = 1.; } // [10^-6 arcsec] 

    /**
     * Diameter of 1 Ceres    
     * <p>
     * Source: C.F. Yoder, 1995, 'Astrometric and Geodetic Properties of Earth and the solar System', in 'Global Earth Physics; A Handbook of Physical Constants', AGU Reference Shelf 1, American Geophysical Union, Table 15 'Prominent minor planets or asteroids' (http://www.agu.org/books/rf/v001/RF001p0001/RF001p0001.pdf)<br/>
     * Status: CONF<br/>
     * Unit: km<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Diameter of 1 Ceres", 
     source = "C.F. Yoder, 1995, 'Astrometric and Geodetic Properties of Earth and the solar System', in 'Global Earth Physics; A Handbook of Physical Constants', AGU Reference Shelf 1, American Geophysical Union, Table 15 'Prominent minor planets or asteroids' (http://www.agu.org/books/rf/v001/RF001p0001/RF001p0001.pdf)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "km") 
    public static final double ASTEROID1CERES_DIAMETER; static { ASTEROID1CERES_DIAMETER = 933.; } // [km] 

    /**
     * Orbital semi-major axis of 1 Ceres (epoch 1 October 1989). The orbital elements are referenced to the B1950 equinox and ecliptic    
     * <p>
     * Source: C.F. Yoder, 1995, 'Astrometric and Geodetic Properties of Earth and the solar System', in 'Global Earth Physics; A Handbook of Physical Constants', AGU Reference Shelf 1, American Geophysical Union, Table 15 'Prominent minor planets or asteroids' (http://www.agu.org/books/rf/v001/RF001p0001/RF001p0001.pdf)<br/>
     * Status: CONF<br/>
     * Unit: au<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Orbital semi-major axis of 1 Ceres (epoch 1 October 1989). The orbital elements are referenced to the B1950 equinox and ecliptic", 
     source = "C.F. Yoder, 1995, 'Astrometric and Geodetic Properties of Earth and the solar System', in 'Global Earth Physics; A Handbook of Physical Constants', AGU Reference Shelf 1, American Geophysical Union, Table 15 'Prominent minor planets or asteroids' (http://www.agu.org/books/rf/v001/RF001p0001/RF001p0001.pdf)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "au") 
    public static final double ASTEROID1CERES_ORBITALSEMIMAJORAXIS_B1950; static { ASTEROID1CERES_ORBITALSEMIMAJORAXIS_B1950 = 2.769; } // [au] 

    /**
     * Orbital eccentricity of 1 Ceres (epoch 1 October 1989). The orbital elements are referenced to the B1950 equinox and ecliptic    
     * <p>
     * Source: C.F. Yoder, 1995, 'Astrometric and Geodetic Properties of Earth and the solar System', in 'Global Earth Physics; A Handbook of Physical Constants', AGU Reference Shelf 1, American Geophysical Union, Table 15 'Prominent minor planets or asteroids' (http://www.agu.org/books/rf/v001/RF001p0001/RF001p0001.pdf)<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Orbital eccentricity of 1 Ceres (epoch 1 October 1989). The orbital elements are referenced to the B1950 equinox and ecliptic", 
     source = "C.F. Yoder, 1995, 'Astrometric and Geodetic Properties of Earth and the solar System', in 'Global Earth Physics; A Handbook of Physical Constants', AGU Reference Shelf 1, American Geophysical Union, Table 15 'Prominent minor planets or asteroids' (http://www.agu.org/books/rf/v001/RF001p0001/RF001p0001.pdf)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double ASTEROID1CERES_ORBITALECCENTRICITY_B1950; static { ASTEROID1CERES_ORBITALECCENTRICITY_B1950 = 0.0780; } 

    /**
     * Orbital period of 1 Ceres (epoch 1 October 1989). The orbital elements are referenced to the B1950 equinox and ecliptic    
     * <p>
     * Source: C.F. Yoder, 1995, 'Astrometric and Geodetic Properties of Earth and the solar System', in 'Global Earth Physics; A Handbook of Physical Constants', AGU Reference Shelf 1, American Geophysical Union, Table 15 'Prominent minor planets or asteroids' (http://www.agu.org/books/rf/v001/RF001p0001/RF001p0001.pdf)<br/>
     * Status: CONF<br/>
     * Unit: yr<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Orbital period of 1 Ceres (epoch 1 October 1989). The orbital elements are referenced to the B1950 equinox and ecliptic", 
     source = "C.F. Yoder, 1995, 'Astrometric and Geodetic Properties of Earth and the solar System', in 'Global Earth Physics; A Handbook of Physical Constants', AGU Reference Shelf 1, American Geophysical Union, Table 15 'Prominent minor planets or asteroids' (http://www.agu.org/books/rf/v001/RF001p0001/RF001p0001.pdf)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "yr") 
    public static final double ASTEROID1CERES_ORBITALPERIOD_B1950; static { ASTEROID1CERES_ORBITALPERIOD_B1950 = 4.607; } // [yr] 

    /**
     * Perihelion distance of 1 Ceres (epoch 1 October 1989). The orbital elements are referenced to the B1950 equinox and ecliptic    
     * <p>
     * Status: CONF<br/>
     * Unit: au<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Perihelion distance of 1 Ceres (epoch 1 October 1989). The orbital elements are referenced to the B1950 equinox and ecliptic", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "au") 
    public static final double ASTEROID1CERES_PERIHELIONDISTANCE_B1950; static { ASTEROID1CERES_PERIHELIONDISTANCE_B1950 = 2.553; } // [au] 

    /**
     * Ratio of 1 Ceres to solar mass (IAU 2009 CBE value)    
     * <p>
     * Source: The IAU (2009) System of Astronomical Constants (IAU, August 2009, 'IAU 2009 Astronomical Constants', IAU 2009 Resolution B2 adopted at the XXVII-th General Assembly of the IAU. See also IAU, 10 August 2009, 'IAU WG on NSFA Current Best Estimates', http://maia.usno.navy.mil/NSFA/NSFA_cbe.html)<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Ratio of 1 Ceres to solar mass (IAU 2009 CBE value)", 
     source = "The IAU (2009) System of Astronomical Constants (IAU, August 2009, 'IAU 2009 Astronomical Constants', IAU 2009 Resolution B2 adopted at the XXVII-th General Assembly of the IAU. See also IAU, 10 August 2009, 'IAU WG on NSFA Current Best Estimates', http://maia.usno.navy.mil/NSFA/NSFA_cbe.html)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double ASTEROID1CERESMASS_SOLARMASS; static { ASTEROID1CERESMASS_SOLARMASS = 4.720e-10; } 

    /**
     * Post-Newtonian deflection angle of a limb-grazing light ray due to the spherically symmetric part of the gravitational field of 2 Pallas    
     * <p>
     * Source: S.A. Klioner, 2003, 'A Practical Relativistic Model for Microarcsecond Astrometry in Space', AJ, 125, 1580, Equation 64 with cot(x) = cos(x) / sin(x) approximated by x^-1; see also J.H.J. de Bruijne, 19 February 2002, 'Gravitational light deflection', GAIA-JdB-001, issue 1, revision 0<br/>
     * Status: CONF<br/>
     * Unit: 10^-6 arcsec<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Post-Newtonian deflection angle of a limb-grazing light ray due to the spherically symmetric part of the gravitational field of 2 Pallas", 
     source = "S.A. Klioner, 2003, 'A Practical Relativistic Model for Microarcsecond Astrometry in Space', AJ, 125, 1580, Equation 64 with cot(x) = cos(x) / sin(x) approximated by x^-1; see also J.H.J. de Bruijne, 19 February 2002, 'Gravitational light deflection', GAIA-JdB-001, issue 1, revision 0", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "10^-6 arcsec") 
    public static final double ASTEROID2PALLAS_LIGHTDEFLECTION_LIMB; static { ASTEROID2PALLAS_LIGHTDEFLECTION_LIMB = 0.; } // [10^-6 arcsec] 

    /**
     * Diameter of 2 Pallas    
     * <p>
     * Source: C.F. Yoder, 1995, 'Astrometric and Geodetic Properties of Earth and the solar System', in 'Global Earth Physics; A Handbook of Physical Constants', AGU Reference Shelf 1, American Geophysical Union, Table 15 'Prominent minor planets or asteroids' (http://www.agu.org/books/rf/v001/RF001p0001/RF001p0001.pdf)<br/>
     * Status: CONF<br/>
     * Unit: km<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Diameter of 2 Pallas", 
     source = "C.F. Yoder, 1995, 'Astrometric and Geodetic Properties of Earth and the solar System', in 'Global Earth Physics; A Handbook of Physical Constants', AGU Reference Shelf 1, American Geophysical Union, Table 15 'Prominent minor planets or asteroids' (http://www.agu.org/books/rf/v001/RF001p0001/RF001p0001.pdf)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "km") 
    public static final double ASTEROID2PALLAS_DIAMETER; static { ASTEROID2PALLAS_DIAMETER = 525.; } // [km] 

    /**
     * Orbital semi-major axis of 2 Pallas (epoch 1 October 1989). The orbital elements are referenced to the B1950 equinox and ecliptic    
     * <p>
     * Source: C.F. Yoder, 1995, 'Astrometric and Geodetic Properties of Earth and the solar System', in 'Global Earth Physics; A Handbook of Physical Constants', AGU Reference Shelf 1, American Geophysical Union, Table 15 'Prominent minor planets or asteroids' (http://www.agu.org/books/rf/v001/RF001p0001/RF001p0001.pdf)<br/>
     * Status: CONF<br/>
     * Unit: au<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Orbital semi-major axis of 2 Pallas (epoch 1 October 1989). The orbital elements are referenced to the B1950 equinox and ecliptic", 
     source = "C.F. Yoder, 1995, 'Astrometric and Geodetic Properties of Earth and the solar System', in 'Global Earth Physics; A Handbook of Physical Constants', AGU Reference Shelf 1, American Geophysical Union, Table 15 'Prominent minor planets or asteroids' (http://www.agu.org/books/rf/v001/RF001p0001/RF001p0001.pdf)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "au") 
    public static final double ASTEROID2PALLAS_ORBITALSEMIMAJORAXIS_B1950; static { ASTEROID2PALLAS_ORBITALSEMIMAJORAXIS_B1950 = 2.770; } // [au] 

    /**
     * Orbital eccentricity of 2 Pallas (epoch 1 October 1989). The orbital elements are referenced to the B1950 equinox and ecliptic    
     * <p>
     * Source: C.F. Yoder, 1995, 'Astrometric and Geodetic Properties of Earth and the solar System', in 'Global Earth Physics; A Handbook of Physical Constants', AGU Reference Shelf 1, American Geophysical Union, Table 15 'Prominent minor planets or asteroids' (http://www.agu.org/books/rf/v001/RF001p0001/RF001p0001.pdf)<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Orbital eccentricity of 2 Pallas (epoch 1 October 1989). The orbital elements are referenced to the B1950 equinox and ecliptic", 
     source = "C.F. Yoder, 1995, 'Astrometric and Geodetic Properties of Earth and the solar System', in 'Global Earth Physics; A Handbook of Physical Constants', AGU Reference Shelf 1, American Geophysical Union, Table 15 'Prominent minor planets or asteroids' (http://www.agu.org/books/rf/v001/RF001p0001/RF001p0001.pdf)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double ASTEROID2PALLAS_ORBITALECCENTRICITY_B1950; static { ASTEROID2PALLAS_ORBITALECCENTRICITY_B1950 = 0.2347; } 

    /**
     * Orbital period of 2 Pallas (epoch 1 October 1989). The orbital elements are referenced to the B1950 equinox and ecliptic    
     * <p>
     * Source: C.F. Yoder, 1995, 'Astrometric and Geodetic Properties of Earth and the solar System', in 'Global Earth Physics; A Handbook of Physical Constants', AGU Reference Shelf 1, American Geophysical Union, Table 15 'Prominent minor planets or asteroids' (http://www.agu.org/books/rf/v001/RF001p0001/RF001p0001.pdf)<br/>
     * Status: CONF<br/>
     * Unit: yr<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Orbital period of 2 Pallas (epoch 1 October 1989). The orbital elements are referenced to the B1950 equinox and ecliptic", 
     source = "C.F. Yoder, 1995, 'Astrometric and Geodetic Properties of Earth and the solar System', in 'Global Earth Physics; A Handbook of Physical Constants', AGU Reference Shelf 1, American Geophysical Union, Table 15 'Prominent minor planets or asteroids' (http://www.agu.org/books/rf/v001/RF001p0001/RF001p0001.pdf)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "yr") 
    public static final double ASTEROID2PALLAS_ORBITALPERIOD_B1950; static { ASTEROID2PALLAS_ORBITALPERIOD_B1950 = 4.611; } // [yr] 

    /**
     * Perihelion distance of 2 Pallas (epoch 1 October 1989). The orbital elements are referenced to the B1950 equinox and ecliptic    
     * <p>
     * Status: CONF<br/>
     * Unit: au<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Perihelion distance of 2 Pallas (epoch 1 October 1989). The orbital elements are referenced to the B1950 equinox and ecliptic", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "au") 
    public static final double ASTEROID2PALLAS_PERIHELIONDISTANCE_B1950; static { ASTEROID2PALLAS_PERIHELIONDISTANCE_B1950 = 2.120; } // [au] 

    /**
     * Ratio of 2 Pallas to solar mass (IAU 2009 CBE value)    
     * <p>
     * Source: The IAU (2009) System of Astronomical Constants (IAU, August 2009, 'IAU 2009 Astronomical Constants', IAU 2009 Resolution B2 adopted at the XXVII-th General Assembly of the IAU. See also IAU, 10 August 2009, 'IAU WG on NSFA Current Best Estimates', http://maia.usno.navy.mil/NSFA/NSFA_cbe.html)<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Ratio of 2 Pallas to solar mass (IAU 2009 CBE value)", 
     source = "The IAU (2009) System of Astronomical Constants (IAU, August 2009, 'IAU 2009 Astronomical Constants', IAU 2009 Resolution B2 adopted at the XXVII-th General Assembly of the IAU. See also IAU, 10 August 2009, 'IAU WG on NSFA Current Best Estimates', http://maia.usno.navy.mil/NSFA/NSFA_cbe.html)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double ASTEROID2PALLASMASS_SOLARMASS; static { ASTEROID2PALLASMASS_SOLARMASS = 1.030e-10; } 

    /**
     * Mass of 3 Juno    
     * <p>
     * Source: Value is calculated following J.L. Hilton, 1999, 'US Naval Observatory Ephemerides of the Largest Asteroids', AJ, 117, 1077, who assumes a mean mass density of 3 g cm^-3. A mass of 2.0E19 kg is found on http://nssdc.gsfc.nasa.gov/planetary/factsheet/asteroidfact.html<br/>
     * Status: CONF<br/>
     * Unit: kg<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mass of 3 Juno", 
     source = "Value is calculated following J.L. Hilton, 1999, 'US Naval Observatory Ephemerides of the Largest Asteroids', AJ, 117, 1077, who assumes a mean mass density of 3 g cm^-3. A mass of 2.0E19 kg is found on http://nssdc.gsfc.nasa.gov/planetary/factsheet/asteroidfact.html", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "kg") 
    public static final double ASTEROID3JUNO_MASS; static { ASTEROID3JUNO_MASS = 2.990e+19; } // [kg] 

    /**
     * Post-Newtonian deflection angle of a limb-grazing light ray due to the spherically symmetric part of the gravitational field of 3 Juno    
     * <p>
     * Source: S.A. Klioner, 2003, 'A Practical Relativistic Model for Microarcsecond Astrometry in Space', AJ, 125, 1580, Equation 64 with cot(x) = cos(x) / sin(x) approximated by x^-1; see also J.H.J. de Bruijne, 19 February 2002, 'Gravitational light deflection', GAIA-JdB-001, issue 1, revision 0<br/>
     * Status: CONF<br/>
     * Unit: 10^-6 arcsec<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Post-Newtonian deflection angle of a limb-grazing light ray due to the spherically symmetric part of the gravitational field of 3 Juno", 
     source = "S.A. Klioner, 2003, 'A Practical Relativistic Model for Microarcsecond Astrometry in Space', AJ, 125, 1580, Equation 64 with cot(x) = cos(x) / sin(x) approximated by x^-1; see also J.H.J. de Bruijne, 19 February 2002, 'Gravitational light deflection', GAIA-JdB-001, issue 1, revision 0", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "10^-6 arcsec") 
    public static final double ASTEROID3JUNO_LIGHTDEFLECTION_LIMB; static { ASTEROID3JUNO_LIGHTDEFLECTION_LIMB = 0.; } // [10^-6 arcsec] 

    /**
     * Diameter of 3 Juno    
     * <p>
     * Source: C.F. Yoder, 1995, 'Astrometric and Geodetic Properties of Earth and the solar System', in 'Global Earth Physics; A Handbook of Physical Constants', AGU Reference Shelf 1, American Geophysical Union, Table 15 'Prominent minor planets or asteroids' (http://www.agu.org/books/rf/v001/RF001p0001/RF001p0001.pdf). Note that a radius of 120 km is found by E.F. Tedesco, 1989, 'Asteroid magnitudes, UBV colors, and IRAS albedos and diameters', in 'Asteroids II', proceedings of the Conference, Tucson, AZ, 8-11 March 1988, eds R.P. Binzel, T. Gehrels, M.S. Matthews, University of Arizona Press, page 1090 (1989aste.conf.1090T)<br/>
     * Status: CONF<br/>
     * Unit: km<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Diameter of 3 Juno", 
     source = "C.F. Yoder, 1995, 'Astrometric and Geodetic Properties of Earth and the solar System', in 'Global Earth Physics; A Handbook of Physical Constants', AGU Reference Shelf 1, American Geophysical Union, Table 15 'Prominent minor planets or asteroids' (http://www.agu.org/books/rf/v001/RF001p0001/RF001p0001.pdf). Note that a radius of 120 km is found by E.F. Tedesco, 1989, 'Asteroid magnitudes, UBV colors, and IRAS albedos and diameters', in 'Asteroids II', proceedings of the Conference, Tucson, AZ, 8-11 March 1988, eds R.P. Binzel, T. Gehrels, M.S. Matthews, University of Arizona Press, page 1090 (1989aste.conf.1090T)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "km") 
    public static final double ASTEROID3JUNO_DIAMETER; static { ASTEROID3JUNO_DIAMETER = 267.; } // [km] 

    /**
     * Orbital semi-major axis of 3 Juno (epoch 1 October 1989). The orbital elements are referenced to the B1950 equinox and ecliptic    
     * <p>
     * Source: C.F. Yoder, 1995, 'Astrometric and Geodetic Properties of Earth and the solar System', in 'Global Earth Physics; A Handbook of Physical Constants', AGU Reference Shelf 1, American Geophysical Union, Table 15 'Prominent minor planets or asteroids' (http://www.agu.org/books/rf/v001/RF001p0001/RF001p0001.pdf)<br/>
     * Status: CONF<br/>
     * Unit: au<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Orbital semi-major axis of 3 Juno (epoch 1 October 1989). The orbital elements are referenced to the B1950 equinox and ecliptic", 
     source = "C.F. Yoder, 1995, 'Astrometric and Geodetic Properties of Earth and the solar System', in 'Global Earth Physics; A Handbook of Physical Constants', AGU Reference Shelf 1, American Geophysical Union, Table 15 'Prominent minor planets or asteroids' (http://www.agu.org/books/rf/v001/RF001p0001/RF001p0001.pdf)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "au") 
    public static final double ASTEROID3JUNO_ORBITALSEMIMAJORAXIS_B1950; static { ASTEROID3JUNO_ORBITALSEMIMAJORAXIS_B1950 = 2.668; } // [au] 

    /**
     * Orbital eccentricity of 3 Juno (epoch 1 October 1989). The orbital elements are referenced to the B1950 equinox and ecliptic    
     * <p>
     * Source: C.F. Yoder, 1995, 'Astrometric and Geodetic Properties of Earth and the solar System', in 'Global Earth Physics; A Handbook of Physical Constants', AGU Reference Shelf 1, American Geophysical Union, Table 15 'Prominent minor planets or asteroids' (http://www.agu.org/books/rf/v001/RF001p0001/RF001p0001.pdf)<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Orbital eccentricity of 3 Juno (epoch 1 October 1989). The orbital elements are referenced to the B1950 equinox and ecliptic", 
     source = "C.F. Yoder, 1995, 'Astrometric and Geodetic Properties of Earth and the solar System', in 'Global Earth Physics; A Handbook of Physical Constants', AGU Reference Shelf 1, American Geophysical Union, Table 15 'Prominent minor planets or asteroids' (http://www.agu.org/books/rf/v001/RF001p0001/RF001p0001.pdf)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double ASTEROID3JUNO_ORBITALECCENTRICITY_B1950; static { ASTEROID3JUNO_ORBITALECCENTRICITY_B1950 = 0.0258; } 

    /**
     * Orbital period of 3 Juno (epoch 1 October 1989). The orbital elements are referenced to the B1950 equinox and ecliptic    
     * <p>
     * Source: C.F. Yoder, 1995, 'Astrometric and Geodetic Properties of Earth and the solar System', in 'Global Earth Physics; A Handbook of Physical Constants', AGU Reference Shelf 1, American Geophysical Union, Table 15 'Prominent minor planets or asteroids' (http://www.agu.org/books/rf/v001/RF001p0001/RF001p0001.pdf)<br/>
     * Status: CONF<br/>
     * Unit: yr<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Orbital period of 3 Juno (epoch 1 October 1989). The orbital elements are referenced to the B1950 equinox and ecliptic", 
     source = "C.F. Yoder, 1995, 'Astrometric and Geodetic Properties of Earth and the solar System', in 'Global Earth Physics; A Handbook of Physical Constants', AGU Reference Shelf 1, American Geophysical Union, Table 15 'Prominent minor planets or asteroids' (http://www.agu.org/books/rf/v001/RF001p0001/RF001p0001.pdf)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "yr") 
    public static final double ASTEROID3JUNO_ORBITALPERIOD_B1950; static { ASTEROID3JUNO_ORBITALPERIOD_B1950 = 4.359; } // [yr] 

    /**
     * Perihelion distance of 3 Juno (epoch 1 October 1989). The orbital elements are referenced to the B1950 equinox and ecliptic    
     * <p>
     * Status: CONF<br/>
     * Unit: au<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Perihelion distance of 3 Juno (epoch 1 October 1989). The orbital elements are referenced to the B1950 equinox and ecliptic", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "au") 
    public static final double ASTEROID3JUNO_PERIHELIONDISTANCE_B1950; static { ASTEROID3JUNO_PERIHELIONDISTANCE_B1950 = 2.599; } // [au] 

    /**
     * Post-Newtonian deflection angle of a limb-grazing light ray due to the spherically symmetric part of the gravitational field of 4 Vesta    
     * <p>
     * Source: S.A. Klioner, 2003, 'A Practical Relativistic Model for Microarcsecond Astrometry in Space', AJ, 125, 1580, Equation 64 with cot(x) = cos(x) / sin(x) approximated by x^-1; see also J.H.J. de Bruijne, 19 February 2002, 'Gravitational light deflection', GAIA-JdB-001, issue 1, revision 0<br/>
     * Status: CONF<br/>
     * Unit: 10^-6 arcsec<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Post-Newtonian deflection angle of a limb-grazing light ray due to the spherically symmetric part of the gravitational field of 4 Vesta", 
     source = "S.A. Klioner, 2003, 'A Practical Relativistic Model for Microarcsecond Astrometry in Space', AJ, 125, 1580, Equation 64 with cot(x) = cos(x) / sin(x) approximated by x^-1; see also J.H.J. de Bruijne, 19 February 2002, 'Gravitational light deflection', GAIA-JdB-001, issue 1, revision 0", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "10^-6 arcsec") 
    public static final double ASTEROID4VESTA_LIGHTDEFLECTION_LIMB; static { ASTEROID4VESTA_LIGHTDEFLECTION_LIMB = 1.; } // [10^-6 arcsec] 

    /**
     * Diameter of 4 Vesta    
     * <p>
     * Source: C.F. Yoder, 1995, 'Astrometric and Geodetic Properties of Earth and the solar System', in 'Global Earth Physics; A Handbook of Physical Constants', AGU Reference Shelf 1, American Geophysical Union, Table 15 'Prominent minor planets or asteroids' (http://www.agu.org/books/rf/v001/RF001p0001/RF001p0001.pdf)<br/>
     * Status: CONF<br/>
     * Unit: km<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Diameter of 4 Vesta", 
     source = "C.F. Yoder, 1995, 'Astrometric and Geodetic Properties of Earth and the solar System', in 'Global Earth Physics; A Handbook of Physical Constants', AGU Reference Shelf 1, American Geophysical Union, Table 15 'Prominent minor planets or asteroids' (http://www.agu.org/books/rf/v001/RF001p0001/RF001p0001.pdf)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "km") 
    public static final double ASTEROID4VESTA_DIAMETER; static { ASTEROID4VESTA_DIAMETER = 510.; } // [km] 

    /**
     * Orbital semi-major axis of 4 Vesta (epoch 1 October 1989). The orbital elements are referenced to the B1950 equinox and ecliptic    
     * <p>
     * Source: C.F. Yoder, 1995, 'Astrometric and Geodetic Properties of Earth and the solar System', in 'Global Earth Physics; A Handbook of Physical Constants', AGU Reference Shelf 1, American Geophysical Union, Table 15 'Prominent minor planets or asteroids' (http://www.agu.org/books/rf/v001/RF001p0001/RF001p0001.pdf)<br/>
     * Status: CONF<br/>
     * Unit: au<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Orbital semi-major axis of 4 Vesta (epoch 1 October 1989). The orbital elements are referenced to the B1950 equinox and ecliptic", 
     source = "C.F. Yoder, 1995, 'Astrometric and Geodetic Properties of Earth and the solar System', in 'Global Earth Physics; A Handbook of Physical Constants', AGU Reference Shelf 1, American Geophysical Union, Table 15 'Prominent minor planets or asteroids' (http://www.agu.org/books/rf/v001/RF001p0001/RF001p0001.pdf)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "au") 
    public static final double ASTEROID4VESTA_ORBITALSEMIMAJORAXIS_B1950; static { ASTEROID4VESTA_ORBITALSEMIMAJORAXIS_B1950 = 2.361; } // [au] 

    /**
     * Orbital eccentricity of 4 Vesta (epoch 1 October 1989). The orbital elements are referenced to the B1950 equinox and ecliptic    
     * <p>
     * Source: C.F. Yoder, 1995, 'Astrometric and Geodetic Properties of Earth and the solar System', in 'Global Earth Physics; A Handbook of Physical Constants', AGU Reference Shelf 1, American Geophysical Union, Table 15 'Prominent minor planets or asteroids' (http://www.agu.org/books/rf/v001/RF001p0001/RF001p0001.pdf)<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Orbital eccentricity of 4 Vesta (epoch 1 October 1989). The orbital elements are referenced to the B1950 equinox and ecliptic", 
     source = "C.F. Yoder, 1995, 'Astrometric and Geodetic Properties of Earth and the solar System', in 'Global Earth Physics; A Handbook of Physical Constants', AGU Reference Shelf 1, American Geophysical Union, Table 15 'Prominent minor planets or asteroids' (http://www.agu.org/books/rf/v001/RF001p0001/RF001p0001.pdf)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double ASTEROID4VESTA_ORBITALECCENTRICITY_B1950; static { ASTEROID4VESTA_ORBITALECCENTRICITY_B1950 = 0.0906; } 

    /**
     * Orbital period of 4 Vesta (epoch 1 October 1989). The orbital elements are referenced to the B1950 equinox and ecliptic    
     * <p>
     * Source: C.F. Yoder, 1995, 'Astrometric and Geodetic Properties of Earth and the solar System', in 'Global Earth Physics; A Handbook of Physical Constants', AGU Reference Shelf 1, American Geophysical Union, Table 15 'Prominent minor planets or asteroids' (http://www.agu.org/books/rf/v001/RF001p0001/RF001p0001.pdf)<br/>
     * Status: CONF<br/>
     * Unit: yr<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Orbital period of 4 Vesta (epoch 1 October 1989). The orbital elements are referenced to the B1950 equinox and ecliptic", 
     source = "C.F. Yoder, 1995, 'Astrometric and Geodetic Properties of Earth and the solar System', in 'Global Earth Physics; A Handbook of Physical Constants', AGU Reference Shelf 1, American Geophysical Union, Table 15 'Prominent minor planets or asteroids' (http://www.agu.org/books/rf/v001/RF001p0001/RF001p0001.pdf)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "yr") 
    public static final double ASTEROID4VESTA_ORBITALPERIOD_B1950; static { ASTEROID4VESTA_ORBITALPERIOD_B1950 = 3.629; } // [yr] 

    /**
     * Perihelion distance of 4 Vesta (epoch 1 October 1989). The orbital elements are referenced to the B1950 equinox and ecliptic    
     * <p>
     * Status: CONF<br/>
     * Unit: au<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Perihelion distance of 4 Vesta (epoch 1 October 1989). The orbital elements are referenced to the B1950 equinox and ecliptic", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "au") 
    public static final double ASTEROID4VESTA_PERIHELIONDISTANCE_B1950; static { ASTEROID4VESTA_PERIHELIONDISTANCE_B1950 = 2.147; } // [au] 

    /**
     * Ratio of 4 Vesta to solar mass (IAU 2009 CBE value)    
     * <p>
     * Source: The IAU (2009) System of Astronomical Constants (IAU, August 2009, 'IAU 2009 Astronomical Constants', IAU 2009 Resolution B2 adopted at the XXVII-th General Assembly of the IAU. See also IAU, 10 August 2009, 'IAU WG on NSFA Current Best Estimates', http://maia.usno.navy.mil/NSFA/NSFA_cbe.html)<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Ratio of 4 Vesta to solar mass (IAU 2009 CBE value)", 
     source = "The IAU (2009) System of Astronomical Constants (IAU, August 2009, 'IAU 2009 Astronomical Constants', IAU 2009 Resolution B2 adopted at the XXVII-th General Assembly of the IAU. See also IAU, 10 August 2009, 'IAU WG on NSFA Current Best Estimates', http://maia.usno.navy.mil/NSFA/NSFA_cbe.html)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double ASTEROID4VESTAMASS_SOLARMASS; static { ASTEROID4VESTAMASS_SOLARMASS = 1.350e-10; } 

    /**
     * Total mass of the main asteroid belt, in units of solar masses    
     * <p>
     * Source: E. Pitjeva, 2003, 'The Dynamic Estimation of the Mass of the Main Asteroid Belt', in 'Physical Properties and Morphology of Small Solar-System Bodies', XXV-th General Assembly of the IAU, Joint Discussion 19, 23 July 2003, Sidney, Australia (2003IAUJD..19E..22P)<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Total mass of the main asteroid belt, in units of solar masses", 
     source = "E. Pitjeva, 2003, 'The Dynamic Estimation of the Mass of the Main Asteroid Belt', in 'Physical Properties and Morphology of Small Solar-System Bodies', XXV-th General Assembly of the IAU, Joint Discussion 19, 23 July 2003, Sidney, Australia (2003IAUJD..19E..22P)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double ASTEROIDBELTMASS_SOLARMASS; static { ASTEROIDBELTMASS_SOLARMASS = 1.400e-9; } 

    /**
     * Astronomical unit (au) length. The au is a conventional unit of length and is a defining constant. The numerical value is in agreement with the value adopted in IAU 2009 Resolution B2. The definition applies to all time scales such as TCB, TDB, TCG, TT, etc.    
     * <p>
     * Source: IAU, August 2012, 'Re-definition of the astronomical unit of length', IAU 2012 Resolution B2 adopted at the XXVIII-th General Assembly of the IAU<br/>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Astronomical unit (au) length. The au is a conventional unit of length and is a defining constant. The numerical value is in agreement with the value adopted in IAU 2009 Resolution B2. The definition applies to all time scales such as TCB, TDB, TCG, TT, etc.", 
     source = "IAU, August 2012, 'Re-definition of the astronomical unit of length', IAU 2012 Resolution B2 adopted at the XXVIII-th General Assembly of the IAU", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "m") 
    public static final double ASTRONOMICALUNIT_METER; static { ASTRONOMICALUNIT_METER = 149597870700.; } // [m] 

    /**
     * Atomic mass constant (also known as atomic mass unit [amu]; 1 amu is defined as 1/12-th of the mass of a 12-C atom). Note: best-measured value equals 1.660539040E-27 (P.J. Mohr, B.N. Taylor, D.B. Newell, 9 July 2015, 'The 2014 CODATA Recommended Values of the Fundamental Physical Constants', National Institute of Standards and Technology, Gaithersburg, MD 20899-8401; http://www.codata.org/ and http://physics.nist.gov/constants (Web Version 7.0))    
     * <p>
     * Status: CONF<br/>
     * Unit: kg<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Atomic mass constant (also known as atomic mass unit [amu]; 1 amu is defined as 1/12-th of the mass of a 12-C atom). Note: best-measured value equals 1.660539040E-27 (P.J. Mohr, B.N. Taylor, D.B. Newell, 9 July 2015, 'The 2014 CODATA Recommended Values of the Fundamental Physical Constants', National Institute of Standards and Technology, Gaithersburg, MD 20899-8401; http://www.codata.org/ and http://physics.nist.gov/constants (Web Version 7.0))", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "kg") 
    public static final double ATOMICMASS_CONSTANT; static { ATOMICMASS_CONSTANT = 1.6605390404e-27; } // [kg] 

    /**
     * Avogadro's constant    
     * <p>
     * Source: P.J. Mohr, B.N. Taylor, D.B. Newell, 9 July 2015, 'The 2014 CODATA Recommended Values of the Fundamental Physical Constants', National Institute of Standards and Technology, Gaithersburg, MD 20899-8401; http://www.codata.org/ and http://physics.nist.gov/constants (Web Version 7.0)<br/>
     * Status: CONF<br/>
     * Unit: mol^-1<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Avogadro's constant", 
     source = "P.J. Mohr, B.N. Taylor, D.B. Newell, 9 July 2015, 'The 2014 CODATA Recommended Values of the Fundamental Physical Constants', National Institute of Standards and Technology, Gaithersburg, MD 20899-8401; http://www.codata.org/ and http://physics.nist.gov/constants (Web Version 7.0)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "mol^-1") 
    public static final double AVOGADRO_CONSTANT; static { AVOGADRO_CONSTANT = 6.0221408570e+23; } // [mol^-1] 

    /**
     * Photon flux density N_{\lambda}(\lambda) of an unreddened B0I star (Pickles' star number 114) at V = 0 mag. First column: wavelength \lambda (in nm; from 115.0 to 1062.0). Second column: photon flux density above the Earth's atmosphere (in photons m^-2 s^-1 nm^-1; the photometric zero point is described in J.H.J. de Bruijne, 26 May 2003, 'Stellar fluxes: transformations and calibrations', GAIA-JdB-005, issue 1, revision 1)    
     * <p>
     * Source: A.J. Pickles, 1998, 'A stellar spectral flux library: 1150-25000 AA', PASP, 110, 863<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: false
     */
    @ParamMetaData (
    description = "Photon flux density N_{\\lambda}(\\lambda) of an unreddened B0I star (Pickles' star number 114) at V = 0 mag. First column: wavelength \\lambda (in nm; from 115.0 to 1062.0). Second column: photon flux density above the Earth's atmosphere (in photons m^-2 s^-1 nm^-1; the photometric zero point is described in J.H.J. de Bruijne, 26 May 2003, 'Stellar fluxes: transformations and calibrations', GAIA-JdB-005, issue 1, revision 1)", 
     source = "A.J. Pickles, 1998, 'A stellar spectral flux library: 1150-25000 AA', PASP, 110, 863", 
     status = "CONF", 
     basic = true, 
     scalar = false, 
     unit = "") 
    public static final String B0ISTAR_SPECTRUM_NUMBEROFPHOTONS; static { B0ISTAR_SPECTRUM_NUMBEROFPHOTONS = "Nature/B0IStar_Spectrum_NumberOfPhotons_001.fits"; } 

    /**
     * Photon flux density N_{\lambda}(\lambda) of an unreddened B1V star (Pickles' star number 004) at V = 0 mag. First column: wavelength \lambda (in nm; from 115.0 to 1062.0). Second column: photon flux density above the Earth's atmosphere (in photons m^-2 s^-1 nm^-1; the photometric zero point is described in J.H.J. de Bruijne, 26 May 2003, 'Stellar fluxes: transformations and calibrations', GAIA-JdB-005, issue 1, revision 1)    
     * <p>
     * Source: A.J. Pickles, 1998, 'A stellar spectral flux library: 1150-25000 AA', PASP, 110, 863<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: false
     */
    @ParamMetaData (
    description = "Photon flux density N_{\\lambda}(\\lambda) of an unreddened B1V star (Pickles' star number 004) at V = 0 mag. First column: wavelength \\lambda (in nm; from 115.0 to 1062.0). Second column: photon flux density above the Earth's atmosphere (in photons m^-2 s^-1 nm^-1; the photometric zero point is described in J.H.J. de Bruijne, 26 May 2003, 'Stellar fluxes: transformations and calibrations', GAIA-JdB-005, issue 1, revision 1)", 
     source = "A.J. Pickles, 1998, 'A stellar spectral flux library: 1150-25000 AA', PASP, 110, 863", 
     status = "CONF", 
     basic = true, 
     scalar = false, 
     unit = "") 
    public static final String B1VSTAR_SPECTRUM_NUMBEROFPHOTONS; static { B1VSTAR_SPECTRUM_NUMBEROFPHOTONS = "Nature/B1VStar_Spectrum_NumberOfPhotons_001.fits"; } 

    /**
     * High-resolution photon-flux density N_{\lambda}(\lambda) of an unreddened B1V star at V = 15 mag. The data refer to a high-resolution Kurucz-model spectrum with the following properties: effective temperature T_eff = 25500 K, logarithm of surface gravity log g = 4.0, metallicity [Fe/H] = 0.0, alpha-elements [\alpha/Fe] = 0.0, rotational velocity v sini = 50 km s^-1, micro-turbulence velocity = 2.0 km s^-1, length of convective bubble divided by pressure scale height = 0.50, no convective overshooting, macro-turbulence velocity = 2.0 km s^-1, and resolving power R = \lambda / \delta \lambda = 250,000. First column: wavelength \lambda (in nm; from 830.1673264 to 889.8217922). Second column: photon flux density above the Earth's atmosphere (in photons m^-2 s^-1 nm^-1). The 34698 lines have an average wavelength step of 0.00172 nm; the spectrum extent is thus 59.7 nm    
     * <p>
     * Source: ESA, 20 June 2005, 'Photon-flux distributions for reference stars', GAIA-EST-TN-00539, issue 1, revision 0, based on D. Katz, priv. comm., 11 May 2005<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: false
     */
    @ParamMetaData (
    description = "High-resolution photon-flux density N_{\\lambda}(\\lambda) of an unreddened B1V star at V = 15 mag. The data refer to a high-resolution Kurucz-model spectrum with the following properties: effective temperature T_eff = 25500 K, logarithm of surface gravity log g = 4.0, metallicity [Fe/H] = 0.0, alpha-elements [\\alpha/Fe] = 0.0, rotational velocity v sini = 50 km s^-1, micro-turbulence velocity = 2.0 km s^-1, length of convective bubble divided by pressure scale height = 0.50, no convective overshooting, macro-turbulence velocity = 2.0 km s^-1, and resolving power R = \\lambda / \\delta \\lambda = 250,000. First column: wavelength \\lambda (in nm; from 830.1673264 to 889.8217922). Second column: photon flux density above the Earth's atmosphere (in photons m^-2 s^-1 nm^-1). The 34698 lines have an average wavelength step of 0.00172 nm; the spectrum extent is thus 59.7 nm", 
     source = "ESA, 20 June 2005, 'Photon-flux distributions for reference stars', GAIA-EST-TN-00539, issue 1, revision 0, based on D. Katz, priv. comm., 11 May 2005", 
     status = "CONF", 
     basic = true, 
     scalar = false, 
     unit = "") 
    public static final String B1VSTAR_SPECTRUM_NUMBEROFPHOTONSHIGHRESOLUTION; static { B1VSTAR_SPECTRUM_NUMBEROFPHOTONSHIGHRESOLUTION = "Nature/B1VStar_Spectrum_NumberOfPhotonsHighResolution_001.fits"; } 

    /**
     * Bohr radius. Note: best-measured value equals 0.52917721067E-10 (P.J. Mohr, B.N. Taylor, D.B. Newell, 9 July 2015, 'The 2014 CODATA Recommended Values of the Fundamental Physical Constants', National Institute of Standards and Technology, Gaithersburg, MD 20899-8401; http://www.codata.org/ and http://physics.nist.gov/constants (Web Version 7.0))    
     * <p>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Bohr radius. Note: best-measured value equals 0.52917721067E-10 (P.J. Mohr, B.N. Taylor, D.B. Newell, 9 July 2015, 'The 2014 CODATA Recommended Values of the Fundamental Physical Constants', National Institute of Standards and Technology, Gaithersburg, MD 20899-8401; http://www.codata.org/ and http://physics.nist.gov/constants (Web Version 7.0))", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m") 
    public static final double BOHRRADIUS_CONSTANT; static { BOHRRADIUS_CONSTANT = 5.29177210564e-11; } // [m] 

    /**
     * Boltzmann's constant. Note: best-measured value equals 1.38064852E-23 (P.J. Mohr, B.N. Taylor, D.B. Newell, 9 July 2015, 'The 2014 CODATA Recommended Values of the Fundamental Physical Constants', National Institute of Standards and Technology, Gaithersburg, MD 20899-8401; http://www.codata.org/ and http://physics.nist.gov/constants (Web Version 7.0))    
     * <p>
     * Status: CONF<br/>
     * Unit: J K^-1<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Boltzmann's constant. Note: best-measured value equals 1.38064852E-23 (P.J. Mohr, B.N. Taylor, D.B. Newell, 9 July 2015, 'The 2014 CODATA Recommended Values of the Fundamental Physical Constants', National Institute of Standards and Technology, Gaithersburg, MD 20899-8401; http://www.codata.org/ and http://physics.nist.gov/constants (Web Version 7.0))", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "J K^-1") 
    public static final double BOLTZMANN_CONSTANT; static { BOLTZMANN_CONSTANT = 1.380648510e-23; } // [J K^-1] 

    /**
     * Rest-wavelength in vacuum of the first line of the CaII-triplet (3p^{6}3d ^{2}D_{3/2} - 3p^{6}4p ^{2}P_{3/2} transition), as calculated from the difference between the energy of the upper and lower level of the transition    
     * <p>
     * Source: Y. Ralchenko, A.E. Kramida, J. Reader, and the NIST ASD Team, 4 October 2010, 'NIST Atomic Spectra Database', National Institute of Standards and Technology, Gaithersburg, MD 20899-8401; http://www.nist.gov/pml/data/asd.cfm (Web Version 4.0)<br/>
     * Status: CONF<br/>
     * Unit: nm<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Rest-wavelength in vacuum of the first line of the CaII-triplet (3p^{6}3d ^{2}D_{3/2} - 3p^{6}4p ^{2}P_{3/2} transition), as calculated from the difference between the energy of the upper and lower level of the transition", 
     source = "Y. Ralchenko, A.E. Kramida, J. Reader, and the NIST ASD Team, 4 October 2010, 'NIST Atomic Spectra Database', National Institute of Standards and Technology, Gaithersburg, MD 20899-8401; http://www.nist.gov/pml/data/asd.cfm (Web Version 4.0)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "nm") 
    public static final double CAIITRIPLET_WAVELENGTH_1; static { CAIITRIPLET_WAVELENGTH_1 = 850.035; } // [nm] 

    /**
     * Rest-wavelength in vacuum of the second line of the CaII-triplet (3p^{6}3d ^{2}D_{5/2} - 3p^{6}4p ^{2}P_{3/2} transition), as calculated from the difference between the energy of the upper and lower level of the transition    
     * <p>
     * Source: Y. Ralchenko, A.E. Kramida, J. Reader, and the NIST ASD Team, 4 October 2010, 'NIST Atomic Spectra Database', National Institute of Standards and Technology, Gaithersburg, MD 20899-8401; http://www.nist.gov/pml/data/asd.cfm (Web Version 4.0)<br/>
     * Status: CONF<br/>
     * Unit: nm<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Rest-wavelength in vacuum of the second line of the CaII-triplet (3p^{6}3d ^{2}D_{5/2} - 3p^{6}4p ^{2}P_{3/2} transition), as calculated from the difference between the energy of the upper and lower level of the transition", 
     source = "Y. Ralchenko, A.E. Kramida, J. Reader, and the NIST ASD Team, 4 October 2010, 'NIST Atomic Spectra Database', National Institute of Standards and Technology, Gaithersburg, MD 20899-8401; http://www.nist.gov/pml/data/asd.cfm (Web Version 4.0)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "nm") 
    public static final double CAIITRIPLET_WAVELENGTH_2; static { CAIITRIPLET_WAVELENGTH_2 = 854.444; } // [nm] 

    /**
     * Rest-wavelength in vacuum of the third line of the CaII-triplet (3p^{6}3d ^{2}D_{3/2} - 3p^{6}4p ^{2}P_{1/2} transition), as calculated from the difference between the energy of the upper and lower level of the transition    
     * <p>
     * Source: Y. Ralchenko, A.E. Kramida, J. Reader, and the NIST ASD Team, 4 October 2010, 'NIST Atomic Spectra Database', National Institute of Standards and Technology, Gaithersburg, MD 20899-8401; http://www.nist.gov/pml/data/asd.cfm (Web Version 4.0)<br/>
     * Status: CONF<br/>
     * Unit: nm<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Rest-wavelength in vacuum of the third line of the CaII-triplet (3p^{6}3d ^{2}D_{3/2} - 3p^{6}4p ^{2}P_{1/2} transition), as calculated from the difference between the energy of the upper and lower level of the transition", 
     source = "Y. Ralchenko, A.E. Kramida, J. Reader, and the NIST ASD Team, 4 October 2010, 'NIST Atomic Spectra Database', National Institute of Standards and Technology, Gaithersburg, MD 20899-8401; http://www.nist.gov/pml/data/asd.cfm (Web Version 4.0)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "nm") 
    public static final double CAIITRIPLET_WAVELENGTH_3; static { CAIITRIPLET_WAVELENGTH_3 = 866.452; } // [nm] 

    /**
     * Oscillator strength of the first line of the CaII-triplet (3p^{6}3d ^{2}D_{3/2} - 3p^{6}4p ^{2}P_{3/2} transition). The estimated accuracy is better than 25%    
     * <p>
     * Source: Y. Ralchenko, A.E. Kramida, J. Reader, and the NIST ASD Team, 4 October 2010, 'NIST Atomic Spectra Database', National Institute of Standards and Technology, Gaithersburg, MD 20899-8401; http://www.nist.gov/pml/data/asd.cfm (Web Version 4.0)<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Oscillator strength of the first line of the CaII-triplet (3p^{6}3d ^{2}D_{3/2} - 3p^{6}4p ^{2}P_{3/2} transition). The estimated accuracy is better than 25%", 
     source = "Y. Ralchenko, A.E. Kramida, J. Reader, and the NIST ASD Team, 4 October 2010, 'NIST Atomic Spectra Database', National Institute of Standards and Technology, Gaithersburg, MD 20899-8401; http://www.nist.gov/pml/data/asd.cfm (Web Version 4.0)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double CAIITRIPLET_OSCILLATORSTRENGTH_1; static { CAIITRIPLET_OSCILLATORSTRENGTH_1 = -1.318; } 

    /**
     * Oscillator strength of the second line of the CaII-triplet (3p^{6}3d ^{2}D_{5/2} - 3p^{6}4p ^{2}P_{3/2} transition). The estimated accuracy is better than 25%    
     * <p>
     * Source: Y. Ralchenko, A.E. Kramida, J. Reader, and the NIST ASD Team, 4 October 2010, 'NIST Atomic Spectra Database', National Institute of Standards and Technology, Gaithersburg, MD 20899-8401; http://www.nist.gov/pml/data/asd.cfm (Web Version 4.0)<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Oscillator strength of the second line of the CaII-triplet (3p^{6}3d ^{2}D_{5/2} - 3p^{6}4p ^{2}P_{3/2} transition). The estimated accuracy is better than 25%", 
     source = "Y. Ralchenko, A.E. Kramida, J. Reader, and the NIST ASD Team, 4 October 2010, 'NIST Atomic Spectra Database', National Institute of Standards and Technology, Gaithersburg, MD 20899-8401; http://www.nist.gov/pml/data/asd.cfm (Web Version 4.0)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double CAIITRIPLET_OSCILLATORSTRENGTH_2; static { CAIITRIPLET_OSCILLATORSTRENGTH_2 = -0.36; } 

    /**
     * Oscillator strength of the third line of the CaII-triplet (3p^{6}3d ^{2}D_{3/2} - 3p^{6}4p ^{2}P_{1/2} transition). The estimated accuracy is better than 25%    
     * <p>
     * Source: Y. Ralchenko, A.E. Kramida, J. Reader, and the NIST ASD Team, 4 October 2010, 'NIST Atomic Spectra Database', National Institute of Standards and Technology, Gaithersburg, MD 20899-8401; http://www.nist.gov/pml/data/asd.cfm (Web Version 4.0)<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Oscillator strength of the third line of the CaII-triplet (3p^{6}3d ^{2}D_{3/2} - 3p^{6}4p ^{2}P_{1/2} transition). The estimated accuracy is better than 25%", 
     source = "Y. Ralchenko, A.E. Kramida, J. Reader, and the NIST ASD Team, 4 October 2010, 'NIST Atomic Spectra Database', National Institute of Standards and Technology, Gaithersburg, MD 20899-8401; http://www.nist.gov/pml/data/asd.cfm (Web Version 4.0)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double CAIITRIPLET_OSCILLATORSTRENGTH_3; static { CAIITRIPLET_OSCILLATORSTRENGTH_3 = -0.622; } 

    /**
     * Solar value of the equivalent width of the first line of the CaII-triplet (3p^{6}3d ^{2}D_{3/2} - 3p^{6}4p ^{2}P_{3/2} transition). A relative intensity of 130 is mentioned in Y. Ralchenko, A.E. Kramida, J. Reader, and the NIST ASD Team, 4 October 2010, 'NIST Atomic Spectra Database', National Institute of Standards and Technology, Gaithersburg, MD 20899-8401; http://www.nist.gov/pml/data/asd.cfm (Web Version 4.0)    
     * <p>
     * Source: C.E. Moore, M.G.J. Minnaert, J. Houtgast, 1966, 'The solar spectrum 2935 AA to 8770 AA', US National Bureau of Standards, Monograph 61<br/>
     * Status: CONF<br/>
     * Unit: nm<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Solar value of the equivalent width of the first line of the CaII-triplet (3p^{6}3d ^{2}D_{3/2} - 3p^{6}4p ^{2}P_{3/2} transition). A relative intensity of 130 is mentioned in Y. Ralchenko, A.E. Kramida, J. Reader, and the NIST ASD Team, 4 October 2010, 'NIST Atomic Spectra Database', National Institute of Standards and Technology, Gaithersburg, MD 20899-8401; http://www.nist.gov/pml/data/asd.cfm (Web Version 4.0)", 
     source = "C.E. Moore, M.G.J. Minnaert, J. Houtgast, 1966, 'The solar spectrum 2935 AA to 8770 AA', US National Bureau of Standards, Monograph 61", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "nm") 
    public static final double CAIITRIPLET_EQUIVALENTWIDTH_1SUN; static { CAIITRIPLET_EQUIVALENTWIDTH_1SUN = 0.146; } // [nm] 

    /**
     * Solar value of the equivalent width of the second line of the CaII-triplet (3p^{6}3d ^{2}D_{5/2} - 3p^{6}4p ^{2}P_{3/2} transition). A relative intensity of 170 is mentioned in Y. Ralchenko, A.E. Kramida, J. Reader, and the NIST ASD Team, 4 October 2010, 'NIST Atomic Spectra Database', National Institute of Standards and Technology, Gaithersburg, MD 20899-8401; http://www.nist.gov/pml/data/asd.cfm (Web Version 4.0)    
     * <p>
     * Source: C.E. Moore, M.G.J. Minnaert, J. Houtgast, 1966, 'The solar spectrum 2935 AA to 8770 AA', US National Bureau of Standards, Monograph 61<br/>
     * Status: CONF<br/>
     * Unit: nm<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Solar value of the equivalent width of the second line of the CaII-triplet (3p^{6}3d ^{2}D_{5/2} - 3p^{6}4p ^{2}P_{3/2} transition). A relative intensity of 170 is mentioned in Y. Ralchenko, A.E. Kramida, J. Reader, and the NIST ASD Team, 4 October 2010, 'NIST Atomic Spectra Database', National Institute of Standards and Technology, Gaithersburg, MD 20899-8401; http://www.nist.gov/pml/data/asd.cfm (Web Version 4.0)", 
     source = "C.E. Moore, M.G.J. Minnaert, J. Houtgast, 1966, 'The solar spectrum 2935 AA to 8770 AA', US National Bureau of Standards, Monograph 61", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "nm") 
    public static final double CAIITRIPLET_EQUIVALENTWIDTH_2SUN; static { CAIITRIPLET_EQUIVALENTWIDTH_2SUN = 0.367; } // [nm] 

    /**
     * Solar value of the equivalent width of the third line of the CaII-triplet (3p^{6}3d ^{2}D_{3/2} - 3p^{6}4p ^{2}P_{1/2} transition). A relative intensity of 160 is mentioned in Y. Ralchenko, A.E. Kramida, J. Reader, and the NIST ASD Team, 4 October 2010, 'NIST Atomic Spectra Database', National Institute of Standards and Technology, Gaithersburg, MD 20899-8401; http://www.nist.gov/pml/data/asd.cfm (Web Version 4.0)    
     * <p>
     * Source: C.E. Moore, M.G.J. Minnaert, J. Houtgast, 1966, 'The solar spectrum 2935 AA to 8770 AA', US National Bureau of Standards, Monograph 61<br/>
     * Status: CONF<br/>
     * Unit: nm<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Solar value of the equivalent width of the third line of the CaII-triplet (3p^{6}3d ^{2}D_{3/2} - 3p^{6}4p ^{2}P_{1/2} transition). A relative intensity of 160 is mentioned in Y. Ralchenko, A.E. Kramida, J. Reader, and the NIST ASD Team, 4 October 2010, 'NIST Atomic Spectra Database', National Institute of Standards and Technology, Gaithersburg, MD 20899-8401; http://www.nist.gov/pml/data/asd.cfm (Web Version 4.0)", 
     source = "C.E. Moore, M.G.J. Minnaert, J. Houtgast, 1966, 'The solar spectrum 2935 AA to 8770 AA', US National Bureau of Standards, Monograph 61", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "nm") 
    public static final double CAIITRIPLET_EQUIVALENTWIDTH_3SUN; static { CAIITRIPLET_EQUIVALENTWIDTH_3SUN = 0.260; } // [nm] 

    /**
     * Mass of Charon (do not use for high-precision (orbit) calculations)    
     * <p>
     * Status: CONF<br/>
     * Unit: kg<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mass of Charon (do not use for high-precision (orbit) calculations)", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "kg") 
    public static final double CHARON_MASS; static { CHARON_MASS = 1.4705e+21; } // [kg] 

    /**
     * Radius of Charon    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A); see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par<br/>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Radius of Charon", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A); see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "m") 
    public static final double CHARON_RADIUS; static { CHARON_RADIUS = 6.050e+5; } // [m] 

    /**
     * Geometric albedo of Charon (i.e., the ratio of the body's brightness at zero phase angle to the brightness of a perfectly diffusing disk with the same position and apparent size as the body)    
     * <p>
     * Source: K. Reinsch, V. Burwitz, and M.C. Festou, 1994, 'Albedo Maps of Pluto and Improved Physical Parameters of the Pluto-Charon System', Icarus, 108, 209-218; see also D.K. Yeomans (NASA/JPL), 3 April 2009, 'Planetary Satellite Physical Parameters', http://ssd.jpl.nasa.gov/?sat_phys_par<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Geometric albedo of Charon (i.e., the ratio of the body's brightness at zero phase angle to the brightness of a perfectly diffusing disk with the same position and apparent size as the body)", 
     source = "K. Reinsch, V. Burwitz, and M.C. Festou, 1994, 'Albedo Maps of Pluto and Improved Physical Parameters of the Pluto-Charon System', Icarus, 108, 209-218; see also D.K. Yeomans (NASA/JPL), 3 April 2009, 'Planetary Satellite Physical Parameters', http://ssd.jpl.nasa.gov/?sat_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double CHARON_GEOMETRICALBEDO; static { CHARON_GEOMETRICALBEDO = 0.372; } 

    /**
     * Mean mass density of Charon    
     * <p>
     * Status: CONF<br/>
     * Unit: g cm^-3<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean mass density of Charon", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "g cm^-3") 
    public static final double CHARON_MASSDENSITY_MEAN; static { CHARON_MASSDENSITY_MEAN = 1.585; } // [g cm^-3] 

    /**
     * Radius of the smallest hypothetical sphere around Charon which would encompass the body (this is a low-accuracy parameter used in the relativistic model)    
     * <p>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Radius of the smallest hypothetical sphere around Charon which would encompass the body (this is a low-accuracy parameter used in the relativistic model)", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m") 
    public static final double CHARON_ENCOMPASSINGSPHERERADIUS; static { CHARON_ENCOMPASSINGSPHERERADIUS = 6.050e+5; } // [m] 

    /**
     * GM of Charon    
     * <p>
     * Source: R.A. Jacobson, 2007, 'Constants used in the PLU017 ephemeris', priv. comm.; see also D.K. Yeomans (NASA/JPL), 3 April 2009, 'Planetary Satellite Physical Parameters', http://ssd.jpl.nasa.gov/?sat_phys_par<br/>
     * Status: CONF<br/>
     * Unit: m^3 s^-2<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "GM of Charon", 
     source = "R.A. Jacobson, 2007, 'Constants used in the PLU017 ephemeris', priv. comm.; see also D.K. Yeomans (NASA/JPL), 3 April 2009, 'Planetary Satellite Physical Parameters', http://ssd.jpl.nasa.gov/?sat_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "m^3 s^-2") 
    public static final double CHARON_GM; static { CHARON_GM = 1.0320e+11; } // [m^3 s^-2] 

    /**
     * Post-Newtonian deflection angle of a limb-grazing light ray due to the spherically symmetric part of the gravitational field of Charon    
     * <p>
     * Source: S.A. Klioner, 2003, 'A Practical Relativistic Model for Microarcsecond Astrometry in Space', AJ, 125, 1580, Equation 64 with cot(x) = cos(x) / sin(x) approximated by x^-1; see also J.H.J. de Bruijne, 19 February 2002, 'Gravitational light deflection', GAIA-JdB-001, issue 1, revision 0<br/>
     * Status: CONF<br/>
     * Unit: 10^-6 arcsec<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Post-Newtonian deflection angle of a limb-grazing light ray due to the spherically symmetric part of the gravitational field of Charon", 
     source = "S.A. Klioner, 2003, 'A Practical Relativistic Model for Microarcsecond Astrometry in Space', AJ, 125, 1580, Equation 64 with cot(x) = cos(x) / sin(x) approximated by x^-1; see also J.H.J. de Bruijne, 19 February 2002, 'Gravitational light deflection', GAIA-JdB-001, issue 1, revision 0", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "10^-6 arcsec") 
    public static final double CHARON_LIGHTDEFLECTION_LIMB; static { CHARON_LIGHTDEFLECTION_LIMB = 1.; } // [10^-6 arcsec] 

    /**
     * Typical expected (galactic) cosmic-ray flux at L2, in units of particles cm^-2 s^-1. This flux will be present as constant background all through the mission. Note that cosmic rays and solar protons are distinct particles, collectively refered to as prompt-particle events (PPEs). An isotropic prompt-particle event flux N, in units of events cm^-2 s^-1, generates 2 N A / 4 events s^-1 CCD^-1, where A denotes the active-pixel area of the CCD in units of cm^2 (including any reduction as a result of TDI-gating), the factor 2 results from considering 'inflow' through both the illuminated and the non-illuminated faces of the CCD, and the factor 4 results from the 'flat geometry' of the CCD (see J.H.J. de Bruijne, A. Short, 7 September 2005, 'prompt-particle events: from fluxes to count rates', GAIA-JdB-026, issue 1, revision 0)    
     * <p>
     * Source: A. Short (ESA), priv. comm., 20 December 2005<br/>
     * Status: CONF<br/>
     * Unit: particles cm^-2 s^-1<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Typical expected (galactic) cosmic-ray flux at L2, in units of particles cm^-2 s^-1. This flux will be present as constant background all through the mission. Note that cosmic rays and solar protons are distinct particles, collectively refered to as prompt-particle events (PPEs). An isotropic prompt-particle event flux N, in units of events cm^-2 s^-1, generates 2 N A / 4 events s^-1 CCD^-1, where A denotes the active-pixel area of the CCD in units of cm^2 (including any reduction as a result of TDI-gating), the factor 2 results from considering 'inflow' through both the illuminated and the non-illuminated faces of the CCD, and the factor 4 results from the 'flat geometry' of the CCD (see J.H.J. de Bruijne, A. Short, 7 September 2005, 'prompt-particle events: from fluxes to count rates', GAIA-JdB-026, issue 1, revision 0)", 
     source = "A. Short (ESA), priv. comm., 20 December 2005", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "particles cm^-2 s^-1") 
    public static final double COSMICRAY_FLUX_L2; static { COSMICRAY_FLUX_L2 = 5.; } // [particles cm^-2 s^-1] 

    /**
     * Catalogue containing CCD images, in units of photo-electrons, of typical (galactic) cosmic-ray events for an AF CCD (used in BAM, WFS, SM, and AF; this CCD is also used in BP albeit with a different anti-reflection coating). Cosmic rays will be present as constant background all through the mission. Note that cosmic rays and solar protons are distinct particles, collectively refered to as prompt-particle events (PPEs). The catalogue contains 12389 events. The structure of the FITS file is as follows: the first FITS-file extension contains a list of events containing event number, number of pixels across-scan in the image, and number of pixels along-scan in the image. The following extensions contain the individual images ('pixel matrices'), in units of photo-electron counts, one image per extension    
     * <p>
     * Source: A. Short (ESA), priv. comm., 12 May 2006<br/>
     * Status: CONF<br/>
     * Unit: e^-<br/>
     * Basic : true<br/>
     * Scalar: false
     */
    @ParamMetaData (
    description = "Catalogue containing CCD images, in units of photo-electrons, of typical (galactic) cosmic-ray events for an AF CCD (used in BAM, WFS, SM, and AF; this CCD is also used in BP albeit with a different anti-reflection coating). Cosmic rays will be present as constant background all through the mission. Note that cosmic rays and solar protons are distinct particles, collectively refered to as prompt-particle events (PPEs). The catalogue contains 12389 events. The structure of the FITS file is as follows: the first FITS-file extension contains a list of events containing event number, number of pixels across-scan in the image, and number of pixels along-scan in the image. The following extensions contain the individual images ('pixel matrices'), in units of photo-electron counts, one image per extension", 
     source = "A. Short (ESA), priv. comm., 12 May 2006", 
     status = "CONF", 
     basic = true, 
     scalar = false, 
     unit = "e^-") 
    public static final String COSMICRAY_CATALOGUE_AFCCD; static { COSMICRAY_CATALOGUE_AFCCD = "Nature/CosmicRay_Catalogue_AFCCD_001.fits"; } // [e^-] 

    /**
     * Catalogue containing CCD images, in units of photo-electrons, of typical (galactic) cosmic-ray events for a red-enhanced CCD (used in RP and RVS). Cosmic rays will be present as constant background all through the mission. Note that cosmic rays and solar protons are distinct particles, collectively refered to as prompt-particle events (PPEs). The catalogue contains 4718 events. The structure of the FITS file is as follows: the first FITS-file extension contains a list of events containing event number, number of pixels across-scan in the image, and number of pixels along-scan in the image. The following extensions contain the individual images ('pixel matrices'), in units of photo-electron counts, one image per extension    
     * <p>
     * Source: A. Short (ESA), priv. comm., 5 May 2004<br/>
     * Status: CONF<br/>
     * Unit: e^-<br/>
     * Basic : true<br/>
     * Scalar: false
     */
    @ParamMetaData (
    description = "Catalogue containing CCD images, in units of photo-electrons, of typical (galactic) cosmic-ray events for a red-enhanced CCD (used in RP and RVS). Cosmic rays will be present as constant background all through the mission. Note that cosmic rays and solar protons are distinct particles, collectively refered to as prompt-particle events (PPEs). The catalogue contains 4718 events. The structure of the FITS file is as follows: the first FITS-file extension contains a list of events containing event number, number of pixels across-scan in the image, and number of pixels along-scan in the image. The following extensions contain the individual images ('pixel matrices'), in units of photo-electron counts, one image per extension", 
     source = "A. Short (ESA), priv. comm., 5 May 2004", 
     status = "CONF", 
     basic = true, 
     scalar = false, 
     unit = "e^-") 
    public static final String COSMICRAY_CATALOGUE_REDENHANCEDCCD; static { COSMICRAY_CATALOGUE_REDENHANCEDCCD = "Nature/CosmicRay_Catalogue_RedEnhancedCCD_001.fits"; } // [e^-] 

    /**
     * Number of seconds per day    
     * <p>
     * Source: IAU definition<br/>
     * Status: CONF<br/>
     * Unit: s<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Number of seconds per day", 
     source = "IAU definition", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "s") 
    public static final double DAY_SECOND; static { DAY_SECOND = 86400.; } // [s] 

    /**
     * One degree in units of radians    
     * <p>
     * Status: CONF<br/>
     * Unit: rad<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "One degree in units of radians", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "rad") 
    public static final double DEGREE_RADIAN; static { DEGREE_RADIAN = 1.745329251994330e-2; } // [rad] 

    /**
     * Chebyshev representation of the ephemerides of the Earth, with origin at the barycentre of the solar system (BCRS), in the equatorial ICRF frame. The ephemeris covers the period starting on JD (JDBEGIP + JDBEGFP) and ending on JD (JDENDIP + JDENDFP) for the position and starting on JD (JDBEGIV + JDBEGFV) and ending on JD (JDENDIV + JDENDFV) for the velocity. A number of Chebyshev coefficients equal to ORDERSP is given for NSSP time intervals of SPANSP days to describe the position-vector components in units of m; the similar parameters ending with PP (Peculiar Position) are not used in the current release and are reserved for future usage. A number of Chebyshev coefficients equal to ORDERSV is given for NSSV time intervals of SPANSV days to describe the velocity-vector components in units of m s^-1; the similar parameters ending with PV (Peculiar Velocity) are not used in the current release and are reserved for future usage. The first three HDUs contain the coefficients for the three components of the position, while the last three HDUs contain the coefficients for the three components of the velocity    
     * <p>
     * Source: A. Fienga, J. Laskar, H. Manche, M. Gastineau, 19 April 2007, 'Solar system planetary ephemeris delivery: INPOP06', GAIA-CA-TN-IMC-AF-001, issue 1, revision 0<br/>
     * Status: DEPR<br/>
     * Basic : true<br/>
     * Scalar: false
     */
    @ParamMetaData (
    description = "Chebyshev representation of the ephemerides of the Earth, with origin at the barycentre of the solar system (BCRS), in the equatorial ICRF frame. The ephemeris covers the period starting on JD (JDBEGIP + JDBEGFP) and ending on JD (JDENDIP + JDENDFP) for the position and starting on JD (JDBEGIV + JDBEGFV) and ending on JD (JDENDIV + JDENDFV) for the velocity. A number of Chebyshev coefficients equal to ORDERSP is given for NSSP time intervals of SPANSP days to describe the position-vector components in units of m; the similar parameters ending with PP (Peculiar Position) are not used in the current release and are reserved for future usage. A number of Chebyshev coefficients equal to ORDERSV is given for NSSV time intervals of SPANSV days to describe the velocity-vector components in units of m s^-1; the similar parameters ending with PV (Peculiar Velocity) are not used in the current release and are reserved for future usage. The first three HDUs contain the coefficients for the three components of the position, while the last three HDUs contain the coefficients for the three components of the velocity", 
     source = "A. Fienga, J. Laskar, H. Manche, M. Gastineau, 19 April 2007, 'Solar system planetary ephemeris delivery: INPOP06', GAIA-CA-TN-IMC-AF-001, issue 1, revision 0", 
     status = "DEPR", 
     basic = true, 
     scalar = false, 
     unit = "") 
    public static final String EARTH_EPHEMERIS; static { EARTH_EPHEMERIS = "Nature/Earth_Ephemeris_004.fits"; } 

    /**
     * Surface gravity of the Earth    
     * <p>
     * Status: CONF<br/>
     * Unit: m s^-2<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Surface gravity of the Earth", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m s^-2") 
    public static final double EARTH_SURFACEGRAVITY; static { EARTH_SURFACEGRAVITY = 9.798; } // [m s^-2] 

    /**
     * Mean surface gravity of the Earth. The value for the International Standard Atmopshere is 9.80665 m s^-2    
     * <p>
     * Source: F. Budnik (ESA), 8 March 2013, 'Gaia FDS-SOC Orbit ICD', GAIA-ESC-ICD-0012, issue 2, revision 0, Annex A. Reference documents: F. Kleijer (Netherlands Geodetic Commission, Delft), 1 April 2004, 'Troposphere Modeling and Filtering for Precise GPS Leveling', Publications on Geodesy 56, ISBN 90 6132 284 7 (http://www.ncg.knaw.nl/Publicaties/Geodesy/pdf/56Kleijer.pdf and http://repository.tudelft.nl/view/ir/uuid%3Aea1f0cf0-4e48-421b-b7ae-4ae3e36d1880/), J. Saastamoinen, 1 January 1972, 'Atmospheric correction for the troposphere and stratosphere in radio ranging of satellites' in 'The use of artificial satellites for geodesy', editors S.W. Henrikson et al., Geophysical Monograph Series, 15, 247-251, and B.R. Bean and E.J. Dutton, 1 March 1966, 'Radio Meteorology', National Bureau of Standards Monograph, 92, 1-44<br/>
     * Status: CONF<br/>
     * Unit: m s^-2<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean surface gravity of the Earth. The value for the International Standard Atmopshere is 9.80665 m s^-2", 
     source = "F. Budnik (ESA), 8 March 2013, 'Gaia FDS-SOC Orbit ICD', GAIA-ESC-ICD-0012, issue 2, revision 0, Annex A. Reference documents: F. Kleijer (Netherlands Geodetic Commission, Delft), 1 April 2004, 'Troposphere Modeling and Filtering for Precise GPS Leveling', Publications on Geodesy 56, ISBN 90 6132 284 7 (http://www.ncg.knaw.nl/Publicaties/Geodesy/pdf/56Kleijer.pdf and http://repository.tudelft.nl/view/ir/uuid%3Aea1f0cf0-4e48-421b-b7ae-4ae3e36d1880/), J. Saastamoinen, 1 January 1972, 'Atmospheric correction for the troposphere and stratosphere in radio ranging of satellites' in 'The use of artificial satellites for geodesy', editors S.W. Henrikson et al., Geophysical Monograph Series, 15, 247-251, and B.R. Bean and E.J. Dutton, 1 March 1966, 'Radio Meteorology', National Bureau of Standards Monograph, 92, 1-44", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "m s^-2") 
    public static final double EARTH_SURFACEGRAVITY_MEAN; static { EARTH_SURFACEGRAVITY_MEAN = 9.784; } // [m s^-2] 

    /**
     * IAU-recommended value for the right ascension \alpha_0 of the north pole of rotation of Earth. The pair (\alpha_0, \delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \alpha_0 = 273.85 deg and \delta_0 = 66.99 degrees. The numerical value shall be used for comparative purposes only    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)<br/>
     * Status: CONF<br/>
     * Unit: deg<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "IAU-recommended value for the right ascension \\alpha_0 of the north pole of rotation of Earth. The pair (\\alpha_0, \\delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \\alpha_0 = 273.85 deg and \\delta_0 = 66.99 degrees. The numerical value shall be used for comparative purposes only", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "deg") 
    public static final double EARTH_NORTHROTATIONALPOLE_RIGHTASCENSION; static { EARTH_NORTHROTATIONALPOLE_RIGHTASCENSION = 0.00; } // [deg] 

    /**
     * IAU-recommended value for the rate of change (in degrees per Julian day, calculated from the standard epoch) of the right ascension \alpha_0 of the north pole of rotation of Earth. The pair (\alpha_0, \delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \alpha_0 = 273.85 deg and \delta_0 = 66.99 degrees. The numerical value shall be used for comparative purposes only    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)<br/>
     * Status: CONF<br/>
     * Unit: deg day^-1<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "IAU-recommended value for the rate of change (in degrees per Julian day, calculated from the standard epoch) of the right ascension \\alpha_0 of the north pole of rotation of Earth. The pair (\\alpha_0, \\delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \\alpha_0 = 273.85 deg and \\delta_0 = 66.99 degrees. The numerical value shall be used for comparative purposes only", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "deg day^-1") 
    public static final double EARTH_NORTHROTATIONALPOLE_RIGHTASCENSIONRATEOFCHANGE; static { EARTH_NORTHROTATIONALPOLE_RIGHTASCENSIONRATEOFCHANGE = -0.00001755; } // [deg day^-1] 

    /**
     * IAU-recommended value for the declination \delta_0 of the north pole of rotation of Earth. The pair (\alpha_0, \delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \alpha_0 = 273.85 deg and \delta_0 = 66.99 degrees. The numerical value shall be used for comparative purposes only    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)<br/>
     * Status: CONF<br/>
     * Unit: deg<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "IAU-recommended value for the declination \\delta_0 of the north pole of rotation of Earth. The pair (\\alpha_0, \\delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \\alpha_0 = 273.85 deg and \\delta_0 = 66.99 degrees. The numerical value shall be used for comparative purposes only", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "deg") 
    public static final double EARTH_NORTHROTATIONALPOLE_DECLINATION; static { EARTH_NORTHROTATIONALPOLE_DECLINATION = 90.00; } // [deg] 

    /**
     * IAU-recommended value for the rate of change (in degrees per Julian day, calculated from the standard epoch) of the declination \delta_0 of the north pole of rotation of Earth. The pair (\alpha_0, \delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \alpha_0 = 273.85 deg and \delta_0 = 66.99 degrees. The numerical value shall be used for comparative purposes only    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)<br/>
     * Status: CONF<br/>
     * Unit: deg day^-1<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "IAU-recommended value for the rate of change (in degrees per Julian day, calculated from the standard epoch) of the declination \\delta_0 of the north pole of rotation of Earth. The pair (\\alpha_0, \\delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \\alpha_0 = 273.85 deg and \\delta_0 = 66.99 degrees. The numerical value shall be used for comparative purposes only", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "deg day^-1") 
    public static final double EARTH_NORTHROTATIONALPOLE_DECLINATIONRATEOFCHANGE; static { EARTH_NORTHROTATIONALPOLE_DECLINATIONRATEOFCHANGE = -0.00001525; } // [deg day^-1] 

    /**
     * IAU-recommended value for the ephemeris position of the prime meridian of Earth. The location of the prime meridian is specified by the angle that is measured along the planet's equator in an easterly direction with respect to the planet's north pole from the node Q (located at right ascension 90 deg + \alpha_0, where \alpha_0 denotes the right ascension of the north pole of rotation) of the planet's equator on the standard equator to the point B where the prime meridian crosses the planet's equator. The right ascension of the point Q is 90 deg + \alpha_0 and the inclination of the planet's equator to the standard equator is 90 deg - \delta_0, where \delta_0 denotes the declination of the north pole of rotation. (The pair (\alpha_0, \delta_0) denotes the standard equatorial coordinates, with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB), of the north pole of rotation, which itself is defined as that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \alpha_0 = 273.85 deg and \delta_0 = 66.99 degrees.) Because the prime meridian is assumed to rotate uniformly with the planet, W accordingly varies linearly with time. In addition, \alpha_0, \delta_0, and W may vary with time due to a precession of the axis of rotation of the planet. If W increases with time, the planet has a direct (or prograde) rotation; if W decreases with time, the rotation is said to be retrograde. The numerical value shall be used for comparative purposes only    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)<br/>
     * Status: CONF<br/>
     * Unit: deg<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "IAU-recommended value for the ephemeris position of the prime meridian of Earth. The location of the prime meridian is specified by the angle that is measured along the planet's equator in an easterly direction with respect to the planet's north pole from the node Q (located at right ascension 90 deg + \\alpha_0, where \\alpha_0 denotes the right ascension of the north pole of rotation) of the planet's equator on the standard equator to the point B where the prime meridian crosses the planet's equator. The right ascension of the point Q is 90 deg + \\alpha_0 and the inclination of the planet's equator to the standard equator is 90 deg - \\delta_0, where \\delta_0 denotes the declination of the north pole of rotation. (The pair (\\alpha_0, \\delta_0) denotes the standard equatorial coordinates, with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB), of the north pole of rotation, which itself is defined as that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \\alpha_0 = 273.85 deg and \\delta_0 = 66.99 degrees.) Because the prime meridian is assumed to rotate uniformly with the planet, W accordingly varies linearly with time. In addition, \\alpha_0, \\delta_0, and W may vary with time due to a precession of the axis of rotation of the planet. If W increases with time, the planet has a direct (or prograde) rotation; if W decreases with time, the rotation is said to be retrograde. The numerical value shall be used for comparative purposes only", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "deg") 
    public static final double EARTH_PRIMEMERIDIAN_EPHEMERISPOSITION; static { EARTH_PRIMEMERIDIAN_EPHEMERISPOSITION = 190.147; } // [deg] 

    /**
     * IAU-recommended value for the rate of change (in degrees per Julian day, calculated from the standard epoch of 1.5 January 2000 = JD2451545.0 TDB) of the ephemeris position of the prime meridian of Earth. The location of the prime meridian is specified by the angle that is measured along the planet's equator in an easterly direction with respect to the planet's north pole from the node Q (located at right ascension 90 deg + \alpha_0, where \alpha_0 denotes the right ascension of the north pole of rotation) of the planet's equator on the standard equator to the point B where the prime meridian crosses the planet's equator. The right ascension of the point Q is 90 deg + \alpha_0 and the inclination of the planet's equator to the standard equator is 90 deg - \delta_0, where \delta_0 denotes the declination of the north pole of rotation. (The pair (\alpha_0, \delta_0) denotes the standard equatorial coordinates, with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB), of the north pole of rotation, which itself is defined as that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \alpha_0 = 273.85 deg and \delta_0 = 66.99 degrees.) Because the prime meridian is assumed to rotate uniformly with the planet, W accordingly varies linearly with time. In addition, \alpha_0, \delta_0, and W may vary with time due to a precession of the axis of rotation of the planet. If W increases with time, the planet has a direct (or prograde) rotation; if W decreases with time, the rotation is said to be retrograde. The numerical value shall be used for comparative purposes only    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)<br/>
     * Status: CONF<br/>
     * Unit: deg day^-1<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "IAU-recommended value for the rate of change (in degrees per Julian day, calculated from the standard epoch of 1.5 January 2000 = JD2451545.0 TDB) of the ephemeris position of the prime meridian of Earth. The location of the prime meridian is specified by the angle that is measured along the planet's equator in an easterly direction with respect to the planet's north pole from the node Q (located at right ascension 90 deg + \\alpha_0, where \\alpha_0 denotes the right ascension of the north pole of rotation) of the planet's equator on the standard equator to the point B where the prime meridian crosses the planet's equator. The right ascension of the point Q is 90 deg + \\alpha_0 and the inclination of the planet's equator to the standard equator is 90 deg - \\delta_0, where \\delta_0 denotes the declination of the north pole of rotation. (The pair (\\alpha_0, \\delta_0) denotes the standard equatorial coordinates, with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB), of the north pole of rotation, which itself is defined as that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \\alpha_0 = 273.85 deg and \\delta_0 = 66.99 degrees.) Because the prime meridian is assumed to rotate uniformly with the planet, W accordingly varies linearly with time. In addition, \\alpha_0, \\delta_0, and W may vary with time due to a precession of the axis of rotation of the planet. If W increases with time, the planet has a direct (or prograde) rotation; if W decreases with time, the rotation is said to be retrograde. The numerical value shall be used for comparative purposes only", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "deg day^-1") 
    public static final double EARTH_PRIMEMERIDIAN_EPHEMERISPOSITIONRATEOFCHANGE; static { EARTH_PRIMEMERIDIAN_EPHEMERISPOSITIONRATEOFCHANGE = 360.9856235; } // [deg day^-1] 

    /**
     * Geocentric gravitational constant (TCB-compatible value), including the Earth's atmosphere but excluding the mass of the Moon    
     * <p>
     * Status: CONF<br/>
     * Unit: m^3 s^-2<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Geocentric gravitational constant (TCB-compatible value), including the Earth's atmosphere but excluding the mass of the Moon", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m^3 s^-2") 
    public static final double EARTH_GM; static { EARTH_GM = 3.9860044180e+14; } // [m^3 s^-2] 

    /**
     * Earth mass, including its atmosphere but excluding the mass of the Moon    
     * <p>
     * Status: CONF<br/>
     * Unit: kg<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Earth mass, including its atmosphere but excluding the mass of the Moon", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "kg") 
    public static final double EARTH_MASS; static { EARTH_MASS = 5.97237e+24; } // [kg] 

    /**
     * Mean mass density of the Earth    
     * <p>
     * Status: CONF<br/>
     * Unit: g cm^-3<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean mass density of the Earth", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "g cm^-3") 
    public static final double EARTH_MASSDENSITY_MEAN; static { EARTH_MASSDENSITY_MEAN = 5.514; } // [g cm^-3] 

    /**
     * Equatorial radius of the Earth    
     * <p>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Equatorial radius of the Earth", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m") 
    public static final double EARTH_EQUATORIALRADIUS; static { EARTH_EQUATORIALRADIUS = 6.37813660e+6; } // [m] 

    /**
     * Mean polar radius of the Earth    
     * <p>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean polar radius of the Earth", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m") 
    public static final double EARTH_POLARRADIUS; static { EARTH_POLARRADIUS = 6.35675186e+6; } // [m] 

    /**
     * Mean volumetric radius of the Earth    
     * <p>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean volumetric radius of the Earth", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m") 
    public static final double EARTH_VOLUMETRICRADIUS; static { EARTH_VOLUMETRICRADIUS = 6.371000e+6; } // [m] 

    /**
     * Mean radius of the Earth    
     * <p>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean radius of the Earth", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m") 
    public static final double EARTH_RADIUS_MEAN; static { EARTH_RADIUS_MEAN = 6.371008e+6; } // [m] 

    /**
     * Geometrical flattening factor f of the Earth (f = (a-b)/a); this quantity is also refered to as ellipticity, but is not identical to eccentricity    
     * <p>
     * Status: CONF<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Geometrical flattening factor f of the Earth (f = (a-b)/a); this quantity is also refered to as ellipticity, but is not identical to eccentricity", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "") 
    public static final double EARTH_FLATTENING; static { EARTH_FLATTENING = 3.352819698e-3; } 

    /**
     * Eccentricity e of the Earth (its shape, not its orbit)    
     * <p>
     * Status: CONF<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Eccentricity e of the Earth (its shape, not its orbit)", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "") 
    public static final double EARTH_ECCENTRICITY; static { EARTH_ECCENTRICITY = 8.181930088e-2; } 

    /**
     * V(1,0) magnitude of the Earth (i.e., the visual magnitude of the planet reduced to a distance of 1 au from both the Sun and Earth and phase angle zero). This parameter is also refered to as absolute magnitude in planetary sciences    
     * <p>
     * Source: P.K. Seidelmann, 1992, 'Explanatory Supplement to the Astronomical Almanac', University Science Books, Mill Valley, Ca., ISBN 0-935702-68-7, Table 15.8 on page 706; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par<br/>
     * Status: CONF<br/>
     * Unit: mag<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "V(1,0) magnitude of the Earth (i.e., the visual magnitude of the planet reduced to a distance of 1 au from both the Sun and Earth and phase angle zero). This parameter is also refered to as absolute magnitude in planetary sciences", 
     source = "P.K. Seidelmann, 1992, 'Explanatory Supplement to the Astronomical Almanac', University Science Books, Mill Valley, Ca., ISBN 0-935702-68-7, Table 15.8 on page 706; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "mag") 
    public static final double EARTH_VONEZEROMAGNITUDE; static { EARTH_VONEZEROMAGNITUDE = -3.86; } // [mag] 

    /**
     * Geometric albedo of the Earth (i.e., the ratio of the body's brightness at zero phase angle to the brightness of a perfectly diffusing disk with the same position and apparent size as the body)    
     * <p>
     * Source: P.K. Seidelmann, 1992, 'Explanatory Supplement to the Astronomical Almanac', University Science Books, Mill Valley, Ca., ISBN 0-935702-68-7, Table 15.8 on page 706; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Geometric albedo of the Earth (i.e., the ratio of the body's brightness at zero phase angle to the brightness of a perfectly diffusing disk with the same position and apparent size as the body)", 
     source = "P.K. Seidelmann, 1992, 'Explanatory Supplement to the Astronomical Almanac', University Science Books, Mill Valley, Ca., ISBN 0-935702-68-7, Table 15.8 on page 706; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double EARTH_GEOMETRICALBEDO; static { EARTH_GEOMETRICALBEDO = 0.367; } 

    /**
     * Radius of the smallest hypothetical sphere around the Earth which would encompass the body (this is a low-accuracy parameter used in the relativistic model)    
     * <p>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Radius of the smallest hypothetical sphere around the Earth which would encompass the body (this is a low-accuracy parameter used in the relativistic model)", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m") 
    public static final double EARTH_ENCOMPASSINGSPHERERADIUS; static { EARTH_ENCOMPASSINGSPHERERADIUS = 6378137.; } // [m] 

    /**
     * Mean orbital speed of the Earth (mean velocity over an unperturbed elliptic orbit). The equation is accurate to 4-th order in EMBC_OrbitalEccentricity_J2000    
     * <p>
     * Status: CONF<br/>
     * Unit: m s^-1<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean orbital speed of the Earth (mean velocity over an unperturbed elliptic orbit). The equation is accurate to 4-th order in EMBC_OrbitalEccentricity_J2000", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m s^-1") 
    public static final double EARTH_ORBITALSPEED_MEAN; static { EARTH_ORBITALSPEED_MEAN = 2.97827e+4; } // [m s^-1] 

    /**
     * Nominal equatorial radius of the Earth (zero-frequency-tide value), in SI units. This nominal value shall be understood as conversion factor only    
     * <p>
     * Source: E. Mamajek, et al., 2015, 'IAU 2015 Resolution B3 on Recommended Nominal Conversion Constants for Selected Solar and Planetary Properties', arXiv:1510.07674 (see also https://www.iau.org/administration/resolutions/general_assemblies/)<br/>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Nominal equatorial radius of the Earth (zero-frequency-tide value), in SI units. This nominal value shall be understood as conversion factor only", 
     source = "E. Mamajek, et al., 2015, 'IAU 2015 Resolution B3 on Recommended Nominal Conversion Constants for Selected Solar and Planetary Properties', arXiv:1510.07674 (see also https://www.iau.org/administration/resolutions/general_assemblies/)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "m") 
    public static final double EARTH_EQUATORIALRADIUS_NOMINAL; static { EARTH_EQUATORIALRADIUS_NOMINAL = 6.37810e+6; } // [m] 

    /**
     * Nominal polar radius of the Earth (zero-frequency-tide value), in SI units. This nominal value shall be understood as conversion factor only    
     * <p>
     * Source: E. Mamajek, et al., 2015, 'IAU 2015 Resolution B3 on Recommended Nominal Conversion Constants for Selected Solar and Planetary Properties', arXiv:1510.07674 (see also https://www.iau.org/administration/resolutions/general_assemblies/)<br/>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Nominal polar radius of the Earth (zero-frequency-tide value), in SI units. This nominal value shall be understood as conversion factor only", 
     source = "E. Mamajek, et al., 2015, 'IAU 2015 Resolution B3 on Recommended Nominal Conversion Constants for Selected Solar and Planetary Properties', arXiv:1510.07674 (see also https://www.iau.org/administration/resolutions/general_assemblies/)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "m") 
    public static final double EARTH_POLARRADIUS_NOMINAL; static { EARTH_POLARRADIUS_NOMINAL = 6.35680e+6; } // [m] 

    /**
     * Nominal GM of the Earth, in SI units. This nominal value shall be understood as conversion factor only    
     * <p>
     * Source: E. Mamajek, et al., 2015, 'IAU 2015 Resolution B3 on Recommended Nominal Conversion Constants for Selected Solar and Planetary Properties', arXiv:1510.07674 (see also https://www.iau.org/administration/resolutions/general_assemblies/)<br/>
     * Status: CONF<br/>
     * Unit: m^3 s^-2<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Nominal GM of the Earth, in SI units. This nominal value shall be understood as conversion factor only", 
     source = "E. Mamajek, et al., 2015, 'IAU 2015 Resolution B3 on Recommended Nominal Conversion Constants for Selected Solar and Planetary Properties', arXiv:1510.07674 (see also https://www.iau.org/administration/resolutions/general_assemblies/)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "m^3 s^-2") 
    public static final double EARTH_GM_NOMINAL; static { EARTH_GM_NOMINAL = 3.9860040e+14; } // [m^3 s^-2] 

    /**
     * Geometric transit probability (Earth transiting the Sun) for an observer external to the solar system    
     * <p>
     * Source: E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 2.1, Equation 2.2, page 14<br/>
     * Status: CONF<br/>
     * Unit: %<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Geometric transit probability (Earth transiting the Sun) for an observer external to the solar system", 
     source = "E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 2.1, Equation 2.2, page 14", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "%") 
    public static final double EARTH_TRANSITPROBABILITY; static { EARTH_TRANSITPROBABILITY = 0.469; } // [%] 

    /**
     * Maximum reduction of the solar flux for an observer external to the solar system during a transit of Earth    
     * <p>
     * Source: E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 2.2, Equation 2.4, page 14<br/>
     * Status: CONF<br/>
     * Unit: %<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Maximum reduction of the solar flux for an observer external to the solar system during a transit of Earth", 
     source = "E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 2.2, Equation 2.4, page 14", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "%") 
    public static final double EARTH_FLUXREDUCTION_MAXIMUM; static { EARTH_FLUXREDUCTION_MAXIMUM = 0.008; } // [%] 

    /**
     * Maximum transit time of Earth (transiting the Sun) for an observer external to the solar system    
     * <p>
     * Source: E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 2.3, Equation 2.5, page 15<br/>
     * Status: CONF<br/>
     * Unit: day<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Maximum transit time of Earth (transiting the Sun) for an observer external to the solar system", 
     source = "E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 2.3, Equation 2.5, page 15", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "day") 
    public static final double EARTH_TRANSITTIME_MAXIMUM; static { EARTH_TRANSITTIME_MAXIMUM = 0.55; } // [day] 

    /**
     * Geocentric gravitational constant (TCB-compatible value), including the Earth's atmosphere but excluding the mass of the Moon    
     * <p>
     * Source: The IAU (2009) System of Astronomical Constants (IAU, August 2009, 'IAU 2009 Astronomical Constants', IAU 2009 Resolution B2 adopted at the XXVII-th General Assembly of the IAU. See also IAU, 10 August 2009, 'IAU WG on NSFA Current Best Estimates', http://maia.usno.navy.mil/NSFA/NSFA_cbe.html)<br/>
     * Status: CONF<br/>
     * Unit: m^3 s^-2<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Geocentric gravitational constant (TCB-compatible value), including the Earth's atmosphere but excluding the mass of the Moon", 
     source = "The IAU (2009) System of Astronomical Constants (IAU, August 2009, 'IAU 2009 Astronomical Constants', IAU 2009 Resolution B2 adopted at the XXVII-th General Assembly of the IAU. See also IAU, 10 August 2009, 'IAU WG on NSFA Current Best Estimates', http://maia.usno.navy.mil/NSFA/NSFA_cbe.html)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "m^3 s^-2") 
    public static final double EARTHELLIPSOID_GM; static { EARTHELLIPSOID_GM = 3.9860044180e+14; } // [m^3 s^-2] 

    /**
     * Semi-major axis of the Earth reference ellipsoid (zero-frequency-tide value)    
     * <p>
     * Source: Numerical value is zero-frequency-tide value from E. Groten, 2000, 'Report of Special Commission 3 of IAG', in Proceedings of IAU Colloquium 180, 'Towards models and constants for sub-microarcsecond astrometry', eds K.J. Johnston, D.D. McCarthy, B.J. Luzum, G.H. Kaplan, page 337. See also the IAU (2009) System of Astronomical Constants (IAU, August 2009, 'IAU 2009 Astronomical Constants', IAU 2009 Resolution B2 adopted at the XXVII-th General Assembly of the IAU. See also IAU, 10 August 2009, 'IAU WG on NSFA Current Best Estimates', http://maia.usno.navy.mil/NSFA/NSFA_cbe.html)<br/>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Semi-major axis of the Earth reference ellipsoid (zero-frequency-tide value)", 
     source = "Numerical value is zero-frequency-tide value from E. Groten, 2000, 'Report of Special Commission 3 of IAG', in Proceedings of IAU Colloquium 180, 'Towards models and constants for sub-microarcsecond astrometry', eds K.J. Johnston, D.D. McCarthy, B.J. Luzum, G.H. Kaplan, page 337. See also the IAU (2009) System of Astronomical Constants (IAU, August 2009, 'IAU 2009 Astronomical Constants', IAU 2009 Resolution B2 adopted at the XXVII-th General Assembly of the IAU. See also IAU, 10 August 2009, 'IAU WG on NSFA Current Best Estimates', http://maia.usno.navy.mil/NSFA/NSFA_cbe.html)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "m") 
    public static final double EARTHELLIPSOID_SEMIMAJORAXIS_ZEROFREQUENCYTIDE; static { EARTHELLIPSOID_SEMIMAJORAXIS_ZEROFREQUENCYTIDE = 6378136.6; } // [m] 

    /**
     * Nominal mean angular velocity of the Earth    
     * <p>
     * Source: Numerical value is from E. Groten, 2000, 'Report of Special Commission 3 of IAG', in Proceedings of IAU Colloquium 180, 'Towards models and constants for sub-microarcsecond astrometry', eds K.J. Johnston, D.D. McCarthy, B.J. Luzum, G.H. Kaplan, page 337. See also the IAU (2009) System of Astronomical Constants (IAU, August 2009, 'IAU 2009 Astronomical Constants', IAU 2009 Resolution B2 adopted at the XXVII-th General Assembly of the IAU. See also IAU, 10 August 2009, 'IAU WG on NSFA Current Best Estimates', http://maia.usno.navy.mil/NSFA/NSFA_cbe.html)<br/>
     * Status: CONF<br/>
     * Unit: rad s^-1<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Nominal mean angular velocity of the Earth", 
     source = "Numerical value is from E. Groten, 2000, 'Report of Special Commission 3 of IAG', in Proceedings of IAU Colloquium 180, 'Towards models and constants for sub-microarcsecond astrometry', eds K.J. Johnston, D.D. McCarthy, B.J. Luzum, G.H. Kaplan, page 337. See also the IAU (2009) System of Astronomical Constants (IAU, August 2009, 'IAU 2009 Astronomical Constants', IAU 2009 Resolution B2 adopted at the XXVII-th General Assembly of the IAU. See also IAU, 10 August 2009, 'IAU WG on NSFA Current Best Estimates', http://maia.usno.navy.mil/NSFA/NSFA_cbe.html)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "rad s^-1") 
    public static final double EARTHELLIPSOID_SPINRATE_NOMINAL; static { EARTHELLIPSOID_SPINRATE_NOMINAL = 7.2921150e-5; } // [rad s^-1] 

    /**
     * Potential of the geoid    
     * <p>
     * Source: Numerical value is from E. Groten, 2000, 'Report of Special Commission 3 of IAG', in Proceedings of IAU Colloquium 180, 'Towards models and constants for sub-microarcsecond astrometry', eds K.J. Johnston, D.D. McCarthy, B.J. Luzum, G.H. Kaplan, page 337. See also the IAU (2009) System of Astronomical Constants (IAU, August 2009, 'IAU 2009 Astronomical Constants', IAU 2009 Resolution B2 adopted at the XXVII-th General Assembly of the IAU. See also IAU, 10 August 2009, 'IAU WG on NSFA Current Best Estimates', http://maia.usno.navy.mil/NSFA/NSFA_cbe.html)<br/>
     * Status: CONF<br/>
     * Unit: m^2 s^-2<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Potential of the geoid", 
     source = "Numerical value is from E. Groten, 2000, 'Report of Special Commission 3 of IAG', in Proceedings of IAU Colloquium 180, 'Towards models and constants for sub-microarcsecond astrometry', eds K.J. Johnston, D.D. McCarthy, B.J. Luzum, G.H. Kaplan, page 337. See also the IAU (2009) System of Astronomical Constants (IAU, August 2009, 'IAU 2009 Astronomical Constants', IAU 2009 Resolution B2 adopted at the XXVII-th General Assembly of the IAU. See also IAU, 10 August 2009, 'IAU WG on NSFA Current Best Estimates', http://maia.usno.navy.mil/NSFA/NSFA_cbe.html)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "m^2 s^-2") 
    public static final double EARTHELLIPSOID_WSUB0; static { EARTHELLIPSOID_WSUB0 = 6.263685600e+7; } // [m^2 s^-2] 

    /**
     * Geopotential scale factor    
     * <p>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Geopotential scale factor", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m") 
    public static final double EARTHELLIPSOID_RSUB0; static { EARTHELLIPSOID_RSUB0 = 6.36367256e+6; } // [m] 

    /**
     * Dynamical form-factor of the Earth, i.e., second-degree zonal harmonic of the geopotential including the indirect tidal distortion on J_2, i.e., in the zero-frequency-tide system JGM-3. The (long-term) rate of change of this parameter equals -3.001E-9 cy^-1    
     * <p>
     * Source: Numerical value is zero-frequency-tide value from E. Groten, 2000, 'Report of Special Commission 3 of IAG', in Proceedings of IAU Colloquium 180, 'Towards models and constants for sub-microarcsecond astrometry', eds K.J. Johnston, D.D. McCarthy, B.J. Luzum, G.H. Kaplan, page 337. See also the IAU (2009) System of Astronomical Constants (IAU, August 2009, 'IAU 2009 Astronomical Constants', IAU 2009 Resolution B2 adopted at the XXVII-th General Assembly of the IAU. See also IAU, 10 August 2009, 'IAU WG on NSFA Current Best Estimates', http://maia.usno.navy.mil/NSFA/NSFA_cbe.html)<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Dynamical form-factor of the Earth, i.e., second-degree zonal harmonic of the geopotential including the indirect tidal distortion on J_2, i.e., in the zero-frequency-tide system JGM-3. The (long-term) rate of change of this parameter equals -3.001E-9 cy^-1", 
     source = "Numerical value is zero-frequency-tide value from E. Groten, 2000, 'Report of Special Commission 3 of IAG', in Proceedings of IAU Colloquium 180, 'Towards models and constants for sub-microarcsecond astrometry', eds K.J. Johnston, D.D. McCarthy, B.J. Luzum, G.H. Kaplan, page 337. See also the IAU (2009) System of Astronomical Constants (IAU, August 2009, 'IAU 2009 Astronomical Constants', IAU 2009 Resolution B2 adopted at the XXVII-th General Assembly of the IAU. See also IAU, 10 August 2009, 'IAU WG on NSFA Current Best Estimates', http://maia.usno.navy.mil/NSFA/NSFA_cbe.html)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double EARTHELLIPSOID_JSUB2_ZEROFREQUENCYTIDE; static { EARTHELLIPSOID_JSUB2_ZEROFREQUENCYTIDE = 1.08263590e-3; } 

    /**
     * Inverse of the geometrical flattening factor f of the Earth (f = (a-b)/a; zero-frequency-tide value)    
     * <p>
     * Source: Numerical value is zero-frequency-tide value from E. Groten, 2000, 'Report of Special Commission 3 of IAG', in Proceedings of IAU Colloquium 180, 'Towards models and constants for sub-microarcsecond astrometry', eds K.J. Johnston, D.D. McCarthy, B.J. Luzum, G.H. Kaplan, page 337<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Inverse of the geometrical flattening factor f of the Earth (f = (a-b)/a; zero-frequency-tide value)", 
     source = "Numerical value is zero-frequency-tide value from E. Groten, 2000, 'Report of Special Commission 3 of IAG', in Proceedings of IAU Colloquium 180, 'Towards models and constants for sub-microarcsecond astrometry', eds K.J. Johnston, D.D. McCarthy, B.J. Luzum, G.H. Kaplan, page 337", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double EARTHELLIPSOID_INVERSEFLATTENING_ZEROFREQUENCYTIDE; static { EARTHELLIPSOID_INVERSEFLATTENING_ZEROFREQUENCYTIDE = 298.25642; } 

    /**
     * Radial-velocity amplitude of the Sun induced by the Earth system for 'an edge-on observer' (i.e., an observer in the orbital plane of the Earth system)    
     * <p>
     * Source: E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 1.4, Equation 1.18, page 9<br/>
     * Status: CONF<br/>
     * Unit: m s^-1<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Radial-velocity amplitude of the Sun induced by the Earth system for 'an edge-on observer' (i.e., an observer in the orbital plane of the Earth system)", 
     source = "E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 1.4, Equation 1.18, page 9", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m s^-1") 
    public static final double EARTHSYSTEM_RADIALVELOCITYSIGNATURE; static { EARTHSYSTEM_RADIALVELOCITYSIGNATURE = 0.091; } // [m s^-1] 

    /**
     * Sidereal orbital period    
     * <p>
     * Source: Values derived from the mean longitude rates in Table 5.8.1 in P.K. Seidelmann, 1992, 'Explanatory Supplement to the Astronomical Almanac', University Science Books, Mill Valley, Ca., ISBN 0-935702-68-7, page 316; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par<br/>
     * Status: CONF<br/>
     * Unit: yr<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Sidereal orbital period", 
     source = "Values derived from the mean longitude rates in Table 5.8.1 in P.K. Seidelmann, 1992, 'Explanatory Supplement to the Astronomical Almanac', University Science Books, Mill Valley, Ca., ISBN 0-935702-68-7, page 316; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "yr") 
    public static final double EARTHSYSTEM_ORBITALPERIOD; static { EARTHSYSTEM_ORBITALPERIOD = 1.0000174; } // [yr] 

    /**
     * Astrometric signature of the Sun induced by the Earth system for an observer located at a distance of 10 pc from the Sun    
     * <p>
     * Source: E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 1.7, Equation 1.22, page 11<br/>
     * Status: CONF<br/>
     * Unit: 10^-6 arcsec<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Astrometric signature of the Sun induced by the Earth system for an observer located at a distance of 10 pc from the Sun", 
     source = "E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 1.7, Equation 1.22, page 11", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "10^-6 arcsec") 
    public static final double EARTHSYSTEM_ASTROMETRICSIGNATURE_10PARSEC; static { EARTHSYSTEM_ASTROMETRICSIGNATURE_10PARSEC = 0.304; } // [10^-6 arcsec] 

    /**
     * Ratio of Earth to Moon mass    
     * <p>
     * Status: CONF<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Ratio of Earth to Moon mass", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "") 
    public static final double EARTHTOMOON_MASSRATIO; static { EARTHTOMOON_MASSRATIO = 81.30057; } 

    /**
     * Electric constant (defining constant)    
     * <p>
     * Status: CONF<br/>
     * Unit: F m^-1<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Electric constant (defining constant)", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "F m^-1") 
    public static final double ELECTRIC_CONSTANT; static { ELECTRIC_CONSTANT = 8.854187817620389e-12; } // [F m^-1] 

    /**
     * Electron mass    
     * <p>
     * Source: P.J. Mohr, B.N. Taylor, D.B. Newell, 9 July 2015, 'The 2014 CODATA Recommended Values of the Fundamental Physical Constants', National Institute of Standards and Technology, Gaithersburg, MD 20899-8401; http://www.codata.org/ and http://physics.nist.gov/constants (Web Version 7.0)<br/>
     * Status: CONF<br/>
     * Unit: kg<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Electron mass", 
     source = "P.J. Mohr, B.N. Taylor, D.B. Newell, 9 July 2015, 'The 2014 CODATA Recommended Values of the Fundamental Physical Constants', National Institute of Standards and Technology, Gaithersburg, MD 20899-8401; http://www.codata.org/ and http://physics.nist.gov/constants (Web Version 7.0)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "kg") 
    public static final double ELECTRON_MASS; static { ELECTRON_MASS = 9.109383560e-31; } // [kg] 

    /**
     * Classical electron radius. Note: best-measured value equals 2.8179403227E-15 (P.J. Mohr, B.N. Taylor, D.B. Newell, 9 July 2015, 'The 2014 CODATA Recommended Values of the Fundamental Physical Constants', National Institute of Standards and Technology, Gaithersburg, MD 20899-8401; http://www.codata.org/ and http://physics.nist.gov/constants (Web Version 7.0))    
     * <p>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Classical electron radius. Note: best-measured value equals 2.8179403227E-15 (P.J. Mohr, B.N. Taylor, D.B. Newell, 9 July 2015, 'The 2014 CODATA Recommended Values of the Fundamental Physical Constants', National Institute of Standards and Technology, Gaithersburg, MD 20899-8401; http://www.codata.org/ and http://physics.nist.gov/constants (Web Version 7.0))", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m") 
    public static final double ELECTRON_CLASSICALRADIUS; static { ELECTRON_CLASSICALRADIUS = 2.81794032201e-15; } // [m] 

    /**
     * Thomson free-electron-scattering absorption coefficient (cross section per electron). Note: best-measured value equals 0.66524587158E-28 (P.J. Mohr, B.N. Taylor, D.B. Newell, 9 July 2015, 'The 2014 CODATA Recommended Values of the Fundamental Physical Constants', National Institute of Standards and Technology, Gaithersburg, MD 20899-8401; http://www.codata.org/ and http://physics.nist.gov/constants (Web Version 7.0))    
     * <p>
     * Source: E.g., R. Kippenhahn, A. Weigert, 1991, 'Stellar structure and evolution' (corrected 2-nd printing), Springer Verlag, Berlin, Section 17, Equation 17.1, page 137<br/>
     * Status: CONF<br/>
     * Unit: m^2<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Thomson free-electron-scattering absorption coefficient (cross section per electron). Note: best-measured value equals 0.66524587158E-28 (P.J. Mohr, B.N. Taylor, D.B. Newell, 9 July 2015, 'The 2014 CODATA Recommended Values of the Fundamental Physical Constants', National Institute of Standards and Technology, Gaithersburg, MD 20899-8401; http://www.codata.org/ and http://physics.nist.gov/constants (Web Version 7.0))", 
     source = "E.g., R. Kippenhahn, A. Weigert, 1991, 'Stellar structure and evolution' (corrected 2-nd printing), Springer Verlag, Berlin, Section 17, Equation 17.1, page 137", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m^2") 
    public static final double ELECTRON_CROSSSECTION_THOMSONSCATTERING; static { ELECTRON_CROSSSECTION_THOMSONSCATTERING = 6.65245871237e-29; } // [m^2] 

    /**
     * Elementary charge    
     * <p>
     * Source: P.J. Mohr, B.N. Taylor, D.B. Newell, 9 July 2015, 'The 2014 CODATA Recommended Values of the Fundamental Physical Constants', National Institute of Standards and Technology, Gaithersburg, MD 20899-8401; http://www.codata.org/ and http://physics.nist.gov/constants (Web Version 7.0)<br/>
     * Status: CONF<br/>
     * Unit: C<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Elementary charge", 
     source = "P.J. Mohr, B.N. Taylor, D.B. Newell, 9 July 2015, 'The 2014 CODATA Recommended Values of the Fundamental Physical Constants', National Institute of Standards and Technology, Gaithersburg, MD 20899-8401; http://www.codata.org/ and http://physics.nist.gov/constants (Web Version 7.0)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "C") 
    public static final double ELEMENTARYCHARGE_CONSTANT; static { ELEMENTARYCHARGE_CONSTANT = 1.60217662080e-19; } // [C] 

    /**
     * Mean orbital semi-major axis of the Earth-Moon barycentre (EMBC) orbit, at the standard epoch J2000.0. The mean orbital semi-major axis is associated with a mean orbit solution from a 250-year least-squares fit of JPL's DE405 ephemeris to a Keplerian orbit covering the interval of years 1800 AD - 2050 AD. In this fit, each orbital element is allowed to vary linearly with time (the resulting evolution of the orbital semi-major axis is 0.00000562 au per century). The orbital element is referenced to the mean ecliptic and equinox of J2000 at the standard epoch J2000.0. This solution fits the DE405 orbit of the Earth-Moon barycentre to about 22 arcsec. DE405 is based upon the International Celestial Reference Frame (ICRF)    
     * <p>
     * Source: E.M. Standish, 16 February 2006, 'Keplerian Elements for Approximate Positions of the Major Planets', http://ssd.jpl.nasa.gov/?planets\#elem<br/>
     * Status: CONF<br/>
     * Unit: au<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean orbital semi-major axis of the Earth-Moon barycentre (EMBC) orbit, at the standard epoch J2000.0. The mean orbital semi-major axis is associated with a mean orbit solution from a 250-year least-squares fit of JPL's DE405 ephemeris to a Keplerian orbit covering the interval of years 1800 AD - 2050 AD. In this fit, each orbital element is allowed to vary linearly with time (the resulting evolution of the orbital semi-major axis is 0.00000562 au per century). The orbital element is referenced to the mean ecliptic and equinox of J2000 at the standard epoch J2000.0. This solution fits the DE405 orbit of the Earth-Moon barycentre to about 22 arcsec. DE405 is based upon the International Celestial Reference Frame (ICRF)", 
     source = "E.M. Standish, 16 February 2006, 'Keplerian Elements for Approximate Positions of the Major Planets', http://ssd.jpl.nasa.gov/?planets\\#elem", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "au") 
    public static final double EMBC_ORBITALSEMIMAJORAXIS_J2000; static { EMBC_ORBITALSEMIMAJORAXIS_J2000 = 1.00000261; } // [au] 

    /**
     * Mean orbital eccentricity of the Earth-Moon barycentre (EMBC) orbit, at the standard epoch J2000.0. The mean orbital eccentricity is associated with a mean orbit solution from a 250-year least-squares fit of JPL's DE405 ephemeris to a Keplerian orbit covering the interval of years 1800 AD - 2050 AD. In this fit, each orbital element is allowed to vary linearly with time (the resulting evolution of the orbital eccentricity is -0.00004392 radians per century). The orbital element is referenced to the mean ecliptic and equinox of J2000 at the standard epoch J2000.0. This solution fits the DE405 orbit of the Earth-Moon barycentre to about 22 arcsec. DE405 is based upon the International Celestial Reference Frame (ICRF)    
     * <p>
     * Source: E.M. Standish, 16 February 2006, 'Keplerian Elements for Approximate Positions of the Major Planets', http://ssd.jpl.nasa.gov/?planets\#elem<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean orbital eccentricity of the Earth-Moon barycentre (EMBC) orbit, at the standard epoch J2000.0. The mean orbital eccentricity is associated with a mean orbit solution from a 250-year least-squares fit of JPL's DE405 ephemeris to a Keplerian orbit covering the interval of years 1800 AD - 2050 AD. In this fit, each orbital element is allowed to vary linearly with time (the resulting evolution of the orbital eccentricity is -0.00004392 radians per century). The orbital element is referenced to the mean ecliptic and equinox of J2000 at the standard epoch J2000.0. This solution fits the DE405 orbit of the Earth-Moon barycentre to about 22 arcsec. DE405 is based upon the International Celestial Reference Frame (ICRF)", 
     source = "E.M. Standish, 16 February 2006, 'Keplerian Elements for Approximate Positions of the Major Planets', http://ssd.jpl.nasa.gov/?planets\\#elem", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double EMBC_ORBITALECCENTRICITY_J2000; static { EMBC_ORBITALECCENTRICITY_J2000 = 0.01671123; } 

    /**
     * Mean orbital inclination of the Earth-Moon barycentre (EMBC) orbit, at the standard epoch J2000.0. The mean orbital inclination is associated with a mean orbit solution from a 250-year least-squares fit of JPL's DE405 ephemeris to a Keplerian orbit covering the interval of years 1800 AD - 2050 AD. In this fit, each orbital element is allowed to vary linearly with time (the resulting evolution of the orbital inclination is -0.01294668 degrees per century). The orbital element is referenced to the mean ecliptic and equinox of J2000 at the standard epoch J2000.0. This solution fits the DE405 orbit of the Earth-Moon barycentre to about 22 arcsec. DE405 is based upon the International Celestial Reference Frame (ICRF)    
     * <p>
     * Source: E.M. Standish, 16 February 2006, 'Keplerian Elements for Approximate Positions of the Major Planets', http://ssd.jpl.nasa.gov/?planets\#elem<br/>
     * Status: CONF<br/>
     * Unit: deg<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean orbital inclination of the Earth-Moon barycentre (EMBC) orbit, at the standard epoch J2000.0. The mean orbital inclination is associated with a mean orbit solution from a 250-year least-squares fit of JPL's DE405 ephemeris to a Keplerian orbit covering the interval of years 1800 AD - 2050 AD. In this fit, each orbital element is allowed to vary linearly with time (the resulting evolution of the orbital inclination is -0.01294668 degrees per century). The orbital element is referenced to the mean ecliptic and equinox of J2000 at the standard epoch J2000.0. This solution fits the DE405 orbit of the Earth-Moon barycentre to about 22 arcsec. DE405 is based upon the International Celestial Reference Frame (ICRF)", 
     source = "E.M. Standish, 16 February 2006, 'Keplerian Elements for Approximate Positions of the Major Planets', http://ssd.jpl.nasa.gov/?planets\\#elem", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "deg") 
    public static final double EMBC_ORBITALINCLINATION_J2000; static { EMBC_ORBITALINCLINATION_J2000 = -0.00001531; } // [deg] 

    /**
     * One erg expressed in units of J. Note that 'erg' is a non-SI unit which should not be used    
     * <p>
     * Status: CONF<br/>
     * Unit: J<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "One erg expressed in units of J. Note that 'erg' is a non-SI unit which should not be used", 
     source = "", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "J") 
    public static final double ERG_JOULE; static { ERG_JOULE = 1.0e-7; } // [J] 

    /**
     * Interstellar extinction curve (see also J.H.J. de Bruijne, 26 May 2003, 'Stellar fluxes: transformations and calibrations', GAIA-JdB-005, issue 1, revision 1). First column: wavelength \lambda (in nm; \lambda = 200.0 to 1100.0). Second column: normalised interstellar extinction A(\lambda) / A(\lambda_{ref}) with \lambda_{ref} = 1000 / 1.82 = 549.45 nm. Note that it has become customary within the Gaia community to denote A(\lambda_{ref}) for \lambda_{ref} = 1000 / 1.82 = 549.45 nm as A(550 nm)    
     * <p>
     * Source: J.A. Cardelli, G.C. Clayton, J.S. Mathis, 1989, 'The relationship between infrared, optical, and ultraviolet extinction', Astrophysical Journal (ApJ), 345, 245<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: false
     */
    @ParamMetaData (
    description = "Interstellar extinction curve (see also J.H.J. de Bruijne, 26 May 2003, 'Stellar fluxes: transformations and calibrations', GAIA-JdB-005, issue 1, revision 1). First column: wavelength \\lambda (in nm; \\lambda = 200.0 to 1100.0). Second column: normalised interstellar extinction A(\\lambda) / A(\\lambda_{ref}) with \\lambda_{ref} = 1000 / 1.82 = 549.45 nm. Note that it has become customary within the Gaia community to denote A(\\lambda_{ref}) for \\lambda_{ref} = 1000 / 1.82 = 549.45 nm as A(550 nm)", 
     source = "J.A. Cardelli, G.C. Clayton, J.S. Mathis, 1989, 'The relationship between infrared, optical, and ultraviolet extinction', Astrophysical Journal (ApJ), 345, 245", 
     status = "CONF", 
     basic = true, 
     scalar = false, 
     unit = "") 
    public static final String EXTINCTION_CURVE; static { EXTINCTION_CURVE = "Nature/Extinction_Curve_002.fits"; } 

    /**
     * Ratio of total to selective absorption (typical value). One has: R_V = A_V / E(B-V), where A_V is the total extinction in the Johnson V band and E(B-V) is the colour excess (see also J.H.J. de Bruijne, 26 May 2003, 'Stellar fluxes: transformations and calibrations', GAIA-JdB-005, issue 1, revision 1)    
     * <p>
     * Source: J.A. Cardelli, G.C. Clayton, J.S. Mathis, 1989, 'The relationship between infrared, optical, and ultraviolet extinction', Astrophysical Journal (ApJ), 345, 245<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Ratio of total to selective absorption (typical value). One has: R_V = A_V / E(B-V), where A_V is the total extinction in the Johnson V band and E(B-V) is the colour excess (see also J.H.J. de Bruijne, 26 May 2003, 'Stellar fluxes: transformations and calibrations', GAIA-JdB-005, issue 1, revision 1)", 
     source = "J.A. Cardelli, G.C. Clayton, J.S. Mathis, 1989, 'The relationship between infrared, optical, and ultraviolet extinction', Astrophysical Journal (ApJ), 345, 245", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double EXTINCTION_TOTALTOSELECTIVERATIO; static { EXTINCTION_TOTALTOSELECTIVERATIO = 3.10; } 

    /**
     * Typical extinction in the Johnson V band (A_V) per kpc in the Galactic plane; values ranging from 0.5 to 1.5 mag kpc^-1 are considered 'normal' (e.g., H. Jonch-Sorensen, 1994, 'CCD uvby-beta photometry of faint stars. 2: Reddening in six fields in the Galaxy', A&A, 292, 92)    
     * <p>
     * Source: Typical value ('common lore')<br/>
     * Status: CONF<br/>
     * Unit: mag kpc^-1<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Typical extinction in the Johnson V band (A_V) per kpc in the Galactic plane; values ranging from 0.5 to 1.5 mag kpc^-1 are considered 'normal' (e.g., H. Jonch-Sorensen, 1994, 'CCD uvby-beta photometry of faint stars. 2: Reddening in six fields in the Galaxy', A&A, 292, 92)", 
     source = "Typical value ('common lore')", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "mag kpc^-1") 
    public static final double EXTINCTION_GALACTICPLANE_TYPICAL; static { EXTINCTION_GALACTICPLANE_TYPICAL = 1.0; } // [mag kpc^-1] 

    /**
     * Photon flux density N_{\lambda}(\lambda) of an unreddened F2V star (Pickles' star number 015) at V = 0 mag. First column: wavelength \lambda (in nm; from 115.0 to 1062.0). Second column: photon flux density above the Earth's atmosphere (in photons m^-2 s^-1 nm^-1; the photometric zero point is described in J.H.J. de Bruijne, 26 May 2003, 'Stellar fluxes: transformations and calibrations', GAIA-JdB-005, issue 1, revision 1)    
     * <p>
     * Source: A.J. Pickles, 1998, 'A stellar spectral flux library: 1150-25000 AA', PASP, 110, 863<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: false
     */
    @ParamMetaData (
    description = "Photon flux density N_{\\lambda}(\\lambda) of an unreddened F2V star (Pickles' star number 015) at V = 0 mag. First column: wavelength \\lambda (in nm; from 115.0 to 1062.0). Second column: photon flux density above the Earth's atmosphere (in photons m^-2 s^-1 nm^-1; the photometric zero point is described in J.H.J. de Bruijne, 26 May 2003, 'Stellar fluxes: transformations and calibrations', GAIA-JdB-005, issue 1, revision 1)", 
     source = "A.J. Pickles, 1998, 'A stellar spectral flux library: 1150-25000 AA', PASP, 110, 863", 
     status = "CONF", 
     basic = true, 
     scalar = false, 
     unit = "") 
    public static final String F2VSTAR_SPECTRUM_NUMBEROFPHOTONS; static { F2VSTAR_SPECTRUM_NUMBEROFPHOTONS = "Nature/F2VStar_Spectrum_NumberOfPhotons_001.fits"; } 

    /**
     * Photon flux density N_{\lambda}(\lambda) of an unreddened F6V star (Pickles' star number 018) at V = 0 mag. First column: wavelength \lambda (in nm; from 115.0 to 1062.0). Second column: photon flux density above the Earth's atmosphere (in photons m^-2 s^-1 nm^-1; the photometric zero point is described in J.H.J. de Bruijne, 26 May 2003, 'Stellar fluxes: transformations and calibrations', GAIA-JdB-005, issue 1, revision 1)    
     * <p>
     * Source: A.J. Pickles, 1998, 'A stellar spectral flux library: 1150-25000 AA', PASP, 110, 863<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: false
     */
    @ParamMetaData (
    description = "Photon flux density N_{\\lambda}(\\lambda) of an unreddened F6V star (Pickles' star number 018) at V = 0 mag. First column: wavelength \\lambda (in nm; from 115.0 to 1062.0). Second column: photon flux density above the Earth's atmosphere (in photons m^-2 s^-1 nm^-1; the photometric zero point is described in J.H.J. de Bruijne, 26 May 2003, 'Stellar fluxes: transformations and calibrations', GAIA-JdB-005, issue 1, revision 1)", 
     source = "A.J. Pickles, 1998, 'A stellar spectral flux library: 1150-25000 AA', PASP, 110, 863", 
     status = "CONF", 
     basic = true, 
     scalar = false, 
     unit = "") 
    public static final String F6VSTAR_SPECTRUM_NUMBEROFPHOTONS; static { F6VSTAR_SPECTRUM_NUMBEROFPHOTONS = "Nature/F6VStar_Spectrum_NumberOfPhotons_001.fits"; } 

    /**
     * Photon flux density N_{\lambda}(\lambda) of an unreddened F8V star (Pickles' star number 020) at V = 0 mag. First column: wavelength \lambda (in nm; from 115.0 to 1062.0). Second column: photon flux density above the Earth's atmosphere (in photons m^-2 s^-1 nm^-1; the photometric zero point is described in J.H.J. de Bruijne, 26 May 2003, 'Stellar fluxes: transformations and calibrations', GAIA-JdB-005, issue 1, revision 1)    
     * <p>
     * Source: A.J. Pickles, 1998, 'A stellar spectral flux library: 1150-25000 AA', PASP, 110, 863<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: false
     */
    @ParamMetaData (
    description = "Photon flux density N_{\\lambda}(\\lambda) of an unreddened F8V star (Pickles' star number 020) at V = 0 mag. First column: wavelength \\lambda (in nm; from 115.0 to 1062.0). Second column: photon flux density above the Earth's atmosphere (in photons m^-2 s^-1 nm^-1; the photometric zero point is described in J.H.J. de Bruijne, 26 May 2003, 'Stellar fluxes: transformations and calibrations', GAIA-JdB-005, issue 1, revision 1)", 
     source = "A.J. Pickles, 1998, 'A stellar spectral flux library: 1150-25000 AA', PASP, 110, 863", 
     status = "CONF", 
     basic = true, 
     scalar = false, 
     unit = "") 
    public static final String F8VSTAR_SPECTRUM_NUMBEROFPHOTONS; static { F8VSTAR_SPECTRUM_NUMBEROFPHOTONS = "Nature/F8VStar_Spectrum_NumberOfPhotons_001.fits"; } 

    /**
     * Johnson B band filter profile (normalised standard passband in the Johnson-Cousins UBVRI photometric system). First column: wavelength \lambda (in nm; from 360.0 to 560.0). Second column: normalised transmittance    
     * <p>
     * Source: M.S. Bessell, S. Murphy, 2012, 'Spectrophotometric Libraries, Revised Photonic Passbands, and Zero Points for UBVRI, Hipparcos, and Tycho Photometry', PASP, 124, 140<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: false
     */
    @ParamMetaData (
    description = "Johnson B band filter profile (normalised standard passband in the Johnson-Cousins UBVRI photometric system). First column: wavelength \\lambda (in nm; from 360.0 to 560.0). Second column: normalised transmittance", 
     source = "M.S. Bessell, S. Murphy, 2012, 'Spectrophotometric Libraries, Revised Photonic Passbands, and Zero Points for UBVRI, Hipparcos, and Tycho Photometry', PASP, 124, 140", 
     status = "CONF", 
     basic = true, 
     scalar = false, 
     unit = "") 
    public static final String FILTERTRANSMISSIONCURVE_JOHNSONCOUSINSB; static { FILTERTRANSMISSIONCURVE_JOHNSONCOUSINSB = "Nature/FilterTransmissionCurve_JohnsonCousinsB_002.fits"; } 

    /**
     * Johnson V band filter profile (normalised standard passband in the Johnson-Cousins UBVRI photometric system). First column: wavelength \lambda (in nm; from 470.0 to 740.0). Second column: normalised transmittance    
     * <p>
     * Source: M.S. Bessell, S. Murphy, 2012, 'Spectrophotometric Libraries, Revised Photonic Passbands, and Zero Points for UBVRI, Hipparcos, and Tycho Photometry', PASP, 124, 140<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: false
     */
    @ParamMetaData (
    description = "Johnson V band filter profile (normalised standard passband in the Johnson-Cousins UBVRI photometric system). First column: wavelength \\lambda (in nm; from 470.0 to 740.0). Second column: normalised transmittance", 
     source = "M.S. Bessell, S. Murphy, 2012, 'Spectrophotometric Libraries, Revised Photonic Passbands, and Zero Points for UBVRI, Hipparcos, and Tycho Photometry', PASP, 124, 140", 
     status = "CONF", 
     basic = true, 
     scalar = false, 
     unit = "") 
    public static final String FILTERTRANSMISSIONCURVE_JOHNSONCOUSINSV; static { FILTERTRANSMISSIONCURVE_JOHNSONCOUSINSV = "Nature/FilterTransmissionCurve_JohnsonCousinsV_002.fits"; } 

    /**
     * Cousins R band filter profile (normalised standard passband in the Johnson-Cousins UBVRI photometric system). First column: wavelength \lambda (in nm; from 550.0 to 910.0). Second column: normalised transmittance    
     * <p>
     * Source: M.S. Bessell, S. Murphy, 2012, 'Spectrophotometric Libraries, Revised Photonic Passbands, and Zero Points for UBVRI, Hipparcos, and Tycho Photometry', PASP, 124, 140<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: false
     */
    @ParamMetaData (
    description = "Cousins R band filter profile (normalised standard passband in the Johnson-Cousins UBVRI photometric system). First column: wavelength \\lambda (in nm; from 550.0 to 910.0). Second column: normalised transmittance", 
     source = "M.S. Bessell, S. Murphy, 2012, 'Spectrophotometric Libraries, Revised Photonic Passbands, and Zero Points for UBVRI, Hipparcos, and Tycho Photometry', PASP, 124, 140", 
     status = "CONF", 
     basic = true, 
     scalar = false, 
     unit = "") 
    public static final String FILTERTRANSMISSIONCURVE_JOHNSONCOUSINSR; static { FILTERTRANSMISSIONCURVE_JOHNSONCOUSINSR = "Nature/FilterTransmissionCurve_JohnsonCousinsR_002.fits"; } 

    /**
     * Cousins I band filter profile (normalised standard passband in the Johnson-Cousins UBVRI photometric system). First column: wavelength \lambda (in nm; from 700.0 to 920.0). Second column: normalised transmittance    
     * <p>
     * Source: M.S. Bessell, S. Murphy, 2012, 'Spectrophotometric Libraries, Revised Photonic Passbands, and Zero Points for UBVRI, Hipparcos, and Tycho Photometry', PASP, 124, 140<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: false
     */
    @ParamMetaData (
    description = "Cousins I band filter profile (normalised standard passband in the Johnson-Cousins UBVRI photometric system). First column: wavelength \\lambda (in nm; from 700.0 to 920.0). Second column: normalised transmittance", 
     source = "M.S. Bessell, S. Murphy, 2012, 'Spectrophotometric Libraries, Revised Photonic Passbands, and Zero Points for UBVRI, Hipparcos, and Tycho Photometry', PASP, 124, 140", 
     status = "CONF", 
     basic = true, 
     scalar = false, 
     unit = "") 
    public static final String FILTERTRANSMISSIONCURVE_JOHNSONCOUSINSI; static { FILTERTRANSMISSIONCURVE_JOHNSONCOUSINSI = "Nature/FilterTransmissionCurve_JohnsonCousinsI_002.fits"; } 

    /**
     * Fine structure constant. Note: best-measured value equals 7.2973525664E-3 (P.J. Mohr, B.N. Taylor, D.B. Newell, 9 July 2015, 'The 2014 CODATA Recommended Values of the Fundamental Physical Constants', National Institute of Standards and Technology, Gaithersburg, MD 20899-8401; http://www.codata.org/ and http://physics.nist.gov/constants (Web Version 7.0))    
     * <p>
     * Status: CONF<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Fine structure constant. Note: best-measured value equals 7.2973525664E-3 (P.J. Mohr, B.N. Taylor, D.B. Newell, 9 July 2015, 'The 2014 CODATA Recommended Values of the Fundamental Physical Constants', National Institute of Standards and Technology, Gaithersburg, MD 20899-8401; http://www.codata.org/ and http://physics.nist.gov/constants (Web Version 7.0))", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "") 
    public static final double FINESTRUCTURE_CONSTANT; static { FINESTRUCTURE_CONSTANT = 7.29735256621e-3; } 

    /**
     * Foreshortening constant A_z^-1 (see ESA, 1997, 'The Hipparcos and Tycho Catalogues', ESA SP-1200, Volume 1, page 25, Table 1.2.2)    
     * <p>
     * Status: CONF<br/>
     * Unit: mas^-1 km^-1 yr^-1 s<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Foreshortening constant A_z^-1 (see ESA, 1997, 'The Hipparcos and Tycho Catalogues', ESA SP-1200, Volume 1, page 25, Table 1.2.2)", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "mas^-1 km^-1 yr^-1 s") 
    public static final double FORESHORTENING_CONSTANT; static { FORESHORTENING_CONSTANT = 1.0227121650e-9; } // [mas^-1 km^-1 yr^-1 s] 

    /**
     * Surface area of unit sphere (4 Pi steradians) in units of square degrees    
     * <p>
     * Status: CONF<br/>
     * Unit: deg^2<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Surface area of unit sphere (4 Pi steradians) in units of square degrees", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "deg^2") 
    public static final double FOURPISTERADIAN_DEGREESQUARE; static { FOURPISTERADIAN_DEGREESQUARE = 41252.9612494193; } // [deg^2] 

    /**
     * Density of synthetic fused Silica    
     * <p>
     * Source: Schott Lithotec AG, 5 August 2010, 'Optical glass data sheets (Lithosil-Q)', http://www.schott.com/advanced_optics/english/download/- schott_optical_glass_august_2010_en.pdf; see also http://www.schott.com/advanced_optics/english/download/- schott_fused_silica_jan_2010_en_brochure.pdf<br/>
     * Status: CONF<br/>
     * Unit: g cm^-3<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Density of synthetic fused Silica", 
     source = "Schott Lithotec AG, 5 August 2010, 'Optical glass data sheets (Lithosil-Q)', http://www.schott.com/advanced_optics/english/download/- schott_optical_glass_august_2010_en.pdf; see also http://www.schott.com/advanced_optics/english/download/- schott_fused_silica_jan_2010_en_brochure.pdf", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "g cm^-3") 
    public static final double FUSEDSILICA_MASSDENSITY; static { FUSEDSILICA_MASSDENSITY = 2.2; } // [g cm^-3] 

    /**
     * Linear thermal expansion coefficient of synthetic fused Silica at 293 K. The quoted value is specified to be valid over the temperature range T = 293 - 373 K; a value for T = 170 K is not available    
     * <p>
     * Source: Schott Lithotec AG, 5 August 2010, 'Optical glass data sheets (Lithosil-Q)', http://www.schott.com/advanced_optics/english/download/- schott_optical_glass_august_2010_en.pdf; see also http://www.schott.com/advanced_optics/english/download/- schott_fused_silica_jan_2010_en_brochure.pdf<br/>
     * Status: CONF<br/>
     * Unit: ppm K^-1<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Linear thermal expansion coefficient of synthetic fused Silica at 293 K. The quoted value is specified to be valid over the temperature range T = 293 - 373 K; a value for T = 170 K is not available", 
     source = "Schott Lithotec AG, 5 August 2010, 'Optical glass data sheets (Lithosil-Q)', http://www.schott.com/advanced_optics/english/download/- schott_optical_glass_august_2010_en.pdf; see also http://www.schott.com/advanced_optics/english/download/- schott_fused_silica_jan_2010_en_brochure.pdf", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "ppm K^-1") 
    public static final double FUSEDSILICA_LINEARTHERMALCOEFFICIENTOFEXPANSION_293K; static { FUSEDSILICA_LINEARTHERMALCOEFFICIENTOFEXPANSION_293K = 0.5; } // [ppm K^-1] 

    /**
     * Sellmeier coefficient B_1 of synthetic fused Silica, which is dimensionless, at T = 120 K. The Sellmeier equation is an empirical relation between the refractive index n and wavelength \lambda for transparent media in the form: n^2(\lambda) = 1 + \frac{B_1 \lambda^2}{\lambda^2 - C_1} + \frac{B_2 \lambda^2}{\lambda^2 - C_2} + \frac{B_3 \lambda^2}{\lambda^2 - C_3}, where B_1, B_2, B_3 and C_1, C_2, C_3 are experimentally-determined Sellmeier coefficients. These coefficients are defined for \lambda measured in 10^-6 m. The wavelength \lambda is the vacuum wavelength and not that in the material itself, which is \lambda / n(\lambda)    
     * <p>
     * Source: EADS-Astrium, 4 July 2008, 'Code V Models Description', GAIA.ASF.TCN.PLM.00287, issue 1, revision 0. For temperature-dependent Sellmeier coefficients, see G. Ghosh, M. Endo, T. Iwasaki, 1 August 1994, 'Temperature-dependent Sellmeier coefficients and chromatic dispersions for some optical fiber glasses', Journal of Lightwave Technology, Volume 12, Number 8, pages 1338-1342 (1994JLwT...12.1338G) and http://www.schott.com/advanced_optics/english/download/- schott_tie-29_refractive_index_v3_jan_2007_en.pdf<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Sellmeier coefficient B_1 of synthetic fused Silica, which is dimensionless, at T = 120 K. The Sellmeier equation is an empirical relation between the refractive index n and wavelength \\lambda for transparent media in the form: n^2(\\lambda) = 1 + \\frac{B_1 \\lambda^2}{\\lambda^2 - C_1} + \\frac{B_2 \\lambda^2}{\\lambda^2 - C_2} + \\frac{B_3 \\lambda^2}{\\lambda^2 - C_3}, where B_1, B_2, B_3 and C_1, C_2, C_3 are experimentally-determined Sellmeier coefficients. These coefficients are defined for \\lambda measured in 10^-6 m. The wavelength \\lambda is the vacuum wavelength and not that in the material itself, which is \\lambda / n(\\lambda)", 
     source = "EADS-Astrium, 4 July 2008, 'Code V Models Description', GAIA.ASF.TCN.PLM.00287, issue 1, revision 0. For temperature-dependent Sellmeier coefficients, see G. Ghosh, M. Endo, T. Iwasaki, 1 August 1994, 'Temperature-dependent Sellmeier coefficients and chromatic dispersions for some optical fiber glasses', Journal of Lightwave Technology, Volume 12, Number 8, pages 1338-1342 (1994JLwT...12.1338G) and http://www.schott.com/advanced_optics/english/download/- schott_tie-29_refractive_index_v3_jan_2007_en.pdf", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double FUSEDSILICA_SELLMEIERCOEFFICIENT_B1; static { FUSEDSILICA_SELLMEIERCOEFFICIENT_B1 = 1.10053898145; } 

    /**
     * Sellmeier coefficient B_2 of synthetic fused Silica, which is dimensionless, at T = 120 K. The Sellmeier equation is an empirical relation between the refractive index n and wavelength \lambda for transparent media in the form: n^2(\lambda) = 1 + \frac{B_1 \lambda^2}{\lambda^2 - C_1} + \frac{B_2 \lambda^2}{\lambda^2 - C_2} + \frac{B_3 \lambda^2}{\lambda^2 - C_3}, where B_1, B_2, B_3 and C_1, C_2, C_3 are experimentally-determined Sellmeier coefficients. These coefficients are defined for \lambda measured in 10^-6 m. The wavelength \lambda is the vacuum wavelength and not that in the material itself, which is \lambda / n(\lambda)    
     * <p>
     * Source: EADS-Astrium, 4 July 2008, 'Code V Models Description', GAIA.ASF.TCN.PLM.00287, issue 1, revision 0. For temperature-dependent Sellmeier coefficients, see G. Ghosh, M. Endo, T. Iwasaki, 1 August 1994, 'Temperature-dependent Sellmeier coefficients and chromatic dispersions for some optical fiber glasses', Journal of Lightwave Technology, Volume 12, Number 8, pages 1338-1342 (1994JLwT...12.1338G) and http://www.schott.com/advanced_optics/english/download/- schott_tie-29_refractive_index_v3_jan_2007_en.pdf<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Sellmeier coefficient B_2 of synthetic fused Silica, which is dimensionless, at T = 120 K. The Sellmeier equation is an empirical relation between the refractive index n and wavelength \\lambda for transparent media in the form: n^2(\\lambda) = 1 + \\frac{B_1 \\lambda^2}{\\lambda^2 - C_1} + \\frac{B_2 \\lambda^2}{\\lambda^2 - C_2} + \\frac{B_3 \\lambda^2}{\\lambda^2 - C_3}, where B_1, B_2, B_3 and C_1, C_2, C_3 are experimentally-determined Sellmeier coefficients. These coefficients are defined for \\lambda measured in 10^-6 m. The wavelength \\lambda is the vacuum wavelength and not that in the material itself, which is \\lambda / n(\\lambda)", 
     source = "EADS-Astrium, 4 July 2008, 'Code V Models Description', GAIA.ASF.TCN.PLM.00287, issue 1, revision 0. For temperature-dependent Sellmeier coefficients, see G. Ghosh, M. Endo, T. Iwasaki, 1 August 1994, 'Temperature-dependent Sellmeier coefficients and chromatic dispersions for some optical fiber glasses', Journal of Lightwave Technology, Volume 12, Number 8, pages 1338-1342 (1994JLwT...12.1338G) and http://www.schott.com/advanced_optics/english/download/- schott_tie-29_refractive_index_v3_jan_2007_en.pdf", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double FUSEDSILICA_SELLMEIERCOEFFICIENT_B2; static { FUSEDSILICA_SELLMEIERCOEFFICIENT_B2 = 0.00144043087; } 

    /**
     * Sellmeier coefficient B_3 of synthetic fused Silica, which is dimensionless, at T = 120 K. The Sellmeier equation is an empirical relation between the refractive index n and wavelength \lambda for transparent media in the form: n^2(\lambda) = 1 + \frac{B_1 \lambda^2}{\lambda^2 - C_1} + \frac{B_2 \lambda^2}{\lambda^2 - C_2} + \frac{B_3 \lambda^2}{\lambda^2 - C_3}, where B_1, B_2, B_3 and C_1, C_2, C_3 are experimentally-determined Sellmeier coefficients. These coefficients are defined for \lambda measured in 10^-6 m. The wavelength \lambda is the vacuum wavelength and not that in the material itself, which is \lambda / n(\lambda)    
     * <p>
     * Source: EADS-Astrium, 4 July 2008, 'Code V Models Description', GAIA.ASF.TCN.PLM.00287, issue 1, revision 0. For temperature-dependent Sellmeier coefficients, see G. Ghosh, M. Endo, T. Iwasaki, 1 August 1994, 'Temperature-dependent Sellmeier coefficients and chromatic dispersions for some optical fiber glasses', Journal of Lightwave Technology, Volume 12, Number 8, pages 1338-1342 (1994JLwT...12.1338G) and http://www.schott.com/advanced_optics/english/download/- schott_tie-29_refractive_index_v3_jan_2007_en.pdf<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Sellmeier coefficient B_3 of synthetic fused Silica, which is dimensionless, at T = 120 K. The Sellmeier equation is an empirical relation between the refractive index n and wavelength \\lambda for transparent media in the form: n^2(\\lambda) = 1 + \\frac{B_1 \\lambda^2}{\\lambda^2 - C_1} + \\frac{B_2 \\lambda^2}{\\lambda^2 - C_2} + \\frac{B_3 \\lambda^2}{\\lambda^2 - C_3}, where B_1, B_2, B_3 and C_1, C_2, C_3 are experimentally-determined Sellmeier coefficients. These coefficients are defined for \\lambda measured in 10^-6 m. The wavelength \\lambda is the vacuum wavelength and not that in the material itself, which is \\lambda / n(\\lambda)", 
     source = "EADS-Astrium, 4 July 2008, 'Code V Models Description', GAIA.ASF.TCN.PLM.00287, issue 1, revision 0. For temperature-dependent Sellmeier coefficients, see G. Ghosh, M. Endo, T. Iwasaki, 1 August 1994, 'Temperature-dependent Sellmeier coefficients and chromatic dispersions for some optical fiber glasses', Journal of Lightwave Technology, Volume 12, Number 8, pages 1338-1342 (1994JLwT...12.1338G) and http://www.schott.com/advanced_optics/english/download/- schott_tie-29_refractive_index_v3_jan_2007_en.pdf", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double FUSEDSILICA_SELLMEIERCOEFFICIENT_B3; static { FUSEDSILICA_SELLMEIERCOEFFICIENT_B3 = 0.77782846144; } 

    /**
     * Sellmeier coefficient C_1 of synthetic fused Silica, in units of (10^-6 m)^2, at T = 120 K. It is emphasised that this C-value is already squared, thus complying with the denominator units of the Sellmeier equation, in (10^-6 m)^2. The Sellmeier equation is an empirical relation between the refractive index n and wavelength \lambda for transparent media in the form: n^2(\lambda) = 1 + \frac{B_1 \lambda^2}{\lambda^2 - C_1} + \frac{B_2 \lambda^2}{\lambda^2 - C_2} + \frac{B_3 \lambda^2}{\lambda^2 - C_3}, where B_1, B_2, B_3 and C_1, C_2, C_3 are experimentally-determined Sellmeier coefficients. These coefficients are defined for \lambda measured in 10^-6 m. The wavelength \lambda is the vacuum wavelength and not that in the material itself, which is \lambda / n(\lambda)    
     * <p>
     * Source: EADS-Astrium, 4 July 2008, 'Code V Models Description', GAIA.ASF.TCN.PLM.00287, issue 1, revision 0. For temperature-dependent Sellmeier coefficients, see G. Ghosh, M. Endo, T. Iwasaki, 1 August 1994, 'Temperature-dependent Sellmeier coefficients and chromatic dispersions for some optical fiber glasses', Journal of Lightwave Technology, Volume 12, Number 8, pages 1338-1342 (1994JLwT...12.1338G) and http://www.schott.com/advanced_optics/english/download/- schott_tie-29_refractive_index_v3_jan_2007_en.pdf<br/>
     * Status: CONF<br/>
     * Unit: (10^-6 m)^2<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Sellmeier coefficient C_1 of synthetic fused Silica, in units of (10^-6 m)^2, at T = 120 K. It is emphasised that this C-value is already squared, thus complying with the denominator units of the Sellmeier equation, in (10^-6 m)^2. The Sellmeier equation is an empirical relation between the refractive index n and wavelength \\lambda for transparent media in the form: n^2(\\lambda) = 1 + \\frac{B_1 \\lambda^2}{\\lambda^2 - C_1} + \\frac{B_2 \\lambda^2}{\\lambda^2 - C_2} + \\frac{B_3 \\lambda^2}{\\lambda^2 - C_3}, where B_1, B_2, B_3 and C_1, C_2, C_3 are experimentally-determined Sellmeier coefficients. These coefficients are defined for \\lambda measured in 10^-6 m. The wavelength \\lambda is the vacuum wavelength and not that in the material itself, which is \\lambda / n(\\lambda)", 
     source = "EADS-Astrium, 4 July 2008, 'Code V Models Description', GAIA.ASF.TCN.PLM.00287, issue 1, revision 0. For temperature-dependent Sellmeier coefficients, see G. Ghosh, M. Endo, T. Iwasaki, 1 August 1994, 'Temperature-dependent Sellmeier coefficients and chromatic dispersions for some optical fiber glasses', Journal of Lightwave Technology, Volume 12, Number 8, pages 1338-1342 (1994JLwT...12.1338G) and http://www.schott.com/advanced_optics/english/download/- schott_tie-29_refractive_index_v3_jan_2007_en.pdf", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "(10^-6 m)^2") 
    public static final double FUSEDSILICA_SELLMEIERCOEFFICIENT_C1; static { FUSEDSILICA_SELLMEIERCOEFFICIENT_C1 = 0.00787874390; } // [(10^-6 m)^2] 

    /**
     * Sellmeier coefficient C_2 of synthetic fused Silica, in units of (10^-6 m)^2, at T = 120 K. It is emphasised that this C-value is already squared, thus complying with the denominator units of the Sellmeier equation, in (10^-6 m)^2. The Sellmeier equation is an empirical relation between the refractive index n and wavelength \lambda for transparent media in the form: n^2(\lambda) = 1 + \frac{B_1 \lambda^2}{\lambda^2 - C_1} + \frac{B_2 \lambda^2}{\lambda^2 - C_2} + \frac{B_3 \lambda^2}{\lambda^2 - C_3}, where B_1, B_2, B_3 and C_1, C_2, C_3 are experimentally-determined Sellmeier coefficients. These coefficients are defined for \lambda measured in 10^-6 m. The wavelength \lambda is the vacuum wavelength and not that in the material itself, which is \lambda / n(\lambda)    
     * <p>
     * Source: EADS-Astrium, 4 July 2008, 'Code V Models Description', GAIA.ASF.TCN.PLM.00287, issue 1, revision 0. For temperature-dependent Sellmeier coefficients, see G. Ghosh, M. Endo, T. Iwasaki, 1 August 1994, 'Temperature-dependent Sellmeier coefficients and chromatic dispersions for some optical fiber glasses', Journal of Lightwave Technology, Volume 12, Number 8, pages 1338-1342 (1994JLwT...12.1338G) and http://www.schott.com/advanced_optics/english/download/- schott_tie-29_refractive_index_v3_jan_2007_en.pdf<br/>
     * Status: CONF<br/>
     * Unit: (10^-6 m)^2<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Sellmeier coefficient C_2 of synthetic fused Silica, in units of (10^-6 m)^2, at T = 120 K. It is emphasised that this C-value is already squared, thus complying with the denominator units of the Sellmeier equation, in (10^-6 m)^2. The Sellmeier equation is an empirical relation between the refractive index n and wavelength \\lambda for transparent media in the form: n^2(\\lambda) = 1 + \\frac{B_1 \\lambda^2}{\\lambda^2 - C_1} + \\frac{B_2 \\lambda^2}{\\lambda^2 - C_2} + \\frac{B_3 \\lambda^2}{\\lambda^2 - C_3}, where B_1, B_2, B_3 and C_1, C_2, C_3 are experimentally-determined Sellmeier coefficients. These coefficients are defined for \\lambda measured in 10^-6 m. The wavelength \\lambda is the vacuum wavelength and not that in the material itself, which is \\lambda / n(\\lambda)", 
     source = "EADS-Astrium, 4 July 2008, 'Code V Models Description', GAIA.ASF.TCN.PLM.00287, issue 1, revision 0. For temperature-dependent Sellmeier coefficients, see G. Ghosh, M. Endo, T. Iwasaki, 1 August 1994, 'Temperature-dependent Sellmeier coefficients and chromatic dispersions for some optical fiber glasses', Journal of Lightwave Technology, Volume 12, Number 8, pages 1338-1342 (1994JLwT...12.1338G) and http://www.schott.com/advanced_optics/english/download/- schott_tie-29_refractive_index_v3_jan_2007_en.pdf", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "(10^-6 m)^2") 
    public static final double FUSEDSILICA_SELLMEIERCOEFFICIENT_C2; static { FUSEDSILICA_SELLMEIERCOEFFICIENT_C2 = 0.07320427965; } // [(10^-6 m)^2] 

    /**
     * Sellmeier coefficient C_3 of synthetic fused Silica, in units of (10^-6 m)^2, at T = 120 K. It is emphasised that this C-value is already squared, thus complying with the denominator units of the Sellmeier equation, in (10^-6 m)^2. The Sellmeier equation is an empirical relation between the refractive index n and wavelength \lambda for transparent media in the form: n^2(\lambda) = 1 + \frac{B_1 \lambda^2}{\lambda^2 - C_1} + \frac{B_2 \lambda^2}{\lambda^2 - C_2} + \frac{B_3 \lambda^2}{\lambda^2 - C_3}, where B_1, B_2, B_3 and C_1, C_2, C_3 are experimentally-determined Sellmeier coefficients. These coefficients are defined for \lambda measured in 10^-6 m. The wavelength \lambda is the vacuum wavelength and not that in the material itself, which is \lambda / n(\lambda)    
     * <p>
     * Source: EADS-Astrium, 4 July 2008, 'Code V Models Description', GAIA.ASF.TCN.PLM.00287, issue 1, revision 0. For temperature-dependent Sellmeier coefficients, see G. Ghosh, M. Endo, T. Iwasaki, 1 August 1994, 'Temperature-dependent Sellmeier coefficients and chromatic dispersions for some optical fiber glasses', Journal of Lightwave Technology, Volume 12, Number 8, pages 1338-1342 (1994JLwT...12.1338G) and http://www.schott.com/advanced_optics/english/download/- schott_tie-29_refractive_index_v3_jan_2007_en.pdf<br/>
     * Status: CONF<br/>
     * Unit: (10^-6 m)^2<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Sellmeier coefficient C_3 of synthetic fused Silica, in units of (10^-6 m)^2, at T = 120 K. It is emphasised that this C-value is already squared, thus complying with the denominator units of the Sellmeier equation, in (10^-6 m)^2. The Sellmeier equation is an empirical relation between the refractive index n and wavelength \\lambda for transparent media in the form: n^2(\\lambda) = 1 + \\frac{B_1 \\lambda^2}{\\lambda^2 - C_1} + \\frac{B_2 \\lambda^2}{\\lambda^2 - C_2} + \\frac{B_3 \\lambda^2}{\\lambda^2 - C_3}, where B_1, B_2, B_3 and C_1, C_2, C_3 are experimentally-determined Sellmeier coefficients. These coefficients are defined for \\lambda measured in 10^-6 m. The wavelength \\lambda is the vacuum wavelength and not that in the material itself, which is \\lambda / n(\\lambda)", 
     source = "EADS-Astrium, 4 July 2008, 'Code V Models Description', GAIA.ASF.TCN.PLM.00287, issue 1, revision 0. For temperature-dependent Sellmeier coefficients, see G. Ghosh, M. Endo, T. Iwasaki, 1 August 1994, 'Temperature-dependent Sellmeier coefficients and chromatic dispersions for some optical fiber glasses', Journal of Lightwave Technology, Volume 12, Number 8, pages 1338-1342 (1994JLwT...12.1338G) and http://www.schott.com/advanced_optics/english/download/- schott_tie-29_refractive_index_v3_jan_2007_en.pdf", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "(10^-6 m)^2") 
    public static final double FUSEDSILICA_SELLMEIERCOEFFICIENT_C3; static { FUSEDSILICA_SELLMEIERCOEFFICIENT_C3 = 85.64043680329; } // [(10^-6 m)^2] 

    /**
     * Typical transmission of synthetic fused Silica, including Fresnel reflection losses for an uncoated surface, for a 10-mm path length. First column: wavelength \lambda (in nm; from 200.0 to 1250.0). Second column: typical transmission. Explanatory, supplementary information: this parameter provides the bulk transmission of 10 mm of synthetic fused Silica, including Fresnel reflection losses. Fresnel diffraction losses, however, are only applicable in the absence of an anti-relfection coating. Since all Gaia prisms (BP/RP and RVS) do have anti-relfection coatings, the bulk transmission (i) first has to be corrected for (the absence of) Fresnel diffraction losses, and (ii) subsequently has to be scaled for the proper path length in the fused Silica. Ad (i): the Fresnel reflectivity per surface equals R = (n-1)^2 (n+1)^-2, where n is the index of refraction of fused Silica (which is a function of wavelength and temperature). The Fresnel loss per surface is hence 1 - R. The index of refraction n can be calculated from the Sellmeier coefficients (see parameters :Nature:FusedSilica_SellmeierCoefficient_*). The corrected bulk transmission of 10 mm of fused Silica exceeds 99.9% above 250 nm. Ad (ii): let us denote the transmission curve of 10 mm synthetic fused Silica, corrected for (the absence of) Fresnel diffraction losses, by \eta_10. The transmission curve for d mm path length (see parameters :Satellite:BP:Prism_Thickness, :Satellite:RP:Prism_Thickness, and :Satellite:RVS:Prism_Thickness) can then be calculated - following the Bouguer-Lambert law - as \eta_d = \eta_10^(d/10). As secondary effect, prism wedge angles could be included, effectively increasing the path lengths d    
     * <p>
     * Source: Schott Lithotec AG, 5 August 2010, 'Optical glass data sheets (Lithosil-Q)', http://www.schott.com/advanced_optics/english/download/- schott_optical_glass_august_2010_en.pdf; see also http://www.schott.com/advanced_optics/english/download/- schott_fused_silica_jan_2010_en_brochure.pdf<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: false
     */
    @ParamMetaData (
    description = "Typical transmission of synthetic fused Silica, including Fresnel reflection losses for an uncoated surface, for a 10-mm path length. First column: wavelength \\lambda (in nm; from 200.0 to 1250.0). Second column: typical transmission. Explanatory, supplementary information: this parameter provides the bulk transmission of 10 mm of synthetic fused Silica, including Fresnel reflection losses. Fresnel diffraction losses, however, are only applicable in the absence of an anti-relfection coating. Since all Gaia prisms (BP/RP and RVS) do have anti-relfection coatings, the bulk transmission (i) first has to be corrected for (the absence of) Fresnel diffraction losses, and (ii) subsequently has to be scaled for the proper path length in the fused Silica. Ad (i): the Fresnel reflectivity per surface equals R = (n-1)^2 (n+1)^-2, where n is the index of refraction of fused Silica (which is a function of wavelength and temperature). The Fresnel loss per surface is hence 1 - R. The index of refraction n can be calculated from the Sellmeier coefficients (see parameters :Nature:FusedSilica_SellmeierCoefficient_*). The corrected bulk transmission of 10 mm of fused Silica exceeds 99.9% above 250 nm. Ad (ii): let us denote the transmission curve of 10 mm synthetic fused Silica, corrected for (the absence of) Fresnel diffraction losses, by \\eta_10. The transmission curve for d mm path length (see parameters :Satellite:BP:Prism_Thickness, :Satellite:RP:Prism_Thickness, and :Satellite:RVS:Prism_Thickness) can then be calculated - following the Bouguer-Lambert law - as \\eta_d = \\eta_10^(d/10). As secondary effect, prism wedge angles could be included, effectively increasing the path lengths d", 
     source = "Schott Lithotec AG, 5 August 2010, 'Optical glass data sheets (Lithosil-Q)', http://www.schott.com/advanced_optics/english/download/- schott_optical_glass_august_2010_en.pdf; see also http://www.schott.com/advanced_optics/english/download/- schott_fused_silica_jan_2010_en_brochure.pdf", 
     status = "CONF", 
     basic = true, 
     scalar = false, 
     unit = "") 
    public static final String FUSEDSILICA_TRANSMISSIVITY_10MM; static { FUSEDSILICA_TRANSMISSIVITY_10MM = "Nature/FusedSilica_Transmissivity_10mm_001.fits"; } 

    /**
     * Photon flux density N_{\lambda}(\lambda) of an unreddened G2V star (Pickles' star number 026) at V = 0 mag. First column: wavelength \lambda (in nm; from 115.0 to 1062.0). Second column: photon flux density above the Earth's atmosphere (in photons m^-2 s^-1 nm^-1; the photometric zero point is described in J.H.J. de Bruijne, 26 May 2003, 'Stellar fluxes: transformations and calibrations', GAIA-JdB-005, issue 1, revision 1)    
     * <p>
     * Source: A.J. Pickles, 1998, 'A stellar spectral flux library: 1150-25000 AA', PASP, 110, 863<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: false
     */
    @ParamMetaData (
    description = "Photon flux density N_{\\lambda}(\\lambda) of an unreddened G2V star (Pickles' star number 026) at V = 0 mag. First column: wavelength \\lambda (in nm; from 115.0 to 1062.0). Second column: photon flux density above the Earth's atmosphere (in photons m^-2 s^-1 nm^-1; the photometric zero point is described in J.H.J. de Bruijne, 26 May 2003, 'Stellar fluxes: transformations and calibrations', GAIA-JdB-005, issue 1, revision 1)", 
     source = "A.J. Pickles, 1998, 'A stellar spectral flux library: 1150-25000 AA', PASP, 110, 863", 
     status = "CONF", 
     basic = true, 
     scalar = false, 
     unit = "") 
    public static final String G2VSTAR_SPECTRUM_NUMBEROFPHOTONS; static { G2VSTAR_SPECTRUM_NUMBEROFPHOTONS = "Nature/G2VStar_Spectrum_NumberOfPhotons_001.fits"; } 

    /**
     * High-resolution photon-flux density N_{\lambda}(\lambda) of an unreddened G2V star at V = 15 mag. The data refer to a high-resolution Kurucz-model spectrum with the following properties: effective temperature T_eff = 5800 K, logarithm of surface gravity log g = 4.5, metallicity [Fe/H] = 0.0, alpha-elements [\alpha/Fe] = 0.0, rotational velocity v sini = 5 km s^-1, micro-turbulence velocity = 2.0 km s^-1, length of convective bubble divided by pressure scale height = 0.50, no convective overshooting, macro-turbulence velocity = 2.0 km s^-1, and resolving power R = \lambda / \delta \lambda = 250,000. First column: wavelength \lambda (in nm; from 830.1673264 to 889.8217922). Second column: photon flux density above the Earth's atmosphere (in photons m^-2 s^-1 nm^-1). The 34698 lines have an average wavelength step of 0.00172 nm; the spectrum extent is thus 59.7 nm    
     * <p>
     * Source: ESA, 20 June 2005, 'Photon-flux distributions for reference stars', GAIA-EST-TN-00539, issue 1, revision 0, based on D. Katz, priv. comm., 11 May 2005<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: false
     */
    @ParamMetaData (
    description = "High-resolution photon-flux density N_{\\lambda}(\\lambda) of an unreddened G2V star at V = 15 mag. The data refer to a high-resolution Kurucz-model spectrum with the following properties: effective temperature T_eff = 5800 K, logarithm of surface gravity log g = 4.5, metallicity [Fe/H] = 0.0, alpha-elements [\\alpha/Fe] = 0.0, rotational velocity v sini = 5 km s^-1, micro-turbulence velocity = 2.0 km s^-1, length of convective bubble divided by pressure scale height = 0.50, no convective overshooting, macro-turbulence velocity = 2.0 km s^-1, and resolving power R = \\lambda / \\delta \\lambda = 250,000. First column: wavelength \\lambda (in nm; from 830.1673264 to 889.8217922). Second column: photon flux density above the Earth's atmosphere (in photons m^-2 s^-1 nm^-1). The 34698 lines have an average wavelength step of 0.00172 nm; the spectrum extent is thus 59.7 nm", 
     source = "ESA, 20 June 2005, 'Photon-flux distributions for reference stars', GAIA-EST-TN-00539, issue 1, revision 0, based on D. Katz, priv. comm., 11 May 2005", 
     status = "CONF", 
     basic = true, 
     scalar = false, 
     unit = "") 
    public static final String G2VSTAR_SPECTRUM_NUMBEROFPHOTONSHIGHRESOLUTION; static { G2VSTAR_SPECTRUM_NUMBEROFPHOTONSHIGHRESOLUTION = "Nature/G2VStar_Spectrum_NumberOfPhotonsHighResolution_001.fits"; } 

    /**
     * Photon flux density N_{\lambda}(\lambda) of an unreddened G8III star (Pickles' star number 076) at V = 0 mag. First column: wavelength \lambda (in nm; from 115.0 to 1062.0). Second column: photon flux density above the Earth's atmosphere (in photons m^-2 s^-1 nm^-1; the photometric zero point is described in J.H.J. de Bruijne, 26 May 2003, 'Stellar fluxes: transformations and calibrations', GAIA-JdB-005, issue 1, revision 1)    
     * <p>
     * Source: A.J. Pickles, 1998, 'A stellar spectral flux library: 1150-25000 AA', PASP, 110, 863<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: false
     */
    @ParamMetaData (
    description = "Photon flux density N_{\\lambda}(\\lambda) of an unreddened G8III star (Pickles' star number 076) at V = 0 mag. First column: wavelength \\lambda (in nm; from 115.0 to 1062.0). Second column: photon flux density above the Earth's atmosphere (in photons m^-2 s^-1 nm^-1; the photometric zero point is described in J.H.J. de Bruijne, 26 May 2003, 'Stellar fluxes: transformations and calibrations', GAIA-JdB-005, issue 1, revision 1)", 
     source = "A.J. Pickles, 1998, 'A stellar spectral flux library: 1150-25000 AA', PASP, 110, 863", 
     status = "CONF", 
     basic = true, 
     scalar = false, 
     unit = "") 
    public static final String G8IIISTAR_SPECTRUM_NUMBEROFPHOTONS; static { G8IIISTAR_SPECTRUM_NUMBEROFPHOTONS = "Nature/G8IIIStar_Spectrum_NumberOfPhotons_001.fits"; } 

    /**
     * Gaussian gravitational constant (defining constant), deprecated by IAU 2012 Resolution B2 adopted at the XXVIII-th General Assembly of the IAU    
     * <p>
     * Source: The IAU (2009) System of Astronomical Constants (IAU, August 2009, 'IAU 2009 Astronomical Constants', IAU 2009 Resolution B2 adopted at the XXVII-th General Assembly of the IAU. See also IAU, 10 August 2009, 'IAU WG on NSFA Current Best Estimates', http://maia.usno.navy.mil/NSFA/NSFA_cbe.html)<br/>
     * Status: DEPR<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Gaussian gravitational constant (defining constant), deprecated by IAU 2012 Resolution B2 adopted at the XXVIII-th General Assembly of the IAU", 
     source = "The IAU (2009) System of Astronomical Constants (IAU, August 2009, 'IAU 2009 Astronomical Constants', IAU 2009 Resolution B2 adopted at the XXVII-th General Assembly of the IAU. See also IAU, 10 August 2009, 'IAU WG on NSFA Current Best Estimates', http://maia.usno.navy.mil/NSFA/NSFA_cbe.html)", 
     status = "DEPR", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double GAUSS_CONSTANT; static { GAUSS_CONSTANT = 0.01720209895; } 

    /**
     * Hubble constant (uncertainty is 0.80 km s^-1 Mpc^-1)    
     * <p>
     * Source: C.L. Bennett, et al., 1 October 2013, 'Nine-Year Wilkinson Microwave Anisotropy Probe (WMAP) Observations: Final Maps and Results', Astrophysical Journal Supplement, Volume 208, 20<br/>
     * Status: CONF<br/>
     * Unit: km s^-1 Mpc^-1<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Hubble constant (uncertainty is 0.80 km s^-1 Mpc^-1)", 
     source = "C.L. Bennett, et al., 1 October 2013, 'Nine-Year Wilkinson Microwave Anisotropy Probe (WMAP) Observations: Final Maps and Results', Astrophysical Journal Supplement, Volume 208, 20", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "km s^-1 Mpc^-1") 
    public static final double HUBBLE_CONSTANT; static { HUBBLE_CONSTANT = 69.32; } // [km s^-1 Mpc^-1] 

    /**
     * Right ascension of the north Galactic pole in the ICRS system (numerical value should be regarded as exact)    
     * <p>
     * Source: ESA, 1997, 'The Hipparcos and Tycho Catalogues', ESA SP-1200, Volume 1, page 91<br/>
     * Status: CONF<br/>
     * Unit: deg<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Right ascension of the north Galactic pole in the ICRS system (numerical value should be regarded as exact)", 
     source = "ESA, 1997, 'The Hipparcos and Tycho Catalogues', ESA SP-1200, Volume 1, page 91", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "deg") 
    public static final double ICRS_NORTHGALACTICPOLE_RIGHTASCENSION; static { ICRS_NORTHGALACTICPOLE_RIGHTASCENSION = 192.85948; } // [deg] 

    /**
     * Declination of the north Galactic pole in the ICRS system (numerical value should be regarded as exact)    
     * <p>
     * Source: ESA, 1997, 'The Hipparcos and Tycho Catalogues', ESA SP-1200, Volume 1, page 91<br/>
     * Status: CONF<br/>
     * Unit: deg<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Declination of the north Galactic pole in the ICRS system (numerical value should be regarded as exact)", 
     source = "ESA, 1997, 'The Hipparcos and Tycho Catalogues', ESA SP-1200, Volume 1, page 91", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "deg") 
    public static final double ICRS_NORTHGALACTICPOLE_DECLINATION; static { ICRS_NORTHGALACTICPOLE_DECLINATION = 27.12825; } // [deg] 

    /**
     * Galactic longitude of the ascending node of the Galactic plane on the equator of the ICRS (numerical value should be regarded as exact)    
     * <p>
     * Source: ESA, 1997, 'The Hipparcos and Tycho Catalogues', ESA SP-1200, Volume 1, page 91<br/>
     * Status: CONF<br/>
     * Unit: deg<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Galactic longitude of the ascending node of the Galactic plane on the equator of the ICRS (numerical value should be regarded as exact)", 
     source = "ESA, 1997, 'The Hipparcos and Tycho Catalogues', ESA SP-1200, Volume 1, page 91", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "deg") 
    public static final double ICRS_LONGITUDEOFASCENDINGNODE; static { ICRS_LONGITUDEOFASCENDINGNODE = 32.93192; } // [deg] 

    /**
     * Inverse of the fine structure constant. Note: best-measured value equals 137.035999139 (P.J. Mohr, B.N. Taylor, D.B. Newell, 9 July 2015, 'The 2014 CODATA Recommended Values of the Fundamental Physical Constants', National Institute of Standards and Technology, Gaithersburg, MD 20899-8401; http://www.codata.org/ and http://physics.nist.gov/constants (Web Version 7.0))    
     * <p>
     * Status: CONF<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Inverse of the fine structure constant. Note: best-measured value equals 137.035999139 (P.J. Mohr, B.N. Taylor, D.B. Newell, 9 July 2015, 'The 2014 CODATA Recommended Values of the Fundamental Physical Constants', National Institute of Standards and Technology, Gaithersburg, MD 20899-8401; http://www.codata.org/ and http://physics.nist.gov/constants (Web Version 7.0))", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "") 
    public static final double INVERSEFINESTRUCTURE_CONSTANT; static { INVERSEFINESTRUCTURE_CONSTANT = 137.035999142; } 

    /**
     * Number of days per Julian century    
     * <p>
     * Source: IAU definition<br/>
     * Status: CONF<br/>
     * Unit: day<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Number of days per Julian century", 
     source = "IAU definition", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "day") 
    public static final double JULIANCENTURY_JULIANYEAR; static { JULIANCENTURY_JULIANYEAR = 36525.; } // [day] 

    /**
     * Julian date of the standard epoch J2000 = J2000.0, i.e., calendar date 2000 January 1, 12:00:00 h = 2000-01-01T12:00:00 TT    
     * <p>
     * Source: Definition (e.g., ESA, 1997, 'The Hipparcos and Tycho Catalogues', Volume 1, page 27)<br/>
     * Status: CONF<br/>
     * Unit: JD<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Julian date of the standard epoch J2000 = J2000.0, i.e., calendar date 2000 January 1, 12:00:00 h = 2000-01-01T12:00:00 TT", 
     source = "Definition (e.g., ESA, 1997, 'The Hipparcos and Tycho Catalogues', Volume 1, page 27)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "JD") 
    public static final double JULIANDATE_J2000; static { JULIANDATE_J2000 = 2451545.0; } // [JD] 

    /**
     * Julian date of the Gaia-specific reference epoch J2010 = J2010.0 = JD2455197.5 = 2010-01-01T00:00:00    
     * <p>
     * Source: U. Bastian, 5 July 2007, 'Reference systems, conventions, and notations for Gaia', GAIA-CA-SP-ARI-BAS-003, issue 6, revision 1, Section 3.5<br/>
     * Status: CONF<br/>
     * Unit: JD<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Julian date of the Gaia-specific reference epoch J2010 = J2010.0 = JD2455197.5 = 2010-01-01T00:00:00", 
     source = "U. Bastian, 5 July 2007, 'Reference systems, conventions, and notations for Gaia', GAIA-CA-SP-ARI-BAS-003, issue 6, revision 1, Section 3.5", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "JD") 
    public static final double JULIANDATE_J2010; static { JULIANDATE_J2010 = 2455197.5; } // [JD] 

    /**
     * Number of days per Julian year    
     * <p>
     * Source: IAU definition<br/>
     * Status: CONF<br/>
     * Unit: day<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Number of days per Julian year", 
     source = "IAU definition", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "day") 
    public static final double JULIANYEAR_DAY; static { JULIANYEAR_DAY = 365.25; } // [day] 

    /**
     * Chebyshev representation of the ephemerides of Jupiter, with origin at the barycentre of the solar system (BCRS), in the equatorial ICRF frame. The ephemeris covers the period starting on JD (JDBEGIP + JDBEGFP) and ending on JD (JDENDIP + JDENDFP) for the position and starting on JD (JDBEGIV + JDBEGFV) and ending on JD (JDENDIV + JDENDFV) for the velocity. A number of Chebyshev coefficients equal to ORDERSP is given for NSSP time intervals of SPANSP days to describe the position-vector components in units of m; the similar parameters ending with PP (Peculiar Position) are not used in the current release and are reserved for future usage. A number of Chebyshev coefficients equal to ORDERSV is given for NSSV time intervals of SPANSV days to describe the velocity-vector components in units of m s^-1; the similar parameters ending with PV (Peculiar Velocity) are not used in the current release and are reserved for future usage. The first three HDUs contain the coefficients for the three components of the position, while the last three HDUs contain the coefficients for the three components of the velocity    
     * <p>
     * Source: A. Fienga, J. Laskar, H. Manche, M. Gastineau, 19 April 2007, 'Solar system planetary ephemeris delivery: INPOP06', GAIA-CA-TN-IMC-AF-001, issue 1, revision 0<br/>
     * Status: DEPR<br/>
     * Basic : true<br/>
     * Scalar: false
     */
    @ParamMetaData (
    description = "Chebyshev representation of the ephemerides of Jupiter, with origin at the barycentre of the solar system (BCRS), in the equatorial ICRF frame. The ephemeris covers the period starting on JD (JDBEGIP + JDBEGFP) and ending on JD (JDENDIP + JDENDFP) for the position and starting on JD (JDBEGIV + JDBEGFV) and ending on JD (JDENDIV + JDENDFV) for the velocity. A number of Chebyshev coefficients equal to ORDERSP is given for NSSP time intervals of SPANSP days to describe the position-vector components in units of m; the similar parameters ending with PP (Peculiar Position) are not used in the current release and are reserved for future usage. A number of Chebyshev coefficients equal to ORDERSV is given for NSSV time intervals of SPANSV days to describe the velocity-vector components in units of m s^-1; the similar parameters ending with PV (Peculiar Velocity) are not used in the current release and are reserved for future usage. The first three HDUs contain the coefficients for the three components of the position, while the last three HDUs contain the coefficients for the three components of the velocity", 
     source = "A. Fienga, J. Laskar, H. Manche, M. Gastineau, 19 April 2007, 'Solar system planetary ephemeris delivery: INPOP06', GAIA-CA-TN-IMC-AF-001, issue 1, revision 0", 
     status = "DEPR", 
     basic = true, 
     scalar = false, 
     unit = "") 
    public static final String JUPITER_EPHEMERIS; static { JUPITER_EPHEMERIS = "Nature/Jupiter_Ephemeris_004.fits"; } 

    /**
     * IAU-recommended value for the right ascension \alpha_0 of the north pole of rotation of Jupiter. The pair (\alpha_0, \delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \alpha_0 = 273.85 deg and \delta_0 = 66.99 degrees    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)<br/>
     * Status: CONF<br/>
     * Unit: deg<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "IAU-recommended value for the right ascension \\alpha_0 of the north pole of rotation of Jupiter. The pair (\\alpha_0, \\delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \\alpha_0 = 273.85 deg and \\delta_0 = 66.99 degrees", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "deg") 
    public static final double JUPITER_NORTHROTATIONALPOLE_RIGHTASCENSION; static { JUPITER_NORTHROTATIONALPOLE_RIGHTASCENSION = 268.056595; } // [deg] 

    /**
     * IAU-recommended value for the rate of change (in degrees per Julian day, calculated from the standard epoch) of the right ascension \alpha_0 of the north pole of rotation of Jupiter. The pair (\alpha_0, \delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \alpha_0 = 273.85 deg and \delta_0 = 66.99 degrees    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)<br/>
     * Status: CONF<br/>
     * Unit: deg day^-1<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "IAU-recommended value for the rate of change (in degrees per Julian day, calculated from the standard epoch) of the right ascension \\alpha_0 of the north pole of rotation of Jupiter. The pair (\\alpha_0, \\delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \\alpha_0 = 273.85 deg and \\delta_0 = 66.99 degrees", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "deg day^-1") 
    public static final double JUPITER_NORTHROTATIONALPOLE_RIGHTASCENSIONRATEOFCHANGE; static { JUPITER_NORTHROTATIONALPOLE_RIGHTASCENSIONRATEOFCHANGE = -0.000000177933; } // [deg day^-1] 

    /**
     * IAU-recommended value for the declination \delta_0 of the north pole of rotation of Jupiter. The pair (\alpha_0, \delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \alpha_0 = 273.85 deg and \delta_0 = 66.99 degrees    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)<br/>
     * Status: CONF<br/>
     * Unit: deg<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "IAU-recommended value for the declination \\delta_0 of the north pole of rotation of Jupiter. The pair (\\alpha_0, \\delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \\alpha_0 = 273.85 deg and \\delta_0 = 66.99 degrees", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "deg") 
    public static final double JUPITER_NORTHROTATIONALPOLE_DECLINATION; static { JUPITER_NORTHROTATIONALPOLE_DECLINATION = 64.495303; } // [deg] 

    /**
     * IAU-recommended value for the rate of change (in degrees per Julian day, calculated from the standard epoch) of the declination \delta_0 of the north pole of rotation of Jupiter. The pair (\alpha_0, \delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \alpha_0 = 273.85 deg and \delta_0 = 66.99 degrees    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)<br/>
     * Status: CONF<br/>
     * Unit: deg day^-1<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "IAU-recommended value for the rate of change (in degrees per Julian day, calculated from the standard epoch) of the declination \\delta_0 of the north pole of rotation of Jupiter. The pair (\\alpha_0, \\delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \\alpha_0 = 273.85 deg and \\delta_0 = 66.99 degrees", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "deg day^-1") 
    public static final double JUPITER_NORTHROTATIONALPOLE_DECLINATIONRATEOFCHANGE; static { JUPITER_NORTHROTATIONALPOLE_DECLINATIONRATEOFCHANGE = 0.000000066064; } // [deg day^-1] 

    /**
     * IAU-recommended value for the ephemeris position of the prime meridian of Jupiter. The prime meridian refers to the rotation of the magnetic field System III. System I (W_{I} = 67.1 deg + 877.900 deg day^-1) refers to the mean atmospheric equatorial rotation. System II (W_{II} = 43.3 deg + 870.270 deg day^-1) refers to the mean atmospheric rotation north of the south component of the north equatorial belt, and south of the north component of the south equatorial belt. The location of the prime meridian is specified by the angle that is measured along the planet's equator in an easterly direction with respect to the planet's north pole from the node Q (located at right ascension 90 deg + \alpha_0, where \alpha_0 denotes the right ascension of the north pole of rotation) of the planet's equator on the standard equator to the point B where the prime meridian crosses the planet's equator. The right ascension of the point Q is 90 deg + \alpha_0 and the inclination of the planet's equator to the standard equator is 90 deg - \delta_0, where \delta_0 denotes the declination of the north pole of rotation. (The pair (\alpha_0, \delta_0) denotes the standard equatorial coordinates, with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB), of the north pole of rotation, which itself is defined as that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \alpha_0 = 273.85 deg and \delta_0 = 66.99 degrees.) Because the prime meridian is assumed to rotate uniformly with the planet, W accordingly varies linearly with time. In addition, \alpha_0, \delta_0, and W may vary with time due to a precession of the axis of rotation of the planet. If W increases with time, the planet has a direct (or prograde) rotation; if W decreases with time, the rotation is said to be retrograde    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)<br/>
     * Status: CONF<br/>
     * Unit: deg<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "IAU-recommended value for the ephemeris position of the prime meridian of Jupiter. The prime meridian refers to the rotation of the magnetic field System III. System I (W_{I} = 67.1 deg + 877.900 deg day^-1) refers to the mean atmospheric equatorial rotation. System II (W_{II} = 43.3 deg + 870.270 deg day^-1) refers to the mean atmospheric rotation north of the south component of the north equatorial belt, and south of the north component of the south equatorial belt. The location of the prime meridian is specified by the angle that is measured along the planet's equator in an easterly direction with respect to the planet's north pole from the node Q (located at right ascension 90 deg + \\alpha_0, where \\alpha_0 denotes the right ascension of the north pole of rotation) of the planet's equator on the standard equator to the point B where the prime meridian crosses the planet's equator. The right ascension of the point Q is 90 deg + \\alpha_0 and the inclination of the planet's equator to the standard equator is 90 deg - \\delta_0, where \\delta_0 denotes the declination of the north pole of rotation. (The pair (\\alpha_0, \\delta_0) denotes the standard equatorial coordinates, with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB), of the north pole of rotation, which itself is defined as that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \\alpha_0 = 273.85 deg and \\delta_0 = 66.99 degrees.) Because the prime meridian is assumed to rotate uniformly with the planet, W accordingly varies linearly with time. In addition, \\alpha_0, \\delta_0, and W may vary with time due to a precession of the axis of rotation of the planet. If W increases with time, the planet has a direct (or prograde) rotation; if W decreases with time, the rotation is said to be retrograde", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "deg") 
    public static final double JUPITER_PRIMEMERIDIAN_EPHEMERISPOSITION; static { JUPITER_PRIMEMERIDIAN_EPHEMERISPOSITION = 284.95; } // [deg] 

    /**
     * IAU-recommended value for the rate of change (in degrees per Julian day, calculated from the standard epoch of 1.5 January 2000 = JD2451545.0 TDB) of the ephemeris position of the prime meridian of Jupiter. The prime meridian refers to the rotation of the magnetic field System III. System I (W_{I} = 67.1 deg + 877.900 deg day^-1) refers to the mean atmospheric equatorial rotation. System II (W_{II} = 43.3 deg + 870.270 deg day^-1) refers to the mean atmospheric rotation north of the south component of the north equatorial belt, and south of the north component of the south equatorial belt. The location of the prime meridian is specified by the angle that is measured along the planet's equator in an easterly direction with respect to the planet's north pole from the node Q (located at right ascension 90 deg + \alpha_0, where \alpha_0 denotes the right ascension of the north pole of rotation) of the planet's equator on the standard equator to the point B where the prime meridian crosses the planet's equator. The right ascension of the point Q is 90 deg + \alpha_0 and the inclination of the planet's equator to the standard equator is 90 deg - \delta_0, where \delta_0 denotes the declination of the north pole of rotation. (The pair (\alpha_0, \delta_0) denotes the standard equatorial coordinates, with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB), of the north pole of rotation, which itself is defined as that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \alpha_0 = 273.85 deg and \delta_0 = 66.99 degrees.) Because the prime meridian is assumed to rotate uniformly with the planet, W accordingly varies linearly with time. In addition, \alpha_0, \delta_0, and W may vary with time due to a precession of the axis of rotation of the planet. If W increases with time, the planet has a direct (or prograde) rotation; if W decreases with time, the rotation is said to be retrograde    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)<br/>
     * Status: CONF<br/>
     * Unit: deg day^-1<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "IAU-recommended value for the rate of change (in degrees per Julian day, calculated from the standard epoch of 1.5 January 2000 = JD2451545.0 TDB) of the ephemeris position of the prime meridian of Jupiter. The prime meridian refers to the rotation of the magnetic field System III. System I (W_{I} = 67.1 deg + 877.900 deg day^-1) refers to the mean atmospheric equatorial rotation. System II (W_{II} = 43.3 deg + 870.270 deg day^-1) refers to the mean atmospheric rotation north of the south component of the north equatorial belt, and south of the north component of the south equatorial belt. The location of the prime meridian is specified by the angle that is measured along the planet's equator in an easterly direction with respect to the planet's north pole from the node Q (located at right ascension 90 deg + \\alpha_0, where \\alpha_0 denotes the right ascension of the north pole of rotation) of the planet's equator on the standard equator to the point B where the prime meridian crosses the planet's equator. The right ascension of the point Q is 90 deg + \\alpha_0 and the inclination of the planet's equator to the standard equator is 90 deg - \\delta_0, where \\delta_0 denotes the declination of the north pole of rotation. (The pair (\\alpha_0, \\delta_0) denotes the standard equatorial coordinates, with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB), of the north pole of rotation, which itself is defined as that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \\alpha_0 = 273.85 deg and \\delta_0 = 66.99 degrees.) Because the prime meridian is assumed to rotate uniformly with the planet, W accordingly varies linearly with time. In addition, \\alpha_0, \\delta_0, and W may vary with time due to a precession of the axis of rotation of the planet. If W increases with time, the planet has a direct (or prograde) rotation; if W decreases with time, the rotation is said to be retrograde", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "deg day^-1") 
    public static final double JUPITER_PRIMEMERIDIAN_EPHEMERISPOSITIONRATEOFCHANGE; static { JUPITER_PRIMEMERIDIAN_EPHEMERISPOSITIONRATEOFCHANGE = 870.5360000; } // [deg day^-1] 

    /**
     * Mass of Jupiter (do not use for high-precision (orbit) calculations)    
     * <p>
     * Source: R.A. Jacobson, 2005, 'Jovian Satellite ephemeris - JUP230', priv. comm.; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par<br/>
     * Status: CONF<br/>
     * Unit: kg<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mass of Jupiter (do not use for high-precision (orbit) calculations)", 
     source = "R.A. Jacobson, 2005, 'Jovian Satellite ephemeris - JUP230', priv. comm.; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "kg") 
    public static final double JUPITER_MASS; static { JUPITER_MASS = 1.898130e+27; } // [kg] 

    /**
     * Mean volumetric radius of Jupiter    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A); see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par<br/>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean volumetric radius of Jupiter", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A); see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "m") 
    public static final double JUPITER_VOLUMETRICRADIUS; static { JUPITER_VOLUMETRICRADIUS = 6.99110e+7; } // [m] 

    /**
     * Equatorial radius of Jupiter    
     * <p>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Equatorial radius of Jupiter", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m") 
    public static final double JUPITER_EQUATORIALRADIUS; static { JUPITER_EQUATORIALRADIUS = 7.14917e+7; } // [m] 

    /**
     * Polar radius of Jupiter    
     * <p>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Polar radius of Jupiter", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m") 
    public static final double JUPITER_POLARRADIUS; static { JUPITER_POLARRADIUS = 6.68537e+7; } // [m] 

    /**
     * V(1,0) magnitude of Jupiter (i.e., the visual magnitude of the planet reduced to a distance of 1 au from both the Sun and Earth and phase angle zero). This parameter is also refered to as absolute magnitude in planetary sciences    
     * <p>
     * Source: P.K. Seidelmann, 1992, 'Explanatory Supplement to the Astronomical Almanac', University Science Books, Mill Valley, Ca., ISBN 0-935702-68-7, Table 15.8 on page 706; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par<br/>
     * Status: CONF<br/>
     * Unit: mag<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "V(1,0) magnitude of Jupiter (i.e., the visual magnitude of the planet reduced to a distance of 1 au from both the Sun and Earth and phase angle zero). This parameter is also refered to as absolute magnitude in planetary sciences", 
     source = "P.K. Seidelmann, 1992, 'Explanatory Supplement to the Astronomical Almanac', University Science Books, Mill Valley, Ca., ISBN 0-935702-68-7, Table 15.8 on page 706; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "mag") 
    public static final double JUPITER_VONEZEROMAGNITUDE; static { JUPITER_VONEZEROMAGNITUDE = -9.40; } // [mag] 

    /**
     * Geometric albedo of Jupiter (i.e., the ratio of the body's brightness at zero phase angle to the brightness of a perfectly diffusing disk with the same position and apparent size as the body)    
     * <p>
     * Source: P.K. Seidelmann, 1992, 'Explanatory Supplement to the Astronomical Almanac', University Science Books, Mill Valley, Ca., ISBN 0-935702-68-7, Table 15.8 on page 706; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Geometric albedo of Jupiter (i.e., the ratio of the body's brightness at zero phase angle to the brightness of a perfectly diffusing disk with the same position and apparent size as the body)", 
     source = "P.K. Seidelmann, 1992, 'Explanatory Supplement to the Astronomical Almanac', University Science Books, Mill Valley, Ca., ISBN 0-935702-68-7, Table 15.8 on page 706; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double JUPITER_GEOMETRICALBEDO; static { JUPITER_GEOMETRICALBEDO = 0.52; } 

    /**
     * Mean mass density of Jupiter    
     * <p>
     * Status: CONF<br/>
     * Unit: g cm^-3<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean mass density of Jupiter", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "g cm^-3") 
    public static final double JUPITER_MASSDENSITY_MEAN; static { JUPITER_MASSDENSITY_MEAN = 1.3262; } // [g cm^-3] 

    /**
     * Radius of the smallest hypothetical sphere around Jupiter which would encompass the body (this is a low-accuracy parameter used in the relativistic model)    
     * <p>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Radius of the smallest hypothetical sphere around Jupiter which would encompass the body (this is a low-accuracy parameter used in the relativistic model)", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m") 
    public static final double JUPITER_ENCOMPASSINGSPHERERADIUS; static { JUPITER_ENCOMPASSINGSPHERERADIUS = 7.14917e+7; } // [m] 

    /**
     * Dynamical form-factor of Jupiter (oblateness or Stokes' second-degree zonal harmonic of the potential)    
     * <p>
     * Source: P.R. Weissman, L.-A. McFadden, T.V. Johnson (eds.), 1999, 'Encyclopedia of the Solar System (first edition)', Academic Press, page 342<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Dynamical form-factor of Jupiter (oblateness or Stokes' second-degree zonal harmonic of the potential)", 
     source = "P.R. Weissman, L.-A. McFadden, T.V. Johnson (eds.), 1999, 'Encyclopedia of the Solar System (first edition)', Academic Press, page 342", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double JUPITER_JSUB2; static { JUPITER_JSUB2 = 0.014697; } 

    /**
     * Geometrical flattening factor f of Jupiter (f = (a-b)/a)    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A); see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Geometrical flattening factor f of Jupiter (f = (a-b)/a)", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A); see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double JUPITER_FLATTENING; static { JUPITER_FLATTENING = 6.487440e-2; } 

    /**
     * Nominal equatorial radius of Jupiter (one-bar value), in SI units. This nominal value shall be understood as conversion factor only    
     * <p>
     * Source: E. Mamajek, et al., 2015, 'IAU 2015 Resolution B3 on Recommended Nominal Conversion Constants for Selected Solar and Planetary Properties', arXiv:1510.07674 (see also https://www.iau.org/administration/resolutions/general_assemblies/)<br/>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Nominal equatorial radius of Jupiter (one-bar value), in SI units. This nominal value shall be understood as conversion factor only", 
     source = "E. Mamajek, et al., 2015, 'IAU 2015 Resolution B3 on Recommended Nominal Conversion Constants for Selected Solar and Planetary Properties', arXiv:1510.07674 (see also https://www.iau.org/administration/resolutions/general_assemblies/)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "m") 
    public static final double JUPITER_EQUATORIALRADIUS_NOMINAL; static { JUPITER_EQUATORIALRADIUS_NOMINAL = 7.14920e+7; } // [m] 

    /**
     * Nominal polar radius of Jupiter (one-bar value), in SI units. This nominal value shall be understood as conversion factor only    
     * <p>
     * Source: E. Mamajek, et al., 2015, 'IAU 2015 Resolution B3 on Recommended Nominal Conversion Constants for Selected Solar and Planetary Properties', arXiv:1510.07674 (see also https://www.iau.org/administration/resolutions/general_assemblies/)<br/>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Nominal polar radius of Jupiter (one-bar value), in SI units. This nominal value shall be understood as conversion factor only", 
     source = "E. Mamajek, et al., 2015, 'IAU 2015 Resolution B3 on Recommended Nominal Conversion Constants for Selected Solar and Planetary Properties', arXiv:1510.07674 (see also https://www.iau.org/administration/resolutions/general_assemblies/)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "m") 
    public static final double JUPITER_POLARRADIUS_NOMINAL; static { JUPITER_POLARRADIUS_NOMINAL = 6.68540e+7; } // [m] 

    /**
     * Nominal GM of Jupiter, in SI units. This nominal value shall be understood as conversion factor only    
     * <p>
     * Source: E. Mamajek, et al., 2015, 'IAU 2015 Resolution B3 on Recommended Nominal Conversion Constants for Selected Solar and Planetary Properties', arXiv:1510.07674 (see also https://www.iau.org/administration/resolutions/general_assemblies/)<br/>
     * Status: CONF<br/>
     * Unit: m^3 s^-2<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Nominal GM of Jupiter, in SI units. This nominal value shall be understood as conversion factor only", 
     source = "E. Mamajek, et al., 2015, 'IAU 2015 Resolution B3 on Recommended Nominal Conversion Constants for Selected Solar and Planetary Properties', arXiv:1510.07674 (see also https://www.iau.org/administration/resolutions/general_assemblies/)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "m^3 s^-2") 
    public static final double JUPITER_GM_NOMINAL; static { JUPITER_GM_NOMINAL = 1.26686530e+17; } // [m^3 s^-2] 

    /**
     * Post-Newtonian deflection angle of a limb-grazing light ray due to the spherically symmetric part of the gravitational field of Jupiter    
     * <p>
     * Source: S.A. Klioner, 2003, 'A Practical Relativistic Model for Microarcsecond Astrometry in Space', AJ, 125, 1580, Equation 64 with cot(x) = cos(x) / sin(x) approximated by x^-1; see also J.H.J. de Bruijne, 19 February 2002, 'Gravitational light deflection', GAIA-JdB-001, issue 1, revision 0<br/>
     * Status: CONF<br/>
     * Unit: 10^-6 arcsec<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Post-Newtonian deflection angle of a limb-grazing light ray due to the spherically symmetric part of the gravitational field of Jupiter", 
     source = "S.A. Klioner, 2003, 'A Practical Relativistic Model for Microarcsecond Astrometry in Space', AJ, 125, 1580, Equation 64 with cot(x) = cos(x) / sin(x) approximated by x^-1; see also J.H.J. de Bruijne, 19 February 2002, 'Gravitational light deflection', GAIA-JdB-001, issue 1, revision 0", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "10^-6 arcsec") 
    public static final double JUPITER_LIGHTDEFLECTION_LIMB; static { JUPITER_LIGHTDEFLECTION_LIMB = 16635.; } // [10^-6 arcsec] 

    /**
     * Geometric transit probability (Jupiter transiting the Sun) for an observer external to the solar system    
     * <p>
     * Source: E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 2.1, Equation 2.2, page 14<br/>
     * Status: CONF<br/>
     * Unit: %<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Geometric transit probability (Jupiter transiting the Sun) for an observer external to the solar system", 
     source = "E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 2.1, Equation 2.2, page 14", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "%") 
    public static final double JUPITER_TRANSITPROBABILITY; static { JUPITER_TRANSITPROBABILITY = 0.098; } // [%] 

    /**
     * Maximum reduction of the solar flux for an observer external to the solar system during a transit of Jupiter    
     * <p>
     * Source: E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 2.2, Equation 2.4, page 14<br/>
     * Status: CONF<br/>
     * Unit: %<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Maximum reduction of the solar flux for an observer external to the solar system during a transit of Jupiter", 
     source = "E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 2.2, Equation 2.4, page 14", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "%") 
    public static final double JUPITER_FLUXREDUCTION_MAXIMUM; static { JUPITER_FLUXREDUCTION_MAXIMUM = 1.010; } // [%] 

    /**
     * Maximum transit time of Jupiter (transiting the Sun) for an observer external to the solar system    
     * <p>
     * Source: E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 2.3, Equation 2.5, page 15<br/>
     * Status: CONF<br/>
     * Unit: day<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Maximum transit time of Jupiter (transiting the Sun) for an observer external to the solar system", 
     source = "E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 2.3, Equation 2.5, page 15", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "day") 
    public static final double JUPITER_TRANSITTIME_MAXIMUM; static { JUPITER_TRANSITTIME_MAXIMUM = 1.36; } // [day] 

    /**
     * Jupiter-system mass (IAU 2009 CBE value). The planetary mass includes the contribution of its satellites    
     * <p>
     * Status: CONF<br/>
     * Unit: kg<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Jupiter-system mass (IAU 2009 CBE value). The planetary mass includes the contribution of its satellites", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "kg") 
    public static final double JUPITERSYSTEM_MASS; static { JUPITERSYSTEM_MASS = 1.89858e+27; } // [kg] 

    /**
     * Mean orbital semi-major axis of Jupiter, at the standard epoch J2000.0. The mean orbital semi-major axis is associated with a mean orbit solution from a 250-year least-squares fit of JPL's DE405 ephemeris to a Keplerian orbit covering the interval of years 1800 AD - 2050 AD. The orbital element is referenced to the mean ecliptic and equinox of J2000 at the standard epoch J2000.0; linear rates and fit errors can be found in the reference document    
     * <p>
     * Source: E.M. Standish, 16 February 2006, 'Keplerian Elements for Approximate Positions of the Major Planets', http://ssd.jpl.nasa.gov/?planets\#elem<br/>
     * Status: CONF<br/>
     * Unit: au<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean orbital semi-major axis of Jupiter, at the standard epoch J2000.0. The mean orbital semi-major axis is associated with a mean orbit solution from a 250-year least-squares fit of JPL's DE405 ephemeris to a Keplerian orbit covering the interval of years 1800 AD - 2050 AD. The orbital element is referenced to the mean ecliptic and equinox of J2000 at the standard epoch J2000.0; linear rates and fit errors can be found in the reference document", 
     source = "E.M. Standish, 16 February 2006, 'Keplerian Elements for Approximate Positions of the Major Planets', http://ssd.jpl.nasa.gov/?planets\\#elem", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "au") 
    public static final double JUPITERSYSTEM_ORBITALSEMIMAJORAXIS_J2000; static { JUPITERSYSTEM_ORBITALSEMIMAJORAXIS_J2000 = 5.20288700; } // [au] 

    /**
     * Mean orbital eccentricity of Jupiter, at the standard epoch J2000.0. The mean orbital eccentricity is associated with a mean orbit solution from a 250-year least-squares fit of JPL's DE405 ephemeris to a Keplerian orbit covering the interval of years 1800 AD - 2050 AD. The orbital element is referenced to the mean ecliptic and equinox of J2000 at the standard epoch J2000.0; linear rates and fit errors can be found in the reference document    
     * <p>
     * Source: E.M. Standish, 16 February 2006, 'Keplerian Elements for Approximate Positions of the Major Planets', http://ssd.jpl.nasa.gov/?planets\#elem<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean orbital eccentricity of Jupiter, at the standard epoch J2000.0. The mean orbital eccentricity is associated with a mean orbit solution from a 250-year least-squares fit of JPL's DE405 ephemeris to a Keplerian orbit covering the interval of years 1800 AD - 2050 AD. The orbital element is referenced to the mean ecliptic and equinox of J2000 at the standard epoch J2000.0; linear rates and fit errors can be found in the reference document", 
     source = "E.M. Standish, 16 February 2006, 'Keplerian Elements for Approximate Positions of the Major Planets', http://ssd.jpl.nasa.gov/?planets\\#elem", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double JUPITERSYSTEM_ORBITALECCENTRICITY_J2000; static { JUPITERSYSTEM_ORBITALECCENTRICITY_J2000 = 0.04838624; } 

    /**
     * Mean orbital inclination of Jupiter, at the standard epoch J2000.0. The mean orbital inclination is is associated with a mean orbit solution from a 250-year least-squares fit of JPL's DE405 ephemeris to a Keplerian orbit covering the interval of years 1800 AD - 2050 AD. The orbital element is referenced to the mean ecliptic and equinox of J2000 at the standard epoch J2000.0; linear rates and fit errors can be found in the reference document    
     * <p>
     * Source: E.M. Standish, 16 February 2006, 'Keplerian Elements for Approximate Positions of the Major Planets', http://ssd.jpl.nasa.gov/?planets\#elem<br/>
     * Status: CONF<br/>
     * Unit: deg<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean orbital inclination of Jupiter, at the standard epoch J2000.0. The mean orbital inclination is is associated with a mean orbit solution from a 250-year least-squares fit of JPL's DE405 ephemeris to a Keplerian orbit covering the interval of years 1800 AD - 2050 AD. The orbital element is referenced to the mean ecliptic and equinox of J2000 at the standard epoch J2000.0; linear rates and fit errors can be found in the reference document", 
     source = "E.M. Standish, 16 February 2006, 'Keplerian Elements for Approximate Positions of the Major Planets', http://ssd.jpl.nasa.gov/?planets\\#elem", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "deg") 
    public static final double JUPITERSYSTEM_ORBITALINCLINATION_J2000; static { JUPITERSYSTEM_ORBITALINCLINATION_J2000 = 1.30439695; } // [deg] 

    /**
     * Radial-velocity amplitude of the Sun induced by the Jupiter system for 'an edge-on observer' (i.e., an observer in the orbital plane of the Jupiter system)    
     * <p>
     * Source: E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 1.4, Equation 1.18, page 9<br/>
     * Status: CONF<br/>
     * Unit: m s^-1<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Radial-velocity amplitude of the Sun induced by the Jupiter system for 'an edge-on observer' (i.e., an observer in the orbital plane of the Jupiter system)", 
     source = "E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 1.4, Equation 1.18, page 9", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m s^-1") 
    public static final double JUPITERSYSTEM_RADIALVELOCITYSIGNATURE; static { JUPITERSYSTEM_RADIALVELOCITYSIGNATURE = 12.5; } // [m s^-1] 

    /**
     * Sidereal orbital period    
     * <p>
     * Source: Values derived from the mean longitude rates in Table 5.8.1 in P.K. Seidelmann, 1992, 'Explanatory Supplement to the Astronomical Almanac', University Science Books, Mill Valley, Ca., ISBN 0-935702-68-7, page 316; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par<br/>
     * Status: CONF<br/>
     * Unit: yr<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Sidereal orbital period", 
     source = "Values derived from the mean longitude rates in Table 5.8.1 in P.K. Seidelmann, 1992, 'Explanatory Supplement to the Astronomical Almanac', University Science Books, Mill Valley, Ca., ISBN 0-935702-68-7, page 316; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "yr") 
    public static final double JUPITERSYSTEM_ORBITALPERIOD; static { JUPITERSYSTEM_ORBITALPERIOD = 11.862615; } // [yr] 

    /**
     * Astrometric signature of the Sun induced by the Jupiter system for an observer located at a distance of 10 pc from the Sun    
     * <p>
     * Source: E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 1.7, Equation 1.22, page 11<br/>
     * Status: CONF<br/>
     * Unit: 10^-6 arcsec<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Astrometric signature of the Sun induced by the Jupiter system for an observer located at a distance of 10 pc from the Sun", 
     source = "E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 1.7, Equation 1.22, page 11", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "10^-6 arcsec") 
    public static final double JUPITERSYSTEM_ASTROMETRICSIGNATURE_10PARSEC; static { JUPITERSYSTEM_ASTROMETRICSIGNATURE_10PARSEC = 497.; } // [10^-6 arcsec] 

    /**
     * Photon flux density N_{\lambda}(\lambda) of an unreddened K1III metal-poor (MP) star (Pickles' star number 082) at V = 0 mag. First column: wavelength \lambda (in nm; from 115.0 to 1062.0). Second column: photon flux density above the Earth's atmosphere (in photons m^-2 s^-1 nm^-1; the photometric zero point is described in J.H.J. de Bruijne, 26 May 2003, 'Stellar fluxes: transformations and calibrations', GAIA-JdB-005, issue 1, revision 1)    
     * <p>
     * Source: A.J. Pickles, 1998, 'A stellar spectral flux library: 1150-25000 AA', PASP, 110, 863<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: false
     */
    @ParamMetaData (
    description = "Photon flux density N_{\\lambda}(\\lambda) of an unreddened K1III metal-poor (MP) star (Pickles' star number 082) at V = 0 mag. First column: wavelength \\lambda (in nm; from 115.0 to 1062.0). Second column: photon flux density above the Earth's atmosphere (in photons m^-2 s^-1 nm^-1; the photometric zero point is described in J.H.J. de Bruijne, 26 May 2003, 'Stellar fluxes: transformations and calibrations', GAIA-JdB-005, issue 1, revision 1)", 
     source = "A.J. Pickles, 1998, 'A stellar spectral flux library: 1150-25000 AA', PASP, 110, 863", 
     status = "CONF", 
     basic = true, 
     scalar = false, 
     unit = "") 
    public static final String K1IIIMPSTAR_SPECTRUM_NUMBEROFPHOTONS; static { K1IIIMPSTAR_SPECTRUM_NUMBEROFPHOTONS = "Nature/K1IIIMPStar_Spectrum_NumberOfPhotons_001.fits"; } 

    /**
     * High-resolution photon-flux density N_{\lambda}(\lambda) of an unreddened K1III metal-poor (MP) star at V = 15 mag. The data refer to a high-resolution Kurucz-model spectrum with the following properties: effective temperature T_eff = 4500 K, logarithm of surface gravity log g = 2.0, metallicity [Fe/H] = -1.5, alpha-elements [\alpha/Fe] = +0.4, rotational velocity v sini = 5 km s^-1, micro-turbulence velocity = 2.0 km s^-1, length of convective bubble divided by pressure scale height = 0.50, no convective overshooting, macro-turbulence velocity = 2.0 km s^-1, and resolving power R = \lambda / \delta \lambda = 250,000. First column: wavelength \lambda (in nm; from 830.1673264 to 889.8217922). Second column: photon flux density above the Earth's atmosphere (in photons m^-2 s^-1 nm^-1). The 34698 lines have an average wavelength step of 0.00172 nm; the spectrum extent is thus 59.7 nm    
     * <p>
     * Source: ESA, 20 June 2005, 'Photon-flux distributions for reference stars', GAIA-EST-TN-00539, issue 1, revision 0, based on D. Katz, priv. comm., 11 May 2005<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: false
     */
    @ParamMetaData (
    description = "High-resolution photon-flux density N_{\\lambda}(\\lambda) of an unreddened K1III metal-poor (MP) star at V = 15 mag. The data refer to a high-resolution Kurucz-model spectrum with the following properties: effective temperature T_eff = 4500 K, logarithm of surface gravity log g = 2.0, metallicity [Fe/H] = -1.5, alpha-elements [\\alpha/Fe] = +0.4, rotational velocity v sini = 5 km s^-1, micro-turbulence velocity = 2.0 km s^-1, length of convective bubble divided by pressure scale height = 0.50, no convective overshooting, macro-turbulence velocity = 2.0 km s^-1, and resolving power R = \\lambda / \\delta \\lambda = 250,000. First column: wavelength \\lambda (in nm; from 830.1673264 to 889.8217922). Second column: photon flux density above the Earth's atmosphere (in photons m^-2 s^-1 nm^-1). The 34698 lines have an average wavelength step of 0.00172 nm; the spectrum extent is thus 59.7 nm", 
     source = "ESA, 20 June 2005, 'Photon-flux distributions for reference stars', GAIA-EST-TN-00539, issue 1, revision 0, based on D. Katz, priv. comm., 11 May 2005", 
     status = "CONF", 
     basic = true, 
     scalar = false, 
     unit = "") 
    public static final String K1IIIMPSTAR_SPECTRUM_NUMBEROFPHOTONSHIGHRESOLUTION; static { K1IIIMPSTAR_SPECTRUM_NUMBEROFPHOTONSHIGHRESOLUTION = "Nature/K1IIIMPStar_Spectrum_NumberOfPhotonsHighResolution_001.fits"; } 

    /**
     * Photon flux density N_{\lambda}(\lambda) of an unreddened K3III star (Pickles' star number 087) at V = 0 mag. First column: wavelength \lambda (in nm; from 115.0 to 1062.0). Second column: photon flux density above the Earth's atmosphere (in photons m^-2 s^-1 nm^-1; the photometric zero point is described in J.H.J. de Bruijne, 26 May 2003, 'Stellar fluxes: transformations and calibrations', GAIA-JdB-005, issue 1, revision 1)    
     * <p>
     * Source: A.J. Pickles, 1998, 'A stellar spectral flux library: 1150-25000 AA', PASP, 110, 863<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: false
     */
    @ParamMetaData (
    description = "Photon flux density N_{\\lambda}(\\lambda) of an unreddened K3III star (Pickles' star number 087) at V = 0 mag. First column: wavelength \\lambda (in nm; from 115.0 to 1062.0). Second column: photon flux density above the Earth's atmosphere (in photons m^-2 s^-1 nm^-1; the photometric zero point is described in J.H.J. de Bruijne, 26 May 2003, 'Stellar fluxes: transformations and calibrations', GAIA-JdB-005, issue 1, revision 1)", 
     source = "A.J. Pickles, 1998, 'A stellar spectral flux library: 1150-25000 AA', PASP, 110, 863", 
     status = "CONF", 
     basic = true, 
     scalar = false, 
     unit = "") 
    public static final String K3IIISTAR_SPECTRUM_NUMBEROFPHOTONS; static { K3IIISTAR_SPECTRUM_NUMBEROFPHOTONS = "Nature/K3IIIStar_Spectrum_NumberOfPhotons_001.fits"; } 

    /**
     * Photon flux density N_{\lambda}(\lambda) of an unreddened K3V star (Pickles' star number 034) at V = 0 mag. First column: wavelength \lambda (in nm; from 115.0 to 1062.0). Second column: photon flux density above the Earth's atmosphere (in photons m^-2 s^-1 nm^-1; the photometric zero point is described in J.H.J. de Bruijne, 26 May 2003, 'Stellar fluxes: transformations and calibrations', GAIA-JdB-005, issue 1, revision 1)    
     * <p>
     * Source: A.J. Pickles, 1998, 'A stellar spectral flux library: 1150-25000 AA', PASP, 110, 863<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: false
     */
    @ParamMetaData (
    description = "Photon flux density N_{\\lambda}(\\lambda) of an unreddened K3V star (Pickles' star number 034) at V = 0 mag. First column: wavelength \\lambda (in nm; from 115.0 to 1062.0). Second column: photon flux density above the Earth's atmosphere (in photons m^-2 s^-1 nm^-1; the photometric zero point is described in J.H.J. de Bruijne, 26 May 2003, 'Stellar fluxes: transformations and calibrations', GAIA-JdB-005, issue 1, revision 1)", 
     source = "A.J. Pickles, 1998, 'A stellar spectral flux library: 1150-25000 AA', PASP, 110, 863", 
     status = "CONF", 
     basic = true, 
     scalar = false, 
     unit = "") 
    public static final String K3VSTAR_SPECTRUM_NUMBEROFPHOTONS; static { K3VSTAR_SPECTRUM_NUMBEROFPHOTONS = "Nature/K3VStar_Spectrum_NumberOfPhotons_001.fits"; } 

    /**
     * Mean orbital semi-major axis of the L2 orbit of the Sun and Earth-Moon system, at the standard epoch J2000.0. The orbital element is referenced to the mean ecliptic and equinox of J2000 at the standard epoch J2000.0. DE405 is based upon the International Celestial Reference Frame (ICRF)    
     * <p>
     * Source: F. Mignard, 15 March 2002, 'Considerations on the orbit of Gaia for simulations', GAIA-FM-011, issue 1, revision 0, Section 3<br/>
     * Status: CONF<br/>
     * Unit: au<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean orbital semi-major axis of the L2 orbit of the Sun and Earth-Moon system, at the standard epoch J2000.0. The orbital element is referenced to the mean ecliptic and equinox of J2000 at the standard epoch J2000.0. DE405 is based upon the International Celestial Reference Frame (ICRF)", 
     source = "F. Mignard, 15 March 2002, 'Considerations on the orbit of Gaia for simulations', GAIA-FM-011, issue 1, revision 0, Section 3", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "au") 
    public static final double L2_ORBITALSEMIMAJORAXIS_J2000; static { L2_ORBITALSEMIMAJORAXIS_J2000 = 1.01008088; } // [au] 

    /**
     * Mean orbital eccentricity of the L2 orbit of the Sun and Earth-Moon system, at the standard epoch J2000.0. The orbital element is referenced to the mean ecliptic and equinox of J2000 at the standard epoch J2000.0. DE405 is based upon the International Celestial Reference Frame (ICRF)    
     * <p>
     * Source: See, e.g., F. Mignard, 15 March 2002, 'Considerations on the orbit of Gaia for simulations', GAIA-FM-011, issue 1, revision 0, Section 3.2, pages 6-7<br/>
     * Status: CONF<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean orbital eccentricity of the L2 orbit of the Sun and Earth-Moon system, at the standard epoch J2000.0. The orbital element is referenced to the mean ecliptic and equinox of J2000 at the standard epoch J2000.0. DE405 is based upon the International Celestial Reference Frame (ICRF)", 
     source = "See, e.g., F. Mignard, 15 March 2002, 'Considerations on the orbit of Gaia for simulations', GAIA-FM-011, issue 1, revision 0, Section 3.2, pages 6-7", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "") 
    public static final double L2_ORBITALECCENTRICITY_J2000; static { L2_ORBITALECCENTRICITY_J2000 = 0.01671123; } 

    /**
     * Reduced mass \mu of the Sun and Earth-Moon system as used in GAIA-FM-011, issue 1, revision 0. Note that the INPOP10e value 328900.552289 gives \mu = 3.04042347E-6    
     * <p>
     * Source: F. Mignard, 15 March 2002, 'Considerations on the orbit of Gaia for simulations', GAIA-FM-011, issue 1, revision 0, Section 2<br/>
     * Status: CONF<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Reduced mass \\mu of the Sun and Earth-Moon system as used in GAIA-FM-011, issue 1, revision 0. Note that the INPOP10e value 328900.552289 gives \\mu = 3.04042347E-6", 
     source = "F. Mignard, 15 March 2002, 'Considerations on the orbit of Gaia for simulations', GAIA-FM-011, issue 1, revision 0, Section 2", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "") 
    public static final double L2_MU; static { L2_MU = 3.040423402e-6; } 

    /**
     * Central auxiliary parameter in GAIA-FM-011, issue 1, revision 0    
     * <p>
     * Source: F. Mignard, 15 March 2002, 'Considerations on the orbit of Gaia for simulations', GAIA-FM-011, issue 1, revision 0, Equation 22<br/>
     * Status: CONF<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Central auxiliary parameter in GAIA-FM-011, issue 1, revision 0", 
     source = "F. Mignard, 15 March 2002, 'Considerations on the orbit of Gaia for simulations', GAIA-FM-011, issue 1, revision 0, Equation 22", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "") 
    public static final double L2_ALPHA; static { L2_ALPHA = 0.0100447147; } 

    /**
     * Normalised separation between L2 and the Earth-Moon barycentre    
     * <p>
     * Source: F. Mignard, 15 March 2002, 'Considerations on the orbit of Gaia for simulations', GAIA-FM-011, issue 1, revision 0, Equation 23; see also the addition to GAIA-FM-011, issue 1, revision 0, dated 25 September 2003<br/>
     * Status: CONF<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Normalised separation between L2 and the Earth-Moon barycentre", 
     source = "F. Mignard, 15 March 2002, 'Considerations on the orbit of Gaia for simulations', GAIA-FM-011, issue 1, revision 0, Equation 23; see also the addition to GAIA-FM-011, issue 1, revision 0, dated 25 September 2003", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "") 
    public static final double L2_RHO; static { L2_RHO = 0.01007824044; } 

    /**
     * Auxiliary variable in GAIA-FM-011, issue 1, revision 0    
     * <p>
     * Source: F. Mignard, 15 March 2002, 'Considerations on the orbit of Gaia for simulations', GAIA-FM-011, issue 1, revision 0, Equations 34 and 38; see also the addition to GAIA-FM-011, issue 1, revision 0, dated 25 September 2003<br/>
     * Status: CONF<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Auxiliary variable in GAIA-FM-011, issue 1, revision 0", 
     source = "F. Mignard, 15 March 2002, 'Considerations on the orbit of Gaia for simulations', GAIA-FM-011, issue 1, revision 0, Equations 34 and 38; see also the addition to GAIA-FM-011, issue 1, revision 0, dated 25 September 2003", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "") 
    public static final double L2_CAPITALOMEGA; static { L2_CAPITALOMEGA = 3.940522185; } 

    /**
     * Frequency of the vertical oscillation around L2    
     * <p>
     * Source: F. Mignard, 15 March 2002, 'Considerations on the orbit of Gaia for simulations', GAIA-FM-011, issue 1, revision 0, Equation 40; see also the addition to GAIA-FM-011, issue 1, revision 0, dated 25 September 2003<br/>
     * Status: CONF<br/>
     * Unit: {sidereal year}^-1<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Frequency of the vertical oscillation around L2", 
     source = "F. Mignard, 15 March 2002, 'Considerations on the orbit of Gaia for simulations', GAIA-FM-011, issue 1, revision 0, Equation 40; see also the addition to GAIA-FM-011, issue 1, revision 0, dated 25 September 2003", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "{sidereal year}^-1") 
    public static final double L2_OMEGA; static { L2_OMEGA = 1.985074856; } // [{sidereal year}^-1] 

    /**
     * Synodic period of the vertical oscillation around L2 in units of days    
     * <p>
     * Source: F. Mignard, 15 March 2002, 'Considerations on the orbit of Gaia for simulations', GAIA-FM-011, issue 1, revision 0, Equation 40<br/>
     * Status: CONF<br/>
     * Unit: day<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Synodic period of the vertical oscillation around L2 in units of days", 
     source = "F. Mignard, 15 March 2002, 'Considerations on the orbit of Gaia for simulations', GAIA-FM-011, issue 1, revision 0, Equation 40", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "day") 
    public static final double L2_OMEGA_PERIOD; static { L2_OMEGA_PERIOD = 184.00; } // [day] 

    /**
     * Synodic period of the 'horizontal' elliptic motion around L2 (Equations 70-71 in GAIA-FM-011, issue 1, revision 0) in units of days    
     * <p>
     * Source: F. Mignard, 15 March 2002, 'Considerations on the orbit of Gaia for simulations', GAIA-FM-011, issue 1, revision 0, Section 5.4<br/>
     * Status: CONF<br/>
     * Unit: day<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Synodic period of the 'horizontal' elliptic motion around L2 (Equations 70-71 in GAIA-FM-011, issue 1, revision 0) in units of days", 
     source = "F. Mignard, 15 March 2002, 'Considerations on the orbit of Gaia for simulations', GAIA-FM-011, issue 1, revision 0, Section 5.4", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "day") 
    public static final double L2_SIGMA_PERIOD; static { L2_SIGMA_PERIOD = 177.57; } // [day] 

    /**
     * Axis ratio of the 'horizontal' elliptic motion around L2 (Equations 70-71 in GAIA-FM-011, issue 1, revision 0)    
     * <p>
     * Source: F. Mignard, 15 March 2002, 'Considerations on the orbit of Gaia for simulations', GAIA-FM-011, issue 1, revision 0, Equation 66; see also the addition to GAIA-FM-011, issue 1, revision 0, dated 25 September 2003<br/>
     * Status: CONF<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Axis ratio of the 'horizontal' elliptic motion around L2 (Equations 70-71 in GAIA-FM-011, issue 1, revision 0)", 
     source = "F. Mignard, 15 March 2002, 'Considerations on the orbit of Gaia for simulations', GAIA-FM-011, issue 1, revision 0, Equation 66; see also the addition to GAIA-FM-011, issue 1, revision 0, dated 25 September 2003", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "") 
    public static final double L2_BETA; static { L2_BETA = 3.18722929; } 

    /**
     * Frequency of the oscillation around L2 in the horizontal plane    
     * <p>
     * Source: F. Mignard, 15 March 2002, 'Considerations on the orbit of Gaia for simulations', GAIA-FM-011, issue 1, revision 0, Equations 49 and 52; see also the addition to GAIA-FM-011, issue 1, revision 0, dated 25 September 2003<br/>
     * Status: CONF<br/>
     * Unit: {sidereal year}^-1<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Frequency of the oscillation around L2 in the horizontal plane", 
     source = "F. Mignard, 15 March 2002, 'Considerations on the orbit of Gaia for simulations', GAIA-FM-011, issue 1, revision 0, Equations 49 and 52; see also the addition to GAIA-FM-011, issue 1, revision 0, dated 25 September 2003", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "{sidereal year}^-1") 
    public static final double L2_SIGMA; static { L2_SIGMA = 2.057014191; } // [{sidereal year}^-1] 

    /**
     * Maximum radius of the penumbra of the Earth during a solar eclipse as seen from a point 1.0E5 km 'behind' L2. GAIA-FM-011, issue 1, revision 0 uses a rounded value of 14000 km    
     * <p>
     * Source: F. Mignard, 15 March 2002, 'Considerations on the orbit of Gaia for simulations', GAIA-FM-011, issue 1, revision 0, Section 4 (symbol \sigma_2) and Equation 86 (symbol s)<br/>
     * Status: CONF<br/>
     * Unit: km<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Maximum radius of the penumbra of the Earth during a solar eclipse as seen from a point 1.0E5 km 'behind' L2. GAIA-FM-011, issue 1, revision 0 uses a rounded value of 14000 km", 
     source = "F. Mignard, 15 March 2002, 'Considerations on the orbit of Gaia for simulations', GAIA-FM-011, issue 1, revision 0, Section 4 (symbol \\sigma_2) and Equation 86 (symbol s)", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "km") 
    public static final double L2_PENUMBRARADIUS; static { L2_PENUMBRARADIUS = 13923.; } // [km] 

    /**
     * The quantity p_n in GAIA-FM-011, issue 1, revision 0; this choice guarantees an eclipse-free orbit around L2 for more than 6 years    
     * <p>
     * Source: F. Mignard, 15 March 2002, 'Considerations on the orbit of Gaia for simulations', GAIA-FM-011, issue 1, revision 0, Tables 1 and 2 and Sections 6.2 and 6.4<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "The quantity p_n in GAIA-FM-011, issue 1, revision 0; this choice guarantees an eclipse-free orbit around L2 for more than 6 years", 
     source = "F. Mignard, 15 March 2002, 'Considerations on the orbit of Gaia for simulations', GAIA-FM-011, issue 1, revision 0, Tables 1 and 2 and Sections 6.2 and 6.4", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double L2_P; static { L2_P = 27.; } 

    /**
     * The quantity q_n in GAIA-FM-011, issue 1, revision 0; this choice guarantees an eclipse-free orbit around L2 for more than 6 years    
     * <p>
     * Source: F. Mignard, 15 March 2002, 'Considerations on the orbit of Gaia for simulations', GAIA-FM-011, issue 1, revision 0, Tables 1 and 2 and Sections 6.2 and 6.4<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "The quantity q_n in GAIA-FM-011, issue 1, revision 0; this choice guarantees an eclipse-free orbit around L2 for more than 6 years", 
     source = "F. Mignard, 15 March 2002, 'Considerations on the orbit of Gaia for simulations', GAIA-FM-011, issue 1, revision 0, Tables 1 and 2 and Sections 6.2 and 6.4", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double L2_Q; static { L2_Q = 26.; } 

    /**
     * The 'residual quantity' p - q a = q \epsilon, with a = \sigma / \omega, in GAIA-FM-011, issue 1, revision 0    
     * <p>
     * Source: F. Mignard, 15 March 2002, 'Considerations on the orbit of Gaia for simulations', GAIA-FM-011, issue 1, revision 0, Table 1 and Section 6.4<br/>
     * Status: CONF<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "The 'residual quantity' p - q a = q \\epsilon, with a = \\sigma / \\omega, in GAIA-FM-011, issue 1, revision 0", 
     source = "F. Mignard, 15 March 2002, 'Considerations on the orbit of Gaia for simulations', GAIA-FM-011, issue 1, revision 0, Table 1 and Section 6.4", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "") 
    public static final double L2_QTIMESEPSILON; static { L2_QTIMESEPSILON = 5.78e-2; } 

    /**
     * Light year expressed in au    
     * <p>
     * Status: CONF<br/>
     * Unit: au<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Light year expressed in au", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "au") 
    public static final double LIGHTYEAR_ASTRONOMICALUNIT; static { LIGHTYEAR_ASTRONOMICALUNIT = 63241.077084; } // [au] 

    /**
     * Light year expressed in parsecs    
     * <p>
     * Status: CONF<br/>
     * Unit: pc<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Light year expressed in parsecs", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "pc") 
    public static final double LIGHTYEAR_PARSEC; static { LIGHTYEAR_PARSEC = 0.306601; } // [pc] 

    /**
     * Light year expressed in meters    
     * <p>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Light year expressed in meters", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m") 
    public static final double LIGHTYEAR_METER; static { LIGHTYEAR_METER = 9.4607304726e+15; } // [m] 

    /**
     * Velocity of circular rotation at the solar Galactocentric radius (local circular speed). Note: Transactions of the IAU, Volume XIXB, 1985, page 254: V_0 = 220 km s^-1    
     * <p>
     * Status: CONF<br/>
     * Unit: km s^-1<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Velocity of circular rotation at the solar Galactocentric radius (local circular speed). Note: Transactions of the IAU, Volume XIXB, 1985, page 254: V_0 = 220 km s^-1", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "km s^-1") 
    public static final double LSR_CIRCULARVELOCITY; static { LSR_CIRCULARVELOCITY = 217.520; } // [km s^-1] 

    /**
     * Distance from the Local Standard of Rest (LSR, or: Sun) to the Galactic centre (solar Galactocentric radius)    
     * <p>
     * Source: Z.M. Malkin, 28 February 2012, 'The current best estimate of the Galactocentric distance of the Sun based on comparison of different statistical techniques', http://adsabs.harvard.edu/abs/2012arXiv1202.6128M; see also Z.M. Malkin, 2013, Astronomicheskii Zhurnal, Volume 90, Number 2, pages 152-157 and Z.M. Malkin, 1 February 2013, 'Analysis of determinations of the distance between the sun and the galactic center', Astronomy Reports, Volume 57, Issue 2, pages 128-133<br/>
     * Status: CONF<br/>
     * Unit: kpc<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Distance from the Local Standard of Rest (LSR, or: Sun) to the Galactic centre (solar Galactocentric radius)", 
     source = "Z.M. Malkin, 28 February 2012, 'The current best estimate of the Galactocentric distance of the Sun based on comparison of different statistical techniques', http://adsabs.harvard.edu/abs/2012arXiv1202.6128M; see also Z.M. Malkin, 2013, Astronomicheskii Zhurnal, Volume 90, Number 2, pages 152-157 and Z.M. Malkin, 1 February 2013, 'Analysis of determinations of the distance between the sun and the galactic center', Astronomy Reports, Volume 57, Issue 2, pages 128-133", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "kpc") 
    public static final double LSR_GALACTOCENTRICRADIUS; static { LSR_GALACTOCENTRICRADIUS = 8.0; } // [kpc] 

    /**
     * Angular velocity of circular rotation at the solar Galactocentric radius. Note: Transactions of the IAU, Volume XIXB, 1985, page 254: \Omega_0 = 220/8.5 = 25.88 km s^-1 kpc^-1    
     * <p>
     * Status: CONF<br/>
     * Unit: km s^-1 kpc^-1<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Angular velocity of circular rotation at the solar Galactocentric radius. Note: Transactions of the IAU, Volume XIXB, 1985, page 254: \\Omega_0 = 220/8.5 = 25.88 km s^-1 kpc^-1", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "km s^-1 kpc^-1") 
    public static final double LSR_ANGULARVELOCITY; static { LSR_ANGULARVELOCITY = 27.19; } // [km s^-1 kpc^-1] 

    /**
     * Period of rotation around the Galactic centre at the solar Galactocentric radius for a circular orbit    
     * <p>
     * Status: CONF<br/>
     * Unit: Myr<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Period of rotation around the Galactic centre at the solar Galactocentric radius for a circular orbit", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "Myr") 
    public static final double LSR_GALACTICROTATIONPERIOD; static { LSR_GALACTICROTATIONPERIOD = 225.95; } // [Myr] 

    /**
     * Maximum (change in) aberration brought about by the acceleration of the LSR relative to the Galactic centre (resulting, if not corrected for, in spurious (apparent) proper motions for extra-Galactic sources in some regions of the sky)    
     * <p>
     * Source: J. Kovalevsky, 2003, 'Aberration in proper motions', A&A, 404, 743. See also ESA, July 2000, 'Gaia; Composition, Formation and Evolution of the Galaxy; Concept and Technology Study Report', ESA-SCI(2000)4, Section 1.8.10, page 110<br/>
     * Status: CONF<br/>
     * Unit: 10^-6 arcsec yr^-1<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Maximum (change in) aberration brought about by the acceleration of the LSR relative to the Galactic centre (resulting, if not corrected for, in spurious (apparent) proper motions for extra-Galactic sources in some regions of the sky)", 
     source = "J. Kovalevsky, 2003, 'Aberration in proper motions', A&A, 404, 743. See also ESA, July 2000, 'Gaia; Composition, Formation and Evolution of the Galaxy; Concept and Technology Study Report', ESA-SCI(2000)4, Section 1.8.10, page 110", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "10^-6 arcsec yr^-1") 
    public static final double LSR_ABERRATION_MAXIMUM; static { LSR_ABERRATION_MAXIMUM = 4.2; } // [10^-6 arcsec yr^-1] 

    /**
     * Average value of 1-d(TT)/d(TCB), defined as a defining constant, based on the '2006 best estimate' of LSubC_Constant + LSubG_Constant - LSubC_Constant * LSubG_Constant    
     * <p>
     * Source: IAU, August 2006, 'Re-definition of Barycentric Dynamical Time, TDB', IAU 2006 Resolution 3 adopted at the XXVI-th General Assembly of the IAU. See also the IAU (2009) System of Astronomical Constants (IAU, August 2009, 'IAU 2009 Astronomical Constants', IAU 2009 Resolution B2 adopted at the XXVII-th General Assembly of the IAU. See also IAU, 10 August 2009, 'IAU WG on NSFA Current Best Estimates', http://maia.usno.navy.mil/NSFA/NSFA_cbe.html)<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Average value of 1-d(TT)/d(TCB), defined as a defining constant, based on the '2006 best estimate' of LSubC_Constant + LSubG_Constant - LSubC_Constant * LSubG_Constant", 
     source = "IAU, August 2006, 'Re-definition of Barycentric Dynamical Time, TDB', IAU 2006 Resolution 3 adopted at the XXVI-th General Assembly of the IAU. See also the IAU (2009) System of Astronomical Constants (IAU, August 2009, 'IAU 2009 Astronomical Constants', IAU 2009 Resolution B2 adopted at the XXVII-th General Assembly of the IAU. See also IAU, 10 August 2009, 'IAU WG on NSFA Current Best Estimates', http://maia.usno.navy.mil/NSFA/NSFA_cbe.html)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double LSUBB_CONSTANT; static { LSUBB_CONSTANT = 1.5505197680e-8; } 

    /**
     * Average value of 1-d(TCG)/d(TCB)    
     * <p>
     * Source: A. Irwin, T. Fukushima, 1999, A&A, 348, 642. See also the IAU (2009) System of Astronomical Constants (IAU, August 2009, 'IAU 2009 Astronomical Constants', IAU 2009 Resolution B2 adopted at the XXVII-th General Assembly of the IAU. See also IAU, 10 August 2009, 'IAU WG on NSFA Current Best Estimates', http://maia.usno.navy.mil/NSFA/NSFA_cbe.html)<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Average value of 1-d(TCG)/d(TCB)", 
     source = "A. Irwin, T. Fukushima, 1999, A&A, 348, 642. See also the IAU (2009) System of Astronomical Constants (IAU, August 2009, 'IAU 2009 Astronomical Constants', IAU 2009 Resolution B2 adopted at the XXVII-th General Assembly of the IAU. See also IAU, 10 August 2009, 'IAU WG on NSFA Current Best Estimates', http://maia.usno.navy.mil/NSFA/NSFA_cbe.html)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double LSUBC_CONSTANT; static { LSUBC_CONSTANT = 1.480826867410e-8; } 

    /**
     * Value of 1-d(TT)/d(TCG) (defining constant, based on best-estimate EarthEllipsoid_WSub0 = 6.26368556E7 m^2 s^-2)    
     * <p>
     * Source: The IAU (2009) System of Astronomical Constants (IAU, August 2009, 'IAU 2009 Astronomical Constants', IAU 2009 Resolution B2 adopted at the XXVII-th General Assembly of the IAU. See also IAU, 10 August 2009, 'IAU WG on NSFA Current Best Estimates', http://maia.usno.navy.mil/NSFA/NSFA_cbe.html). See also IAU, August 2000, 'Re-definition of Terrestrial Time, TT', IAU 2000 Resolution B1.9 adopted at the XXIV-th General Assembly of the IAU<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Value of 1-d(TT)/d(TCG) (defining constant, based on best-estimate EarthEllipsoid_WSub0 = 6.26368556E7 m^2 s^-2)", 
     source = "The IAU (2009) System of Astronomical Constants (IAU, August 2009, 'IAU 2009 Astronomical Constants', IAU 2009 Resolution B2 adopted at the XXVII-th General Assembly of the IAU. See also IAU, 10 August 2009, 'IAU WG on NSFA Current Best Estimates', http://maia.usno.navy.mil/NSFA/NSFA_cbe.html). See also IAU, August 2000, 'Re-definition of Terrestrial Time, TT', IAU 2000 Resolution B1.9 adopted at the XXIV-th General Assembly of the IAU", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double LSUBG_CONSTANT; static { LSUBG_CONSTANT = 6.9692901340e-10; } 

    /**
     * Photon flux density N_{\lambda}(\lambda) of an unreddened M0III star (Pickles' star number 095) at V = 0 mag. First column: wavelength \lambda (in nm; from 115.0 to 1062.0). Second column: photon flux density above the Earth's atmosphere (in photons m^-2 s^-1 nm^-1; the photometric zero point is described in J.H.J. de Bruijne, 26 May 2003, 'Stellar fluxes: transformations and calibrations', GAIA-JdB-005, issue 1, revision 1)    
     * <p>
     * Source: A.J. Pickles, 1998, 'A stellar spectral flux library: 1150-25000 AA', PASP, 110, 863<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: false
     */
    @ParamMetaData (
    description = "Photon flux density N_{\\lambda}(\\lambda) of an unreddened M0III star (Pickles' star number 095) at V = 0 mag. First column: wavelength \\lambda (in nm; from 115.0 to 1062.0). Second column: photon flux density above the Earth's atmosphere (in photons m^-2 s^-1 nm^-1; the photometric zero point is described in J.H.J. de Bruijne, 26 May 2003, 'Stellar fluxes: transformations and calibrations', GAIA-JdB-005, issue 1, revision 1)", 
     source = "A.J. Pickles, 1998, 'A stellar spectral flux library: 1150-25000 AA', PASP, 110, 863", 
     status = "CONF", 
     basic = true, 
     scalar = false, 
     unit = "") 
    public static final String M0IIISTAR_SPECTRUM_NUMBEROFPHOTONS; static { M0IIISTAR_SPECTRUM_NUMBEROFPHOTONS = "Nature/M0IIIStar_Spectrum_NumberOfPhotons_001.fits"; } 

    /**
     * Photon flux density N_{\lambda}(\lambda) of an unreddened M0V star (Pickles' star number 038) at V = 0 mag. First column: wavelength \lambda (in nm; from 115.0 to 1062.0). Second column: photon flux density above the Earth's atmosphere (in photons m^-2 s^-1 nm^-1; the photometric zero point is described in J.H.J. de Bruijne, 26 May 2003, 'Stellar fluxes: transformations and calibrations', GAIA-JdB-005, issue 1, revision 1)    
     * <p>
     * Source: A.J. Pickles, 1998, 'A stellar spectral flux library: 1150-25000 AA', PASP, 110, 863<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: false
     */
    @ParamMetaData (
    description = "Photon flux density N_{\\lambda}(\\lambda) of an unreddened M0V star (Pickles' star number 038) at V = 0 mag. First column: wavelength \\lambda (in nm; from 115.0 to 1062.0). Second column: photon flux density above the Earth's atmosphere (in photons m^-2 s^-1 nm^-1; the photometric zero point is described in J.H.J. de Bruijne, 26 May 2003, 'Stellar fluxes: transformations and calibrations', GAIA-JdB-005, issue 1, revision 1)", 
     source = "A.J. Pickles, 1998, 'A stellar spectral flux library: 1150-25000 AA', PASP, 110, 863", 
     status = "CONF", 
     basic = true, 
     scalar = false, 
     unit = "") 
    public static final String M0VSTAR_SPECTRUM_NUMBEROFPHOTONS; static { M0VSTAR_SPECTRUM_NUMBEROFPHOTONS = "Nature/M0VStar_Spectrum_NumberOfPhotons_001.fits"; } 

    /**
     * Photon flux density N_{\lambda}(\lambda) of an unreddened M6V star (Pickles' star number 045) at V = 0 mag. First column: wavelength \lambda (in nm; from 115.0 to 1062.0). Second column: photon flux density above the Earth's atmosphere (in photons m^-2 s^-1 nm^-1; the photometric zero point is described in J.H.J. de Bruijne, 26 May 2003, 'Stellar fluxes: transformations and calibrations', GAIA-JdB-005, issue 1, revision 1)    
     * <p>
     * Source: A.J. Pickles, 1998, 'A stellar spectral flux library: 1150-25000 AA', PASP, 110, 863<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: false
     */
    @ParamMetaData (
    description = "Photon flux density N_{\\lambda}(\\lambda) of an unreddened M6V star (Pickles' star number 045) at V = 0 mag. First column: wavelength \\lambda (in nm; from 115.0 to 1062.0). Second column: photon flux density above the Earth's atmosphere (in photons m^-2 s^-1 nm^-1; the photometric zero point is described in J.H.J. de Bruijne, 26 May 2003, 'Stellar fluxes: transformations and calibrations', GAIA-JdB-005, issue 1, revision 1)", 
     source = "A.J. Pickles, 1998, 'A stellar spectral flux library: 1150-25000 AA', PASP, 110, 863", 
     status = "CONF", 
     basic = true, 
     scalar = false, 
     unit = "") 
    public static final String M6VSTAR_SPECTRUM_NUMBEROFPHOTONS; static { M6VSTAR_SPECTRUM_NUMBEROFPHOTONS = "Nature/M6VStar_Spectrum_NumberOfPhotons_001.fits"; } 

    /**
     * Photon flux density N_{\lambda}(\lambda) of an unreddened M7III star (Pickles' star number 102) at V = 0 mag. First column: wavelength \lambda (in nm; from 115.0 to 1062.0). Second column: photon flux density above the Earth's atmosphere (in photons m^-2 s^-1 nm^-1; the photometric zero point is described in J.H.J. de Bruijne, 26 May 2003, 'Stellar fluxes: transformations and calibrations', GAIA-JdB-005, issue 1, revision 1)    
     * <p>
     * Source: A.J. Pickles, 1998, 'A stellar spectral flux library: 1150-25000 AA', PASP, 110, 863<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: false
     */
    @ParamMetaData (
    description = "Photon flux density N_{\\lambda}(\\lambda) of an unreddened M7III star (Pickles' star number 102) at V = 0 mag. First column: wavelength \\lambda (in nm; from 115.0 to 1062.0). Second column: photon flux density above the Earth's atmosphere (in photons m^-2 s^-1 nm^-1; the photometric zero point is described in J.H.J. de Bruijne, 26 May 2003, 'Stellar fluxes: transformations and calibrations', GAIA-JdB-005, issue 1, revision 1)", 
     source = "A.J. Pickles, 1998, 'A stellar spectral flux library: 1150-25000 AA', PASP, 110, 863", 
     status = "CONF", 
     basic = true, 
     scalar = false, 
     unit = "") 
    public static final String M7IIISTAR_SPECTRUM_NUMBEROFPHOTONS; static { M7IIISTAR_SPECTRUM_NUMBEROFPHOTONS = "Nature/M7IIIStar_Spectrum_NumberOfPhotons_001.fits"; } 

    /**
     * Magnetic constant (defining constant)    
     * <p>
     * Status: CONF<br/>
     * Unit: N A^-2<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Magnetic constant (defining constant)", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "N A^-2") 
    public static final double MAGNETIC_CONSTANT; static { MAGNETIC_CONSTANT = 1.256637061435917e-6; } // [N A^-2] 

    /**
     * Chebyshev representation of the ephemerides of Mars, with origin at the barycentre of the solar system (BCRS), in the equatorial ICRF frame. The ephemeris covers the period starting on JD (JDBEGIP + JDBEGFP) and ending on JD (JDENDIP + JDENDFP) for the position and starting on JD (JDBEGIV + JDBEGFV) and ending on JD (JDENDIV + JDENDFV) for the velocity. A number of Chebyshev coefficients equal to ORDERSP is given for NSSP time intervals of SPANSP days to describe the position-vector components in units of m; the similar parameters ending with PP (Peculiar Position) are not used in the current release and are reserved for future usage. A number of Chebyshev coefficients equal to ORDERSV is given for NSSV time intervals of SPANSV days to describe the velocity-vector components in units of m s^-1; the similar parameters ending with PV (Peculiar Velocity) are not used in the current release and are reserved for future usage. The first three HDUs contain the coefficients for the three components of the position, while the last three HDUs contain the coefficients for the three components of the velocity    
     * <p>
     * Source: A. Fienga, J. Laskar, H. Manche, M. Gastineau, 19 April 2007, 'Solar system planetary ephemeris delivery: INPOP06', GAIA-CA-TN-IMC-AF-001, issue 1, revision 0<br/>
     * Status: DEPR<br/>
     * Basic : true<br/>
     * Scalar: false
     */
    @ParamMetaData (
    description = "Chebyshev representation of the ephemerides of Mars, with origin at the barycentre of the solar system (BCRS), in the equatorial ICRF frame. The ephemeris covers the period starting on JD (JDBEGIP + JDBEGFP) and ending on JD (JDENDIP + JDENDFP) for the position and starting on JD (JDBEGIV + JDBEGFV) and ending on JD (JDENDIV + JDENDFV) for the velocity. A number of Chebyshev coefficients equal to ORDERSP is given for NSSP time intervals of SPANSP days to describe the position-vector components in units of m; the similar parameters ending with PP (Peculiar Position) are not used in the current release and are reserved for future usage. A number of Chebyshev coefficients equal to ORDERSV is given for NSSV time intervals of SPANSV days to describe the velocity-vector components in units of m s^-1; the similar parameters ending with PV (Peculiar Velocity) are not used in the current release and are reserved for future usage. The first three HDUs contain the coefficients for the three components of the position, while the last three HDUs contain the coefficients for the three components of the velocity", 
     source = "A. Fienga, J. Laskar, H. Manche, M. Gastineau, 19 April 2007, 'Solar system planetary ephemeris delivery: INPOP06', GAIA-CA-TN-IMC-AF-001, issue 1, revision 0", 
     status = "DEPR", 
     basic = true, 
     scalar = false, 
     unit = "") 
    public static final String MARS_EPHEMERIS; static { MARS_EPHEMERIS = "Nature/Mars_Ephemeris_004.fits"; } 

    /**
     * IAU-recommended value for the right ascension \alpha_0 of the north pole of rotation of Mars. The pair (\alpha_0, \delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \alpha_0 = 273.85 deg and \delta_0 = 66.99 degrees    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)<br/>
     * Status: CONF<br/>
     * Unit: deg<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "IAU-recommended value for the right ascension \\alpha_0 of the north pole of rotation of Mars. The pair (\\alpha_0, \\delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \\alpha_0 = 273.85 deg and \\delta_0 = 66.99 degrees", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "deg") 
    public static final double MARS_NORTHROTATIONALPOLE_RIGHTASCENSION; static { MARS_NORTHROTATIONALPOLE_RIGHTASCENSION = 317.68143; } // [deg] 

    /**
     * IAU-recommended value for the rate of change (in degrees per Julian day, calculated from the standard epoch) of the right ascension \alpha_0 of the north pole of rotation of Mars. The pair (\alpha_0, \delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \alpha_0 = 273.85 deg and \delta_0 = 66.99 degrees    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)<br/>
     * Status: CONF<br/>
     * Unit: deg day^-1<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "IAU-recommended value for the rate of change (in degrees per Julian day, calculated from the standard epoch) of the right ascension \\alpha_0 of the north pole of rotation of Mars. The pair (\\alpha_0, \\delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \\alpha_0 = 273.85 deg and \\delta_0 = 66.99 degrees", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "deg day^-1") 
    public static final double MARS_NORTHROTATIONALPOLE_RIGHTASCENSIONRATEOFCHANGE; static { MARS_NORTHROTATIONALPOLE_RIGHTASCENSIONRATEOFCHANGE = -0.0000029049; } // [deg day^-1] 

    /**
     * IAU-recommended value for the declination \delta_0 of the north pole of rotation of Mars. The pair (\alpha_0, \delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \alpha_0 = 273.85 deg and \delta_0 = 66.99 degrees    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)<br/>
     * Status: CONF<br/>
     * Unit: deg<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "IAU-recommended value for the declination \\delta_0 of the north pole of rotation of Mars. The pair (\\alpha_0, \\delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \\alpha_0 = 273.85 deg and \\delta_0 = 66.99 degrees", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "deg") 
    public static final double MARS_NORTHROTATIONALPOLE_DECLINATION; static { MARS_NORTHROTATIONALPOLE_DECLINATION = 52.88650; } // [deg] 

    /**
     * IAU-recommended value for the rate of change (in degrees per Julian day, calculated from the standard epoch) of the declination \delta_0 of the north pole of rotation of Mars. The pair (\alpha_0, \delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \alpha_0 = 273.85 deg and \delta_0 = 66.99 degrees    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)<br/>
     * Status: CONF<br/>
     * Unit: deg day^-1<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "IAU-recommended value for the rate of change (in degrees per Julian day, calculated from the standard epoch) of the declination \\delta_0 of the north pole of rotation of Mars. The pair (\\alpha_0, \\delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \\alpha_0 = 273.85 deg and \\delta_0 = 66.99 degrees", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "deg day^-1") 
    public static final double MARS_NORTHROTATIONALPOLE_DECLINATIONRATEOFCHANGE; static { MARS_NORTHROTATIONALPOLE_DECLINATIONRATEOFCHANGE = -0.0000016674; } // [deg day^-1] 

    /**
     * IAU-recommended value for the ephemeris position of the prime meridian of Mars. The 0-deg meridian is defined by the crater Airy-0. The location of the prime meridian is specified by the angle that is measured along the planet's equator in an easterly direction with respect to the planet's north pole from the node Q (located at right ascension 90 deg + \alpha_0, where \alpha_0 denotes the right ascension of the north pole of rotation) of the planet's equator on the standard equator to the point B where the prime meridian crosses the planet's equator. The right ascension of the point Q is 90 deg + \alpha_0 and the inclination of the planet's equator to the standard equator is 90 deg - \delta_0, where \delta_0 denotes the declination of the north pole of rotation. (The pair (\alpha_0, \delta_0) denotes the standard equatorial coordinates, with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB), of the north pole of rotation, which itself is defined as that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \alpha_0 = 273.85 deg and \delta_0 = 66.99 degrees.) Because the prime meridian is assumed to rotate uniformly with the planet, W accordingly varies linearly with time. In addition, \alpha_0, \delta_0, and W may vary with time due to a precession of the axis of rotation of the planet. If W increases with time, the planet has a direct (or prograde) rotation; if W decreases with time, the rotation is said to be retrograde    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)<br/>
     * Status: CONF<br/>
     * Unit: deg<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "IAU-recommended value for the ephemeris position of the prime meridian of Mars. The 0-deg meridian is defined by the crater Airy-0. The location of the prime meridian is specified by the angle that is measured along the planet's equator in an easterly direction with respect to the planet's north pole from the node Q (located at right ascension 90 deg + \\alpha_0, where \\alpha_0 denotes the right ascension of the north pole of rotation) of the planet's equator on the standard equator to the point B where the prime meridian crosses the planet's equator. The right ascension of the point Q is 90 deg + \\alpha_0 and the inclination of the planet's equator to the standard equator is 90 deg - \\delta_0, where \\delta_0 denotes the declination of the north pole of rotation. (The pair (\\alpha_0, \\delta_0) denotes the standard equatorial coordinates, with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB), of the north pole of rotation, which itself is defined as that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \\alpha_0 = 273.85 deg and \\delta_0 = 66.99 degrees.) Because the prime meridian is assumed to rotate uniformly with the planet, W accordingly varies linearly with time. In addition, \\alpha_0, \\delta_0, and W may vary with time due to a precession of the axis of rotation of the planet. If W increases with time, the planet has a direct (or prograde) rotation; if W decreases with time, the rotation is said to be retrograde", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "deg") 
    public static final double MARS_PRIMEMERIDIAN_EPHEMERISPOSITION; static { MARS_PRIMEMERIDIAN_EPHEMERISPOSITION = 176.630; } // [deg] 

    /**
     * IAU-recommended value for the rate of change (in degrees per Julian day, calculated from the standard epoch of 1.5 January 2000 = JD2451545.0 TDB) of the ephemeris position of the prime meridian of Mars. The 0-deg meridian is defined by the crater Airy-0. The location of the prime meridian is specified by the angle that is measured along the planet's equator in an easterly direction with respect to the planet's north pole from the node Q (located at right ascension 90 deg + \alpha_0, where \alpha_0 denotes the right ascension of the north pole of rotation) of the planet's equator on the standard equator to the point B where the prime meridian crosses the planet's equator. The right ascension of the point Q is 90 deg + \alpha_0 and the inclination of the planet's equator to the standard equator is 90 deg - \delta_0, where \delta_0 denotes the declination of the north pole of rotation. (The pair (\alpha_0, \delta_0) denotes the standard equatorial coordinates, with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB), of the north pole of rotation, which itself is defined as that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \alpha_0 = 273.85 deg and \delta_0 = 66.99 degrees.) Because the prime meridian is assumed to rotate uniformly with the planet, W accordingly varies linearly with time. In addition, \alpha_0, \delta_0, and W may vary with time due to a precession of the axis of rotation of the planet. If W increases with time, the planet has a direct (or prograde) rotation; if W decreases with time, the rotation is said to be retrograde    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)<br/>
     * Status: CONF<br/>
     * Unit: deg day^-1<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "IAU-recommended value for the rate of change (in degrees per Julian day, calculated from the standard epoch of 1.5 January 2000 = JD2451545.0 TDB) of the ephemeris position of the prime meridian of Mars. The 0-deg meridian is defined by the crater Airy-0. The location of the prime meridian is specified by the angle that is measured along the planet's equator in an easterly direction with respect to the planet's north pole from the node Q (located at right ascension 90 deg + \\alpha_0, where \\alpha_0 denotes the right ascension of the north pole of rotation) of the planet's equator on the standard equator to the point B where the prime meridian crosses the planet's equator. The right ascension of the point Q is 90 deg + \\alpha_0 and the inclination of the planet's equator to the standard equator is 90 deg - \\delta_0, where \\delta_0 denotes the declination of the north pole of rotation. (The pair (\\alpha_0, \\delta_0) denotes the standard equatorial coordinates, with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB), of the north pole of rotation, which itself is defined as that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \\alpha_0 = 273.85 deg and \\delta_0 = 66.99 degrees.) Because the prime meridian is assumed to rotate uniformly with the planet, W accordingly varies linearly with time. In addition, \\alpha_0, \\delta_0, and W may vary with time due to a precession of the axis of rotation of the planet. If W increases with time, the planet has a direct (or prograde) rotation; if W decreases with time, the rotation is said to be retrograde", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "deg day^-1") 
    public static final double MARS_PRIMEMERIDIAN_EPHEMERISPOSITIONRATEOFCHANGE; static { MARS_PRIMEMERIDIAN_EPHEMERISPOSITIONRATEOFCHANGE = 350.89198226; } // [deg day^-1] 

    /**
     * Mass of Mars (do not use for high-precision (orbit) calculations)    
     * <p>
     * Source: R.A. Jacobson, 2008, 'Ephemerides of the Martian Satellites - MAR080', JPL IOM 343.R-08-006; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par<br/>
     * Status: CONF<br/>
     * Unit: kg<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mass of Mars (do not use for high-precision (orbit) calculations)", 
     source = "R.A. Jacobson, 2008, 'Ephemerides of the Martian Satellites - MAR080', JPL IOM 343.R-08-006; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "kg") 
    public static final double MARS_MASS; static { MARS_MASS = 6.416930e+23; } // [kg] 

    /**
     * Mean volumetric radius of Mars    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A); see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par<br/>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean volumetric radius of Mars", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A); see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "m") 
    public static final double MARS_VOLUMETRICRADIUS; static { MARS_VOLUMETRICRADIUS = 3.389500e+6; } // [m] 

    /**
     * Equatorial radius of Mars    
     * <p>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Equatorial radius of Mars", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m") 
    public static final double MARS_EQUATORIALRADIUS; static { MARS_EQUATORIALRADIUS = 3.396190e+6; } // [m] 

    /**
     * Polar radius of Mars. Mars has a significant dichotomy in shape between the northern and southern hemispheres: the average polar radius is listed as 3.37620E6 m in B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A); see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par    
     * <p>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Polar radius of Mars. Mars has a significant dichotomy in shape between the northern and southern hemispheres: the average polar radius is listed as 3.37620E6 m in B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A); see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m") 
    public static final double MARS_POLARRADIUS; static { MARS_POLARRADIUS = 3.376160e+6; } // [m] 

    /**
     * V(1,0) magnitude of Mars (i.e., the visual magnitude of the planet reduced to a distance of 1 au from both the Sun and Earth and phase angle zero). This parameter is also refered to as absolute magnitude in planetary sciences    
     * <p>
     * Source: P.K. Seidelmann, 1992, 'Explanatory Supplement to the Astronomical Almanac', University Science Books, Mill Valley, Ca., ISBN 0-935702-68-7, Table 15.8 on page 706; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par<br/>
     * Status: CONF<br/>
     * Unit: mag<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "V(1,0) magnitude of Mars (i.e., the visual magnitude of the planet reduced to a distance of 1 au from both the Sun and Earth and phase angle zero). This parameter is also refered to as absolute magnitude in planetary sciences", 
     source = "P.K. Seidelmann, 1992, 'Explanatory Supplement to the Astronomical Almanac', University Science Books, Mill Valley, Ca., ISBN 0-935702-68-7, Table 15.8 on page 706; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "mag") 
    public static final double MARS_VONEZEROMAGNITUDE; static { MARS_VONEZEROMAGNITUDE = -1.52; } // [mag] 

    /**
     * Geometric albedo of Mars (i.e., the ratio of the body's brightness at zero phase angle to the brightness of a perfectly diffusing disk with the same position and apparent size as the body)    
     * <p>
     * Source: P.K. Seidelmann, 1992, 'Explanatory Supplement to the Astronomical Almanac', University Science Books, Mill Valley, Ca., ISBN 0-935702-68-7, Table 15.8 on page 706; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Geometric albedo of Mars (i.e., the ratio of the body's brightness at zero phase angle to the brightness of a perfectly diffusing disk with the same position and apparent size as the body)", 
     source = "P.K. Seidelmann, 1992, 'Explanatory Supplement to the Astronomical Almanac', University Science Books, Mill Valley, Ca., ISBN 0-935702-68-7, Table 15.8 on page 706; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double MARS_GEOMETRICALBEDO; static { MARS_GEOMETRICALBEDO = 0.150; } 

    /**
     * Mean mass density of Mars    
     * <p>
     * Status: CONF<br/>
     * Unit: g cm^-3<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean mass density of Mars", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "g cm^-3") 
    public static final double MARS_MASSDENSITY_MEAN; static { MARS_MASSDENSITY_MEAN = 3.9340; } // [g cm^-3] 

    /**
     * Radius of the smallest hypothetical sphere around Mars which would encompass the body (this is a low-accuracy parameter used in the relativistic model)    
     * <p>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Radius of the smallest hypothetical sphere around Mars which would encompass the body (this is a low-accuracy parameter used in the relativistic model)", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m") 
    public static final double MARS_ENCOMPASSINGSPHERERADIUS; static { MARS_ENCOMPASSINGSPHERERADIUS = 3.396190e+6; } // [m] 

    /**
     * Dynamical form-factor of Mars (oblateness or Stokes' second-degree zonal harmonic of the potential)    
     * <p>
     * Source: P.K. Seidelmann, 1992, 'Explanatory Supplement to the Astronomical Almanac', University Science Books, Mill Valley, Ca., ISBN 0-935702-68-7, Table 15.8<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Dynamical form-factor of Mars (oblateness or Stokes' second-degree zonal harmonic of the potential)", 
     source = "P.K. Seidelmann, 1992, 'Explanatory Supplement to the Astronomical Almanac', University Science Books, Mill Valley, Ca., ISBN 0-935702-68-7, Table 15.8", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double MARS_JSUB2; static { MARS_JSUB2 = 1.9640e-3; } 

    /**
     * Geometrical flattening factor f of Mars (f = (a-b)/a). Mars has a significant dichotomy in shape between the northern and southern hemispheres    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A); see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Geometrical flattening factor f of Mars (f = (a-b)/a). Mars has a significant dichotomy in shape between the northern and southern hemispheres", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A); see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double MARS_FLATTENING; static { MARS_FLATTENING = 5.89790e-3; } 

    /**
     * Post-Newtonian deflection angle of a limb-grazing light ray due to the spherically symmetric part of the gravitational field of Mars    
     * <p>
     * Source: S.A. Klioner, 2003, 'A Practical Relativistic Model for Microarcsecond Astrometry in Space', AJ, 125, 1580, Equation 64 with cot(x) = cos(x) / sin(x) approximated by x^-1; see also J.H.J. de Bruijne, 19 February 2002, 'Gravitational light deflection', GAIA-JdB-001, issue 1, revision 0<br/>
     * Status: CONF<br/>
     * Unit: 10^-6 arcsec<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Post-Newtonian deflection angle of a limb-grazing light ray due to the spherically symmetric part of the gravitational field of Mars", 
     source = "S.A. Klioner, 2003, 'A Practical Relativistic Model for Microarcsecond Astrometry in Space', AJ, 125, 1580, Equation 64 with cot(x) = cos(x) / sin(x) approximated by x^-1; see also J.H.J. de Bruijne, 19 February 2002, 'Gravitational light deflection', GAIA-JdB-001, issue 1, revision 0", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "10^-6 arcsec") 
    public static final double MARS_LIGHTDEFLECTION_LIMB; static { MARS_LIGHTDEFLECTION_LIMB = 116.; } // [10^-6 arcsec] 

    /**
     * Geometric transit probability (Mars transiting the Sun) for an observer external to the solar system    
     * <p>
     * Source: E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 2.1, Equation 2.2, page 14<br/>
     * Status: CONF<br/>
     * Unit: %<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Geometric transit probability (Mars transiting the Sun) for an observer external to the solar system", 
     source = "E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 2.1, Equation 2.2, page 14", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "%") 
    public static final double MARS_TRANSITPROBABILITY; static { MARS_TRANSITPROBABILITY = 0.307; } // [%] 

    /**
     * Maximum reduction of the solar flux for an observer external to the solar system during a transit of Mars    
     * <p>
     * Source: E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 2.2, Equation 2.4, page 14<br/>
     * Status: CONF<br/>
     * Unit: %<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Maximum reduction of the solar flux for an observer external to the solar system during a transit of Mars", 
     source = "E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 2.2, Equation 2.4, page 14", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "%") 
    public static final double MARS_FLUXREDUCTION_MAXIMUM; static { MARS_FLUXREDUCTION_MAXIMUM = 0.002; } // [%] 

    /**
     * Maximum transit time of Mars (transiting the Sun) for an observer external to the solar system    
     * <p>
     * Source: E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 2.3, Equation 2.5, page 15<br/>
     * Status: CONF<br/>
     * Unit: day<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Maximum transit time of Mars (transiting the Sun) for an observer external to the solar system", 
     source = "E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 2.3, Equation 2.5, page 15", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "day") 
    public static final double MARS_TRANSITTIME_MAXIMUM; static { MARS_TRANSITTIME_MAXIMUM = 0.67; } // [day] 

    /**
     * Mars-system mass (IAU 2009 CBE value). The planetary mass includes the contribution of its satellites    
     * <p>
     * Status: CONF<br/>
     * Unit: kg<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mars-system mass (IAU 2009 CBE value). The planetary mass includes the contribution of its satellites", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "kg") 
    public static final double MARSSYSTEM_MASS; static { MARSSYSTEM_MASS = 6.41712e+23; } // [kg] 

    /**
     * Mean orbital semi-major axis of Mars, at the standard epoch J2000.0. The mean orbital semi-major axis is associated with a mean orbit solution from a 250-year least-squares fit of JPL's DE405 ephemeris to a Keplerian orbit covering the interval of years 1800 AD - 2050 AD. The orbital element is referenced to the mean ecliptic and equinox of J2000 at the standard epoch J2000.0; linear rates and fit errors can be found in the reference document    
     * <p>
     * Source: E.M. Standish, 16 February 2006, 'Keplerian Elements for Approximate Positions of the Major Planets', http://ssd.jpl.nasa.gov/?planets\#elem<br/>
     * Status: CONF<br/>
     * Unit: au<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean orbital semi-major axis of Mars, at the standard epoch J2000.0. The mean orbital semi-major axis is associated with a mean orbit solution from a 250-year least-squares fit of JPL's DE405 ephemeris to a Keplerian orbit covering the interval of years 1800 AD - 2050 AD. The orbital element is referenced to the mean ecliptic and equinox of J2000 at the standard epoch J2000.0; linear rates and fit errors can be found in the reference document", 
     source = "E.M. Standish, 16 February 2006, 'Keplerian Elements for Approximate Positions of the Major Planets', http://ssd.jpl.nasa.gov/?planets\\#elem", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "au") 
    public static final double MARSSYSTEM_ORBITALSEMIMAJORAXIS_J2000; static { MARSSYSTEM_ORBITALSEMIMAJORAXIS_J2000 = 1.52371034; } // [au] 

    /**
     * Mean orbital eccentricity of Mars, at the standard epoch J2000.0. The mean orbital eccentricity is associated with a mean orbit solution from a 250-year least-squares fit of JPL's DE405 ephemeris to a Keplerian orbit covering the interval of years 1800 AD - 2050 AD. The orbital element is referenced to the mean ecliptic and equinox of J2000 at the standard epoch J2000.0; linear rates and fit errors can be found in the reference document    
     * <p>
     * Source: E.M. Standish, 16 February 2006, 'Keplerian Elements for Approximate Positions of the Major Planets', http://ssd.jpl.nasa.gov/?planets\#elem<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean orbital eccentricity of Mars, at the standard epoch J2000.0. The mean orbital eccentricity is associated with a mean orbit solution from a 250-year least-squares fit of JPL's DE405 ephemeris to a Keplerian orbit covering the interval of years 1800 AD - 2050 AD. The orbital element is referenced to the mean ecliptic and equinox of J2000 at the standard epoch J2000.0; linear rates and fit errors can be found in the reference document", 
     source = "E.M. Standish, 16 February 2006, 'Keplerian Elements for Approximate Positions of the Major Planets', http://ssd.jpl.nasa.gov/?planets\\#elem", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double MARSSYSTEM_ORBITALECCENTRICITY_J2000; static { MARSSYSTEM_ORBITALECCENTRICITY_J2000 = 0.09339410; } 

    /**
     * Mean orbital inclination of Mars, at the standard epoch J2000.0. The mean orbital inclination is is associated with a mean orbit solution from a 250-year least-squares fit of JPL's DE405 ephemeris to a Keplerian orbit covering the interval of years 1800 AD - 2050 AD. The orbital element is referenced to the mean ecliptic and equinox of J2000 at the standard epoch J2000.0; linear rates and fit errors can be found in the reference document    
     * <p>
     * Source: E.M. Standish, 16 February 2006, 'Keplerian Elements for Approximate Positions of the Major Planets', http://ssd.jpl.nasa.gov/?planets\#elem<br/>
     * Status: CONF<br/>
     * Unit: deg<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean orbital inclination of Mars, at the standard epoch J2000.0. The mean orbital inclination is is associated with a mean orbit solution from a 250-year least-squares fit of JPL's DE405 ephemeris to a Keplerian orbit covering the interval of years 1800 AD - 2050 AD. The orbital element is referenced to the mean ecliptic and equinox of J2000 at the standard epoch J2000.0; linear rates and fit errors can be found in the reference document", 
     source = "E.M. Standish, 16 February 2006, 'Keplerian Elements for Approximate Positions of the Major Planets', http://ssd.jpl.nasa.gov/?planets\\#elem", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "deg") 
    public static final double MARSSYSTEM_ORBITALINCLINATION_J2000; static { MARSSYSTEM_ORBITALINCLINATION_J2000 = 1.84969142; } // [deg] 

    /**
     * Radial-velocity amplitude of the Sun induced by the Mars system for 'an edge-on observer' (i.e., an observer in the orbital plane of the Mars system)    
     * <p>
     * Source: E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 1.4, Equation 1.18, page 9<br/>
     * Status: CONF<br/>
     * Unit: m s^-1<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Radial-velocity amplitude of the Sun induced by the Mars system for 'an edge-on observer' (i.e., an observer in the orbital plane of the Mars system)", 
     source = "E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 1.4, Equation 1.18, page 9", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m s^-1") 
    public static final double MARSSYSTEM_RADIALVELOCITYSIGNATURE; static { MARSSYSTEM_RADIALVELOCITYSIGNATURE = 0.008; } // [m s^-1] 

    /**
     * Sidereal orbital period    
     * <p>
     * Source: Values derived from the mean longitude rates in Table 5.8.1 in P.K. Seidelmann, 1992, 'Explanatory Supplement to the Astronomical Almanac', University Science Books, Mill Valley, Ca., ISBN 0-935702-68-7, page 316; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par<br/>
     * Status: CONF<br/>
     * Unit: yr<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Sidereal orbital period", 
     source = "Values derived from the mean longitude rates in Table 5.8.1 in P.K. Seidelmann, 1992, 'Explanatory Supplement to the Astronomical Almanac', University Science Books, Mill Valley, Ca., ISBN 0-935702-68-7, page 316; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "yr") 
    public static final double MARSSYSTEM_ORBITALPERIOD; static { MARSSYSTEM_ORBITALPERIOD = 1.8808476; } // [yr] 

    /**
     * Astrometric signature of the Sun induced by the Mars system for an observer located at a distance of 10 pc from the Sun    
     * <p>
     * Source: E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 1.7, Equation 1.22, page 11<br/>
     * Status: CONF<br/>
     * Unit: 10^-6 arcsec<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Astrometric signature of the Sun induced by the Mars system for an observer located at a distance of 10 pc from the Sun", 
     source = "E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 1.7, Equation 1.22, page 11", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "10^-6 arcsec") 
    public static final double MARSSYSTEM_ASTROMETRICSIGNATURE_10PARSEC; static { MARSSYSTEM_ASTROMETRICSIGNATURE_10PARSEC = 0.049; } // [10^-6 arcsec] 

    /**
     * Chebyshev representation of the ephemerides of Mercury, with origin at the barycentre of the solar system (BCRS), in the equatorial ICRF frame. The ephemeris covers the period starting on JD (JDBEGIP + JDBEGFP) and ending on JD (JDENDIP + JDENDFP) for the position and starting on JD (JDBEGIV + JDBEGFV) and ending on JD (JDENDIV + JDENDFV) for the velocity. A number of Chebyshev coefficients equal to ORDERSP is given for NSSP time intervals of SPANSP days to describe the position-vector components in units of m; the similar parameters ending with PP (Peculiar Position) are not used in the current release and are reserved for future usage. A number of Chebyshev coefficients equal to ORDERSV is given for NSSV time intervals of SPANSV days to describe the velocity-vector components in units of m s^-1; the similar parameters ending with PV (Peculiar Velocity) are not used in the current release and are reserved for future usage. The first three HDUs contain the coefficients for the three components of the position, while the last three HDUs contain the coefficients for the three components of the velocity    
     * <p>
     * Source: A. Fienga, J. Laskar, H. Manche, M. Gastineau, 19 April 2007, 'Solar system planetary ephemeris delivery: INPOP06', GAIA-CA-TN-IMC-AF-001, issue 1, revision 0<br/>
     * Status: DEPR<br/>
     * Basic : true<br/>
     * Scalar: false
     */
    @ParamMetaData (
    description = "Chebyshev representation of the ephemerides of Mercury, with origin at the barycentre of the solar system (BCRS), in the equatorial ICRF frame. The ephemeris covers the period starting on JD (JDBEGIP + JDBEGFP) and ending on JD (JDENDIP + JDENDFP) for the position and starting on JD (JDBEGIV + JDBEGFV) and ending on JD (JDENDIV + JDENDFV) for the velocity. A number of Chebyshev coefficients equal to ORDERSP is given for NSSP time intervals of SPANSP days to describe the position-vector components in units of m; the similar parameters ending with PP (Peculiar Position) are not used in the current release and are reserved for future usage. A number of Chebyshev coefficients equal to ORDERSV is given for NSSV time intervals of SPANSV days to describe the velocity-vector components in units of m s^-1; the similar parameters ending with PV (Peculiar Velocity) are not used in the current release and are reserved for future usage. The first three HDUs contain the coefficients for the three components of the position, while the last three HDUs contain the coefficients for the three components of the velocity", 
     source = "A. Fienga, J. Laskar, H. Manche, M. Gastineau, 19 April 2007, 'Solar system planetary ephemeris delivery: INPOP06', GAIA-CA-TN-IMC-AF-001, issue 1, revision 0", 
     status = "DEPR", 
     basic = true, 
     scalar = false, 
     unit = "") 
    public static final String MERCURY_EPHEMERIS; static { MERCURY_EPHEMERIS = "Nature/Mercury_Ephemeris_001.fits"; } 

    /**
     * IAU-recommended value for the right ascension \alpha_0 of the north pole of rotation of Mercury. The pair (\alpha_0, \delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \alpha_0 = 273.85 deg and \delta_0 = 66.99 degrees    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)<br/>
     * Status: CONF<br/>
     * Unit: deg<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "IAU-recommended value for the right ascension \\alpha_0 of the north pole of rotation of Mercury. The pair (\\alpha_0, \\delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \\alpha_0 = 273.85 deg and \\delta_0 = 66.99 degrees", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "deg") 
    public static final double MERCURY_NORTHROTATIONALPOLE_RIGHTASCENSION; static { MERCURY_NORTHROTATIONALPOLE_RIGHTASCENSION = 281.0097; } // [deg] 

    /**
     * IAU-recommended value for the rate of change (in degrees per Julian day, calculated from the standard epoch) of the right ascension \alpha_0 of the north pole of rotation of Mercury. The pair (\alpha_0, \delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \alpha_0 = 273.85 deg and \delta_0 = 66.99 degrees    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)<br/>
     * Status: CONF<br/>
     * Unit: deg day^-1<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "IAU-recommended value for the rate of change (in degrees per Julian day, calculated from the standard epoch) of the right ascension \\alpha_0 of the north pole of rotation of Mercury. The pair (\\alpha_0, \\delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \\alpha_0 = 273.85 deg and \\delta_0 = 66.99 degrees", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "deg day^-1") 
    public static final double MERCURY_NORTHROTATIONALPOLE_RIGHTASCENSIONRATEOFCHANGE; static { MERCURY_NORTHROTATIONALPOLE_RIGHTASCENSIONRATEOFCHANGE = -0.0000008980; } // [deg day^-1] 

    /**
     * IAU-recommended value for the declination \delta_0 of the north pole of rotation of Mercury. The pair (\alpha_0, \delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \alpha_0 = 273.85 deg and \delta_0 = 66.99 degrees    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)<br/>
     * Status: CONF<br/>
     * Unit: deg<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "IAU-recommended value for the declination \\delta_0 of the north pole of rotation of Mercury. The pair (\\alpha_0, \\delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \\alpha_0 = 273.85 deg and \\delta_0 = 66.99 degrees", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "deg") 
    public static final double MERCURY_NORTHROTATIONALPOLE_DECLINATION; static { MERCURY_NORTHROTATIONALPOLE_DECLINATION = 61.4143; } // [deg] 

    /**
     * IAU-recommended value for the rate of change (in degrees per Julian day, calculated from the standard epoch) of the declination \delta_0 of the north pole of rotation of Mercury. The pair (\alpha_0, \delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \alpha_0 = 273.85 deg and \delta_0 = 66.99 degrees    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)<br/>
     * Status: CONF<br/>
     * Unit: deg day^-1<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "IAU-recommended value for the rate of change (in degrees per Julian day, calculated from the standard epoch) of the declination \\delta_0 of the north pole of rotation of Mercury. The pair (\\alpha_0, \\delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \\alpha_0 = 273.85 deg and \\delta_0 = 66.99 degrees", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "deg day^-1") 
    public static final double MERCURY_NORTHROTATIONALPOLE_DECLINATIONRATEOFCHANGE; static { MERCURY_NORTHROTATIONALPOLE_DECLINATIONRATEOFCHANGE = -0.0000001342; } // [deg day^-1] 

    /**
     * IAU-recommended value for the ephemeris position of the prime meridian of Mercury. The 20-deg meridian is defined by the crater Hun Kal. The location of the prime meridian is specified by the angle that is measured along the planet's equator in an easterly direction with respect to the planet's north pole from the node Q (located at right ascension 90 deg + \alpha_0, where \alpha_0 denotes the right ascension of the north pole of rotation) of the planet's equator on the standard equator to the point B where the prime meridian crosses the planet's equator. The right ascension of the point Q is 90 deg + \alpha_0 and the inclination of the planet's equator to the standard equator is 90 deg - \delta_0, where \delta_0 denotes the declination of the north pole of rotation. (The pair (\alpha_0, \delta_0) denotes the standard equatorial coordinates, with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB), of the north pole of rotation, which itself is defined as that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \alpha_0 = 273.85 deg and \delta_0 = 66.99 degrees.) Because the prime meridian is assumed to rotate uniformly with the planet, W accordingly varies linearly with time. In addition, \alpha_0, \delta_0, and W may vary with time due to a precession of the axis of rotation of the planet. If W increases with time, the planet has a direct (or prograde) rotation; if W decreases with time, the rotation is said to be retrograde    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)<br/>
     * Status: CONF<br/>
     * Unit: deg<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "IAU-recommended value for the ephemeris position of the prime meridian of Mercury. The 20-deg meridian is defined by the crater Hun Kal. The location of the prime meridian is specified by the angle that is measured along the planet's equator in an easterly direction with respect to the planet's north pole from the node Q (located at right ascension 90 deg + \\alpha_0, where \\alpha_0 denotes the right ascension of the north pole of rotation) of the planet's equator on the standard equator to the point B where the prime meridian crosses the planet's equator. The right ascension of the point Q is 90 deg + \\alpha_0 and the inclination of the planet's equator to the standard equator is 90 deg - \\delta_0, where \\delta_0 denotes the declination of the north pole of rotation. (The pair (\\alpha_0, \\delta_0) denotes the standard equatorial coordinates, with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB), of the north pole of rotation, which itself is defined as that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \\alpha_0 = 273.85 deg and \\delta_0 = 66.99 degrees.) Because the prime meridian is assumed to rotate uniformly with the planet, W accordingly varies linearly with time. In addition, \\alpha_0, \\delta_0, and W may vary with time due to a precession of the axis of rotation of the planet. If W increases with time, the planet has a direct (or prograde) rotation; if W decreases with time, the rotation is said to be retrograde", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "deg") 
    public static final double MERCURY_PRIMEMERIDIAN_EPHEMERISPOSITION; static { MERCURY_PRIMEMERIDIAN_EPHEMERISPOSITION = 329.5469; } // [deg] 

    /**
     * IAU-recommended value for the rate of change (in degrees per Julian day, calculated from the standard epoch of 1.5 January 2000 = JD2451545.0 TDB) of the ephemeris position of the prime meridian of Mercury. The 20-deg meridian is defined by the crater Hun Kal. The location of the prime meridian is specified by the angle that is measured along the planet's equator in an easterly direction with respect to the planet's north pole from the node Q (located at right ascension 90 deg + \alpha_0, where \alpha_0 denotes the right ascension of the north pole of rotation) of the planet's equator on the standard equator to the point B where the prime meridian crosses the planet's equator. The right ascension of the point Q is 90 deg + \alpha_0 and the inclination of the planet's equator to the standard equator is 90 deg - \delta_0, where \delta_0 denotes the declination of the north pole of rotation. (The pair (\alpha_0, \delta_0) denotes the standard equatorial coordinates, with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB), of the north pole of rotation, which itself is defined as that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \alpha_0 = 273.85 deg and \delta_0 = 66.99 degrees.) Because the prime meridian is assumed to rotate uniformly with the planet, W accordingly varies linearly with time. In addition, \alpha_0, \delta_0, and W may vary with time due to a precession of the axis of rotation of the planet. If W increases with time, the planet has a direct (or prograde) rotation; if W decreases with time, the rotation is said to be retrograde    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)<br/>
     * Status: CONF<br/>
     * Unit: deg day^-1<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "IAU-recommended value for the rate of change (in degrees per Julian day, calculated from the standard epoch of 1.5 January 2000 = JD2451545.0 TDB) of the ephemeris position of the prime meridian of Mercury. The 20-deg meridian is defined by the crater Hun Kal. The location of the prime meridian is specified by the angle that is measured along the planet's equator in an easterly direction with respect to the planet's north pole from the node Q (located at right ascension 90 deg + \\alpha_0, where \\alpha_0 denotes the right ascension of the north pole of rotation) of the planet's equator on the standard equator to the point B where the prime meridian crosses the planet's equator. The right ascension of the point Q is 90 deg + \\alpha_0 and the inclination of the planet's equator to the standard equator is 90 deg - \\delta_0, where \\delta_0 denotes the declination of the north pole of rotation. (The pair (\\alpha_0, \\delta_0) denotes the standard equatorial coordinates, with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB), of the north pole of rotation, which itself is defined as that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \\alpha_0 = 273.85 deg and \\delta_0 = 66.99 degrees.) Because the prime meridian is assumed to rotate uniformly with the planet, W accordingly varies linearly with time. In addition, \\alpha_0, \\delta_0, and W may vary with time due to a precession of the axis of rotation of the planet. If W increases with time, the planet has a direct (or prograde) rotation; if W decreases with time, the rotation is said to be retrograde", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "deg day^-1") 
    public static final double MERCURY_PRIMEMERIDIAN_EPHEMERISPOSITIONRATEOFCHANGE; static { MERCURY_PRIMEMERIDIAN_EPHEMERISPOSITIONRATEOFCHANGE = 6.1385025; } // [deg day^-1] 

    /**
     * Mass of Mercury (do not use for high-precision (orbit) calculations)    
     * <p>
     * Source: J.D. Anderson, et al., 1987, 'The mass, gravity field, and ephemeris of Mercury', Icarus, 71, 337-349; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par<br/>
     * Status: CONF<br/>
     * Unit: kg<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mass of Mercury (do not use for high-precision (orbit) calculations)", 
     source = "J.D. Anderson, et al., 1987, 'The mass, gravity field, and ephemeris of Mercury', Icarus, 71, 337-349; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "kg") 
    public static final double MERCURY_MASS; static { MERCURY_MASS = 3.301040e+23; } // [kg] 

    /**
     * Mean volumetric radius of Mercury    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A); see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par<br/>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean volumetric radius of Mercury", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A); see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "m") 
    public static final double MERCURY_VOLUMETRICRADIUS; static { MERCURY_VOLUMETRICRADIUS = 2.43970e+6; } // [m] 

    /**
     * Equatorial radius of Mercury    
     * <p>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Equatorial radius of Mercury", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m") 
    public static final double MERCURY_EQUATORIALRADIUS; static { MERCURY_EQUATORIALRADIUS = 2.43970e+6; } // [m] 

    /**
     * Polar radius of Mercury    
     * <p>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Polar radius of Mercury", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m") 
    public static final double MERCURY_POLARRADIUS; static { MERCURY_POLARRADIUS = 2.43970e+6; } // [m] 

    /**
     * V(1,0) magnitude of Mercury (i.e., the visual magnitude of the planet reduced to a distance of 1 au from both the Sun and Earth and phase angle zero). This parameter is also refered to as absolute magnitude in planetary sciences    
     * <p>
     * Source: J.L. Hilton, 2005, 'Improving the Visual Magnitudes of the Planets in The Astronomical Almanac. I. Mercury and Venus', AJ, 129, 2902-2906; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par<br/>
     * Status: CONF<br/>
     * Unit: mag<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "V(1,0) magnitude of Mercury (i.e., the visual magnitude of the planet reduced to a distance of 1 au from both the Sun and Earth and phase angle zero). This parameter is also refered to as absolute magnitude in planetary sciences", 
     source = "J.L. Hilton, 2005, 'Improving the Visual Magnitudes of the Planets in The Astronomical Almanac. I. Mercury and Venus', AJ, 129, 2902-2906; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "mag") 
    public static final double MERCURY_VONEZEROMAGNITUDE; static { MERCURY_VONEZEROMAGNITUDE = -0.60; } // [mag] 

    /**
     * Geometric albedo of Mercury (i.e., the ratio of the body's brightness at zero phase angle to the brightness of a perfectly diffusing disk with the same position and apparent size as the body)    
     * <p>
     * Source: P.K. Seidelmann, 1992, 'Explanatory Supplement to the Astronomical Almanac', University Science Books, Mill Valley, Ca., ISBN 0-935702-68-7, Table 15.8 on page 706; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Geometric albedo of Mercury (i.e., the ratio of the body's brightness at zero phase angle to the brightness of a perfectly diffusing disk with the same position and apparent size as the body)", 
     source = "P.K. Seidelmann, 1992, 'Explanatory Supplement to the Astronomical Almanac', University Science Books, Mill Valley, Ca., ISBN 0-935702-68-7, Table 15.8 on page 706; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double MERCURY_GEOMETRICALBEDO; static { MERCURY_GEOMETRICALBEDO = 0.106; } 

    /**
     * Mean mass density of Mercury    
     * <p>
     * Status: CONF<br/>
     * Unit: g cm^-3<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean mass density of Mercury", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "g cm^-3") 
    public static final double MERCURY_MASSDENSITY_MEAN; static { MERCURY_MASSDENSITY_MEAN = 5.427; } // [g cm^-3] 

    /**
     * Radius of the smallest hypothetical sphere around Mercury which would encompass the body (this is a low-accuracy parameter used in the relativistic model)    
     * <p>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Radius of the smallest hypothetical sphere around Mercury which would encompass the body (this is a low-accuracy parameter used in the relativistic model)", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m") 
    public static final double MERCURY_ENCOMPASSINGSPHERERADIUS; static { MERCURY_ENCOMPASSINGSPHERERADIUS = 2.4397e+6; } // [m] 

    /**
     * Dynamical form-factor of Mercury (oblateness or Stokes' second-degree zonal harmonic of the potential)    
     * <p>
     * Source: J.D. Anderson, G. Colombo, P.B. Esposito, E.L. Lau, G.B. Trager, 1 September 1987, 'The mass, gravity field, and ephemeris of Mercury', Icarus, 71, 337-349<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Dynamical form-factor of Mercury (oblateness or Stokes' second-degree zonal harmonic of the potential)", 
     source = "J.D. Anderson, G. Colombo, P.B. Esposito, E.L. Lau, G.B. Trager, 1 September 1987, 'The mass, gravity field, and ephemeris of Mercury', Icarus, 71, 337-349", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double MERCURY_JSUB2; static { MERCURY_JSUB2 = 6.00e-5; } 

    /**
     * Geometrical flattening factor f of Mercury (f = (a-b)/a)    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A); see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Geometrical flattening factor f of Mercury (f = (a-b)/a)", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A); see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double MERCURY_FLATTENING; static { MERCURY_FLATTENING = 0.; } 

    /**
     * Post-Newtonian deflection angle of a limb-grazing light ray due to the spherically symmetric part of the gravitational field of Mercury    
     * <p>
     * Source: S.A. Klioner, 2003, 'A Practical Relativistic Model for Microarcsecond Astrometry in Space', AJ, 125, 1580, Equation 64 with cot(x) = cos(x) / sin(x) approximated by x^-1; see also J.H.J. de Bruijne, 19 February 2002, 'Gravitational light deflection', GAIA-JdB-001, issue 1, revision 0<br/>
     * Status: CONF<br/>
     * Unit: 10^-6 arcsec<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Post-Newtonian deflection angle of a limb-grazing light ray due to the spherically symmetric part of the gravitational field of Mercury", 
     source = "S.A. Klioner, 2003, 'A Practical Relativistic Model for Microarcsecond Astrometry in Space', AJ, 125, 1580, Equation 64 with cot(x) = cos(x) / sin(x) approximated by x^-1; see also J.H.J. de Bruijne, 19 February 2002, 'Gravitational light deflection', GAIA-JdB-001, issue 1, revision 0", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "10^-6 arcsec") 
    public static final double MERCURY_LIGHTDEFLECTION_LIMB; static { MERCURY_LIGHTDEFLECTION_LIMB = 83.; } // [10^-6 arcsec] 

    /**
     * Geometric transit probability (Mercury transiting the Sun) for an observer external to the solar system    
     * <p>
     * Source: E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 2.1, Equation 2.2, page 14<br/>
     * Status: CONF<br/>
     * Unit: %<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Geometric transit probability (Mercury transiting the Sun) for an observer external to the solar system", 
     source = "E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 2.1, Equation 2.2, page 14", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "%") 
    public static final double MERCURY_TRANSITPROBABILITY; static { MERCURY_TRANSITPROBABILITY = 1.206; } // [%] 

    /**
     * Maximum reduction of the solar flux for an observer external to the solar system during a transit of Mercury    
     * <p>
     * Source: E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 2.2, Equation 2.4, page 14<br/>
     * Status: CONF<br/>
     * Unit: %<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Maximum reduction of the solar flux for an observer external to the solar system during a transit of Mercury", 
     source = "E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 2.2, Equation 2.4, page 14", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "%") 
    public static final double MERCURY_FLUXREDUCTION_MAXIMUM; static { MERCURY_FLUXREDUCTION_MAXIMUM = 0.001; } // [%] 

    /**
     * Maximum transit time of Mercury (transiting the Sun) for an observer external to the solar system    
     * <p>
     * Source: E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 2.3, Equation 2.5, page 15<br/>
     * Status: CONF<br/>
     * Unit: day<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Maximum transit time of Mercury (transiting the Sun) for an observer external to the solar system", 
     source = "E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 2.3, Equation 2.5, page 15", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "day") 
    public static final double MERCURY_TRANSITTIME_MAXIMUM; static { MERCURY_TRANSITTIME_MAXIMUM = 0.34; } // [day] 

    /**
     * Mercury(-system) mass (IAU 2009 CBE value)    
     * <p>
     * Status: CONF<br/>
     * Unit: kg<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mercury(-system) mass (IAU 2009 CBE value)", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "kg") 
    public static final double MERCURYSYSTEM_MASS; static { MERCURYSYSTEM_MASS = 3.3011e+23; } // [kg] 

    /**
     * Mean orbital semi-major axis of Mercury, at the standard epoch J2000.0. The mean orbital semi-major axis is associated with a mean orbit solution from a 250-year least-squares fit of JPL's DE405 ephemeris to a Keplerian orbit covering the interval of years 1800 AD - 2050 AD. The orbital element is referenced to the mean ecliptic and equinox of J2000 at the standard epoch J2000.0; linear rates and fit errors can be found in the reference document    
     * <p>
     * Source: E.M. Standish, 16 February 2006, 'Keplerian Elements for Approximate Positions of the Major Planets', http://ssd.jpl.nasa.gov/?planets\#elem<br/>
     * Status: CONF<br/>
     * Unit: au<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean orbital semi-major axis of Mercury, at the standard epoch J2000.0. The mean orbital semi-major axis is associated with a mean orbit solution from a 250-year least-squares fit of JPL's DE405 ephemeris to a Keplerian orbit covering the interval of years 1800 AD - 2050 AD. The orbital element is referenced to the mean ecliptic and equinox of J2000 at the standard epoch J2000.0; linear rates and fit errors can be found in the reference document", 
     source = "E.M. Standish, 16 February 2006, 'Keplerian Elements for Approximate Positions of the Major Planets', http://ssd.jpl.nasa.gov/?planets\\#elem", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "au") 
    public static final double MERCURYSYSTEM_ORBITALSEMIMAJORAXIS_J2000; static { MERCURYSYSTEM_ORBITALSEMIMAJORAXIS_J2000 = 0.38709927; } // [au] 

    /**
     * Mean orbital eccentricity of Mercury, at the standard epoch J2000.0. The mean orbital eccentricity is associated with a mean orbit solution from a 250-year least-squares fit of JPL's DE405 ephemeris to a Keplerian orbit covering the interval of years 1800 AD - 2050 AD. The orbital element is referenced to the mean ecliptic and equinox of J2000 at the standard epoch J2000.0; linear rates and fit errors can be found in the reference document    
     * <p>
     * Source: E.M. Standish, 16 February 2006, 'Keplerian Elements for Approximate Positions of the Major Planets', http://ssd.jpl.nasa.gov/?planets\#elem<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean orbital eccentricity of Mercury, at the standard epoch J2000.0. The mean orbital eccentricity is associated with a mean orbit solution from a 250-year least-squares fit of JPL's DE405 ephemeris to a Keplerian orbit covering the interval of years 1800 AD - 2050 AD. The orbital element is referenced to the mean ecliptic and equinox of J2000 at the standard epoch J2000.0; linear rates and fit errors can be found in the reference document", 
     source = "E.M. Standish, 16 February 2006, 'Keplerian Elements for Approximate Positions of the Major Planets', http://ssd.jpl.nasa.gov/?planets\\#elem", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double MERCURYSYSTEM_ORBITALECCENTRICITY_J2000; static { MERCURYSYSTEM_ORBITALECCENTRICITY_J2000 = 0.20563593; } 

    /**
     * Mean orbital inclination of Mercury, at the standard epoch J2000.0. The mean orbital inclination is is associated with a mean orbit solution from a 250-year least-squares fit of JPL's DE405 ephemeris to a Keplerian orbit covering the interval of years 1800 AD - 2050 AD. The orbital element is referenced to the mean ecliptic and equinox of J2000 at the standard epoch J2000.0; linear rates and fit errors can be found in the reference document    
     * <p>
     * Source: E.M. Standish, 16 February 2006, 'Keplerian Elements for Approximate Positions of the Major Planets', http://ssd.jpl.nasa.gov/?planets\#elem<br/>
     * Status: CONF<br/>
     * Unit: deg<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean orbital inclination of Mercury, at the standard epoch J2000.0. The mean orbital inclination is is associated with a mean orbit solution from a 250-year least-squares fit of JPL's DE405 ephemeris to a Keplerian orbit covering the interval of years 1800 AD - 2050 AD. The orbital element is referenced to the mean ecliptic and equinox of J2000 at the standard epoch J2000.0; linear rates and fit errors can be found in the reference document", 
     source = "E.M. Standish, 16 February 2006, 'Keplerian Elements for Approximate Positions of the Major Planets', http://ssd.jpl.nasa.gov/?planets\\#elem", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "deg") 
    public static final double MERCURYSYSTEM_ORBITALINCLINATION_J2000; static { MERCURYSYSTEM_ORBITALINCLINATION_J2000 = 7.00497902; } // [deg] 

    /**
     * Sidereal orbital period    
     * <p>
     * Source: Values derived from the mean longitude rates in Table 5.8.1 in P.K. Seidelmann, 1992, 'Explanatory Supplement to the Astronomical Almanac', University Science Books, Mill Valley, Ca., ISBN 0-935702-68-7, page 316; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par<br/>
     * Status: CONF<br/>
     * Unit: yr<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Sidereal orbital period", 
     source = "Values derived from the mean longitude rates in Table 5.8.1 in P.K. Seidelmann, 1992, 'Explanatory Supplement to the Astronomical Almanac', University Science Books, Mill Valley, Ca., ISBN 0-935702-68-7, page 316; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "yr") 
    public static final double MERCURYSYSTEM_ORBITALPERIOD; static { MERCURYSYSTEM_ORBITALPERIOD = 0.2408467; } // [yr] 

    /**
     * Radial-velocity amplitude of the Sun induced by Mercury for 'an edge-on observer' (i.e., an observer in the orbital plane of Mercury)    
     * <p>
     * Source: E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 1.4, Equation 1.18, page 9<br/>
     * Status: CONF<br/>
     * Unit: m s^-1<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Radial-velocity amplitude of the Sun induced by Mercury for 'an edge-on observer' (i.e., an observer in the orbital plane of Mercury)", 
     source = "E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 1.4, Equation 1.18, page 9", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m s^-1") 
    public static final double MERCURYSYSTEM_RADIALVELOCITYSIGNATURE; static { MERCURYSYSTEM_RADIALVELOCITYSIGNATURE = 0.008; } // [m s^-1] 

    /**
     * Astrometric signature of the Sun induced by Mercury for an observer located at a distance of 10 pc from the Sun    
     * <p>
     * Source: E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 1.7, Equation 1.22, page 11<br/>
     * Status: CONF<br/>
     * Unit: 10^-6 arcsec<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Astrometric signature of the Sun induced by Mercury for an observer located at a distance of 10 pc from the Sun", 
     source = "E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 1.7, Equation 1.22, page 11", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "10^-6 arcsec") 
    public static final double MERCURYSYSTEM_ASTROMETRICSIGNATURE_10PARSEC; static { MERCURYSYSTEM_ASTROMETRICSIGNATURE_10PARSEC = 0.006; } // [10^-6 arcsec] 

    /**
     * One micro-arcsecond in units of radians    
     * <p>
     * Status: CONF<br/>
     * Unit: rad<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "One micro-arcsecond in units of radians", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "rad") 
    public static final double MICROARCSECOND_RADIAN; static { MICROARCSECOND_RADIAN = 4.848136811095360e-12; } // [rad] 

    /**
     * The typical expected micro-meteoroid flux at L2, in units of particles cm^-2 s^-1 hemisphere^-1, resulting from particles with masses greater than m (in units of kg and for m < 2.8E-11 kg) equals 2.8E-11 * m^(-1/2)    
     * <p>
     * Source: L. Lindegren, 13 July 2000, 'Effects of micro-meteoroids on Gaia attitude', GAIA-LL-031, issue 1, revision 0. See also K. Yamakoshi, 1994, 'Extraterrestrial dust; Laboratory studies of interplanetary dust', Astrophysics and Space Science Library, 181, Kluwer Academic Publishers, Dordrecht (1994edls.book.....Y)<br/>
     * Status: CONF<br/>
     * Unit: particles m^-2 s^-1 hemisphere^-1<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "The typical expected micro-meteoroid flux at L2, in units of particles cm^-2 s^-1 hemisphere^-1, resulting from particles with masses greater than m (in units of kg and for m < 2.8E-11 kg) equals 2.8E-11 * m^(-1/2)", 
     source = "L. Lindegren, 13 July 2000, 'Effects of micro-meteoroids on Gaia attitude', GAIA-LL-031, issue 1, revision 0. See also K. Yamakoshi, 1994, 'Extraterrestrial dust; Laboratory studies of interplanetary dust', Astrophysics and Space Science Library, 181, Kluwer Academic Publishers, Dordrecht (1994edls.book.....Y)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "particles m^-2 s^-1 hemisphere^-1") 
    public static final double MICROMETEOROID_FLUX_L2SMALLPARTICLES; static { MICROMETEOROID_FLUX_L2SMALLPARTICLES = 2.80e-11; } // [particles m^-2 s^-1 hemisphere^-1] 

    /**
     * The typical expected micro-meteoroid flux at L2, in units of particles cm^-2 s^-1 hemisphere^-1, resulting from particles with masses greater than m (in units of kg and for m > 2.8E-11 kg) equals 2.6E-18 * m^(-7/6)    
     * <p>
     * Source: L. Lindegren, 13 July 2000, 'Effects of micro-meteoroids on Gaia attitude', GAIA-LL-031, issue 1, revision 0. See also K. Yamakoshi, 1994, 'Extraterrestrial dust; Laboratory studies of interplanetary dust', Astrophysics and Space Science Library, 181, Kluwer Academic Publishers, Dordrecht (1994edls.book.....Y)<br/>
     * Status: CONF<br/>
     * Unit: particles m^-2 s^-1 hemisphere^-1<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "The typical expected micro-meteoroid flux at L2, in units of particles cm^-2 s^-1 hemisphere^-1, resulting from particles with masses greater than m (in units of kg and for m > 2.8E-11 kg) equals 2.6E-18 * m^(-7/6)", 
     source = "L. Lindegren, 13 July 2000, 'Effects of micro-meteoroids on Gaia attitude', GAIA-LL-031, issue 1, revision 0. See also K. Yamakoshi, 1994, 'Extraterrestrial dust; Laboratory studies of interplanetary dust', Astrophysics and Space Science Library, 181, Kluwer Academic Publishers, Dordrecht (1994edls.book.....Y)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "particles m^-2 s^-1 hemisphere^-1") 
    public static final double MICROMETEOROID_FLUX_L2LARGEPARTICLES; static { MICROMETEOROID_FLUX_L2LARGEPARTICLES = 2.60e-18; } // [particles m^-2 s^-1 hemisphere^-1] 

    /**
     * One milli-arcsecond in units of radians    
     * <p>
     * Status: CONF<br/>
     * Unit: rad<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "One milli-arcsecond in units of radians", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "rad") 
    public static final double MILLIARCSECOND_RADIAN; static { MILLIARCSECOND_RADIAN = 4.848136811095359e-9; } // [rad] 

    /**
     * Molar gas constant    
     * <p>
     * Source: P.J. Mohr, B.N. Taylor, D.B. Newell, 9 July 2015, 'The 2014 CODATA Recommended Values of the Fundamental Physical Constants', National Institute of Standards and Technology, Gaithersburg, MD 20899-8401; http://www.codata.org/ and http://physics.nist.gov/constants (Web Version 7.0)<br/>
     * Status: CONF<br/>
     * Unit: J mol^-1 K^-1<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Molar gas constant", 
     source = "P.J. Mohr, B.N. Taylor, D.B. Newell, 9 July 2015, 'The 2014 CODATA Recommended Values of the Fundamental Physical Constants', National Institute of Standards and Technology, Gaithersburg, MD 20899-8401; http://www.codata.org/ and http://physics.nist.gov/constants (Web Version 7.0)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "J mol^-1 K^-1") 
    public static final double MOLARGAS_CONSTANT; static { MOLARGAS_CONSTANT = 8.3144598; } // [J mol^-1 K^-1] 

    /**
     * Chebyshev representation of the ephemerides of the Moon, with origin at the barycentre of the solar system (BCRS), in the equatorial ICRF frame. The ephemeris covers the period starting on JD (JDBEGIP + JDBEGFP) and ending on JD (JDENDIP + JDENDFP) for the position and starting on JD (JDBEGIV + JDBEGFV) and ending on JD (JDENDIV + JDENDFV) for the velocity. A number of Chebyshev coefficients equal to ORDERSP is given for NSSP time intervals of SPANSP days to describe the position-vector components in units of m; the similar parameters ending with PP (Peculiar Position) are not used in the current release and are reserved for future usage. A number of Chebyshev coefficients equal to ORDERSV is given for NSSV time intervals of SPANSV days to describe the velocity-vector components in units of m s^-1; the similar parameters ending with PV (Peculiar Velocity) are not used in the current release and are reserved for future usage. The first three HDUs contain the coefficients for the three components of the position, while the last three HDUs contain the coefficients for the three components of the velocity    
     * <p>
     * Source: A. Fienga, J. Laskar, H. Manche, M. Gastineau, 19 April 2007, 'Solar system planetary ephemeris delivery: INPOP06', GAIA-CA-TN-IMC-AF-001, issue 1, revision 0<br/>
     * Status: DEPR<br/>
     * Basic : true<br/>
     * Scalar: false
     */
    @ParamMetaData (
    description = "Chebyshev representation of the ephemerides of the Moon, with origin at the barycentre of the solar system (BCRS), in the equatorial ICRF frame. The ephemeris covers the period starting on JD (JDBEGIP + JDBEGFP) and ending on JD (JDENDIP + JDENDFP) for the position and starting on JD (JDBEGIV + JDBEGFV) and ending on JD (JDENDIV + JDENDFV) for the velocity. A number of Chebyshev coefficients equal to ORDERSP is given for NSSP time intervals of SPANSP days to describe the position-vector components in units of m; the similar parameters ending with PP (Peculiar Position) are not used in the current release and are reserved for future usage. A number of Chebyshev coefficients equal to ORDERSV is given for NSSV time intervals of SPANSV days to describe the velocity-vector components in units of m s^-1; the similar parameters ending with PV (Peculiar Velocity) are not used in the current release and are reserved for future usage. The first three HDUs contain the coefficients for the three components of the position, while the last three HDUs contain the coefficients for the three components of the velocity", 
     source = "A. Fienga, J. Laskar, H. Manche, M. Gastineau, 19 April 2007, 'Solar system planetary ephemeris delivery: INPOP06', GAIA-CA-TN-IMC-AF-001, issue 1, revision 0", 
     status = "DEPR", 
     basic = true, 
     scalar = false, 
     unit = "") 
    public static final String MOON_EPHEMERIS; static { MOON_EPHEMERIS = "Nature/Moon_Ephemeris_001.fits"; } 

    /**
     * Lunar diurnal parallax. Formally, this parameter is defined as the ratio of a fictitious mean equatorial radius of the Earth to the perturbed mean distance of the Moon; the ratio F_2 of the perturbed mean distance to the Moon (the perturbation being due to the Sun) to the two-body mean distance of the Moon (with the Sun not present and constant mean motion) equals 0.999093141975298 (see T.D. Moyer, 15 May 1971, 'Mathematical formulation of the Double-Precision Orbit Determination Programme (DPODP)', NASA JPL Technical Report 32-1527, pages 25-26)    
     * <p>
     * Status: CONF<br/>
     * Unit: arcsec<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Lunar diurnal parallax. Formally, this parameter is defined as the ratio of a fictitious mean equatorial radius of the Earth to the perturbed mean distance of the Moon; the ratio F_2 of the perturbed mean distance to the Moon (the perturbation being due to the Sun) to the two-body mean distance of the Moon (with the Sun not present and constant mean motion) equals 0.999093141975298 (see T.D. Moyer, 15 May 1971, 'Mathematical formulation of the Double-Precision Orbit Determination Programme (DPODP)', NASA JPL Technical Report 32-1527, pages 25-26)", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "arcsec") 
    public static final double MOON_DIURNALPARALLAX; static { MOON_DIURNALPARALLAX = 3422.595; } // [arcsec] 

    /**
     * Semi-major axis of Lunar orbit (mean ecliptic orbital elements, at the standard epoch J2000.0, based on JPL's Planetary and Lunar Ephemerides DE405/LE405)    
     * <p>
     * Source: E.M. Standish, 2001, 'Approximate Mean Ecliptic Elements of the Lunar Orbit', JPL IOM 312.F-01-004 (http://ssd.jpl.nasa.gov/?sat_elem)<br/>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Semi-major axis of Lunar orbit (mean ecliptic orbital elements, at the standard epoch J2000.0, based on JPL's Planetary and Lunar Ephemerides DE405/LE405)", 
     source = "E.M. Standish, 2001, 'Approximate Mean Ecliptic Elements of the Lunar Orbit', JPL IOM 312.F-01-004 (http://ssd.jpl.nasa.gov/?sat_elem)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "m") 
    public static final double MOON_ORBITALSEMIMAJORAXIS_J2000; static { MOON_ORBITALSEMIMAJORAXIS_J2000 = 3.844000e+8; } // [m] 

    /**
     * Eccentricity of Lunar orbit (mean ecliptic orbital elements, at the standard epoch J2000.0, based on JPL's Planetary and Lunar Ephemerides DE405/LE405)    
     * <p>
     * Source: E.M. Standish, 2001, 'Approximate Mean Ecliptic Elements of the Lunar Orbit', JPL IOM 312.F-01-004 (http://ssd.jpl.nasa.gov/?sat_elem)<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Eccentricity of Lunar orbit (mean ecliptic orbital elements, at the standard epoch J2000.0, based on JPL's Planetary and Lunar Ephemerides DE405/LE405)", 
     source = "E.M. Standish, 2001, 'Approximate Mean Ecliptic Elements of the Lunar Orbit', JPL IOM 312.F-01-004 (http://ssd.jpl.nasa.gov/?sat_elem)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double MOON_ORBITALECCENTRICITY_J2000; static { MOON_ORBITALECCENTRICITY_J2000 = 0.0554; } 

    /**
     * Inclination of Lunar orbit with respect to the ecliptic (mean ecliptic orbital elements, at the standard epoch J2000.0, based on JPL's Planetary and Lunar Ephemerides DE405/LE405)    
     * <p>
     * Source: E.M. Standish, 2001, 'Approximate Mean Ecliptic Elements of the Lunar Orbit', JPL IOM 312.F-01-004 (http://ssd.jpl.nasa.gov/?sat_elem)<br/>
     * Status: CONF<br/>
     * Unit: deg<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Inclination of Lunar orbit with respect to the ecliptic (mean ecliptic orbital elements, at the standard epoch J2000.0, based on JPL's Planetary and Lunar Ephemerides DE405/LE405)", 
     source = "E.M. Standish, 2001, 'Approximate Mean Ecliptic Elements of the Lunar Orbit', JPL IOM 312.F-01-004 (http://ssd.jpl.nasa.gov/?sat_elem)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "deg") 
    public static final double MOON_ORBITALINCLINATION_J2000; static { MOON_ORBITALINCLINATION_J2000 = 5.16; } // [deg] 

    /**
     * Sidereal period of Lunar orbit (mean ecliptic orbital elements, at the standard epoch J2000.0, based on JPL's Planetary and Lunar Ephemerides DE405/LE405)    
     * <p>
     * Source: E.M. Standish, 2001, 'Approximate Mean Ecliptic Elements of the Lunar Orbit', JPL IOM 312.F-01-004 (http://ssd.jpl.nasa.gov/?sat_elem)<br/>
     * Status: CONF<br/>
     * Unit: day<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Sidereal period of Lunar orbit (mean ecliptic orbital elements, at the standard epoch J2000.0, based on JPL's Planetary and Lunar Ephemerides DE405/LE405)", 
     source = "E.M. Standish, 2001, 'Approximate Mean Ecliptic Elements of the Lunar Orbit', JPL IOM 312.F-01-004 (http://ssd.jpl.nasa.gov/?sat_elem)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "day") 
    public static final double MOON_SIDEREALPERIOD_J2000; static { MOON_SIDEREALPERIOD_J2000 = 27.322; } // [day] 

    /**
     * Precession period of the argument of periapsis of Lunar orbit, i.e., apsidal period (mean ecliptic orbital elements, at the standard epoch J2000.0, based on JPL's Planetary and Lunar Ephemerides DE405/LE405)    
     * <p>
     * Source: E.M. Standish, 2001, 'Approximate Mean Ecliptic Elements of the Lunar Orbit', JPL IOM 312.F-01-004 (http://ssd.jpl.nasa.gov/?sat_elem)<br/>
     * Status: CONF<br/>
     * Unit: yr<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Precession period of the argument of periapsis of Lunar orbit, i.e., apsidal period (mean ecliptic orbital elements, at the standard epoch J2000.0, based on JPL's Planetary and Lunar Ephemerides DE405/LE405)", 
     source = "E.M. Standish, 2001, 'Approximate Mean Ecliptic Elements of the Lunar Orbit', JPL IOM 312.F-01-004 (http://ssd.jpl.nasa.gov/?sat_elem)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "yr") 
    public static final double MOON_PRECESSIONPERIOD_J2000ARGUMENTOFPERIAPSIS; static { MOON_PRECESSIONPERIOD_J2000ARGUMENTOFPERIAPSIS = 5.997; } // [yr] 

    /**
     * Precession period of the longitude of the ascending node of Lunar orbit, i.e., nodal period (mean ecliptic orbital elements, at the standard epoch J2000.0, based on JPL's Planetary and Lunar Ephemerides DE405/LE405)    
     * <p>
     * Source: E.M. Standish, 2001, 'Approximate Mean Ecliptic Elements of the Lunar Orbit', JPL IOM 312.F-01-004 (http://ssd.jpl.nasa.gov/?sat_elem)<br/>
     * Status: CONF<br/>
     * Unit: yr<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Precession period of the longitude of the ascending node of Lunar orbit, i.e., nodal period (mean ecliptic orbital elements, at the standard epoch J2000.0, based on JPL's Planetary and Lunar Ephemerides DE405/LE405)", 
     source = "E.M. Standish, 2001, 'Approximate Mean Ecliptic Elements of the Lunar Orbit', JPL IOM 312.F-01-004 (http://ssd.jpl.nasa.gov/?sat_elem)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "yr") 
    public static final double MOON_PRECESSIONPERIOD_J2000LONGITUDEOFASCENDINGNODE; static { MOON_PRECESSIONPERIOD_J2000LONGITUDEOFASCENDINGNODE = 18.600; } // [yr] 

    /**
     * Selenocentric gravitational constant (TCB-compatible value)    
     * <p>
     * Status: CONF<br/>
     * Unit: m^3 s^-2<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Selenocentric gravitational constant (TCB-compatible value)", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m^3 s^-2") 
    public static final double MOON_GM; static { MOON_GM = 4.9028002e+12; } // [m^3 s^-2] 

    /**
     * Lunar mass (do not use for high-precision (orbit) calculations)    
     * <p>
     * Status: CONF<br/>
     * Unit: kg<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Lunar mass (do not use for high-precision (orbit) calculations)", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "kg") 
    public static final double MOON_MASS; static { MOON_MASS = 7.3460e+22; } // [kg] 

    /**
     * Mean volumetric radius of the Moon    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A); see also D.K. Yeomans (NASA/JPL), 3 April 2009, 'Planetary Satellite Physical Parameters', http://ssd.jpl.nasa.gov/?sat_phys_par<br/>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean volumetric radius of the Moon", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A); see also D.K. Yeomans (NASA/JPL), 3 April 2009, 'Planetary Satellite Physical Parameters', http://ssd.jpl.nasa.gov/?sat_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "m") 
    public static final double MOON_VOLUMETRICRADIUS; static { MOON_VOLUMETRICRADIUS = 1.73740e+6; } // [m] 

    /**
     * Mean Moon mass density    
     * <p>
     * Status: CONF<br/>
     * Unit: g cm^-3<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean Moon mass density", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "g cm^-3") 
    public static final double MOON_MASSDENSITY_MEAN; static { MOON_MASSDENSITY_MEAN = 3.344; } // [g cm^-3] 

    /**
     * Johnson V band mean opposition magnitude of the Moon    
     * <p>
     * Source: P.K. Seidelmann, 1992, 'Explanatory Supplement to the Astronomical Almanac', University Science Books, Mill Valley, Ca., ISBN 0-935702-68-7, Table 15.8<br/>
     * Status: CONF<br/>
     * Unit: mag<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Johnson V band mean opposition magnitude of the Moon", 
     source = "P.K. Seidelmann, 1992, 'Explanatory Supplement to the Astronomical Almanac', University Science Books, Mill Valley, Ca., ISBN 0-935702-68-7, Table 15.8", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "mag") 
    public static final double MOON_OPPOSITIONVMAGNITUDE; static { MOON_OPPOSITIONVMAGNITUDE = -12.74; } // [mag] 

    /**
     * Geometric albedo of the Moon (i.e., the ratio of the body's brightness at zero phase angle to the brightness of a perfectly diffusing disk with the same position and apparent size as the body)    
     * <p>
     * Source: P.K. Seidelmann, 1992, 'Explanatory Supplement to the Astronomical Almanac', University Science Books, Mill Valley, Ca., ISBN 0-935702-68-7, Table 15.8<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Geometric albedo of the Moon (i.e., the ratio of the body's brightness at zero phase angle to the brightness of a perfectly diffusing disk with the same position and apparent size as the body)", 
     source = "P.K. Seidelmann, 1992, 'Explanatory Supplement to the Astronomical Almanac', University Science Books, Mill Valley, Ca., ISBN 0-935702-68-7, Table 15.8", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double MOON_GEOMETRICALBEDO; static { MOON_GEOMETRICALBEDO = 0.12; } 

    /**
     * Radius of the smallest hypothetical sphere around the Moon which would encompass the body (this is a low-accuracy parameter used in the relativistic model)    
     * <p>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Radius of the smallest hypothetical sphere around the Moon which would encompass the body (this is a low-accuracy parameter used in the relativistic model)", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m") 
    public static final double MOON_ENCOMPASSINGSPHERERADIUS; static { MOON_ENCOMPASSINGSPHERERADIUS = 1738000.; } // [m] 

    /**
     * Radius of the smallest hypothetical sphere around J1 (Io) which would encompass the body (this is a low-accuracy parameter used in the relativistic model)    
     * <p>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Radius of the smallest hypothetical sphere around J1 (Io) which would encompass the body (this is a low-accuracy parameter used in the relativistic model)", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m") 
    public static final double MOONJ1_ENCOMPASSINGSPHERERADIUS; static { MOONJ1_ENCOMPASSINGSPHERERADIUS = 1.82149e+6; } // [m] 

    /**
     * GM of J1 (Io)    
     * <p>
     * Source: R.A. Jacobson, 2003, 'Constants used in the JUP230 ephemeris', priv. comm.; see also D.K. Yeomans (NASA/JPL), 3 April 2009, 'Planetary Satellite Physical Parameters', http://ssd.jpl.nasa.gov/?sat_phys_par<br/>
     * Status: CONF<br/>
     * Unit: m^3 s^-2<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "GM of J1 (Io)", 
     source = "R.A. Jacobson, 2003, 'Constants used in the JUP230 ephemeris', priv. comm.; see also D.K. Yeomans (NASA/JPL), 3 April 2009, 'Planetary Satellite Physical Parameters', http://ssd.jpl.nasa.gov/?sat_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "m^3 s^-2") 
    public static final double MOONJ1_GM; static { MOONJ1_GM = 5.9599160e+12; } // [m^3 s^-2] 

    /**
     * Radius of J1 (Io)    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A); see also D.K. Yeomans (NASA/JPL), 3 April 2009, 'Planetary Satellite Physical Parameters', http://ssd.jpl.nasa.gov/?sat_phys_par<br/>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Radius of J1 (Io)", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A); see also D.K. Yeomans (NASA/JPL), 3 April 2009, 'Planetary Satellite Physical Parameters', http://ssd.jpl.nasa.gov/?sat_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "m") 
    public static final double MOONJ1_RADIUS; static { MOONJ1_RADIUS = 1.821490e+6; } // [m] 

    /**
     * Mean mass density of J1 (Io)    
     * <p>
     * Status: CONF<br/>
     * Unit: g cm^-3<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean mass density of J1 (Io)", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "g cm^-3") 
    public static final double MOONJ1_MASSDENSITY_MEAN; static { MOONJ1_MASSDENSITY_MEAN = 3.528; } // [g cm^-3] 

    /**
     * Post-Newtonian deflection angle of a limb-grazing light ray due to the spherically symmetric part of the gravitational field of J1 (Io)    
     * <p>
     * Source: S.A. Klioner, 2003, 'A Practical Relativistic Model for Microarcsecond Astrometry in Space', AJ, 125, 1580, Equation 64 with cot(x) = cos(x) / sin(x) approximated by x^-1; see also J.H.J. de Bruijne, 19 February 2002, 'Gravitational light deflection', GAIA-JdB-001, issue 1, revision 0<br/>
     * Status: CONF<br/>
     * Unit: 10^-6 arcsec<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Post-Newtonian deflection angle of a limb-grazing light ray due to the spherically symmetric part of the gravitational field of J1 (Io)", 
     source = "S.A. Klioner, 2003, 'A Practical Relativistic Model for Microarcsecond Astrometry in Space', AJ, 125, 1580, Equation 64 with cot(x) = cos(x) / sin(x) approximated by x^-1; see also J.H.J. de Bruijne, 19 February 2002, 'Gravitational light deflection', GAIA-JdB-001, issue 1, revision 0", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "10^-6 arcsec") 
    public static final double MOONJ1_LIGHTDEFLECTION_LIMB; static { MOONJ1_LIGHTDEFLECTION_LIMB = 30.; } // [10^-6 arcsec] 

    /**
     * Radius of the smallest hypothetical sphere around J2 (Europa) which would encompass the body (this is a low-accuracy parameter used in the relativistic model)    
     * <p>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Radius of the smallest hypothetical sphere around J2 (Europa) which would encompass the body (this is a low-accuracy parameter used in the relativistic model)", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m") 
    public static final double MOONJ2_ENCOMPASSINGSPHERERADIUS; static { MOONJ2_ENCOMPASSINGSPHERERADIUS = 1.56080e+6; } // [m] 

    /**
     * GM of J2 (Europa)    
     * <p>
     * Source: R.A. Jacobson, 2003, 'Constants used in the JUP230 ephemeris', priv. comm.; see also D.K. Yeomans (NASA/JPL), 3 April 2009, 'Planetary Satellite Physical Parameters', http://ssd.jpl.nasa.gov/?sat_phys_par<br/>
     * Status: CONF<br/>
     * Unit: m^3 s^-2<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "GM of J2 (Europa)", 
     source = "R.A. Jacobson, 2003, 'Constants used in the JUP230 ephemeris', priv. comm.; see also D.K. Yeomans (NASA/JPL), 3 April 2009, 'Planetary Satellite Physical Parameters', http://ssd.jpl.nasa.gov/?sat_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "m^3 s^-2") 
    public static final double MOONJ2_GM; static { MOONJ2_GM = 3.2027390e+12; } // [m^3 s^-2] 

    /**
     * Radius of J2 (Europa)    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A); see also D.K. Yeomans (NASA/JPL), 3 April 2009, 'Planetary Satellite Physical Parameters', http://ssd.jpl.nasa.gov/?sat_phys_par<br/>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Radius of J2 (Europa)", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A); see also D.K. Yeomans (NASA/JPL), 3 April 2009, 'Planetary Satellite Physical Parameters', http://ssd.jpl.nasa.gov/?sat_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "m") 
    public static final double MOONJ2_RADIUS; static { MOONJ2_RADIUS = 1.56080e+6; } // [m] 

    /**
     * Mean mass density of J2 (Europa)    
     * <p>
     * Status: CONF<br/>
     * Unit: g cm^-3<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean mass density of J2 (Europa)", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "g cm^-3") 
    public static final double MOONJ2_MASSDENSITY_MEAN; static { MOONJ2_MASSDENSITY_MEAN = 3.013; } // [g cm^-3] 

    /**
     * Post-Newtonian deflection angle of a limb-grazing light ray due to the spherically symmetric part of the gravitational field of J2 (Europa)    
     * <p>
     * Source: S.A. Klioner, 2003, 'A Practical Relativistic Model for Microarcsecond Astrometry in Space', AJ, 125, 1580, Equation 64 with cot(x) = cos(x) / sin(x) approximated by x^-1; see also J.H.J. de Bruijne, 19 February 2002, 'Gravitational light deflection', GAIA-JdB-001, issue 1, revision 0<br/>
     * Status: CONF<br/>
     * Unit: 10^-6 arcsec<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Post-Newtonian deflection angle of a limb-grazing light ray due to the spherically symmetric part of the gravitational field of J2 (Europa)", 
     source = "S.A. Klioner, 2003, 'A Practical Relativistic Model for Microarcsecond Astrometry in Space', AJ, 125, 1580, Equation 64 with cot(x) = cos(x) / sin(x) approximated by x^-1; see also J.H.J. de Bruijne, 19 February 2002, 'Gravitational light deflection', GAIA-JdB-001, issue 1, revision 0", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "10^-6 arcsec") 
    public static final double MOONJ2_LIGHTDEFLECTION_LIMB; static { MOONJ2_LIGHTDEFLECTION_LIMB = 19.; } // [10^-6 arcsec] 

    /**
     * Radius of the smallest hypothetical sphere around J3 (Ganymede) which would encompass the body (this is a low-accuracy parameter used in the relativistic model)    
     * <p>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Radius of the smallest hypothetical sphere around J3 (Ganymede) which would encompass the body (this is a low-accuracy parameter used in the relativistic model)", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m") 
    public static final double MOONJ3_ENCOMPASSINGSPHERERADIUS; static { MOONJ3_ENCOMPASSINGSPHERERADIUS = 2.63120e+6; } // [m] 

    /**
     * GM of J3 (Ganymede)    
     * <p>
     * Source: R.A. Jacobson, 2003, 'Constants used in the JUP230 ephemeris', priv. comm.; see also D.K. Yeomans (NASA/JPL), 3 April 2009, 'Planetary Satellite Physical Parameters', http://ssd.jpl.nasa.gov/?sat_phys_par<br/>
     * Status: CONF<br/>
     * Unit: m^3 s^-2<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "GM of J3 (Ganymede)", 
     source = "R.A. Jacobson, 2003, 'Constants used in the JUP230 ephemeris', priv. comm.; see also D.K. Yeomans (NASA/JPL), 3 April 2009, 'Planetary Satellite Physical Parameters', http://ssd.jpl.nasa.gov/?sat_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "m^3 s^-2") 
    public static final double MOONJ3_GM; static { MOONJ3_GM = 9.8878340e+12; } // [m^3 s^-2] 

    /**
     * Radius of J3 (Ganymede)    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A); see also D.K. Yeomans (NASA/JPL), 3 April 2009, 'Planetary Satellite Physical Parameters', http://ssd.jpl.nasa.gov/?sat_phys_par<br/>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Radius of J3 (Ganymede)", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A); see also D.K. Yeomans (NASA/JPL), 3 April 2009, 'Planetary Satellite Physical Parameters', http://ssd.jpl.nasa.gov/?sat_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "m") 
    public static final double MOONJ3_RADIUS; static { MOONJ3_RADIUS = 2.63120e+6; } // [m] 

    /**
     * Mean mass density of J3 (Ganymede)    
     * <p>
     * Status: CONF<br/>
     * Unit: g cm^-3<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean mass density of J3 (Ganymede)", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "g cm^-3") 
    public static final double MOONJ3_MASSDENSITY_MEAN; static { MOONJ3_MASSDENSITY_MEAN = 1.942; } // [g cm^-3] 

    /**
     * Post-Newtonian deflection angle of a limb-grazing light ray due to the spherically symmetric part of the gravitational field of J3 (Ganymede)    
     * <p>
     * Source: S.A. Klioner, 2003, 'A Practical Relativistic Model for Microarcsecond Astrometry in Space', AJ, 125, 1580, Equation 64 with cot(x) = cos(x) / sin(x) approximated by x^-1; see also J.H.J. de Bruijne, 19 February 2002, 'Gravitational light deflection', GAIA-JdB-001, issue 1, revision 0<br/>
     * Status: CONF<br/>
     * Unit: 10^-6 arcsec<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Post-Newtonian deflection angle of a limb-grazing light ray due to the spherically symmetric part of the gravitational field of J3 (Ganymede)", 
     source = "S.A. Klioner, 2003, 'A Practical Relativistic Model for Microarcsecond Astrometry in Space', AJ, 125, 1580, Equation 64 with cot(x) = cos(x) / sin(x) approximated by x^-1; see also J.H.J. de Bruijne, 19 February 2002, 'Gravitational light deflection', GAIA-JdB-001, issue 1, revision 0", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "10^-6 arcsec") 
    public static final double MOONJ3_LIGHTDEFLECTION_LIMB; static { MOONJ3_LIGHTDEFLECTION_LIMB = 34.; } // [10^-6 arcsec] 

    /**
     * Radius of the smallest hypothetical sphere around J4 (Callisto) which would encompass the body (this is a low-accuracy parameter used in the relativistic model)    
     * <p>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Radius of the smallest hypothetical sphere around J4 (Callisto) which would encompass the body (this is a low-accuracy parameter used in the relativistic model)", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m") 
    public static final double MOONJ4_ENCOMPASSINGSPHERERADIUS; static { MOONJ4_ENCOMPASSINGSPHERERADIUS = 2.41030e+6; } // [m] 

    /**
     * GM of J4 (Callisto)    
     * <p>
     * Source: R.A. Jacobson, 2003, 'Constants used in the JUP230 ephemeris', priv. comm.; see also D.K. Yeomans (NASA/JPL), 3 April 2009, 'Planetary Satellite Physical Parameters', http://ssd.jpl.nasa.gov/?sat_phys_par<br/>
     * Status: CONF<br/>
     * Unit: m^3 s^-2<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "GM of J4 (Callisto)", 
     source = "R.A. Jacobson, 2003, 'Constants used in the JUP230 ephemeris', priv. comm.; see also D.K. Yeomans (NASA/JPL), 3 April 2009, 'Planetary Satellite Physical Parameters', http://ssd.jpl.nasa.gov/?sat_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "m^3 s^-2") 
    public static final double MOONJ4_GM; static { MOONJ4_GM = 7.1792890e+12; } // [m^3 s^-2] 

    /**
     * Radius of J4 (Callisto)    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A); see also D.K. Yeomans (NASA/JPL), 3 April 2009, 'Planetary Satellite Physical Parameters', http://ssd.jpl.nasa.gov/?sat_phys_par<br/>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Radius of J4 (Callisto)", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A); see also D.K. Yeomans (NASA/JPL), 3 April 2009, 'Planetary Satellite Physical Parameters', http://ssd.jpl.nasa.gov/?sat_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "m") 
    public static final double MOONJ4_RADIUS; static { MOONJ4_RADIUS = 2.41030e+6; } // [m] 

    /**
     * Mean mass density of J4 (Callisto)    
     * <p>
     * Status: CONF<br/>
     * Unit: g cm^-3<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean mass density of J4 (Callisto)", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "g cm^-3") 
    public static final double MOONJ4_MASSDENSITY_MEAN; static { MOONJ4_MASSDENSITY_MEAN = 1.834; } // [g cm^-3] 

    /**
     * Post-Newtonian deflection angle of a limb-grazing light ray due to the spherically symmetric part of the gravitational field of J4 (Callisto)    
     * <p>
     * Source: S.A. Klioner, 2003, 'A Practical Relativistic Model for Microarcsecond Astrometry in Space', AJ, 125, 1580, Equation 64 with cot(x) = cos(x) / sin(x) approximated by x^-1; see also J.H.J. de Bruijne, 19 February 2002, 'Gravitational light deflection', GAIA-JdB-001, issue 1, revision 0<br/>
     * Status: CONF<br/>
     * Unit: 10^-6 arcsec<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Post-Newtonian deflection angle of a limb-grazing light ray due to the spherically symmetric part of the gravitational field of J4 (Callisto)", 
     source = "S.A. Klioner, 2003, 'A Practical Relativistic Model for Microarcsecond Astrometry in Space', AJ, 125, 1580, Equation 64 with cot(x) = cos(x) / sin(x) approximated by x^-1; see also J.H.J. de Bruijne, 19 February 2002, 'Gravitational light deflection', GAIA-JdB-001, issue 1, revision 0", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "10^-6 arcsec") 
    public static final double MOONJ4_LIGHTDEFLECTION_LIMB; static { MOONJ4_LIGHTDEFLECTION_LIMB = 27.; } // [10^-6 arcsec] 

    /**
     * Radius of the smallest hypothetical sphere around N1 (Triton) which would encompass the body (this is a low-accuracy parameter used in the relativistic model)    
     * <p>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Radius of the smallest hypothetical sphere around N1 (Triton) which would encompass the body (this is a low-accuracy parameter used in the relativistic model)", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m") 
    public static final double MOONN1_ENCOMPASSINGSPHERERADIUS; static { MOONN1_ENCOMPASSINGSPHERERADIUS = 1.35260e+6; } // [m] 

    /**
     * GM of N1 (Triton)    
     * <p>
     * Source: R.A. Jacobson, 2009, 'The Orbits of the Neptunian Satellites and the Orientation of the Pole of Neptune', AJ, 137, 4322; see also D.K. Yeomans (NASA/JPL), 3 April 2009, 'Planetary Satellite Physical Parameters', http://ssd.jpl.nasa.gov/?sat_phys_par<br/>
     * Status: CONF<br/>
     * Unit: m^3 s^-2<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "GM of N1 (Triton)", 
     source = "R.A. Jacobson, 2009, 'The Orbits of the Neptunian Satellites and the Orientation of the Pole of Neptune', AJ, 137, 4322; see also D.K. Yeomans (NASA/JPL), 3 April 2009, 'Planetary Satellite Physical Parameters', http://ssd.jpl.nasa.gov/?sat_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "m^3 s^-2") 
    public static final double MOONN1_GM; static { MOONN1_GM = 1.42760e+12; } // [m^3 s^-2] 

    /**
     * Radius of N1 (Triton)    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A); see also D.K. Yeomans (NASA/JPL), 3 April 2009, 'Planetary Satellite Physical Parameters', http://ssd.jpl.nasa.gov/?sat_phys_par<br/>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Radius of N1 (Triton)", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A); see also D.K. Yeomans (NASA/JPL), 3 April 2009, 'Planetary Satellite Physical Parameters', http://ssd.jpl.nasa.gov/?sat_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "m") 
    public static final double MOONN1_RADIUS; static { MOONN1_RADIUS = 1.35260e+6; } // [m] 

    /**
     * Mean mass density of N1 (Triton)    
     * <p>
     * Status: CONF<br/>
     * Unit: g cm^-3<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean mass density of N1 (Triton)", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "g cm^-3") 
    public static final double MOONN1_MASSDENSITY_MEAN; static { MOONN1_MASSDENSITY_MEAN = 2.064; } // [g cm^-3] 

    /**
     * Post-Newtonian deflection angle of a limb-grazing light ray due to the spherically symmetric part of the gravitational field of N1 (Triton)    
     * <p>
     * Source: S.A. Klioner, 2003, 'A Practical Relativistic Model for Microarcsecond Astrometry in Space', AJ, 125, 1580, Equation 64 with cot(x) = cos(x) / sin(x) approximated by x^-1; see also J.H.J. de Bruijne, 19 February 2002, 'Gravitational light deflection', GAIA-JdB-001, issue 1, revision 0<br/>
     * Status: CONF<br/>
     * Unit: 10^-6 arcsec<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Post-Newtonian deflection angle of a limb-grazing light ray due to the spherically symmetric part of the gravitational field of N1 (Triton)", 
     source = "S.A. Klioner, 2003, 'A Practical Relativistic Model for Microarcsecond Astrometry in Space', AJ, 125, 1580, Equation 64 with cot(x) = cos(x) / sin(x) approximated by x^-1; see also J.H.J. de Bruijne, 19 February 2002, 'Gravitational light deflection', GAIA-JdB-001, issue 1, revision 0", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "10^-6 arcsec") 
    public static final double MOONN1_LIGHTDEFLECTION_LIMB; static { MOONN1_LIGHTDEFLECTION_LIMB = 10.; } // [10^-6 arcsec] 

    /**
     * Radius of the smallest hypothetical sphere around S3 (Tethys) which would encompass the body (this is a low-accuracy parameter used in the relativistic model)    
     * <p>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Radius of the smallest hypothetical sphere around S3 (Tethys) which would encompass the body (this is a low-accuracy parameter used in the relativistic model)", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m") 
    public static final double MOONS3_ENCOMPASSINGSPHERERADIUS; static { MOONS3_ENCOMPASSINGSPHERERADIUS = 5.3100e+5; } // [m] 

    /**
     * GM of S3 (Tethys)    
     * <p>
     * Source: R.A. Jacobson, et al., 2008, 'The Gravity Gield of the Saturnian System and the Orbits of the Major Saturnian satellites', Presented at the Saturn After Cassini-Huygens Symposium held at Imperial College London, UK, 28 July - 1 August 2008; see also D.K. Yeomans (NASA/JPL), 3 April 2009, 'Planetary Satellite Physical Parameters', http://ssd.jpl.nasa.gov/?sat_phys_par<br/>
     * Status: CONF<br/>
     * Unit: m^3 s^-2<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "GM of S3 (Tethys)", 
     source = "R.A. Jacobson, et al., 2008, 'The Gravity Gield of the Saturnian System and the Orbits of the Major Saturnian satellites', Presented at the Saturn After Cassini-Huygens Symposium held at Imperial College London, UK, 28 July - 1 August 2008; see also D.K. Yeomans (NASA/JPL), 3 April 2009, 'Planetary Satellite Physical Parameters', http://ssd.jpl.nasa.gov/?sat_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "m^3 s^-2") 
    public static final double MOONS3_GM; static { MOONS3_GM = 4.120670e+10; } // [m^3 s^-2] 

    /**
     * Radius of S3 (Tethys)    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A); see also D.K. Yeomans (NASA/JPL), 3 April 2009, 'Planetary Satellite Physical Parameters', http://ssd.jpl.nasa.gov/?sat_phys_par<br/>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Radius of S3 (Tethys)", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A); see also D.K. Yeomans (NASA/JPL), 3 April 2009, 'Planetary Satellite Physical Parameters', http://ssd.jpl.nasa.gov/?sat_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "m") 
    public static final double MOONS3_RADIUS; static { MOONS3_RADIUS = 5.3100e+5; } // [m] 

    /**
     * Mean mass density of S3 (Tethys)    
     * <p>
     * Status: CONF<br/>
     * Unit: g cm^-3<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean mass density of S3 (Tethys)", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "g cm^-3") 
    public static final double MOONS3_MASSDENSITY_MEAN; static { MOONS3_MASSDENSITY_MEAN = 0.984; } // [g cm^-3] 

    /**
     * Post-Newtonian deflection angle of a limb-grazing light ray due to the spherically symmetric part of the gravitational field of S3 (Tethys)    
     * <p>
     * Source: S.A. Klioner, 2003, 'A Practical Relativistic Model for Microarcsecond Astrometry in Space', AJ, 125, 1580, Equation 64 with cot(x) = cos(x) / sin(x) approximated by x^-1; see also J.H.J. de Bruijne, 19 February 2002, 'Gravitational light deflection', GAIA-JdB-001, issue 1, revision 0<br/>
     * Status: CONF<br/>
     * Unit: 10^-6 arcsec<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Post-Newtonian deflection angle of a limb-grazing light ray due to the spherically symmetric part of the gravitational field of S3 (Tethys)", 
     source = "S.A. Klioner, 2003, 'A Practical Relativistic Model for Microarcsecond Astrometry in Space', AJ, 125, 1580, Equation 64 with cot(x) = cos(x) / sin(x) approximated by x^-1; see also J.H.J. de Bruijne, 19 February 2002, 'Gravitational light deflection', GAIA-JdB-001, issue 1, revision 0", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "10^-6 arcsec") 
    public static final double MOONS3_LIGHTDEFLECTION_LIMB; static { MOONS3_LIGHTDEFLECTION_LIMB = 1.; } // [10^-6 arcsec] 

    /**
     * Radius of the smallest hypothetical sphere around S4 (Dione) which would encompass the body (this is a low-accuracy parameter used in the relativistic model)    
     * <p>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Radius of the smallest hypothetical sphere around S4 (Dione) which would encompass the body (this is a low-accuracy parameter used in the relativistic model)", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m") 
    public static final double MOONS4_ENCOMPASSINGSPHERERADIUS; static { MOONS4_ENCOMPASSINGSPHERERADIUS = 5.614e+5; } // [m] 

    /**
     * GM of S4 (Dione)    
     * <p>
     * Source: R.A. Jacobson, et al., 2008, 'The Gravity Gield of the Saturnian System and the Orbits of the Major Saturnian satellites', Presented at the Saturn After Cassini-Huygens Symposium held at Imperial College London, UK, 28 July - 1 August 2008; see also D.K. Yeomans (NASA/JPL), 3 April 2009, 'Planetary Satellite Physical Parameters', http://ssd.jpl.nasa.gov/?sat_phys_par<br/>
     * Status: CONF<br/>
     * Unit: m^3 s^-2<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "GM of S4 (Dione)", 
     source = "R.A. Jacobson, et al., 2008, 'The Gravity Gield of the Saturnian System and the Orbits of the Major Saturnian satellites', Presented at the Saturn After Cassini-Huygens Symposium held at Imperial College London, UK, 28 July - 1 August 2008; see also D.K. Yeomans (NASA/JPL), 3 April 2009, 'Planetary Satellite Physical Parameters', http://ssd.jpl.nasa.gov/?sat_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "m^3 s^-2") 
    public static final double MOONS4_GM; static { MOONS4_GM = 7.311460e+10; } // [m^3 s^-2] 

    /**
     * Radius of S4 (Dione)    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A); see also D.K. Yeomans (NASA/JPL), 3 April 2009, 'Planetary Satellite Physical Parameters', http://ssd.jpl.nasa.gov/?sat_phys_par<br/>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Radius of S4 (Dione)", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A); see also D.K. Yeomans (NASA/JPL), 3 April 2009, 'Planetary Satellite Physical Parameters', http://ssd.jpl.nasa.gov/?sat_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "m") 
    public static final double MOONS4_RADIUS; static { MOONS4_RADIUS = 5.6140e+5; } // [m] 

    /**
     * Mean mass density of S4 (Dione)    
     * <p>
     * Status: CONF<br/>
     * Unit: g cm^-3<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean mass density of S4 (Dione)", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "g cm^-3") 
    public static final double MOONS4_MASSDENSITY_MEAN; static { MOONS4_MASSDENSITY_MEAN = 1.478; } // [g cm^-3] 

    /**
     * Post-Newtonian deflection angle of a limb-grazing light ray due to the spherically symmetric part of the gravitational field of S4 (Dione)    
     * <p>
     * Source: S.A. Klioner, 2003, 'A Practical Relativistic Model for Microarcsecond Astrometry in Space', AJ, 125, 1580, Equation 64 with cot(x) = cos(x) / sin(x) approximated by x^-1; see also J.H.J. de Bruijne, 19 February 2002, 'Gravitational light deflection', GAIA-JdB-001, issue 1, revision 0<br/>
     * Status: CONF<br/>
     * Unit: 10^-6 arcsec<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Post-Newtonian deflection angle of a limb-grazing light ray due to the spherically symmetric part of the gravitational field of S4 (Dione)", 
     source = "S.A. Klioner, 2003, 'A Practical Relativistic Model for Microarcsecond Astrometry in Space', AJ, 125, 1580, Equation 64 with cot(x) = cos(x) / sin(x) approximated by x^-1; see also J.H.J. de Bruijne, 19 February 2002, 'Gravitational light deflection', GAIA-JdB-001, issue 1, revision 0", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "10^-6 arcsec") 
    public static final double MOONS4_LIGHTDEFLECTION_LIMB; static { MOONS4_LIGHTDEFLECTION_LIMB = 1.; } // [10^-6 arcsec] 

    /**
     * Radius of the smallest hypothetical sphere around S5 (Rhea) which would encompass the body (this is a low-accuracy parameter used in the relativistic model)    
     * <p>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Radius of the smallest hypothetical sphere around S5 (Rhea) which would encompass the body (this is a low-accuracy parameter used in the relativistic model)", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m") 
    public static final double MOONS5_ENCOMPASSINGSPHERERADIUS; static { MOONS5_ENCOMPASSINGSPHERERADIUS = 7.635e+5; } // [m] 

    /**
     * GM of S5 (Rhea)    
     * <p>
     * Source: R.A. Jacobson, et al., 2008, 'The Gravity Gield of the Saturnian System and the Orbits of the Major Saturnian satellites', Presented at the Saturn After Cassini-Huygens Symposium held at Imperial College London, UK, 28 July - 1 August 2008; see also D.K. Yeomans (NASA/JPL), 3 April 2009, 'Planetary Satellite Physical Parameters', http://ssd.jpl.nasa.gov/?sat_phys_par<br/>
     * Status: CONF<br/>
     * Unit: m^3 s^-2<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "GM of S5 (Rhea)", 
     source = "R.A. Jacobson, et al., 2008, 'The Gravity Gield of the Saturnian System and the Orbits of the Major Saturnian satellites', Presented at the Saturn After Cassini-Huygens Symposium held at Imperial College London, UK, 28 July - 1 August 2008; see also D.K. Yeomans (NASA/JPL), 3 April 2009, 'Planetary Satellite Physical Parameters', http://ssd.jpl.nasa.gov/?sat_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "m^3 s^-2") 
    public static final double MOONS5_GM; static { MOONS5_GM = 1.5394260e+11; } // [m^3 s^-2] 

    /**
     * Radius of S5 (Rhea)    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A); see also D.K. Yeomans (NASA/JPL), 3 April 2009, 'Planetary Satellite Physical Parameters', http://ssd.jpl.nasa.gov/?sat_phys_par<br/>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Radius of S5 (Rhea)", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A); see also D.K. Yeomans (NASA/JPL), 3 April 2009, 'Planetary Satellite Physical Parameters', http://ssd.jpl.nasa.gov/?sat_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "m") 
    public static final double MOONS5_RADIUS; static { MOONS5_RADIUS = 7.6350e+5; } // [m] 

    /**
     * Mean mass density of S5 (Rhea)    
     * <p>
     * Status: CONF<br/>
     * Unit: g cm^-3<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean mass density of S5 (Rhea)", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "g cm^-3") 
    public static final double MOONS5_MASSDENSITY_MEAN; static { MOONS5_MASSDENSITY_MEAN = 1.237; } // [g cm^-3] 

    /**
     * Post-Newtonian deflection angle of a limb-grazing light ray due to the spherically symmetric part of the gravitational field of S5 (Rhea)    
     * <p>
     * Source: S.A. Klioner, 2003, 'A Practical Relativistic Model for Microarcsecond Astrometry in Space', AJ, 125, 1580, Equation 64 with cot(x) = cos(x) / sin(x) approximated by x^-1; see also J.H.J. de Bruijne, 19 February 2002, 'Gravitational light deflection', GAIA-JdB-001, issue 1, revision 0<br/>
     * Status: CONF<br/>
     * Unit: 10^-6 arcsec<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Post-Newtonian deflection angle of a limb-grazing light ray due to the spherically symmetric part of the gravitational field of S5 (Rhea)", 
     source = "S.A. Klioner, 2003, 'A Practical Relativistic Model for Microarcsecond Astrometry in Space', AJ, 125, 1580, Equation 64 with cot(x) = cos(x) / sin(x) approximated by x^-1; see also J.H.J. de Bruijne, 19 February 2002, 'Gravitational light deflection', GAIA-JdB-001, issue 1, revision 0", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "10^-6 arcsec") 
    public static final double MOONS5_LIGHTDEFLECTION_LIMB; static { MOONS5_LIGHTDEFLECTION_LIMB = 2.; } // [10^-6 arcsec] 

    /**
     * Radius of the smallest hypothetical sphere around S6 (Titan) which would encompass the body (this is a low-accuracy parameter used in the relativistic model)    
     * <p>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Radius of the smallest hypothetical sphere around S6 (Titan) which would encompass the body (this is a low-accuracy parameter used in the relativistic model)", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m") 
    public static final double MOONS6_ENCOMPASSINGSPHERERADIUS; static { MOONS6_ENCOMPASSINGSPHERERADIUS = 2.5747e+6; } // [m] 

    /**
     * GM of S6 (Titan)    
     * <p>
     * Source: R.A. Jacobson, et al., 2008, 'The Gravity Gield of the Saturnian System and the Orbits of the Major Saturnian satellites', Presented at the Saturn After Cassini-Huygens Symposium held at Imperial College London, UK, 28 July - 1 August 2008; see also D.K. Yeomans (NASA/JPL), 3 April 2009, 'Planetary Satellite Physical Parameters', http://ssd.jpl.nasa.gov/?sat_phys_par<br/>
     * Status: CONF<br/>
     * Unit: m^3 s^-2<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "GM of S6 (Titan)", 
     source = "R.A. Jacobson, et al., 2008, 'The Gravity Gield of the Saturnian System and the Orbits of the Major Saturnian satellites', Presented at the Saturn After Cassini-Huygens Symposium held at Imperial College London, UK, 28 July - 1 August 2008; see also D.K. Yeomans (NASA/JPL), 3 April 2009, 'Planetary Satellite Physical Parameters', http://ssd.jpl.nasa.gov/?sat_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "m^3 s^-2") 
    public static final double MOONS6_GM; static { MOONS6_GM = 8.97813820e+12; } // [m^3 s^-2] 

    /**
     * Radius of S6 (Titan)    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A); see also D.K. Yeomans (NASA/JPL), 3 April 2009, 'Planetary Satellite Physical Parameters', http://ssd.jpl.nasa.gov/?sat_phys_par<br/>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Radius of S6 (Titan)", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A); see also D.K. Yeomans (NASA/JPL), 3 April 2009, 'Planetary Satellite Physical Parameters', http://ssd.jpl.nasa.gov/?sat_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "m") 
    public static final double MOONS6_RADIUS; static { MOONS6_RADIUS = 2.574730e+6; } // [m] 

    /**
     * Mean mass density of S6 (Titan)    
     * <p>
     * Status: CONF<br/>
     * Unit: g cm^-3<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean mass density of S6 (Titan)", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "g cm^-3") 
    public static final double MOONS6_MASSDENSITY_MEAN; static { MOONS6_MASSDENSITY_MEAN = 1.882; } // [g cm^-3] 

    /**
     * Post-Newtonian deflection angle of a limb-grazing light ray due to the spherically symmetric part of the gravitational field of S6 (Titan)    
     * <p>
     * Source: S.A. Klioner, 2003, 'A Practical Relativistic Model for Microarcsecond Astrometry in Space', AJ, 125, 1580, Equation 64 with cot(x) = cos(x) / sin(x) approximated by x^-1; see also J.H.J. de Bruijne, 19 February 2002, 'Gravitational light deflection', GAIA-JdB-001, issue 1, revision 0<br/>
     * Status: CONF<br/>
     * Unit: 10^-6 arcsec<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Post-Newtonian deflection angle of a limb-grazing light ray due to the spherically symmetric part of the gravitational field of S6 (Titan)", 
     source = "S.A. Klioner, 2003, 'A Practical Relativistic Model for Microarcsecond Astrometry in Space', AJ, 125, 1580, Equation 64 with cot(x) = cos(x) / sin(x) approximated by x^-1; see also J.H.J. de Bruijne, 19 February 2002, 'Gravitational light deflection', GAIA-JdB-001, issue 1, revision 0", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "10^-6 arcsec") 
    public static final double MOONS6_LIGHTDEFLECTION_LIMB; static { MOONS6_LIGHTDEFLECTION_LIMB = 32.; } // [10^-6 arcsec] 

    /**
     * Radius of the smallest hypothetical sphere around S8 (Iapetus) which would encompass the body (this is a low-accuracy parameter used in the relativistic model)    
     * <p>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Radius of the smallest hypothetical sphere around S8 (Iapetus) which would encompass the body (this is a low-accuracy parameter used in the relativistic model)", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m") 
    public static final double MOONS8_ENCOMPASSINGSPHERERADIUS; static { MOONS8_ENCOMPASSINGSPHERERADIUS = 7.343e+5; } // [m] 

    /**
     * GM of S8 (Iapetus)    
     * <p>
     * Source: R.A. Jacobson, et al., 2008, 'The Gravity Gield of the Saturnian System and the Orbits of the Major Saturnian satellites', Presented at the Saturn After Cassini-Huygens Symposium held at Imperial College London, UK, 28 July - 1 August 2008; see also D.K. Yeomans (NASA/JPL), 3 April 2009, 'Planetary Satellite Physical Parameters', http://ssd.jpl.nasa.gov/?sat_phys_par<br/>
     * Status: CONF<br/>
     * Unit: m^3 s^-2<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "GM of S8 (Iapetus)", 
     source = "R.A. Jacobson, et al., 2008, 'The Gravity Gield of the Saturnian System and the Orbits of the Major Saturnian satellites', Presented at the Saturn After Cassini-Huygens Symposium held at Imperial College London, UK, 28 July - 1 August 2008; see also D.K. Yeomans (NASA/JPL), 3 April 2009, 'Planetary Satellite Physical Parameters', http://ssd.jpl.nasa.gov/?sat_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "m^3 s^-2") 
    public static final double MOONS8_GM; static { MOONS8_GM = 1.2050380e+11; } // [m^3 s^-2] 

    /**
     * Radius of S8 (Iapetus)    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A); see also D.K. Yeomans (NASA/JPL), 3 April 2009, 'Planetary Satellite Physical Parameters', http://ssd.jpl.nasa.gov/?sat_phys_par<br/>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Radius of S8 (Iapetus)", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A); see also D.K. Yeomans (NASA/JPL), 3 April 2009, 'Planetary Satellite Physical Parameters', http://ssd.jpl.nasa.gov/?sat_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "m") 
    public static final double MOONS8_RADIUS; static { MOONS8_RADIUS = 7.3430e+5; } // [m] 

    /**
     * Mean mass density of S8 (Iapetus)    
     * <p>
     * Status: CONF<br/>
     * Unit: g cm^-3<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean mass density of S8 (Iapetus)", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "g cm^-3") 
    public static final double MOONS8_MASSDENSITY_MEAN; static { MOONS8_MASSDENSITY_MEAN = 1.089; } // [g cm^-3] 

    /**
     * Post-Newtonian deflection angle of a limb-grazing light ray due to the spherically symmetric part of the gravitational field of S8 (Iapetus)    
     * <p>
     * Source: S.A. Klioner, 2003, 'A Practical Relativistic Model for Microarcsecond Astrometry in Space', AJ, 125, 1580, Equation 64 with cot(x) = cos(x) / sin(x) approximated by x^-1; see also J.H.J. de Bruijne, 19 February 2002, 'Gravitational light deflection', GAIA-JdB-001, issue 1, revision 0<br/>
     * Status: CONF<br/>
     * Unit: 10^-6 arcsec<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Post-Newtonian deflection angle of a limb-grazing light ray due to the spherically symmetric part of the gravitational field of S8 (Iapetus)", 
     source = "S.A. Klioner, 2003, 'A Practical Relativistic Model for Microarcsecond Astrometry in Space', AJ, 125, 1580, Equation 64 with cot(x) = cos(x) / sin(x) approximated by x^-1; see also J.H.J. de Bruijne, 19 February 2002, 'Gravitational light deflection', GAIA-JdB-001, issue 1, revision 0", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "10^-6 arcsec") 
    public static final double MOONS8_LIGHTDEFLECTION_LIMB; static { MOONS8_LIGHTDEFLECTION_LIMB = 2.; } // [10^-6 arcsec] 

    /**
     * Ratio of Moon to Earth mass    
     * <p>
     * Source: The IAU (2009) System of Astronomical Constants (IAU, August 2009, 'IAU 2009 Astronomical Constants', IAU 2009 Resolution B2 adopted at the XXVII-th General Assembly of the IAU. See also IAU, 10 August 2009, 'IAU WG on NSFA Current Best Estimates', http://maia.usno.navy.mil/NSFA/NSFA_cbe.html)<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Ratio of Moon to Earth mass", 
     source = "The IAU (2009) System of Astronomical Constants (IAU, August 2009, 'IAU 2009 Astronomical Constants', IAU 2009 Resolution B2 adopted at the XXVII-th General Assembly of the IAU. See also IAU, 10 August 2009, 'IAU WG on NSFA Current Best Estimates', http://maia.usno.navy.mil/NSFA/NSFA_cbe.html)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double MOONTOEARTH_MASSRATIO; static { MOONTOEARTH_MASSRATIO = 0.0123000371; } 

    /**
     * Radius of the smallest hypothetical sphere around U1 (Ariel) which would encompass the body (this is a low-accuracy parameter used in the relativistic model)    
     * <p>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Radius of the smallest hypothetical sphere around U1 (Ariel) which would encompass the body (this is a low-accuracy parameter used in the relativistic model)", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m") 
    public static final double MOONU1_ENCOMPASSINGSPHERERADIUS; static { MOONU1_ENCOMPASSINGSPHERERADIUS = 5.7890e+5; } // [m] 

    /**
     * GM of U1 (Ariel)    
     * <p>
     * Source: R.A. Jacobson, 2007, 'The Gravity Field of the Uranian System and the Orbits of the Uranian Satellites and Rings', BAAS, 39, 453; see also D.K. Yeomans (NASA/JPL), 3 April 2009, 'Planetary Satellite Physical Parameters', http://ssd.jpl.nasa.gov/?sat_phys_par<br/>
     * Status: CONF<br/>
     * Unit: m^3 s^-2<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "GM of U1 (Ariel)", 
     source = "R.A. Jacobson, 2007, 'The Gravity Field of the Uranian System and the Orbits of the Uranian Satellites and Rings', BAAS, 39, 453; see also D.K. Yeomans (NASA/JPL), 3 April 2009, 'Planetary Satellite Physical Parameters', http://ssd.jpl.nasa.gov/?sat_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "m^3 s^-2") 
    public static final double MOONU1_GM; static { MOONU1_GM = 8.640e+10; } // [m^3 s^-2] 

    /**
     * Radius of U1 (Ariel)    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A); see also D.K. Yeomans (NASA/JPL), 3 April 2009, 'Planetary Satellite Physical Parameters', http://ssd.jpl.nasa.gov/?sat_phys_par<br/>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Radius of U1 (Ariel)", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A); see also D.K. Yeomans (NASA/JPL), 3 April 2009, 'Planetary Satellite Physical Parameters', http://ssd.jpl.nasa.gov/?sat_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "m") 
    public static final double MOONU1_RADIUS; static { MOONU1_RADIUS = 5.7890e+5; } // [m] 

    /**
     * Mean mass density of U1 (Ariel)    
     * <p>
     * Status: CONF<br/>
     * Unit: g cm^-3<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean mass density of U1 (Ariel)", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "g cm^-3") 
    public static final double MOONU1_MASSDENSITY_MEAN; static { MOONU1_MASSDENSITY_MEAN = 1.593; } // [g cm^-3] 

    /**
     * Post-Newtonian deflection angle of a limb-grazing light ray due to the spherically symmetric part of the gravitational field of U1 (Ariel)    
     * <p>
     * Source: S.A. Klioner, 2003, 'A Practical Relativistic Model for Microarcsecond Astrometry in Space', AJ, 125, 1580, Equation 64 with cot(x) = cos(x) / sin(x) approximated by x^-1; see also J.H.J. de Bruijne, 19 February 2002, 'Gravitational light deflection', GAIA-JdB-001, issue 1, revision 0<br/>
     * Status: CONF<br/>
     * Unit: 10^-6 arcsec<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Post-Newtonian deflection angle of a limb-grazing light ray due to the spherically symmetric part of the gravitational field of U1 (Ariel)", 
     source = "S.A. Klioner, 2003, 'A Practical Relativistic Model for Microarcsecond Astrometry in Space', AJ, 125, 1580, Equation 64 with cot(x) = cos(x) / sin(x) approximated by x^-1; see also J.H.J. de Bruijne, 19 February 2002, 'Gravitational light deflection', GAIA-JdB-001, issue 1, revision 0", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "10^-6 arcsec") 
    public static final double MOONU1_LIGHTDEFLECTION_LIMB; static { MOONU1_LIGHTDEFLECTION_LIMB = 1.; } // [10^-6 arcsec] 

    /**
     * Radius of the smallest hypothetical sphere around U2 (Umbriel) which would encompass the body (this is a low-accuracy parameter used in the relativistic model)    
     * <p>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Radius of the smallest hypothetical sphere around U2 (Umbriel) which would encompass the body (this is a low-accuracy parameter used in the relativistic model)", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m") 
    public static final double MOONU2_ENCOMPASSINGSPHERERADIUS; static { MOONU2_ENCOMPASSINGSPHERERADIUS = 5.8470e+5; } // [m] 

    /**
     * GM of U2 (Umbriel)    
     * <p>
     * Source: R.A. Jacobson, 2007, 'The Gravity Field of the Uranian System and the Orbits of the Uranian Satellites and Rings', BAAS, 39, 453; see also D.K. Yeomans (NASA/JPL), 3 April 2009, 'Planetary Satellite Physical Parameters', http://ssd.jpl.nasa.gov/?sat_phys_par<br/>
     * Status: CONF<br/>
     * Unit: m^3 s^-2<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "GM of U2 (Umbriel)", 
     source = "R.A. Jacobson, 2007, 'The Gravity Field of the Uranian System and the Orbits of the Uranian Satellites and Rings', BAAS, 39, 453; see also D.K. Yeomans (NASA/JPL), 3 April 2009, 'Planetary Satellite Physical Parameters', http://ssd.jpl.nasa.gov/?sat_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "m^3 s^-2") 
    public static final double MOONU2_GM; static { MOONU2_GM = 8.150e+10; } // [m^3 s^-2] 

    /**
     * Radius of U2 (Umbriel)    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A); see also D.K. Yeomans (NASA/JPL), 3 April 2009, 'Planetary Satellite Physical Parameters', http://ssd.jpl.nasa.gov/?sat_phys_par<br/>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Radius of U2 (Umbriel)", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A); see also D.K. Yeomans (NASA/JPL), 3 April 2009, 'Planetary Satellite Physical Parameters', http://ssd.jpl.nasa.gov/?sat_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "m") 
    public static final double MOONU2_RADIUS; static { MOONU2_RADIUS = 5.8470e+5; } // [m] 

    /**
     * Mean mass density of U2 (Umbriel)    
     * <p>
     * Status: CONF<br/>
     * Unit: g cm^-3<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean mass density of U2 (Umbriel)", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "g cm^-3") 
    public static final double MOONU2_MASSDENSITY_MEAN; static { MOONU2_MASSDENSITY_MEAN = 1.458; } // [g cm^-3] 

    /**
     * Post-Newtonian deflection angle of a limb-grazing light ray due to the spherically symmetric part of the gravitational field of U2 (Umbriel)    
     * <p>
     * Source: S.A. Klioner, 2003, 'A Practical Relativistic Model for Microarcsecond Astrometry in Space', AJ, 125, 1580, Equation 64 with cot(x) = cos(x) / sin(x) approximated by x^-1; see also J.H.J. de Bruijne, 19 February 2002, 'Gravitational light deflection', GAIA-JdB-001, issue 1, revision 0<br/>
     * Status: CONF<br/>
     * Unit: 10^-6 arcsec<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Post-Newtonian deflection angle of a limb-grazing light ray due to the spherically symmetric part of the gravitational field of U2 (Umbriel)", 
     source = "S.A. Klioner, 2003, 'A Practical Relativistic Model for Microarcsecond Astrometry in Space', AJ, 125, 1580, Equation 64 with cot(x) = cos(x) / sin(x) approximated by x^-1; see also J.H.J. de Bruijne, 19 February 2002, 'Gravitational light deflection', GAIA-JdB-001, issue 1, revision 0", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "10^-6 arcsec") 
    public static final double MOONU2_LIGHTDEFLECTION_LIMB; static { MOONU2_LIGHTDEFLECTION_LIMB = 1.; } // [10^-6 arcsec] 

    /**
     * Radius of the smallest hypothetical sphere around U3 (Titania) which would encompass the body (this is a low-accuracy parameter used in the relativistic model)    
     * <p>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Radius of the smallest hypothetical sphere around U3 (Titania) which would encompass the body (this is a low-accuracy parameter used in the relativistic model)", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m") 
    public static final double MOONU3_ENCOMPASSINGSPHERERADIUS; static { MOONU3_ENCOMPASSINGSPHERERADIUS = 7.8890e+5; } // [m] 

    /**
     * GM of U3 (Titania)    
     * <p>
     * Source: R.A. Jacobson, 2007, 'The Gravity Field of the Uranian System and the Orbits of the Uranian Satellites and Rings', BAAS, 39, 453; see also D.K. Yeomans (NASA/JPL), 3 April 2009, 'Planetary Satellite Physical Parameters', http://ssd.jpl.nasa.gov/?sat_phys_par<br/>
     * Status: CONF<br/>
     * Unit: m^3 s^-2<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "GM of U3 (Titania)", 
     source = "R.A. Jacobson, 2007, 'The Gravity Field of the Uranian System and the Orbits of the Uranian Satellites and Rings', BAAS, 39, 453; see also D.K. Yeomans (NASA/JPL), 3 April 2009, 'Planetary Satellite Physical Parameters', http://ssd.jpl.nasa.gov/?sat_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "m^3 s^-2") 
    public static final double MOONU3_GM; static { MOONU3_GM = 2.2820e+11; } // [m^3 s^-2] 

    /**
     * Radius of U3 (Titania)    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A); see also D.K. Yeomans (NASA/JPL), 3 April 2009, 'Planetary Satellite Physical Parameters', http://ssd.jpl.nasa.gov/?sat_phys_par<br/>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Radius of U3 (Titania)", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A); see also D.K. Yeomans (NASA/JPL), 3 April 2009, 'Planetary Satellite Physical Parameters', http://ssd.jpl.nasa.gov/?sat_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "m") 
    public static final double MOONU3_RADIUS; static { MOONU3_RADIUS = 7.8890e+5; } // [m] 

    /**
     * Mean mass density of U3 (Titania)    
     * <p>
     * Status: CONF<br/>
     * Unit: g cm^-3<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean mass density of U3 (Titania)", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "g cm^-3") 
    public static final double MOONU3_MASSDENSITY_MEAN; static { MOONU3_MASSDENSITY_MEAN = 1.663; } // [g cm^-3] 

    /**
     * Post-Newtonian deflection angle of a limb-grazing light ray due to the spherically symmetric part of the gravitational field of U3 (Titania)    
     * <p>
     * Source: S.A. Klioner, 2003, 'A Practical Relativistic Model for Microarcsecond Astrometry in Space', AJ, 125, 1580, Equation 64 with cot(x) = cos(x) / sin(x) approximated by x^-1; see also J.H.J. de Bruijne, 19 February 2002, 'Gravitational light deflection', GAIA-JdB-001, issue 1, revision 0<br/>
     * Status: CONF<br/>
     * Unit: 10^-6 arcsec<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Post-Newtonian deflection angle of a limb-grazing light ray due to the spherically symmetric part of the gravitational field of U3 (Titania)", 
     source = "S.A. Klioner, 2003, 'A Practical Relativistic Model for Microarcsecond Astrometry in Space', AJ, 125, 1580, Equation 64 with cot(x) = cos(x) / sin(x) approximated by x^-1; see also J.H.J. de Bruijne, 19 February 2002, 'Gravitational light deflection', GAIA-JdB-001, issue 1, revision 0", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "10^-6 arcsec") 
    public static final double MOONU3_LIGHTDEFLECTION_LIMB; static { MOONU3_LIGHTDEFLECTION_LIMB = 3.; } // [10^-6 arcsec] 

    /**
     * Radius of the smallest hypothetical sphere around U4 (Oberon) which would encompass the body (this is a low-accuracy parameter used in the relativistic model)    
     * <p>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Radius of the smallest hypothetical sphere around U4 (Oberon) which would encompass the body (this is a low-accuracy parameter used in the relativistic model)", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m") 
    public static final double MOONU4_ENCOMPASSINGSPHERERADIUS; static { MOONU4_ENCOMPASSINGSPHERERADIUS = 7.6140e+5; } // [m] 

    /**
     * GM of U4 (Oberon)    
     * <p>
     * Source: R.A. Jacobson, 2007, 'The Gravity Field of the Uranian System and the Orbits of the Uranian Satellites and Rings', BAAS, 39, 453; see also D.K. Yeomans (NASA/JPL), 3 April 2009, 'Planetary Satellite Physical Parameters', http://ssd.jpl.nasa.gov/?sat_phys_par<br/>
     * Status: CONF<br/>
     * Unit: m^3 s^-2<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "GM of U4 (Oberon)", 
     source = "R.A. Jacobson, 2007, 'The Gravity Field of the Uranian System and the Orbits of the Uranian Satellites and Rings', BAAS, 39, 453; see also D.K. Yeomans (NASA/JPL), 3 April 2009, 'Planetary Satellite Physical Parameters', http://ssd.jpl.nasa.gov/?sat_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "m^3 s^-2") 
    public static final double MOONU4_GM; static { MOONU4_GM = 1.9240e+11; } // [m^3 s^-2] 

    /**
     * Radius of U4 (Oberon)    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A); see also D.K. Yeomans (NASA/JPL), 3 April 2009, 'Planetary Satellite Physical Parameters', http://ssd.jpl.nasa.gov/?sat_phys_par<br/>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Radius of U4 (Oberon)", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A); see also D.K. Yeomans (NASA/JPL), 3 April 2009, 'Planetary Satellite Physical Parameters', http://ssd.jpl.nasa.gov/?sat_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "m") 
    public static final double MOONU4_RADIUS; static { MOONU4_RADIUS = 7.6140e+5; } // [m] 

    /**
     * Mean mass density of U4 (Oberon)    
     * <p>
     * Status: CONF<br/>
     * Unit: g cm^-3<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean mass density of U4 (Oberon)", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "g cm^-3") 
    public static final double MOONU4_MASSDENSITY_MEAN; static { MOONU4_MASSDENSITY_MEAN = 1.559; } // [g cm^-3] 

    /**
     * Post-Newtonian deflection angle of a limb-grazing light ray due to the spherically symmetric part of the gravitational field of U4 (Oberon)    
     * <p>
     * Source: S.A. Klioner, 2003, 'A Practical Relativistic Model for Microarcsecond Astrometry in Space', AJ, 125, 1580, Equation 64 with cot(x) = cos(x) / sin(x) approximated by x^-1; see also J.H.J. de Bruijne, 19 February 2002, 'Gravitational light deflection', GAIA-JdB-001, issue 1, revision 0<br/>
     * Status: CONF<br/>
     * Unit: 10^-6 arcsec<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Post-Newtonian deflection angle of a limb-grazing light ray due to the spherically symmetric part of the gravitational field of U4 (Oberon)", 
     source = "S.A. Klioner, 2003, 'A Practical Relativistic Model for Microarcsecond Astrometry in Space', AJ, 125, 1580, Equation 64 with cot(x) = cos(x) / sin(x) approximated by x^-1; see also J.H.J. de Bruijne, 19 February 2002, 'Gravitational light deflection', GAIA-JdB-001, issue 1, revision 0", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "10^-6 arcsec") 
    public static final double MOONU4_LIGHTDEFLECTION_LIMB; static { MOONU4_LIGHTDEFLECTION_LIMB = 2.; } // [10^-6 arcsec] 

    /**
     * Napier's constant (also known as Neper's constant), i.e., base of the natural logarithm. Although the symbol 'e' refers to Euler, the Napier constant should not be confused with the Euler(-Mascheroni) constant \gamma = 0.5772156649... Note that double-precision, floating-point numbers in any programming language which follows the IEEE standard (true for C, C++, Java, and most, if not all, others) have only 16 significant digits (64 bits); the representation here, using 30 significant digits, is thus amply sufficient    
     * <p>
     * Source: Well-known mathematical constant; numerical value can be extracted, e.g., from Mathematica 4.0 for Solaris (Wolfram Research, Inc.) using 'N[Exp[1],30]'<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Napier's constant (also known as Neper's constant), i.e., base of the natural logarithm. Although the symbol 'e' refers to Euler, the Napier constant should not be confused with the Euler(-Mascheroni) constant \\gamma = 0.5772156649... Note that double-precision, floating-point numbers in any programming language which follows the IEEE standard (true for C, C++, Java, and most, if not all, others) have only 16 significant digits (64 bits); the representation here, using 30 significant digits, is thus amply sufficient", 
     source = "Well-known mathematical constant; numerical value can be extracted, e.g., from Mathematica 4.0 for Solaris (Wolfram Research, Inc.) using 'N[Exp[1],30]'", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double NAPIER_CONSTANT; static { NAPIER_CONSTANT = 2.71828182845904523536028747135; } 

    /**
     * Diameter of near-Earth asteroid 1036 Ganymed    
     * <p>
     * Source: C.F. Yoder, 1995, 'Astrometric and Geodetic Properties of Earth and the solar System', in 'Global Earth Physics; A Handbook of Physical Constants', AGU Reference Shelf 1, American Geophysical Union, Table 16 'Prominent Aten-, Apollo-, and Amor-class near-Earth asteroids with well-determined orbits and V(1,0) < 18 mag' (http://www.agu.org/books/rf/v001/RF001p0001/RF001p0001.pdf)<br/>
     * Status: CONF<br/>
     * Unit: km<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Diameter of near-Earth asteroid 1036 Ganymed", 
     source = "C.F. Yoder, 1995, 'Astrometric and Geodetic Properties of Earth and the solar System', in 'Global Earth Physics; A Handbook of Physical Constants', AGU Reference Shelf 1, American Geophysical Union, Table 16 'Prominent Aten-, Apollo-, and Amor-class near-Earth asteroids with well-determined orbits and V(1,0) < 18 mag' (http://www.agu.org/books/rf/v001/RF001p0001/RF001p0001.pdf)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "km") 
    public static final double NEAREARTHASTEROID1036GANYMED_DIAMETER; static { NEAREARTHASTEROID1036GANYMED_DIAMETER = 38.5; } // [km] 

    /**
     * Diameter of near-Earth asteroid 1580 Betulia    
     * <p>
     * Source: C.F. Yoder, 1995, 'Astrometric and Geodetic Properties of Earth and the solar System', in 'Global Earth Physics; A Handbook of Physical Constants', AGU Reference Shelf 1, American Geophysical Union, Table 16 'Prominent Aten-, Apollo-, and Amor-class near-Earth asteroids with well-determined orbits and V(1,0) < 18 mag' (http://www.agu.org/books/rf/v001/RF001p0001/RF001p0001.pdf)<br/>
     * Status: CONF<br/>
     * Unit: km<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Diameter of near-Earth asteroid 1580 Betulia", 
     source = "C.F. Yoder, 1995, 'Astrometric and Geodetic Properties of Earth and the solar System', in 'Global Earth Physics; A Handbook of Physical Constants', AGU Reference Shelf 1, American Geophysical Union, Table 16 'Prominent Aten-, Apollo-, and Amor-class near-Earth asteroids with well-determined orbits and V(1,0) < 18 mag' (http://www.agu.org/books/rf/v001/RF001p0001/RF001p0001.pdf)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "km") 
    public static final double NEAREARTHASTEROID1580BETULIA_DIAMETER; static { NEAREARTHASTEROID1580BETULIA_DIAMETER = 7.4; } // [km] 

    /**
     * Diameter of near-Earth asteroid 1627 Ivar    
     * <p>
     * Source: C.F. Yoder, 1995, 'Astrometric and Geodetic Properties of Earth and the solar System', in 'Global Earth Physics; A Handbook of Physical Constants', AGU Reference Shelf 1, American Geophysical Union, Table 16 'Prominent Aten-, Apollo-, and Amor-class near-Earth asteroids with well-determined orbits and V(1,0) < 18 mag' (http://www.agu.org/books/rf/v001/RF001p0001/RF001p0001.pdf)<br/>
     * Status: CONF<br/>
     * Unit: km<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Diameter of near-Earth asteroid 1627 Ivar", 
     source = "C.F. Yoder, 1995, 'Astrometric and Geodetic Properties of Earth and the solar System', in 'Global Earth Physics; A Handbook of Physical Constants', AGU Reference Shelf 1, American Geophysical Union, Table 16 'Prominent Aten-, Apollo-, and Amor-class near-Earth asteroids with well-determined orbits and V(1,0) < 18 mag' (http://www.agu.org/books/rf/v001/RF001p0001/RF001p0001.pdf)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "km") 
    public static final double NEAREARTHASTEROID1627IVAR_DIAMETER; static { NEAREARTHASTEROID1627IVAR_DIAMETER = 8.1; } // [km] 

    /**
     * Diameter of near-Earth asteroid 1685 Toro    
     * <p>
     * Source: C.F. Yoder, 1995, 'Astrometric and Geodetic Properties of Earth and the solar System', in 'Global Earth Physics; A Handbook of Physical Constants', AGU Reference Shelf 1, American Geophysical Union, Table 16 'Prominent Aten-, Apollo-, and Amor-class near-Earth asteroids with well-determined orbits and V(1,0) < 18 mag' (http://www.agu.org/books/rf/v001/RF001p0001/RF001p0001.pdf)<br/>
     * Status: CONF<br/>
     * Unit: km<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Diameter of near-Earth asteroid 1685 Toro", 
     source = "C.F. Yoder, 1995, 'Astrometric and Geodetic Properties of Earth and the solar System', in 'Global Earth Physics; A Handbook of Physical Constants', AGU Reference Shelf 1, American Geophysical Union, Table 16 'Prominent Aten-, Apollo-, and Amor-class near-Earth asteroids with well-determined orbits and V(1,0) < 18 mag' (http://www.agu.org/books/rf/v001/RF001p0001/RF001p0001.pdf)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "km") 
    public static final double NEAREARTHASTEROID1685TORO_DIAMETER; static { NEAREARTHASTEROID1685TORO_DIAMETER = 5.2; } // [km] 

    /**
     * Diameter of near-Earth asteroid 1866 Sisyphus    
     * <p>
     * Source: C.F. Yoder, 1995, 'Astrometric and Geodetic Properties of Earth and the solar System', in 'Global Earth Physics; A Handbook of Physical Constants', AGU Reference Shelf 1, American Geophysical Union, Table 16 'Prominent Aten-, Apollo-, and Amor-class near-Earth asteroids with well-determined orbits and V(1,0) < 18 mag' (http://www.agu.org/books/rf/v001/RF001p0001/RF001p0001.pdf)<br/>
     * Status: CONF<br/>
     * Unit: km<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Diameter of near-Earth asteroid 1866 Sisyphus", 
     source = "C.F. Yoder, 1995, 'Astrometric and Geodetic Properties of Earth and the solar System', in 'Global Earth Physics; A Handbook of Physical Constants', AGU Reference Shelf 1, American Geophysical Union, Table 16 'Prominent Aten-, Apollo-, and Amor-class near-Earth asteroids with well-determined orbits and V(1,0) < 18 mag' (http://www.agu.org/books/rf/v001/RF001p0001/RF001p0001.pdf)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "km") 
    public static final double NEAREARTHASTEROID1866SISYPHUS_DIAMETER; static { NEAREARTHASTEROID1866SISYPHUS_DIAMETER = 8.2; } // [km] 

    /**
     * Diameter of near-Earth asteroid 3200 Phaeton    
     * <p>
     * Source: C.F. Yoder, 1995, 'Astrometric and Geodetic Properties of Earth and the solar System', in 'Global Earth Physics; A Handbook of Physical Constants', AGU Reference Shelf 1, American Geophysical Union, Table 16 'Prominent Aten-, Apollo-, and Amor-class near-Earth asteroids with well-determined orbits and V(1,0) < 18 mag' (http://www.agu.org/books/rf/v001/RF001p0001/RF001p0001.pdf)<br/>
     * Status: CONF<br/>
     * Unit: km<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Diameter of near-Earth asteroid 3200 Phaeton", 
     source = "C.F. Yoder, 1995, 'Astrometric and Geodetic Properties of Earth and the solar System', in 'Global Earth Physics; A Handbook of Physical Constants', AGU Reference Shelf 1, American Geophysical Union, Table 16 'Prominent Aten-, Apollo-, and Amor-class near-Earth asteroids with well-determined orbits and V(1,0) < 18 mag' (http://www.agu.org/books/rf/v001/RF001p0001/RF001p0001.pdf)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "km") 
    public static final double NEAREARTHASTEROID3200PHAETON_DIAMETER; static { NEAREARTHASTEROID3200PHAETON_DIAMETER = 6.9; } // [km] 

    /**
     * Diameter of near-Earth asteroid 3552 Don Quixote    
     * <p>
     * Source: C.F. Yoder, 1995, 'Astrometric and Geodetic Properties of Earth and the solar System', in 'Global Earth Physics; A Handbook of Physical Constants', AGU Reference Shelf 1, American Geophysical Union, Table 16 'Prominent Aten-, Apollo-, and Amor-class near-Earth asteroids with well-determined orbits and V(1,0) < 18 mag' (http://www.agu.org/books/rf/v001/RF001p0001/RF001p0001.pdf)<br/>
     * Status: CONF<br/>
     * Unit: km<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Diameter of near-Earth asteroid 3552 Don Quixote", 
     source = "C.F. Yoder, 1995, 'Astrometric and Geodetic Properties of Earth and the solar System', in 'Global Earth Physics; A Handbook of Physical Constants', AGU Reference Shelf 1, American Geophysical Union, Table 16 'Prominent Aten-, Apollo-, and Amor-class near-Earth asteroids with well-determined orbits and V(1,0) < 18 mag' (http://www.agu.org/books/rf/v001/RF001p0001/RF001p0001.pdf)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "km") 
    public static final double NEAREARTHASTEROID3552DONQUIXOTE_DIAMETER; static { NEAREARTHASTEROID3552DONQUIXOTE_DIAMETER = 18.7; } // [km] 

    /**
     * Diameter of near-Earth asteroid 433 Eros    
     * <p>
     * Source: C.F. Yoder, 1995, 'Astrometric and Geodetic Properties of Earth and the solar System', in 'Global Earth Physics; A Handbook of Physical Constants', AGU Reference Shelf 1, American Geophysical Union, Table 16 'Prominent Aten-, Apollo-, and Amor-class near-Earth asteroids with well-determined orbits and V(1,0) < 18 mag' (http://www.agu.org/books/rf/v001/RF001p0001/RF001p0001.pdf)<br/>
     * Status: CONF<br/>
     * Unit: km<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Diameter of near-Earth asteroid 433 Eros", 
     source = "C.F. Yoder, 1995, 'Astrometric and Geodetic Properties of Earth and the solar System', in 'Global Earth Physics; A Handbook of Physical Constants', AGU Reference Shelf 1, American Geophysical Union, Table 16 'Prominent Aten-, Apollo-, and Amor-class near-Earth asteroids with well-determined orbits and V(1,0) < 18 mag' (http://www.agu.org/books/rf/v001/RF001p0001/RF001p0001.pdf)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "km") 
    public static final double NEAREARTHASTEROID433EROS_DIAMETER; static { NEAREARTHASTEROID433EROS_DIAMETER = 22.; } // [km] 

    /**
     * The velocity distribution of near-Earth objects (NEOs) is approximately Gaussian with zero mean and a standard deviation of 22.5 mas s^-1 along-scan (for a solar-aspect angle of 45 degrees)    
     * <p>
     * Source: F. Mignard, 2002, 'Observations of solar-system objects with Gaia. I. Detection of NEOs', A&A, 393, 727, Section 4.4 (2002A&A...393..727M). See also E. Hoeg, F. Arenou, P. Hjorth, U.G. Joergensen, F. Mignard, S. Wolff, 28 February 2003, 'Faint objects and NEOs with Gaia', GAIA-CUO-118, issue 1, revision 0. Current value, for a solar-aspect angle of 45 degrees, from F. Mignard, priv. comm., 10 August 2005<br/>
     * Status: CONF<br/>
     * Unit: mas s^-1<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "The velocity distribution of near-Earth objects (NEOs) is approximately Gaussian with zero mean and a standard deviation of 22.5 mas s^-1 along-scan (for a solar-aspect angle of 45 degrees)", 
     source = "F. Mignard, 2002, 'Observations of solar-system objects with Gaia. I. Detection of NEOs', A&A, 393, 727, Section 4.4 (2002A&A...393..727M). See also E. Hoeg, F. Arenou, P. Hjorth, U.G. Joergensen, F. Mignard, S. Wolff, 28 February 2003, 'Faint objects and NEOs with Gaia', GAIA-CUO-118, issue 1, revision 0. Current value, for a solar-aspect angle of 45 degrees, from F. Mignard, priv. comm., 10 August 2005", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "mas s^-1") 
    public static final double NEAREARTHOBJECT_VELOCITYDISTRIBUTIONSTANDARDDEVIATION_AL; static { NEAREARTHOBJECT_VELOCITYDISTRIBUTIONSTANDARDDEVIATION_AL = 22.5; } // [mas s^-1] 

    /**
     * The velocity distribution of near-Earth objects (NEOs) is approximately Gaussian with zero mean and a standard deviation of 30.0 mas s^-1 across-scan (for a solar-aspect angle of 45 degrees)    
     * <p>
     * Source: F. Mignard, 2002, 'Observations of solar-system objects with Gaia. I. Detection of NEOs', A&A, 393, 727, Section 4.4 (2002A&A...393..727M). See also E. Hoeg, F. Arenou, P. Hjorth, U.G. Joergensen, F. Mignard, S. Wolff, 28 February 2003, 'Faint objects and NEOs with Gaia', GAIA-CUO-118, issue 1, revision 0. Current value, for a solar-aspect angle of 45 degrees, from F. Mignard, priv. comm., 10 August 2005<br/>
     * Status: CONF<br/>
     * Unit: mas s^-1<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "The velocity distribution of near-Earth objects (NEOs) is approximately Gaussian with zero mean and a standard deviation of 30.0 mas s^-1 across-scan (for a solar-aspect angle of 45 degrees)", 
     source = "F. Mignard, 2002, 'Observations of solar-system objects with Gaia. I. Detection of NEOs', A&A, 393, 727, Section 4.4 (2002A&A...393..727M). See also E. Hoeg, F. Arenou, P. Hjorth, U.G. Joergensen, F. Mignard, S. Wolff, 28 February 2003, 'Faint objects and NEOs with Gaia', GAIA-CUO-118, issue 1, revision 0. Current value, for a solar-aspect angle of 45 degrees, from F. Mignard, priv. comm., 10 August 2005", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "mas s^-1") 
    public static final double NEAREARTHOBJECT_VELOCITYDISTRIBUTIONSTANDARDDEVIATION_AC; static { NEAREARTHOBJECT_VELOCITYDISTRIBUTIONSTANDARDDEVIATION_AC = 30.0; } // [mas s^-1] 

    /**
     * Chebyshev representation of the ephemerides of Neptune, with origin at the barycentre of the solar system (BCRS), in the equatorial ICRF frame. The ephemeris covers the period starting on JD (JDBEGIP + JDBEGFP) and ending on JD (JDENDIP + JDENDFP) for the position and starting on JD (JDBEGIV + JDBEGFV) and ending on JD (JDENDIV + JDENDFV) for the velocity. A number of Chebyshev coefficients equal to ORDERSP is given for NSSP time intervals of SPANSP days to describe the position-vector components in units of m; the similar parameters ending with PP (Peculiar Position) are not used in the current release and are reserved for future usage. A number of Chebyshev coefficients equal to ORDERSV is given for NSSV time intervals of SPANSV days to describe the velocity-vector components in units of m s^-1; the similar parameters ending with PV (Peculiar Velocity) are not used in the current release and are reserved for future usage. The first three HDUs contain the coefficients for the three components of the position, while the last three HDUs contain the coefficients for the three components of the velocity    
     * <p>
     * Source: A. Fienga, J. Laskar, H. Manche, M. Gastineau, 19 April 2007, 'Solar system planetary ephemeris delivery: INPOP06', GAIA-CA-TN-IMC-AF-001, issue 1, revision 0<br/>
     * Status: DEPR<br/>
     * Basic : true<br/>
     * Scalar: false
     */
    @ParamMetaData (
    description = "Chebyshev representation of the ephemerides of Neptune, with origin at the barycentre of the solar system (BCRS), in the equatorial ICRF frame. The ephemeris covers the period starting on JD (JDBEGIP + JDBEGFP) and ending on JD (JDENDIP + JDENDFP) for the position and starting on JD (JDBEGIV + JDBEGFV) and ending on JD (JDENDIV + JDENDFV) for the velocity. A number of Chebyshev coefficients equal to ORDERSP is given for NSSP time intervals of SPANSP days to describe the position-vector components in units of m; the similar parameters ending with PP (Peculiar Position) are not used in the current release and are reserved for future usage. A number of Chebyshev coefficients equal to ORDERSV is given for NSSV time intervals of SPANSV days to describe the velocity-vector components in units of m s^-1; the similar parameters ending with PV (Peculiar Velocity) are not used in the current release and are reserved for future usage. The first three HDUs contain the coefficients for the three components of the position, while the last three HDUs contain the coefficients for the three components of the velocity", 
     source = "A. Fienga, J. Laskar, H. Manche, M. Gastineau, 19 April 2007, 'Solar system planetary ephemeris delivery: INPOP06', GAIA-CA-TN-IMC-AF-001, issue 1, revision 0", 
     status = "DEPR", 
     basic = true, 
     scalar = false, 
     unit = "") 
    public static final String NEPTUNE_EPHEMERIS; static { NEPTUNE_EPHEMERIS = "Nature/Neptune_Ephemeris_004.fits"; } 

    /**
     * IAU-recommended value for the right ascension \alpha_0 of the north pole of rotation of Neptune. The pair (\alpha_0, \delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \alpha_0 = 273.85 deg and \delta_0 = 66.99 degrees. The numerical value is based on an approximate formula, accurate to first order in 'd' (see below); the true equation is \alpha_0 = 299.36 + 0.70 * sin(357.85 + 52.316 * d / 36525), where d is the number of Julian days calculated from the standard epoch. The numerical accuracy of this equation is 0.1 deg    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)<br/>
     * Status: CONF<br/>
     * Unit: deg<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "IAU-recommended value for the right ascension \\alpha_0 of the north pole of rotation of Neptune. The pair (\\alpha_0, \\delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \\alpha_0 = 273.85 deg and \\delta_0 = 66.99 degrees. The numerical value is based on an approximate formula, accurate to first order in 'd' (see below); the true equation is \\alpha_0 = 299.36 + 0.70 * sin(357.85 + 52.316 * d / 36525), where d is the number of Julian days calculated from the standard epoch. The numerical accuracy of this equation is 0.1 deg", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "deg") 
    public static final double NEPTUNE_NORTHROTATIONALPOLE_RIGHTASCENSION; static { NEPTUNE_NORTHROTATIONALPOLE_RIGHTASCENSION = 299.334; } // [deg] 

    /**
     * IAU-recommended value for the rate of change (in degrees per Julian day, calculated from the standard epoch) of the right ascension \alpha_0 of the north pole of rotation of Neptune. The pair (\alpha_0, \delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \alpha_0 = 273.85 deg and \delta_0 = 66.99 degrees. The numerical value is based on an approximate formula, accurate to first order in 'd' (see below); the true equation is \alpha_0 = 299.36 + 0.70 * sin(357.85 + 52.316 * d / 36525), where d is the number of Julian days calculated from the standard epoch. The numerical accuracy of this equation is 0.1 deg    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)<br/>
     * Status: CONF<br/>
     * Unit: deg day^-1<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "IAU-recommended value for the rate of change (in degrees per Julian day, calculated from the standard epoch) of the right ascension \\alpha_0 of the north pole of rotation of Neptune. The pair (\\alpha_0, \\delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \\alpha_0 = 273.85 deg and \\delta_0 = 66.99 degrees. The numerical value is based on an approximate formula, accurate to first order in 'd' (see below); the true equation is \\alpha_0 = 299.36 + 0.70 * sin(357.85 + 52.316 * d / 36525), where d is the number of Julian days calculated from the standard epoch. The numerical accuracy of this equation is 0.1 deg", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "deg day^-1") 
    public static final double NEPTUNE_NORTHROTATIONALPOLE_RIGHTASCENSIONRATEOFCHANGE; static { NEPTUNE_NORTHROTATIONALPOLE_RIGHTASCENSIONRATEOFCHANGE = 0.0000174869; } // [deg day^-1] 

    /**
     * IAU-recommended value for the declination \delta_0 of the north pole of rotation of Neptune. The pair (\alpha_0, \delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \alpha_0 = 273.85 deg and \delta_0 = 66.99 degrees. The numerical value is based on an approximate formula, accurate to first order in 'd' (see below); the true equation is \delta_0 = 43.46 - 0.51 * cos(357.85 + 52.316 * d / 36525), where d is the number of Julian days calculated from the standard epoch. The numerical accuracy of this equation is 0.1 deg    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)<br/>
     * Status: CONF<br/>
     * Unit: deg<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "IAU-recommended value for the declination \\delta_0 of the north pole of rotation of Neptune. The pair (\\alpha_0, \\delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \\alpha_0 = 273.85 deg and \\delta_0 = 66.99 degrees. The numerical value is based on an approximate formula, accurate to first order in 'd' (see below); the true equation is \\delta_0 = 43.46 - 0.51 * cos(357.85 + 52.316 * d / 36525), where d is the number of Julian days calculated from the standard epoch. The numerical accuracy of this equation is 0.1 deg", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "deg") 
    public static final double NEPTUNE_NORTHROTATIONALPOLE_DECLINATION; static { NEPTUNE_NORTHROTATIONALPOLE_DECLINATION = 42.950; } // [deg] 

    /**
     * IAU-recommended value for the rate of change (in degrees per Julian day, calculated from the standard epoch) of the declination \delta_0 of the north pole of rotation of Neptune. The pair (\alpha_0, \delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \alpha_0 = 273.85 deg and \delta_0 = 66.99 degrees. The numerical value is based on an approximate formula, accurate to first order in 'd' (see below); the true equation is \delta_0 = 43.46 - 0.51 * cos(357.85 + 52.316 * d / 36525), where d is the number of Julian days calculated from the standard epoch. The numerical accuracy of this equation is 0.1 deg    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)<br/>
     * Status: CONF<br/>
     * Unit: deg day^-1<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "IAU-recommended value for the rate of change (in degrees per Julian day, calculated from the standard epoch) of the declination \\delta_0 of the north pole of rotation of Neptune. The pair (\\alpha_0, \\delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \\alpha_0 = 273.85 deg and \\delta_0 = 66.99 degrees. The numerical value is based on an approximate formula, accurate to first order in 'd' (see below); the true equation is \\delta_0 = 43.46 - 0.51 * cos(357.85 + 52.316 * d / 36525), where d is the number of Julian days calculated from the standard epoch. The numerical accuracy of this equation is 0.1 deg", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "deg day^-1") 
    public static final double NEPTUNE_NORTHROTATIONALPOLE_DECLINATIONRATEOFCHANGE; static { NEPTUNE_NORTHROTATIONALPOLE_DECLINATIONRATEOFCHANGE = -0.0000004783; } // [deg day^-1] 

    /**
     * IAU-recommended value for the ephemeris position of the prime meridian of Neptune. The prime meridian refers to the rotation of the magnetic field System III. The location of the prime meridian is specified by the angle that is measured along the planet's equator in an easterly direction with respect to the planet's north pole from the node Q (located at right ascension 90 deg + \alpha_0, where \alpha_0 denotes the right ascension of the north pole of rotation) of the planet's equator on the standard equator to the point B where the prime meridian crosses the planet's equator. The right ascension of the point Q is 90 deg + \alpha_0 and the inclination of the planet's equator to the standard equator is 90 deg - \delta_0, where \delta_0 denotes the declination of the north pole of rotation. (The pair (\alpha_0, \delta_0) denotes the standard equatorial coordinates, with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB), of the north pole of rotation, which itself is defined as that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \alpha_0 = 273.85 deg and \delta_0 = 66.99 degrees.) Because the prime meridian is assumed to rotate uniformly with the planet, W accordingly varies linearly with time. In addition, \alpha_0, \delta_0, and W may vary with time due to a precession of the axis of rotation of the planet. If W increases with time, the planet has a direct (or prograde) rotation; if W decreases with time, the rotation is said to be retrograde. The numerical value is based on an approximate formula, accurate to first order in 'd' (see below); the true equation is W = 253.18 + 536.3128492 * d - 0.48 * sin(357.85 + 52.316 * d / 36525), where d is the number of Julian days calculated from the standard epoch. The numerical accuracy of this equation is 0.1 deg    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)<br/>
     * Status: CONF<br/>
     * Unit: deg<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "IAU-recommended value for the ephemeris position of the prime meridian of Neptune. The prime meridian refers to the rotation of the magnetic field System III. The location of the prime meridian is specified by the angle that is measured along the planet's equator in an easterly direction with respect to the planet's north pole from the node Q (located at right ascension 90 deg + \\alpha_0, where \\alpha_0 denotes the right ascension of the north pole of rotation) of the planet's equator on the standard equator to the point B where the prime meridian crosses the planet's equator. The right ascension of the point Q is 90 deg + \\alpha_0 and the inclination of the planet's equator to the standard equator is 90 deg - \\delta_0, where \\delta_0 denotes the declination of the north pole of rotation. (The pair (\\alpha_0, \\delta_0) denotes the standard equatorial coordinates, with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB), of the north pole of rotation, which itself is defined as that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \\alpha_0 = 273.85 deg and \\delta_0 = 66.99 degrees.) Because the prime meridian is assumed to rotate uniformly with the planet, W accordingly varies linearly with time. In addition, \\alpha_0, \\delta_0, and W may vary with time due to a precession of the axis of rotation of the planet. If W increases with time, the planet has a direct (or prograde) rotation; if W decreases with time, the rotation is said to be retrograde. The numerical value is based on an approximate formula, accurate to first order in 'd' (see below); the true equation is W = 253.18 + 536.3128492 * d - 0.48 * sin(357.85 + 52.316 * d / 36525), where d is the number of Julian days calculated from the standard epoch. The numerical accuracy of this equation is 0.1 deg", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "deg") 
    public static final double NEPTUNE_PRIMEMERIDIAN_EPHEMERISPOSITION; static { NEPTUNE_PRIMEMERIDIAN_EPHEMERISPOSITION = 253.198; } // [deg] 

    /**
     * IAU-recommended value for the rate of change (in degrees per Julian day, calculated from the standard epoch of 1.5 January 2000 = JD2451545.0 TDB) of the ephemeris position of the prime meridian of Neptune. The prime meridian refers to the rotation of the magnetic field System III. The location of the prime meridian is specified by the angle that is measured along the planet's equator in an easterly direction with respect to the planet's north pole from the node Q (located at right ascension 90 deg + \alpha_0, where \alpha_0 denotes the right ascension of the north pole of rotation) of the planet's equator on the standard equator to the point B where the prime meridian crosses the planet's equator. The right ascension of the point Q is 90 deg + \alpha_0 and the inclination of the planet's equator to the standard equator is 90 deg - \delta_0, where \delta_0 denotes the declination of the north pole of rotation. (The pair (\alpha_0, \delta_0) denotes the standard equatorial coordinates, with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB), of the north pole of rotation, which itself is defined as that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \alpha_0 = 273.85 deg and \delta_0 = 66.99 degrees.) Because the prime meridian is assumed to rotate uniformly with the planet, W accordingly varies linearly with time. In addition, \alpha_0, \delta_0, and W may vary with time due to a precession of the axis of rotation of the planet. If W increases with time, the planet has a direct (or prograde) rotation; if W decreases with time, the rotation is said to be retrograde. The numerical value is based on an approximate formula, accurate to first order in 'd' (see below); the true equation is W = 253.18 + 536.3128492 * d - 0.48 * sin(357.85 + 52.316 * d / 36525), where d is the number of Julian days calculated from the standard epoch. The numerical accuracy of this equation is 0.1 deg    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)<br/>
     * Status: CONF<br/>
     * Unit: deg day^-1<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "IAU-recommended value for the rate of change (in degrees per Julian day, calculated from the standard epoch of 1.5 January 2000 = JD2451545.0 TDB) of the ephemeris position of the prime meridian of Neptune. The prime meridian refers to the rotation of the magnetic field System III. The location of the prime meridian is specified by the angle that is measured along the planet's equator in an easterly direction with respect to the planet's north pole from the node Q (located at right ascension 90 deg + \\alpha_0, where \\alpha_0 denotes the right ascension of the north pole of rotation) of the planet's equator on the standard equator to the point B where the prime meridian crosses the planet's equator. The right ascension of the point Q is 90 deg + \\alpha_0 and the inclination of the planet's equator to the standard equator is 90 deg - \\delta_0, where \\delta_0 denotes the declination of the north pole of rotation. (The pair (\\alpha_0, \\delta_0) denotes the standard equatorial coordinates, with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB), of the north pole of rotation, which itself is defined as that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \\alpha_0 = 273.85 deg and \\delta_0 = 66.99 degrees.) Because the prime meridian is assumed to rotate uniformly with the planet, W accordingly varies linearly with time. In addition, \\alpha_0, \\delta_0, and W may vary with time due to a precession of the axis of rotation of the planet. If W increases with time, the planet has a direct (or prograde) rotation; if W decreases with time, the rotation is said to be retrograde. The numerical value is based on an approximate formula, accurate to first order in 'd' (see below); the true equation is W = 253.18 + 536.3128492 * d - 0.48 * sin(357.85 + 52.316 * d / 36525), where d is the number of Julian days calculated from the standard epoch. The numerical accuracy of this equation is 0.1 deg", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "deg day^-1") 
    public static final double NEPTUNE_PRIMEMERIDIAN_EPHEMERISPOSITIONRATEOFCHANGE; static { NEPTUNE_PRIMEMERIDIAN_EPHEMERISPOSITIONRATEOFCHANGE = 536.3128372090; } // [deg day^-1] 

    /**
     * Mass of Neptune (do not use for high-precision (orbit) calculations)    
     * <p>
     * Source: R.A. Jacobson, 2008, 'The orbits of the Neptunian satellites and the orientation of the pole of Neptune', BAAS, 40, 296; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par<br/>
     * Status: CONF<br/>
     * Unit: kg<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mass of Neptune (do not use for high-precision (orbit) calculations)", 
     source = "R.A. Jacobson, 2008, 'The orbits of the Neptunian satellites and the orientation of the pole of Neptune', BAAS, 40, 296; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "kg") 
    public static final double NEPTUNE_MASS; static { NEPTUNE_MASS = 1.024100e+26; } // [kg] 

    /**
     * Mean volumetric radius of Neptune    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A); see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par<br/>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean volumetric radius of Neptune", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A); see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "m") 
    public static final double NEPTUNE_VOLUMETRICRADIUS; static { NEPTUNE_VOLUMETRICRADIUS = 2.46220e+7; } // [m] 

    /**
     * Equatorial radius of Neptune    
     * <p>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Equatorial radius of Neptune", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m") 
    public static final double NEPTUNE_EQUATORIALRADIUS; static { NEPTUNE_EQUATORIALRADIUS = 2.47640e+7; } // [m] 

    /**
     * Polar radius of Neptune    
     * <p>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Polar radius of Neptune", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m") 
    public static final double NEPTUNE_POLARRADIUS; static { NEPTUNE_POLARRADIUS = 2.43405e+7; } // [m] 

    /**
     * V(1,0) magnitude of Neptune (i.e., the visual magnitude of the planet reduced to a distance of 1 au from both the Sun and Earth and phase angle zero). This parameter is also refered to as absolute magnitude in planetary sciences    
     * <p>
     * Source: P.K. Seidelmann, 1992, 'Explanatory Supplement to the Astronomical Almanac', University Science Books, Mill Valley, Ca., ISBN 0-935702-68-7, Table 15.8 on page 706; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par<br/>
     * Status: CONF<br/>
     * Unit: mag<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "V(1,0) magnitude of Neptune (i.e., the visual magnitude of the planet reduced to a distance of 1 au from both the Sun and Earth and phase angle zero). This parameter is also refered to as absolute magnitude in planetary sciences", 
     source = "P.K. Seidelmann, 1992, 'Explanatory Supplement to the Astronomical Almanac', University Science Books, Mill Valley, Ca., ISBN 0-935702-68-7, Table 15.8 on page 706; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "mag") 
    public static final double NEPTUNE_VONEZEROMAGNITUDE; static { NEPTUNE_VONEZEROMAGNITUDE = -6.87; } // [mag] 

    /**
     * Geometric albedo of Neptune (i.e., the ratio of the body's brightness at zero phase angle to the brightness of a perfectly diffusing disk with the same position and apparent size as the body)    
     * <p>
     * Source: P.K. Seidelmann, 1992, 'Explanatory Supplement to the Astronomical Almanac', University Science Books, Mill Valley, Ca., ISBN 0-935702-68-7, Table 15.8 on page 706; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Geometric albedo of Neptune (i.e., the ratio of the body's brightness at zero phase angle to the brightness of a perfectly diffusing disk with the same position and apparent size as the body)", 
     source = "P.K. Seidelmann, 1992, 'Explanatory Supplement to the Astronomical Almanac', University Science Books, Mill Valley, Ca., ISBN 0-935702-68-7, Table 15.8 on page 706; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double NEPTUNE_GEOMETRICALBEDO; static { NEPTUNE_GEOMETRICALBEDO = 0.41; } 

    /**
     * Mean mass density of Neptune    
     * <p>
     * Status: CONF<br/>
     * Unit: g cm^-3<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean mass density of Neptune", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "g cm^-3") 
    public static final double NEPTUNE_MASSDENSITY_MEAN; static { NEPTUNE_MASSDENSITY_MEAN = 1.638; } // [g cm^-3] 

    /**
     * Radius of the smallest hypothetical sphere around Neptune which would encompass the body (this is a low-accuracy parameter used in the relativistic model)    
     * <p>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Radius of the smallest hypothetical sphere around Neptune which would encompass the body (this is a low-accuracy parameter used in the relativistic model)", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m") 
    public static final double NEPTUNE_ENCOMPASSINGSPHERERADIUS; static { NEPTUNE_ENCOMPASSINGSPHERERADIUS = 2.47640e+7; } // [m] 

    /**
     * Dynamical form-factor of Neptune (oblateness or Stokes' second-degree zonal harmonic of the potential)    
     * <p>
     * Source: P.R. Weissman, L.-A. McFadden, T.V. Johnson (eds.), 1999, 'Encyclopedia of the Solar System (first edition)', Academic Press, page 342<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Dynamical form-factor of Neptune (oblateness or Stokes' second-degree zonal harmonic of the potential)", 
     source = "P.R. Weissman, L.-A. McFadden, T.V. Johnson (eds.), 1999, 'Encyclopedia of the Solar System (first edition)', Academic Press, page 342", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double NEPTUNE_JSUB2; static { NEPTUNE_JSUB2 = 0.003538; } 

    /**
     * Geometrical flattening factor f of Neptune (f = (a-b)/a)    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A); see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Geometrical flattening factor f of Neptune (f = (a-b)/a)", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A); see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double NEPTUNE_FLATTENING; static { NEPTUNE_FLATTENING = 1.710e-2; } 

    /**
     * Post-Newtonian deflection angle of a limb-grazing light ray due to the spherically symmetric part of the gravitational field of Neptune    
     * <p>
     * Source: S.A. Klioner, 2003, 'A Practical Relativistic Model for Microarcsecond Astrometry in Space', AJ, 125, 1580, Equation 64 with cot(x) = cos(x) / sin(x) approximated by x^-1; see also J.H.J. de Bruijne, 19 February 2002, 'Gravitational light deflection', GAIA-JdB-001, issue 1, revision 0<br/>
     * Status: CONF<br/>
     * Unit: 10^-6 arcsec<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Post-Newtonian deflection angle of a limb-grazing light ray due to the spherically symmetric part of the gravitational field of Neptune", 
     source = "S.A. Klioner, 2003, 'A Practical Relativistic Model for Microarcsecond Astrometry in Space', AJ, 125, 1580, Equation 64 with cot(x) = cos(x) / sin(x) approximated by x^-1; see also J.H.J. de Bruijne, 19 February 2002, 'Gravitational light deflection', GAIA-JdB-001, issue 1, revision 0", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "10^-6 arcsec") 
    public static final double NEPTUNE_LIGHTDEFLECTION_LIMB; static { NEPTUNE_LIGHTDEFLECTION_LIMB = 2548.; } // [10^-6 arcsec] 

    /**
     * Geometric transit probability (Neptune transiting the Sun) for an observer external to the solar system    
     * <p>
     * Source: E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 2.1, Equation 2.2, page 14<br/>
     * Status: CONF<br/>
     * Unit: %<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Geometric transit probability (Neptune transiting the Sun) for an observer external to the solar system", 
     source = "E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 2.1, Equation 2.2, page 14", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "%") 
    public static final double NEPTUNE_TRANSITPROBABILITY; static { NEPTUNE_TRANSITPROBABILITY = 0.016; } // [%] 

    /**
     * Maximum reduction of the solar flux for an observer external to the solar system during a transit of Neptune    
     * <p>
     * Source: E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 2.2, Equation 2.4, page 14<br/>
     * Status: CONF<br/>
     * Unit: %<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Maximum reduction of the solar flux for an observer external to the solar system during a transit of Neptune", 
     source = "E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 2.2, Equation 2.4, page 14", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "%") 
    public static final double NEPTUNE_FLUXREDUCTION_MAXIMUM; static { NEPTUNE_FLUXREDUCTION_MAXIMUM = 0.125; } // [%] 

    /**
     * Maximum transit time of Neptune (transiting the Sun) for an observer external to the solar system    
     * <p>
     * Source: E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 2.3, Equation 2.5, page 15<br/>
     * Status: CONF<br/>
     * Unit: day<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Maximum transit time of Neptune (transiting the Sun) for an observer external to the solar system", 
     source = "E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 2.3, Equation 2.5, page 15", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "day") 
    public static final double NEPTUNE_TRANSITTIME_MAXIMUM; static { NEPTUNE_TRANSITTIME_MAXIMUM = 3.07; } // [day] 

    /**
     * Neptune-system mass (IAU 2009 CBE value). The planetary mass includes the contribution of its satellites    
     * <p>
     * Status: CONF<br/>
     * Unit: kg<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Neptune-system mass (IAU 2009 CBE value). The planetary mass includes the contribution of its satellites", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "kg") 
    public static final double NEPTUNESYSTEM_MASS; static { NEPTUNESYSTEM_MASS = 1.02434e+26; } // [kg] 

    /**
     * Mean orbital semi-major axis of Neptune, at the standard epoch J2000.0. The mean orbital semi-major axis is associated with a mean orbit solution from a 250-year least-squares fit of JPL's DE405 ephemeris to a Keplerian orbit covering the interval of years 1800 AD - 2050 AD. The orbital element is referenced to the mean ecliptic and equinox of J2000 at the standard epoch J2000.0; linear rates and fit errors can be found in the reference document    
     * <p>
     * Source: E.M. Standish, 16 February 2006, 'Keplerian Elements for Approximate Positions of the Major Planets', http://ssd.jpl.nasa.gov/?planets\#elem<br/>
     * Status: CONF<br/>
     * Unit: au<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean orbital semi-major axis of Neptune, at the standard epoch J2000.0. The mean orbital semi-major axis is associated with a mean orbit solution from a 250-year least-squares fit of JPL's DE405 ephemeris to a Keplerian orbit covering the interval of years 1800 AD - 2050 AD. The orbital element is referenced to the mean ecliptic and equinox of J2000 at the standard epoch J2000.0; linear rates and fit errors can be found in the reference document", 
     source = "E.M. Standish, 16 February 2006, 'Keplerian Elements for Approximate Positions of the Major Planets', http://ssd.jpl.nasa.gov/?planets\\#elem", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "au") 
    public static final double NEPTUNESYSTEM_ORBITALSEMIMAJORAXIS_J2000; static { NEPTUNESYSTEM_ORBITALSEMIMAJORAXIS_J2000 = 30.06992276; } // [au] 

    /**
     * Mean orbital eccentricity of Neptune, at the standard epoch J2000.0. The mean orbital eccentricity is associated with a mean orbit solution from a 250-year least-squares fit of JPL's DE405 ephemeris to a Keplerian orbit covering the interval of years 1800 AD - 2050 AD. The orbital element is referenced to the mean ecliptic and equinox of J2000 at the standard epoch J2000.0; linear rates and fit errors can be found in the reference document    
     * <p>
     * Source: E.M. Standish, 16 February 2006, 'Keplerian Elements for Approximate Positions of the Major Planets', http://ssd.jpl.nasa.gov/?planets\#elem<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean orbital eccentricity of Neptune, at the standard epoch J2000.0. The mean orbital eccentricity is associated with a mean orbit solution from a 250-year least-squares fit of JPL's DE405 ephemeris to a Keplerian orbit covering the interval of years 1800 AD - 2050 AD. The orbital element is referenced to the mean ecliptic and equinox of J2000 at the standard epoch J2000.0; linear rates and fit errors can be found in the reference document", 
     source = "E.M. Standish, 16 February 2006, 'Keplerian Elements for Approximate Positions of the Major Planets', http://ssd.jpl.nasa.gov/?planets\\#elem", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double NEPTUNESYSTEM_ORBITALECCENTRICITY_J2000; static { NEPTUNESYSTEM_ORBITALECCENTRICITY_J2000 = 0.00859048; } 

    /**
     * Mean orbital inclination of Neptune, at the standard epoch J2000.0. The mean orbital inclination is is associated with a mean orbit solution from a 250-year least-squares fit of JPL's DE405 ephemeris to a Keplerian orbit covering the interval of years 1800 AD - 2050 AD. The orbital element is referenced to the mean ecliptic and equinox of J2000 at the standard epoch J2000.0; linear rates and fit errors can be found in the reference document    
     * <p>
     * Source: E.M. Standish, 16 February 2006, 'Keplerian Elements for Approximate Positions of the Major Planets', http://ssd.jpl.nasa.gov/?planets\#elem<br/>
     * Status: CONF<br/>
     * Unit: deg<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean orbital inclination of Neptune, at the standard epoch J2000.0. The mean orbital inclination is is associated with a mean orbit solution from a 250-year least-squares fit of JPL's DE405 ephemeris to a Keplerian orbit covering the interval of years 1800 AD - 2050 AD. The orbital element is referenced to the mean ecliptic and equinox of J2000 at the standard epoch J2000.0; linear rates and fit errors can be found in the reference document", 
     source = "E.M. Standish, 16 February 2006, 'Keplerian Elements for Approximate Positions of the Major Planets', http://ssd.jpl.nasa.gov/?planets\\#elem", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "deg") 
    public static final double NEPTUNESYSTEM_ORBITALINCLINATION_J2000; static { NEPTUNESYSTEM_ORBITALINCLINATION_J2000 = 1.77004347; } // [deg] 

    /**
     * Radial-velocity amplitude of the Sun induced by the Neptune system for 'an edge-on observer' (i.e., an observer in the orbital plane of the Neptune system)    
     * <p>
     * Source: E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 1.4, Equation 1.18, page 9<br/>
     * Status: CONF<br/>
     * Unit: m s^-1<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Radial-velocity amplitude of the Sun induced by the Neptune system for 'an edge-on observer' (i.e., an observer in the orbital plane of the Neptune system)", 
     source = "E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 1.4, Equation 1.18, page 9", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m s^-1") 
    public static final double NEPTUNESYSTEM_RADIALVELOCITYSIGNATURE; static { NEPTUNESYSTEM_RADIALVELOCITYSIGNATURE = 0.3; } // [m s^-1] 

    /**
     * Sidereal orbital period    
     * <p>
     * Source: Values derived from the mean longitude rates in Table 5.8.1 in P.K. Seidelmann, 1992, 'Explanatory Supplement to the Astronomical Almanac', University Science Books, Mill Valley, Ca., ISBN 0-935702-68-7, page 316; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par<br/>
     * Status: CONF<br/>
     * Unit: yr<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Sidereal orbital period", 
     source = "Values derived from the mean longitude rates in Table 5.8.1 in P.K. Seidelmann, 1992, 'Explanatory Supplement to the Astronomical Almanac', University Science Books, Mill Valley, Ca., ISBN 0-935702-68-7, page 316; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "yr") 
    public static final double NEPTUNESYSTEM_ORBITALPERIOD; static { NEPTUNESYSTEM_ORBITALPERIOD = 164.79132; } // [yr] 

    /**
     * Astrometric signature of the Sun induced by the Neptune system for an observer located at a distance of 10 pc from the Sun    
     * <p>
     * Source: E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 1.7, Equation 1.22, page 11<br/>
     * Status: CONF<br/>
     * Unit: 10^-6 arcsec<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Astrometric signature of the Sun induced by the Neptune system for an observer located at a distance of 10 pc from the Sun", 
     source = "E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 1.7, Equation 1.22, page 11", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "10^-6 arcsec") 
    public static final double NEPTUNESYSTEM_ASTROMETRICSIGNATURE_10PARSEC; static { NEPTUNESYSTEM_ASTROMETRICSIGNATURE_10PARSEC = 155.; } // [10^-6 arcsec] 

    /**
     * Newton's universal constant of gravitation    
     * <p>
     * Source: P.J. Mohr, B.N. Taylor, D.B. Newell, 9 July 2015, 'The 2014 CODATA Recommended Values of the Fundamental Physical Constants', National Institute of Standards and Technology, Gaithersburg, MD 20899-8401; http://www.codata.org/ and http://physics.nist.gov/constants (Web Version 7.0). See also the IAU (2009) System of Astronomical Constants (IAU, August 2009, 'IAU 2009 Astronomical Constants', IAU 2009 Resolution B2 adopted at the XXVII-th General Assembly of the IAU. See also IAU, 10 August 2009, 'IAU WG on NSFA Current Best Estimates', http://maia.usno.navy.mil/NSFA/NSFA_cbe.html)<br/>
     * Status: CONF<br/>
     * Unit: m^3 kg^-1 s^-2<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Newton's universal constant of gravitation", 
     source = "P.J. Mohr, B.N. Taylor, D.B. Newell, 9 July 2015, 'The 2014 CODATA Recommended Values of the Fundamental Physical Constants', National Institute of Standards and Technology, Gaithersburg, MD 20899-8401; http://www.codata.org/ and http://physics.nist.gov/constants (Web Version 7.0). See also the IAU (2009) System of Astronomical Constants (IAU, August 2009, 'IAU 2009 Astronomical Constants', IAU 2009 Resolution B2 adopted at the XXVII-th General Assembly of the IAU. See also IAU, 10 August 2009, 'IAU WG on NSFA Current Best Estimates', http://maia.usno.navy.mil/NSFA/NSFA_cbe.html)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "m^3 kg^-1 s^-2") 
    public static final double NEWTON_CONSTANT; static { NEWTON_CONSTANT = 6.674080e-11; } // [m^3 kg^-1 s^-2] 

    /**
     * Mean orbital eccentricity of the nominal Sun for use in simulations of the NSL (mean ecliptic orbital elements, at the standard epoch J2000.0). See also the parameter :Nature:EMBC_OrbitalEccentricity_J2000. Note that a value of 0.0167086342 is given in Section 5.8.3 of J.L. Simon, P. Bretagnon, J. Chapront, M. Chapront-Touze, G. Francou, J. Laskar, 1994, 'Numerical expressions for precession formulae and mean elements for the Moon and the planets', A&A, 282, 663 (1994A&A...282..663S)    
     * <p>
     * Source: F. Mignard, priv. comm., 14 July 2004, based on the Fortran-90 subroutine SCANNING (version 4.1, April 2004); see also GAIA-FM-010 and GAIA-FM-017<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean orbital eccentricity of the nominal Sun for use in simulations of the NSL (mean ecliptic orbital elements, at the standard epoch J2000.0). See also the parameter :Nature:EMBC_OrbitalEccentricity_J2000. Note that a value of 0.0167086342 is given in Section 5.8.3 of J.L. Simon, P. Bretagnon, J. Chapront, M. Chapront-Touze, G. Francou, J. Laskar, 1994, 'Numerical expressions for precession formulae and mean elements for the Moon and the planets', A&A, 282, 663 (1994A&A...282..663S)", 
     source = "F. Mignard, priv. comm., 14 July 2004, based on the Fortran-90 subroutine SCANNING (version 4.1, April 2004); see also GAIA-FM-010 and GAIA-FM-017", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double NOMINALSUN_ORBITALECCENTRICITY_J2000; static { NOMINALSUN_ORBITALECCENTRICITY_J2000 = 0.01671; } 

    /**
     * Mean (geometric) longitude of the nominal Sun for use in simulations of the NSL (mean ecliptic orbital elements, at the standard epoch J2000.0); subtract aberration (about 20 arcsec; see parameter :Nature:Aberration_Constant_J2000) to obtain the apparent longitude of the nominal Sun. Note that a value of 280.46645683 degrees is given in Section 5.8.3 of J.L. Simon, P. Bretagnon, J. Chapront, M. Chapront-Touze, G. Francou, J. Laskar, 1994, 'Numerical expressions for precession formulae and mean elements for the Moon and the planets', A&A, 282, 663 (1994A&A...282..663S)    
     * <p>
     * Source: F. Mignard, priv. comm., 14 July 2004, based on the Fortran-90 subroutine SCANNING (version 4.1, April 2004); see also GAIA-FM-010 and GAIA-FM-017<br/>
     * Status: CONF<br/>
     * Unit: deg<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean (geometric) longitude of the nominal Sun for use in simulations of the NSL (mean ecliptic orbital elements, at the standard epoch J2000.0); subtract aberration (about 20 arcsec; see parameter :Nature:Aberration_Constant_J2000) to obtain the apparent longitude of the nominal Sun. Note that a value of 280.46645683 degrees is given in Section 5.8.3 of J.L. Simon, P. Bretagnon, J. Chapront, M. Chapront-Touze, G. Francou, J. Laskar, 1994, 'Numerical expressions for precession formulae and mean elements for the Moon and the planets', A&A, 282, 663 (1994A&A...282..663S)", 
     source = "F. Mignard, priv. comm., 14 July 2004, based on the Fortran-90 subroutine SCANNING (version 4.1, April 2004); see also GAIA-FM-010 and GAIA-FM-017", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "deg") 
    public static final double NOMINALSUN_MEANLONGITUDE_J2000; static { NOMINALSUN_MEANLONGITUDE_J2000 = 280.4665; } // [deg] 

    /**
     * Mean (geometric) longitude rate of the nominal Sun for use in simulations of the NSL (mean ecliptic orbital elements, at the standard epoch J2000.0). Note that a value of 1295977422.83429 / (1.0E3 * 365.25 * 3600.0) = 0.98560911 degrees day^-1 is given in Section 5.8.3 of J.L. Simon, P. Bretagnon, J. Chapront, M. Chapront-Touze, G. Francou, J. Laskar, 1994, 'Numerical expressions for precession formulae and mean elements for the Moon and the planets', A&A, 282, 663 (1994A&A...282..663S)    
     * <p>
     * Source: F. Mignard, priv. comm., 14 July 2004, based on the Fortran-90 subroutine SCANNING (version 4.1, April 2004); see also GAIA-FM-010 and GAIA-FM-017<br/>
     * Status: CONF<br/>
     * Unit: deg day^-1<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean (geometric) longitude rate of the nominal Sun for use in simulations of the NSL (mean ecliptic orbital elements, at the standard epoch J2000.0). Note that a value of 1295977422.83429 / (1.0E3 * 365.25 * 3600.0) = 0.98560911 degrees day^-1 is given in Section 5.8.3 of J.L. Simon, P. Bretagnon, J. Chapront, M. Chapront-Touze, G. Francou, J. Laskar, 1994, 'Numerical expressions for precession formulae and mean elements for the Moon and the planets', A&A, 282, 663 (1994A&A...282..663S)", 
     source = "F. Mignard, priv. comm., 14 July 2004, based on the Fortran-90 subroutine SCANNING (version 4.1, April 2004); see also GAIA-FM-010 and GAIA-FM-017", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "deg day^-1") 
    public static final double NOMINALSUN_MEANLONGITUDERATE_J2000; static { NOMINALSUN_MEANLONGITUDERATE_J2000 = 0.98560903; } // [deg day^-1] 

    /**
     * Orbital mean anomaly of the nominal Sun for use in simulations of the NSL (mean ecliptic orbital elements, at the standard epoch J2000.0). Note that a value of 100.46645683 - 102.93734808 + 360 = 357.52910875 degrees is given in Section 5.8.3 of J.L. Simon, P. Bretagnon, J. Chapront, M. Chapront-Touze, G. Francou, J. Laskar, 1994, 'Numerical expressions for precession formulae and mean elements for the Moon and the planets', A&A, 282, 663 (1994A&A...282..663S)    
     * <p>
     * Source: F. Mignard, priv. comm., 14 July 2004, based on the Fortran-90 subroutine SCANNING (version 4.1, April 2004); see also GAIA-FM-010 and GAIA-FM-017<br/>
     * Status: CONF<br/>
     * Unit: deg<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Orbital mean anomaly of the nominal Sun for use in simulations of the NSL (mean ecliptic orbital elements, at the standard epoch J2000.0). Note that a value of 100.46645683 - 102.93734808 + 360 = 357.52910875 degrees is given in Section 5.8.3 of J.L. Simon, P. Bretagnon, J. Chapront, M. Chapront-Touze, G. Francou, J. Laskar, 1994, 'Numerical expressions for precession formulae and mean elements for the Moon and the planets', A&A, 282, 663 (1994A&A...282..663S)", 
     source = "F. Mignard, priv. comm., 14 July 2004, based on the Fortran-90 subroutine SCANNING (version 4.1, April 2004); see also GAIA-FM-010 and GAIA-FM-017", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "deg") 
    public static final double NOMINALSUN_ORBITALMEANANOMALY_J2000; static { NOMINALSUN_ORBITALMEANANOMALY_J2000 = 357.529; } // [deg] 

    /**
     * Orbital mean anomaly rate of the nominal Sun for use in simulations of the NSL (mean ecliptic orbital elements, at the standard epoch J2000.0). Note that a value of (1295977422.83429 - 11612.35290) / (1.0E3 * 365.25 * 3600.0) = 0.98560028 degrees day^-1 is given in Section 5.8.3 of J.L. Simon, P. Bretagnon, J. Chapront, M. Chapront-Touze, G. Francou, J. Laskar, 1994, 'Numerical expressions for precession formulae and mean elements for the Moon and the planets', A&A, 282, 663 (1994A&A...282..663S)    
     * <p>
     * Source: F. Mignard, priv. comm., 14 July 2004, based on the Fortran-90 subroutine SCANNING (version 4.1, April 2004); see also GAIA-FM-010 and GAIA-FM-017<br/>
     * Status: CONF<br/>
     * Unit: deg day^-1<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Orbital mean anomaly rate of the nominal Sun for use in simulations of the NSL (mean ecliptic orbital elements, at the standard epoch J2000.0). Note that a value of (1295977422.83429 - 11612.35290) / (1.0E3 * 365.25 * 3600.0) = 0.98560028 degrees day^-1 is given in Section 5.8.3 of J.L. Simon, P. Bretagnon, J. Chapront, M. Chapront-Touze, G. Francou, J. Laskar, 1994, 'Numerical expressions for precession formulae and mean elements for the Moon and the planets', A&A, 282, 663 (1994A&A...282..663S)", 
     source = "F. Mignard, priv. comm., 14 July 2004, based on the Fortran-90 subroutine SCANNING (version 4.1, April 2004); see also GAIA-FM-010 and GAIA-FM-017", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "deg day^-1") 
    public static final double NOMINALSUN_ORBITALMEANANOMALYRATE_J2000; static { NOMINALSUN_ORBITALMEANANOMALYRATE_J2000 = 0.98560020; } // [deg day^-1] 

    /**
     * Constant of nutation, at the standard epoch J2000.0, nowadays irrelevant as a fundamental constant    
     * <p>
     * Source: P.K. Seidelmann, May 1982, '1980 IAU theory of nutation. The final report of the IAU Working Group on Nutation', Celestial Mechanics, 27, pages 79-106 (1982CeMec..27...79S)<br/>
     * Status: CONF<br/>
     * Unit: arcsec<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Constant of nutation, at the standard epoch J2000.0, nowadays irrelevant as a fundamental constant", 
     source = "P.K. Seidelmann, May 1982, '1980 IAU theory of nutation. The final report of the IAU Working Group on Nutation', Celestial Mechanics, 27, pages 79-106 (1982CeMec..27...79S)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "arcsec") 
    public static final double NUTATION_CONSTANT_J2000; static { NUTATION_CONSTANT_J2000 = 9.2025; } // [arcsec] 

    /**
     * Obliquity of the ecliptic with respect to the ICRS reference plane, at the standard epoch J2000.0. Note that the ICRS origin is shifted in the equatorial plane from \Gamma by \phi = 0.05542 arcsec, positive from \Gamma to the ICRS origin. Note that the value of the obliquity of the ecliptic in the inertial sense, i.e., with respect to the CIP equator (Celestial Intermediate Pole, formerly the Mean Celestial Ephemeris Pole or MCEP) equals 84381.406 arcsec (from the IAU (2009) System of Astronomical Constants: IAU, August 2009, 'IAU 2009 Astronomical Constants', IAU 2009 Resolution B2 adopted at the XXVII-th General Assembly of the IAU. See also IAU, 10 August 2009, 'IAU WG on NSFA Current Best Estimates', http://maia.usno.navy.mil/NSFA/NSFA_cbe.html)    
     * <p>
     * Source: J. Chapront, M. Chapront-Touze, G. Francou, 2002, 'A new determination of lunar orbital parameters, precession constant, and tidal acceleration from LLR measurements', A&A, 387, 700<br/>
     * Status: CONF<br/>
     * Unit: arcsec<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Obliquity of the ecliptic with respect to the ICRS reference plane, at the standard epoch J2000.0. Note that the ICRS origin is shifted in the equatorial plane from \\Gamma by \\phi = 0.05542 arcsec, positive from \\Gamma to the ICRS origin. Note that the value of the obliquity of the ecliptic in the inertial sense, i.e., with respect to the CIP equator (Celestial Intermediate Pole, formerly the Mean Celestial Ephemeris Pole or MCEP) equals 84381.406 arcsec (from the IAU (2009) System of Astronomical Constants: IAU, August 2009, 'IAU 2009 Astronomical Constants', IAU 2009 Resolution B2 adopted at the XXVII-th General Assembly of the IAU. See also IAU, 10 August 2009, 'IAU WG on NSFA Current Best Estimates', http://maia.usno.navy.mil/NSFA/NSFA_cbe.html)", 
     source = "J. Chapront, M. Chapront-Touze, G. Francou, 2002, 'A new determination of lunar orbital parameters, precession constant, and tidal acceleration from LLR measurements', A&A, 387, 700", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "arcsec") 
    public static final double OBLIQUITYOFECLIPTIC_J2000; static { OBLIQUITYOFECLIPTIC_J2000 = 84381.41100; } // [arcsec] 

    /**
     * Oort constant A    
     * <p>
     * Source: M. Feast, P. Whitelock, 1997, MNRAS, 291, 683<br/>
     * Status: CONF<br/>
     * Unit: km s^-1 kpc^-1<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Oort constant A", 
     source = "M. Feast, P. Whitelock, 1997, MNRAS, 291, 683", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "km s^-1 kpc^-1") 
    public static final double OORT_CONSTANT_A; static { OORT_CONSTANT_A = 14.82; } // [km s^-1 kpc^-1] 

    /**
     * Oort constant B    
     * <p>
     * Source: M. Feast, P. Whitelock, 1997, MNRAS, 291, 683<br/>
     * Status: CONF<br/>
     * Unit: km s^-1 kpc^-1<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Oort constant B", 
     source = "M. Feast, P. Whitelock, 1997, MNRAS, 291, 683", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "km s^-1 kpc^-1") 
    public static final double OORT_CONSTANT_B; static { OORT_CONSTANT_B = -12.37; } // [km s^-1 kpc^-1] 

    /**
     * Parsec expressed in m    
     * <p>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Parsec expressed in m", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m") 
    public static final double PARSEC_METER; static { PARSEC_METER = 3.0856775814913672e+16; } // [m] 

    /**
     * Parsec expressed in au    
     * <p>
     * Status: CONF<br/>
     * Unit: au<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Parsec expressed in au", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "au") 
    public static final double PARSEC_ASTRONOMICALUNIT; static { PARSEC_ASTRONOMICALUNIT = 206264.806247096; } // [au] 

    /**
     * The constant Pi (also known as Archimedes' constant). Note that double-precision, floating-point numbers in any programming language which follows the IEEE standard (true for C, C++, Java, and most, if not all, others) have only 16 significant digits (64 bits); the representation here, using 30 significant digits, is thus amply sufficient    
     * <p>
     * Source: Well-known mathematical constant; numerical value can be extracted, e.g., from Mathematica 4.0 for Solaris (Wolfram Research, Inc.) using 'N[Pi,30]'<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "The constant Pi (also known as Archimedes' constant). Note that double-precision, floating-point numbers in any programming language which follows the IEEE standard (true for C, C++, Java, and most, if not all, others) have only 16 significant digits (64 bits); the representation here, using 30 significant digits, is thus amply sufficient", 
     source = "Well-known mathematical constant; numerical value can be extracted, e.g., from Mathematica 4.0 for Solaris (Wolfram Research, Inc.) using 'N[Pi,30]'", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double PI_CONSTANT; static { PI_CONSTANT = 3.14159265358979323846264338328; } 

    /**
     * Planck's constant    
     * <p>
     * Source: P.J. Mohr, B.N. Taylor, D.B. Newell, 9 July 2015, 'The 2014 CODATA Recommended Values of the Fundamental Physical Constants', National Institute of Standards and Technology, Gaithersburg, MD 20899-8401; http://www.codata.org/ and http://physics.nist.gov/constants (Web Version 7.0)<br/>
     * Status: CONF<br/>
     * Unit: J s<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Planck's constant", 
     source = "P.J. Mohr, B.N. Taylor, D.B. Newell, 9 July 2015, 'The 2014 CODATA Recommended Values of the Fundamental Physical Constants', National Institute of Standards and Technology, Gaithersburg, MD 20899-8401; http://www.codata.org/ and http://physics.nist.gov/constants (Web Version 7.0)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "J s") 
    public static final double PLANCK_CONSTANT; static { PLANCK_CONSTANT = 6.6260700400e-34; } // [J s] 

    /**
     * Mass of Pluto (do not use for high-precision (orbit) calculations)    
     * <p>
     * Source: R.A. Jacobson, 2007, 'The orbits of the satellites of Pluto - Ephemeris PLU017', priv. comm.; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par<br/>
     * Status: CONF<br/>
     * Unit: kg<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mass of Pluto (do not use for high-precision (orbit) calculations)", 
     source = "R.A. Jacobson, 2007, 'The orbits of the satellites of Pluto - Ephemeris PLU017', priv. comm.; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "kg") 
    public static final double PLUTO_MASS; static { PLUTO_MASS = 1.3090e+22; } // [kg] 

    /**
     * Mean volumetric radius of Pluto    
     * <p>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean volumetric radius of Pluto", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m") 
    public static final double PLUTO_VOLUMETRICRADIUS; static { PLUTO_VOLUMETRICRADIUS = 1.1950e+6; } // [m] 

    /**
     * Equatorial radius of Pluto    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A); see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par<br/>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Equatorial radius of Pluto", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A); see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "m") 
    public static final double PLUTO_EQUATORIALRADIUS; static { PLUTO_EQUATORIALRADIUS = 1.1950e+6; } // [m] 

    /**
     * Polar radius of Pluto    
     * <p>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Polar radius of Pluto", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m") 
    public static final double PLUTO_POLARRADIUS; static { PLUTO_POLARRADIUS = 1.1950e+6; } // [m] 

    /**
     * V(1,0) magnitude of Pluto (i.e., the visual magnitude of the 'planet' reduced to a distance of 1 au from both the Sun and Earth and phase angle zero). This parameter is also refered to as absolute magnitude in planetary sciences    
     * <p>
     * Source: P.K. Seidelmann, 1992, 'Explanatory Supplement to the Astronomical Almanac', University Science Books, Mill Valley, Ca., ISBN 0-935702-68-7, Table 15.8 on page 706; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par<br/>
     * Status: CONF<br/>
     * Unit: mag<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "V(1,0) magnitude of Pluto (i.e., the visual magnitude of the 'planet' reduced to a distance of 1 au from both the Sun and Earth and phase angle zero). This parameter is also refered to as absolute magnitude in planetary sciences", 
     source = "P.K. Seidelmann, 1992, 'Explanatory Supplement to the Astronomical Almanac', University Science Books, Mill Valley, Ca., ISBN 0-935702-68-7, Table 15.8 on page 706; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "mag") 
    public static final double PLUTO_VONEZEROMAGNITUDE; static { PLUTO_VONEZEROMAGNITUDE = -1.0; } // [mag] 

    /**
     * Geometric albedo of Pluto (i.e., the ratio of the body's brightness at zero phase angle to the brightness of a perfectly diffusing disk with the same position and apparent size as the body)    
     * <p>
     * Source: P.K. Seidelmann, 1992, 'Explanatory Supplement to the Astronomical Almanac', University Science Books, Mill Valley, Ca., ISBN 0-935702-68-7, Table 15.8 on page 706; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Geometric albedo of Pluto (i.e., the ratio of the body's brightness at zero phase angle to the brightness of a perfectly diffusing disk with the same position and apparent size as the body)", 
     source = "P.K. Seidelmann, 1992, 'Explanatory Supplement to the Astronomical Almanac', University Science Books, Mill Valley, Ca., ISBN 0-935702-68-7, Table 15.8 on page 706; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double PLUTO_GEOMETRICALBEDO; static { PLUTO_GEOMETRICALBEDO = 0.3; } 

    /**
     * Mean mass density of Pluto (rough estimate)    
     * <p>
     * Status: CONF<br/>
     * Unit: g cm^-3<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean mass density of Pluto (rough estimate)", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "g cm^-3") 
    public static final double PLUTO_MASSDENSITY_MEAN; static { PLUTO_MASSDENSITY_MEAN = 1.83; } // [g cm^-3] 

    /**
     * Radius of the smallest hypothetical sphere around Pluto which would encompass the body (this is a low-accuracy parameter used in the relativistic model)    
     * <p>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Radius of the smallest hypothetical sphere around Pluto which would encompass the body (this is a low-accuracy parameter used in the relativistic model)", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m") 
    public static final double PLUTO_ENCOMPASSINGSPHERERADIUS; static { PLUTO_ENCOMPASSINGSPHERERADIUS = 1.1950e+6; } // [m] 

    /**
     * Dynamical form-factor of Pluto (oblateness or Stokes' second-degree zonal harmonic of the potential); value is unknown    
     * <p>
     * Source: P.K. Seidelmann, 1992, 'Explanatory Supplement to the Astronomical Almanac', University Science Books, Mill Valley, Ca., ISBN 0-935702-68-7, Table 15.8<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Dynamical form-factor of Pluto (oblateness or Stokes' second-degree zonal harmonic of the potential); value is unknown", 
     source = "P.K. Seidelmann, 1992, 'Explanatory Supplement to the Astronomical Almanac', University Science Books, Mill Valley, Ca., ISBN 0-935702-68-7, Table 15.8", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double PLUTO_JSUB2; static { PLUTO_JSUB2 = 0.; } 

    /**
     * Geometrical flattening factor f of Pluto (f = (a-b)/a)    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A); see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Geometrical flattening factor f of Pluto (f = (a-b)/a)", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A); see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double PLUTO_FLATTENING; static { PLUTO_FLATTENING = 0.; } 

    /**
     * Post-Newtonian deflection angle of a limb-grazing light ray due to the spherically symmetric part of the gravitational field of Pluto    
     * <p>
     * Source: S.A. Klioner, 2003, 'A Practical Relativistic Model for Microarcsecond Astrometry in Space', AJ, 125, 1580, Equation 64 with cot(x) = cos(x) / sin(x) approximated by x^-1; see also J.H.J. de Bruijne, 19 February 2002, 'Gravitational light deflection', GAIA-JdB-001, issue 1, revision 0<br/>
     * Status: CONF<br/>
     * Unit: 10^-6 arcsec<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Post-Newtonian deflection angle of a limb-grazing light ray due to the spherically symmetric part of the gravitational field of Pluto", 
     source = "S.A. Klioner, 2003, 'A Practical Relativistic Model for Microarcsecond Astrometry in Space', AJ, 125, 1580, Equation 64 with cot(x) = cos(x) / sin(x) approximated by x^-1; see also J.H.J. de Bruijne, 19 February 2002, 'Gravitational light deflection', GAIA-JdB-001, issue 1, revision 0", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "10^-6 arcsec") 
    public static final double PLUTO_LIGHTDEFLECTION_LIMB; static { PLUTO_LIGHTDEFLECTION_LIMB = 7.; } // [10^-6 arcsec] 

    /**
     * Geometric transit probability (Pluto transiting the Sun) for an observer external to the solar system    
     * <p>
     * Source: E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 2.1, Equation 2.2, page 14<br/>
     * Status: CONF<br/>
     * Unit: %<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Geometric transit probability (Pluto transiting the Sun) for an observer external to the solar system", 
     source = "E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 2.1, Equation 2.2, page 14", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "%") 
    public static final double PLUTO_TRANSITPROBABILITY; static { PLUTO_TRANSITPROBABILITY = 0.012; } // [%] 

    /**
     * Maximum reduction of the solar flux for an observer external to the solar system during a transit of Pluto    
     * <p>
     * Source: E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 2.2, Equation 2.4, page 14<br/>
     * Status: CONF<br/>
     * Unit: %<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Maximum reduction of the solar flux for an observer external to the solar system during a transit of Pluto", 
     source = "E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 2.2, Equation 2.4, page 14", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "%") 
    public static final double PLUTO_FLUXREDUCTION_MAXIMUM; static { PLUTO_FLUXREDUCTION_MAXIMUM = 0.0003; } // [%] 

    /**
     * Maximum transit time of Pluto (transiting the Sun) for an observer external to the solar system    
     * <p>
     * Source: E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 2.3, Equation 2.5, page 15<br/>
     * Status: CONF<br/>
     * Unit: day<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Maximum transit time of Pluto (transiting the Sun) for an observer external to the solar system", 
     source = "E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 2.3, Equation 2.5, page 15", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "day") 
    public static final double PLUTO_TRANSITTIME_MAXIMUM; static { PLUTO_TRANSITTIME_MAXIMUM = 3.40; } // [day] 

    /**
     * Pluto-system mass (IAU 2009 CBE value). The 'planetary' mass includes the contribution of its satellite, Charon    
     * <p>
     * Status: CONF<br/>
     * Unit: kg<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Pluto-system mass (IAU 2009 CBE value). The 'planetary' mass includes the contribution of its satellite, Charon", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "kg") 
    public static final double PLUTOSYSTEM_MASS; static { PLUTOSYSTEM_MASS = 1.4561e+22; } // [kg] 

    /**
     * Mean orbital semi-major axis of Pluto, at the standard epoch J2000.0. The mean orbital semi-major axis is associated with a mean orbit solution from a 250-year least-squares fit of JPL's DE405 ephemeris to a Keplerian orbit covering the interval of years 1800 AD - 2050 AD. The orbital element is referenced to the mean ecliptic and equinox of J2000 at the standard epoch J2000.0; linear rates and fit errors can be found in the reference document    
     * <p>
     * Source: E.M. Standish, 16 February 2006, 'Keplerian Elements for Approximate Positions of the Major Planets', http://ssd.jpl.nasa.gov/?planets\#elem<br/>
     * Status: CONF<br/>
     * Unit: au<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean orbital semi-major axis of Pluto, at the standard epoch J2000.0. The mean orbital semi-major axis is associated with a mean orbit solution from a 250-year least-squares fit of JPL's DE405 ephemeris to a Keplerian orbit covering the interval of years 1800 AD - 2050 AD. The orbital element is referenced to the mean ecliptic and equinox of J2000 at the standard epoch J2000.0; linear rates and fit errors can be found in the reference document", 
     source = "E.M. Standish, 16 February 2006, 'Keplerian Elements for Approximate Positions of the Major Planets', http://ssd.jpl.nasa.gov/?planets\\#elem", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "au") 
    public static final double PLUTOSYSTEM_ORBITALSEMIMAJORAXIS_J2000; static { PLUTOSYSTEM_ORBITALSEMIMAJORAXIS_J2000 = 39.48211675; } // [au] 

    /**
     * Mean orbital eccentricity of Pluto, at the standard epoch J2000.0. The mean orbital eccentricity is associated with a mean orbit solution from a 250-year least-squares fit of JPL's DE405 ephemeris to a Keplerian orbit covering the interval of years 1800 AD - 2050 AD. The orbital element is referenced to the mean ecliptic and equinox of J2000 at the standard epoch J2000.0; linear rates and fit errors can be found in the reference document    
     * <p>
     * Source: E.M. Standish, 16 February 2006, 'Keplerian Elements for Approximate Positions of the Major Planets', http://ssd.jpl.nasa.gov/?planets\#elem<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean orbital eccentricity of Pluto, at the standard epoch J2000.0. The mean orbital eccentricity is associated with a mean orbit solution from a 250-year least-squares fit of JPL's DE405 ephemeris to a Keplerian orbit covering the interval of years 1800 AD - 2050 AD. The orbital element is referenced to the mean ecliptic and equinox of J2000 at the standard epoch J2000.0; linear rates and fit errors can be found in the reference document", 
     source = "E.M. Standish, 16 February 2006, 'Keplerian Elements for Approximate Positions of the Major Planets', http://ssd.jpl.nasa.gov/?planets\\#elem", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double PLUTOSYSTEM_ORBITALECCENTRICITY_J2000; static { PLUTOSYSTEM_ORBITALECCENTRICITY_J2000 = 0.24882730; } 

    /**
     * Mean orbital inclination of Pluto, at the standard epoch J2000.0. The mean orbital inclination is is associated with a mean orbit solution from a 250-year least-squares fit of JPL's DE405 ephemeris to a Keplerian orbit covering the interval of years 1800 AD - 2050 AD. The orbital element is referenced to the mean ecliptic and equinox of J2000 at the standard epoch J2000.0; linear rates and fit errors can be found in the reference document    
     * <p>
     * Source: E.M. Standish, 16 February 2006, 'Keplerian Elements for Approximate Positions of the Major Planets', http://ssd.jpl.nasa.gov/?planets\#elem<br/>
     * Status: CONF<br/>
     * Unit: deg<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean orbital inclination of Pluto, at the standard epoch J2000.0. The mean orbital inclination is is associated with a mean orbit solution from a 250-year least-squares fit of JPL's DE405 ephemeris to a Keplerian orbit covering the interval of years 1800 AD - 2050 AD. The orbital element is referenced to the mean ecliptic and equinox of J2000 at the standard epoch J2000.0; linear rates and fit errors can be found in the reference document", 
     source = "E.M. Standish, 16 February 2006, 'Keplerian Elements for Approximate Positions of the Major Planets', http://ssd.jpl.nasa.gov/?planets\\#elem", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "deg") 
    public static final double PLUTOSYSTEM_ORBITALINCLINATION_J2000; static { PLUTOSYSTEM_ORBITALINCLINATION_J2000 = 17.14001206; } // [deg] 

    /**
     * Radial-velocity amplitude of the Sun induced by the Pluto system for 'an edge-on observer' (i.e., an observer in the orbital plane of the Pluto system)    
     * <p>
     * Source: E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 1.4, Equation 1.18, page 9<br/>
     * Status: CONF<br/>
     * Unit: m s^-1<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Radial-velocity amplitude of the Sun induced by the Pluto system for 'an edge-on observer' (i.e., an observer in the orbital plane of the Pluto system)", 
     source = "E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 1.4, Equation 1.18, page 9", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m s^-1") 
    public static final double PLUTOSYSTEM_RADIALVELOCITYSIGNATURE; static { PLUTOSYSTEM_RADIALVELOCITYSIGNATURE = 3.58e-5; } // [m s^-1] 

    /**
     * Sidereal orbital period    
     * <p>
     * Source: Values derived from the mean longitude rates in Table 5.8.1 in P.K. Seidelmann, 1992, 'Explanatory Supplement to the Astronomical Almanac', University Science Books, Mill Valley, Ca., ISBN 0-935702-68-7, page 316; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par<br/>
     * Status: CONF<br/>
     * Unit: yr<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Sidereal orbital period", 
     source = "Values derived from the mean longitude rates in Table 5.8.1 in P.K. Seidelmann, 1992, 'Explanatory Supplement to the Astronomical Almanac', University Science Books, Mill Valley, Ca., ISBN 0-935702-68-7, page 316; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "yr") 
    public static final double PLUTOSYSTEM_ORBITALPERIOD; static { PLUTOSYSTEM_ORBITALPERIOD = 247.92065; } // [yr] 

    /**
     * Astrometric signature of the Sun induced by the Pluto system for an observer located at a distance of 10 pc from the Sun    
     * <p>
     * Source: E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 1.7, Equation 1.22, page 11<br/>
     * Status: CONF<br/>
     * Unit: 10^-6 arcsec<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Astrometric signature of the Sun induced by the Pluto system for an observer located at a distance of 10 pc from the Sun", 
     source = "E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 1.7, Equation 1.22, page 11", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "10^-6 arcsec") 
    public static final double PLUTOSYSTEM_ASTROMETRICSIGNATURE_10PARSEC; static { PLUTOSYSTEM_ASTROMETRICSIGNATURE_10PARSEC = 0.029; } // [10^-6 arcsec] 

    /**
     * General relativistic standard PPN parameter \alpha_1, quantifying prefered-frame effects    
     * <p>
     * Source: E.g., C.M. Will, 2006, 'The Confrontation between General Relativity and Experiment', Living Reviews in Relativity, Section 3.2 'The parametrized post-Newtonian formalism', http://www.livingreviews.org/lrr-2006-3<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "General relativistic standard PPN parameter \\alpha_1, quantifying prefered-frame effects", 
     source = "E.g., C.M. Will, 2006, 'The Confrontation between General Relativity and Experiment', Living Reviews in Relativity, Section 3.2 'The parametrized post-Newtonian formalism', http://www.livingreviews.org/lrr-2006-3", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double PPN_ALPHA_1; static { PPN_ALPHA_1 = 0.; } 

    /**
     * General relativistic standard PPN parameter \alpha_2, quantifying prefered-frame effects    
     * <p>
     * Source: E.g., C.M. Will, 2006, 'The Confrontation between General Relativity and Experiment', Living Reviews in Relativity, Section 3.2 'The parametrized post-Newtonian formalism', http://www.livingreviews.org/lrr-2006-3<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "General relativistic standard PPN parameter \\alpha_2, quantifying prefered-frame effects", 
     source = "E.g., C.M. Will, 2006, 'The Confrontation between General Relativity and Experiment', Living Reviews in Relativity, Section 3.2 'The parametrized post-Newtonian formalism', http://www.livingreviews.org/lrr-2006-3", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double PPN_ALPHA_2; static { PPN_ALPHA_2 = 0.; } 

    /**
     * General relativistic standard PPN parameter \alpha_3, quantifying prefered-frame effects    
     * <p>
     * Source: E.g., C.M. Will, 2006, 'The Confrontation between General Relativity and Experiment', Living Reviews in Relativity, Section 3.2 'The parametrized post-Newtonian formalism', http://www.livingreviews.org/lrr-2006-3<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "General relativistic standard PPN parameter \\alpha_3, quantifying prefered-frame effects", 
     source = "E.g., C.M. Will, 2006, 'The Confrontation between General Relativity and Experiment', Living Reviews in Relativity, Section 3.2 'The parametrized post-Newtonian formalism', http://www.livingreviews.org/lrr-2006-3", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double PPN_ALPHA_3; static { PPN_ALPHA_3 = 0.; } 

    /**
     * General relativistic standard PPN parameter \beta, quantifying non-linearity in the gravitational superposition law    
     * <p>
     * Source: E.g., C.M. Will, 2006, 'The Confrontation between General Relativity and Experiment', Living Reviews in Relativity, Section 3.2 'The parametrized post-Newtonian formalism', http://www.livingreviews.org/lrr-2006-3<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "General relativistic standard PPN parameter \\beta, quantifying non-linearity in the gravitational superposition law", 
     source = "E.g., C.M. Will, 2006, 'The Confrontation between General Relativity and Experiment', Living Reviews in Relativity, Section 3.2 'The parametrized post-Newtonian formalism', http://www.livingreviews.org/lrr-2006-3", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double PPN_BETA; static { PPN_BETA = 1.; } 

    /**
     * General relativistic standard PPN parameter \gamma, quantifying space curvature per unit rest mass    
     * <p>
     * Source: E.g., C.M. Will, 2006, 'The Confrontation between General Relativity and Experiment', Living Reviews in Relativity, Section 3.2 'The parametrized post-Newtonian formalism', http://www.livingreviews.org/lrr-2006-3<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "General relativistic standard PPN parameter \\gamma, quantifying space curvature per unit rest mass", 
     source = "E.g., C.M. Will, 2006, 'The Confrontation between General Relativity and Experiment', Living Reviews in Relativity, Section 3.2 'The parametrized post-Newtonian formalism', http://www.livingreviews.org/lrr-2006-3", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double PPN_GAMMA; static { PPN_GAMMA = 1.; } 

    /**
     * General relativistic standard PPN parameter \xi, quantifying prefered-location effects    
     * <p>
     * Source: E.g., C.M. Will, 2006, 'The Confrontation between General Relativity and Experiment', Living Reviews in Relativity, Section 3.2 'The parametrized post-Newtonian formalism', http://www.livingreviews.org/lrr-2006-3<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "General relativistic standard PPN parameter \\xi, quantifying prefered-location effects", 
     source = "E.g., C.M. Will, 2006, 'The Confrontation between General Relativity and Experiment', Living Reviews in Relativity, Section 3.2 'The parametrized post-Newtonian formalism', http://www.livingreviews.org/lrr-2006-3", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double PPN_XI; static { PPN_XI = 0.; } 

    /**
     * General relativistic standard PPN parameter \zeta_1, quantifying violation of conservation of total momentum    
     * <p>
     * Source: E.g., C.M. Will, 2006, 'The Confrontation between General Relativity and Experiment', Living Reviews in Relativity, Section 3.2 'The parametrized post-Newtonian formalism', http://www.livingreviews.org/lrr-2006-3<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "General relativistic standard PPN parameter \\zeta_1, quantifying violation of conservation of total momentum", 
     source = "E.g., C.M. Will, 2006, 'The Confrontation between General Relativity and Experiment', Living Reviews in Relativity, Section 3.2 'The parametrized post-Newtonian formalism', http://www.livingreviews.org/lrr-2006-3", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double PPN_ZETA_1; static { PPN_ZETA_1 = 0.; } 

    /**
     * General relativistic standard PPN parameter \zeta_2, quantifying violation of conservation of total momentum    
     * <p>
     * Source: E.g., C.M. Will, 2006, 'The Confrontation between General Relativity and Experiment', Living Reviews in Relativity, Section 3.2 'The parametrized post-Newtonian formalism', http://www.livingreviews.org/lrr-2006-3<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "General relativistic standard PPN parameter \\zeta_2, quantifying violation of conservation of total momentum", 
     source = "E.g., C.M. Will, 2006, 'The Confrontation between General Relativity and Experiment', Living Reviews in Relativity, Section 3.2 'The parametrized post-Newtonian formalism', http://www.livingreviews.org/lrr-2006-3", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double PPN_ZETA_2; static { PPN_ZETA_2 = 0.; } 

    /**
     * General relativistic standard PPN parameter \zeta_3, quantifying violation of conservation of total momentum    
     * <p>
     * Source: E.g., C.M. Will, 2006, 'The Confrontation between General Relativity and Experiment', Living Reviews in Relativity, Section 3.2 'The parametrized post-Newtonian formalism', http://www.livingreviews.org/lrr-2006-3<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "General relativistic standard PPN parameter \\zeta_3, quantifying violation of conservation of total momentum", 
     source = "E.g., C.M. Will, 2006, 'The Confrontation between General Relativity and Experiment', Living Reviews in Relativity, Section 3.2 'The parametrized post-Newtonian formalism', http://www.livingreviews.org/lrr-2006-3", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double PPN_ZETA_3; static { PPN_ZETA_3 = 0.; } 

    /**
     * General relativistic standard PPN parameter \zeta_4, quantifying violation of conservation of total momentum    
     * <p>
     * Source: E.g., C.M. Will, 2006, 'The Confrontation between General Relativity and Experiment', Living Reviews in Relativity, Section 3.2 'The parametrized post-Newtonian formalism', http://www.livingreviews.org/lrr-2006-3<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "General relativistic standard PPN parameter \\zeta_4, quantifying violation of conservation of total momentum", 
     source = "E.g., C.M. Will, 2006, 'The Confrontation between General Relativity and Experiment', Living Reviews in Relativity, Section 3.2 'The parametrized post-Newtonian formalism', http://www.livingreviews.org/lrr-2006-3", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double PPN_ZETA_4; static { PPN_ZETA_4 = 0.; } 

    /**
     * Precession constant m = p cos(\epsilon_0), in s per Julian year, at the standard epoch J2000.0, nowadays irrelevant as a fundamental constant. The precession in right ascension \alpha equals m + n sin(\alpha) tan(\delta); the precession in declination \delta equals n cos(\alpha)    
     * <p>
     * Status: CONF<br/>
     * Unit: s yr^-1<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Precession constant m = p cos(\\epsilon_0), in s per Julian year, at the standard epoch J2000.0, nowadays irrelevant as a fundamental constant. The precession in right ascension \\alpha equals m + n sin(\\alpha) tan(\\delta); the precession in declination \\delta equals n cos(\\alpha)", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "s yr^-1") 
    public static final double PRECESSION_CONSTANT_J2000M; static { PRECESSION_CONSTANT_J2000M = 3.075887; } // [s yr^-1] 

    /**
     * Precession constant n = p sin(\epsilon_0), in arcsec per Julian year, at the standard epoch J2000.0, nowadays irrelevant as a fundamental constant. The precession in right ascension \alpha equals m + n sin(\alpha) tan(\delta); the precession in declination \delta equals n cos(\alpha)    
     * <p>
     * Status: CONF<br/>
     * Unit: arcsec yr^-1<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Precession constant n = p sin(\\epsilon_0), in arcsec per Julian year, at the standard epoch J2000.0, nowadays irrelevant as a fundamental constant. The precession in right ascension \\alpha equals m + n sin(\\alpha) tan(\\delta); the precession in declination \\delta equals n cos(\\alpha)", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "arcsec yr^-1") 
    public static final double PRECESSION_CONSTANT_J2000N; static { PRECESSION_CONSTANT_J2000N = 20.003394; } // [arcsec yr^-1] 

    /**
     * Speed of general precession in ecliptic longitude, in arcsec per Julian century, at the standard epoch J2000.0, nowadays irrelevant as a fundamental constant    
     * <p>
     * Source: N. Capitaine, P.T. Wallace, J. Chapront, 2003, 'Expressions for IAU 2000 precession quantities', A&A, 412, 567-586, 'P03 solution'<br/>
     * Status: CONF<br/>
     * Unit: arcsec cy^-1<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Speed of general precession in ecliptic longitude, in arcsec per Julian century, at the standard epoch J2000.0, nowadays irrelevant as a fundamental constant", 
     source = "N. Capitaine, P.T. Wallace, J. Chapront, 2003, 'Expressions for IAU 2000 precession quantities', A&A, 412, 567-586, 'P03 solution'", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "arcsec cy^-1") 
    public static final double PRECESSIONLONGITUDE_CONSTANT_J2000; static { PRECESSIONLONGITUDE_CONSTANT_J2000 = 5028.796195; } // [arcsec cy^-1] 

    /**
     * Proper-motion conversion constant A_v = 4.74... km yr s^-1 (see ESA, 1997, 'The Hipparcos and Tycho Catalogues', ESA SP-1200, Volume 1, page 25, Table 1.2.2)    
     * <p>
     * Status: CONF<br/>
     * Unit: km yr s^-1<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Proper-motion conversion constant A_v = 4.74... km yr s^-1 (see ESA, 1997, 'The Hipparcos and Tycho Catalogues', ESA SP-1200, Volume 1, page 25, Table 1.2.2)", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "km yr s^-1") 
    public static final double PROPERMOTION_CONSTANT; static { PROPERMOTION_CONSTANT = 4.740470464; } // [km yr s^-1] 

    /**
     * Composite (unweighted-mean) zero-redshift quasar (QSO) spectrum, based on 949 LBQS QSOs, 191 2MASS AGN, 37 Hamburg-ESO QSOs, and 18 PG QSOs. First column: wavelength \lambda (in nm; from 96.10 to 932.85). Second column: unnormalised flux density f_\lambda (in W m^-2 nm^-1)    
     * <p>
     * Source: P.J. Francis, et al., 1991, 'A high signal-to-noise ratio composite quasar spectrum', Astrophysical Journal (ApJ), 373, 465<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: false
     */
    @ParamMetaData (
    description = "Composite (unweighted-mean) zero-redshift quasar (QSO) spectrum, based on 949 LBQS QSOs, 191 2MASS AGN, 37 Hamburg-ESO QSOs, and 18 PG QSOs. First column: wavelength \\lambda (in nm; from 96.10 to 932.85). Second column: unnormalised flux density f_\\lambda (in W m^-2 nm^-1)", 
     source = "P.J. Francis, et al., 1991, 'A high signal-to-noise ratio composite quasar spectrum', Astrophysical Journal (ApJ), 373, 465", 
     status = "CONF", 
     basic = true, 
     scalar = false, 
     unit = "") 
    public static final String QSO_SPECTRUM_LAMBDA; static { QSO_SPECTRUM_LAMBDA = "Nature/QSO_Spectrum_Lambda_001.fits"; } 

    /**
     * One radian in units of degrees    
     * <p>
     * Status: CONF<br/>
     * Unit: deg<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "One radian in units of degrees", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "deg") 
    public static final double RADIAN_DEGREE; static { RADIAN_DEGREE = 5.729577951308232e+1; } // [deg] 

    /**
     * One radian in units of arcseconds    
     * <p>
     * Status: CONF<br/>
     * Unit: arcsec<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "One radian in units of arcseconds", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "arcsec") 
    public static final double RADIAN_ARCSECOND; static { RADIAN_ARCSECOND = 2.062648062470964e+5; } // [arcsec] 

    /**
     * One radian in units of milli-arcseconds    
     * <p>
     * Status: CONF<br/>
     * Unit: milli-arcsec<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "One radian in units of milli-arcseconds", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "milli-arcsec") 
    public static final double RADIAN_MILLIARCSECOND; static { RADIAN_MILLIARCSECOND = 2.062648062470964e+8; } // [milli-arcsec] 

    /**
     * One radian in units of micro-arcseconds    
     * <p>
     * Status: CONF<br/>
     * Unit: micro-arcsec<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "One radian in units of micro-arcseconds", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "micro-arcsec") 
    public static final double RADIAN_MICROARCSECOND; static { RADIAN_MICROARCSECOND = 2.062648062470964e+11; } // [micro-arcsec] 

    /**
     * First radiation constant. Note: best-measured value equals 3.741771790E-16 (P.J. Mohr, B.N. Taylor, D.B. Newell, 9 July 2015, 'The 2014 CODATA Recommended Values of the Fundamental Physical Constants', National Institute of Standards and Technology, Gaithersburg, MD 20899-8401; http://www.codata.org/ and http://physics.nist.gov/constants (Web Version 7.0))    
     * <p>
     * Status: CONF<br/>
     * Unit: W m^2<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "First radiation constant. Note: best-measured value equals 3.741771790E-16 (P.J. Mohr, B.N. Taylor, D.B. Newell, 9 July 2015, 'The 2014 CODATA Recommended Values of the Fundamental Physical Constants', National Institute of Standards and Technology, Gaithersburg, MD 20899-8401; http://www.codata.org/ and http://physics.nist.gov/constants (Web Version 7.0))", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "W m^2") 
    public static final double RADIATION_CONSTANT_FIRST; static { RADIATION_CONSTANT_FIRST = 3.7417717901e-16; } // [W m^2] 

    /**
     * Second radiation constant. Note: best-measured value equals 1.43877736E-2 (P.J. Mohr, B.N. Taylor, D.B. Newell, 9 July 2015, 'The 2014 CODATA Recommended Values of the Fundamental Physical Constants', National Institute of Standards and Technology, Gaithersburg, MD 20899-8401; http://www.codata.org/ and http://physics.nist.gov/constants (Web Version 7.0))    
     * <p>
     * Status: CONF<br/>
     * Unit: m K<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Second radiation constant. Note: best-measured value equals 1.43877736E-2 (P.J. Mohr, B.N. Taylor, D.B. Newell, 9 July 2015, 'The 2014 CODATA Recommended Values of the Fundamental Physical Constants', National Institute of Standards and Technology, Gaithersburg, MD 20899-8401; http://www.codata.org/ and http://physics.nist.gov/constants (Web Version 7.0))", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m K") 
    public static final double RADIATION_CONSTANT_SECOND; static { RADIATION_CONSTANT_SECOND = 1.438777364e-2; } // [m K] 

    /**
     * Radiation constant, also known as radiation-density constant, linking the energy density u (= 4 Pi I / c) of black-body radiation and temperature T via u = a T^4    
     * <p>
     * Source: E.g., H. Karttunen, et al., 1987, 'Fundamental Astronomy', Springer Verlag, Berlin, Section 11.2, page 247 or R. Kippenhahn, A. Weigert, 1991, 'Stellar structure and evolution' (corrected 2-nd printing), Springer Verlag, Berlin, Section 3.1, page 16, and Section 5.1.2, page 28<br/>
     * Status: CONF<br/>
     * Unit: J m^-3 K^-4<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Radiation constant, also known as radiation-density constant, linking the energy density u (= 4 Pi I / c) of black-body radiation and temperature T via u = a T^4", 
     source = "E.g., H. Karttunen, et al., 1987, 'Fundamental Astronomy', Springer Verlag, Berlin, Section 11.2, page 247 or R. Kippenhahn, A. Weigert, 1991, 'Stellar structure and evolution' (corrected 2-nd printing), Springer Verlag, Berlin, Section 3.1, page 16, and Section 5.1.2, page 28", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "J m^-3 K^-4") 
    public static final double RADIATION_CONSTANT; static { RADIATION_CONSTANT = 7.5657229e-16; } // [J m^-3 K^-4] 

    /**
     * The origin of TCB is defined in terms of TAI: the reading of TCB on 1 January 1977, 00:00:00 TAI = JD2443144.5 TAI must be 1 January 1977, 00:00:32.184 TCB = JD2443144.5003725 TCB. This origin has been arbitrarily set so that TCB coincides with TT at the geocentre on 1 January 1977, 00:00:00 TAI    
     * <p>
     * Source: IAU, July 1991, 'Recommendations from the Working Group on Reference Systems', IAU 1991 Resolution A4, Recommendation 4, adopted at the XXI-st General Assembly of the IAU. See, for example, M. Soffel, et al., 1 December 2003, 'The IAU 2000 resolutions for astrometry, celestial mechanics, and metrology in the relativistic framework: explanatory supplement', AJ, 126, 2687-2706<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "The origin of TCB is defined in terms of TAI: the reading of TCB on 1 January 1977, 00:00:00 TAI = JD2443144.5 TAI must be 1 January 1977, 00:00:32.184 TCB = JD2443144.5003725 TCB. This origin has been arbitrarily set so that TCB coincides with TT at the geocentre on 1 January 1977, 00:00:00 TAI", 
     source = "IAU, July 1991, 'Recommendations from the Working Group on Reference Systems', IAU 1991 Resolution A4, Recommendation 4, adopted at the XXI-st General Assembly of the IAU. See, for example, M. Soffel, et al., 1 December 2003, 'The IAU 2000 resolutions for astrometry, celestial mechanics, and metrology in the relativistic framework: explanatory supplement', AJ, 126, 2687-2706", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final String REFERENCEEPOCH_TCB; static { REFERENCEEPOCH_TCB = "JD2443144.5003725 TCB"; } 

    /**
     * The origin of TCG is defined in terms of TAI: the reading of TCG on 1 January 1977, 00:00:00 TAI = JD2443144.5 TAI must be 1 January 1977, 00:00:32.184 TCG = JD2443144.5003725 TCG. This origin has been arbitrarily set so that TCG coincides with TT at the geocentre on 1 January 1977, 00:00:00 TAI    
     * <p>
     * Source: IAU, July 1991, 'Recommendations from the Working Group on Reference Systems', IAU 1991 Resolution A4, Recommendation 4, adopted at the XXI-st General Assembly of the IAU. See, for example, M. Soffel, et al., 1 December 2003, 'The IAU 2000 resolutions for astrometry, celestial mechanics, and metrology in the relativistic framework: explanatory supplement', AJ, 126, 2687-2706<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "The origin of TCG is defined in terms of TAI: the reading of TCG on 1 January 1977, 00:00:00 TAI = JD2443144.5 TAI must be 1 January 1977, 00:00:32.184 TCG = JD2443144.5003725 TCG. This origin has been arbitrarily set so that TCG coincides with TT at the geocentre on 1 January 1977, 00:00:00 TAI", 
     source = "IAU, July 1991, 'Recommendations from the Working Group on Reference Systems', IAU 1991 Resolution A4, Recommendation 4, adopted at the XXI-st General Assembly of the IAU. See, for example, M. Soffel, et al., 1 December 2003, 'The IAU 2000 resolutions for astrometry, celestial mechanics, and metrology in the relativistic framework: explanatory supplement', AJ, 126, 2687-2706", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final String REFERENCEEPOCH_TCG; static { REFERENCEEPOCH_TCG = "JD2443144.5003725 TCG"; } 

    /**
     * IAU 2006 Resolution B3, entitled 'Re-definition of Barycentric Dynamical Time, TDB', recommends that 'TDB be defined as the following linear transformation of TCB: TDB = TCB - L_B x ( JD_TCB - T_0 ) x 86400 + TDB_0, where T_0 = 2443144.5003725 (parameter :Nature:ReferenceEpoch_TCB), and L_B = 1.550519768E-8 (parameter :Nature:LSubB_Constant) and TDB_0 = -6.55E-5 s are defining constants'. The number 86400 is equal to parameter :Nature:Day_Second    
     * <p>
     * Source: IAU, August 2006, 'Re-definition of Barycentric Dynamical Time, TDB', IAU 2006 Resolution 3 adopted at the XXVI-th General Assembly of the IAU. See also the IAU (2009) System of Astronomical Constants (IAU, August 2009, 'IAU 2009 Astronomical Constants', IAU 2009 Resolution B2 adopted at the XXVII-th General Assembly of the IAU. See also IAU, 10 August 2009, 'IAU WG on NSFA Current Best Estimates', http://maia.usno.navy.mil/NSFA/NSFA_cbe.html)<br/>
     * Status: CONF<br/>
     * Unit: s<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "IAU 2006 Resolution B3, entitled 'Re-definition of Barycentric Dynamical Time, TDB', recommends that 'TDB be defined as the following linear transformation of TCB: TDB = TCB - L_B x ( JD_TCB - T_0 ) x 86400 + TDB_0, where T_0 = 2443144.5003725 (parameter :Nature:ReferenceEpoch_TCB), and L_B = 1.550519768E-8 (parameter :Nature:LSubB_Constant) and TDB_0 = -6.55E-5 s are defining constants'. The number 86400 is equal to parameter :Nature:Day_Second", 
     source = "IAU, August 2006, 'Re-definition of Barycentric Dynamical Time, TDB', IAU 2006 Resolution 3 adopted at the XXVI-th General Assembly of the IAU. See also the IAU (2009) System of Astronomical Constants (IAU, August 2009, 'IAU 2009 Astronomical Constants', IAU 2009 Resolution B2 adopted at the XXVII-th General Assembly of the IAU. See also IAU, 10 August 2009, 'IAU WG on NSFA Current Best Estimates', http://maia.usno.navy.mil/NSFA/NSFA_cbe.html)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "s") 
    public static final double REFERENCEEPOCH_TDBSUBZERO; static { REFERENCEEPOCH_TDBSUBZERO = -6.550e-5; } // [s] 

    /**
     * Rydberg constant. Note: best-measured value equals 10973731.568508 (P.J. Mohr, B.N. Taylor, D.B. Newell, 9 July 2015, 'The 2014 CODATA Recommended Values of the Fundamental Physical Constants', National Institute of Standards and Technology, Gaithersburg, MD 20899-8401; http://www.codata.org/ and http://physics.nist.gov/constants (Web Version 7.0))    
     * <p>
     * Status: CONF<br/>
     * Unit: m^-1<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Rydberg constant. Note: best-measured value equals 10973731.568508 (P.J. Mohr, B.N. Taylor, D.B. Newell, 9 July 2015, 'The 2014 CODATA Recommended Values of the Fundamental Physical Constants', National Institute of Standards and Technology, Gaithersburg, MD 20899-8401; http://www.codata.org/ and http://physics.nist.gov/constants (Web Version 7.0))", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m^-1") 
    public static final double RYDBERG_CONSTANT; static { RYDBERG_CONSTANT = 10973731.570551; } // [m^-1] 

    /**
     * Chebyshev representation of the ephemerides of Saturn, with origin at the barycentre of the solar system (BCRS), in the equatorial ICRF frame. The ephemeris covers the period starting on JD (JDBEGIP + JDBEGFP) and ending on JD (JDENDIP + JDENDFP) for the position and starting on JD (JDBEGIV + JDBEGFV) and ending on JD (JDENDIV + JDENDFV) for the velocity. A number of Chebyshev coefficients equal to ORDERSP is given for NSSP time intervals of SPANSP days to describe the position-vector components in units of m; the similar parameters ending with PP (Peculiar Position) are not used in the current release and are reserved for future usage. A number of Chebyshev coefficients equal to ORDERSV is given for NSSV time intervals of SPANSV days to describe the velocity-vector components in units of m s^-1; the similar parameters ending with PV (Peculiar Velocity) are not used in the current release and are reserved for future usage. The first three HDUs contain the coefficients for the three components of the position, while the last three HDUs contain the coefficients for the three components of the velocity    
     * <p>
     * Source: A. Fienga, J. Laskar, H. Manche, M. Gastineau, 19 April 2007, 'Solar system planetary ephemeris delivery: INPOP06', GAIA-CA-TN-IMC-AF-001, issue 1, revision 0<br/>
     * Status: DEPR<br/>
     * Basic : true<br/>
     * Scalar: false
     */
    @ParamMetaData (
    description = "Chebyshev representation of the ephemerides of Saturn, with origin at the barycentre of the solar system (BCRS), in the equatorial ICRF frame. The ephemeris covers the period starting on JD (JDBEGIP + JDBEGFP) and ending on JD (JDENDIP + JDENDFP) for the position and starting on JD (JDBEGIV + JDBEGFV) and ending on JD (JDENDIV + JDENDFV) for the velocity. A number of Chebyshev coefficients equal to ORDERSP is given for NSSP time intervals of SPANSP days to describe the position-vector components in units of m; the similar parameters ending with PP (Peculiar Position) are not used in the current release and are reserved for future usage. A number of Chebyshev coefficients equal to ORDERSV is given for NSSV time intervals of SPANSV days to describe the velocity-vector components in units of m s^-1; the similar parameters ending with PV (Peculiar Velocity) are not used in the current release and are reserved for future usage. The first three HDUs contain the coefficients for the three components of the position, while the last three HDUs contain the coefficients for the three components of the velocity", 
     source = "A. Fienga, J. Laskar, H. Manche, M. Gastineau, 19 April 2007, 'Solar system planetary ephemeris delivery: INPOP06', GAIA-CA-TN-IMC-AF-001, issue 1, revision 0", 
     status = "DEPR", 
     basic = true, 
     scalar = false, 
     unit = "") 
    public static final String SATURN_EPHEMERIS; static { SATURN_EPHEMERIS = "Nature/Saturn_Ephemeris_004.fits"; } 

    /**
     * IAU-recommended value for the right ascension \alpha_0 of the north pole of rotation of Saturn. The pair (\alpha_0, \delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \alpha_0 = 273.85 deg and \delta_0 = 66.99 degrees    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)<br/>
     * Status: CONF<br/>
     * Unit: deg<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "IAU-recommended value for the right ascension \\alpha_0 of the north pole of rotation of Saturn. The pair (\\alpha_0, \\delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \\alpha_0 = 273.85 deg and \\delta_0 = 66.99 degrees", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "deg") 
    public static final double SATURN_NORTHROTATIONALPOLE_RIGHTASCENSION; static { SATURN_NORTHROTATIONALPOLE_RIGHTASCENSION = 40.589; } // [deg] 

    /**
     * IAU-recommended value for the rate of change (in degrees per Julian day, calculated from the standard epoch) of the right ascension \alpha_0 of the north pole of rotation of Saturn. The pair (\alpha_0, \delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \alpha_0 = 273.85 deg and \delta_0 = 66.99 degrees    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)<br/>
     * Status: CONF<br/>
     * Unit: deg day^-1<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "IAU-recommended value for the rate of change (in degrees per Julian day, calculated from the standard epoch) of the right ascension \\alpha_0 of the north pole of rotation of Saturn. The pair (\\alpha_0, \\delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \\alpha_0 = 273.85 deg and \\delta_0 = 66.99 degrees", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "deg day^-1") 
    public static final double SATURN_NORTHROTATIONALPOLE_RIGHTASCENSIONRATEOFCHANGE; static { SATURN_NORTHROTATIONALPOLE_RIGHTASCENSIONRATEOFCHANGE = -0.00000099; } // [deg day^-1] 

    /**
     * IAU-recommended value for the declination \delta_0 of the north pole of rotation of Saturn. The pair (\alpha_0, \delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \alpha_0 = 273.85 deg and \delta_0 = 66.99 degrees    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)<br/>
     * Status: CONF<br/>
     * Unit: deg<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "IAU-recommended value for the declination \\delta_0 of the north pole of rotation of Saturn. The pair (\\alpha_0, \\delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \\alpha_0 = 273.85 deg and \\delta_0 = 66.99 degrees", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "deg") 
    public static final double SATURN_NORTHROTATIONALPOLE_DECLINATION; static { SATURN_NORTHROTATIONALPOLE_DECLINATION = 83.537; } // [deg] 

    /**
     * IAU-recommended value for the rate of change (in degrees per Julian day, calculated from the standard epoch) of the declination \delta_0 of the north pole of rotation of Saturn. The pair (\alpha_0, \delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \alpha_0 = 273.85 deg and \delta_0 = 66.99 degrees    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)<br/>
     * Status: CONF<br/>
     * Unit: deg day^-1<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "IAU-recommended value for the rate of change (in degrees per Julian day, calculated from the standard epoch) of the declination \\delta_0 of the north pole of rotation of Saturn. The pair (\\alpha_0, \\delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \\alpha_0 = 273.85 deg and \\delta_0 = 66.99 degrees", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "deg day^-1") 
    public static final double SATURN_NORTHROTATIONALPOLE_DECLINATIONRATEOFCHANGE; static { SATURN_NORTHROTATIONALPOLE_DECLINATIONRATEOFCHANGE = -0.00000011; } // [deg day^-1] 

    /**
     * IAU-recommended value for the ephemeris position of the prime meridian of Saturn. The prime meridian refers to the rotation of the magnetic field System III. The location of the prime meridian is specified by the angle that is measured along the planet's equator in an easterly direction with respect to the planet's north pole from the node Q (located at right ascension 90 deg + \alpha_0, where \alpha_0 denotes the right ascension of the north pole of rotation) of the planet's equator on the standard equator to the point B where the prime meridian crosses the planet's equator. The right ascension of the point Q is 90 deg + \alpha_0 and the inclination of the planet's equator to the standard equator is 90 deg - \delta_0, where \delta_0 denotes the declination of the north pole of rotation. (The pair (\alpha_0, \delta_0) denotes the standard equatorial coordinates, with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB), of the north pole of rotation, which itself is defined as that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \alpha_0 = 273.85 deg and \delta_0 = 66.99 degrees.) Because the prime meridian is assumed to rotate uniformly with the planet, W accordingly varies linearly with time. In addition, \alpha_0, \delta_0, and W may vary with time due to a precession of the axis of rotation of the planet. If W increases with time, the planet has a direct (or prograde) rotation; if W decreases with time, the rotation is said to be retrograde    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)<br/>
     * Status: CONF<br/>
     * Unit: deg<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "IAU-recommended value for the ephemeris position of the prime meridian of Saturn. The prime meridian refers to the rotation of the magnetic field System III. The location of the prime meridian is specified by the angle that is measured along the planet's equator in an easterly direction with respect to the planet's north pole from the node Q (located at right ascension 90 deg + \\alpha_0, where \\alpha_0 denotes the right ascension of the north pole of rotation) of the planet's equator on the standard equator to the point B where the prime meridian crosses the planet's equator. The right ascension of the point Q is 90 deg + \\alpha_0 and the inclination of the planet's equator to the standard equator is 90 deg - \\delta_0, where \\delta_0 denotes the declination of the north pole of rotation. (The pair (\\alpha_0, \\delta_0) denotes the standard equatorial coordinates, with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB), of the north pole of rotation, which itself is defined as that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \\alpha_0 = 273.85 deg and \\delta_0 = 66.99 degrees.) Because the prime meridian is assumed to rotate uniformly with the planet, W accordingly varies linearly with time. In addition, \\alpha_0, \\delta_0, and W may vary with time due to a precession of the axis of rotation of the planet. If W increases with time, the planet has a direct (or prograde) rotation; if W decreases with time, the rotation is said to be retrograde", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "deg") 
    public static final double SATURN_PRIMEMERIDIAN_EPHEMERISPOSITION; static { SATURN_PRIMEMERIDIAN_EPHEMERISPOSITION = 38.90; } // [deg] 

    /**
     * IAU-recommended value for the rate of change (in degrees per Julian day, calculated from the standard epoch of 1.5 January 2000 = JD2451545.0 TDB) of the ephemeris position of the prime meridian of Saturn. The prime meridian refers to the rotation of the magnetic field System III. The location of the prime meridian is specified by the angle that is measured along the planet's equator in an easterly direction with respect to the planet's north pole from the node Q (located at right ascension 90 deg + \alpha_0, where \alpha_0 denotes the right ascension of the north pole of rotation) of the planet's equator on the standard equator to the point B where the prime meridian crosses the planet's equator. The right ascension of the point Q is 90 deg + \alpha_0 and the inclination of the planet's equator to the standard equator is 90 deg - \delta_0, where \delta_0 denotes the declination of the north pole of rotation. (The pair (\alpha_0, \delta_0) denotes the standard equatorial coordinates, with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB), of the north pole of rotation, which itself is defined as that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \alpha_0 = 273.85 deg and \delta_0 = 66.99 degrees.) Because the prime meridian is assumed to rotate uniformly with the planet, W accordingly varies linearly with time. In addition, \alpha_0, \delta_0, and W may vary with time due to a precession of the axis of rotation of the planet. If W increases with time, the planet has a direct (or prograde) rotation; if W decreases with time, the rotation is said to be retrograde    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)<br/>
     * Status: CONF<br/>
     * Unit: deg day^-1<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "IAU-recommended value for the rate of change (in degrees per Julian day, calculated from the standard epoch of 1.5 January 2000 = JD2451545.0 TDB) of the ephemeris position of the prime meridian of Saturn. The prime meridian refers to the rotation of the magnetic field System III. The location of the prime meridian is specified by the angle that is measured along the planet's equator in an easterly direction with respect to the planet's north pole from the node Q (located at right ascension 90 deg + \\alpha_0, where \\alpha_0 denotes the right ascension of the north pole of rotation) of the planet's equator on the standard equator to the point B where the prime meridian crosses the planet's equator. The right ascension of the point Q is 90 deg + \\alpha_0 and the inclination of the planet's equator to the standard equator is 90 deg - \\delta_0, where \\delta_0 denotes the declination of the north pole of rotation. (The pair (\\alpha_0, \\delta_0) denotes the standard equatorial coordinates, with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB), of the north pole of rotation, which itself is defined as that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \\alpha_0 = 273.85 deg and \\delta_0 = 66.99 degrees.) Because the prime meridian is assumed to rotate uniformly with the planet, W accordingly varies linearly with time. In addition, \\alpha_0, \\delta_0, and W may vary with time due to a precession of the axis of rotation of the planet. If W increases with time, the planet has a direct (or prograde) rotation; if W decreases with time, the rotation is said to be retrograde", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "deg day^-1") 
    public static final double SATURN_PRIMEMERIDIAN_EPHEMERISPOSITIONRATEOFCHANGE; static { SATURN_PRIMEMERIDIAN_EPHEMERISPOSITIONRATEOFCHANGE = 810.7939024; } // [deg day^-1] 

    /**
     * Mass of Saturn (do not use for high-precision (orbit) calculations)    
     * <p>
     * Source: R.A. Jacobson, et al., 2006, 'The gravity field of the Saturnian system from satellite observations and spacecraft tracking data', AJ, 132, 2520-2526; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par<br/>
     * Status: CONF<br/>
     * Unit: kg<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mass of Saturn (do not use for high-precision (orbit) calculations)", 
     source = "R.A. Jacobson, et al., 2006, 'The gravity field of the Saturnian system from satellite observations and spacecraft tracking data', AJ, 132, 2520-2526; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "kg") 
    public static final double SATURN_MASS; static { SATURN_MASS = 5.683190e+26; } // [kg] 

    /**
     * Mean volumetric radius of Saturn    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A); see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par<br/>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean volumetric radius of Saturn", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A); see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "m") 
    public static final double SATURN_VOLUMETRICRADIUS; static { SATURN_VOLUMETRICRADIUS = 5.82320e+7; } // [m] 

    /**
     * Equatorial radius of Saturn    
     * <p>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Equatorial radius of Saturn", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m") 
    public static final double SATURN_EQUATORIALRADIUS; static { SATURN_EQUATORIALRADIUS = 6.02680e+7; } // [m] 

    /**
     * Polar radius of Saturn    
     * <p>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Polar radius of Saturn", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m") 
    public static final double SATURN_POLARRADIUS; static { SATURN_POLARRADIUS = 5.43640e+7; } // [m] 

    /**
     * V(1,0) magnitude of Saturn (i.e., the visual magnitude of the planet reduced to a distance of 1 au from both the Sun and Earth and phase angle zero). This parameter is also refered to as absolute magnitude in planetary sciences. The magnitude refers to the planetary disk only    
     * <p>
     * Source: P.K. Seidelmann, 1992, 'Explanatory Supplement to the Astronomical Almanac', University Science Books, Mill Valley, Ca., ISBN 0-935702-68-7, Table 15.8 on page 706; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par<br/>
     * Status: CONF<br/>
     * Unit: mag<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "V(1,0) magnitude of Saturn (i.e., the visual magnitude of the planet reduced to a distance of 1 au from both the Sun and Earth and phase angle zero). This parameter is also refered to as absolute magnitude in planetary sciences. The magnitude refers to the planetary disk only", 
     source = "P.K. Seidelmann, 1992, 'Explanatory Supplement to the Astronomical Almanac', University Science Books, Mill Valley, Ca., ISBN 0-935702-68-7, Table 15.8 on page 706; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "mag") 
    public static final double SATURN_VONEZEROMAGNITUDE; static { SATURN_VONEZEROMAGNITUDE = -8.88; } // [mag] 

    /**
     * Geometric albedo of Saturn (i.e., the ratio of the body's brightness at zero phase angle to the brightness of a perfectly diffusing disk with the same position and apparent size as the body)    
     * <p>
     * Source: P.K. Seidelmann, 1992, 'Explanatory Supplement to the Astronomical Almanac', University Science Books, Mill Valley, Ca., ISBN 0-935702-68-7, Table 15.8 on page 706; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Geometric albedo of Saturn (i.e., the ratio of the body's brightness at zero phase angle to the brightness of a perfectly diffusing disk with the same position and apparent size as the body)", 
     source = "P.K. Seidelmann, 1992, 'Explanatory Supplement to the Astronomical Almanac', University Science Books, Mill Valley, Ca., ISBN 0-935702-68-7, Table 15.8 on page 706; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double SATURN_GEOMETRICALBEDO; static { SATURN_GEOMETRICALBEDO = 0.47; } 

    /**
     * Mean mass density of Saturn    
     * <p>
     * Status: CONF<br/>
     * Unit: g cm^-3<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean mass density of Saturn", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "g cm^-3") 
    public static final double SATURN_MASSDENSITY_MEAN; static { SATURN_MASSDENSITY_MEAN = 0.6871; } // [g cm^-3] 

    /**
     * Radius of the smallest hypothetical sphere around Saturn which would encompass the body (this is a low-accuracy parameter used in the relativistic model)    
     * <p>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Radius of the smallest hypothetical sphere around Saturn which would encompass the body (this is a low-accuracy parameter used in the relativistic model)", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m") 
    public static final double SATURN_ENCOMPASSINGSPHERERADIUS; static { SATURN_ENCOMPASSINGSPHERERADIUS = 6.02680e+7; } // [m] 

    /**
     * Dynamical form-factor of Saturn (oblateness or Stokes' second-degree zonal harmonic of the potential)    
     * <p>
     * Source: P.R. Weissman, L.-A. McFadden, T.V. Johnson (eds.), 1999, 'Encyclopedia of the Solar System (first edition)', Academic Press, page 342<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Dynamical form-factor of Saturn (oblateness or Stokes' second-degree zonal harmonic of the potential)", 
     source = "P.R. Weissman, L.-A. McFadden, T.V. Johnson (eds.), 1999, 'Encyclopedia of the Solar System (first edition)', Academic Press, page 342", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double SATURN_JSUB2; static { SATURN_JSUB2 = 0.016331; } 

    /**
     * Geometrical flattening factor f of Saturn (f = (a-b)/a)    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A); see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Geometrical flattening factor f of Saturn (f = (a-b)/a)", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A); see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double SATURN_FLATTENING; static { SATURN_FLATTENING = 9.796240e-2; } 

    /**
     * Post-Newtonian deflection angle of a limb-grazing light ray due to the spherically symmetric part of the gravitational field of Saturn    
     * <p>
     * Source: S.A. Klioner, 2003, 'A Practical Relativistic Model for Microarcsecond Astrometry in Space', AJ, 125, 1580, Equation 64 with cot(x) = cos(x) / sin(x) approximated by x^-1; see also J.H.J. de Bruijne, 19 February 2002, 'Gravitational light deflection', GAIA-JdB-001, issue 1, revision 0<br/>
     * Status: CONF<br/>
     * Unit: 10^-6 arcsec<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Post-Newtonian deflection angle of a limb-grazing light ray due to the spherically symmetric part of the gravitational field of Saturn", 
     source = "S.A. Klioner, 2003, 'A Practical Relativistic Model for Microarcsecond Astrometry in Space', AJ, 125, 1580, Equation 64 with cot(x) = cos(x) / sin(x) approximated by x^-1; see also J.H.J. de Bruijne, 19 February 2002, 'Gravitational light deflection', GAIA-JdB-001, issue 1, revision 0", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "10^-6 arcsec") 
    public static final double SATURN_LIGHTDEFLECTION_LIMB; static { SATURN_LIGHTDEFLECTION_LIMB = 5980.; } // [10^-6 arcsec] 

    /**
     * Geometric transit probability (Saturn transiting the Sun) for an observer external to the solar system    
     * <p>
     * Source: E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 2.1, Equation 2.2, page 14<br/>
     * Status: CONF<br/>
     * Unit: %<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Geometric transit probability (Saturn transiting the Sun) for an observer external to the solar system", 
     source = "E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 2.1, Equation 2.2, page 14", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "%") 
    public static final double SATURN_TRANSITPROBABILITY; static { SATURN_TRANSITPROBABILITY = 0.053; } // [%] 

    /**
     * Maximum reduction of the solar flux for an observer external to the solar system during a transit of Saturn    
     * <p>
     * Source: E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 2.2, Equation 2.4, page 14<br/>
     * Status: CONF<br/>
     * Unit: %<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Maximum reduction of the solar flux for an observer external to the solar system during a transit of Saturn", 
     source = "E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 2.2, Equation 2.4, page 14", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "%") 
    public static final double SATURN_FLUXREDUCTION_MAXIMUM; static { SATURN_FLUXREDUCTION_MAXIMUM = 0.701; } // [%] 

    /**
     * Maximum transit time of Saturn (transiting the Sun) for an observer external to the solar system    
     * <p>
     * Source: E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 2.3, Equation 2.5, page 15<br/>
     * Status: CONF<br/>
     * Unit: day<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Maximum transit time of Saturn (transiting the Sun) for an observer external to the solar system", 
     source = "E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 2.3, Equation 2.5, page 15", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "day") 
    public static final double SATURN_TRANSITTIME_MAXIMUM; static { SATURN_TRANSITTIME_MAXIMUM = 1.81; } // [day] 

    /**
     * Saturn-system mass (IAU 2009 CBE value). The planetary mass includes the contribution of its satellites    
     * <p>
     * Status: CONF<br/>
     * Unit: kg<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Saturn-system mass (IAU 2009 CBE value). The planetary mass includes the contribution of its satellites", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "kg") 
    public static final double SATURNSYSTEM_MASS; static { SATURNSYSTEM_MASS = 5.68477e+26; } // [kg] 

    /**
     * Mean orbital semi-major axis of Saturn, at the standard epoch J2000.0. The mean orbital semi-major axis is associated with a mean orbit solution from a 250-year least-squares fit of JPL's DE405 ephemeris to a Keplerian orbit covering the interval of years 1800 AD - 2050 AD. The orbital element is referenced to the mean ecliptic and equinox of J2000 at the standard epoch J2000.0; linear rates and fit errors can be found in the reference document    
     * <p>
     * Source: E.M. Standish, 16 February 2006, 'Keplerian Elements for Approximate Positions of the Major Planets', http://ssd.jpl.nasa.gov/?planets\#elem<br/>
     * Status: CONF<br/>
     * Unit: au<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean orbital semi-major axis of Saturn, at the standard epoch J2000.0. The mean orbital semi-major axis is associated with a mean orbit solution from a 250-year least-squares fit of JPL's DE405 ephemeris to a Keplerian orbit covering the interval of years 1800 AD - 2050 AD. The orbital element is referenced to the mean ecliptic and equinox of J2000 at the standard epoch J2000.0; linear rates and fit errors can be found in the reference document", 
     source = "E.M. Standish, 16 February 2006, 'Keplerian Elements for Approximate Positions of the Major Planets', http://ssd.jpl.nasa.gov/?planets\\#elem", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "au") 
    public static final double SATURNSYSTEM_ORBITALSEMIMAJORAXIS_J2000; static { SATURNSYSTEM_ORBITALSEMIMAJORAXIS_J2000 = 9.53667594; } // [au] 

    /**
     * Mean orbital eccentricity of Saturn, at the standard epoch J2000.0. The mean orbital eccentricity is associated with a mean orbit solution from a 250-year least-squares fit of JPL's DE405 ephemeris to a Keplerian orbit covering the interval of years 1800 AD - 2050 AD. The orbital element is referenced to the mean ecliptic and equinox of J2000 at the standard epoch J2000.0; linear rates and fit errors can be found in the reference document    
     * <p>
     * Source: E.M. Standish, 16 February 2006, 'Keplerian Elements for Approximate Positions of the Major Planets', http://ssd.jpl.nasa.gov/?planets\#elem<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean orbital eccentricity of Saturn, at the standard epoch J2000.0. The mean orbital eccentricity is associated with a mean orbit solution from a 250-year least-squares fit of JPL's DE405 ephemeris to a Keplerian orbit covering the interval of years 1800 AD - 2050 AD. The orbital element is referenced to the mean ecliptic and equinox of J2000 at the standard epoch J2000.0; linear rates and fit errors can be found in the reference document", 
     source = "E.M. Standish, 16 February 2006, 'Keplerian Elements for Approximate Positions of the Major Planets', http://ssd.jpl.nasa.gov/?planets\\#elem", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double SATURNSYSTEM_ORBITALECCENTRICITY_J2000; static { SATURNSYSTEM_ORBITALECCENTRICITY_J2000 = 0.05386179; } 

    /**
     * Mean orbital inclination of Saturn, at the standard epoch J2000.0. The mean orbital inclination is is associated with a mean orbit solution from a 250-year least-squares fit of JPL's DE405 ephemeris to a Keplerian orbit covering the interval of years 1800 AD - 2050 AD. The orbital element is referenced to the mean ecliptic and equinox of J2000 at the standard epoch J2000.0; linear rates and fit errors can be found in the reference document    
     * <p>
     * Source: E.M. Standish, 16 February 2006, 'Keplerian Elements for Approximate Positions of the Major Planets', http://ssd.jpl.nasa.gov/?planets\#elem<br/>
     * Status: CONF<br/>
     * Unit: deg<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean orbital inclination of Saturn, at the standard epoch J2000.0. The mean orbital inclination is is associated with a mean orbit solution from a 250-year least-squares fit of JPL's DE405 ephemeris to a Keplerian orbit covering the interval of years 1800 AD - 2050 AD. The orbital element is referenced to the mean ecliptic and equinox of J2000 at the standard epoch J2000.0; linear rates and fit errors can be found in the reference document", 
     source = "E.M. Standish, 16 February 2006, 'Keplerian Elements for Approximate Positions of the Major Planets', http://ssd.jpl.nasa.gov/?planets\\#elem", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "deg") 
    public static final double SATURNSYSTEM_ORBITALINCLINATION_J2000; static { SATURNSYSTEM_ORBITALINCLINATION_J2000 = 2.48599187; } // [deg] 

    /**
     * Radial-velocity amplitude of the Sun induced by the Saturn system for 'an edge-on observer' (i.e., an observer in the orbital plane of the Saturn system)    
     * <p>
     * Source: E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 1.4, Equation 1.18, page 9<br/>
     * Status: CONF<br/>
     * Unit: m s^-1<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Radial-velocity amplitude of the Sun induced by the Saturn system for 'an edge-on observer' (i.e., an observer in the orbital plane of the Saturn system)", 
     source = "E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 1.4, Equation 1.18, page 9", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m s^-1") 
    public static final double SATURNSYSTEM_RADIALVELOCITYSIGNATURE; static { SATURNSYSTEM_RADIALVELOCITYSIGNATURE = 2.8; } // [m s^-1] 

    /**
     * Sidereal orbital period    
     * <p>
     * Source: Values derived from the mean longitude rates in Table 5.8.1 in P.K. Seidelmann, 1992, 'Explanatory Supplement to the Astronomical Almanac', University Science Books, Mill Valley, Ca., ISBN 0-935702-68-7, page 316; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par<br/>
     * Status: CONF<br/>
     * Unit: yr<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Sidereal orbital period", 
     source = "Values derived from the mean longitude rates in Table 5.8.1 in P.K. Seidelmann, 1992, 'Explanatory Supplement to the Astronomical Almanac', University Science Books, Mill Valley, Ca., ISBN 0-935702-68-7, page 316; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "yr") 
    public static final double SATURNSYSTEM_ORBITALPERIOD; static { SATURNSYSTEM_ORBITALPERIOD = 29.447498; } // [yr] 

    /**
     * Astrometric signature of the Sun induced by the Saturn system for an observer located at a distance of 10 pc from the Sun    
     * <p>
     * Source: E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 1.7, Equation 1.22, page 11<br/>
     * Status: CONF<br/>
     * Unit: 10^-6 arcsec<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Astrometric signature of the Sun induced by the Saturn system for an observer located at a distance of 10 pc from the Sun", 
     source = "E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 1.7, Equation 1.22, page 11", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "10^-6 arcsec") 
    public static final double SATURNSYSTEM_ASTROMETRICSIGNATURE_10PARSEC; static { SATURNSYSTEM_ASTROMETRICSIGNATURE_10PARSEC = 273.; } // [10^-6 arcsec] 

    /**
     * Shapiro's time-delay constant for the Sun    
     * <p>
     * Source: See, e.g., L. Lindegren, D. Dravins, 2003, 'The fundamental definition of <radial velocity>', A&A, 401, 1185, Section 4.3 or P.K. Seidelmann, 1992, 'Explanatory Supplement to the Astronomical Almanac', University Science Books, Mill Valley, Ca., ISBN 0-935702-68-7, Equation 5.3211-1, page 295<br/>
     * Status: CONF<br/>
     * Unit: s<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Shapiro's time-delay constant for the Sun", 
     source = "See, e.g., L. Lindegren, D. Dravins, 2003, 'The fundamental definition of <radial velocity>', A&A, 401, 1185, Section 4.3 or P.K. Seidelmann, 1992, 'Explanatory Supplement to the Astronomical Almanac', University Science Books, Mill Valley, Ca., ISBN 0-935702-68-7, Equation 5.3211-1, page 295", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "s") 
    public static final double SHAPIRO_CONSTANT; static { SHAPIRO_CONSTANT = 9.8510e-6; } // [s] 

    /**
     * Silicon photon absorption depth as a function of (photon) wavelength. First column: wavelength \lambda (in nm; from 200.0 to 1100.0). Second column: Silicon optical absorption coefficient \alpha (in [10^-6 m]^-1) at T = 160 K. Third column: Silicon photon absorption depth L_A = \alpha^-1 (in 10^-6 m) at T = 160 K    
     * <p>
     * Source: K. Rajkanan, R. Singh, J. Shewchun, 1979, 'Absorption coefficient of Silicon for solar cell calculations', Solid-State Electronics, 22, 793-795; analytical phenomenological model presented in this reference has an accuracy of about 20%; formal validity ranges are 20-500 K in temperature T and 1.1-4.0 eV, i.e., 310-1127 nm, in photon energy (and wavelength)<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: false
     */
    @ParamMetaData (
    description = "Silicon photon absorption depth as a function of (photon) wavelength. First column: wavelength \\lambda (in nm; from 200.0 to 1100.0). Second column: Silicon optical absorption coefficient \\alpha (in [10^-6 m]^-1) at T = 160 K. Third column: Silicon photon absorption depth L_A = \\alpha^-1 (in 10^-6 m) at T = 160 K", 
     source = "K. Rajkanan, R. Singh, J. Shewchun, 1979, 'Absorption coefficient of Silicon for solar cell calculations', Solid-State Electronics, 22, 793-795; analytical phenomenological model presented in this reference has an accuracy of about 20%; formal validity ranges are 20-500 K in temperature T and 1.1-4.0 eV, i.e., 310-1127 nm, in photon energy (and wavelength)", 
     status = "CONF", 
     basic = true, 
     scalar = false, 
     unit = "") 
    public static final String SI_PHOTONABSORPTIONDEPTH_160K; static { SI_PHOTONABSORPTIONDEPTH_160K = "Nature/Si_PhotonAbsorptionDepth_160K_001.fits"; } 

    /**
     * Silicon optical absorption coefficient as a function of (photon) wavelength. First column: wavelength \lambda (in nm; from 200.0 to 1100.0). Second column: Silicon optical absorption coefficient \alpha (in [10^-6 m]^-1) at T = 160 K. Third column: Silicon photon absorption depth L_A = \alpha^-1 (in 10^-6 m) at T = 160 K    
     * <p>
     * Source: K. Rajkanan, R. Singh, J. Shewchun, 1979, 'Absorption coefficient of Silicon for solar cell calculations', Solid-State Electronics, 22, 793-795; analytical phenomenological model presented in this reference has an accuracy of about 20%; formal validity ranges are 20-500 K in temperature T and 1.1-4.0 eV, i.e., 310-1127 nm, in photon energy (and wavelength)<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: false
     */
    @ParamMetaData (
    description = "Silicon optical absorption coefficient as a function of (photon) wavelength. First column: wavelength \\lambda (in nm; from 200.0 to 1100.0). Second column: Silicon optical absorption coefficient \\alpha (in [10^-6 m]^-1) at T = 160 K. Third column: Silicon photon absorption depth L_A = \\alpha^-1 (in 10^-6 m) at T = 160 K", 
     source = "K. Rajkanan, R. Singh, J. Shewchun, 1979, 'Absorption coefficient of Silicon for solar cell calculations', Solid-State Electronics, 22, 793-795; analytical phenomenological model presented in this reference has an accuracy of about 20%; formal validity ranges are 20-500 K in temperature T and 1.1-4.0 eV, i.e., 310-1127 nm, in photon energy (and wavelength)", 
     status = "CONF", 
     basic = true, 
     scalar = false, 
     unit = "") 
    public static final String SI_OPTICALABSORPTIONCOEFFICIENT_160K; static { SI_OPTICALABSORPTIONCOEFFICIENT_160K = "Nature/Si_OpticalAbsorptionCoefficient_160K_001.fits"; } 

    /**
     * Silicon diffusion coefficient    
     * <p>
     * Source: J.R. Janesick, 2001, 'Scientific CCDs', SPIE, Bellingham, Washington, Example 4.17, page 348<br/>
     * Status: CONF<br/>
     * Unit: m^2 s^-1<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Silicon diffusion coefficient", 
     source = "J.R. Janesick, 2001, 'Scientific CCDs', SPIE, Bellingham, Washington, Example 4.17, page 348", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "m^2 s^-1") 
    public static final double SI_DIFFUSIONCOEFFICIENT; static { SI_DIFFUSIONCOEFFICIENT = 0.0039; } // [m^2 s^-1] 

    /**
     * Diffusion length in the epitaxial Silicon    
     * <p>
     * Source: J.R. Janesick, 2001, 'Scientific CCDs', SPIE, Bellingham, Washington, Example 4.17, page 348<br/>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Diffusion length in the epitaxial Silicon", 
     source = "J.R. Janesick, 2001, 'Scientific CCDs', SPIE, Bellingham, Washington, Example 4.17, page 348", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "m") 
    public static final double SI_DIFFUSIONLENGTH; static { SI_DIFFUSIONLENGTH = 0.0006; } // [m] 

    /**
     * Silicon bandgap, in eV, at 0 K    
     * <p>
     * Source: B. van Zeghbroeck, 1 January 2007, 'Principles of Semiconductor Devices', http://ece-www.colorado.edu/~bart/book/<br/>
     * Status: CONF<br/>
     * Unit: eV<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Silicon bandgap, in eV, at 0 K", 
     source = "B. van Zeghbroeck, 1 January 2007, 'Principles of Semiconductor Devices', http://ece-www.colorado.edu/~bart/book/", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "eV") 
    public static final double SI_BANDGAP_0K; static { SI_BANDGAP_0K = 1.166; } // [eV] 

    /**
     * Silicon constant \alpha, in eV K^-1. The energy bandgap of Silicon (and semi-conductors in general) decreases with increasing temperature. This is explained as follows: an increased temperature enhances the amplitude of atomic vibrations due to the increased thermal energy; this causes the interatomic spacing to increase; this decreases the potential seen by the electrons in the material; this, finally, reduces the size of the energy bandgap. The temperature dependence of the energy bandgap has been experimentally determined to be E_g(T) = E_g(0) - \alpha * T^2 * (T + \beta)^-1, where T is the temperature in K,  E_g(0) is the bandgap energy in eV at zero absolute temperature (parameter Si_Bandgap_0K), and \alpha and \beta are material constants (parameters Si_Constant_Alpha and Si_Constant_Beta for Silicon)    
     * <p>
     * Source: B. van Zeghbroeck, 1 January 2007, 'Principles of Semiconductor Devices', http://ece-www.colorado.edu/~bart/book/<br/>
     * Status: CONF<br/>
     * Unit: eV K^-1<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Silicon constant \\alpha, in eV K^-1. The energy bandgap of Silicon (and semi-conductors in general) decreases with increasing temperature. This is explained as follows: an increased temperature enhances the amplitude of atomic vibrations due to the increased thermal energy; this causes the interatomic spacing to increase; this decreases the potential seen by the electrons in the material; this, finally, reduces the size of the energy bandgap. The temperature dependence of the energy bandgap has been experimentally determined to be E_g(T) = E_g(0) - \\alpha * T^2 * (T + \\beta)^-1, where T is the temperature in K,  E_g(0) is the bandgap energy in eV at zero absolute temperature (parameter Si_Bandgap_0K), and \\alpha and \\beta are material constants (parameters Si_Constant_Alpha and Si_Constant_Beta for Silicon)", 
     source = "B. van Zeghbroeck, 1 January 2007, 'Principles of Semiconductor Devices', http://ece-www.colorado.edu/~bart/book/", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "eV K^-1") 
    public static final double SI_CONSTANT_ALPHA; static { SI_CONSTANT_ALPHA = 4.730e-4; } // [eV K^-1] 

    /**
     * Silicon constant \beta, in K. The energy bandgap of Silicon (and semi-conductors in general) decreases with increasing temperature. This is explained as follows: an increased temperature enhances the amplitude of atomic vibrations due to the increased thermal energy; this causes the interatomic spacing to increase; this decreases the potential seen by the electrons in the material; this, finally, reduces the size of the energy bandgap. The temperature dependence of the energy bandgap has been experimentally determined to be E_g(T) = E_g(0) - \alpha * T^2 * (T + \beta)^-1, where T is the temperature in K,  E_g(0) is the bandgap energy in eV at zero absolute temperature (parameter Si_Bandgap_0K), and \alpha and \beta are material constants (parameters Si_Constant_Alpha and Si_Constant_Beta for Silicon)    
     * <p>
     * Source: B. van Zeghbroeck, 1 January 2007, 'Principles of Semiconductor Devices', http://ece-www.colorado.edu/~bart/book/<br/>
     * Status: CONF<br/>
     * Unit: K<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Silicon constant \\beta, in K. The energy bandgap of Silicon (and semi-conductors in general) decreases with increasing temperature. This is explained as follows: an increased temperature enhances the amplitude of atomic vibrations due to the increased thermal energy; this causes the interatomic spacing to increase; this decreases the potential seen by the electrons in the material; this, finally, reduces the size of the energy bandgap. The temperature dependence of the energy bandgap has been experimentally determined to be E_g(T) = E_g(0) - \\alpha * T^2 * (T + \\beta)^-1, where T is the temperature in K,  E_g(0) is the bandgap energy in eV at zero absolute temperature (parameter Si_Bandgap_0K), and \\alpha and \\beta are material constants (parameters Si_Constant_Alpha and Si_Constant_Beta for Silicon)", 
     source = "B. van Zeghbroeck, 1 January 2007, 'Principles of Semiconductor Devices', http://ece-www.colorado.edu/~bart/book/", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "K") 
    public static final double SI_CONSTANT_BETA; static { SI_CONSTANT_BETA = 636.; } // [K] 

    /**
     * Silicon bandgap, in eV, at 160 K. The energy bandgap of Silicon (and semi-conductors in general) decreases with increasing temperature. This is explained as follows: an increased temperature enhances the amplitude of atomic vibrations due to the increased thermal energy; this causes the interatomic spacing to increase; this decreases the potential seen by the electrons in the material; this, finally, reduces the size of the energy bandgap. The temperature dependence of the energy bandgap has been experimentally determined to be E_g(T) = E_g(0) - \alpha * T^2 * (T + \beta)^-1, where T is the temperature in K,  E_g(0) is the bandgap energy in eV at zero absolute temperature (parameter Si_Bandgap_0K), and \alpha and \beta are material constants (parameters Si_Constant_Alpha and Si_Constant_Beta for Silicon)    
     * <p>
     * Status: CONF<br/>
     * Unit: eV<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Silicon bandgap, in eV, at 160 K. The energy bandgap of Silicon (and semi-conductors in general) decreases with increasing temperature. This is explained as follows: an increased temperature enhances the amplitude of atomic vibrations due to the increased thermal energy; this causes the interatomic spacing to increase; this decreases the potential seen by the electrons in the material; this, finally, reduces the size of the energy bandgap. The temperature dependence of the energy bandgap has been experimentally determined to be E_g(T) = E_g(0) - \\alpha * T^2 * (T + \\beta)^-1, where T is the temperature in K,  E_g(0) is the bandgap energy in eV at zero absolute temperature (parameter Si_Bandgap_0K), and \\alpha and \\beta are material constants (parameters Si_Constant_Alpha and Si_Constant_Beta for Silicon)", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "eV") 
    public static final double SI_BANDGAP_160K; static { SI_BANDGAP_160K = 1.151; } // [eV] 

    /**
     * Silicon cut-off wavelength, in nm, at 160 K    
     * <p>
     * Status: CONF<br/>
     * Unit: nm<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Silicon cut-off wavelength, in nm, at 160 K", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "nm") 
    public static final double SI_CUTOFFWAVELENGTH_160K; static { SI_CUTOFFWAVELENGTH_160K = 1077.39; } // [nm] 

    /**
     * Density of SiC (Boostec)    
     * <p>
     * Source: F. Safa (EADS-Astrium), 23 April 2002, 'SiC versus C-SiC trade-off', pages 8-9<br/>
     * Status: CONF<br/>
     * Unit: g cm^-3<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Density of SiC (Boostec)", 
     source = "F. Safa (EADS-Astrium), 23 April 2002, 'SiC versus C-SiC trade-off', pages 8-9", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "g cm^-3") 
    public static final double SIC_MASSDENSITY; static { SIC_MASSDENSITY = 3.16; } // [g cm^-3] 

    /**
     * Young's modulus of SiC (Boostec); a measure for the resistance of a material to elastic (recoverable) deformation under load. Also known as elastic modulus and tension modulus    
     * <p>
     * Source: F. Safa (EADS-Astrium), 23 April 2002, 'SiC versus C-SiC trade-off', pages 8-9<br/>
     * Status: CONF<br/>
     * Unit: GPa<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Young's modulus of SiC (Boostec); a measure for the resistance of a material to elastic (recoverable) deformation under load. Also known as elastic modulus and tension modulus", 
     source = "F. Safa (EADS-Astrium), 23 April 2002, 'SiC versus C-SiC trade-off', pages 8-9", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "GPa") 
    public static final double SIC_YOUNGMODULUS; static { SIC_YOUNGMODULUS = 420.; } // [GPa] 

    /**
     * Specific stiffness of SiC (Boostec); also known as specific modulus    
     * <p>
     * Source: F. Safa (EADS-Astrium), 23 April 2002, 'SiC versus C-SiC trade-off', pages 8-9<br/>
     * Status: CONF<br/>
     * Unit: 10^6 N m kg^-1<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Specific stiffness of SiC (Boostec); also known as specific modulus", 
     source = "F. Safa (EADS-Astrium), 23 April 2002, 'SiC versus C-SiC trade-off', pages 8-9", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "10^6 N m kg^-1") 
    public static final double SIC_SPECIFICSTIFNESS; static { SIC_SPECIFICSTIFNESS = 133.; } // [10^6 N m kg^-1] 

    /**
     * Poisson ratio of SiC (Boostec)    
     * <p>
     * Source: F. Safa (EADS-Astrium), 23 April 2002, 'SiC versus C-SiC trade-off', pages 8-9<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Poisson ratio of SiC (Boostec)", 
     source = "F. Safa (EADS-Astrium), 23 April 2002, 'SiC versus C-SiC trade-off', pages 8-9", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double SIC_POISSONRATIO; static { SIC_POISSONRATIO = 0.16; } 

    /**
     * Average strength of SiC (Boostec) in the four-point bending test    
     * <p>
     * Source: F. Safa (EADS-Astrium), 23 April 2002, 'SiC versus C-SiC trade-off', pages 8-9<br/>
     * Status: CONF<br/>
     * Unit: 10^6 Pa<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Average strength of SiC (Boostec) in the four-point bending test", 
     source = "F. Safa (EADS-Astrium), 23 April 2002, 'SiC versus C-SiC trade-off', pages 8-9", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "10^6 Pa") 
    public static final double SIC_STRENGTH_AVERAGE; static { SIC_STRENGTH_AVERAGE = 390.; } // [10^6 Pa] 

    /**
     * The Weibull modulus of fired/sintered SiC (Boostec). The Weibull modulus is the slope of the linear plot of log(log(P^-1)) versus log(\sigma), where P is the probability of survival under a given stress \sigma. The numerical value is a lower limit for the Weibull modulus    
     * <p>
     * Source: F. Safa (EADS-Astrium), 23 April 2002, 'SiC versus C-SiC trade-off', pages 8-9<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "The Weibull modulus of fired/sintered SiC (Boostec). The Weibull modulus is the slope of the linear plot of log(log(P^-1)) versus log(\\sigma), where P is the probability of survival under a given stress \\sigma. The numerical value is a lower limit for the Weibull modulus", 
     source = "F. Safa (EADS-Astrium), 23 April 2002, 'SiC versus C-SiC trade-off', pages 8-9", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double SIC_WEIBULLMODULUS_FIREDSLASHSINTERED; static { SIC_WEIBULLMODULUS_FIREDSLASHSINTERED = 12.; } 

    /**
     * The Weibull modulus of machined SiC (Boostec). The Weibull modulus is the slope of the linear plot of log(log(P^-1)) versus log(\sigma), where P is the probability of survival under a given stress \sigma. The numerical value is a lower limit for the Weibull modulus    
     * <p>
     * Source: F. Safa (EADS-Astrium), 23 April 2002, 'SiC versus C-SiC trade-off', pages 8-9<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "The Weibull modulus of machined SiC (Boostec). The Weibull modulus is the slope of the linear plot of log(log(P^-1)) versus log(\\sigma), where P is the probability of survival under a given stress \\sigma. The numerical value is a lower limit for the Weibull modulus", 
     source = "F. Safa (EADS-Astrium), 23 April 2002, 'SiC versus C-SiC trade-off', pages 8-9", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double SIC_WEIBULLMODULUS_MACHINED; static { SIC_WEIBULLMODULUS_MACHINED = 10.; } 

    /**
     * Second Lame constant of SiC (Boostec), also known as shear modulus or rigidity    
     * <p>
     * Status: CONF<br/>
     * Unit: GPa<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Second Lame constant of SiC (Boostec), also known as shear modulus or rigidity", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "GPa") 
    public static final double SIC_LAMECONSTANT_SECOND; static { SIC_LAMECONSTANT_SECOND = 181.; } // [GPa] 

    /**
     * First Lame constant of SiC (Boostec)    
     * <p>
     * Status: CONF<br/>
     * Unit: GPa<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "First Lame constant of SiC (Boostec)", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "GPa") 
    public static final double SIC_LAMECONSTANT_FIRST; static { SIC_LAMECONSTANT_FIRST = 85.; } // [GPa] 

    /**
     * The bulk modulus of SiC (Boostec) under isotropic stress; also known as compression modulus    
     * <p>
     * Status: CONF<br/>
     * Unit: GPa<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "The bulk modulus of SiC (Boostec) under isotropic stress; also known as compression modulus", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "GPa") 
    public static final double SIC_BULKMODULUS; static { SIC_BULKMODULUS = 206.; } // [GPa] 

    /**
     * The compressibility of SiC (Boostec)    
     * <p>
     * Status: CONF<br/>
     * Unit: m^2 N^-1<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "The compressibility of SiC (Boostec)", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m^2 N^-1") 
    public static final double SIC_COMPRESSIBILITY; static { SIC_COMPRESSIBILITY = 4.857e-12; } // [m^2 N^-1] 

    /**
     * The S-wave speed in SiC (Boostec); an S-wave is a wave in an elastic medium in which the restoring force is provided by shear    
     * <p>
     * Status: CONF<br/>
     * Unit: km s^-1<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "The S-wave speed in SiC (Boostec); an S-wave is a wave in an elastic medium in which the restoring force is provided by shear", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "km s^-1") 
    public static final double SIC_SWAVESPEED; static { SIC_SWAVESPEED = 7.57; } // [km s^-1] 

    /**
     * The P-wave speed in SiC (Boostec); a P-wave (pressure wave) is a longitudinal wave in an elastic medium in which the restoring force is provided by the medium's bulk modulus    
     * <p>
     * Status: CONF<br/>
     * Unit: km s^-1<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "The P-wave speed in SiC (Boostec); a P-wave (pressure wave) is a longitudinal wave in an elastic medium in which the restoring force is provided by the medium's bulk modulus", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "km s^-1") 
    public static final double SIC_PWAVESPEED; static { SIC_PWAVESPEED = 11.90; } // [km s^-1] 

    /**
     * Thermal conductivity of isotropic homogeneous SiC (Boostec) at 293 K    
     * <p>
     * Source: F. Safa (EADS-Astrium), 23 April 2002, 'SiC versus C-SiC trade-off', pages 8-9<br/>
     * Status: CONF<br/>
     * Unit: W m^-1 K^-1<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Thermal conductivity of isotropic homogeneous SiC (Boostec) at 293 K", 
     source = "F. Safa (EADS-Astrium), 23 April 2002, 'SiC versus C-SiC trade-off', pages 8-9", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "W m^-1 K^-1") 
    public static final double SIC_THERMALCONDUCTIVITY_293K; static { SIC_THERMALCONDUCTIVITY_293K = 190.; } // [W m^-1 K^-1] 

    /**
     * Thermal conductivity of isotropic homogeneous SiC (Boostec) at 170 K    
     * <p>
     * Source: F. Safa (EADS-Astrium), 23 April 2002, 'SiC versus C-SiC trade-off', pages 8-9<br/>
     * Status: CONF<br/>
     * Unit: W m^-1 K^-1<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Thermal conductivity of isotropic homogeneous SiC (Boostec) at 170 K", 
     source = "F. Safa (EADS-Astrium), 23 April 2002, 'SiC versus C-SiC trade-off', pages 8-9", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "W m^-1 K^-1") 
    public static final double SIC_THERMALCONDUCTIVITY_170K; static { SIC_THERMALCONDUCTIVITY_170K = 220.; } // [W m^-1 K^-1] 

    /**
     * Thermal conductivity of isotropic homogeneous SiC (Boostec) at 100 K    
     * <p>
     * Source: F. Safa (EADS-Astrium), 23 April 2002, 'SiC versus C-SiC trade-off', pages 8-9<br/>
     * Status: CONF<br/>
     * Unit: W m^-1 K^-1<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Thermal conductivity of isotropic homogeneous SiC (Boostec) at 100 K", 
     source = "F. Safa (EADS-Astrium), 23 April 2002, 'SiC versus C-SiC trade-off', pages 8-9", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "W m^-1 K^-1") 
    public static final double SIC_THERMALCONDUCTIVITY_100K; static { SIC_THERMALCONDUCTIVITY_100K = 180.; } // [W m^-1 K^-1] 

    /**
     * Average volumetric thermal expansion coefficient of isotropic homogeneous SiC (Boostec) at 293 K    
     * <p>
     * Source: F. Safa (EADS-Astrium), 23 April 2002, 'SiC versus C-SiC trade-off', pages 8-9<br/>
     * Status: CONF<br/>
     * Unit: ppm K^-1<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Average volumetric thermal expansion coefficient of isotropic homogeneous SiC (Boostec) at 293 K", 
     source = "F. Safa (EADS-Astrium), 23 April 2002, 'SiC versus C-SiC trade-off', pages 8-9", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "ppm K^-1") 
    public static final double SIC_VOLUMETRICTHERMALCOEFFICIENTOFEXPANSION_293K; static { SIC_VOLUMETRICTHERMALCOEFFICIENTOFEXPANSION_293K = 2.2; } // [ppm K^-1] 

    /**
     * Average volumetric thermal expansion coefficient of isotropic homogeneous SiC (Boostec) at 170 K    
     * <p>
     * Source: F. Safa (EADS-Astrium), 23 April 2002, 'SiC versus C-SiC trade-off', pages 8-9<br/>
     * Status: CONF<br/>
     * Unit: ppm K^-1<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Average volumetric thermal expansion coefficient of isotropic homogeneous SiC (Boostec) at 170 K", 
     source = "F. Safa (EADS-Astrium), 23 April 2002, 'SiC versus C-SiC trade-off', pages 8-9", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "ppm K^-1") 
    public static final double SIC_VOLUMETRICTHERMALCOEFFICIENTOFEXPANSION_170K; static { SIC_VOLUMETRICTHERMALCOEFFICIENTOFEXPANSION_170K = 3.4; } // [ppm K^-1] 

    /**
     * Average volumetric thermal expansion coefficient of isotropic homogeneous SiC (Boostec) at 100 K    
     * <p>
     * Source: F. Safa (EADS-Astrium), 23 April 2002, 'SiC versus C-SiC trade-off', pages 8-9<br/>
     * Status: CONF<br/>
     * Unit: ppm K^-1<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Average volumetric thermal expansion coefficient of isotropic homogeneous SiC (Boostec) at 100 K", 
     source = "F. Safa (EADS-Astrium), 23 April 2002, 'SiC versus C-SiC trade-off', pages 8-9", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "ppm K^-1") 
    public static final double SIC_VOLUMETRICTHERMALCOEFFICIENTOFEXPANSION_100K; static { SIC_VOLUMETRICTHERMALCOEFFICIENTOFEXPANSION_100K = 3.1; } // [ppm K^-1] 

    /**
     * Average linear thermal expansion coefficient of isotropic homogeneous SiC (Boostec) at 293 K    
     * <p>
     * Status: CONF<br/>
     * Unit: ppm K^-1<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Average linear thermal expansion coefficient of isotropic homogeneous SiC (Boostec) at 293 K", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "ppm K^-1") 
    public static final double SIC_LINEARTHERMALCOEFFICIENTOFEXPANSION_293K; static { SIC_LINEARTHERMALCOEFFICIENTOFEXPANSION_293K = 0.7; } // [ppm K^-1] 

    /**
     * Average linear thermal expansion coefficient of isotropic homogeneous SiC (Boostec) at 170 K    
     * <p>
     * Status: CONF<br/>
     * Unit: ppm K^-1<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Average linear thermal expansion coefficient of isotropic homogeneous SiC (Boostec) at 170 K", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "ppm K^-1") 
    public static final double SIC_LINEARTHERMALCOEFFICIENTOFEXPANSION_170K; static { SIC_LINEARTHERMALCOEFFICIENTOFEXPANSION_170K = 1.1; } // [ppm K^-1] 

    /**
     * Average linear thermal expansion coefficient of isotropic homogeneous SiC (Boostec) at 100 K    
     * <p>
     * Status: CONF<br/>
     * Unit: ppm K^-1<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Average linear thermal expansion coefficient of isotropic homogeneous SiC (Boostec) at 100 K", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "ppm K^-1") 
    public static final double SIC_LINEARTHERMALCOEFFICIENTOFEXPANSION_100K; static { SIC_LINEARTHERMALCOEFFICIENTOFEXPANSION_100K = 1.0; } // [ppm K^-1] 

    /**
     * SiC cryogenic linear scale factor \xi between 293 K and 120 K. The assumed linear thermal expansion coefficient of SiC at 293 K is 1.27 ppm K^-1 (see also parameter SiC_LinearThermalCoefficientOfExpansion_293K)    
     * <p>
     * Source: A. Mora, 21 June 2011, 'Conversion between image and object space coordinates', GAIA-CH-TN-ESAC-AMF-008, issue 2, revision 1, Section 3<br/>
     * Status: CONF<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "SiC cryogenic linear scale factor \\xi between 293 K and 120 K. The assumed linear thermal expansion coefficient of SiC at 293 K is 1.27 ppm K^-1 (see also parameter SiC_LinearThermalCoefficientOfExpansion_293K)", 
     source = "A. Mora, 21 June 2011, 'Conversion between image and object space coordinates', GAIA-CH-TN-ESAC-AMF-008, issue 2, revision 1, Section 3", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "") 
    public static final double SIC_CRYOGENICLINEARSCALEFACTOR_293K; static { SIC_CRYOGENICLINEARSCALEFACTOR_293K = 1.00021971; } 

    /**
     * Specific heat of SiC (Boostec) at 293 K    
     * <p>
     * Source: F. Safa (EADS-Astrium), 23 April 2002, 'SiC versus C-SiC trade-off', pages 8-9<br/>
     * Status: CONF<br/>
     * Unit: J K^-1 kg^-1<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Specific heat of SiC (Boostec) at 293 K", 
     source = "F. Safa (EADS-Astrium), 23 April 2002, 'SiC versus C-SiC trade-off', pages 8-9", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "J K^-1 kg^-1") 
    public static final double SIC_SPECIFICHEATATCONSTANTPRESSURE_293K; static { SIC_SPECIFICHEATATCONSTANTPRESSURE_293K = 680.; } // [J K^-1 kg^-1] 

    /**
     * Specific heat of SiC (Boostec) at 170 K    
     * <p>
     * Source: F. Safa (EADS-Astrium), 23 April 2002, 'SiC versus C-SiC trade-off', pages 8-9<br/>
     * Status: CONF<br/>
     * Unit: J K^-1 kg^-1<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Specific heat of SiC (Boostec) at 170 K", 
     source = "F. Safa (EADS-Astrium), 23 April 2002, 'SiC versus C-SiC trade-off', pages 8-9", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "J K^-1 kg^-1") 
    public static final double SIC_SPECIFICHEATATCONSTANTPRESSURE_170K; static { SIC_SPECIFICHEATATCONSTANTPRESSURE_170K = 320.; } // [J K^-1 kg^-1] 

    /**
     * Specific heat of SiC (Boostec) at 100 K    
     * <p>
     * Source: F. Safa (EADS-Astrium), 23 April 2002, 'SiC versus C-SiC trade-off', pages 8-9<br/>
     * Status: CONF<br/>
     * Unit: J K^-1 kg^-1<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Specific heat of SiC (Boostec) at 100 K", 
     source = "F. Safa (EADS-Astrium), 23 April 2002, 'SiC versus C-SiC trade-off', pages 8-9", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "J K^-1 kg^-1") 
    public static final double SIC_SPECIFICHEATATCONSTANTPRESSURE_100K; static { SIC_SPECIFICHEATATCONSTANTPRESSURE_100K = 100.; } // [J K^-1 kg^-1] 

    /**
     * Thermal diffusivity of SiC (Boostec) at 293 K    
     * <p>
     * Status: CONF<br/>
     * Unit: m^2 s^-1<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Thermal diffusivity of SiC (Boostec) at 293 K", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m^2 s^-1") 
    public static final double SIC_THERMALDIFFUSIVITY_293K; static { SIC_THERMALDIFFUSIVITY_293K = 88.; } // [m^2 s^-1] 

    /**
     * Thermal diffusivity of SiC (Boostec) at 170 K    
     * <p>
     * Status: CONF<br/>
     * Unit: m^2 s^-1<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Thermal diffusivity of SiC (Boostec) at 170 K", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m^2 s^-1") 
    public static final double SIC_THERMALDIFFUSIVITY_170K; static { SIC_THERMALDIFFUSIVITY_170K = 218.; } // [m^2 s^-1] 

    /**
     * Thermal diffusivity of SiC (Boostec) at 100 K    
     * <p>
     * Status: CONF<br/>
     * Unit: m^2 s^-1<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Thermal diffusivity of SiC (Boostec) at 100 K", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m^2 s^-1") 
    public static final double SIC_THERMALDIFFUSIVITY_100K; static { SIC_THERMALDIFFUSIVITY_100K = 570.; } // [m^2 s^-1] 

    /**
     * Number of days per sidereal year    
     * <p>
     * Source: J.L. Simon, P. Bretagnon, J. Chapront, M. Chapront-Touze, G. Francou, J. Laskar, 1994, 'Numerical expressions for precession formulae and mean elements for the Moon and the planets', A&A, 282, 663 (1994A&A...282..663S)<br/>
     * Status: CONF<br/>
     * Unit: day<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Number of days per sidereal year", 
     source = "J.L. Simon, P. Bretagnon, J. Chapront, M. Chapront-Touze, G. Francou, J. Laskar, 1994, 'Numerical expressions for precession formulae and mean elements for the Moon and the planets', A&A, 282, 663 (1994A&A...282..663S)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "day") 
    public static final double SIDEREALYEAR_J2000DAY; static { SIDEREALYEAR_J2000DAY = 365.256363004; } // [day] 

    /**
     * Minimum magnitude of the magnitude grid (STAR-G-MAGGRID and STAR-C1M861-MAGGRID) underlying the object counts in parameter Sky_ObjectDensity    
     * <p>
     * Source: Extracted from parameter Sky_ObjectDensity_003<br/>
     * Status: CONF<br/>
     * Unit: mag<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Minimum magnitude of the magnitude grid (STAR-G-MAGGRID and STAR-C1M861-MAGGRID) underlying the object counts in parameter Sky_ObjectDensity", 
     source = "Extracted from parameter Sky_ObjectDensity_003", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "mag") 
    public static final double SKY_OBJECTDENSITY_MAGMIN; static { SKY_OBJECTDENSITY_MAGMIN = 4.0; } // [mag] 

    /**
     * Maximum magnitude of the magnitude grid (STAR-G-MAGGRID and STAR-C1M861-MAGGRID) underlying the object counts in parameter Sky_ObjectDensity    
     * <p>
     * Source: Extracted from parameter Sky_ObjectDensity_003<br/>
     * Status: CONF<br/>
     * Unit: mag<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Maximum magnitude of the magnitude grid (STAR-G-MAGGRID and STAR-C1M861-MAGGRID) underlying the object counts in parameter Sky_ObjectDensity", 
     source = "Extracted from parameter Sky_ObjectDensity_003", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "mag") 
    public static final double SKY_OBJECTDENSITY_MAGMAX; static { SKY_OBJECTDENSITY_MAGMAX = 21.0; } // [mag] 

    /**
     * Magnitude step (bin size) of the magnitude grid (STAR-G-MAGGRID and STAR-C1M861-MAGGRID) underlying the object counts in parameter Sky_ObjectDensity    
     * <p>
     * Source: Extracted from parameter Sky_ObjectDensity_003<br/>
     * Status: CONF<br/>
     * Unit: mag<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Magnitude step (bin size) of the magnitude grid (STAR-G-MAGGRID and STAR-C1M861-MAGGRID) underlying the object counts in parameter Sky_ObjectDensity", 
     source = "Extracted from parameter Sky_ObjectDensity_003", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "mag") 
    public static final double SKY_OBJECTDENSITY_MAGBINWIDTH; static { SKY_OBJECTDENSITY_MAGBINWIDTH = 0.5; } // [mag] 

    /**
     * Standard Gaia Galaxy model, providing predictions of object densities in the three Gaia-2-relevant photometric bands G, GS, and G_RVS (= C1M861 = RVF) as a function of limiting magnitude for any point on the celestial sphere. Object densities are defined on a Hierarchical Triangular Mesh of level 6 comprised of almost-equal-area cells of approximately 1 square degree in size. The model is a synthesis of count predictions from two distinct sources: (i) the Bescancon Galaxy model (http://model.obs-besancon.fr/), in conjunction with the extinction law of R. Drimmel, for stars; and (ii) the GSC-II catalogue (http://gsss.stsci.edu/Catalogs/GSC/GSC2/GSC2.htm) for stars and galaxies. The combined result can be summarised as follows: (a) Bright stars: 4 <= G <= 12.5: GSC-II (Tycho-2 catalogue included); 4 <= GS <= 12.5: GSC-II (Tycho-2 catalogue included); 4 <= G_RVS <= 12.5: GSC-II (Tycho-2 catalogue included); (b) Faint stars: 12.5 <= G <= 21: Bescancon; 12.5 <= GS <= 21: Bescancon; 12.5 <= G_RVS <= 18: Bescancon; (c) Stars in special regions (LMC/SMC): counts for full range of magnitudes, for circle with radius 10 deg (LMC) and 7 deg (SMC), taken from the GSC-II catalogue; (d) galaxies: G <= 21: GSC-II; GS <= 21: GSC-II; G_RVS <= 18: GSC-II. The following Bintables are defined: (1) STAR-G-MAGGRID: magnitude grid for column DENSITY in following extension STAR-G-DENSITY (the magnitude grids STAR-G-MAGGRID and STAR-C1M861-MAGGRID are defined through parameters Sky_ObjectDensity_MagMin, Sky_ObjectDensity_MagMax, and Sky_ObjectDensity_MagBinWidth); (2) STAR-G-DENSITY: table with star magnitude counts in column DENSITY per HTM cell in the G band; each row corresponds to one cell. Table columns are: HTMID: unique HTM cell designator; AREA: area of cell [square deg]; ALPHA: right ascension of cell centre [h]; DELTA: declination of cell centre [deg]; LGAL: Galactic longitude of cell centre [deg]; BGAL: Galactic latitude of cell centre [deg]; DENSITY: non-cumulative number of objects per square degree in cell in 0.5 magnitude-bin interval, i.e., DENSITY[i] is the number of stars per square degree in the magnitude interval [STAR-G-MAGGRID[i], STAR-G-MAGGRID[i]+0.5]; (3) GAL-G-MAGGRID: same as STAR-G-MAGGRID, but for galaxies (the magnitude grids STAR-G-MAGGRID and STAR-C1M861-MAGGRID are defined through parameters Sky_ObjectDensity_MagMin, Sky_ObjectDensity_MagMax, and Sky_ObjectDensity_MagBinWidth); (4) GAL-G-DENSITY: same as STAR-G-DENSITY, but for galaxies; (5) STAR-GS-MAGGRID: same as STAR-G-MAGGRID, but in GS band; (6) STAR-GS-DENSITY: same as STAR-G-DENSITY, but in GS band; (7) GAL-GS-MAGGRID: same as STAR-GS-MAGGRID, but for galaxies; (8) GAL-GS-DENSITY: same as STAR-GS-DENSITY, but for galaxies; (9) STAR-C1M861-MAGGRID: same as STAR-G-MAGGRID, but in G_RVS band; (10) STAR-C1M861-DENSITY: same as STAR-G-DENSITY, but in G_RVS band; (11) GAL-C1M861-MAGGRID: same as STAR-C1M861-MAGGRID, but for galaxies; and (12) GAL-C1M861-DENSITY: same as STAR-C1M861-DENSITY, but for galaxies    
     * <p>
     * Source: The data used to produce the standard Gaia Galaxy model have been provided by the teams of the Observatoire de Besancon (A. Robin, C. Reyle, et al.) and the Observatorio Astronomico di Torino (R. Drimmel, et al.); the harmonisation has been provided by the SWG (X. Luri). See U. Lammers, 22 April 2005, 'Gaia Standard Galaxy Model Access Software (GSGMAS); User Guide', GAIA-UL-010, issue 1, revision 0. See also R. Drimmel, et al., 19 July 2005, 'Recommendations on the use of estimated star counts for Gaia studies', SWG-RD-004<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: false
     */
    @ParamMetaData (
    description = "Standard Gaia Galaxy model, providing predictions of object densities in the three Gaia-2-relevant photometric bands G, GS, and G_RVS (= C1M861 = RVF) as a function of limiting magnitude for any point on the celestial sphere. Object densities are defined on a Hierarchical Triangular Mesh of level 6 comprised of almost-equal-area cells of approximately 1 square degree in size. The model is a synthesis of count predictions from two distinct sources: (i) the Bescancon Galaxy model (http://model.obs-besancon.fr/), in conjunction with the extinction law of R. Drimmel, for stars; and (ii) the GSC-II catalogue (http://gsss.stsci.edu/Catalogs/GSC/GSC2/GSC2.htm) for stars and galaxies. The combined result can be summarised as follows: (a) Bright stars: 4 <= G <= 12.5: GSC-II (Tycho-2 catalogue included); 4 <= GS <= 12.5: GSC-II (Tycho-2 catalogue included); 4 <= G_RVS <= 12.5: GSC-II (Tycho-2 catalogue included); (b) Faint stars: 12.5 <= G <= 21: Bescancon; 12.5 <= GS <= 21: Bescancon; 12.5 <= G_RVS <= 18: Bescancon; (c) Stars in special regions (LMC/SMC): counts for full range of magnitudes, for circle with radius 10 deg (LMC) and 7 deg (SMC), taken from the GSC-II catalogue; (d) galaxies: G <= 21: GSC-II; GS <= 21: GSC-II; G_RVS <= 18: GSC-II. The following Bintables are defined: (1) STAR-G-MAGGRID: magnitude grid for column DENSITY in following extension STAR-G-DENSITY (the magnitude grids STAR-G-MAGGRID and STAR-C1M861-MAGGRID are defined through parameters Sky_ObjectDensity_MagMin, Sky_ObjectDensity_MagMax, and Sky_ObjectDensity_MagBinWidth); (2) STAR-G-DENSITY: table with star magnitude counts in column DENSITY per HTM cell in the G band; each row corresponds to one cell. Table columns are: HTMID: unique HTM cell designator; AREA: area of cell [square deg]; ALPHA: right ascension of cell centre [h]; DELTA: declination of cell centre [deg]; LGAL: Galactic longitude of cell centre [deg]; BGAL: Galactic latitude of cell centre [deg]; DENSITY: non-cumulative number of objects per square degree in cell in 0.5 magnitude-bin interval, i.e., DENSITY[i] is the number of stars per square degree in the magnitude interval [STAR-G-MAGGRID[i], STAR-G-MAGGRID[i]+0.5]; (3) GAL-G-MAGGRID: same as STAR-G-MAGGRID, but for galaxies (the magnitude grids STAR-G-MAGGRID and STAR-C1M861-MAGGRID are defined through parameters Sky_ObjectDensity_MagMin, Sky_ObjectDensity_MagMax, and Sky_ObjectDensity_MagBinWidth); (4) GAL-G-DENSITY: same as STAR-G-DENSITY, but for galaxies; (5) STAR-GS-MAGGRID: same as STAR-G-MAGGRID, but in GS band; (6) STAR-GS-DENSITY: same as STAR-G-DENSITY, but in GS band; (7) GAL-GS-MAGGRID: same as STAR-GS-MAGGRID, but for galaxies; (8) GAL-GS-DENSITY: same as STAR-GS-DENSITY, but for galaxies; (9) STAR-C1M861-MAGGRID: same as STAR-G-MAGGRID, but in G_RVS band; (10) STAR-C1M861-DENSITY: same as STAR-G-DENSITY, but in G_RVS band; (11) GAL-C1M861-MAGGRID: same as STAR-C1M861-MAGGRID, but for galaxies; and (12) GAL-C1M861-DENSITY: same as STAR-C1M861-DENSITY, but for galaxies", 
     source = "The data used to produce the standard Gaia Galaxy model have been provided by the teams of the Observatoire de Besancon (A. Robin, C. Reyle, et al.) and the Observatorio Astronomico di Torino (R. Drimmel, et al.); the harmonisation has been provided by the SWG (X. Luri). See U. Lammers, 22 April 2005, 'Gaia Standard Galaxy Model Access Software (GSGMAS); User Guide', GAIA-UL-010, issue 1, revision 0. See also R. Drimmel, et al., 19 July 2005, 'Recommendations on the use of estimated star counts for Gaia studies', SWG-RD-004", 
     status = "CONF", 
     basic = true, 
     scalar = false, 
     unit = "") 
    public static final String SKY_OBJECTDENSITY; static { SKY_OBJECTDENSITY = "Nature/Sky_ObjectDensity_003.fits"; } 

    /**
     * Johnson V band sky-background surface brightness seen from space; average value    
     * <p>
     * Source: ESA, 21 May 2013, 'Gaia mission requirements document (MRD)', GAIA-EST-RD-00553, issue 3, revision 1, Requirement SCI-090. See also ESA, July 2000, 'Gaia; Composition, Formation and Evolution of the Galaxy; Concept and Technology Study Report', ESA-SCI(2000)4, Section 6.4.3, page 239<br/>
     * Status: CONF<br/>
     * Unit: mag arcsec^-2<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Johnson V band sky-background surface brightness seen from space; average value", 
     source = "ESA, 21 May 2013, 'Gaia mission requirements document (MRD)', GAIA-EST-RD-00553, issue 3, revision 1, Requirement SCI-090. See also ESA, July 2000, 'Gaia; Composition, Formation and Evolution of the Galaxy; Concept and Technology Study Report', ESA-SCI(2000)4, Section 6.4.3, page 239", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "mag arcsec^-2") 
    public static final double SKY_SURFACEBRIGHTNESS_AVERAGE; static { SKY_SURFACEBRIGHTNESS_AVERAGE = 22.5; } // [mag arcsec^-2] 

    /**
     * Johnson V band sky-background surface brightness seen from space; worst-case value (in the ecliptic)    
     * <p>
     * Source: ESA, July 2000, 'Gaia; Composition, Formation and Evolution of the Galaxy; Concept and Technology Study Report', ESA-SCI(2000)4, Section 6.4.3, page 239<br/>
     * Status: CONF<br/>
     * Unit: mag arcsec^-2<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Johnson V band sky-background surface brightness seen from space; worst-case value (in the ecliptic)", 
     source = "ESA, July 2000, 'Gaia; Composition, Formation and Evolution of the Galaxy; Concept and Technology Study Report', ESA-SCI(2000)4, Section 6.4.3, page 239", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "mag arcsec^-2") 
    public static final double SKY_SURFACEBRIGHTNESS_WORSTCASE; static { SKY_SURFACEBRIGHTNESS_WORSTCASE = 21.0; } // [mag arcsec^-2] 

    /**
     * Sky-averaged density of stars with G <= 20.00 mag. Note that a value of 25.1E3 stars deg^-2 is given in ESA, July 2000, 'Gaia; Composition, Formation and Evolution of the Galaxy; Concept and Technology Study Report', ESA-SCI(2000)4, Section 6.4.5 and Table 6.6, pages 240-242    
     * <p>
     * Source: See also ESA, 21 May 2013, 'Gaia mission requirements document (MRD)', GAIA-EST-RD-00553, issue 3, revision 1, Section 4.1<br/>
     * Status: CONF<br/>
     * Unit: stars deg^-2<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Sky-averaged density of stars with G <= 20.00 mag. Note that a value of 25.1E3 stars deg^-2 is given in ESA, July 2000, 'Gaia; Composition, Formation and Evolution of the Galaxy; Concept and Technology Study Report', ESA-SCI(2000)4, Section 6.4.5 and Table 6.6, pages 240-242", 
     source = "See also ESA, 21 May 2013, 'Gaia mission requirements document (MRD)', GAIA-EST-RD-00553, issue 3, revision 1, Section 4.1", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "stars deg^-2") 
    public static final double SKY_STARDENSITY_AVERAGE; static { SKY_STARDENSITY_AVERAGE = 25089.; } // [stars deg^-2] 

    /**
     * Typical density of stars with G <= 20.00 mag. This value is a typical value encountered in the Galactic plane and, as such, is more representative than the sky-averaged value    
     * <p>
     * Source: J.H.J. de Bruijne, 31 October 2003, 'PDHE load assumptions: properties of the sky', GAIA-JdB-009. See also ESA, 21 May 2013, 'Gaia mission requirements document (MRD)', GAIA-EST-RD-00553, issue 3, revision 1, Section 4.1 and ESA, July 2000, 'Gaia; Composition, Formation and Evolution of the Galaxy; Concept and Technology Study Report', ESA-SCI(2000)4, Section 3.6.6, page 176<br/>
     * Status: CONF<br/>
     * Unit: stars deg^-2<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Typical density of stars with G <= 20.00 mag. This value is a typical value encountered in the Galactic plane and, as such, is more representative than the sky-averaged value", 
     source = "J.H.J. de Bruijne, 31 October 2003, 'PDHE load assumptions: properties of the sky', GAIA-JdB-009. See also ESA, 21 May 2013, 'Gaia mission requirements document (MRD)', GAIA-EST-RD-00553, issue 3, revision 1, Section 4.1 and ESA, July 2000, 'Gaia; Composition, Formation and Evolution of the Galaxy; Concept and Technology Study Report', ESA-SCI(2000)4, Section 3.6.6, page 176", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "stars deg^-2") 
    public static final double SKY_STARDENSITY_TYPICAL; static { SKY_STARDENSITY_TYPICAL = 150000.; } // [stars deg^-2] 

    /**
     * Density of stars with G <= 20.00 mag below which Gaia is designed to operate nominally: nominal observations and all astrometric requirements shall be achieved in the two superimposed fields of view computed using the design object density in one instrument field of view plus the typical object density in the other instrument field of view (Requirement SCI-150). Requirement SCI-160 guarantees that a strategy to observe high-density sky regions (e.g., Baade's window), with stellar densities up to the worst-case star density, will be implemented (if higher densities than the worst-case density are encountered, the brightest objects up to the worst-case density will be observed). One option is to have several successive transits of the same sky region at a reduced precession rate using a modified scanning law (MSL; see L. Lindegren, 7 April 2005, 'Multi-pass scanning across Baade`s Window', GAIA-LL-058, issue 1, revision 0 and L. Lindegren, 22 August 2010, 'Reference Scanning Law for Gaia', GAIA-C3-TN-LU-LL-085-01)    
     * <p>
     * Source: ESA, 21 May 2013, 'Gaia mission requirements document (MRD)', GAIA-EST-RD-00553, issue 3, revision 1, Section 4.1, Requirements SCI-150 and SCI-160<br/>
     * Status: CONF<br/>
     * Unit: stars deg^-2<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Density of stars with G <= 20.00 mag below which Gaia is designed to operate nominally: nominal observations and all astrometric requirements shall be achieved in the two superimposed fields of view computed using the design object density in one instrument field of view plus the typical object density in the other instrument field of view (Requirement SCI-150). Requirement SCI-160 guarantees that a strategy to observe high-density sky regions (e.g., Baade's window), with stellar densities up to the worst-case star density, will be implemented (if higher densities than the worst-case density are encountered, the brightest objects up to the worst-case density will be observed). One option is to have several successive transits of the same sky region at a reduced precession rate using a modified scanning law (MSL; see L. Lindegren, 7 April 2005, 'Multi-pass scanning across Baade`s Window', GAIA-LL-058, issue 1, revision 0 and L. Lindegren, 22 August 2010, 'Reference Scanning Law for Gaia', GAIA-C3-TN-LU-LL-085-01)", 
     source = "ESA, 21 May 2013, 'Gaia mission requirements document (MRD)', GAIA-EST-RD-00553, issue 3, revision 1, Section 4.1, Requirements SCI-150 and SCI-160", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "stars deg^-2") 
    public static final double SKY_STARDENSITY_DESIGN; static { SKY_STARDENSITY_DESIGN = 600000.; } // [stars deg^-2] 

    /**
     * Density of stars with G <= 20.00 mag (worst-case, localised value, e.g., in Baade's window)    
     * <p>
     * Source: ESA, 21 May 2013, 'Gaia mission requirements document (MRD)', GAIA-EST-RD-00553, issue 3, revision 1, Section 4.1. See also ESA, July 2000, 'Gaia; Composition, Formation and Evolution of the Galaxy; Concept and Technology Study Report', ESA-SCI(2000)4, Section 6.5.2, page 244<br/>
     * Status: CONF<br/>
     * Unit: stars deg^-2<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Density of stars with G <= 20.00 mag (worst-case, localised value, e.g., in Baade's window)", 
     source = "ESA, 21 May 2013, 'Gaia mission requirements document (MRD)', GAIA-EST-RD-00553, issue 3, revision 1, Section 4.1. See also ESA, July 2000, 'Gaia; Composition, Formation and Evolution of the Galaxy; Concept and Technology Study Report', ESA-SCI(2000)4, Section 6.5.2, page 244", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "stars deg^-2") 
    public static final double SKY_STARDENSITY_WORSTCASE; static { SKY_STARDENSITY_WORSTCASE = 3.0e+6; } // [stars deg^-2] 

    /**
     * Density of stars with G <= 20.00 mag in the Galactic-latitude ranges 0-5 degrees, 5-10 degrees, 10-20 degrees, 20-30 degrees, and 30-90 degrees    
     * <p>
     * Source: ESA, July 2000, 'Gaia; Composition, Formation and Evolution of the Galaxy; Concept and Technology Study Report', ESA-SCI(2000)4, Section 6.4.5 and Table 6.6, pages 240-242<br/>
     * Status: CONF<br/>
     * Unit: 1E3 stars deg^-2<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Density of stars with G <= 20.00 mag in the Galactic-latitude ranges 0-5 degrees, 5-10 degrees, 10-20 degrees, 20-30 degrees, and 30-90 degrees", 
     source = "ESA, July 2000, 'Gaia; Composition, Formation and Evolution of the Galaxy; Concept and Technology Study Report', ESA-SCI(2000)4, Section 6.4.5 and Table 6.6, pages 240-242", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "1E3 stars deg^-2") 
    public static final double SKY_STARDENSITY_LATITUDE[] = {101.6,  79.8,  31.2,  11.4,  3.8}; // [1E3 stars deg^-2] 

    /**
     * The brighter star-selection limiting magnitude of RVS compared to SM/AF/BP/RP (G_RVS (= C1M861 = RVF) = 17.00 mag versus G = 20.00 mag, respectively) is assumed to correspond to a factor 6 reduction in star density and the number of stars    
     * <p>
     * Source: D. Katz, M. Cropper, J.-M. Desert, et al., 3 November 2006, 'CU6 - Spectroscopic processing - preliminary functional and data-flow analysis', GAIA-C6-TN-OPM-DK-001, issue 3, revision 0, Section 4<br/>
     * Status: CONF<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "The brighter star-selection limiting magnitude of RVS compared to SM/AF/BP/RP (G_RVS (= C1M861 = RVF) = 17.00 mag versus G = 20.00 mag, respectively) is assumed to correspond to a factor 6 reduction in star density and the number of stars", 
     source = "D. Katz, M. Cropper, J.-M. Desert, et al., 3 November 2006, 'CU6 - Spectroscopic processing - preliminary functional and data-flow analysis', GAIA-C6-TN-OPM-DK-001, issue 3, revision 0, Section 4", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "") 
    public static final double SKY_STARDENSITY_RVSREDUCTIONFACTOR; static { SKY_STARDENSITY_RVSREDUCTIONFACTOR = 6.0; } 

    /**
     * Predicted number of observed stars (i.e., G <= 20.00 mag) in the disk (main sequence stars plus white dwarfs)    
     * <p>
     * Source: ESA, July 2000, 'Gaia; Composition, Formation and Evolution of the Galaxy; Concept and Technology Study Report', ESA-SCI(2000)4, Section 6.4.4 and Table 6.3, pages 239-240 (Galaxy model from J. Torra, et al., 1999, 'Predicting Gaia Observations from a Star-Count Model', Baltic Astronomy, 8, 171 and extinction law from J. Hakkila, et al., 1997, 'A Computerised Model of Large-Scale Visual Interstellar Extinction', AJ, 114, 2043)<br/>
     * Status: CONF<br/>
     * Unit: 10^6 stars<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Predicted number of observed stars (i.e., G <= 20.00 mag) in the disk (main sequence stars plus white dwarfs)", 
     source = "ESA, July 2000, 'Gaia; Composition, Formation and Evolution of the Galaxy; Concept and Technology Study Report', ESA-SCI(2000)4, Section 6.4.4 and Table 6.3, pages 239-240 (Galaxy model from J. Torra, et al., 1999, 'Predicting Gaia Observations from a Star-Count Model', Baltic Astronomy, 8, 171 and extinction law from J. Hakkila, et al., 1997, 'A Computerised Model of Large-Scale Visual Interstellar Extinction', AJ, 114, 2043)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "10^6 stars") 
    public static final double SKY_NUMBEROFSTARS_DISKMSPLUSWD; static { SKY_NUMBEROFSTARS_DISKMSPLUSWD = 779.; } // [10^6 stars] 

    /**
     * Predicted number of observed stars (i.e., G <= 20.00 mag) in the disk (giants)    
     * <p>
     * Source: ESA, July 2000, 'Gaia; Composition, Formation and Evolution of the Galaxy; Concept and Technology Study Report', ESA-SCI(2000)4, Section 6.4.4 and Table 6.3, pages 239-240 (Galaxy model from J. Torra, et al., 1999, 'Predicting Gaia Observations from a Star-Count Model', Baltic Astronomy, 8, 171 and extinction law from J. Hakkila, et al., 1997, 'A Computerised Model of Large-Scale Visual Interstellar Extinction', AJ, 114, 2043)<br/>
     * Status: CONF<br/>
     * Unit: 10^6 stars<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Predicted number of observed stars (i.e., G <= 20.00 mag) in the disk (giants)", 
     source = "ESA, July 2000, 'Gaia; Composition, Formation and Evolution of the Galaxy; Concept and Technology Study Report', ESA-SCI(2000)4, Section 6.4.4 and Table 6.3, pages 239-240 (Galaxy model from J. Torra, et al., 1999, 'Predicting Gaia Observations from a Star-Count Model', Baltic Astronomy, 8, 171 and extinction law from J. Hakkila, et al., 1997, 'A Computerised Model of Large-Scale Visual Interstellar Extinction', AJ, 114, 2043)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "10^6 stars") 
    public static final double SKY_NUMBEROFSTARS_DISKGIANT; static { SKY_NUMBEROFSTARS_DISKGIANT = 92.; } // [10^6 stars] 

    /**
     * Predicted number of observed stars (i.e., G <= 20.00 mag) in the thick disk    
     * <p>
     * Source: ESA, July 2000, 'Gaia; Composition, Formation and Evolution of the Galaxy; Concept and Technology Study Report', ESA-SCI(2000)4, Section 6.4.4 and Table 6.3, pages 239-240 (Galaxy model from J. Torra, et al., 1999, 'Predicting Gaia Observations from a Star-Count Model', Baltic Astronomy, 8, 171 and extinction law from J. Hakkila, et al., 1997, 'A Computerised Model of Large-Scale Visual Interstellar Extinction', AJ, 114, 2043)<br/>
     * Status: CONF<br/>
     * Unit: 10^6 stars<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Predicted number of observed stars (i.e., G <= 20.00 mag) in the thick disk", 
     source = "ESA, July 2000, 'Gaia; Composition, Formation and Evolution of the Galaxy; Concept and Technology Study Report', ESA-SCI(2000)4, Section 6.4.4 and Table 6.3, pages 239-240 (Galaxy model from J. Torra, et al., 1999, 'Predicting Gaia Observations from a Star-Count Model', Baltic Astronomy, 8, 171 and extinction law from J. Hakkila, et al., 1997, 'A Computerised Model of Large-Scale Visual Interstellar Extinction', AJ, 114, 2043)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "10^6 stars") 
    public static final double SKY_NUMBEROFSTARS_THICKDISK; static { SKY_NUMBEROFSTARS_THICKDISK = 97.; } // [10^6 stars] 

    /**
     * Predicted number of observed stars (i.e., G <= 20.00 mag) in the spheroid (including the bulge)    
     * <p>
     * Source: ESA, July 2000, 'Gaia; Composition, Formation and Evolution of the Galaxy; Concept and Technology Study Report', ESA-SCI(2000)4, Section 6.4.4 and Table 6.3, pages 239-240 (Galaxy model from J. Torra, et al., 1999, 'Predicting Gaia Observations from a Star-Count Model', Baltic Astronomy, 8, 171 and extinction law from J. Hakkila, et al., 1997, 'A Computerised Model of Large-Scale Visual Interstellar Extinction', AJ, 114, 2043)<br/>
     * Status: CONF<br/>
     * Unit: 10^6 stars<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Predicted number of observed stars (i.e., G <= 20.00 mag) in the spheroid (including the bulge)", 
     source = "ESA, July 2000, 'Gaia; Composition, Formation and Evolution of the Galaxy; Concept and Technology Study Report', ESA-SCI(2000)4, Section 6.4.4 and Table 6.3, pages 239-240 (Galaxy model from J. Torra, et al., 1999, 'Predicting Gaia Observations from a Star-Count Model', Baltic Astronomy, 8, 171 and extinction law from J. Hakkila, et al., 1997, 'A Computerised Model of Large-Scale Visual Interstellar Extinction', AJ, 114, 2043)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "10^6 stars") 
    public static final double SKY_NUMBEROFSTARS_SPHEROID; static { SKY_NUMBEROFSTARS_SPHEROID = 67.; } // [10^6 stars] 

    /**
     * Predicted total number of observed stars (i.e., G <= 20.00 mag)    
     * <p>
     * Source: See also ESA, 21 May 2013, 'Gaia mission requirements document (MRD)', GAIA-EST-RD-00553, issue 3, revision 1, Requirement SCI-130<br/>
     * Status: CONF<br/>
     * Unit: stars<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Predicted total number of observed stars (i.e., G <= 20.00 mag)", 
     source = "See also ESA, 21 May 2013, 'Gaia mission requirements document (MRD)', GAIA-EST-RD-00553, issue 3, revision 1, Requirement SCI-130", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "stars") 
    public static final double SKY_NUMBEROFSTARS_TOTAL; static { SKY_NUMBEROFSTARS_TOTAL = 1.0350e+9; } // [stars] 

    /**
     * Cumulative number of stars, integrated over the full sky, as function of G magnitude for the following limits: up to G = 4.5 mag, up to G = 5.0 mag, ..., up to G = 20.5 mag, and up to G = 21.0 mag (numerical values from parameter Sky_ObjectDensity_003, extracted by B. Holl on 4 October 2012 using GT SkyDensity.class). See parameter Sky_NumberOfGalaxies_G for galaxy counts and Sky_NumberOfObjects_G for object counts    
     * <p>
     * Source: The data used to produce the standard Gaia Galaxy model have been provided by the teams of the Observatoire de Besancon (A. Robin, C. Reyle, et al.) and the Observatorio Astronomico di Torino (R. Drimmel, et al.); the harmonisation has been provided by the SWG (X. Luri). See U. Lammers, 22 April 2005, 'Gaia Standard Galaxy Model Access Software (GSGMAS); User Guide', GAIA-UL-010, issue 1, revision 0. See also R. Drimmel, et al., 19 July 2005, 'Recommendations on the use of estimated star counts for Gaia studies', SWG-RD-004<br/>
     * Status: CONF<br/>
     * Unit: 10^6 objects<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Cumulative number of stars, integrated over the full sky, as function of G magnitude for the following limits: up to G = 4.5 mag, up to G = 5.0 mag, ..., up to G = 20.5 mag, and up to G = 21.0 mag (numerical values from parameter Sky_ObjectDensity_003, extracted by B. Holl on 4 October 2012 using GT SkyDensity.class). See parameter Sky_NumberOfGalaxies_G for galaxy counts and Sky_NumberOfObjects_G for object counts", 
     source = "The data used to produce the standard Gaia Galaxy model have been provided by the teams of the Observatoire de Besancon (A. Robin, C. Reyle, et al.) and the Observatorio Astronomico di Torino (R. Drimmel, et al.); the harmonisation has been provided by the SWG (X. Luri). See U. Lammers, 22 April 2005, 'Gaia Standard Galaxy Model Access Software (GSGMAS); User Guide', GAIA-UL-010, issue 1, revision 0. See also R. Drimmel, et al., 19 July 2005, 'Recommendations on the use of estimated star counts for Gaia studies', SWG-RD-004", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "10^6 objects") 
    public static final double SKY_NUMBEROFSTARS_G[] = {0.003,  0.007,  0.014,  0.026,  0.044,  0.070,  0.107,  0.160,  0.241,  0.356,  0.522,  0.768,  1.141,  1.715,  2.640,  4.053,  6.267,  9.708,  14.749,  22.060,  32.547,  47.450,  68.441,  97.595,  137.435,  191.424,  263.806,  359.935,  488.497,  660.937,  890.460,  1192.338,  1584.350,  2081.548}; // [10^6 objects] 

    /**
     * Cumulative number of galaxies, integrated over the full sky, as function of G magnitude for the following limits: up to G = 4.5 mag, up to G = 5.0 mag, ..., up to G = 20.5 mag, and up to G = 21.0 mag (numerical values from parameter Sky_ObjectDensity_003, extracted by B. Holl on 4 October 2012 using GT SkyDensity.class). See parameter Sky_NumberOfStars_G for star counts and Sky_NumberOfObjects_G for object counts    
     * <p>
     * Source: The data used to produce the standard Gaia Galaxy model have been provided by the teams of the Observatoire de Besancon (A. Robin, C. Reyle, et al.) and the Observatorio Astronomico di Torino (R. Drimmel, et al.); the harmonisation has been provided by the SWG (X. Luri). See U. Lammers, 22 April 2005, 'Gaia Standard Galaxy Model Access Software (GSGMAS); User Guide', GAIA-UL-010, issue 1, revision 0. See also R. Drimmel, et al., 19 July 2005, 'Recommendations on the use of estimated star counts for Gaia studies', SWG-RD-004<br/>
     * Status: CONF<br/>
     * Unit: 10^6 objects<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Cumulative number of galaxies, integrated over the full sky, as function of G magnitude for the following limits: up to G = 4.5 mag, up to G = 5.0 mag, ..., up to G = 20.5 mag, and up to G = 21.0 mag (numerical values from parameter Sky_ObjectDensity_003, extracted by B. Holl on 4 October 2012 using GT SkyDensity.class). See parameter Sky_NumberOfStars_G for star counts and Sky_NumberOfObjects_G for object counts", 
     source = "The data used to produce the standard Gaia Galaxy model have been provided by the teams of the Observatoire de Besancon (A. Robin, C. Reyle, et al.) and the Observatorio Astronomico di Torino (R. Drimmel, et al.); the harmonisation has been provided by the SWG (X. Luri). See U. Lammers, 22 April 2005, 'Gaia Standard Galaxy Model Access Software (GSGMAS); User Guide', GAIA-UL-010, issue 1, revision 0. See also R. Drimmel, et al., 19 July 2005, 'Recommendations on the use of estimated star counts for Gaia studies', SWG-RD-004", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "10^6 objects") 
    public static final double SKY_NUMBEROFGALAXIES_G[] = {0.000,  0.000,  0.000,  0.000,  0.000,  0.000,  0.000,  0.000,  0.000,  0.000,  0.000,  0.000,  0.000,  0.000,  0.000,  0.000,  0.000,  0.000,  0.000,  0.000,  0.009,  0.038,  0.104,  0.241,  0.509,  0.983,  1.822,  3.326,  6.048,  11.075,  21.145,  41.602,  82.794,  166.012}; // [10^6 objects] 

    /**
     * Cumulative number of objects (stars + galaxies; see parameters Sky_NumberOfStars_G and Sky_NumberOfGalaxies_G), integrated over the full sky, as function of G magnitude for the following limits: up to G = 4.5 mag, up to G = 5.0 mag, ..., up to G = 20.5 mag, and up to G = 21.0 mag (numerical values from parameter Sky_ObjectDensity_003, extracted by B. Holl on 4 October 2012 using GT SkyDensity.class)    
     * <p>
     * Source: The data used to produce the standard Gaia Galaxy model have been provided by the teams of the Observatoire de Besancon (A. Robin, C. Reyle, et al.) and the Observatorio Astronomico di Torino (R. Drimmel, et al.); the harmonisation has been provided by the SWG (X. Luri). See U. Lammers, 22 April 2005, 'Gaia Standard Galaxy Model Access Software (GSGMAS); User Guide', GAIA-UL-010, issue 1, revision 0. See also R. Drimmel, et al., 19 July 2005, 'Recommendations on the use of estimated star counts for Gaia studies', SWG-RD-004<br/>
     * Status: CONF<br/>
     * Unit: 10^6 objects<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Cumulative number of objects (stars + galaxies; see parameters Sky_NumberOfStars_G and Sky_NumberOfGalaxies_G), integrated over the full sky, as function of G magnitude for the following limits: up to G = 4.5 mag, up to G = 5.0 mag, ..., up to G = 20.5 mag, and up to G = 21.0 mag (numerical values from parameter Sky_ObjectDensity_003, extracted by B. Holl on 4 October 2012 using GT SkyDensity.class)", 
     source = "The data used to produce the standard Gaia Galaxy model have been provided by the teams of the Observatoire de Besancon (A. Robin, C. Reyle, et al.) and the Observatorio Astronomico di Torino (R. Drimmel, et al.); the harmonisation has been provided by the SWG (X. Luri). See U. Lammers, 22 April 2005, 'Gaia Standard Galaxy Model Access Software (GSGMAS); User Guide', GAIA-UL-010, issue 1, revision 0. See also R. Drimmel, et al., 19 July 2005, 'Recommendations on the use of estimated star counts for Gaia studies', SWG-RD-004", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "10^6 objects") 
    public static final double SKY_NUMBEROFOBJECTS_G[] = {0.003,  0.007,  0.014,  0.026,  0.044,  0.070,  0.107,  0.160,  0.241,  0.356,  0.522,  0.768,  1.141,  1.715,  2.640,  4.053,  6.267,  9.708,  14.749,  22.060,  32.556,  47.488,  68.545,  97.837,  137.944,  192.408,  265.629,  363.261,  494.546,  672.011,  911.605,  1233.940,  1667.145,  2247.560}; // [10^6 objects] 

    /**
     * Cumulative number of stars, integrated over the full sky, as function of G_RVS (= C1M861 = RVF) magnitude for the following limits: up to G_RVS = 4.5 mag, up to G_RVS = 5.0 mag, ..., up to G_RVS = 17.5 mag, and up to G_RVS = 18.0 mag (numerical values from parameter Sky_ObjectDensity_003, extracted by B. Holl on 4 October 2012 using GT SkyDensity.class). See parameter Sky_NumberOfGalaxies_GRVS for galaxy counts and Sky_NumberOfObjects_GRVS for object counts    
     * <p>
     * Source: The data used to produce the standard Gaia Galaxy model have been provided by the teams of the Observatoire de Besancon (A. Robin, C. Reyle, et al.) and the Observatorio Astronomico di Torino (R. Drimmel, et al.); the harmonisation has been provided by the SWG (X. Luri). See U. Lammers, 22 April 2005, 'Gaia Standard Galaxy Model Access Software (GSGMAS); User Guide', GAIA-UL-010, issue 1, revision 0. See also R. Drimmel, et al., 19 July 2005, 'Recommendations on the use of estimated star counts for Gaia studies', SWG-RD-004<br/>
     * Status: CONF<br/>
     * Unit: 10^6 objects<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Cumulative number of stars, integrated over the full sky, as function of G_RVS (= C1M861 = RVF) magnitude for the following limits: up to G_RVS = 4.5 mag, up to G_RVS = 5.0 mag, ..., up to G_RVS = 17.5 mag, and up to G_RVS = 18.0 mag (numerical values from parameter Sky_ObjectDensity_003, extracted by B. Holl on 4 October 2012 using GT SkyDensity.class). See parameter Sky_NumberOfGalaxies_GRVS for galaxy counts and Sky_NumberOfObjects_GRVS for object counts", 
     source = "The data used to produce the standard Gaia Galaxy model have been provided by the teams of the Observatoire de Besancon (A. Robin, C. Reyle, et al.) and the Observatorio Astronomico di Torino (R. Drimmel, et al.); the harmonisation has been provided by the SWG (X. Luri). See U. Lammers, 22 April 2005, 'Gaia Standard Galaxy Model Access Software (GSGMAS); User Guide', GAIA-UL-010, issue 1, revision 0. See also R. Drimmel, et al., 19 July 2005, 'Recommendations on the use of estimated star counts for Gaia studies', SWG-RD-004", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "10^6 objects") 
    public static final double SKY_NUMBEROFSTARS_GRVS[] = {0.018,  0.042,  0.072,  0.111,  0.160,  0.227,  0.320,  0.460,  0.675,  0.995,  1.471,  2.196,  3.293,  4.902,  7.280,  10.876,  16.184,  23.915,  35.147,  51.347,  74.587,  107.488,  153.490,  216.557,  302.033,  417.361,  573.879,  788.939}; // [10^6 objects] 

    /**
     * Cumulative number of galaxies, integrated over the full sky, as function of G_RVS (= C1M861 = RVF) magnitude for the following limits: up to G_RVS = 4.5 mag, up to G_RVS = 5.0 mag, ..., up to G_RVS = 17.5 mag, and up to G_RVS = 18.0 mag (numerical values from parameter Sky_ObjectDensity_003, extracted by B. Holl on 4 October 2012 using GT SkyDensity.class). See parameter Sky_NumberOfStars_GRVS for star counts and Sky_NumberOfObjects_GRVS for object counts    
     * <p>
     * Source: The data used to produce the standard Gaia Galaxy model have been provided by the teams of the Observatoire de Besancon (A. Robin, C. Reyle, et al.) and the Observatorio Astronomico di Torino (R. Drimmel, et al.); the harmonisation has been provided by the SWG (X. Luri). See U. Lammers, 22 April 2005, 'Gaia Standard Galaxy Model Access Software (GSGMAS); User Guide', GAIA-UL-010, issue 1, revision 0. See also R. Drimmel, et al., 19 July 2005, 'Recommendations on the use of estimated star counts for Gaia studies', SWG-RD-004<br/>
     * Status: CONF<br/>
     * Unit: 10^6 objects<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Cumulative number of galaxies, integrated over the full sky, as function of G_RVS (= C1M861 = RVF) magnitude for the following limits: up to G_RVS = 4.5 mag, up to G_RVS = 5.0 mag, ..., up to G_RVS = 17.5 mag, and up to G_RVS = 18.0 mag (numerical values from parameter Sky_ObjectDensity_003, extracted by B. Holl on 4 October 2012 using GT SkyDensity.class). See parameter Sky_NumberOfStars_GRVS for star counts and Sky_NumberOfObjects_GRVS for object counts", 
     source = "The data used to produce the standard Gaia Galaxy model have been provided by the teams of the Observatoire de Besancon (A. Robin, C. Reyle, et al.) and the Observatorio Astronomico di Torino (R. Drimmel, et al.); the harmonisation has been provided by the SWG (X. Luri). See U. Lammers, 22 April 2005, 'Gaia Standard Galaxy Model Access Software (GSGMAS); User Guide', GAIA-UL-010, issue 1, revision 0. See also R. Drimmel, et al., 19 July 2005, 'Recommendations on the use of estimated star counts for Gaia studies', SWG-RD-004", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "10^6 objects") 
    public static final double SKY_NUMBEROFGALAXIES_GRVS[] = {0.000,  0.000,  0.000,  0.000,  0.000,  0.000,  0.000,  0.000,  0.000,  0.000,  0.000,  0.000,  0.000,  0.000,  0.000,  0.000,  0.000,  0.000,  0.010,  0.040,  0.111,  0.255,  0.537,  1.032,  1.912,  3.490,  6.349,  11.607}; // [10^6 objects] 

    /**
     * Cumulative number of objects (stars + galaxies; see parameters Sky_NumberOfStars_GRVS and Sky_NumberOfGalaxies_GRVS), integrated over the full sky, as function of G_RVS (= C1M861 = RVF) magnitude for the following limits: up to G_RVS = 4.5 mag, up to G_RVS = 5.0 mag, ..., up to G_RVS = 17.5 mag, and up to G_RVS = 18.0 mag (numerical values from parameter Sky_ObjectDensity_003, extracted by B. Holl on 4 October 2012 using GT SkyDensity.class)    
     * <p>
     * Source: The data used to produce the standard Gaia Galaxy model have been provided by the teams of the Observatoire de Besancon (A. Robin, C. Reyle, et al.) and the Observatorio Astronomico di Torino (R. Drimmel, et al.); the harmonisation has been provided by the SWG (X. Luri). See U. Lammers, 22 April 2005, 'Gaia Standard Galaxy Model Access Software (GSGMAS); User Guide', GAIA-UL-010, issue 1, revision 0. See also R. Drimmel, et al., 19 July 2005, 'Recommendations on the use of estimated star counts for Gaia studies', SWG-RD-004<br/>
     * Status: CONF<br/>
     * Unit: 10^6 objects<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Cumulative number of objects (stars + galaxies; see parameters Sky_NumberOfStars_GRVS and Sky_NumberOfGalaxies_GRVS), integrated over the full sky, as function of G_RVS (= C1M861 = RVF) magnitude for the following limits: up to G_RVS = 4.5 mag, up to G_RVS = 5.0 mag, ..., up to G_RVS = 17.5 mag, and up to G_RVS = 18.0 mag (numerical values from parameter Sky_ObjectDensity_003, extracted by B. Holl on 4 October 2012 using GT SkyDensity.class)", 
     source = "The data used to produce the standard Gaia Galaxy model have been provided by the teams of the Observatoire de Besancon (A. Robin, C. Reyle, et al.) and the Observatorio Astronomico di Torino (R. Drimmel, et al.); the harmonisation has been provided by the SWG (X. Luri). See U. Lammers, 22 April 2005, 'Gaia Standard Galaxy Model Access Software (GSGMAS); User Guide', GAIA-UL-010, issue 1, revision 0. See also R. Drimmel, et al., 19 July 2005, 'Recommendations on the use of estimated star counts for Gaia studies', SWG-RD-004", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "10^6 objects") 
    public static final double SKY_NUMBEROFOBJECTS_GRVS[] = {0.018,  0.042,  0.072,  0.111,  0.160,  0.227,  0.320,  0.460,  0.675,  0.995,  1.471,  2.196,  3.293,  4.902,  7.280,  10.876,  16.184,  23.915,  35.157,  51.387,  74.697,  107.743,  154.027,  217.589,  303.945,  420.851,  580.228,  800.547}; // [10^6 objects] 

    /**
     * Maximum-sustainable solar-proton flux at L2, in units of particles cm^-2 s^-1. Normally, outside periods of solar activity (solar flares), the solar-proton flux will be negligibly small. During solar activity (solar flares), solar-proton fluxes vary strongly with time, reaching peak levels of 1E6 particles cm^-2 s^-1 or higher. Note that cosmic rays and solar protons are distinct particles, collectively refered to as prompt-particle events (PPEs). A PPE rate of 1300 particles cm^-2 s^-1 is assumed to correspond to the operational limit below which Gaia functions nominally and above which the spacecraft will be in AOCS TranSition Mode (TSM). An isotropic prompt-particle event flux N, in units of events cm^-2 s^-1, generates 2 N A / 4 events s^-1 CCD^-1, where A denotes the active-pixel area of the CCD in units of cm^2 (including any reduction as a result of TDI-gating), the factor 2 results from considering 'inflow' through both the illuminated and the non-illuminated faces of the CCD, and the factor 4 results from the 'flat geometry' of the CCD (see J.H.J. de Bruijne, A. Short, 7 September 2005, 'prompt-particle events: from fluxes to count rates', GAIA-JdB-026, issue 1, revision 0)    
     * <p>
     * Source: EADS-Astrium, 3 March 2011, 'Dead-time budget', GAIA.ASF.TCN.SAT.00133, issue 5, revision 1<br/>
     * Status: CONF<br/>
     * Unit: particles cm^-2 s^-1<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Maximum-sustainable solar-proton flux at L2, in units of particles cm^-2 s^-1. Normally, outside periods of solar activity (solar flares), the solar-proton flux will be negligibly small. During solar activity (solar flares), solar-proton fluxes vary strongly with time, reaching peak levels of 1E6 particles cm^-2 s^-1 or higher. Note that cosmic rays and solar protons are distinct particles, collectively refered to as prompt-particle events (PPEs). A PPE rate of 1300 particles cm^-2 s^-1 is assumed to correspond to the operational limit below which Gaia functions nominally and above which the spacecraft will be in AOCS TranSition Mode (TSM). An isotropic prompt-particle event flux N, in units of events cm^-2 s^-1, generates 2 N A / 4 events s^-1 CCD^-1, where A denotes the active-pixel area of the CCD in units of cm^2 (including any reduction as a result of TDI-gating), the factor 2 results from considering 'inflow' through both the illuminated and the non-illuminated faces of the CCD, and the factor 4 results from the 'flat geometry' of the CCD (see J.H.J. de Bruijne, A. Short, 7 September 2005, 'prompt-particle events: from fluxes to count rates', GAIA-JdB-026, issue 1, revision 0)", 
     source = "EADS-Astrium, 3 March 2011, 'Dead-time budget', GAIA.ASF.TCN.SAT.00133, issue 5, revision 1", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "particles cm^-2 s^-1") 
    public static final double SOLARPROTON_FLUX_L2; static { SOLARPROTON_FLUX_L2 = 1300.; } // [particles cm^-2 s^-1] 

    /**
     * Catalogue containing CCD images, in units of photo-electrons, of typical solar-proton events for an AF CCD (used in BAM, WFS, SM, and AF; this CCD is also used in BP albeit with a different anti-reflection coating). Normally, outside periods of solar activity (solar flares), the solar-proton flux will be negligibly small. During solar activity (solar flares), solar-proton fluxes vary strongly with time, reaching peak levels of 1E6 particles cm^-2 s^-1 or higher. Note that cosmic rays and solar protons are distinct particles, collectively refered to as prompt-particle events (PPEs). The catalogue contains 12954 events. The structure of the FITS file is as follows: the first FITS-file extension contains a list of events containing event number, number of pixels across-scan in the image, and number of pixels along-scan in the image. The following extensions contain the individual images ('pixel matrices'), in units of photo-electron counts, one image per extension    
     * <p>
     * Source: A. Short (ESA), priv. comm., 12 May 2006<br/>
     * Status: CONF<br/>
     * Unit: e^-<br/>
     * Basic : true<br/>
     * Scalar: false
     */
    @ParamMetaData (
    description = "Catalogue containing CCD images, in units of photo-electrons, of typical solar-proton events for an AF CCD (used in BAM, WFS, SM, and AF; this CCD is also used in BP albeit with a different anti-reflection coating). Normally, outside periods of solar activity (solar flares), the solar-proton flux will be negligibly small. During solar activity (solar flares), solar-proton fluxes vary strongly with time, reaching peak levels of 1E6 particles cm^-2 s^-1 or higher. Note that cosmic rays and solar protons are distinct particles, collectively refered to as prompt-particle events (PPEs). The catalogue contains 12954 events. The structure of the FITS file is as follows: the first FITS-file extension contains a list of events containing event number, number of pixels across-scan in the image, and number of pixels along-scan in the image. The following extensions contain the individual images ('pixel matrices'), in units of photo-electron counts, one image per extension", 
     source = "A. Short (ESA), priv. comm., 12 May 2006", 
     status = "CONF", 
     basic = true, 
     scalar = false, 
     unit = "e^-") 
    public static final String SOLARPROTON_CATALOGUE_AFCCD; static { SOLARPROTON_CATALOGUE_AFCCD = "Nature/SolarProton_Catalogue_AFCCD_001.fits"; } // [e^-] 

    /**
     * Catalogue containing CCD images, in units of photo-electrons, of typical solar-proton events for a red-enhanced CCD (used in RP and RVS). Normally, outside periods of solar activity (solar flares), the solar-proton flux will be negligibly small. During solar activity (solar flares), solar-proton fluxes vary strongly with time, reaching peak levels of 1E6 particles cm^-2 s^-1 or higher. Note that cosmic rays and solar protons are distinct particles, collectively refered to as prompt-particle events (PPEs). The catalogue contains 4950 events. The structure of the FITS file is as follows: the first FITS-file extension contains a list of events containing event number, number of pixels across-scan in the image, and number of pixels along-scan in the image. The following extensions contain the individual images ('pixel matrices'), in units of photo-electron counts, one image per extension    
     * <p>
     * Source: A. Short (ESA), priv. comm., 1 September 2008<br/>
     * Status: CONF<br/>
     * Unit: e^-<br/>
     * Basic : true<br/>
     * Scalar: false
     */
    @ParamMetaData (
    description = "Catalogue containing CCD images, in units of photo-electrons, of typical solar-proton events for a red-enhanced CCD (used in RP and RVS). Normally, outside periods of solar activity (solar flares), the solar-proton flux will be negligibly small. During solar activity (solar flares), solar-proton fluxes vary strongly with time, reaching peak levels of 1E6 particles cm^-2 s^-1 or higher. Note that cosmic rays and solar protons are distinct particles, collectively refered to as prompt-particle events (PPEs). The catalogue contains 4950 events. The structure of the FITS file is as follows: the first FITS-file extension contains a list of events containing event number, number of pixels across-scan in the image, and number of pixels along-scan in the image. The following extensions contain the individual images ('pixel matrices'), in units of photo-electron counts, one image per extension", 
     source = "A. Short (ESA), priv. comm., 1 September 2008", 
     status = "CONF", 
     basic = true, 
     scalar = false, 
     unit = "e^-") 
    public static final String SOLARPROTON_CATALOGUE_REDENHANCEDCCD; static { SOLARPROTON_CATALOGUE_REDENHANCEDCCD = "Nature/SolarProton_Catalogue_RedEnhancedCCD_001.fits"; } // [e^-] 

    /**
     * Space sink temperature at L2    
     * <p>
     * Source: European Cooperation for Space Standards (ECSS), 15 November 2008, 'Space environment standard', ECSS-E-ST-10-04C, Section 6.2.1 (http://www.ecss.nl/)<br/>
     * Status: CONF<br/>
     * Unit: K<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Space sink temperature at L2", 
     source = "European Cooperation for Space Standards (ECSS), 15 November 2008, 'Space environment standard', ECSS-E-ST-10-04C, Section 6.2.1 (http://www.ecss.nl/)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "K") 
    public static final double SPACE_TEMPERATURE_L2; static { SPACE_TEMPERATURE_L2 = 3.; } // [K] 

    /**
     * Specific gas constant for dry air, defined as the molar gas constant (:Nature:MolarGas_Constant) divided by the molar mass (which is 0.0289644 kg mol^-1 for the International Standard Atmopshere)    
     * <p>
     * Source: F. Kleijer (Netherlands Geodetic Commission, Delft), 1 April 2004, 'Troposphere Modeling and Filtering for Precise GPS Leveling', Publications on Geodesy 56, ISBN 90 6132 284 7 (http://www.ncg.knaw.nl/Publicaties/Geodesy/pdf/56Kleijer.pdf and http://repository.tudelft.nl/view/ir/uuid%3Aea1f0cf0-4e48-421b-b7ae-4ae3e36d1880/)<br/>
     * Status: CONF<br/>
     * Unit: m^2 s^-2 K^-1<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Specific gas constant for dry air, defined as the molar gas constant (:Nature:MolarGas_Constant) divided by the molar mass (which is 0.0289644 kg mol^-1 for the International Standard Atmopshere)", 
     source = "F. Kleijer (Netherlands Geodetic Commission, Delft), 1 April 2004, 'Troposphere Modeling and Filtering for Precise GPS Leveling', Publications on Geodesy 56, ISBN 90 6132 284 7 (http://www.ncg.knaw.nl/Publicaties/Geodesy/pdf/56Kleijer.pdf and http://repository.tudelft.nl/view/ir/uuid%3Aea1f0cf0-4e48-421b-b7ae-4ae3e36d1880/)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "m^2 s^-2 K^-1") 
    public static final double SPECIFICGAS_CONSTANT_DRYAIR; static { SPECIFICGAS_CONSTANT_DRYAIR = 287.060; } // [m^2 s^-2 K^-1] 

    /**
     * Specific gas constant for water vapour, defined as the molar gas constant (:Nature:MolarGas_Constant) divided by the molar mass (which is 0.0180152 kg mol^-1)    
     * <p>
     * Source: F. Kleijer (Netherlands Geodetic Commission, Delft), 1 April 2004, 'Troposphere Modeling and Filtering for Precise GPS Leveling', Publications on Geodesy 56, ISBN 90 6132 284 7 (http://www.ncg.knaw.nl/Publicaties/Geodesy/pdf/56Kleijer.pdf and http://repository.tudelft.nl/view/ir/uuid%3Aea1f0cf0-4e48-421b-b7ae-4ae3e36d1880/)<br/>
     * Status: CONF<br/>
     * Unit: m^2 s^-2 K^-1<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Specific gas constant for water vapour, defined as the molar gas constant (:Nature:MolarGas_Constant) divided by the molar mass (which is 0.0180152 kg mol^-1)", 
     source = "F. Kleijer (Netherlands Geodetic Commission, Delft), 1 April 2004, 'Troposphere Modeling and Filtering for Precise GPS Leveling', Publications on Geodesy 56, ISBN 90 6132 284 7 (http://www.ncg.knaw.nl/Publicaties/Geodesy/pdf/56Kleijer.pdf and http://repository.tudelft.nl/view/ir/uuid%3Aea1f0cf0-4e48-421b-b7ae-4ae3e36d1880/)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "m^2 s^-2 K^-1") 
    public static final double SPECIFICGAS_CONSTANT_WATERVAPOUR; static { SPECIFICGAS_CONSTANT_WATERVAPOUR = 461.525; } // [m^2 s^-2 K^-1] 

    /**
     * Velocity vector of the Solar-System BaryCentre (SSBC) with respect to the Cosmic Microwave Background (CMB), in units of km s^-1. The vector elements refer to Galactic (U,V,W) coordinates    
     * <p>
     * Source: G. Hinshaw, et al., 11 February 2009, 'Five-Year Wilkinson Microwave Anisotropy Probe (WMAP) Observations: Data Processing, Sky Maps, and Basic Results', Astrophysical Journal Supplement (ApJS), Volume 180, pages 225-245<br/>
     * Status: CONF<br/>
     * Unit: km s^-1<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Velocity vector of the Solar-System BaryCentre (SSBC) with respect to the Cosmic Microwave Background (CMB), in units of km s^-1. The vector elements refer to Galactic (U,V,W) coordinates", 
     source = "G. Hinshaw, et al., 11 February 2009, 'Five-Year Wilkinson Microwave Anisotropy Probe (WMAP) Observations: Data Processing, Sky Maps, and Basic Results', Astrophysical Journal Supplement (ApJS), Volume 180, pages 225-245", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "km s^-1") 
    public static final double SSBC_VELOCITYCMB[] = {-26.29,  -244.96,  +275.93}; // [km s^-1] 

    /**
     * Stefan-Boltzmann constant. Note: best-measured value equals 5.670367E-8 (P.J. Mohr, B.N. Taylor, D.B. Newell, 9 July 2015, 'The 2014 CODATA Recommended Values of the Fundamental Physical Constants', National Institute of Standards and Technology, Gaithersburg, MD 20899-8401; http://www.codata.org/ and http://physics.nist.gov/constants (Web Version 7.0))    
     * <p>
     * Status: CONF<br/>
     * Unit: W m^-2 K^-4<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Stefan-Boltzmann constant. Note: best-measured value equals 5.670367E-8 (P.J. Mohr, B.N. Taylor, D.B. Newell, 9 July 2015, 'The 2014 CODATA Recommended Values of the Fundamental Physical Constants', National Institute of Standards and Technology, Gaithersburg, MD 20899-8401; http://www.codata.org/ and http://physics.nist.gov/constants (Web Version 7.0))", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "W m^-2 K^-4") 
    public static final double STEFANBOLTZMANN_CONSTANT; static { STEFANBOLTZMANN_CONSTANT = 5.6703666e-8; } // [W m^-2 K^-4] 

    /**
     * One steradian in units of square degrees    
     * <p>
     * Status: CONF<br/>
     * Unit: deg^2<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "One steradian in units of square degrees", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "deg^2") 
    public static final double STERADIAN_DEGREESQUARE; static { STERADIAN_DEGREESQUARE = 3282.80635001174; } // [deg^2] 

    /**
     * Spectrum f_{\odot\nu}(\lambda) of the Sun: Kurucz/ATLAS9 spectrum (CDROM 19). First column: wavelength \lambda (in nm; from 115.0 to 1062.0). Second column: Eddington flux (in W m^-2 Hz^-1 steradian^-1). Note that the flux at 115.0 nm was obtained using linear interpolation between the available fluxes at 114.5 and 115.5 nm (0.6745E-15 and 0.8131E-15, respectively). Note that the flux at 1062.0 nm was obtained using linear interpolation between the available fluxes at 1057.5 and 1062.5 nm (0.8892E-05 and 0.8861E-05, respectively)    
     * <p>
     * Source: C. Jordi, priv. comm., 17 February 2003; see also http://gaia.am.ub.es/PWG/sun.mod. Note that data beyond the current wavelength limits are available<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: false
     */
    @ParamMetaData (
    description = "Spectrum f_{\\odot\\nu}(\\lambda) of the Sun: Kurucz/ATLAS9 spectrum (CDROM 19). First column: wavelength \\lambda (in nm; from 115.0 to 1062.0). Second column: Eddington flux (in W m^-2 Hz^-1 steradian^-1). Note that the flux at 115.0 nm was obtained using linear interpolation between the available fluxes at 114.5 and 115.5 nm (0.6745E-15 and 0.8131E-15, respectively). Note that the flux at 1062.0 nm was obtained using linear interpolation between the available fluxes at 1057.5 and 1062.5 nm (0.8892E-05 and 0.8861E-05, respectively)", 
     source = "C. Jordi, priv. comm., 17 February 2003; see also http://gaia.am.ub.es/PWG/sun.mod. Note that data beyond the current wavelength limits are available", 
     status = "CONF", 
     basic = true, 
     scalar = false, 
     unit = "") 
    public static final String SUN_SPECTRUM_NU; static { SUN_SPECTRUM_NU = "Nature/Sun_Spectrum_Nu_001.fits"; } 

    /**
     * Chebyshev representation of the ephemerides of the Sun, with origin at the barycentre of the solar system (BCRS), in the equatorial ICRF frame. The ephemeris covers the period starting on JD (JDBEGIP + JDBEGFP) and ending on JD (JDENDIP + JDENDFP) for the position and starting on JD (JDBEGIV + JDBEGFV) and ending on JD (JDENDIV + JDENDFV) for the velocity. A number of Chebyshev coefficients equal to ORDERSP is given for NSSP time intervals of SPANSP days to describe the position-vector components in units of m; the similar parameters ending with PP (Peculiar Position) are not used in the current release and are reserved for future usage. A number of Chebyshev coefficients equal to ORDERSV is given for NSSV time intervals of SPANSV days to describe the velocity-vector components in units of m s^-1; the similar parameters ending with PV (Peculiar Velocity) are not used in the current release and are reserved for future usage. The first three HDUs contain the coefficients for the three components of the position, while the last three HDUs contain the coefficients for the three components of the velocity    
     * <p>
     * Source: A. Fienga, J. Laskar, H. Manche, M. Gastineau, 19 April 2007, 'Solar system planetary ephemeris delivery: INPOP06', GAIA-CA-TN-IMC-AF-001, issue 1, revision 0<br/>
     * Status: DEPR<br/>
     * Basic : true<br/>
     * Scalar: false
     */
    @ParamMetaData (
    description = "Chebyshev representation of the ephemerides of the Sun, with origin at the barycentre of the solar system (BCRS), in the equatorial ICRF frame. The ephemeris covers the period starting on JD (JDBEGIP + JDBEGFP) and ending on JD (JDENDIP + JDENDFP) for the position and starting on JD (JDBEGIV + JDBEGFV) and ending on JD (JDENDIV + JDENDFV) for the velocity. A number of Chebyshev coefficients equal to ORDERSP is given for NSSP time intervals of SPANSP days to describe the position-vector components in units of m; the similar parameters ending with PP (Peculiar Position) are not used in the current release and are reserved for future usage. A number of Chebyshev coefficients equal to ORDERSV is given for NSSV time intervals of SPANSV days to describe the velocity-vector components in units of m s^-1; the similar parameters ending with PV (Peculiar Velocity) are not used in the current release and are reserved for future usage. The first three HDUs contain the coefficients for the three components of the position, while the last three HDUs contain the coefficients for the three components of the velocity", 
     source = "A. Fienga, J. Laskar, H. Manche, M. Gastineau, 19 April 2007, 'Solar system planetary ephemeris delivery: INPOP06', GAIA-CA-TN-IMC-AF-001, issue 1, revision 0", 
     status = "DEPR", 
     basic = true, 
     scalar = false, 
     unit = "") 
    public static final String SUN_EPHEMERIS; static { SUN_EPHEMERIS = "Nature/Sun_Ephemeris_004.fits"; } 

    /**
     * Heliocentric gravitational constant (TCB-compatible value). Note that IAU 2012 Resolution B2 adopted at the XXVIII-th General Assembly of the IAU recommends that this parameter be determined observationally in SI units    
     * <p>
     * Status: CONF<br/>
     * Unit: m^3 s^-2<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Heliocentric gravitational constant (TCB-compatible value). Note that IAU 2012 Resolution B2 adopted at the XXVIII-th General Assembly of the IAU recommends that this parameter be determined observationally in SI units", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m^3 s^-2") 
    public static final double SUN_GM; static { SUN_GM = 1.3271244210789468e+20; } // [m^3 s^-2] 

    /**
     * Post-Newtonian deflection angle, for an observer at 1 au from the Sun, of a light ray arriving at right angles to the solar direction due to the spherically symmetric part of the gravitational field of the Sun    
     * <p>
     * Source: ESA, 1997, 'The Hipparcos and Tycho Catalogues', ESA SP-1200, Volume 3, page 331; cf. S.A. Klioner, 2003, 'A Practical Relativistic Model for Microarcsecond Astrometry in Space', AJ, 125, 1580, Equation 64<br/>
     * Status: CONF<br/>
     * Unit: 10^-6 arcsec<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Post-Newtonian deflection angle, for an observer at 1 au from the Sun, of a light ray arriving at right angles to the solar direction due to the spherically symmetric part of the gravitational field of the Sun", 
     source = "ESA, 1997, 'The Hipparcos and Tycho Catalogues', ESA SP-1200, Volume 3, page 331; cf. S.A. Klioner, 2003, 'A Practical Relativistic Model for Microarcsecond Astrometry in Space', AJ, 125, 1580, Equation 64", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "10^-6 arcsec") 
    public static final double SUN_LIGHTDEFLECTION_RIGHTANGLES; static { SUN_LIGHTDEFLECTION_RIGHTANGLES = 4072.; } // [10^-6 arcsec] 

    /**
     * Post-Newtonian deflection angle, for an observer at 1 au from the Sun, of a Solar-limb-grazing light ray due to the spherically symmetric part of the gravitational field of the Sun    
     * <p>
     * Source: S.A. Klioner, 2003, 'A Practical Relativistic Model for Microarcsecond Astrometry in Space', AJ, 125, 1580, Equation 64<br/>
     * Status: CONF<br/>
     * Unit: 10^-6 arcsec<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Post-Newtonian deflection angle, for an observer at 1 au from the Sun, of a Solar-limb-grazing light ray due to the spherically symmetric part of the gravitational field of the Sun", 
     source = "S.A. Klioner, 2003, 'A Practical Relativistic Model for Microarcsecond Astrometry in Space', AJ, 125, 1580, Equation 64", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "10^-6 arcsec") 
    public static final double SUN_LIGHTDEFLECTION_LIMB; static { SUN_LIGHTDEFLECTION_LIMB = 1751293.; } // [10^-6 arcsec] 

    /**
     * Solar mass    
     * <p>
     * Status: CONF<br/>
     * Unit: kg<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Solar mass", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "kg") 
    public static final double SUN_MASS; static { SUN_MASS = 1.98848e+30; } // [kg] 

    /**
     * IAU-recommended value for the right ascension \alpha_0 of the north pole of rotation of the Sun. The pair (\alpha_0, \delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \alpha_0 = 273.85 deg and \delta_0 = 66.99 degrees. The numerical value shall be used for comparative purposes only    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)<br/>
     * Status: CONF<br/>
     * Unit: deg<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "IAU-recommended value for the right ascension \\alpha_0 of the north pole of rotation of the Sun. The pair (\\alpha_0, \\delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \\alpha_0 = 273.85 deg and \\delta_0 = 66.99 degrees. The numerical value shall be used for comparative purposes only", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "deg") 
    public static final double SUN_NORTHROTATIONALPOLE_RIGHTASCENSION; static { SUN_NORTHROTATIONALPOLE_RIGHTASCENSION = 286.13; } // [deg] 

    /**
     * IAU-recommended value for the rate of change (in degrees per Julian day, calculated from the standard epoch) of the right ascension \alpha_0 of the north pole of rotation of the Sun. The pair (\alpha_0, \delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \alpha_0 = 273.85 deg and \delta_0 = 66.99 degrees. The numerical value shall be used for comparative purposes only    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)<br/>
     * Status: CONF<br/>
     * Unit: deg day^-1<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "IAU-recommended value for the rate of change (in degrees per Julian day, calculated from the standard epoch) of the right ascension \\alpha_0 of the north pole of rotation of the Sun. The pair (\\alpha_0, \\delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \\alpha_0 = 273.85 deg and \\delta_0 = 66.99 degrees. The numerical value shall be used for comparative purposes only", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "deg day^-1") 
    public static final double SUN_NORTHROTATIONALPOLE_RIGHTASCENSIONRATEOFCHANGE; static { SUN_NORTHROTATIONALPOLE_RIGHTASCENSIONRATEOFCHANGE = 0.; } // [deg day^-1] 

    /**
     * IAU-recommended value for the declination \delta_0 of the north pole of rotation of the Sun. The pair (\alpha_0, \delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \alpha_0 = 273.85 deg and \delta_0 = 66.99 degrees. The numerical value shall be used for comparative purposes only    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)<br/>
     * Status: CONF<br/>
     * Unit: deg<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "IAU-recommended value for the declination \\delta_0 of the north pole of rotation of the Sun. The pair (\\alpha_0, \\delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \\alpha_0 = 273.85 deg and \\delta_0 = 66.99 degrees. The numerical value shall be used for comparative purposes only", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "deg") 
    public static final double SUN_NORTHROTATIONALPOLE_DECLINATION; static { SUN_NORTHROTATIONALPOLE_DECLINATION = 63.87; } // [deg] 

    /**
     * IAU-recommended value for the rate of change (in degrees per Julian day, calculated from the standard epoch) of the declination \delta_0 of the north pole of rotation of the Sun. The pair (\alpha_0, \delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \alpha_0 = 273.85 deg and \delta_0 = 66.99 degrees. The numerical value shall be used for comparative purposes only    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)<br/>
     * Status: CONF<br/>
     * Unit: deg day^-1<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "IAU-recommended value for the rate of change (in degrees per Julian day, calculated from the standard epoch) of the declination \\delta_0 of the north pole of rotation of the Sun. The pair (\\alpha_0, \\delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \\alpha_0 = 273.85 deg and \\delta_0 = 66.99 degrees. The numerical value shall be used for comparative purposes only", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "deg day^-1") 
    public static final double SUN_NORTHROTATIONALPOLE_DECLINATIONRATEOFCHANGE; static { SUN_NORTHROTATIONALPOLE_DECLINATIONRATEOFCHANGE = 0.; } // [deg day^-1] 

    /**
     * IAU-recommended value for the ephemeris position of the prime meridian of the Sun. The location of the prime meridian is specified by the angle that is measured along the Sun's equator in an easterly direction with respect to the Sun's north pole from the node Q (located at right ascension 90 deg + \alpha_0, where \alpha_0 denotes the right ascension of the north pole of rotation) of the Sun's equator on the standard equator to the point B where the prime meridian crosses the Sun's equator. The right ascension of the point Q is 90 deg + \alpha_0 and the inclination of the Sun's equator to the standard equator is 90 deg - \delta_0, where \delta_0 denotes the declination of the north pole of rotation. (The pair (\alpha_0, \delta_0) denotes the standard equatorial coordinates, with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB), of the north pole of rotation, which itself is defined as that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \alpha_0 = 273.85 deg and \delta_0 = 66.99 degrees.) Because the prime meridian is assumed to rotate uniformly with the Sun, W accordingly varies linearly with time. In addition, \alpha_0, \delta_0, and W may vary with time due to a precession of the axis of rotation of the Sun. If W increases with time, the body has a direct (or prograde) rotation; if W decreases with time, the rotation is said to be retrograde. The numerical value shall be used for comparative purposes only    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)<br/>
     * Status: CONF<br/>
     * Unit: deg<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "IAU-recommended value for the ephemeris position of the prime meridian of the Sun. The location of the prime meridian is specified by the angle that is measured along the Sun's equator in an easterly direction with respect to the Sun's north pole from the node Q (located at right ascension 90 deg + \\alpha_0, where \\alpha_0 denotes the right ascension of the north pole of rotation) of the Sun's equator on the standard equator to the point B where the prime meridian crosses the Sun's equator. The right ascension of the point Q is 90 deg + \\alpha_0 and the inclination of the Sun's equator to the standard equator is 90 deg - \\delta_0, where \\delta_0 denotes the declination of the north pole of rotation. (The pair (\\alpha_0, \\delta_0) denotes the standard equatorial coordinates, with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB), of the north pole of rotation, which itself is defined as that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \\alpha_0 = 273.85 deg and \\delta_0 = 66.99 degrees.) Because the prime meridian is assumed to rotate uniformly with the Sun, W accordingly varies linearly with time. In addition, \\alpha_0, \\delta_0, and W may vary with time due to a precession of the axis of rotation of the Sun. If W increases with time, the body has a direct (or prograde) rotation; if W decreases with time, the rotation is said to be retrograde. The numerical value shall be used for comparative purposes only", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "deg") 
    public static final double SUN_PRIMEMERIDIAN_EPHEMERISPOSITION; static { SUN_PRIMEMERIDIAN_EPHEMERISPOSITION = 84.176; } // [deg] 

    /**
     * IAU-recommended value for the rate of change (in degrees per Julian day, calculated from the standard epoch of 1.5 January 2000 = JD2451545.0 TDB) of the ephemeris position of the prime meridian of the Sun. The location of the prime meridian is specified by the angle that is measured along the Sun's equator in an easterly direction with respect to the Sun's north pole from the node Q (located at right ascension 90 deg + \alpha_0, where \alpha_0 denotes the right ascension of the north pole of rotation) of the Sun's equator on the standard equator to the point B where the prime meridian crosses the Sun's equator. The right ascension of the point Q is 90 deg + \alpha_0 and the inclination of the Sun's equator to the standard equator is 90 deg - \delta_0, where \delta_0 denotes the declination of the north pole of rotation. (The pair (\alpha_0, \delta_0) denotes the standard equatorial coordinates, with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB), of the north pole of rotation, which itself is defined as that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \alpha_0 = 273.85 deg and \delta_0 = 66.99 degrees.) Because the prime meridian is assumed to rotate uniformly with the Sun, W accordingly varies linearly with time. In addition, \alpha_0, \delta_0, and W may vary with time due to a precession of the axis of rotation of the Sun. If W increases with time, the body has a direct (or prograde) rotation; if W decreases with time, the rotation is said to be retrograde. The numerical value shall be used for comparative purposes only    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)<br/>
     * Status: CONF<br/>
     * Unit: deg day^-1<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "IAU-recommended value for the rate of change (in degrees per Julian day, calculated from the standard epoch of 1.5 January 2000 = JD2451545.0 TDB) of the ephemeris position of the prime meridian of the Sun. The location of the prime meridian is specified by the angle that is measured along the Sun's equator in an easterly direction with respect to the Sun's north pole from the node Q (located at right ascension 90 deg + \\alpha_0, where \\alpha_0 denotes the right ascension of the north pole of rotation) of the Sun's equator on the standard equator to the point B where the prime meridian crosses the Sun's equator. The right ascension of the point Q is 90 deg + \\alpha_0 and the inclination of the Sun's equator to the standard equator is 90 deg - \\delta_0, where \\delta_0 denotes the declination of the north pole of rotation. (The pair (\\alpha_0, \\delta_0) denotes the standard equatorial coordinates, with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB), of the north pole of rotation, which itself is defined as that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \\alpha_0 = 273.85 deg and \\delta_0 = 66.99 degrees.) Because the prime meridian is assumed to rotate uniformly with the Sun, W accordingly varies linearly with time. In addition, \\alpha_0, \\delta_0, and W may vary with time due to a precession of the axis of rotation of the Sun. If W increases with time, the body has a direct (or prograde) rotation; if W decreases with time, the rotation is said to be retrograde. The numerical value shall be used for comparative purposes only", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "deg day^-1") 
    public static final double SUN_PRIMEMERIDIAN_EPHEMERISPOSITIONRATEOFCHANGE; static { SUN_PRIMEMERIDIAN_EPHEMERISPOSITIONRATEOFCHANGE = 14.1844000; } // [deg day^-1] 

    /**
     * Solar diurnal parallax    
     * <p>
     * Status: CONF<br/>
     * Unit: arcsec<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Solar diurnal parallax", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "arcsec") 
    public static final double SUN_DIURNALPARALLAX; static { SUN_DIURNALPARALLAX = 8.794143; } // [arcsec] 

    /**
     * Velocity of the Sun with respect to the local standard of rest (LSR); U-component, i.e., radially inwards (towards the Galactic centre). The random error is +0.69 and -0.75 km s^-1; the systematic error is 1.0 km s^-1    
     * <p>
     * Source: R. Schoenrich, J.J. Binney, W. Dehnen, 1 April 2010, 'Local kinematics and the local standard of rest', MNRAS, 403, 1829-1833 (2010MNRAS.403.1829S)<br/>
     * Status: CONF<br/>
     * Unit: km s^-1<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Velocity of the Sun with respect to the local standard of rest (LSR); U-component, i.e., radially inwards (towards the Galactic centre). The random error is +0.69 and -0.75 km s^-1; the systematic error is 1.0 km s^-1", 
     source = "R. Schoenrich, J.J. Binney, W. Dehnen, 1 April 2010, 'Local kinematics and the local standard of rest', MNRAS, 403, 1829-1833 (2010MNRAS.403.1829S)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "km s^-1") 
    public static final double SUN_VELOCITYLSR_U; static { SUN_VELOCITYLSR_U = 11.10; } // [km s^-1] 

    /**
     * Velocity of the Sun with respect to the local standard of rest (LSR); V-component, i.e., in the direction of Galactic rotation. The random error is +0.47 and -0.47 km s^-1; the systematic error is 2.0 km s^-1    
     * <p>
     * Source: R. Schoenrich, J.J. Binney, W. Dehnen, 1 April 2010, 'Local kinematics and the local standard of rest', MNRAS, 403, 1829-1833 (2010MNRAS.403.1829S)<br/>
     * Status: CONF<br/>
     * Unit: km s^-1<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Velocity of the Sun with respect to the local standard of rest (LSR); V-component, i.e., in the direction of Galactic rotation. The random error is +0.47 and -0.47 km s^-1; the systematic error is 2.0 km s^-1", 
     source = "R. Schoenrich, J.J. Binney, W. Dehnen, 1 April 2010, 'Local kinematics and the local standard of rest', MNRAS, 403, 1829-1833 (2010MNRAS.403.1829S)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "km s^-1") 
    public static final double SUN_VELOCITYLSR_V; static { SUN_VELOCITYLSR_V = 12.24; } // [km s^-1] 

    /**
     * Velocity of the Sun with respect to the local standard of rest (LSR); W-component, i.e., vertically upwards (towards the north Galactic pole). The random error is +0.37 and -0.36 km s^-1; the systematic error is 0.5 km s^-1    
     * <p>
     * Source: R. Schoenrich, J.J. Binney, W. Dehnen, 1 April 2010, 'Local kinematics and the local standard of rest', MNRAS, 403, 1829-1833 (2010MNRAS.403.1829S)<br/>
     * Status: CONF<br/>
     * Unit: km s^-1<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Velocity of the Sun with respect to the local standard of rest (LSR); W-component, i.e., vertically upwards (towards the north Galactic pole). The random error is +0.37 and -0.36 km s^-1; the systematic error is 0.5 km s^-1", 
     source = "R. Schoenrich, J.J. Binney, W. Dehnen, 1 April 2010, 'Local kinematics and the local standard of rest', MNRAS, 403, 1829-1833 (2010MNRAS.403.1829S)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "km s^-1") 
    public static final double SUN_VELOCITYLSR_W; static { SUN_VELOCITYLSR_W = 7.25; } // [km s^-1] 

    /**
     * Solar apparent (equatorial) radius at unit distance     
     * <p>
     * Status: CONF<br/>
     * Unit: arcsec<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Solar apparent (equatorial) radius at unit distance ", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "arcsec") 
    public static final double SUN_EQUATORIALRADIUS_APPARENT; static { SUN_EQUATORIALRADIUS_APPARENT = 959.17; } // [arcsec] 

    /**
     * Solar (equatorial) radius (photosphere)    
     * <p>
     * Source: M. Haberreiter, W. Schmutz, A.G. Kosovichev, 2008, 'Solving the Discrepancy between the Seismic and Photospheric Solar Radius', Astrophysical Journal (ApJ), 675, L53<br/>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Solar (equatorial) radius (photosphere)", 
     source = "M. Haberreiter, W. Schmutz, A.G. Kosovichev, 2008, 'Solving the Discrepancy between the Seismic and Photospheric Solar Radius', Astrophysical Journal (ApJ), 675, L53", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "m") 
    public static final double SUN_EQUATORIALRADIUS; static { SUN_EQUATORIALRADIUS = 6.956580e+8; } // [m] 

    /**
     * Mean solar mass density    
     * <p>
     * Status: CONF<br/>
     * Unit: g cm^-3<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean solar mass density", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "g cm^-3") 
    public static final double SUN_MASSDENSITY_MEAN; static { SUN_MASSDENSITY_MEAN = 1.410; } // [g cm^-3] 

    /**
     * Radius of the smallest hypothetical sphere around the Sun which would encompass the body (this is a low-accuracy parameter used in the relativistic model)    
     * <p>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Radius of the smallest hypothetical sphere around the Sun which would encompass the body (this is a low-accuracy parameter used in the relativistic model)", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m") 
    public static final double SUN_ENCOMPASSINGSPHERERADIUS; static { SUN_ENCOMPASSINGSPHERERADIUS = 6.960e+8; } // [m] 

    /**
     * Solar (mean) value of the Rosseland mean opacity for Thomson free-electron-scattering    
     * <p>
     * Source: E.g., R. Kippenhahn, A. Weigert, 1991, 'Stellar structure and evolution' (corrected 2-nd printing), Springer Verlag, Berlin, Section 17, Equation 17.2, page 137<br/>
     * Status: CONF<br/>
     * Unit: m^2 kg^-1<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Solar (mean) value of the Rosseland mean opacity for Thomson free-electron-scattering", 
     source = "E.g., R. Kippenhahn, A. Weigert, 1991, 'Stellar structure and evolution' (corrected 2-nd printing), Springer Verlag, Berlin, Section 17, Equation 17.2, page 137", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m^2 kg^-1") 
    public static final double SUN_ROSSELANDMEANOPACITY_THOMSONSCATTERING; static { SUN_ROSSELANDMEANOPACITY_THOMSONSCATTERING = 0.0344; } // [m^2 kg^-1] 

    /**
     * Coarse estimate of the solar (mean) value of the mean free photon path (assuming complete ionisation)    
     * <p>
     * Source: E.g., R. Kippenhahn, A. Weigert, 1991, 'Stellar structure and evolution' (corrected 2-nd printing), Springer Verlag, Berlin, Section 5, Equation 5.1, page 27<br/>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Coarse estimate of the solar (mean) value of the mean free photon path (assuming complete ionisation)", 
     source = "E.g., R. Kippenhahn, A. Weigert, 1991, 'Stellar structure and evolution' (corrected 2-nd printing), Springer Verlag, Berlin, Section 5, Equation 5.1, page 27", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m") 
    public static final double SUN_FREEPHOTONPATH_MEAN; static { SUN_FREEPHOTONPATH_MEAN = 0.021; } // [m] 

    /**
     * Johnson B-V colour of the Sun    
     * <p>
     * Source: Derived from :Nature:Planck_Constant, :Nature:VelocityOfLight_Constant_Vacuum, :Nature:A0VStar_CalibrationWavelength, :Nature:A0VStar_Spectrum_Nu_002, :Nature:A0VStar_CalibrationFunction_002, :Nature:Sun_Spectrum_Nu_001, :Nature:A0VStar_VMinI, :Nature:A0VStar_VMinR, :Nature:A0VStar_BMinV, :Nature:A0VStar_RMinI, :Nature:FilterTransmissionCurve_JohnsonCousinsB_002, :Nature:FilterTransmissionCurve_JohnsonCousinsV_002, :Nature:FilterTransmissionCurve_JohnsonCousinsR_002, and :Nature:FilterTransmissionCurve_JohnsonCousinsI_002. See also I. Ramirez, et al., 2012, 'The UBV(RI)C Colors of the Sun', Astrophysical Journal (ApJ), 752, 5, J. Holmberg, C. Flynn, L. Portinari, 2006, 'The colours of the Sun', MNRAS, 367, 449, and B.J. Taylor, 1998, 'The colours of the Sun', proceedings of IAU Symposium 189 on 'Fundamental Stellar Properties: The Interaction between Observation and Theory', eds T.R. Bedding, A.J. Booth, J. Davis, Kluwer, Dordrecht, ISBN 0-7923-4651-3, page 83 (1998IAUS..189...83T)<br/>
     * Status: CONF<br/>
     * Unit: mag<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Johnson B-V colour of the Sun", 
     source = "Derived from :Nature:Planck_Constant, :Nature:VelocityOfLight_Constant_Vacuum, :Nature:A0VStar_CalibrationWavelength, :Nature:A0VStar_Spectrum_Nu_002, :Nature:A0VStar_CalibrationFunction_002, :Nature:Sun_Spectrum_Nu_001, :Nature:A0VStar_VMinI, :Nature:A0VStar_VMinR, :Nature:A0VStar_BMinV, :Nature:A0VStar_RMinI, :Nature:FilterTransmissionCurve_JohnsonCousinsB_002, :Nature:FilterTransmissionCurve_JohnsonCousinsV_002, :Nature:FilterTransmissionCurve_JohnsonCousinsR_002, and :Nature:FilterTransmissionCurve_JohnsonCousinsI_002. See also I. Ramirez, et al., 2012, 'The UBV(RI)C Colors of the Sun', Astrophysical Journal (ApJ), 752, 5, J. Holmberg, C. Flynn, L. Portinari, 2006, 'The colours of the Sun', MNRAS, 367, 449, and B.J. Taylor, 1998, 'The colours of the Sun', proceedings of IAU Symposium 189 on 'Fundamental Stellar Properties: The Interaction between Observation and Theory', eds T.R. Bedding, A.J. Booth, J. Davis, Kluwer, Dordrecht, ISBN 0-7923-4651-3, page 83 (1998IAUS..189...83T)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "mag") 
    public static final double SUN_BMINV; static { SUN_BMINV = 0.678; } // [mag] 

    /**
     * Cousins R-I colour of the Sun    
     * <p>
     * Source: Derived from :Nature:Planck_Constant, :Nature:VelocityOfLight_Constant_Vacuum, :Nature:A0VStar_CalibrationWavelength, :Nature:A0VStar_Spectrum_Nu_002, :Nature:A0VStar_CalibrationFunction_002, :Nature:Sun_Spectrum_Nu_001, :Nature:A0VStar_VMinI, :Nature:A0VStar_VMinR, :Nature:A0VStar_BMinV, :Nature:A0VStar_RMinI, :Nature:FilterTransmissionCurve_JohnsonCousinsB_002, :Nature:FilterTransmissionCurve_JohnsonCousinsV_002, :Nature:FilterTransmissionCurve_JohnsonCousinsR_002, and :Nature:FilterTransmissionCurve_JohnsonCousinsI_002. See also I. Ramirez, et al., 2012, 'The UBV(RI)C Colors of the Sun', Astrophysical Journal (ApJ), 752, 5, J. Holmberg, C. Flynn, L. Portinari, 2006, 'The colours of the Sun', MNRAS, 367, 449, and B.J. Taylor, 1998, 'The colours of the Sun', proceedings of IAU Symposium 189 on 'Fundamental Stellar Properties: The Interaction between Observation and Theory', eds T.R. Bedding, A.J. Booth, J. Davis, Kluwer, Dordrecht, ISBN 0-7923-4651-3, page 83 (1998IAUS..189...83T)<br/>
     * Status: CONF<br/>
     * Unit: mag<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Cousins R-I colour of the Sun", 
     source = "Derived from :Nature:Planck_Constant, :Nature:VelocityOfLight_Constant_Vacuum, :Nature:A0VStar_CalibrationWavelength, :Nature:A0VStar_Spectrum_Nu_002, :Nature:A0VStar_CalibrationFunction_002, :Nature:Sun_Spectrum_Nu_001, :Nature:A0VStar_VMinI, :Nature:A0VStar_VMinR, :Nature:A0VStar_BMinV, :Nature:A0VStar_RMinI, :Nature:FilterTransmissionCurve_JohnsonCousinsB_002, :Nature:FilterTransmissionCurve_JohnsonCousinsV_002, :Nature:FilterTransmissionCurve_JohnsonCousinsR_002, and :Nature:FilterTransmissionCurve_JohnsonCousinsI_002. See also I. Ramirez, et al., 2012, 'The UBV(RI)C Colors of the Sun', Astrophysical Journal (ApJ), 752, 5, J. Holmberg, C. Flynn, L. Portinari, 2006, 'The colours of the Sun', MNRAS, 367, 449, and B.J. Taylor, 1998, 'The colours of the Sun', proceedings of IAU Symposium 189 on 'Fundamental Stellar Properties: The Interaction between Observation and Theory', eds T.R. Bedding, A.J. Booth, J. Davis, Kluwer, Dordrecht, ISBN 0-7923-4651-3, page 83 (1998IAUS..189...83T)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "mag") 
    public static final double SUN_RMINI; static { SUN_RMINI = 0.344; } // [mag] 

    /**
     * Johnson V absolute magnitude of the Sun    
     * <p>
     * Status: CONF<br/>
     * Unit: mag<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Johnson V absolute magnitude of the Sun", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "mag") 
    public static final double SUN_ABSOLUTEVMAGNITUDE; static { SUN_ABSOLUTEVMAGNITUDE = 4.812; } // [mag] 

    /**
     * Johnson V magnitude of the Sun (observed)     
     * <p>
     * Source: M.S. Bessell, F. Castelli, B. Plez, 1998, 'Model atmospheres, broad-band colors, bolometric corrections, and temperature calibrations for O-M stars', A&A, 333, 231, Appendices C and D (erratum 1998, A&A, 337, 321)<br/>
     * Status: CONF<br/>
     * Unit: mag<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Johnson V magnitude of the Sun (observed) ", 
     source = "M.S. Bessell, F. Castelli, B. Plez, 1998, 'Model atmospheres, broad-band colors, bolometric corrections, and temperature calibrations for O-M stars', A&A, 333, 231, Appendices C and D (erratum 1998, A&A, 337, 321)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "mag") 
    public static final double SUN_VMAGNITUDE; static { SUN_VMAGNITUDE = -26.760; } // [mag] 

    /**
     * Absolute bolometric magnitude of the Sun    
     * <p>
     * Source: E. Mamajek, et al., 2015, 'IAU 2015 Resolution B2 on Recommended Zero Points for the Absolute and Apparent Bolometric Magnitude Scales', arXiv:1510.06262 (see also https://www.iau.org/administration/resolutions/general_assemblies/)<br/>
     * Status: CONF<br/>
     * Unit: mag<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Absolute bolometric magnitude of the Sun", 
     source = "E. Mamajek, et al., 2015, 'IAU 2015 Resolution B2 on Recommended Zero Points for the Absolute and Apparent Bolometric Magnitude Scales', arXiv:1510.06262 (see also https://www.iau.org/administration/resolutions/general_assemblies/)", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "mag") 
    public static final double SUN_BOLOMETRICMAGNITUDE; static { SUN_BOLOMETRICMAGNITUDE = 4.740; } // [mag] 

    /**
     * Johnson V bolometric correction of the Sun    
     * <p>
     * Status: CONF<br/>
     * Unit: mag<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Johnson V bolometric correction of the Sun", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "mag") 
    public static final double SUN_BOLOMETRICCORRECTIONVMAGNITUDE; static { SUN_BOLOMETRICCORRECTIONVMAGNITUDE = -0.072; } // [mag] 

    /**
     * Mixing length parameter \alpha of the Sun    
     * <p>
     * Source: L. Girardi, A. Bressan, G. Bertelli, C. Chiosi, 2000, 'Evolutionary tracks and isochrones for low- and intermediate-mass stars; from M = 0.15 to 7 M_Sun and from Z = 0.0004 to 0.03', A&AS, 141, 371<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mixing length parameter \\alpha of the Sun", 
     source = "L. Girardi, A. Bressan, G. Bertelli, C. Chiosi, 2000, 'Evolutionary tracks and isochrones for low- and intermediate-mass stars; from M = 0.15 to 7 M_Sun and from Z = 0.0004 to 0.03', A&AS, 141, 371", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double SUN_ALPHA; static { SUN_ALPHA = 1.68; } 

    /**
     * Hydrogen abundance of the Sun by mass    
     * <p>
     * Status: CONF<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Hydrogen abundance of the Sun by mass", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "") 
    public static final double SUN_X; static { SUN_X = 0.7166; } 

    /**
     * Helium abundance of the Sun by mass    
     * <p>
     * Source: N. Grevesse, A. Noels, 1993, in 'Association Vaudoise des chercheurs en physique: la formation des elements chimiques', eds B. Hauck, S. Plantani, D. Raboud and N. Grevesse, A. Noels, 1993, in 'Origin and evolution of the elements', eds N. Prantzos, E. Vangioni-Flam, M. Casse, Cambridge University Press, Cambridge, page 15<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Helium abundance of the Sun by mass", 
     source = "N. Grevesse, A. Noels, 1993, in 'Association Vaudoise des chercheurs en physique: la formation des elements chimiques', eds B. Hauck, S. Plantani, D. Raboud and N. Grevesse, A. Noels, 1993, in 'Origin and evolution of the elements', eds N. Prantzos, E. Vangioni-Flam, M. Casse, Cambridge University Press, Cambridge, page 15", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double SUN_Y; static { SUN_Y = 0.2659; } 

    /**
     * Johnson-Cousins V-I colour of the Sun    
     * <p>
     * Source: Derived from :Nature:Planck_Constant, :Nature:VelocityOfLight_Constant_Vacuum, :Nature:A0VStar_CalibrationWavelength, :Nature:A0VStar_Spectrum_Nu_002, :Nature:A0VStar_CalibrationFunction_002, :Nature:Sun_Spectrum_Nu_001, :Nature:A0VStar_VMinI, :Nature:A0VStar_VMinR, :Nature:A0VStar_BMinV, :Nature:A0VStar_RMinI, :Nature:FilterTransmissionCurve_JohnsonCousinsB_002, :Nature:FilterTransmissionCurve_JohnsonCousinsV_002, :Nature:FilterTransmissionCurve_JohnsonCousinsR_002, and :Nature:FilterTransmissionCurve_JohnsonCousinsI_002. See also I. Ramirez, et al., 2012, 'The UBV(RI)C Colors of the Sun', Astrophysical Journal (ApJ), 752, 5, J. Holmberg, C. Flynn, L. Portinari, 2006, 'The colours of the Sun', MNRAS, 367, 449, and B.J. Taylor, 1998, 'The colours of the Sun', proceedings of IAU Symposium 189 on 'Fundamental Stellar Properties: The Interaction between Observation and Theory', eds T.R. Bedding, A.J. Booth, J. Davis, Kluwer, Dordrecht, ISBN 0-7923-4651-3, page 83 (1998IAUS..189...83T)<br/>
     * Status: CONF<br/>
     * Unit: mag<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Johnson-Cousins V-I colour of the Sun", 
     source = "Derived from :Nature:Planck_Constant, :Nature:VelocityOfLight_Constant_Vacuum, :Nature:A0VStar_CalibrationWavelength, :Nature:A0VStar_Spectrum_Nu_002, :Nature:A0VStar_CalibrationFunction_002, :Nature:Sun_Spectrum_Nu_001, :Nature:A0VStar_VMinI, :Nature:A0VStar_VMinR, :Nature:A0VStar_BMinV, :Nature:A0VStar_RMinI, :Nature:FilterTransmissionCurve_JohnsonCousinsB_002, :Nature:FilterTransmissionCurve_JohnsonCousinsV_002, :Nature:FilterTransmissionCurve_JohnsonCousinsR_002, and :Nature:FilterTransmissionCurve_JohnsonCousinsI_002. See also I. Ramirez, et al., 2012, 'The UBV(RI)C Colors of the Sun', Astrophysical Journal (ApJ), 752, 5, J. Holmberg, C. Flynn, L. Portinari, 2006, 'The colours of the Sun', MNRAS, 367, 449, and B.J. Taylor, 1998, 'The colours of the Sun', proceedings of IAU Symposium 189 on 'Fundamental Stellar Properties: The Interaction between Observation and Theory', eds T.R. Bedding, A.J. Booth, J. Davis, Kluwer, Dordrecht, ISBN 0-7923-4651-3, page 83 (1998IAUS..189...83T)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "mag") 
    public static final double SUN_VMINI; static { SUN_VMINI = 0.711; } // [mag] 

    /**
     * Johnson-Cousins V-R colour of the Sun    
     * <p>
     * Source: Derived from :Nature:Planck_Constant, :Nature:VelocityOfLight_Constant_Vacuum, :Nature:A0VStar_CalibrationWavelength, :Nature:A0VStar_Spectrum_Nu_002, :Nature:A0VStar_CalibrationFunction_002, :Nature:Sun_Spectrum_Nu_001, :Nature:A0VStar_VMinI, :Nature:A0VStar_VMinR, :Nature:A0VStar_BMinV, :Nature:A0VStar_RMinI, :Nature:FilterTransmissionCurve_JohnsonCousinsB_002, :Nature:FilterTransmissionCurve_JohnsonCousinsV_002, :Nature:FilterTransmissionCurve_JohnsonCousinsR_002, and :Nature:FilterTransmissionCurve_JohnsonCousinsI_002. See also I. Ramirez, et al., 2012, 'The UBV(RI)C Colors of the Sun', Astrophysical Journal (ApJ), 752, 5, J. Holmberg, C. Flynn, L. Portinari, 2006, 'The colours of the Sun', MNRAS, 367, 449, and B.J. Taylor, 1998, 'The colours of the Sun', proceedings of IAU Symposium 189 on 'Fundamental Stellar Properties: The Interaction between Observation and Theory', eds T.R. Bedding, A.J. Booth, J. Davis, Kluwer, Dordrecht, ISBN 0-7923-4651-3, page 83 (1998IAUS..189...83T)<br/>
     * Status: CONF<br/>
     * Unit: mag<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Johnson-Cousins V-R colour of the Sun", 
     source = "Derived from :Nature:Planck_Constant, :Nature:VelocityOfLight_Constant_Vacuum, :Nature:A0VStar_CalibrationWavelength, :Nature:A0VStar_Spectrum_Nu_002, :Nature:A0VStar_CalibrationFunction_002, :Nature:Sun_Spectrum_Nu_001, :Nature:A0VStar_VMinI, :Nature:A0VStar_VMinR, :Nature:A0VStar_BMinV, :Nature:A0VStar_RMinI, :Nature:FilterTransmissionCurve_JohnsonCousinsB_002, :Nature:FilterTransmissionCurve_JohnsonCousinsV_002, :Nature:FilterTransmissionCurve_JohnsonCousinsR_002, and :Nature:FilterTransmissionCurve_JohnsonCousinsI_002. See also I. Ramirez, et al., 2012, 'The UBV(RI)C Colors of the Sun', Astrophysical Journal (ApJ), 752, 5, J. Holmberg, C. Flynn, L. Portinari, 2006, 'The colours of the Sun', MNRAS, 367, 449, and B.J. Taylor, 1998, 'The colours of the Sun', proceedings of IAU Symposium 189 on 'Fundamental Stellar Properties: The Interaction between Observation and Theory', eds T.R. Bedding, A.J. Booth, J. Davis, Kluwer, Dordrecht, ISBN 0-7923-4651-3, page 83 (1998IAUS..189...83T)", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "mag") 
    public static final double SUN_VMINR; static { SUN_VMINR = 0.367; } // [mag] 

    /**
     * Metal abundance of the Sun by mass    
     * <p>
     * Source: N. Grevesse, A. Noels, 1993, in 'Association Vaudoise des chercheurs en physique: la formation des elements chimiques', eds B. Hauck, S. Plantani, D. Raboud and N. Grevesse, A. Noels, 1993, in 'Origin and evolution of the elements', eds N. Prantzos, E. Vangioni-Flam, M. Casse, Cambridge University Press, Cambridge, page 15<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Metal abundance of the Sun by mass", 
     source = "N. Grevesse, A. Noels, 1993, in 'Association Vaudoise des chercheurs en physique: la formation des elements chimiques', eds B. Hauck, S. Plantani, D. Raboud and N. Grevesse, A. Noels, 1993, in 'Origin and evolution of the elements', eds N. Prantzos, E. Vangioni-Flam, M. Casse, Cambridge University Press, Cambridge, page 15", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double SUN_Z; static { SUN_Z = 0.0175; } 

    /**
     * Solar value of the mean molecular weight (assuming complete ionisation)    
     * <p>
     * Source: E.g., H. Karttunen, et al., 1987, 'Fundamental Astronomy', Springer Verlag, Berlin, Section 11.2, Equation 11.8, page 245<br/>
     * Status: CONF<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Solar value of the mean molecular weight (assuming complete ionisation)", 
     source = "E.g., H. Karttunen, et al., 1987, 'Fundamental Astronomy', Springer Verlag, Berlin, Section 11.2, Equation 11.8, page 245", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "") 
    public static final double SUN_MEANMOLECULARWEIGHT; static { SUN_MEANMOLECULARWEIGHT = 0.6092; } 

    /**
     * Solar value of the mean molecular weight per free electron (assuming complete ionisation)    
     * <p>
     * Source: E.g., H. Karttunen, et al., 1987, 'Fundamental Astronomy', Springer Verlag, Berlin, Section 11.2, page 246<br/>
     * Status: CONF<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Solar value of the mean molecular weight per free electron (assuming complete ionisation)", 
     source = "E.g., H. Karttunen, et al., 1987, 'Fundamental Astronomy', Springer Verlag, Berlin, Section 11.2, page 246", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "") 
    public static final double SUN_MEANMOLECULARWEIGHT_PERFREEELECTRON; static { SUN_MEANMOLECULARWEIGHT_PERFREEELECTRON = 1.1651; } 

    /**
     * Surface gravity of the Sun    
     * <p>
     * Status: CONF<br/>
     * Unit: m s^-2<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Surface gravity of the Sun", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m s^-2") 
    public static final double SUN_SURFACEGRAVITY; static { SUN_SURFACEGRAVITY = 274.2; } // [m s^-2] 

    /**
     * Energy flux of the Sun at a distance of 1 au (also refered to as solar constant or total solar irradiance). This is the cycle-23-averaged, measured value. Due to orbital modulation, this value changes by \pm 3.4% during a year; this value changes by \pm 0.1% during a solar cycle; during solar maximum, sunspots can induce variations over one solar rotation at the level of a few tenths of a percent    
     * <p>
     * Source: E. Mamajek, et al., 2015, 'IAU 2015 Resolution B3 on Recommended Nominal Conversion Constants for Selected Solar and Planetary Properties', arXiv:1510.07674 (see also https://www.iau.org/administration/resolutions/general_assemblies/)<br/>
     * Status: CONF<br/>
     * Unit: W m^-2<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Energy flux of the Sun at a distance of 1 au (also refered to as solar constant or total solar irradiance). This is the cycle-23-averaged, measured value. Due to orbital modulation, this value changes by \\pm 3.4% during a year; this value changes by \\pm 0.1% during a solar cycle; during solar maximum, sunspots can induce variations over one solar rotation at the level of a few tenths of a percent", 
     source = "E. Mamajek, et al., 2015, 'IAU 2015 Resolution B3 on Recommended Nominal Conversion Constants for Selected Solar and Planetary Properties', arXiv:1510.07674 (see also https://www.iau.org/administration/resolutions/general_assemblies/)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "W m^-2") 
    public static final double SUN_ENERGYFLUX_ASTRONOMICALUNIT; static { SUN_ENERGYFLUX_ASTRONOMICALUNIT = 1361.; } // [W m^-2] 

    /**
     * Luminosity of the Sun. This value changes by \pm 0.1% during a solar cycle; during solar maximum, sunspots can induce variations over one solar rotation at the level of a few tenths of a percent    
     * <p>
     * Status: CONF<br/>
     * Unit: W<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Luminosity of the Sun. This value changes by \\pm 0.1% during a solar cycle; during solar maximum, sunspots can induce variations over one solar rotation at the level of a few tenths of a percent", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "W") 
    public static final double SUN_LUMINOSITY; static { SUN_LUMINOSITY = 3.8275e+26; } // [W] 

    /**
     * Effective (black-body) temperature of the Sun    
     * <p>
     * Status: CONF<br/>
     * Unit: K<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Effective (black-body) temperature of the Sun", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "K") 
    public static final double SUN_EFFECTIVETEMPERATURE; static { SUN_EFFECTIVETEMPERATURE = 5772.; } // [K] 

    /**
     * Energy flux of the Sun at L2. Due to orbital modulation, this value changes by \pm 3.4% during a year; this value changes by \pm 0.1% during a solar cycle; during solar maximum, sunspots can induce variations over one solar rotation at the level of a few tenths of a percent    
     * <p>
     * Status: CONF<br/>
     * Unit: W m^-2<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Energy flux of the Sun at L2. Due to orbital modulation, this value changes by \\pm 3.4% during a year; this value changes by \\pm 0.1% during a solar cycle; during solar maximum, sunspots can induce variations over one solar rotation at the level of a few tenths of a percent", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "W m^-2") 
    public static final double SUN_ENERGYFLUX_L2; static { SUN_ENERGYFLUX_L2 = 1334.; } // [W m^-2] 

    /**
     * Mean value of the solar-radiation pressure at a distance of 1 au. Due to orbital modulation, this value changes by \pm 3.4% during a year; this value changes by \pm 0.1% during a solar cycle; during solar maximum, sunspots can induce variations over one solar rotation at the level of a few tenths of a percent    
     * <p>
     * Status: CONF<br/>
     * Unit: Pa<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean value of the solar-radiation pressure at a distance of 1 au. Due to orbital modulation, this value changes by \\pm 3.4% during a year; this value changes by \\pm 0.1% during a solar cycle; during solar maximum, sunspots can induce variations over one solar rotation at the level of a few tenths of a percent", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "Pa") 
    public static final double SUN_RADIATIONPRESSURE_ASTRONOMICALUNIT; static { SUN_RADIATIONPRESSURE_ASTRONOMICALUNIT = 4.540e-6; } // [Pa] 

    /**
     * Mean value of the solar-radiation pressure at L2. Due to orbital modulation, this value changes by \pm 3.4% during a year; this value changes by \pm 0.1% during a solar cycle; during solar maximum, sunspots can induce variations over one solar rotation at the level of a few tenths of a percent    
     * <p>
     * Status: CONF<br/>
     * Unit: Pa<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean value of the solar-radiation pressure at L2. Due to orbital modulation, this value changes by \\pm 3.4% during a year; this value changes by \\pm 0.1% during a solar cycle; during solar maximum, sunspots can induce variations over one solar rotation at the level of a few tenths of a percent", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "Pa") 
    public static final double SUN_RADIATIONPRESSURE_L2; static { SUN_RADIATIONPRESSURE_L2 = 4.450e-6; } // [Pa] 

    /**
     * Velocity of the Sun with respect to the local standard of rest (LSR)    
     * <p>
     * Status: CONF<br/>
     * Unit: km s^-1<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Velocity of the Sun with respect to the local standard of rest (LSR)", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "km s^-1") 
    public static final double SUN_VELOCITYLSR; static { SUN_VELOCITYLSR = 18.04; } // [km s^-1] 

    /**
     * Nominal solar (equatorial) radius (photosphere), in SI units. This nominal value shall be understood as conversion factor only    
     * <p>
     * Source: E. Mamajek, et al., 2015, 'IAU 2015 Resolution B3 on Recommended Nominal Conversion Constants for Selected Solar and Planetary Properties', arXiv:1510.07674 (see also https://www.iau.org/administration/resolutions/general_assemblies/)<br/>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Nominal solar (equatorial) radius (photosphere), in SI units. This nominal value shall be understood as conversion factor only", 
     source = "E. Mamajek, et al., 2015, 'IAU 2015 Resolution B3 on Recommended Nominal Conversion Constants for Selected Solar and Planetary Properties', arXiv:1510.07674 (see also https://www.iau.org/administration/resolutions/general_assemblies/)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "m") 
    public static final double SUN_EQUATORIALRADIUS_NOMINAL; static { SUN_EQUATORIALRADIUS_NOMINAL = 6.9570e+8; } // [m] 

    /**
     * Nominal energy flux of the Sun at a distance of 1 au (also refered to as solar constant or total solar irradiance), in SI units. This nominal value shall be understood as conversion factor only    
     * <p>
     * Source: E. Mamajek, et al., 2015, 'IAU 2015 Resolution B3 on Recommended Nominal Conversion Constants for Selected Solar and Planetary Properties', arXiv:1510.07674 (see also https://www.iau.org/administration/resolutions/general_assemblies/)<br/>
     * Status: CONF<br/>
     * Unit: W m^-2<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Nominal energy flux of the Sun at a distance of 1 au (also refered to as solar constant or total solar irradiance), in SI units. This nominal value shall be understood as conversion factor only", 
     source = "E. Mamajek, et al., 2015, 'IAU 2015 Resolution B3 on Recommended Nominal Conversion Constants for Selected Solar and Planetary Properties', arXiv:1510.07674 (see also https://www.iau.org/administration/resolutions/general_assemblies/)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "W m^-2") 
    public static final double SUN_ENERGYFLUX_NOMINAL; static { SUN_ENERGYFLUX_NOMINAL = 1361.; } // [W m^-2] 

    /**
     * Nominal luminosity of the Sun, in SI units. This nominal value shall be understood as conversion factor only    
     * <p>
     * Source: E. Mamajek, et al., 2015, 'IAU 2015 Resolution B3 on Recommended Nominal Conversion Constants for Selected Solar and Planetary Properties', arXiv:1510.07674 (see also https://www.iau.org/administration/resolutions/general_assemblies/)<br/>
     * Status: CONF<br/>
     * Unit: W<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Nominal luminosity of the Sun, in SI units. This nominal value shall be understood as conversion factor only", 
     source = "E. Mamajek, et al., 2015, 'IAU 2015 Resolution B3 on Recommended Nominal Conversion Constants for Selected Solar and Planetary Properties', arXiv:1510.07674 (see also https://www.iau.org/administration/resolutions/general_assemblies/)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "W") 
    public static final double SUN_LUMINOSITY_NOMINAL; static { SUN_LUMINOSITY_NOMINAL = 3.8280e+26; } // [W] 

    /**
     * Nominal effective (black-body) temperature of the Sun, in SI units. This nominal value shall be understood as conversion factor only    
     * <p>
     * Source: E. Mamajek, et al., 2015, 'IAU 2015 Resolution B3 on Recommended Nominal Conversion Constants for Selected Solar and Planetary Properties', arXiv:1510.07674 (see also https://www.iau.org/administration/resolutions/general_assemblies/)<br/>
     * Status: CONF<br/>
     * Unit: K<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Nominal effective (black-body) temperature of the Sun, in SI units. This nominal value shall be understood as conversion factor only", 
     source = "E. Mamajek, et al., 2015, 'IAU 2015 Resolution B3 on Recommended Nominal Conversion Constants for Selected Solar and Planetary Properties', arXiv:1510.07674 (see also https://www.iau.org/administration/resolutions/general_assemblies/)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "K") 
    public static final double SUN_EFFECTIVETEMPERATURE_NOMINAL; static { SUN_EFFECTIVETEMPERATURE_NOMINAL = 5772.; } // [K] 

    /**
     * Nominal heliocentric gravitational constant, in SI units. This nominal value shall be understood as conversion factor only    
     * <p>
     * Source: E. Mamajek, et al., 2015, 'IAU 2015 Resolution B3 on Recommended Nominal Conversion Constants for Selected Solar and Planetary Properties', arXiv:1510.07674 (see also https://www.iau.org/administration/resolutions/general_assemblies/)<br/>
     * Status: CONF<br/>
     * Unit: m^3 s^-2<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Nominal heliocentric gravitational constant, in SI units. This nominal value shall be understood as conversion factor only", 
     source = "E. Mamajek, et al., 2015, 'IAU 2015 Resolution B3 on Recommended Nominal Conversion Constants for Selected Solar and Planetary Properties', arXiv:1510.07674 (see also https://www.iau.org/administration/resolutions/general_assemblies/)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "m^3 s^-2") 
    public static final double SUN_GM_NOMINAL; static { SUN_GM_NOMINAL = 1.32712440e+20; } // [m^3 s^-2] 

    /**
     * Orbital semi-major axis of the Sun's orbit around the (hypothetical) common barycentre of the Mercury-Sun system    
     * <p>
     * Source: E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 1.1, Equation 1.6, page 6<br/>
     * Status: CONF<br/>
     * Unit: km<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Orbital semi-major axis of the Sun's orbit around the (hypothetical) common barycentre of the Mercury-Sun system", 
     source = "E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 1.1, Equation 1.6, page 6", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "km") 
    public static final double SUN_ORBITALSEMIMAJORAXIS_MERCURYSYSTEM; static { SUN_ORBITALSEMIMAJORAXIS_MERCURYSYSTEM = 10.; } // [km] 

    /**
     * Orbital semi-major axis of the Sun's orbit around the (hypothetical) common barycentre of the Venus-Sun system    
     * <p>
     * Source: E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 1.1, Equation 1.6, page 6<br/>
     * Status: CONF<br/>
     * Unit: km<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Orbital semi-major axis of the Sun's orbit around the (hypothetical) common barycentre of the Venus-Sun system", 
     source = "E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 1.1, Equation 1.6, page 6", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "km") 
    public static final double SUN_ORBITALSEMIMAJORAXIS_VENUSSYSTEM; static { SUN_ORBITALSEMIMAJORAXIS_VENUSSYSTEM = 265.; } // [km] 

    /**
     * Orbital semi-major axis of the Sun's orbit around the (hypothetical) common barycentre of the Earth-system-Sun system    
     * <p>
     * Source: E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 1.1, Equation 1.6, page 6<br/>
     * Status: CONF<br/>
     * Unit: km<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Orbital semi-major axis of the Sun's orbit around the (hypothetical) common barycentre of the Earth-system-Sun system", 
     source = "E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 1.1, Equation 1.6, page 6", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "km") 
    public static final double SUN_ORBITALSEMIMAJORAXIS_EARTHSYSTEM; static { SUN_ORBITALSEMIMAJORAXIS_EARTHSYSTEM = 455.; } // [km] 

    /**
     * Orbital semi-major axis of the Sun's orbit around the (hypothetical) common barycentre of the Mars-system-Sun system    
     * <p>
     * Source: E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 1.1, Equation 1.6, page 6<br/>
     * Status: CONF<br/>
     * Unit: km<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Orbital semi-major axis of the Sun's orbit around the (hypothetical) common barycentre of the Mars-system-Sun system", 
     source = "E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 1.1, Equation 1.6, page 6", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "km") 
    public static final double SUN_ORBITALSEMIMAJORAXIS_MARSSYSTEM; static { SUN_ORBITALSEMIMAJORAXIS_MARSSYSTEM = 74.; } // [km] 

    /**
     * Orbital semi-major axis of the Sun's orbit around the (hypothetical) common barycentre of the Jupiter-system-Sun system    
     * <p>
     * Source: E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 1.1, Equation 1.6, page 6<br/>
     * Status: CONF<br/>
     * Unit: km<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Orbital semi-major axis of the Sun's orbit around the (hypothetical) common barycentre of the Jupiter-system-Sun system", 
     source = "E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 1.1, Equation 1.6, page 6", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "km") 
    public static final double SUN_ORBITALSEMIMAJORAXIS_JUPITERSYSTEM; static { SUN_ORBITALSEMIMAJORAXIS_JUPITERSYSTEM = 743154.; } // [km] 

    /**
     * Orbital semi-major axis of the Sun's orbit around the (hypothetical) common barycentre of the Saturn-system-Sun system    
     * <p>
     * Source: E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 1.1, Equation 1.6, page 6<br/>
     * Status: CONF<br/>
     * Unit: km<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Orbital semi-major axis of the Sun's orbit around the (hypothetical) common barycentre of the Saturn-system-Sun system", 
     source = "E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 1.1, Equation 1.6, page 6", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "km") 
    public static final double SUN_ORBITALSEMIMAJORAXIS_SATURNSYSTEM; static { SUN_ORBITALSEMIMAJORAXIS_SATURNSYSTEM = 407863.; } // [km] 

    /**
     * Orbital semi-major axis of the Sun's orbit around the (hypothetical) common barycentre of the Uranus-system-Sun system    
     * <p>
     * Source: E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 1.1, Equation 1.6, page 6<br/>
     * Status: CONF<br/>
     * Unit: km<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Orbital semi-major axis of the Sun's orbit around the (hypothetical) common barycentre of the Uranus-system-Sun system", 
     source = "E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 1.1, Equation 1.6, page 6", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "km") 
    public static final double SUN_ORBITALSEMIMAJORAXIS_URANUSSYSTEM; static { SUN_ORBITALSEMIMAJORAXIS_URANUSSYSTEM = 125340.; } // [km] 

    /**
     * Orbital semi-major axis of the Sun's orbit around the (hypothetical) common barycentre of the Neptune-system-Sun system    
     * <p>
     * Source: E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 1.1, Equation 1.6, page 6<br/>
     * Status: CONF<br/>
     * Unit: km<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Orbital semi-major axis of the Sun's orbit around the (hypothetical) common barycentre of the Neptune-system-Sun system", 
     source = "E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 1.1, Equation 1.6, page 6", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "km") 
    public static final double SUN_ORBITALSEMIMAJORAXIS_NEPTUNESYSTEM; static { SUN_ORBITALSEMIMAJORAXIS_NEPTUNESYSTEM = 231730.; } // [km] 

    /**
     * Orbital semi-major axis of the Sun's orbit around the (hypothetical) common barycentre of the Pluto-system-Sun system    
     * <p>
     * Source: E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 1.1, Equation 1.6, page 6<br/>
     * Status: CONF<br/>
     * Unit: km<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Orbital semi-major axis of the Sun's orbit around the (hypothetical) common barycentre of the Pluto-system-Sun system", 
     source = "E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 1.1, Equation 1.6, page 6", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "km") 
    public static final double SUN_ORBITALSEMIMAJORAXIS_PLUTOSYSTEM; static { SUN_ORBITALSEMIMAJORAXIS_PLUTOSYSTEM = 43.; } // [km] 

    /**
     * Ratio of Sun to Earth mass. The Earth mass includes the Earth's atmosphere but excludes the mass of the Moon    
     * <p>
     * Status: CONF<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Ratio of Sun to Earth mass. The Earth mass includes the Earth's atmosphere but excludes the mass of the Moon", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "") 
    public static final double SUNTOEARTH_MASSRATIO; static { SUNTOEARTH_MASSRATIO = 332946.048701; } 

    /**
     * Ratio of Sun to Earth-system mass. The planetary mass includes the contribution of its satellite, the Moon    
     * <p>
     * Status: CONF<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Ratio of Sun to Earth-system mass. The planetary mass includes the contribution of its satellite, the Moon", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "") 
    public static final double SUNTOEARTHSYSTEM_MASSRATIO; static { SUNTOEARTHSYSTEM_MASSRATIO = 328900.559616; } 

    /**
     * Ratio of Sun to Eris-system mass (IAU 2009 CBE value). The 'planetary' mass includes the contribution of its satellite, Dysnomia    
     * <p>
     * Source: The IAU (2009) System of Astronomical Constants (IAU, August 2009, 'IAU 2009 Astronomical Constants', IAU 2009 Resolution B2 adopted at the XXVII-th General Assembly of the IAU. See also IAU, 10 August 2009, 'IAU WG on NSFA Current Best Estimates', http://maia.usno.navy.mil/NSFA/NSFA_cbe.html)<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Ratio of Sun to Eris-system mass (IAU 2009 CBE value). The 'planetary' mass includes the contribution of its satellite, Dysnomia", 
     source = "The IAU (2009) System of Astronomical Constants (IAU, August 2009, 'IAU 2009 Astronomical Constants', IAU 2009 Resolution B2 adopted at the XXVII-th General Assembly of the IAU. See also IAU, 10 August 2009, 'IAU WG on NSFA Current Best Estimates', http://maia.usno.navy.mil/NSFA/NSFA_cbe.html)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double SUNTOERISSYSTEM_MASSRATIO; static { SUNTOERISSYSTEM_MASSRATIO = 1.1910e+8; } 

    /**
     * Ratio of Sun to Jupiter-system mass (IAU 2009 CBE value). The planetary mass includes the contribution of its satellites    
     * <p>
     * Source: The IAU (2009) System of Astronomical Constants (IAU, August 2009, 'IAU 2009 Astronomical Constants', IAU 2009 Resolution B2 adopted at the XXVII-th General Assembly of the IAU. See also IAU, 10 August 2009, 'IAU WG on NSFA Current Best Estimates', http://maia.usno.navy.mil/NSFA/NSFA_cbe.html)<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Ratio of Sun to Jupiter-system mass (IAU 2009 CBE value). The planetary mass includes the contribution of its satellites", 
     source = "The IAU (2009) System of Astronomical Constants (IAU, August 2009, 'IAU 2009 Astronomical Constants', IAU 2009 Resolution B2 adopted at the XXVII-th General Assembly of the IAU. See also IAU, 10 August 2009, 'IAU WG on NSFA Current Best Estimates', http://maia.usno.navy.mil/NSFA/NSFA_cbe.html)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double SUNTOJUPITERSYSTEM_MASSRATIO; static { SUNTOJUPITERSYSTEM_MASSRATIO = 1.0473486440e+3; } 

    /**
     * Ratio of Sun to Mars-system mass (IAU 2009 CBE value). The planetary mass includes the contribution of its satellites    
     * <p>
     * Source: The IAU (2009) System of Astronomical Constants (IAU, August 2009, 'IAU 2009 Astronomical Constants', IAU 2009 Resolution B2 adopted at the XXVII-th General Assembly of the IAU. See also IAU, 10 August 2009, 'IAU WG on NSFA Current Best Estimates', http://maia.usno.navy.mil/NSFA/NSFA_cbe.html)<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Ratio of Sun to Mars-system mass (IAU 2009 CBE value). The planetary mass includes the contribution of its satellites", 
     source = "The IAU (2009) System of Astronomical Constants (IAU, August 2009, 'IAU 2009 Astronomical Constants', IAU 2009 Resolution B2 adopted at the XXVII-th General Assembly of the IAU. See also IAU, 10 August 2009, 'IAU WG on NSFA Current Best Estimates', http://maia.usno.navy.mil/NSFA/NSFA_cbe.html)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double SUNTOMARSSYSTEM_MASSRATIO; static { SUNTOMARSSYSTEM_MASSRATIO = 3.098703590e+6; } 

    /**
     * Ratio of Sun to Mercury(-system) mass (IAU 2009 CBE value)    
     * <p>
     * Source: The IAU (2009) System of Astronomical Constants (IAU, August 2009, 'IAU 2009 Astronomical Constants', IAU 2009 Resolution B2 adopted at the XXVII-th General Assembly of the IAU. See also IAU, 10 August 2009, 'IAU WG on NSFA Current Best Estimates', http://maia.usno.navy.mil/NSFA/NSFA_cbe.html)<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Ratio of Sun to Mercury(-system) mass (IAU 2009 CBE value)", 
     source = "The IAU (2009) System of Astronomical Constants (IAU, August 2009, 'IAU 2009 Astronomical Constants', IAU 2009 Resolution B2 adopted at the XXVII-th General Assembly of the IAU. See also IAU, 10 August 2009, 'IAU WG on NSFA Current Best Estimates', http://maia.usno.navy.mil/NSFA/NSFA_cbe.html)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double SUNTOMERCURYSYSTEM_MASSRATIO; static { SUNTOMERCURYSYSTEM_MASSRATIO = 6.02360e+6; } 

    /**
     * Ratio of Sun to Neptune-system mass (IAU 2009 CBE value). The planetary mass includes the contribution of its satellites    
     * <p>
     * Source: The IAU (2009) System of Astronomical Constants (IAU, August 2009, 'IAU 2009 Astronomical Constants', IAU 2009 Resolution B2 adopted at the XXVII-th General Assembly of the IAU. See also IAU, 10 August 2009, 'IAU WG on NSFA Current Best Estimates', http://maia.usno.navy.mil/NSFA/NSFA_cbe.html)<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Ratio of Sun to Neptune-system mass (IAU 2009 CBE value). The planetary mass includes the contribution of its satellites", 
     source = "The IAU (2009) System of Astronomical Constants (IAU, August 2009, 'IAU 2009 Astronomical Constants', IAU 2009 Resolution B2 adopted at the XXVII-th General Assembly of the IAU. See also IAU, 10 August 2009, 'IAU WG on NSFA Current Best Estimates', http://maia.usno.navy.mil/NSFA/NSFA_cbe.html)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double SUNTONEPTUNESYSTEM_MASSRATIO; static { SUNTONEPTUNESYSTEM_MASSRATIO = 1.9412260e+4; } 

    /**
     * Ratio of Sun to Pluto-system mass (IAU 2009 CBE value). The 'planetary' mass includes the contribution of its satellite, Charon    
     * <p>
     * Source: The IAU (2009) System of Astronomical Constants (IAU, August 2009, 'IAU 2009 Astronomical Constants', IAU 2009 Resolution B2 adopted at the XXVII-th General Assembly of the IAU. See also IAU, 10 August 2009, 'IAU WG on NSFA Current Best Estimates', http://maia.usno.navy.mil/NSFA/NSFA_cbe.html)<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Ratio of Sun to Pluto-system mass (IAU 2009 CBE value). The 'planetary' mass includes the contribution of its satellite, Charon", 
     source = "The IAU (2009) System of Astronomical Constants (IAU, August 2009, 'IAU 2009 Astronomical Constants', IAU 2009 Resolution B2 adopted at the XXVII-th General Assembly of the IAU. See also IAU, 10 August 2009, 'IAU WG on NSFA Current Best Estimates', http://maia.usno.navy.mil/NSFA/NSFA_cbe.html)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double SUNTOPLUTOSYSTEM_MASSRATIO; static { SUNTOPLUTOSYSTEM_MASSRATIO = 1.365660e+8; } 

    /**
     * Ratio of Sun to Saturn-system mass (IAU 2009 CBE value). The planetary mass includes the contribution of its satellites    
     * <p>
     * Source: The IAU (2009) System of Astronomical Constants (IAU, August 2009, 'IAU 2009 Astronomical Constants', IAU 2009 Resolution B2 adopted at the XXVII-th General Assembly of the IAU. See also IAU, 10 August 2009, 'IAU WG on NSFA Current Best Estimates', http://maia.usno.navy.mil/NSFA/NSFA_cbe.html)<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Ratio of Sun to Saturn-system mass (IAU 2009 CBE value). The planetary mass includes the contribution of its satellites", 
     source = "The IAU (2009) System of Astronomical Constants (IAU, August 2009, 'IAU 2009 Astronomical Constants', IAU 2009 Resolution B2 adopted at the XXVII-th General Assembly of the IAU. See also IAU, 10 August 2009, 'IAU WG on NSFA Current Best Estimates', http://maia.usno.navy.mil/NSFA/NSFA_cbe.html)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double SUNTOSATURNSYSTEM_MASSRATIO; static { SUNTOSATURNSYSTEM_MASSRATIO = 3.49790180e+3; } 

    /**
     * Ratio of Sun to Uranus-system mass (IAU 2009 CBE value). The planetary mass includes the contribution of its satellites    
     * <p>
     * Source: The IAU (2009) System of Astronomical Constants (IAU, August 2009, 'IAU 2009 Astronomical Constants', IAU 2009 Resolution B2 adopted at the XXVII-th General Assembly of the IAU. See also IAU, 10 August 2009, 'IAU WG on NSFA Current Best Estimates', http://maia.usno.navy.mil/NSFA/NSFA_cbe.html)<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Ratio of Sun to Uranus-system mass (IAU 2009 CBE value). The planetary mass includes the contribution of its satellites", 
     source = "The IAU (2009) System of Astronomical Constants (IAU, August 2009, 'IAU 2009 Astronomical Constants', IAU 2009 Resolution B2 adopted at the XXVII-th General Assembly of the IAU. See also IAU, 10 August 2009, 'IAU WG on NSFA Current Best Estimates', http://maia.usno.navy.mil/NSFA/NSFA_cbe.html)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double SUNTOURANUSSYSTEM_MASSRATIO; static { SUNTOURANUSSYSTEM_MASSRATIO = 2.2902980e+4; } 

    /**
     * Ratio of Sun to Venus(-system) mass (IAU 2009 CBE value)    
     * <p>
     * Source: The IAU (2009) System of Astronomical Constants (IAU, August 2009, 'IAU 2009 Astronomical Constants', IAU 2009 Resolution B2 adopted at the XXVII-th General Assembly of the IAU. See also IAU, 10 August 2009, 'IAU WG on NSFA Current Best Estimates', http://maia.usno.navy.mil/NSFA/NSFA_cbe.html)<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Ratio of Sun to Venus(-system) mass (IAU 2009 CBE value)", 
     source = "The IAU (2009) System of Astronomical Constants (IAU, August 2009, 'IAU 2009 Astronomical Constants', IAU 2009 Resolution B2 adopted at the XXVII-th General Assembly of the IAU. See also IAU, 10 August 2009, 'IAU WG on NSFA Current Best Estimates', http://maia.usno.navy.mil/NSFA/NSFA_cbe.html)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double SUNTOVENUSSYSTEM_MASSRATIO; static { SUNTOVENUSSYSTEM_MASSRATIO = 4.085237190e+5; } 

    /**
     * The difference of TAI and UTC as function of time, since 1972, in units of seconds. UTC differs from TAI by an integral number of seconds ('leap seconds'), in such a way that UT1-UTC stays smaller than 0.9 s in absolute value. The decision to introduce a leap second in UTC to meet this condition is the responsability of the IERS. Announcements are made through IERS Bulletin C (https://hpiers.obspm.fr/eoppc/bul/bulc/). Positive leap seconds make the difference TAI-UTC more positive. The vector elements of this parameter define triplets {STARTTIME, ENDTIME, LEAPSECOND} where STARTTIME denotes the start time of the validity interval (in JD UTC), ENDTIME denotes the end time of the validity interval (in JD UTC), and LEAPSECOND denotes the difference TAI - UTC in units of seconds. Note that the ENDTIME of the final triplet (JD2500000.5 UTC) indicates that the end time of the current validity interval is undefined    
     * <p>
     * Source: IERS Bulletin C (https://hpiers.obspm.fr/iers/bul/bulc/Leap_Second.dat; see also http://maia.usno.navy.mil/ser7/tai-utc.dat)<br/>
     * Status: CONF<br/>
     * Unit: s<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "The difference of TAI and UTC as function of time, since 1972, in units of seconds. UTC differs from TAI by an integral number of seconds ('leap seconds'), in such a way that UT1-UTC stays smaller than 0.9 s in absolute value. The decision to introduce a leap second in UTC to meet this condition is the responsability of the IERS. Announcements are made through IERS Bulletin C (https://hpiers.obspm.fr/eoppc/bul/bulc/). Positive leap seconds make the difference TAI-UTC more positive. The vector elements of this parameter define triplets {STARTTIME, ENDTIME, LEAPSECOND} where STARTTIME denotes the start time of the validity interval (in JD UTC), ENDTIME denotes the end time of the validity interval (in JD UTC), and LEAPSECOND denotes the difference TAI - UTC in units of seconds. Note that the ENDTIME of the final triplet (JD2500000.5 UTC) indicates that the end time of the current validity interval is undefined", 
     source = "IERS Bulletin C (https://hpiers.obspm.fr/iers/bul/bulc/Leap_Second.dat; see also http://maia.usno.navy.mil/ser7/tai-utc.dat)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "s") 
    public static final double TAIMINUTC_CONSTANT[][] = {{2441317.5,  2441499.5,  10.0},  {2441499.5,  2441683.5,  11.0},  {2441683.5,  2442048.5,  12.0},  {2442048.5,  2442413.5,  13.0},  {2442413.5,  2442778.5,  14.0},  {2442778.5,  2443144.5,  15.0},  {2443144.5,  2443509.5,  16.0},  {2443509.5,  2443874.5,  17.0},  {2443874.5,  2444239.5,  18.0},  {2444239.5,  2444786.5,  19.0},  {2444786.5,  2445151.5,  20.0},  {2445151.5,  2445516.5,  21.0},  {2445516.5,  2446247.5,  22.0},  {2446247.5,  2447161.5,  23.0},  {2447161.5,  2447892.5,  24.0},  {2447892.5,  2448257.5,  25.0},  {2448257.5,  2448804.5,  26.0},  {2448804.5,  2449169.5,  27.0},  {2449169.5,  2449534.5,  28.0},  {2449534.5,  2450083.5,  29.0},  {2450083.5,  2450630.5,  30.0},  {2450630.5,  2451179.5,  31.0},  {2451179.5,  2453736.5,  32.0},  {2453736.5,  2454832.5,  33.0},  {2454832.5,  2456109.5,  34.0},  {2456109.5,  2457204.5,  35.0},  {2457204.5,  2457754.5,  36.0},  {2457754.5,  2500000.5,  37.0}}; // [s] 

    /**
     * Temperature constant encountered in physics of stellar atmospheres    
     * <p>
     * Source: E.g., E. Bohm-Vitense, 1997, 'Introduction to stellar astrophysics; Volume 2: stellar atmospheres', Cambridge University Press, page 74<br/>
     * Status: CONF<br/>
     * Unit: K<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Temperature constant encountered in physics of stellar atmospheres", 
     source = "E.g., E. Bohm-Vitense, 1997, 'Introduction to stellar astrophysics; Volume 2: stellar atmospheres', Cambridge University Press, page 74", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "K") 
    public static final double TEMPERATURE_CONSTANT; static { TEMPERATURE_CONSTANT = 5039.8; } // [K] 

    /**
     * Transformation matrix which transforms the unit-direction vector r_equ, expressed in equatorial coordinates (ICRS), into the unit-direction vector r_gal in Galactic coordinates: r_gal = A_G^T times r_equ (see ESA, 1997, 'The Hipparcos and Tycho Catalogues', ESA SP-1200, Volume 1, Section 1.5.3, Equation 1.5.13; A_G^T denotes the transpose of matrix A_G)    
     * <p>
     * Source: ESA, 1997, 'The Hipparcos and Tycho Catalogues', ESA SP-1200, Volume 1, Section 1.5.3, transpose of Equation 1.5.11 (transpose of matrix A_G)<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Transformation matrix which transforms the unit-direction vector r_equ, expressed in equatorial coordinates (ICRS), into the unit-direction vector r_gal in Galactic coordinates: r_gal = A_G^T times r_equ (see ESA, 1997, 'The Hipparcos and Tycho Catalogues', ESA SP-1200, Volume 1, Section 1.5.3, Equation 1.5.13; A_G^T denotes the transpose of matrix A_G)", 
     source = "ESA, 1997, 'The Hipparcos and Tycho Catalogues', ESA SP-1200, Volume 1, Section 1.5.3, transpose of Equation 1.5.11 (transpose of matrix A_G)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double TRANSFORMATIONMATRIX_ICRSTOGALACTIC[] = {-0.0548755604162154,  -0.8734370902348850,  -0.4838350155487132,  +0.4941094278755837,  -0.4448296299600112,  +0.7469822444972189,  -0.8676661490190047,  -0.1980763734312015,  +0.4559837761750669}; 

    /**
     * Transformation matrix which transforms the unit-direction vector r_gal, expressed in Galactic coordinates, into the unit-direction vector r_equ in equatorial coordinates (ICRS): r_equ = A_G times r_gal (see ESA, 1997, 'The Hipparcos and Tycho Catalogues', ESA SP-1200, Volume 1, Section 1.5.3, inverse of Equation 1.5.13)    
     * <p>
     * Source: ESA, 1997, 'The Hipparcos and Tycho Catalogues', ESA SP-1200, Volume 1, Section 1.5.3, Equation 1.5.11 (matrix A_G)<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Transformation matrix which transforms the unit-direction vector r_gal, expressed in Galactic coordinates, into the unit-direction vector r_equ in equatorial coordinates (ICRS): r_equ = A_G times r_gal (see ESA, 1997, 'The Hipparcos and Tycho Catalogues', ESA SP-1200, Volume 1, Section 1.5.3, inverse of Equation 1.5.13)", 
     source = "ESA, 1997, 'The Hipparcos and Tycho Catalogues', ESA SP-1200, Volume 1, Section 1.5.3, Equation 1.5.11 (matrix A_G)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double TRANSFORMATIONMATRIX_GALACTICTOICRS[] = {-0.0548755604162154,  +0.4941094278755837,  -0.8676661490190047,  -0.8734370902348850,  -0.4448296299600112,  -0.1980763734312015,  -0.4838350155487132,  +0.7469822444972189,  +0.4559837761750669}; 

    /**
     * Transformation matrix which transforms the unit-direction vector r_equ, expressed in equatorial coordinates (ICRS), into the unit-direction vector r_ecl in ecliptic coordinates: r_ecl = A_K^T times r_equ (see also ESA, 1997, 'The Hipparcos and Tycho Catalogues', ESA SP-1200, Volume 1, Section 1.5.3, Equation 1.5.12; A_K^T denotes the transpose of matrix A_K). Note that the ICRS origin is shifted in the equatorial plane from \Gamma by \phi = 0.05542 arcsec, positive from \Gamma to the ICRS origin (see J. Chapront, M. Chapront-Touze, G. Francou, 2002, 'A new determination of lunar orbital parameters, precession constant, and tidal acceleration from LLR measurements', A&A, 387, 700). The ICRS has an unambiguous definition with an origin in the ICRF equator defined by the realisation of the ICRF. The ecliptic system is less well-defined, potentially depending on additional conventions in dynamical theories. The transformation quantified here corresponds to the inertial mean ecliptic with obliquity (see parameter :Nature:ObliquityOfEcliptic_J2000) and \Gamma defined by reference to the ICRS equator (other possibilities include the mean equator for J2000 or one of the JPL ephemerides equators). Both the obliquity and the position of \Gamma on the ICRS equator with respect to the ICRS origin have been obtained from LLR measurements. The transformation quantified here has no time dependence (there is no secular variation of the obliquity and no precession): it simply defines the relative situation of the various planes at J2000.0    
     * <p>
     * Source: ESA, 1997, 'The Hipparcos and Tycho Catalogues', ESA SP-1200, Volume 1, Section 1.5.3, transpose of Equation 1.5.7 (transpose of generalised matrix A_K)<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Transformation matrix which transforms the unit-direction vector r_equ, expressed in equatorial coordinates (ICRS), into the unit-direction vector r_ecl in ecliptic coordinates: r_ecl = A_K^T times r_equ (see also ESA, 1997, 'The Hipparcos and Tycho Catalogues', ESA SP-1200, Volume 1, Section 1.5.3, Equation 1.5.12; A_K^T denotes the transpose of matrix A_K). Note that the ICRS origin is shifted in the equatorial plane from \\Gamma by \\phi = 0.05542 arcsec, positive from \\Gamma to the ICRS origin (see J. Chapront, M. Chapront-Touze, G. Francou, 2002, 'A new determination of lunar orbital parameters, precession constant, and tidal acceleration from LLR measurements', A&A, 387, 700). The ICRS has an unambiguous definition with an origin in the ICRF equator defined by the realisation of the ICRF. The ecliptic system is less well-defined, potentially depending on additional conventions in dynamical theories. The transformation quantified here corresponds to the inertial mean ecliptic with obliquity (see parameter :Nature:ObliquityOfEcliptic_J2000) and \\Gamma defined by reference to the ICRS equator (other possibilities include the mean equator for J2000 or one of the JPL ephemerides equators). Both the obliquity and the position of \\Gamma on the ICRS equator with respect to the ICRS origin have been obtained from LLR measurements. The transformation quantified here has no time dependence (there is no secular variation of the obliquity and no precession): it simply defines the relative situation of the various planes at J2000.0", 
     source = "ESA, 1997, 'The Hipparcos and Tycho Catalogues', ESA SP-1200, Volume 1, Section 1.5.3, transpose of Equation 1.5.7 (transpose of generalised matrix A_K)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double TRANSFORMATIONMATRIX_ICRSTOECLIPTIC[] = {+0.9999999999999639,  -0.0000002686837421,  +0.0000000000000000,  +0.0000002465125329,  +0.9174821334228226,  +0.3977769913530006,  -0.0000001068762105,  -0.3977769913529863,  +0.9174821334228557}; 

    /**
     * Transformation matrix which transforms the unit-direction vector r_ecl, expressed in ecliptic coordinates, into the unit-direction vector r_equ in equatorial coordinates (ICRS): r_equ = A_K times r_ecl (see also ESA, 1997, 'The Hipparcos and Tycho Catalogues', ESA SP-1200, Volume 1, Section 1.5.3, inverse of Equation 1.5.12). Note that the ICRS origin is shifted in the equatorial plane from \Gamma by \phi = 0.05542 arcsec, positive from \Gamma to the ICRS origin (see J. Chapront, M. Chapront-Touze, G. Francou, 2002, 'A new determination of lunar orbital parameters, precession constant, and tidal acceleration from LLR measurements', A&A, 387, 700). The ICRS has an unambiguous definition with an origin in the ICRF equator defined by the realisation of the ICRF. The ecliptic system is less well-defined, potentially depending on additional conventions in dynamical theories. The transformation quantified here corresponds to the inertial mean ecliptic with obliquity (see parameter :Nature:ObliquityOfEcliptic_J2000) and \Gamma defined by reference to the ICRS equator (other possibilities include the mean equator for J2000 or one of the JPL ephemerides equators). Both the obliquity and the position of \Gamma on the ICRS equator with respect to the ICRS origin have been obtained from LLR measurements. The transformation quantified here has no time dependence (there is no secular variation of the obliquity and no precession): it simply defines the relative situation of the various planes at J2000.0    
     * <p>
     * Source: ESA, 1997, 'The Hipparcos and Tycho Catalogues', ESA SP-1200, Volume 1, Section 1.5.3, Equation 1.5.7 (generalised matrix A_K)<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Transformation matrix which transforms the unit-direction vector r_ecl, expressed in ecliptic coordinates, into the unit-direction vector r_equ in equatorial coordinates (ICRS): r_equ = A_K times r_ecl (see also ESA, 1997, 'The Hipparcos and Tycho Catalogues', ESA SP-1200, Volume 1, Section 1.5.3, inverse of Equation 1.5.12). Note that the ICRS origin is shifted in the equatorial plane from \\Gamma by \\phi = 0.05542 arcsec, positive from \\Gamma to the ICRS origin (see J. Chapront, M. Chapront-Touze, G. Francou, 2002, 'A new determination of lunar orbital parameters, precession constant, and tidal acceleration from LLR measurements', A&A, 387, 700). The ICRS has an unambiguous definition with an origin in the ICRF equator defined by the realisation of the ICRF. The ecliptic system is less well-defined, potentially depending on additional conventions in dynamical theories. The transformation quantified here corresponds to the inertial mean ecliptic with obliquity (see parameter :Nature:ObliquityOfEcliptic_J2000) and \\Gamma defined by reference to the ICRS equator (other possibilities include the mean equator for J2000 or one of the JPL ephemerides equators). Both the obliquity and the position of \\Gamma on the ICRS equator with respect to the ICRS origin have been obtained from LLR measurements. The transformation quantified here has no time dependence (there is no secular variation of the obliquity and no precession): it simply defines the relative situation of the various planes at J2000.0", 
     source = "ESA, 1997, 'The Hipparcos and Tycho Catalogues', ESA SP-1200, Volume 1, Section 1.5.3, Equation 1.5.7 (generalised matrix A_K)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double TRANSFORMATIONMATRIX_ECLIPTICTOICRS[] = {+0.9999999999999639,  +0.0000002465125329,  -0.0000001068762105,  -0.0000002686837421,  +0.9174821334228226,  -0.3977769913529863,  +0.0000000000000000,  +0.3977769913530006,  +0.9174821334228557}; 

    /**
     * Number of days per tropical year    
     * <p>
     * Source: J.L. Simon, P. Bretagnon, J. Chapront, M. Chapront-Touze, G. Francou, J. Laskar, 1994, 'Numerical expressions for precession formulae and mean elements for the Moon and the planets', A&A, 282, 663 (1994A&A...282..663S)<br/>
     * Status: CONF<br/>
     * Unit: day<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Number of days per tropical year", 
     source = "J.L. Simon, P. Bretagnon, J. Chapront, M. Chapront-Touze, G. Francou, J. Laskar, 1994, 'Numerical expressions for precession formulae and mean elements for the Moon and the planets', A&A, 282, 663 (1994A&A...282..663S)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "day") 
    public static final double TROPICALYEAR_J2000DAY; static { TROPICALYEAR_J2000DAY = 365.242190402; } // [day] 

    /**
     * Nominal value of the (constant) offset between TAI and TT: TT(TAI) = TAI + 32.184 s. This offset was chosen to give continuity with the previously used, but now obsolete, Ephemeris Time (see P.K. Seidelmann, 1992, 'Explanatory Supplement to the Astronomical Almanac', University Science Books, Mill Valley, Ca., ISBN 0-935702-68-7). Deviations of this value, which are attributable to physical defects of atomic time standards, are probably between the limits \pm 10 \mus    
     * <p>
     * Source: ESA, 1997, 'The Hipparcos and Tycho Catalogues', Volume 1, page 23<br/>
     * Status: CONF<br/>
     * Unit: s<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Nominal value of the (constant) offset between TAI and TT: TT(TAI) = TAI + 32.184 s. This offset was chosen to give continuity with the previously used, but now obsolete, Ephemeris Time (see P.K. Seidelmann, 1992, 'Explanatory Supplement to the Astronomical Almanac', University Science Books, Mill Valley, Ca., ISBN 0-935702-68-7). Deviations of this value, which are attributable to physical defects of atomic time standards, are probably between the limits \\pm 10 \\mus", 
     source = "ESA, 1997, 'The Hipparcos and Tycho Catalogues', Volume 1, page 23", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "s") 
    public static final double TTMINTAI_CONSTANT_NOMINAL; static { TTMINTAI_CONSTANT_NOMINAL = 32.184; } // [s] 

    /**
     * Chebyshev representation of the ephemerides of Uranus, with origin at the barycentre of the solar system (BCRS), in the equatorial ICRF frame. The ephemeris covers the period starting on JD (JDBEGIP + JDBEGFP) and ending on JD (JDENDIP + JDENDFP) for the position and starting on JD (JDBEGIV + JDBEGFV) and ending on JD (JDENDIV + JDENDFV) for the velocity. A number of Chebyshev coefficients equal to ORDERSP is given for NSSP time intervals of SPANSP days to describe the position-vector components in units of m; the similar parameters ending with PP (Peculiar Position) are not used in the current release and are reserved for future usage. A number of Chebyshev coefficients equal to ORDERSV is given for NSSV time intervals of SPANSV days to describe the velocity-vector components in units of m s^-1; the similar parameters ending with PV (Peculiar Velocity) are not used in the current release and are reserved for future usage. The first three HDUs contain the coefficients for the three components of the position, while the last three HDUs contain the coefficients for the three components of the velocity    
     * <p>
     * Source: A. Fienga, J. Laskar, H. Manche, M. Gastineau, 19 April 2007, 'Solar system planetary ephemeris delivery: INPOP06', GAIA-CA-TN-IMC-AF-001, issue 1, revision 0<br/>
     * Status: DEPR<br/>
     * Basic : true<br/>
     * Scalar: false
     */
    @ParamMetaData (
    description = "Chebyshev representation of the ephemerides of Uranus, with origin at the barycentre of the solar system (BCRS), in the equatorial ICRF frame. The ephemeris covers the period starting on JD (JDBEGIP + JDBEGFP) and ending on JD (JDENDIP + JDENDFP) for the position and starting on JD (JDBEGIV + JDBEGFV) and ending on JD (JDENDIV + JDENDFV) for the velocity. A number of Chebyshev coefficients equal to ORDERSP is given for NSSP time intervals of SPANSP days to describe the position-vector components in units of m; the similar parameters ending with PP (Peculiar Position) are not used in the current release and are reserved for future usage. A number of Chebyshev coefficients equal to ORDERSV is given for NSSV time intervals of SPANSV days to describe the velocity-vector components in units of m s^-1; the similar parameters ending with PV (Peculiar Velocity) are not used in the current release and are reserved for future usage. The first three HDUs contain the coefficients for the three components of the position, while the last three HDUs contain the coefficients for the three components of the velocity", 
     source = "A. Fienga, J. Laskar, H. Manche, M. Gastineau, 19 April 2007, 'Solar system planetary ephemeris delivery: INPOP06', GAIA-CA-TN-IMC-AF-001, issue 1, revision 0", 
     status = "DEPR", 
     basic = true, 
     scalar = false, 
     unit = "") 
    public static final String URANUS_EPHEMERIS; static { URANUS_EPHEMERIS = "Nature/Uranus_Ephemeris_004.fits"; } 

    /**
     * IAU-recommended value for the right ascension \alpha_0 of the north pole of rotation of Uranus. The pair (\alpha_0, \delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \alpha_0 = 273.85 deg and \delta_0 = 66.99 degrees    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)<br/>
     * Status: CONF<br/>
     * Unit: deg<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "IAU-recommended value for the right ascension \\alpha_0 of the north pole of rotation of Uranus. The pair (\\alpha_0, \\delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \\alpha_0 = 273.85 deg and \\delta_0 = 66.99 degrees", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "deg") 
    public static final double URANUS_NORTHROTATIONALPOLE_RIGHTASCENSION; static { URANUS_NORTHROTATIONALPOLE_RIGHTASCENSION = 257.311; } // [deg] 

    /**
     * IAU-recommended value for the rate of change (in degrees per Julian day, calculated from the standard epoch) of the right ascension \alpha_0 of the north pole of rotation of Uranus. The pair (\alpha_0, \delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \alpha_0 = 273.85 deg and \delta_0 = 66.99 degrees    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)<br/>
     * Status: CONF<br/>
     * Unit: deg day^-1<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "IAU-recommended value for the rate of change (in degrees per Julian day, calculated from the standard epoch) of the right ascension \\alpha_0 of the north pole of rotation of Uranus. The pair (\\alpha_0, \\delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \\alpha_0 = 273.85 deg and \\delta_0 = 66.99 degrees", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "deg day^-1") 
    public static final double URANUS_NORTHROTATIONALPOLE_RIGHTASCENSIONRATEOFCHANGE; static { URANUS_NORTHROTATIONALPOLE_RIGHTASCENSIONRATEOFCHANGE = 0.; } // [deg day^-1] 

    /**
     * IAU-recommended value for the declination \delta_0 of the north pole of rotation of Uranus. The pair (\alpha_0, \delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \alpha_0 = 273.85 deg and \delta_0 = 66.99 degrees    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)<br/>
     * Status: CONF<br/>
     * Unit: deg<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "IAU-recommended value for the declination \\delta_0 of the north pole of rotation of Uranus. The pair (\\alpha_0, \\delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \\alpha_0 = 273.85 deg and \\delta_0 = 66.99 degrees", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "deg") 
    public static final double URANUS_NORTHROTATIONALPOLE_DECLINATION; static { URANUS_NORTHROTATIONALPOLE_DECLINATION = -15.175; } // [deg] 

    /**
     * IAU-recommended value for the rate of change (in degrees per Julian day, calculated from the standard epoch) of the declination \delta_0 of the north pole of rotation of Uranus. The pair (\alpha_0, \delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \alpha_0 = 273.85 deg and \delta_0 = 66.99 degrees    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)<br/>
     * Status: CONF<br/>
     * Unit: deg day^-1<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "IAU-recommended value for the rate of change (in degrees per Julian day, calculated from the standard epoch) of the declination \\delta_0 of the north pole of rotation of Uranus. The pair (\\alpha_0, \\delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \\alpha_0 = 273.85 deg and \\delta_0 = 66.99 degrees", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "deg day^-1") 
    public static final double URANUS_NORTHROTATIONALPOLE_DECLINATIONRATEOFCHANGE; static { URANUS_NORTHROTATIONALPOLE_DECLINATIONRATEOFCHANGE = 0.; } // [deg day^-1] 

    /**
     * IAU-recommended value for the ephemeris position of the prime meridian of Uranus. The prime meridian refers to the rotation of the magnetic field System III. The location of the prime meridian is specified by the angle that is measured along the planet's equator in an easterly direction with respect to the planet's north pole from the node Q (located at right ascension 90 deg + \alpha_0, where \alpha_0 denotes the right ascension of the north pole of rotation) of the planet's equator on the standard equator to the point B where the prime meridian crosses the planet's equator. The right ascension of the point Q is 90 deg + \alpha_0 and the inclination of the planet's equator to the standard equator is 90 deg - \delta_0, where \delta_0 denotes the declination of the north pole of rotation. (The pair (\alpha_0, \delta_0) denotes the standard equatorial coordinates, with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB), of the north pole of rotation, which itself is defined as that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \alpha_0 = 273.85 deg and \delta_0 = 66.99 degrees.) Because the prime meridian is assumed to rotate uniformly with the planet, W accordingly varies linearly with time. In addition, \alpha_0, \delta_0, and W may vary with time due to a precession of the axis of rotation of the planet. If W increases with time, the planet has a direct (or prograde) rotation; if W decreases with time, the rotation is said to be retrograde    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)<br/>
     * Status: CONF<br/>
     * Unit: deg<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "IAU-recommended value for the ephemeris position of the prime meridian of Uranus. The prime meridian refers to the rotation of the magnetic field System III. The location of the prime meridian is specified by the angle that is measured along the planet's equator in an easterly direction with respect to the planet's north pole from the node Q (located at right ascension 90 deg + \\alpha_0, where \\alpha_0 denotes the right ascension of the north pole of rotation) of the planet's equator on the standard equator to the point B where the prime meridian crosses the planet's equator. The right ascension of the point Q is 90 deg + \\alpha_0 and the inclination of the planet's equator to the standard equator is 90 deg - \\delta_0, where \\delta_0 denotes the declination of the north pole of rotation. (The pair (\\alpha_0, \\delta_0) denotes the standard equatorial coordinates, with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB), of the north pole of rotation, which itself is defined as that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \\alpha_0 = 273.85 deg and \\delta_0 = 66.99 degrees.) Because the prime meridian is assumed to rotate uniformly with the planet, W accordingly varies linearly with time. In addition, \\alpha_0, \\delta_0, and W may vary with time due to a precession of the axis of rotation of the planet. If W increases with time, the planet has a direct (or prograde) rotation; if W decreases with time, the rotation is said to be retrograde", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "deg") 
    public static final double URANUS_PRIMEMERIDIAN_EPHEMERISPOSITION; static { URANUS_PRIMEMERIDIAN_EPHEMERISPOSITION = 203.81; } // [deg] 

    /**
     * IAU-recommended value for the rate of change (in degrees per Julian day, calculated from the standard epoch of 1.5 January 2000 = JD2451545.0 TDB) of the ephemeris position of the prime meridian of Uranus. The prime meridian refers to the rotation of the magnetic field System III. The location of the prime meridian is specified by the angle that is measured along the planet's equator in an easterly direction with respect to the planet's north pole from the node Q (located at right ascension 90 deg + \alpha_0, where \alpha_0 denotes the right ascension of the north pole of rotation) of the planet's equator on the standard equator to the point B where the prime meridian crosses the planet's equator. The right ascension of the point Q is 90 deg + \alpha_0 and the inclination of the planet's equator to the standard equator is 90 deg - \delta_0, where \delta_0 denotes the declination of the north pole of rotation. (The pair (\alpha_0, \delta_0) denotes the standard equatorial coordinates, with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB), of the north pole of rotation, which itself is defined as that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \alpha_0 = 273.85 deg and \delta_0 = 66.99 degrees.) Because the prime meridian is assumed to rotate uniformly with the planet, W accordingly varies linearly with time. In addition, \alpha_0, \delta_0, and W may vary with time due to a precession of the axis of rotation of the planet. If W increases with time, the planet has a direct (or prograde) rotation; if W decreases with time, the rotation is said to be retrograde    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)<br/>
     * Status: CONF<br/>
     * Unit: deg day^-1<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "IAU-recommended value for the rate of change (in degrees per Julian day, calculated from the standard epoch of 1.5 January 2000 = JD2451545.0 TDB) of the ephemeris position of the prime meridian of Uranus. The prime meridian refers to the rotation of the magnetic field System III. The location of the prime meridian is specified by the angle that is measured along the planet's equator in an easterly direction with respect to the planet's north pole from the node Q (located at right ascension 90 deg + \\alpha_0, where \\alpha_0 denotes the right ascension of the north pole of rotation) of the planet's equator on the standard equator to the point B where the prime meridian crosses the planet's equator. The right ascension of the point Q is 90 deg + \\alpha_0 and the inclination of the planet's equator to the standard equator is 90 deg - \\delta_0, where \\delta_0 denotes the declination of the north pole of rotation. (The pair (\\alpha_0, \\delta_0) denotes the standard equatorial coordinates, with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB), of the north pole of rotation, which itself is defined as that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \\alpha_0 = 273.85 deg and \\delta_0 = 66.99 degrees.) Because the prime meridian is assumed to rotate uniformly with the planet, W accordingly varies linearly with time. In addition, \\alpha_0, \\delta_0, and W may vary with time due to a precession of the axis of rotation of the planet. If W increases with time, the planet has a direct (or prograde) rotation; if W decreases with time, the rotation is said to be retrograde", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "deg day^-1") 
    public static final double URANUS_PRIMEMERIDIAN_EPHEMERISPOSITIONRATEOFCHANGE; static { URANUS_PRIMEMERIDIAN_EPHEMERISPOSITIONRATEOFCHANGE = -501.1600928; } // [deg day^-1] 

    /**
     * Mass of Uranus (do not use for high-precision (orbit) calculations)    
     * <p>
     * Source: R.A. Jacobson, 2007, 'The gravity field of the Uranian system and the orbits of the Uranian satellites and rings', BAAS, 39, 453; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par<br/>
     * Status: CONF<br/>
     * Unit: kg<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mass of Uranus (do not use for high-precision (orbit) calculations)", 
     source = "R.A. Jacobson, 2007, 'The gravity field of the Uranian system and the orbits of the Uranian satellites and rings', BAAS, 39, 453; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "kg") 
    public static final double URANUS_MASS; static { URANUS_MASS = 8.681030e+25; } // [kg] 

    /**
     * Mean volumetric radius of Uranus    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A); see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par<br/>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean volumetric radius of Uranus", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A); see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "m") 
    public static final double URANUS_VOLUMETRICRADIUS; static { URANUS_VOLUMETRICRADIUS = 2.53620e+7; } // [m] 

    /**
     * Equatorial radius of Uranus    
     * <p>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Equatorial radius of Uranus", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m") 
    public static final double URANUS_EQUATORIALRADIUS; static { URANUS_EQUATORIALRADIUS = 2.55588e+7; } // [m] 

    /**
     * Polar radius of Uranus    
     * <p>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Polar radius of Uranus", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m") 
    public static final double URANUS_POLARRADIUS; static { URANUS_POLARRADIUS = 2.49728e+7; } // [m] 

    /**
     * V(1,0) magnitude of Uranus (i.e., the visual magnitude of the planet reduced to a distance of 1 au from both the Sun and Earth and phase angle zero). This parameter is also refered to as absolute magnitude in planetary sciences    
     * <p>
     * Source: P.K. Seidelmann, 1992, 'Explanatory Supplement to the Astronomical Almanac', University Science Books, Mill Valley, Ca., ISBN 0-935702-68-7, Table 15.8 on page 706; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par<br/>
     * Status: CONF<br/>
     * Unit: mag<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "V(1,0) magnitude of Uranus (i.e., the visual magnitude of the planet reduced to a distance of 1 au from both the Sun and Earth and phase angle zero). This parameter is also refered to as absolute magnitude in planetary sciences", 
     source = "P.K. Seidelmann, 1992, 'Explanatory Supplement to the Astronomical Almanac', University Science Books, Mill Valley, Ca., ISBN 0-935702-68-7, Table 15.8 on page 706; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "mag") 
    public static final double URANUS_VONEZEROMAGNITUDE; static { URANUS_VONEZEROMAGNITUDE = -7.19; } // [mag] 

    /**
     * Geometric albedo of Uranus (i.e., the ratio of the body's brightness at zero phase angle to the brightness of a perfectly diffusing disk with the same position and apparent size as the body)    
     * <p>
     * Source: P.K. Seidelmann, 1992, 'Explanatory Supplement to the Astronomical Almanac', University Science Books, Mill Valley, Ca., ISBN 0-935702-68-7, Table 15.8 on page 706; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Geometric albedo of Uranus (i.e., the ratio of the body's brightness at zero phase angle to the brightness of a perfectly diffusing disk with the same position and apparent size as the body)", 
     source = "P.K. Seidelmann, 1992, 'Explanatory Supplement to the Astronomical Almanac', University Science Books, Mill Valley, Ca., ISBN 0-935702-68-7, Table 15.8 on page 706; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double URANUS_GEOMETRICALBEDO; static { URANUS_GEOMETRICALBEDO = 0.51; } 

    /**
     * Mean mass density of Uranus    
     * <p>
     * Status: CONF<br/>
     * Unit: g cm^-3<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean mass density of Uranus", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "g cm^-3") 
    public static final double URANUS_MASSDENSITY_MEAN; static { URANUS_MASSDENSITY_MEAN = 1.270; } // [g cm^-3] 

    /**
     * Radius of the smallest hypothetical sphere around Uranus which would encompass the body (this is a low-accuracy parameter used in the relativistic model)    
     * <p>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Radius of the smallest hypothetical sphere around Uranus which would encompass the body (this is a low-accuracy parameter used in the relativistic model)", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m") 
    public static final double URANUS_ENCOMPASSINGSPHERERADIUS; static { URANUS_ENCOMPASSINGSPHERERADIUS = 2.55588e+7; } // [m] 

    /**
     * Dynamical form-factor of Uranus (oblateness or Stokes' second-degree zonal harmonic of the potential)    
     * <p>
     * Source: P.R. Weissman, L.-A. McFadden, T.V. Johnson (eds.), 1999, 'Encyclopedia of the Solar System (first edition)', Academic Press, page 342<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Dynamical form-factor of Uranus (oblateness or Stokes' second-degree zonal harmonic of the potential)", 
     source = "P.R. Weissman, L.-A. McFadden, T.V. Johnson (eds.), 1999, 'Encyclopedia of the Solar System (first edition)', Academic Press, page 342", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double URANUS_JSUB2; static { URANUS_JSUB2 = 0.003516; } 

    /**
     * Geometrical flattening factor f of Uranus (f = (a-b)/a)    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A); see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Geometrical flattening factor f of Uranus (f = (a-b)/a)", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A); see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double URANUS_FLATTENING; static { URANUS_FLATTENING = 2.292730e-2; } 

    /**
     * Post-Newtonian deflection angle of a limb-grazing light ray due to the spherically symmetric part of the gravitational field of Uranus    
     * <p>
     * Source: S.A. Klioner, 2003, 'A Practical Relativistic Model for Microarcsecond Astrometry in Space', AJ, 125, 1580, Equation 64 with cot(x) = cos(x) / sin(x) approximated by x^-1; see also J.H.J. de Bruijne, 19 February 2002, 'Gravitational light deflection', GAIA-JdB-001, issue 1, revision 0<br/>
     * Status: CONF<br/>
     * Unit: 10^-6 arcsec<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Post-Newtonian deflection angle of a limb-grazing light ray due to the spherically symmetric part of the gravitational field of Uranus", 
     source = "S.A. Klioner, 2003, 'A Practical Relativistic Model for Microarcsecond Astrometry in Space', AJ, 125, 1580, Equation 64 with cot(x) = cos(x) / sin(x) approximated by x^-1; see also J.H.J. de Bruijne, 19 February 2002, 'Gravitational light deflection', GAIA-JdB-001, issue 1, revision 0", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "10^-6 arcsec") 
    public static final double URANUS_LIGHTDEFLECTION_LIMB; static { URANUS_LIGHTDEFLECTION_LIMB = 2097.; } // [10^-6 arcsec] 

    /**
     * Geometric transit probability (Uranus transiting the Sun) for an observer external to the solar system    
     * <p>
     * Source: E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 2.1, Equation 2.2, page 14<br/>
     * Status: CONF<br/>
     * Unit: %<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Geometric transit probability (Uranus transiting the Sun) for an observer external to the solar system", 
     source = "E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 2.1, Equation 2.2, page 14", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "%") 
    public static final double URANUS_TRANSITPROBABILITY; static { URANUS_TRANSITPROBABILITY = 0.025; } // [%] 

    /**
     * Maximum reduction of the solar flux for an observer external to the solar system during a transit of Uranus    
     * <p>
     * Source: E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 2.2, Equation 2.4, page 14<br/>
     * Status: CONF<br/>
     * Unit: %<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Maximum reduction of the solar flux for an observer external to the solar system during a transit of Uranus", 
     source = "E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 2.2, Equation 2.4, page 14", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "%") 
    public static final double URANUS_FLUXREDUCTION_MAXIMUM; static { URANUS_FLUXREDUCTION_MAXIMUM = 0.133; } // [%] 

    /**
     * Maximum transit time of Uranus (transiting the Sun) for an observer external to the solar system    
     * <p>
     * Source: E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 2.3, Equation 2.5, page 15<br/>
     * Status: CONF<br/>
     * Unit: day<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Maximum transit time of Uranus (transiting the Sun) for an observer external to the solar system", 
     source = "E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 2.3, Equation 2.5, page 15", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "day") 
    public static final double URANUS_TRANSITTIME_MAXIMUM; static { URANUS_TRANSITTIME_MAXIMUM = 2.45; } // [day] 

    /**
     * Uranus-system mass (IAU 2009 CBE value). The planetary mass includes the contribution of its satellites    
     * <p>
     * Status: CONF<br/>
     * Unit: kg<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Uranus-system mass (IAU 2009 CBE value). The planetary mass includes the contribution of its satellites", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "kg") 
    public static final double URANUSSYSTEM_MASS; static { URANUSSYSTEM_MASS = 8.68217e+25; } // [kg] 

    /**
     * Mean orbital semi-major axis of Uranus, at the standard epoch J2000.0. The mean orbital semi-major axis is associated with a mean orbit solution from a 250-year least-squares fit of JPL's DE405 ephemeris to a Keplerian orbit covering the interval of years 1800 AD - 2050 AD. The orbital element is referenced to the mean ecliptic and equinox of J2000 at the standard epoch J2000.0; linear rates and fit errors can be found in the reference document    
     * <p>
     * Source: E.M. Standish, 16 February 2006, 'Keplerian Elements for Approximate Positions of the Major Planets', http://ssd.jpl.nasa.gov/?planets\#elem<br/>
     * Status: CONF<br/>
     * Unit: au<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean orbital semi-major axis of Uranus, at the standard epoch J2000.0. The mean orbital semi-major axis is associated with a mean orbit solution from a 250-year least-squares fit of JPL's DE405 ephemeris to a Keplerian orbit covering the interval of years 1800 AD - 2050 AD. The orbital element is referenced to the mean ecliptic and equinox of J2000 at the standard epoch J2000.0; linear rates and fit errors can be found in the reference document", 
     source = "E.M. Standish, 16 February 2006, 'Keplerian Elements for Approximate Positions of the Major Planets', http://ssd.jpl.nasa.gov/?planets\\#elem", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "au") 
    public static final double URANUSSYSTEM_ORBITALSEMIMAJORAXIS_J2000; static { URANUSSYSTEM_ORBITALSEMIMAJORAXIS_J2000 = 19.18916464; } // [au] 

    /**
     * Mean orbital eccentricity of Uranus, at the standard epoch J2000.0. The mean orbital eccentricity is associated with a mean orbit solution from a 250-year least-squares fit of JPL's DE405 ephemeris to a Keplerian orbit covering the interval of years 1800 AD - 2050 AD. The orbital element is referenced to the mean ecliptic and equinox of J2000 at the standard epoch J2000.0; linear rates and fit errors can be found in the reference document    
     * <p>
     * Source: E.M. Standish, 16 February 2006, 'Keplerian Elements for Approximate Positions of the Major Planets', http://ssd.jpl.nasa.gov/?planets\#elem<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean orbital eccentricity of Uranus, at the standard epoch J2000.0. The mean orbital eccentricity is associated with a mean orbit solution from a 250-year least-squares fit of JPL's DE405 ephemeris to a Keplerian orbit covering the interval of years 1800 AD - 2050 AD. The orbital element is referenced to the mean ecliptic and equinox of J2000 at the standard epoch J2000.0; linear rates and fit errors can be found in the reference document", 
     source = "E.M. Standish, 16 February 2006, 'Keplerian Elements for Approximate Positions of the Major Planets', http://ssd.jpl.nasa.gov/?planets\\#elem", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double URANUSSYSTEM_ORBITALECCENTRICITY_J2000; static { URANUSSYSTEM_ORBITALECCENTRICITY_J2000 = 0.04725744; } 

    /**
     * Mean orbital inclination of Uranus, at the standard epoch J2000.0. The mean orbital inclination is is associated with a mean orbit solution from a 250-year least-squares fit of JPL's DE405 ephemeris to a Keplerian orbit covering the interval of years 1800 AD - 2050 AD. The orbital element is referenced to the mean ecliptic and equinox of J2000 at the standard epoch J2000.0; linear rates and fit errors can be found in the reference document    
     * <p>
     * Source: E.M. Standish, 16 February 2006, 'Keplerian Elements for Approximate Positions of the Major Planets', http://ssd.jpl.nasa.gov/?planets\#elem<br/>
     * Status: CONF<br/>
     * Unit: deg<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean orbital inclination of Uranus, at the standard epoch J2000.0. The mean orbital inclination is is associated with a mean orbit solution from a 250-year least-squares fit of JPL's DE405 ephemeris to a Keplerian orbit covering the interval of years 1800 AD - 2050 AD. The orbital element is referenced to the mean ecliptic and equinox of J2000 at the standard epoch J2000.0; linear rates and fit errors can be found in the reference document", 
     source = "E.M. Standish, 16 February 2006, 'Keplerian Elements for Approximate Positions of the Major Planets', http://ssd.jpl.nasa.gov/?planets\\#elem", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "deg") 
    public static final double URANUSSYSTEM_ORBITALINCLINATION_J2000; static { URANUSSYSTEM_ORBITALINCLINATION_J2000 = 0.77263783; } // [deg] 

    /**
     * Radial-velocity amplitude of the Sun induced by the Uranus system for 'an edge-on observer' (i.e., an observer in the orbital plane of the Uranus system)    
     * <p>
     * Source: E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 1.4, Equation 1.18, page 9<br/>
     * Status: CONF<br/>
     * Unit: m s^-1<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Radial-velocity amplitude of the Sun induced by the Uranus system for 'an edge-on observer' (i.e., an observer in the orbital plane of the Uranus system)", 
     source = "E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 1.4, Equation 1.18, page 9", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m s^-1") 
    public static final double URANUSSYSTEM_RADIALVELOCITYSIGNATURE; static { URANUSSYSTEM_RADIALVELOCITYSIGNATURE = 0.3; } // [m s^-1] 

    /**
     * Sidereal orbital period    
     * <p>
     * Source: Values derived from the mean longitude rates in Table 5.8.1 in P.K. Seidelmann, 1992, 'Explanatory Supplement to the Astronomical Almanac', University Science Books, Mill Valley, Ca., ISBN 0-935702-68-7, page 316; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par<br/>
     * Status: CONF<br/>
     * Unit: yr<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Sidereal orbital period", 
     source = "Values derived from the mean longitude rates in Table 5.8.1 in P.K. Seidelmann, 1992, 'Explanatory Supplement to the Astronomical Almanac', University Science Books, Mill Valley, Ca., ISBN 0-935702-68-7, page 316; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "yr") 
    public static final double URANUSSYSTEM_ORBITALPERIOD; static { URANUSSYSTEM_ORBITALPERIOD = 84.016846; } // [yr] 

    /**
     * Astrometric signature of the Sun induced by the Uranus system for an observer located at a distance of 10 pc from the Sun    
     * <p>
     * Source: E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 1.7, Equation 1.22, page 11<br/>
     * Status: CONF<br/>
     * Unit: 10^-6 arcsec<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Astrometric signature of the Sun induced by the Uranus system for an observer located at a distance of 10 pc from the Sun", 
     source = "E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 1.7, Equation 1.22, page 11", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "10^-6 arcsec") 
    public static final double URANUSSYSTEM_ASTROMETRICSIGNATURE_10PARSEC; static { URANUSSYSTEM_ASTROMETRICSIGNATURE_10PARSEC = 84.; } // [10^-6 arcsec] 

    /**
     * Velocity of light in vacuum (defining constant)    
     * <p>
     * Source: P.J. Mohr, B.N. Taylor, D.B. Newell, 9 July 2015, 'The 2014 CODATA Recommended Values of the Fundamental Physical Constants', National Institute of Standards and Technology, Gaithersburg, MD 20899-8401; http://www.codata.org/ and http://physics.nist.gov/constants (Web Version 7.0). See also the IAU (2009) System of Astronomical Constants (IAU, August 2009, 'IAU 2009 Astronomical Constants', IAU 2009 Resolution B2 adopted at the XXVII-th General Assembly of the IAU. See also IAU, 10 August 2009, 'IAU WG on NSFA Current Best Estimates', http://maia.usno.navy.mil/NSFA/NSFA_cbe.html)<br/>
     * Status: CONF<br/>
     * Unit: m s^-1<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Velocity of light in vacuum (defining constant)", 
     source = "P.J. Mohr, B.N. Taylor, D.B. Newell, 9 July 2015, 'The 2014 CODATA Recommended Values of the Fundamental Physical Constants', National Institute of Standards and Technology, Gaithersburg, MD 20899-8401; http://www.codata.org/ and http://physics.nist.gov/constants (Web Version 7.0). See also the IAU (2009) System of Astronomical Constants (IAU, August 2009, 'IAU 2009 Astronomical Constants', IAU 2009 Resolution B2 adopted at the XXVII-th General Assembly of the IAU. See also IAU, 10 August 2009, 'IAU WG on NSFA Current Best Estimates', http://maia.usno.navy.mil/NSFA/NSFA_cbe.html)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "m s^-1") 
    public static final double VELOCITYOFLIGHT_CONSTANT_VACUUM; static { VELOCITYOFLIGHT_CONSTANT_VACUUM = 299792458.; } // [m s^-1] 

    /**
     * Chebyshev representation of the ephemerides of Venus, with origin at the barycentre of the solar system (BCRS), in the equatorial ICRF frame. The ephemeris covers the period starting on JD (JDBEGIP + JDBEGFP) and ending on JD (JDENDIP + JDENDFP) for the position and starting on JD (JDBEGIV + JDBEGFV) and ending on JD (JDENDIV + JDENDFV) for the velocity. A number of Chebyshev coefficients equal to ORDERSP is given for NSSP time intervals of SPANSP days to describe the position-vector components in units of m; the similar parameters ending with PP (Peculiar Position) are not used in the current release and are reserved for future usage. A number of Chebyshev coefficients equal to ORDERSV is given for NSSV time intervals of SPANSV days to describe the velocity-vector components in units of m s^-1; the similar parameters ending with PV (Peculiar Velocity) are not used in the current release and are reserved for future usage. The first three HDUs contain the coefficients for the three components of the position, while the last three HDUs contain the coefficients for the three components of the velocity    
     * <p>
     * Source: A. Fienga, J. Laskar, H. Manche, M. Gastineau, 19 April 2007, 'Solar system planetary ephemeris delivery: INPOP06', GAIA-CA-TN-IMC-AF-001, issue 1, revision 0<br/>
     * Status: DEPR<br/>
     * Basic : true<br/>
     * Scalar: false
     */
    @ParamMetaData (
    description = "Chebyshev representation of the ephemerides of Venus, with origin at the barycentre of the solar system (BCRS), in the equatorial ICRF frame. The ephemeris covers the period starting on JD (JDBEGIP + JDBEGFP) and ending on JD (JDENDIP + JDENDFP) for the position and starting on JD (JDBEGIV + JDBEGFV) and ending on JD (JDENDIV + JDENDFV) for the velocity. A number of Chebyshev coefficients equal to ORDERSP is given for NSSP time intervals of SPANSP days to describe the position-vector components in units of m; the similar parameters ending with PP (Peculiar Position) are not used in the current release and are reserved for future usage. A number of Chebyshev coefficients equal to ORDERSV is given for NSSV time intervals of SPANSV days to describe the velocity-vector components in units of m s^-1; the similar parameters ending with PV (Peculiar Velocity) are not used in the current release and are reserved for future usage. The first three HDUs contain the coefficients for the three components of the position, while the last three HDUs contain the coefficients for the three components of the velocity", 
     source = "A. Fienga, J. Laskar, H. Manche, M. Gastineau, 19 April 2007, 'Solar system planetary ephemeris delivery: INPOP06', GAIA-CA-TN-IMC-AF-001, issue 1, revision 0", 
     status = "DEPR", 
     basic = true, 
     scalar = false, 
     unit = "") 
    public static final String VENUS_EPHEMERIS; static { VENUS_EPHEMERIS = "Nature/Venus_Ephemeris_004.fits"; } 

    /**
     * IAU-recommended value for the right ascension \alpha_0 of the north pole of rotation of Venus. The pair (\alpha_0, \delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \alpha_0 = 273.85 deg and \delta_0 = 66.99 degrees    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)<br/>
     * Status: CONF<br/>
     * Unit: deg<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "IAU-recommended value for the right ascension \\alpha_0 of the north pole of rotation of Venus. The pair (\\alpha_0, \\delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \\alpha_0 = 273.85 deg and \\delta_0 = 66.99 degrees", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "deg") 
    public static final double VENUS_NORTHROTATIONALPOLE_RIGHTASCENSION; static { VENUS_NORTHROTATIONALPOLE_RIGHTASCENSION = 272.76; } // [deg] 

    /**
     * IAU-recommended value for the rate of change (in degrees per Julian day, calculated from the standard epoch) of the right ascension \alpha_0 of the north pole of rotation of Venus. The pair (\alpha_0, \delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \alpha_0 = 273.85 deg and \delta_0 = 66.99 degrees    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)<br/>
     * Status: CONF<br/>
     * Unit: deg day^-1<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "IAU-recommended value for the rate of change (in degrees per Julian day, calculated from the standard epoch) of the right ascension \\alpha_0 of the north pole of rotation of Venus. The pair (\\alpha_0, \\delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \\alpha_0 = 273.85 deg and \\delta_0 = 66.99 degrees", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "deg day^-1") 
    public static final double VENUS_NORTHROTATIONALPOLE_RIGHTASCENSIONRATEOFCHANGE; static { VENUS_NORTHROTATIONALPOLE_RIGHTASCENSIONRATEOFCHANGE = 0.; } // [deg day^-1] 

    /**
     * IAU-recommended value for the declination \delta_0 of the north pole of rotation of Venus. The pair (\alpha_0, \delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \alpha_0 = 273.85 deg and \delta_0 = 66.99 degrees    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)<br/>
     * Status: CONF<br/>
     * Unit: deg<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "IAU-recommended value for the declination \\delta_0 of the north pole of rotation of Venus. The pair (\\alpha_0, \\delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \\alpha_0 = 273.85 deg and \\delta_0 = 66.99 degrees", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "deg") 
    public static final double VENUS_NORTHROTATIONALPOLE_DECLINATION; static { VENUS_NORTHROTATIONALPOLE_DECLINATION = 67.16; } // [deg] 

    /**
     * IAU-recommended value for the rate of change (in degrees per Julian day, calculated from the standard epoch) of the declination \delta_0 of the north pole of rotation of Venus. The pair (\alpha_0, \delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \alpha_0 = 273.85 deg and \delta_0 = 66.99 degrees    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)<br/>
     * Status: CONF<br/>
     * Unit: deg day^-1<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "IAU-recommended value for the rate of change (in degrees per Julian day, calculated from the standard epoch) of the declination \\delta_0 of the north pole of rotation of Venus. The pair (\\alpha_0, \\delta_0) denotes standard equatorial coordinates with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB). The north pole is that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \\alpha_0 = 273.85 deg and \\delta_0 = 66.99 degrees", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "deg day^-1") 
    public static final double VENUS_NORTHROTATIONALPOLE_DECLINATIONRATEOFCHANGE; static { VENUS_NORTHROTATIONALPOLE_DECLINATIONRATEOFCHANGE = 0.; } // [deg day^-1] 

    /**
     * IAU-recommended value for the ephemeris position of the prime meridian of Venus. The 0-deg meridian is defined by the central peak in the crater Ariadne. The location of the prime meridian is specified by the angle that is measured along the planet's equator in an easterly direction with respect to the planet's north pole from the node Q (located at right ascension 90 deg + \alpha_0, where \alpha_0 denotes the right ascension of the north pole of rotation) of the planet's equator on the standard equator to the point B where the prime meridian crosses the planet's equator. The right ascension of the point Q is 90 deg + \alpha_0 and the inclination of the planet's equator to the standard equator is 90 deg - \delta_0, where \delta_0 denotes the declination of the north pole of rotation. (The pair (\alpha_0, \delta_0) denotes the standard equatorial coordinates, with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB), of the north pole of rotation, which itself is defined as that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \alpha_0 = 273.85 deg and \delta_0 = 66.99 degrees.) Because the prime meridian is assumed to rotate uniformly with the planet, W accordingly varies linearly with time. In addition, \alpha_0, \delta_0, and W may vary with time due to a precession of the axis of rotation of the planet. If W increases with time, the planet has a direct (or prograde) rotation; if W decreases with time, the rotation is said to be retrograde    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)<br/>
     * Status: CONF<br/>
     * Unit: deg<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "IAU-recommended value for the ephemeris position of the prime meridian of Venus. The 0-deg meridian is defined by the central peak in the crater Ariadne. The location of the prime meridian is specified by the angle that is measured along the planet's equator in an easterly direction with respect to the planet's north pole from the node Q (located at right ascension 90 deg + \\alpha_0, where \\alpha_0 denotes the right ascension of the north pole of rotation) of the planet's equator on the standard equator to the point B where the prime meridian crosses the planet's equator. The right ascension of the point Q is 90 deg + \\alpha_0 and the inclination of the planet's equator to the standard equator is 90 deg - \\delta_0, where \\delta_0 denotes the declination of the north pole of rotation. (The pair (\\alpha_0, \\delta_0) denotes the standard equatorial coordinates, with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB), of the north pole of rotation, which itself is defined as that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \\alpha_0 = 273.85 deg and \\delta_0 = 66.99 degrees.) Because the prime meridian is assumed to rotate uniformly with the planet, W accordingly varies linearly with time. In addition, \\alpha_0, \\delta_0, and W may vary with time due to a precession of the axis of rotation of the planet. If W increases with time, the planet has a direct (or prograde) rotation; if W decreases with time, the rotation is said to be retrograde", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "deg") 
    public static final double VENUS_PRIMEMERIDIAN_EPHEMERISPOSITION; static { VENUS_PRIMEMERIDIAN_EPHEMERISPOSITION = 160.20; } // [deg] 

    /**
     * IAU-recommended value for the rate of change (in degrees per Julian day, calculated from the standard epoch of 1.5 January 2000 = JD2451545.0 TDB) of the ephemeris position of the prime meridian of Venus. The 0-deg meridian is defined by the central peak in the crater Ariadne. The location of the prime meridian is specified by the angle that is measured along the planet's equator in an easterly direction with respect to the planet's north pole from the node Q (located at right ascension 90 deg + \alpha_0, where \alpha_0 denotes the right ascension of the north pole of rotation) of the planet's equator on the standard equator to the point B where the prime meridian crosses the planet's equator. The right ascension of the point Q is 90 deg + \alpha_0 and the inclination of the planet's equator to the standard equator is 90 deg - \delta_0, where \delta_0 denotes the declination of the north pole of rotation. (The pair (\alpha_0, \delta_0) denotes the standard equatorial coordinates, with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB), of the north pole of rotation, which itself is defined as that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \alpha_0 = 273.85 deg and \delta_0 = 66.99 degrees.) Because the prime meridian is assumed to rotate uniformly with the planet, W accordingly varies linearly with time. In addition, \alpha_0, \delta_0, and W may vary with time due to a precession of the axis of rotation of the planet. If W increases with time, the planet has a direct (or prograde) rotation; if W decreases with time, the rotation is said to be retrograde    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)<br/>
     * Status: CONF<br/>
     * Unit: deg day^-1<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "IAU-recommended value for the rate of change (in degrees per Julian day, calculated from the standard epoch of 1.5 January 2000 = JD2451545.0 TDB) of the ephemeris position of the prime meridian of Venus. The 0-deg meridian is defined by the central peak in the crater Ariadne. The location of the prime meridian is specified by the angle that is measured along the planet's equator in an easterly direction with respect to the planet's north pole from the node Q (located at right ascension 90 deg + \\alpha_0, where \\alpha_0 denotes the right ascension of the north pole of rotation) of the planet's equator on the standard equator to the point B where the prime meridian crosses the planet's equator. The right ascension of the point Q is 90 deg + \\alpha_0 and the inclination of the planet's equator to the standard equator is 90 deg - \\delta_0, where \\delta_0 denotes the declination of the north pole of rotation. (The pair (\\alpha_0, \\delta_0) denotes the standard equatorial coordinates, with equinox J2000 at epoch J2000 (the standard epoch is 1.5 January 2000 = JD2451545.0 TDB), of the north pole of rotation, which itself is defined as that pole of rotation that lies on the north side of the invariable plane of the solar system; the approximate coordinates of the north pole of the invariable plane are \\alpha_0 = 273.85 deg and \\delta_0 = 66.99 degrees.) Because the prime meridian is assumed to rotate uniformly with the planet, W accordingly varies linearly with time. In addition, \\alpha_0, \\delta_0, and W may vary with time due to a precession of the axis of rotation of the planet. If W increases with time, the planet has a direct (or prograde) rotation; if W decreases with time, the rotation is said to be retrograde", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "deg day^-1") 
    public static final double VENUS_PRIMEMERIDIAN_EPHEMERISPOSITIONRATEOFCHANGE; static { VENUS_PRIMEMERIDIAN_EPHEMERISPOSITIONRATEOFCHANGE = -1.4813688; } // [deg day^-1] 

    /**
     * Mass of Venus (do not use for high-precision (orbit) calculations)    
     * <p>
     * Source: A.S. Konopliv, et al., 1999, 'Venus gravity: 180-th degree and order model', Icarus, 139, 3-18; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par<br/>
     * Status: CONF<br/>
     * Unit: kg<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mass of Venus (do not use for high-precision (orbit) calculations)", 
     source = "A.S. Konopliv, et al., 1999, 'Venus gravity: 180-th degree and order model', Icarus, 139, 3-18; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "kg") 
    public static final double VENUS_MASS; static { VENUS_MASS = 4.867320e+24; } // [kg] 

    /**
     * Mean volumetric radius of Venus    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A); see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par<br/>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean volumetric radius of Venus", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A); see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "m") 
    public static final double VENUS_VOLUMETRICRADIUS; static { VENUS_VOLUMETRICRADIUS = 6.05180e+6; } // [m] 

    /**
     * Equatorial radius of Venus    
     * <p>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Equatorial radius of Venus", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m") 
    public static final double VENUS_EQUATORIALRADIUS; static { VENUS_EQUATORIALRADIUS = 6.05180e+6; } // [m] 

    /**
     * Polar radius of Venus    
     * <p>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Polar radius of Venus", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m") 
    public static final double VENUS_POLARRADIUS; static { VENUS_POLARRADIUS = 6.05180e+6; } // [m] 

    /**
     * V(1,0) magnitude of Venus (i.e., the visual magnitude of the planet reduced to a distance of 1 au from both the Sun and Earth and phase angle zero). This parameter is also refered to as absolute magnitude in planetary sciences    
     * <p>
     * Source: J.L. Hilton, 2005, 'Improving the Visual Magnitudes of the Planets in The Astronomical Almanac. I. Mercury and Venus', AJ, 129, 2902-2906; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par<br/>
     * Status: CONF<br/>
     * Unit: mag<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "V(1,0) magnitude of Venus (i.e., the visual magnitude of the planet reduced to a distance of 1 au from both the Sun and Earth and phase angle zero). This parameter is also refered to as absolute magnitude in planetary sciences", 
     source = "J.L. Hilton, 2005, 'Improving the Visual Magnitudes of the Planets in The Astronomical Almanac. I. Mercury and Venus', AJ, 129, 2902-2906; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "mag") 
    public static final double VENUS_VONEZEROMAGNITUDE; static { VENUS_VONEZEROMAGNITUDE = -4.47; } // [mag] 

    /**
     * Geometric albedo of Venus (i.e., the ratio of the body's brightness at zero phase angle to the brightness of a perfectly diffusing disk with the same position and apparent size as the body)    
     * <p>
     * Source: P.K. Seidelmann, 1992, 'Explanatory Supplement to the Astronomical Almanac', University Science Books, Mill Valley, Ca., ISBN 0-935702-68-7, Table 15.8 on page 706; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Geometric albedo of Venus (i.e., the ratio of the body's brightness at zero phase angle to the brightness of a perfectly diffusing disk with the same position and apparent size as the body)", 
     source = "P.K. Seidelmann, 1992, 'Explanatory Supplement to the Astronomical Almanac', University Science Books, Mill Valley, Ca., ISBN 0-935702-68-7, Table 15.8 on page 706; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double VENUS_GEOMETRICALBEDO; static { VENUS_GEOMETRICALBEDO = 0.65; } 

    /**
     * Mean mass density of Venus    
     * <p>
     * Status: CONF<br/>
     * Unit: g cm^-3<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean mass density of Venus", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "g cm^-3") 
    public static final double VENUS_MASSDENSITY_MEAN; static { VENUS_MASSDENSITY_MEAN = 5.243; } // [g cm^-3] 

    /**
     * Radius of the smallest hypothetical sphere around Venus which would encompass the body (this is a low-accuracy parameter used in the relativistic model)    
     * <p>
     * Status: CONF<br/>
     * Unit: m<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Radius of the smallest hypothetical sphere around Venus which would encompass the body (this is a low-accuracy parameter used in the relativistic model)", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m") 
    public static final double VENUS_ENCOMPASSINGSPHERERADIUS; static { VENUS_ENCOMPASSINGSPHERERADIUS = 6.051800e+6; } // [m] 

    /**
     * Dynamical form-factor of Venus (oblateness or Stokes' second-degree zonal harmonic of the potential)    
     * <p>
     * Source: P.K. Seidelmann, 1992, 'Explanatory Supplement to the Astronomical Almanac', University Science Books, Mill Valley, Ca., ISBN 0-935702-68-7, Table 15.8<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Dynamical form-factor of Venus (oblateness or Stokes' second-degree zonal harmonic of the potential)", 
     source = "P.K. Seidelmann, 1992, 'Explanatory Supplement to the Astronomical Almanac', University Science Books, Mill Valley, Ca., ISBN 0-935702-68-7, Table 15.8", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double VENUS_JSUB2; static { VENUS_JSUB2 = 2.70e-5; } 

    /**
     * Geometrical flattening factor f of Venus (f = (a-b)/a)    
     * <p>
     * Source: B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A); see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Geometrical flattening factor f of Venus (f = (a-b)/a)", 
     source = "B.A. Archinal, et al., 1 February 2011, 'Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009', Celestial Mechanics and Dynamical Astronomy, 109, 101-135 (2011CeMDA.109..101A); see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double VENUS_FLATTENING; static { VENUS_FLATTENING = 0.; } 

    /**
     * Post-Newtonian deflection angle of a limb-grazing light ray due to the spherically symmetric part of the gravitational field of Venus    
     * <p>
     * Source: S.A. Klioner, 2003, 'A Practical Relativistic Model for Microarcsecond Astrometry in Space', AJ, 125, 1580, Equation 64 with cot(x) = cos(x) / sin(x) approximated by x^-1; see also J.H.J. de Bruijne, 19 February 2002, 'Gravitational light deflection', GAIA-JdB-001, issue 1, revision 0<br/>
     * Status: CONF<br/>
     * Unit: 10^-6 arcsec<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Post-Newtonian deflection angle of a limb-grazing light ray due to the spherically symmetric part of the gravitational field of Venus", 
     source = "S.A. Klioner, 2003, 'A Practical Relativistic Model for Microarcsecond Astrometry in Space', AJ, 125, 1580, Equation 64 with cot(x) = cos(x) / sin(x) approximated by x^-1; see also J.H.J. de Bruijne, 19 February 2002, 'Gravitational light deflection', GAIA-JdB-001, issue 1, revision 0", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "10^-6 arcsec") 
    public static final double VENUS_LIGHTDEFLECTION_LIMB; static { VENUS_LIGHTDEFLECTION_LIMB = 493.; } // [10^-6 arcsec] 

    /**
     * Geometric transit probability (Venus transiting the Sun) for an observer external to the solar system    
     * <p>
     * Source: E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 2.1, Equation 2.2, page 14<br/>
     * Status: CONF<br/>
     * Unit: %<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Geometric transit probability (Venus transiting the Sun) for an observer external to the solar system", 
     source = "E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 2.1, Equation 2.2, page 14", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "%") 
    public static final double VENUS_TRANSITPROBABILITY; static { VENUS_TRANSITPROBABILITY = 0.648; } // [%] 

    /**
     * Maximum reduction of the solar flux for an observer external to the solar system during a transit of Venus    
     * <p>
     * Source: E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 2.2, Equation 2.4, page 14<br/>
     * Status: CONF<br/>
     * Unit: %<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Maximum reduction of the solar flux for an observer external to the solar system during a transit of Venus", 
     source = "E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 2.2, Equation 2.4, page 14", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "%") 
    public static final double VENUS_FLUXREDUCTION_MAXIMUM; static { VENUS_FLUXREDUCTION_MAXIMUM = 0.008; } // [%] 

    /**
     * Maximum transit time of Venus (transiting the Sun) for an observer external to the solar system    
     * <p>
     * Source: E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 2.3, Equation 2.5, page 15<br/>
     * Status: CONF<br/>
     * Unit: day<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Maximum transit time of Venus (transiting the Sun) for an observer external to the solar system", 
     source = "E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 2.3, Equation 2.5, page 15", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "day") 
    public static final double VENUS_TRANSITTIME_MAXIMUM; static { VENUS_TRANSITTIME_MAXIMUM = 0.46; } // [day] 

    /**
     * Venus(-system) mass (IAU 2009 CBE value)    
     * <p>
     * Status: CONF<br/>
     * Unit: kg<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Venus(-system) mass (IAU 2009 CBE value)", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "kg") 
    public static final double VENUSSYSTEM_MASS; static { VENUSSYSTEM_MASS = 4.86747e+24; } // [kg] 

    /**
     * Mean orbital semi-major axis of Venus, at the standard epoch J2000.0. The mean orbital semi-major axis is associated with a mean orbit solution from a 250-year least-squares fit of JPL's DE405 ephemeris to a Keplerian orbit covering the interval of years 1800 AD - 2050 AD. The orbital element is referenced to the mean ecliptic and equinox of J2000 at the standard epoch J2000.0; linear rates and fit errors can be found in the reference document    
     * <p>
     * Source: E.M. Standish, 16 February 2006, 'Keplerian Elements for Approximate Positions of the Major Planets', http://ssd.jpl.nasa.gov/?planets\#elem<br/>
     * Status: CONF<br/>
     * Unit: au<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean orbital semi-major axis of Venus, at the standard epoch J2000.0. The mean orbital semi-major axis is associated with a mean orbit solution from a 250-year least-squares fit of JPL's DE405 ephemeris to a Keplerian orbit covering the interval of years 1800 AD - 2050 AD. The orbital element is referenced to the mean ecliptic and equinox of J2000 at the standard epoch J2000.0; linear rates and fit errors can be found in the reference document", 
     source = "E.M. Standish, 16 February 2006, 'Keplerian Elements for Approximate Positions of the Major Planets', http://ssd.jpl.nasa.gov/?planets\\#elem", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "au") 
    public static final double VENUSSYSTEM_ORBITALSEMIMAJORAXIS_J2000; static { VENUSSYSTEM_ORBITALSEMIMAJORAXIS_J2000 = 0.72333566; } // [au] 

    /**
     * Mean orbital eccentricity of Venus, at the standard epoch J2000.0. The mean orbital eccentricity is associated with a mean orbit solution from a 250-year least-squares fit of JPL's DE405 ephemeris to a Keplerian orbit covering the interval of years 1800 AD - 2050 AD. The orbital element is referenced to the mean ecliptic and equinox of J2000 at the standard epoch J2000.0; linear rates and fit errors can be found in the reference document    
     * <p>
     * Source: E.M. Standish, 16 February 2006, 'Keplerian Elements for Approximate Positions of the Major Planets', http://ssd.jpl.nasa.gov/?planets\#elem<br/>
     * Status: CONF<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean orbital eccentricity of Venus, at the standard epoch J2000.0. The mean orbital eccentricity is associated with a mean orbit solution from a 250-year least-squares fit of JPL's DE405 ephemeris to a Keplerian orbit covering the interval of years 1800 AD - 2050 AD. The orbital element is referenced to the mean ecliptic and equinox of J2000 at the standard epoch J2000.0; linear rates and fit errors can be found in the reference document", 
     source = "E.M. Standish, 16 February 2006, 'Keplerian Elements for Approximate Positions of the Major Planets', http://ssd.jpl.nasa.gov/?planets\\#elem", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "") 
    public static final double VENUSSYSTEM_ORBITALECCENTRICITY_J2000; static { VENUSSYSTEM_ORBITALECCENTRICITY_J2000 = 0.00677672; } 

    /**
     * Mean orbital inclination of Venus, at the standard epoch J2000.0. The mean orbital inclination is is associated with a mean orbit solution from a 250-year least-squares fit of JPL's DE405 ephemeris to a Keplerian orbit covering the interval of years 1800 AD - 2050 AD. The orbital element is referenced to the mean ecliptic and equinox of J2000 at the standard epoch J2000.0; linear rates and fit errors can be found in the reference document    
     * <p>
     * Source: E.M. Standish, 16 February 2006, 'Keplerian Elements for Approximate Positions of the Major Planets', http://ssd.jpl.nasa.gov/?planets\#elem<br/>
     * Status: CONF<br/>
     * Unit: deg<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Mean orbital inclination of Venus, at the standard epoch J2000.0. The mean orbital inclination is is associated with a mean orbit solution from a 250-year least-squares fit of JPL's DE405 ephemeris to a Keplerian orbit covering the interval of years 1800 AD - 2050 AD. The orbital element is referenced to the mean ecliptic and equinox of J2000 at the standard epoch J2000.0; linear rates and fit errors can be found in the reference document", 
     source = "E.M. Standish, 16 February 2006, 'Keplerian Elements for Approximate Positions of the Major Planets', http://ssd.jpl.nasa.gov/?planets\\#elem", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "deg") 
    public static final double VENUSSYSTEM_ORBITALINCLINATION_J2000; static { VENUSSYSTEM_ORBITALINCLINATION_J2000 = 3.39467605; } // [deg] 

    /**
     * Sidereal orbital period    
     * <p>
     * Source: Values derived from the mean longitude rates in Table 5.8.1 in P.K. Seidelmann, 1992, 'Explanatory Supplement to the Astronomical Almanac', University Science Books, Mill Valley, Ca., ISBN 0-935702-68-7, page 316; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par<br/>
     * Status: CONF<br/>
     * Unit: yr<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Sidereal orbital period", 
     source = "Values derived from the mean longitude rates in Table 5.8.1 in P.K. Seidelmann, 1992, 'Explanatory Supplement to the Astronomical Almanac', University Science Books, Mill Valley, Ca., ISBN 0-935702-68-7, page 316; see also D.K. Yeomans (NASA/JPL), 5 November 2008, 'Planets and Pluto: Physical Characteristics', http://ssd.jpl.nasa.gov/?planet_phys_par", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "yr") 
    public static final double VENUSSYSTEM_ORBITALPERIOD; static { VENUSSYSTEM_ORBITALPERIOD = 0.61519726; } // [yr] 

    /**
     * Radial-velocity amplitude of the Sun induced by Venus for 'an edge-on observer' (i.e., an observer in the orbital plane of the Venus)    
     * <p>
     * Source: E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 1.4, Equation 1.18, page 9<br/>
     * Status: CONF<br/>
     * Unit: m s^-1<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Radial-velocity amplitude of the Sun induced by Venus for 'an edge-on observer' (i.e., an observer in the orbital plane of the Venus)", 
     source = "E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 1.4, Equation 1.18, page 9", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "m s^-1") 
    public static final double VENUSSYSTEM_RADIALVELOCITYSIGNATURE; static { VENUSSYSTEM_RADIALVELOCITYSIGNATURE = 0.086; } // [m s^-1] 

    /**
     * Astrometric signature of the Sun induced by Venus for an observer located at a distance of 10 pc from the Sun    
     * <p>
     * Source: E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 1.7, Equation 1.22, page 11<br/>
     * Status: CONF<br/>
     * Unit: 10^-6 arcsec<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Astrometric signature of the Sun induced by Venus for an observer located at a distance of 10 pc from the Sun", 
     source = "E.g., A. Johansen, 26 March 2002, 'Detection of planetary transits with the Gaia satellite', GAIA-CUO-106, issue 1, revision 3, Section 1.7, Equation 1.22, page 11", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "10^-6 arcsec") 
    public static final double VENUSSYSTEM_ASTROMETRICSIGNATURE_10PARSEC; static { VENUSSYSTEM_ASTROMETRICSIGNATURE_10PARSEC = 0.177; } // [10^-6 arcsec] 

    /**
     * Wien's displacement-law constant (for \lambda_max)    
     * <p>
     * Source: P.J. Mohr, B.N. Taylor, D.B. Newell, 9 July 2015, 'The 2014 CODATA Recommended Values of the Fundamental Physical Constants', National Institute of Standards and Technology, Gaithersburg, MD 20899-8401; http://www.codata.org/ and http://physics.nist.gov/constants (Web Version 7.0)<br/>
     * Status: CONF<br/>
     * Unit: m K<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Wien's displacement-law constant (for \\lambda_max)", 
     source = "P.J. Mohr, B.N. Taylor, D.B. Newell, 9 July 2015, 'The 2014 CODATA Recommended Values of the Fundamental Physical Constants', National Institute of Standards and Technology, Gaithersburg, MD 20899-8401; http://www.codata.org/ and http://physics.nist.gov/constants (Web Version 7.0)", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "m K") 
    public static final double WIEN_CONSTANT; static { WIEN_CONSTANT = 2.89777290e-3; } // [m K] 

    /**
     * Zero degrees Celsius (ice point) expressed in degrees Kelvin    
     * <p>
     * Status: CONF<br/>
     * Unit: K<br/>
     * Basic : false<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Zero degrees Celsius (ice point) expressed in degrees Kelvin", 
     source = "", 
     status = "CONF", 
     basic = false, 
     scalar = true, 
     unit = "K") 
    public static final double ZEROCELSIUS_KELVIN; static { ZEROCELSIUS_KELVIN = 273.15; } // [K] 

    /**
     * Zero degrees Kelvin expressed in degrees Celsius. The triple point of water is the only realizable defining fixed point common to the Kelvin Thermodynamic Temperature Scale (KTTS) and the International Temperature Scale of 1990 (ITS-90); the assigned value of the triple point of water on these scales is 273.16 K (0.01 C)    
     * <p>
     * Source: The International Temperature Scale of 1990 (ITS-90); http://www.its-90.com/its-90.html<br/>
     * Status: CONF<br/>
     * Unit: deg C<br/>
     * Basic : true<br/>
     * Scalar: true
     */
    @ParamMetaData (
    description = "Zero degrees Kelvin expressed in degrees Celsius. The triple point of water is the only realizable defining fixed point common to the Kelvin Thermodynamic Temperature Scale (KTTS) and the International Temperature Scale of 1990 (ITS-90); the assigned value of the triple point of water on these scales is 273.16 K (0.01 C)", 
     source = "The International Temperature Scale of 1990 (ITS-90); http://www.its-90.com/its-90.html", 
     status = "CONF", 
     basic = true, 
     scalar = true, 
     unit = "deg C") 
    public static final double ZEROKELVIN_CELSIUS; static { ZEROKELVIN_CELSIUS = -273.15; } // [deg C] 

    public static class DE405 {
        /**
         * Mean mass density of C-class asteroids (DE405 value). In JPL's DE ephemerides, masses for the 300 most massive asteroids (except Ceres, Pallas, and Vesta) are derived using the relation GM = 6.27E-22 Radius^3 \rho, where Radius is the known asteroid radius in km and \rho is the mean mass density in g cm^-3 (GM in this relation is in 'solar-system units', i.e., Sun_GM = Gauss_Constant * Gauss_Constant [au^3/2 day^-1 M_Sun^-1/2]; note that the reference erroneously lists a prefactor 6.27E20; typo confirmed by E.M. Standish, priv. comm., 18 September 2003). The mean density \rho is assumed to be constant within each of the three taxonomic asteroid classes C, S, and M        
         * <p>
         * Source: E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048, Section IV<br/>
         * Status: CONF<br/>
         * Unit: g cm^-3<br/>
         * Basic : true<br/>
         * Scalar: true
         */
        @ParamMetaData (
        description = "Mean mass density of C-class asteroids (DE405 value). In JPL's DE ephemerides, masses for the 300 most massive asteroids (except Ceres, Pallas, and Vesta) are derived using the relation GM = 6.27E-22 Radius^3 \\rho, where Radius is the known asteroid radius in km and \\rho is the mean mass density in g cm^-3 (GM in this relation is in 'solar-system units', i.e., Sun_GM = Gauss_Constant * Gauss_Constant [au^3/2 day^-1 M_Sun^-1/2]; note that the reference erroneously lists a prefactor 6.27E20; typo confirmed by E.M. Standish, priv. comm., 18 September 2003). The mean density \\rho is assumed to be constant within each of the three taxonomic asteroid classes C, S, and M", 
         source = "E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048, Section IV", 
         status = "CONF", 
         basic = true, 
         scalar = true, 
         unit = "g cm^-3") 
        public static final double ASTEROID_MASSDENSITY_MEANCLASSC; static { ASTEROID_MASSDENSITY_MEANCLASSC = 1.8; } // [g cm^-3] 

        /**
         * Mean mass density of S-class asteroids (DE405 value). In JPL's DE ephemerides, masses for the 300 most massive asteroids (except Ceres, Pallas, and Vesta) are derived using the relation GM = 6.27E-22 Radius^3 \rho, where Radius is the known asteroid radius in km and \rho is the mean mass density in g cm^-3 (GM in this relation is in 'solar-system units', i.e., Sun_GM = Gauss_Constant * Gauss_Constant [au^3/2 day^-1 M_Sun^-1/2]; note that the reference erroneously lists a prefactor 6.27E20; typo confirmed by E.M. Standish, priv. comm., 18 September 2003). The mean density \rho is assumed to be constant within each of the three taxonomic asteroid classes C, S, and M        
         * <p>
         * Source: E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048, Section IV<br/>
         * Status: CONF<br/>
         * Unit: g cm^-3<br/>
         * Basic : true<br/>
         * Scalar: true
         */
        @ParamMetaData (
        description = "Mean mass density of S-class asteroids (DE405 value). In JPL's DE ephemerides, masses for the 300 most massive asteroids (except Ceres, Pallas, and Vesta) are derived using the relation GM = 6.27E-22 Radius^3 \\rho, where Radius is the known asteroid radius in km and \\rho is the mean mass density in g cm^-3 (GM in this relation is in 'solar-system units', i.e., Sun_GM = Gauss_Constant * Gauss_Constant [au^3/2 day^-1 M_Sun^-1/2]; note that the reference erroneously lists a prefactor 6.27E20; typo confirmed by E.M. Standish, priv. comm., 18 September 2003). The mean density \\rho is assumed to be constant within each of the three taxonomic asteroid classes C, S, and M", 
         source = "E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048, Section IV", 
         status = "CONF", 
         basic = true, 
         scalar = true, 
         unit = "g cm^-3") 
        public static final double ASTEROID_MASSDENSITY_MEANCLASSS; static { ASTEROID_MASSDENSITY_MEANCLASSS = 2.4; } // [g cm^-3] 

        /**
         * Mean mass density of M-class asteroids (DE405 value). In JPL's DE ephemerides, masses for the 300 most massive asteroids (except Ceres, Pallas, and Vesta) are derived using the relation GM = 6.27E-22 Radius^3 \rho, where Radius is the known asteroid radius in km and \rho is the mean mass density in g cm^-3 (GM in this relation is in 'solar-system units', i.e., Sun_GM = Gauss_Constant * Gauss_Constant [au^3/2 day^-1 M_Sun^-1/2]; note that the reference erroneously lists a prefactor 6.27E20; typo confirmed by E.M. Standish, priv. comm., 18 September 2003). The mean density \rho is assumed to be constant within each of the three taxonomic asteroid classes C, S, and M        
         * <p>
         * Source: E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048, Section IV<br/>
         * Status: CONF<br/>
         * Unit: g cm^-3<br/>
         * Basic : true<br/>
         * Scalar: true
         */
        @ParamMetaData (
        description = "Mean mass density of M-class asteroids (DE405 value). In JPL's DE ephemerides, masses for the 300 most massive asteroids (except Ceres, Pallas, and Vesta) are derived using the relation GM = 6.27E-22 Radius^3 \\rho, where Radius is the known asteroid radius in km and \\rho is the mean mass density in g cm^-3 (GM in this relation is in 'solar-system units', i.e., Sun_GM = Gauss_Constant * Gauss_Constant [au^3/2 day^-1 M_Sun^-1/2]; note that the reference erroneously lists a prefactor 6.27E20; typo confirmed by E.M. Standish, priv. comm., 18 September 2003). The mean density \\rho is assumed to be constant within each of the three taxonomic asteroid classes C, S, and M", 
         source = "E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048, Section IV", 
         status = "CONF", 
         basic = true, 
         scalar = true, 
         unit = "g cm^-3") 
        public static final double ASTEROID_MASSDENSITY_MEANCLASSM; static { ASTEROID_MASSDENSITY_MEANCLASSM = 5.0; } // [g cm^-3] 

        /**
         * Ratio of 1 Ceres to solar mass (DE405 value)        
         * <p>
         * Source: E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048<br/>
         * Status: CONF<br/>
         * Basic : true<br/>
         * Scalar: true
         */
        @ParamMetaData (
        description = "Ratio of 1 Ceres to solar mass (DE405 value)", 
         source = "E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048", 
         status = "CONF", 
         basic = true, 
         scalar = true, 
         unit = "") 
        public static final double ASTEROID1CERESMASS_SOLARMASS; static { ASTEROID1CERESMASS_SOLARMASS = 4.70e-10; } 

        /**
         * Ratio of 2 Pallas to solar mass (DE405 value)        
         * <p>
         * Source: E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048<br/>
         * Status: CONF<br/>
         * Basic : true<br/>
         * Scalar: true
         */
        @ParamMetaData (
        description = "Ratio of 2 Pallas to solar mass (DE405 value)", 
         source = "E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048", 
         status = "CONF", 
         basic = true, 
         scalar = true, 
         unit = "") 
        public static final double ASTEROID2PALLASMASS_SOLARMASS; static { ASTEROID2PALLASMASS_SOLARMASS = 1.00e-10; } 

        /**
         * Ratio of 4 Vesta to solar mass (DE405 value)        
         * <p>
         * Source: E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048<br/>
         * Status: CONF<br/>
         * Basic : true<br/>
         * Scalar: true
         */
        @ParamMetaData (
        description = "Ratio of 4 Vesta to solar mass (DE405 value)", 
         source = "E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048", 
         status = "CONF", 
         basic = true, 
         scalar = true, 
         unit = "") 
        public static final double ASTEROID4VESTAMASS_SOLARMASS; static { ASTEROID4VESTAMASS_SOLARMASS = 1.30e-10; } 

        /**
         * Astronomical unit (au) light time (TDB-compatible value; DE405 value). Do not use this parameter but use the TCB-compatible value from parameter :Nature:DE405:AstronomicalUnit_Second instead        
         * <p>
         * Source: E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048<br/>
         * Status: CONF<br/>
         * Unit: s (TDB)<br/>
         * Basic : true<br/>
         * Scalar: true
         */
        @ParamMetaData (
        description = "Astronomical unit (au) light time (TDB-compatible value; DE405 value). Do not use this parameter but use the TCB-compatible value from parameter :Nature:DE405:AstronomicalUnit_Second instead", 
         source = "E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048", 
         status = "CONF", 
         basic = true, 
         scalar = true, 
         unit = "s (TDB)") 
        public static final double ASTRONOMICALUNIT_TDBSECOND; static { ASTRONOMICALUNIT_TDBSECOND = 4.9900478380610002e+2; } // [s (TDB)] 

        /**
         * Astronomical unit (au) length (TDB-compatible value; DE405 value). Do not use this parameter but use the TCB-compatible value from parameter :Nature:DE405:AstronomicalUnit_Meter instead        
         * <p>
         * Source: E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048<br/>
         * Status: CONF<br/>
         * Unit: m (TDB)<br/>
         * Basic : false<br/>
         * Scalar: true
         */
        @ParamMetaData (
        description = "Astronomical unit (au) length (TDB-compatible value; DE405 value). Do not use this parameter but use the TCB-compatible value from parameter :Nature:DE405:AstronomicalUnit_Meter instead", 
         source = "E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048", 
         status = "CONF", 
         basic = false, 
         scalar = true, 
         unit = "m (TDB)") 
        public static final double ASTRONOMICALUNIT_TDBMETER; static { ASTRONOMICALUNIT_TDBMETER = 1.4959787301053391e+11; } // [m (TDB)] 

        /**
         * Astronomical unit (au) light time (TCB-compatible value; DE405 value; see S.A. Klioner, 2008, 'Relativistic scaling of astronomical quantities and the system of astronomical units', A&A, 478, 951-958)        
         * <p>
         * Source: E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048<br/>
         * Status: CONF<br/>
         * Unit: s<br/>
         * Basic : false<br/>
         * Scalar: true
         */
        @ParamMetaData (
        description = "Astronomical unit (au) light time (TCB-compatible value; DE405 value; see S.A. Klioner, 2008, 'Relativistic scaling of astronomical quantities and the system of astronomical units', A&A, 478, 951-958)", 
         source = "E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048", 
         status = "CONF", 
         basic = false, 
         scalar = true, 
         unit = "s") 
        public static final double ASTRONOMICALUNIT_SECOND; static { ASTRONOMICALUNIT_SECOND = 4.9900479154326797e+2; } // [s] 

        /**
         * Astronomical unit (au) length (TCB-compatible value; DE405 value; see S.A. Klioner, 2008, 'Relativistic scaling of astronomical quantities and the system of astronomical units', A&A, 478, 951-958)        
         * <p>
         * Source: E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048<br/>
         * Status: CONF<br/>
         * Unit: m<br/>
         * Basic : false<br/>
         * Scalar: true
         */
        @ParamMetaData (
        description = "Astronomical unit (au) length (TCB-compatible value; DE405 value; see S.A. Klioner, 2008, 'Relativistic scaling of astronomical quantities and the system of astronomical units', A&A, 478, 951-958)", 
         source = "E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048", 
         status = "CONF", 
         basic = false, 
         scalar = true, 
         unit = "m") 
        public static final double ASTRONOMICALUNIT_METER; static { ASTRONOMICALUNIT_METER = 1.4959787301053391e+11; } // [m] 

        /**
         * Geocentric gravitational constant (TCB-compatible value; DE405 value)        
         * <p>
         * Source: E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048<br/>
         * Status: CONF<br/>
         * Unit: m^3 s^-2<br/>
         * Basic : false<br/>
         * Scalar: true
         */
        @ParamMetaData (
        description = "Geocentric gravitational constant (TCB-compatible value; DE405 value)", 
         source = "E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048", 
         status = "CONF", 
         basic = false, 
         scalar = true, 
         unit = "m^3 s^-2") 
        public static final double EARTH_GM; static { EARTH_GM = 3.986004576184e+14; } // [m^3 s^-2] 

        /**
         * Geocentric gravitational constant (TDB-compatible value; DE405 value). Do not use this parameter but use the TCB-compatible value from parameter :Nature:DE405:Earth_GM instead        
         * <p>
         * Source: E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048<br/>
         * Status: CONF<br/>
         * Unit: m^3 s^-2 (TDB)<br/>
         * Basic : false<br/>
         * Scalar: true
         */
        @ParamMetaData (
        description = "Geocentric gravitational constant (TDB-compatible value; DE405 value). Do not use this parameter but use the TCB-compatible value from parameter :Nature:DE405:Earth_GM instead", 
         source = "E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048", 
         status = "CONF", 
         basic = false, 
         scalar = true, 
         unit = "m^3 s^-2 (TDB)") 
        public static final double EARTH_GM_TDB; static { EARTH_GM_TDB = 3.986004514380e+14; } // [m^3 s^-2 (TDB)] 

        /**
         * Equatorial radius of the Earth (DE405 value)        
         * <p>
         * Source: E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048<br/>
         * Status: CONF<br/>
         * Unit: m<br/>
         * Basic : true<br/>
         * Scalar: true
         */
        @ParamMetaData (
        description = "Equatorial radius of the Earth (DE405 value)", 
         source = "E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048", 
         status = "CONF", 
         basic = true, 
         scalar = true, 
         unit = "m") 
        public static final double EARTH_EQUATORIALRADIUS; static { EARTH_EQUATORIALRADIUS = 6378137.; } // [m] 

        /**
         * Secular (long-term) variation of the dynamical form-factor J_2 of the Earth (also known as oblateness and as Stokes' second-degree zonal harmonic of the geopotential) due to the post-glacial rebound of the mantle (DE405 value)        
         * <p>
         * Source: E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048<br/>
         * Status: CONF<br/>
         * Unit: cy^-1<br/>
         * Basic : true<br/>
         * Scalar: true
         */
        @ParamMetaData (
        description = "Secular (long-term) variation of the dynamical form-factor J_2 of the Earth (also known as oblateness and as Stokes' second-degree zonal harmonic of the geopotential) due to the post-glacial rebound of the mantle (DE405 value)", 
         source = "E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048", 
         status = "CONF", 
         basic = true, 
         scalar = true, 
         unit = "cy^-1") 
        public static final double EARTH_JSUB2DOT; static { EARTH_JSUB2DOT = 0.00e+0; } // [cy^-1] 

        /**
         * Time delay \tau_20 used to compute tidal effects for harmonic (2,0) of the Earth's harmonic potential expansion (rigid-Earth tide / slow zonal tides; DE405 value)        
         * <p>
         * Source: E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048<br/>
         * Status: CONF<br/>
         * Unit: day<br/>
         * Basic : true<br/>
         * Scalar: true
         */
        @ParamMetaData (
        description = "Time delay \\tau_20 used to compute tidal effects for harmonic (2,0) of the Earth's harmonic potential expansion (rigid-Earth tide / slow zonal tides; DE405 value)", 
         source = "E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048", 
         status = "CONF", 
         basic = true, 
         scalar = true, 
         unit = "day") 
        public static final double EARTH_TIMEDELAY_20; static { EARTH_TIMEDELAY_20 = 0.; } // [day] 

        /**
         * Time delay \tau_21 used to compute tidal effects for harmonic (2,1) of the Earth's harmonic potential expansion (tidal deformation / diurnal tides; DE405 value)        
         * <p>
         * Source: E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048<br/>
         * Status: CONF<br/>
         * Unit: day<br/>
         * Basic : true<br/>
         * Scalar: true
         */
        @ParamMetaData (
        description = "Time delay \\tau_21 used to compute tidal effects for harmonic (2,1) of the Earth's harmonic potential expansion (tidal deformation / diurnal tides; DE405 value)", 
         source = "E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048", 
         status = "CONF", 
         basic = true, 
         scalar = true, 
         unit = "day") 
        public static final double EARTH_TIMEDELAY_21; static { EARTH_TIMEDELAY_21 = 0.01290895939; } // [day] 

        /**
         * Time delay \tau_22 used to compute tidal effects for harmonic (2,1) of the Earth's harmonic potential expansion (rotational deformation / semi-diurnal tides; DE405 value)        
         * <p>
         * Source: E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048<br/>
         * Status: CONF<br/>
         * Unit: day<br/>
         * Basic : true<br/>
         * Scalar: true
         */
        @ParamMetaData (
        description = "Time delay \\tau_22 used to compute tidal effects for harmonic (2,1) of the Earth's harmonic potential expansion (rotational deformation / semi-diurnal tides; DE405 value)", 
         source = "E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048", 
         status = "CONF", 
         basic = true, 
         scalar = true, 
         unit = "day") 
        public static final double EARTH_TIMEDELAY_22; static { EARTH_TIMEDELAY_22 = 0.00694178558; } // [day] 

        /**
         * Love number k_20 of harmonic (2,0) of the Earth's harmonic potential expansion (rigid-Earth tide / slow zonal tides; DE405 value)        
         * <p>
         * Source: E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048<br/>
         * Status: CONF<br/>
         * Basic : true<br/>
         * Scalar: true
         */
        @ParamMetaData (
        description = "Love number k_20 of harmonic (2,0) of the Earth's harmonic potential expansion (rigid-Earth tide / slow zonal tides; DE405 value)", 
         source = "E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048", 
         status = "CONF", 
         basic = true, 
         scalar = true, 
         unit = "") 
        public static final double EARTH_LOVENUMBER_20; static { EARTH_LOVENUMBER_20 = 0.34; } 

        /**
         * Love number k_21 of harmonic (2,1) of the Earth's harmonic potential expansion (tidal deformation / diurnal tides; DE405 value)        
         * <p>
         * Source: E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048<br/>
         * Status: CONF<br/>
         * Basic : true<br/>
         * Scalar: true
         */
        @ParamMetaData (
        description = "Love number k_21 of harmonic (2,1) of the Earth's harmonic potential expansion (tidal deformation / diurnal tides; DE405 value)", 
         source = "E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048", 
         status = "CONF", 
         basic = true, 
         scalar = true, 
         unit = "") 
        public static final double EARTH_LOVENUMBER_21; static { EARTH_LOVENUMBER_21 = 0.30; } 

        /**
         * Love number k_22 of harmonic (2,1) of the Earth's harmonic potential expansion (rotational deformation / semi-diurnal tides; DE405 value)        
         * <p>
         * Source: E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048<br/>
         * Status: CONF<br/>
         * Basic : true<br/>
         * Scalar: true
         */
        @ParamMetaData (
        description = "Love number k_22 of harmonic (2,1) of the Earth's harmonic potential expansion (rotational deformation / semi-diurnal tides; DE405 value)", 
         source = "E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048", 
         status = "CONF", 
         basic = true, 
         scalar = true, 
         unit = "") 
        public static final double EARTH_LOVENUMBER_22; static { EARTH_LOVENUMBER_22 = 0.30; } 

        /**
         * Degree of harmonic expansion of the Earth's potential (DE405 value)        
         * <p>
         * Source: E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048<br/>
         * Status: CONF<br/>
         * Basic : true<br/>
         * Scalar: true
         */
        @ParamMetaData (
        description = "Degree of harmonic expansion of the Earth's potential (DE405 value)", 
         source = "E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048", 
         status = "CONF", 
         basic = true, 
         scalar = true, 
         unit = "") 
        public static final int EARTH_POTENTIALEXPANSION_DEGREE; static { EARTH_POTENTIALEXPANSION_DEGREE = 4; } 

        /**
         * Harmonic potential coefficients of the Earth (DE405 values). The vector elements denote C_nm, with (n,m) = (2,0), (2,1), (2,2), (3,0), (3,1), (3,2), (3,3), (4,0), (4,1), (4,2), (4,3), and (4,4). A zonal harmonic J_n is a spherical harmonic of the form P_n(cos\theta), i.e., one which reduces to a Legendre polynomial of degree n. A tesseral harmonic C_nm/S_nm is a spherical harmonic of the form cos/sin(m\phi) P_n^m(cos\theta), where P_n^m is a Legendre function of degree n and order m. Special notations include -C_20 = J_2 = Stokes' second degree zonal harmonic (oblateness), -C_30 = J_3 = Stokes' third degree zonal harmonic, and -C_40 = J_4 = Stokes' fourth degree zonal harmonic        
         * <p>
         * Source: E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048<br/>
         * Status: CONF<br/>
         * Basic : true<br/>
         * Scalar: true
         */
        @ParamMetaData (
        description = "Harmonic potential coefficients of the Earth (DE405 values). The vector elements denote C_nm, with (n,m) = (2,0), (2,1), (2,2), (3,0), (3,1), (3,2), (3,3), (4,0), (4,1), (4,2), (4,3), and (4,4). A zonal harmonic J_n is a spherical harmonic of the form P_n(cos\\theta), i.e., one which reduces to a Legendre polynomial of degree n. A tesseral harmonic C_nm/S_nm is a spherical harmonic of the form cos/sin(m\\phi) P_n^m(cos\\theta), where P_n^m is a Legendre function of degree n and order m. Special notations include -C_20 = J_2 = Stokes' second degree zonal harmonic (oblateness), -C_30 = J_3 = Stokes' third degree zonal harmonic, and -C_40 = J_4 = Stokes' fourth degree zonal harmonic", 
         source = "E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048", 
         status = "CONF", 
         basic = true, 
         scalar = true, 
         unit = "") 
        public static final double EARTH_POTENTIALEXPANSION_C[] = {-0.001082626,  0.,  0.,  0.000002533,  0.,  0.,  0.,  0.000001616,  0.,  0.,  0.,  0.}; 

        /**
         * Harmonic potential coefficients of the Earth (DE405 values). The vector elements denote S_nm, with (n,m) = (2,0), (2,1), (2,2), (3,0), (3,1), (3,2), (3,3), (4,0), (4,1), (4,2), (4,3), and (4,4). A zonal harmonic J_n is a spherical harmonic of the form P_n(cos\theta), i.e., one which reduces to a Legendre polynomial of degree n. A tesseral harmonic C_nm/S_nm is a spherical harmonic of the form cos/sin(m\phi) P_n^m(cos\theta), where P_n^m is a Legendre function of degree n and order m        
         * <p>
         * Source: E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048<br/>
         * Status: CONF<br/>
         * Basic : true<br/>
         * Scalar: true
         */
        @ParamMetaData (
        description = "Harmonic potential coefficients of the Earth (DE405 values). The vector elements denote S_nm, with (n,m) = (2,0), (2,1), (2,2), (3,0), (3,1), (3,2), (3,3), (4,0), (4,1), (4,2), (4,3), and (4,4). A zonal harmonic J_n is a spherical harmonic of the form P_n(cos\\theta), i.e., one which reduces to a Legendre polynomial of degree n. A tesseral harmonic C_nm/S_nm is a spherical harmonic of the form cos/sin(m\\phi) P_n^m(cos\\theta), where P_n^m is a Legendre function of degree n and order m", 
         source = "E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048", 
         status = "CONF", 
         basic = true, 
         scalar = true, 
         unit = "") 
        public static final double EARTH_POTENTIALEXPANSION_S[] = {0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.}; 

        /**
         * Ratio of Earth to Moon mass (DE405 value)        
         * <p>
         * Source: E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048<br/>
         * Status: CONF<br/>
         * Basic : true<br/>
         * Scalar: true
         */
        @ParamMetaData (
        description = "Ratio of Earth to Moon mass (DE405 value)", 
         source = "E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048", 
         status = "CONF", 
         basic = true, 
         scalar = true, 
         unit = "") 
        public static final double EARTHTOMOON_MASSRATIO; static { EARTHTOMOON_MASSRATIO = 81.30056; } 

        /**
         * Equatorial radius of the Moon (DE405 value)        
         * <p>
         * Source: E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048<br/>
         * Status: CONF<br/>
         * Unit: m<br/>
         * Basic : true<br/>
         * Scalar: true
         */
        @ParamMetaData (
        description = "Equatorial radius of the Moon (DE405 value)", 
         source = "E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048", 
         status = "CONF", 
         basic = true, 
         scalar = true, 
         unit = "m") 
        public static final double MOON_EQUATORIALRADIUS; static { MOON_EQUATORIALRADIUS = 1738000.; } // [m] 

        /**
         * Time delay \tau_2 used to compute tidal effects for the Moon's solid-body tide, assumed to be the same for all harmonic coefficients of order 2 (DE405 value)        
         * <p>
         * Source: E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048<br/>
         * Status: CONF<br/>
         * Unit: day<br/>
         * Basic : true<br/>
         * Scalar: true
         */
        @ParamMetaData (
        description = "Time delay \\tau_2 used to compute tidal effects for the Moon's solid-body tide, assumed to be the same for all harmonic coefficients of order 2 (DE405 value)", 
         source = "E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048", 
         status = "CONF", 
         basic = true, 
         scalar = true, 
         unit = "day") 
        public static final double MOON_TIMEDELAY_2; static { MOON_TIMEDELAY_2 = 0.1667165558; } // [day] 

        /**
         * Love number k_2 of the Moon's harmonic potential expansion, assumed to be the same for all harmonic coefficients of order 2 (DE405 value)        
         * <p>
         * Source: E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048<br/>
         * Status: CONF<br/>
         * Basic : true<br/>
         * Scalar: true
         */
        @ParamMetaData (
        description = "Love number k_2 of the Moon's harmonic potential expansion, assumed to be the same for all harmonic coefficients of order 2 (DE405 value)", 
         source = "E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048", 
         status = "CONF", 
         basic = true, 
         scalar = true, 
         unit = "") 
        public static final double MOON_LOVENUMBER_2; static { MOON_LOVENUMBER_2 = 0.0299221167; } 

        /**
         * Degree of harmonic expansion of the Moon's potential (DE405 value)        
         * <p>
         * Source: E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048<br/>
         * Status: CONF<br/>
         * Basic : true<br/>
         * Scalar: true
         */
        @ParamMetaData (
        description = "Degree of harmonic expansion of the Moon's potential (DE405 value)", 
         source = "E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048", 
         status = "CONF", 
         basic = true, 
         scalar = true, 
         unit = "") 
        public static final int MOON_POTENTIALEXPANSION_DEGREE; static { MOON_POTENTIALEXPANSION_DEGREE = 4; } 

        /**
         * Harmonic potential coefficients of the Moon (DE405 values). The vector elements denote C_nm, with (n,m) = (2,0), (2,1), (2,2), (3,0), (3,1), (3,2), (3,3), (4,0), (4,1), (4,2), (4,3), and (4,4). A zonal harmonic J_n is a spherical harmonic of the form P_n(cos\theta), i.e., one which reduces to a Legendre polynomial of degree n. A tesseral harmonic C_nm/S_nm is a spherical harmonic of the form cos/sin(m\phi) P_n^m(cos\theta), where P_n^m is a Legendre function of degree n and order m. Special notations include -C_20 = J_2 = Stokes' second degree zonal harmonic (oblateness), -C_30 = J_3 = Stokes' third degree zonal harmonic, and -C_40 = J_4 = Stokes' fourth degree zonal harmonic. The second-degree lunar gravity field is time variable and the time-variable harmonic coefficients are computed in the DE405 ephemeris from the time-variable moment-of-inertia tensor. The numerical values of the C_20, C_21, and C_22 coefficients reported here (-99.99) are hence spurious        
         * <p>
         * Source: E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048<br/>
         * Status: CONF<br/>
         * Basic : true<br/>
         * Scalar: true
         */
        @ParamMetaData (
        description = "Harmonic potential coefficients of the Moon (DE405 values). The vector elements denote C_nm, with (n,m) = (2,0), (2,1), (2,2), (3,0), (3,1), (3,2), (3,3), (4,0), (4,1), (4,2), (4,3), and (4,4). A zonal harmonic J_n is a spherical harmonic of the form P_n(cos\\theta), i.e., one which reduces to a Legendre polynomial of degree n. A tesseral harmonic C_nm/S_nm is a spherical harmonic of the form cos/sin(m\\phi) P_n^m(cos\\theta), where P_n^m is a Legendre function of degree n and order m. Special notations include -C_20 = J_2 = Stokes' second degree zonal harmonic (oblateness), -C_30 = J_3 = Stokes' third degree zonal harmonic, and -C_40 = J_4 = Stokes' fourth degree zonal harmonic. The second-degree lunar gravity field is time variable and the time-variable harmonic coefficients are computed in the DE405 ephemeris from the time-variable moment-of-inertia tensor. The numerical values of the C_20, C_21, and C_22 coefficients reported here (-99.99) are hence spurious", 
         source = "E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048", 
         status = "CONF", 
         basic = true, 
         scalar = true, 
         unit = "") 
        public static final double MOON_POTENTIALEXPANSION_C[] = {-99.99,  -99.99,  -99.99,  -0.000008785470,  0.000030803810,  0.000004879807,  0.000001770176,  0.000000145383,  -0.000007177801,  -0.000001439518,  -0.000000085479,  -0.000000154904}; 

        /**
         * Harmonic potential coefficients of the Moon (DE405 values). The vector elements denote S_nm, with (n,m) = (2,0), (2,1), (2,2), (3,0), (3,1), (3,2), (3,3), (4,0), (4,1), (4,2), (4,3), and (4,4). A zonal harmonic J_n is a spherical harmonic of the form P_n(cos\theta), i.e., one which reduces to a Legendre polynomial of degree n. A tesseral harmonic C_nm/S_nm is a spherical harmonic of the form cos/sin(m\phi) P_n^m(cos\theta), where P_n^m is a Legendre function of degree n and order m. The second-degree lunar gravity field is time variable and the time-variable harmonic coefficients are computed in the DE405 ephemeris from the time-variable moment-of-inertia tensor. The numerical values of the S_21 and S_22 coefficients reported here (-99.99) are hence spurious        
         * <p>
         * Source: E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048<br/>
         * Status: CONF<br/>
         * Basic : true<br/>
         * Scalar: true
         */
        @ParamMetaData (
        description = "Harmonic potential coefficients of the Moon (DE405 values). The vector elements denote S_nm, with (n,m) = (2,0), (2,1), (2,2), (3,0), (3,1), (3,2), (3,3), (4,0), (4,1), (4,2), (4,3), and (4,4). A zonal harmonic J_n is a spherical harmonic of the form P_n(cos\\theta), i.e., one which reduces to a Legendre polynomial of degree n. A tesseral harmonic C_nm/S_nm is a spherical harmonic of the form cos/sin(m\\phi) P_n^m(cos\\theta), where P_n^m is a Legendre function of degree n and order m. The second-degree lunar gravity field is time variable and the time-variable harmonic coefficients are computed in the DE405 ephemeris from the time-variable moment-of-inertia tensor. The numerical values of the S_21 and S_22 coefficients reported here (-99.99) are hence spurious", 
         source = "E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048", 
         status = "CONF", 
         basic = true, 
         scalar = true, 
         unit = "") 
        public static final double MOON_POTENTIALEXPANSION_S[] = {0.,  -99.99,  -99.99,  0.,  0.000004259329,  0.000001695516,  -0.000000270970,  0.,  0.000002947434,  -0.000002884372,  -0.000000788967,  0.000000056404}; 

        /**
         * Ratio of Moon to Earth mass (DE405 value)        
         * <p>
         * Source: E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048<br/>
         * Status: CONF<br/>
         * Basic : false<br/>
         * Scalar: true
         */
        @ParamMetaData (
        description = "Ratio of Moon to Earth mass (DE405 value)", 
         source = "E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048", 
         status = "CONF", 
         basic = false, 
         scalar = true, 
         unit = "") 
        public static final double MOONTOEARTH_MASSRATIO; static { MOONTOEARTH_MASSRATIO = 0.0123000383; } 

        /**
         * Heliocentric gravitational constant (TCB-compatible value; DE405 value)        
         * <p>
         * Source: E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048<br/>
         * Status: CONF<br/>
         * Unit: m^3 s^-2<br/>
         * Basic : false<br/>
         * Scalar: true
         */
        @ParamMetaData (
        description = "Heliocentric gravitational constant (TCB-compatible value; DE405 value)", 
         source = "E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048", 
         status = "CONF", 
         basic = false, 
         scalar = true, 
         unit = "m^3 s^-2") 
        public static final double SUN_GM; static { SUN_GM = 1.327124482489e+20; } // [m^3 s^-2] 

        /**
         * Heliocentric gravitational constant (TDB-compatible value; DE405 value). Do not use this parameter but use the TCB-compatible value from parameter :Nature:DE405:Sun_GM instead        
         * <p>
         * Source: E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048<br/>
         * Status: CONF<br/>
         * Unit: m^3 s^-2 (TDB)<br/>
         * Basic : false<br/>
         * Scalar: true
         */
        @ParamMetaData (
        description = "Heliocentric gravitational constant (TDB-compatible value; DE405 value). Do not use this parameter but use the TCB-compatible value from parameter :Nature:DE405:Sun_GM instead", 
         source = "E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048", 
         status = "CONF", 
         basic = false, 
         scalar = true, 
         unit = "m^3 s^-2 (TDB)") 
        public static final double SUN_GM_TDB; static { SUN_GM_TDB = 1.327124461912e+20; } // [m^3 s^-2 (TDB)] 

        /**
         * Dynamical form-factor of the Sun (Stokes' second-degree zonal harmonic of the solar potential; DE405 value)        
         * <p>
         * Source: E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048<br/>
         * Status: CONF<br/>
         * Basic : true<br/>
         * Scalar: true
         */
        @ParamMetaData (
        description = "Dynamical form-factor of the Sun (Stokes' second-degree zonal harmonic of the solar potential; DE405 value)", 
         source = "E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048", 
         status = "CONF", 
         basic = true, 
         scalar = true, 
         unit = "") 
        public static final double SUN_JSUB2; static { SUN_JSUB2 = 2.0e-7; } 

        /**
         * Ratio of Sun to Earth mass (DE405 value)        
         * <p>
         * Source: E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048<br/>
         * Status: CONF<br/>
         * Basic : false<br/>
         * Scalar: true
         */
        @ParamMetaData (
        description = "Ratio of Sun to Earth mass (DE405 value)", 
         source = "E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048", 
         status = "CONF", 
         basic = false, 
         scalar = true, 
         unit = "") 
        public static final double SUNTOEARTH_MASSRATIO; static { SUNTOEARTH_MASSRATIO = 332946.050895; } 

        /**
         * Ratio of Sun to Earth-system mass (DE405 value). The planetary mass includes the contribution of its satellite, the Moon        
         * <p>
         * Source: E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048<br/>
         * Status: CONF<br/>
         * Basic : true<br/>
         * Scalar: true
         */
        @ParamMetaData (
        description = "Ratio of Sun to Earth-system mass (DE405 value). The planetary mass includes the contribution of its satellite, the Moon", 
         source = "E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048", 
         status = "CONF", 
         basic = true, 
         scalar = true, 
         unit = "") 
        public static final double SUNTOEARTHSYSTEM_MASSRATIO; static { SUNTOEARTHSYSTEM_MASSRATIO = 328900.561400; } 

        /**
         * Ratio of Sun to Jupiter-system mass (DE405 value). The planetary mass includes the contribution of its satellites        
         * <p>
         * Source: E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048. Numerical value: J.K. Campbell, S.P. Synnott, 1985, 'Gravity field of the Jovian system from Pioneer and Voyager tracking data', AJ, 90, 364; this reference lists GM = 126712767 km^3 s^-2<br/>
         * Status: CONF<br/>
         * Basic : true<br/>
         * Scalar: true
         */
        @ParamMetaData (
        description = "Ratio of Sun to Jupiter-system mass (DE405 value). The planetary mass includes the contribution of its satellites", 
         source = "E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048. Numerical value: J.K. Campbell, S.P. Synnott, 1985, 'Gravity field of the Jovian system from Pioneer and Voyager tracking data', AJ, 90, 364; this reference lists GM = 126712767 km^3 s^-2", 
         status = "CONF", 
         basic = true, 
         scalar = true, 
         unit = "") 
        public static final double SUNTOJUPITERSYSTEM_MASSRATIO; static { SUNTOJUPITERSYSTEM_MASSRATIO = 1047.3486; } 

        /**
         * Ratio of Sun to Mars-system mass (DE405 value). The planetary mass includes the contribution of its satellites        
         * <p>
         * Source: E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048. Numerical value: G.W. Null, 1969, 'A solution for the mass and dynamical oblateness of Mars using Mariner-IV Doppler data', Bull. Am. Astron. Soc., 1, 356<br/>
         * Status: CONF<br/>
         * Basic : true<br/>
         * Scalar: true
         */
        @ParamMetaData (
        description = "Ratio of Sun to Mars-system mass (DE405 value). The planetary mass includes the contribution of its satellites", 
         source = "E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048. Numerical value: G.W. Null, 1969, 'A solution for the mass and dynamical oblateness of Mars using Mariner-IV Doppler data', Bull. Am. Astron. Soc., 1, 356", 
         status = "CONF", 
         basic = true, 
         scalar = true, 
         unit = "") 
        public static final double SUNTOMARSSYSTEM_MASSRATIO; static { SUNTOMARSSYSTEM_MASSRATIO = 3098708.; } 

        /**
         * Ratio of Sun to Mercury(-system) mass (DE405 value)        
         * <p>
         * Source: E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048. Numerical value: J.D. Anderson, et al., 1987, 'The mass, gravity field, and ephemeris of Mercury', Icarus, 71, 337; this reference lists GM = 22032.09 km^3 s^-2<br/>
         * Status: CONF<br/>
         * Basic : true<br/>
         * Scalar: true
         */
        @ParamMetaData (
        description = "Ratio of Sun to Mercury(-system) mass (DE405 value)", 
         source = "E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048. Numerical value: J.D. Anderson, et al., 1987, 'The mass, gravity field, and ephemeris of Mercury', Icarus, 71, 337; this reference lists GM = 22032.09 km^3 s^-2", 
         status = "CONF", 
         basic = true, 
         scalar = true, 
         unit = "") 
        public static final double SUNTOMERCURYSYSTEM_MASSRATIO; static { SUNTOMERCURYSYSTEM_MASSRATIO = 6023600.; } 

        /**
         * Ratio of Sun to Neptune-system mass (DE405 value). The planetary mass includes the contribution of its satellites        
         * <p>
         * Source: E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048. Numerical value: R.A. Jacobson, et al., 1991, 'The orbits of Triton and Nereid from spacecraft and Earth-based observations', A&A, 247, 565; this reference lists GM = 6836535 km^3 s^-2<br/>
         * Status: CONF<br/>
         * Basic : true<br/>
         * Scalar: true
         */
        @ParamMetaData (
        description = "Ratio of Sun to Neptune-system mass (DE405 value). The planetary mass includes the contribution of its satellites", 
         source = "E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048. Numerical value: R.A. Jacobson, et al., 1991, 'The orbits of Triton and Nereid from spacecraft and Earth-based observations', A&A, 247, 565; this reference lists GM = 6836535 km^3 s^-2", 
         status = "CONF", 
         basic = true, 
         scalar = true, 
         unit = "") 
        public static final double SUNTONEPTUNESYSTEM_MASSRATIO; static { SUNTONEPTUNESYSTEM_MASSRATIO = 19412.24; } 

        /**
         * Ratio of Sun to Pluto-system mass (DE405 value). The 'planetary' mass includes the contribution of its satellite, Charon        
         * <p>
         * Source: E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048. Numerical value: D.J. Tholen, M.W. Buie, 1997, 'The Orbit of Charon', Icarus, 125, 245, although these authors list 1.3522E8 rather than 1.3521E8; this reference lists GM = 981.5 km^3 s^-2<br/>
         * Status: CONF<br/>
         * Basic : true<br/>
         * Scalar: true
         */
        @ParamMetaData (
        description = "Ratio of Sun to Pluto-system mass (DE405 value). The 'planetary' mass includes the contribution of its satellite, Charon", 
         source = "E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048. Numerical value: D.J. Tholen, M.W. Buie, 1997, 'The Orbit of Charon', Icarus, 125, 245, although these authors list 1.3522E8 rather than 1.3521E8; this reference lists GM = 981.5 km^3 s^-2", 
         status = "CONF", 
         basic = true, 
         scalar = true, 
         unit = "") 
        public static final double SUNTOPLUTOSYSTEM_MASSRATIO; static { SUNTOPLUTOSYSTEM_MASSRATIO = 135200000.; } 

        /**
         * Ratio of Sun to Saturn-system mass (DE405 value). The planetary mass includes the contribution of its satellites        
         * <p>
         * Source: E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048. Numerical value: J.K. Campbell, J.D. Anderson, 1989, 'Gravity field of the Saturnian system from Pioneer and Voyager tracking data', AJ, 97, 1485; this reference lists GM = 37940630 km^3 s^-2<br/>
         * Status: CONF<br/>
         * Basic : true<br/>
         * Scalar: true
         */
        @ParamMetaData (
        description = "Ratio of Sun to Saturn-system mass (DE405 value). The planetary mass includes the contribution of its satellites", 
         source = "E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048. Numerical value: J.K. Campbell, J.D. Anderson, 1989, 'Gravity field of the Saturnian system from Pioneer and Voyager tracking data', AJ, 97, 1485; this reference lists GM = 37940630 km^3 s^-2", 
         status = "CONF", 
         basic = true, 
         scalar = true, 
         unit = "") 
        public static final double SUNTOSATURNSYSTEM_MASSRATIO; static { SUNTOSATURNSYSTEM_MASSRATIO = 3497.898; } 

        /**
         * Ratio of Sun to Uranus-system mass (DE405 value). The planetary mass includes the contribution of its satellites        
         * <p>
         * Source: E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048. Numerical value: R.A. Jacobson, et al., 1992, AJ, 'The masses of Uranus and its major satellites from Voyager tracking data and Earth-based Uranian satellite data', 103, 2068; this reference lists GM = 5794548.6 km^3 s^-2<br/>
         * Status: CONF<br/>
         * Basic : true<br/>
         * Scalar: true
         */
        @ParamMetaData (
        description = "Ratio of Sun to Uranus-system mass (DE405 value). The planetary mass includes the contribution of its satellites", 
         source = "E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048. Numerical value: R.A. Jacobson, et al., 1992, AJ, 'The masses of Uranus and its major satellites from Voyager tracking data and Earth-based Uranian satellite data', 103, 2068; this reference lists GM = 5794548.6 km^3 s^-2", 
         status = "CONF", 
         basic = true, 
         scalar = true, 
         unit = "") 
        public static final double SUNTOURANUSSYSTEM_MASSRATIO; static { SUNTOURANUSSYSTEM_MASSRATIO = 22902.98; } 

        /**
         * Ratio of Sun to Venus(-system) mass (DE405 value)        
         * <p>
         * Source: E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048. Numerical value: W.L. Sjogren, et al., 1990, 'Venus - A total mass estimate', Geophysical Research Letters, 17, 1485; this reference lists GM = 324858.60 km^3 s^-2<br/>
         * Status: CONF<br/>
         * Basic : true<br/>
         * Scalar: true
         */
        @ParamMetaData (
        description = "Ratio of Sun to Venus(-system) mass (DE405 value)", 
         source = "E.M. Standish, 26 August 1998, 'JPL Planetary and Lunar Ephemerides, DE405/LE405', JPL IOM 312.F-98-048. Numerical value: W.L. Sjogren, et al., 1990, 'Venus - A total mass estimate', Geophysical Research Letters, 17, 1485; this reference lists GM = 324858.60 km^3 s^-2", 
         status = "CONF", 
         basic = true, 
         scalar = true, 
         unit = "") 
        public static final double SUNTOVENUSSYSTEM_MASSRATIO; static { SUNTOVENUSSYSTEM_MASSRATIO = 408523.71; } 

    }

    public static class INPOP06 {
        /**
         * Mean mass density of C-class asteroids (INPOP06 value from a direct fit). The mean density \rho is assumed to be constant within each of the three taxonomic asteroid classes C, S, and M. Note that INPOP06 uses an outdated numerical value of 6.672E-11 m^3 kg^-1 s^-2 for Newton's constant (see parameter :Nature:Newton_Constant), which directly influences the asteroid-mass estimates        
         * <p>
         * Source: A. Fienga, J. Laskar, H. Manche, M. Gastineau, 19 April 2007, 'Solar System Planetary Ephemeris Delivery: INPOP06', GAIA-CA-TN-IMC-AF-001, issue 1, revision 0<br/>
         * Status: DEPR<br/>
         * Unit: g cm^-3<br/>
         * Basic : true<br/>
         * Scalar: true
         */
        @ParamMetaData (
        description = "Mean mass density of C-class asteroids (INPOP06 value from a direct fit). The mean density \\rho is assumed to be constant within each of the three taxonomic asteroid classes C, S, and M. Note that INPOP06 uses an outdated numerical value of 6.672E-11 m^3 kg^-1 s^-2 for Newton's constant (see parameter :Nature:Newton_Constant), which directly influences the asteroid-mass estimates", 
         source = "A. Fienga, J. Laskar, H. Manche, M. Gastineau, 19 April 2007, 'Solar System Planetary Ephemeris Delivery: INPOP06', GAIA-CA-TN-IMC-AF-001, issue 1, revision 0", 
         status = "DEPR", 
         basic = true, 
         scalar = true, 
         unit = "g cm^-3") 
        public static final double ASTEROID_MASSDENSITY_MEANCLASSC; static { ASTEROID_MASSDENSITY_MEANCLASSC = 2.02; } // [g cm^-3] 

        /**
         * Mean mass density of S-class asteroids (INPOP06 value from a direct fit). The mean density \rho is assumed to be constant within each of the three taxonomic asteroid classes C, S, and M. Note that INPOP06 uses an outdated numerical value of 6.672E-11 m^3 kg^-1 s^-2 for Newton's constant (see parameter :Nature:Newton_Constant), which directly influences the asteroid-mass estimates        
         * <p>
         * Source: A. Fienga, J. Laskar, H. Manche, M. Gastineau, 19 April 2007, 'Solar System Planetary Ephemeris Delivery: INPOP06', GAIA-CA-TN-IMC-AF-001, issue 1, revision 0<br/>
         * Status: DEPR<br/>
         * Unit: g cm^-3<br/>
         * Basic : true<br/>
         * Scalar: true
         */
        @ParamMetaData (
        description = "Mean mass density of S-class asteroids (INPOP06 value from a direct fit). The mean density \\rho is assumed to be constant within each of the three taxonomic asteroid classes C, S, and M. Note that INPOP06 uses an outdated numerical value of 6.672E-11 m^3 kg^-1 s^-2 for Newton's constant (see parameter :Nature:Newton_Constant), which directly influences the asteroid-mass estimates", 
         source = "A. Fienga, J. Laskar, H. Manche, M. Gastineau, 19 April 2007, 'Solar System Planetary Ephemeris Delivery: INPOP06', GAIA-CA-TN-IMC-AF-001, issue 1, revision 0", 
         status = "DEPR", 
         basic = true, 
         scalar = true, 
         unit = "g cm^-3") 
        public static final double ASTEROID_MASSDENSITY_MEANCLASSS; static { ASTEROID_MASSDENSITY_MEANCLASSS = 2.18; } // [g cm^-3] 

        /**
         * Mean mass density of M-class asteroids (INPOP06 value from a direct fit). The mean density \rho is assumed to be constant within each of the three taxonomic asteroid classes C, S, and M. Note that INPOP06 uses an outdated numerical value of 6.672E-11 m^3 kg^-1 s^-2 for Newton's constant (see parameter :Nature:Newton_Constant), which directly influences the asteroid-mass estimates        
         * <p>
         * Source: A. Fienga, J. Laskar, H. Manche, M. Gastineau, 19 April 2007, 'Solar System Planetary Ephemeris Delivery: INPOP06', GAIA-CA-TN-IMC-AF-001, issue 1, revision 0<br/>
         * Status: DEPR<br/>
         * Unit: g cm^-3<br/>
         * Basic : true<br/>
         * Scalar: true
         */
        @ParamMetaData (
        description = "Mean mass density of M-class asteroids (INPOP06 value from a direct fit). The mean density \\rho is assumed to be constant within each of the three taxonomic asteroid classes C, S, and M. Note that INPOP06 uses an outdated numerical value of 6.672E-11 m^3 kg^-1 s^-2 for Newton's constant (see parameter :Nature:Newton_Constant), which directly influences the asteroid-mass estimates", 
         source = "A. Fienga, J. Laskar, H. Manche, M. Gastineau, 19 April 2007, 'Solar System Planetary Ephemeris Delivery: INPOP06', GAIA-CA-TN-IMC-AF-001, issue 1, revision 0", 
         status = "DEPR", 
         basic = true, 
         scalar = true, 
         unit = "g cm^-3") 
        public static final double ASTEROID_MASSDENSITY_MEANCLASSM; static { ASTEROID_MASSDENSITY_MEANCLASSM = 4.460; } // [g cm^-3] 

        /**
         * Uncertainty of the INPOP06 value of the mean mass density of C-class asteroids (1-\sigma uncertainty from the direct INPOP06 fit). The mean density \rho is assumed to be constant within each of the three taxonomic asteroid classes C, S, and M        
         * <p>
         * Source: A. Fienga, J. Laskar, H. Manche, M. Gastineau, 19 April 2007, 'Solar System Planetary Ephemeris Delivery: INPOP06', GAIA-CA-TN-IMC-AF-001, issue 1, revision 0<br/>
         * Status: DEPR<br/>
         * Unit: g cm^-3<br/>
         * Basic : true<br/>
         * Scalar: true
         */
        @ParamMetaData (
        description = "Uncertainty of the INPOP06 value of the mean mass density of C-class asteroids (1-\\sigma uncertainty from the direct INPOP06 fit). The mean density \\rho is assumed to be constant within each of the three taxonomic asteroid classes C, S, and M", 
         source = "A. Fienga, J. Laskar, H. Manche, M. Gastineau, 19 April 2007, 'Solar System Planetary Ephemeris Delivery: INPOP06', GAIA-CA-TN-IMC-AF-001, issue 1, revision 0", 
         status = "DEPR", 
         basic = true, 
         scalar = true, 
         unit = "g cm^-3") 
        public static final double ASTEROID_MASSDENSITYERROR_MEANCLASSC; static { ASTEROID_MASSDENSITYERROR_MEANCLASSC = 0.12; } // [g cm^-3] 

        /**
         * Uncertainty of the INPOP06 value of the mean mass density of S-class asteroids (1-\sigma uncertainty from the direct INPOP06 fit). The mean density \rho is assumed to be constant within each of the three taxonomic asteroid classes C, S, and M        
         * <p>
         * Source: A. Fienga, J. Laskar, H. Manche, M. Gastineau, 19 April 2007, 'Solar System Planetary Ephemeris Delivery: INPOP06', GAIA-CA-TN-IMC-AF-001, issue 1, revision 0<br/>
         * Status: DEPR<br/>
         * Unit: g cm^-3<br/>
         * Basic : true<br/>
         * Scalar: true
         */
        @ParamMetaData (
        description = "Uncertainty of the INPOP06 value of the mean mass density of S-class asteroids (1-\\sigma uncertainty from the direct INPOP06 fit). The mean density \\rho is assumed to be constant within each of the three taxonomic asteroid classes C, S, and M", 
         source = "A. Fienga, J. Laskar, H. Manche, M. Gastineau, 19 April 2007, 'Solar System Planetary Ephemeris Delivery: INPOP06', GAIA-CA-TN-IMC-AF-001, issue 1, revision 0", 
         status = "DEPR", 
         basic = true, 
         scalar = true, 
         unit = "g cm^-3") 
        public static final double ASTEROID_MASSDENSITYERROR_MEANCLASSS; static { ASTEROID_MASSDENSITYERROR_MEANCLASSS = 0.11; } // [g cm^-3] 

        /**
         * Uncertainty of the INPOP06 value of the mean mass density of M-class asteroids (1-\sigma uncertainty from the direct INPOP06 fit). The mean density \rho is assumed to be constant within each of the three taxonomic asteroid classes C, S, and M        
         * <p>
         * Source: A. Fienga, J. Laskar, H. Manche, M. Gastineau, 19 April 2007, 'Solar System Planetary Ephemeris Delivery: INPOP06', GAIA-CA-TN-IMC-AF-001, issue 1, revision 0<br/>
         * Status: DEPR<br/>
         * Unit: g cm^-3<br/>
         * Basic : true<br/>
         * Scalar: true
         */
        @ParamMetaData (
        description = "Uncertainty of the INPOP06 value of the mean mass density of M-class asteroids (1-\\sigma uncertainty from the direct INPOP06 fit). The mean density \\rho is assumed to be constant within each of the three taxonomic asteroid classes C, S, and M", 
         source = "A. Fienga, J. Laskar, H. Manche, M. Gastineau, 19 April 2007, 'Solar System Planetary Ephemeris Delivery: INPOP06', GAIA-CA-TN-IMC-AF-001, issue 1, revision 0", 
         status = "DEPR", 
         basic = true, 
         scalar = true, 
         unit = "g cm^-3") 
        public static final double ASTEROID_MASSDENSITYERROR_MEANCLASSM; static { ASTEROID_MASSDENSITYERROR_MEANCLASSM = 0.012; } // [g cm^-3] 

        /**
         * Ratio of 1 Ceres to solar mass (INPOP06 value from a direct fit)        
         * <p>
         * Source: A. Fienga, J. Laskar, H. Manche, M. Gastineau, 19 April 2007, 'Solar System Planetary Ephemeris Delivery: INPOP06', GAIA-CA-TN-IMC-AF-001, issue 1, revision 0<br/>
         * Status: DEPR<br/>
         * Basic : true<br/>
         * Scalar: true
         */
        @ParamMetaData (
        description = "Ratio of 1 Ceres to solar mass (INPOP06 value from a direct fit)", 
         source = "A. Fienga, J. Laskar, H. Manche, M. Gastineau, 19 April 2007, 'Solar System Planetary Ephemeris Delivery: INPOP06', GAIA-CA-TN-IMC-AF-001, issue 1, revision 0", 
         status = "DEPR", 
         basic = true, 
         scalar = true, 
         unit = "") 
        public static final double ASTEROID1CERESMASS_SOLARMASS; static { ASTEROID1CERESMASS_SOLARMASS = 4.7930e-10; } 

        /**
         * Uncertainty of the INPOP06 value of the ratio of 1 Ceres to solar mass (1-\sigma uncertainty from the direct INPOP06 fit)        
         * <p>
         * Source: A. Fienga, J. Laskar, H. Manche, M. Gastineau, 19 April 2007, 'Solar System Planetary Ephemeris Delivery: INPOP06', GAIA-CA-TN-IMC-AF-001, issue 1, revision 0<br/>
         * Status: DEPR<br/>
         * Basic : true<br/>
         * Scalar: true
         */
        @ParamMetaData (
        description = "Uncertainty of the INPOP06 value of the ratio of 1 Ceres to solar mass (1-\\sigma uncertainty from the direct INPOP06 fit)", 
         source = "A. Fienga, J. Laskar, H. Manche, M. Gastineau, 19 April 2007, 'Solar System Planetary Ephemeris Delivery: INPOP06', GAIA-CA-TN-IMC-AF-001, issue 1, revision 0", 
         status = "DEPR", 
         basic = true, 
         scalar = true, 
         unit = "") 
        public static final double ASTEROID1CERESMASS_SOLARMASSERROR; static { ASTEROID1CERESMASS_SOLARMASSERROR = 6.00e-13; } 

        /**
         * Ratio of 2 Pallas to solar mass (INPOP06 value from a direct fit)        
         * <p>
         * Source: A. Fienga, J. Laskar, H. Manche, M. Gastineau, 19 April 2007, 'Solar System Planetary Ephemeris Delivery: INPOP06', GAIA-CA-TN-IMC-AF-001, issue 1, revision 0<br/>
         * Status: DEPR<br/>
         * Basic : true<br/>
         * Scalar: true
         */
        @ParamMetaData (
        description = "Ratio of 2 Pallas to solar mass (INPOP06 value from a direct fit)", 
         source = "A. Fienga, J. Laskar, H. Manche, M. Gastineau, 19 April 2007, 'Solar System Planetary Ephemeris Delivery: INPOP06', GAIA-CA-TN-IMC-AF-001, issue 1, revision 0", 
         status = "DEPR", 
         basic = true, 
         scalar = true, 
         unit = "") 
        public static final double ASTEROID2PALLASMASS_SOLARMASS; static { ASTEROID2PALLASMASS_SOLARMASS = 9.720e-11; } 

        /**
         * Uncertainty of the INPOP06 value of the ratio of 2 Pallas to solar mass (1-\sigma uncertainty from the direct INPOP06 fit)        
         * <p>
         * Source: A. Fienga, J. Laskar, H. Manche, M. Gastineau, 19 April 2007, 'Solar System Planetary Ephemeris Delivery: INPOP06', GAIA-CA-TN-IMC-AF-001, issue 1, revision 0<br/>
         * Status: DEPR<br/>
         * Basic : true<br/>
         * Scalar: true
         */
        @ParamMetaData (
        description = "Uncertainty of the INPOP06 value of the ratio of 2 Pallas to solar mass (1-\\sigma uncertainty from the direct INPOP06 fit)", 
         source = "A. Fienga, J. Laskar, H. Manche, M. Gastineau, 19 April 2007, 'Solar System Planetary Ephemeris Delivery: INPOP06', GAIA-CA-TN-IMC-AF-001, issue 1, revision 0", 
         status = "DEPR", 
         basic = true, 
         scalar = true, 
         unit = "") 
        public static final double ASTEROID2PALLASMASS_SOLARMASSERROR; static { ASTEROID2PALLASMASS_SOLARMASSERROR = 3.00e-13; } 

        /**
         * Ratio of 324 Bamberga to solar mass (INPOP06 value from a direct fit)        
         * <p>
         * Source: A. Fienga, J. Laskar, H. Manche, M. Gastineau, 19 April 2007, 'Solar System Planetary Ephemeris Delivery: INPOP06', GAIA-CA-TN-IMC-AF-001, issue 1, revision 0<br/>
         * Status: DEPR<br/>
         * Basic : true<br/>
         * Scalar: true
         */
        @ParamMetaData (
        description = "Ratio of 324 Bamberga to solar mass (INPOP06 value from a direct fit)", 
         source = "A. Fienga, J. Laskar, H. Manche, M. Gastineau, 19 April 2007, 'Solar System Planetary Ephemeris Delivery: INPOP06', GAIA-CA-TN-IMC-AF-001, issue 1, revision 0", 
         status = "DEPR", 
         basic = true, 
         scalar = true, 
         unit = "") 
        public static final double ASTEROID324BAMBERGA_SOLARMASS; static { ASTEROID324BAMBERGA_SOLARMASS = 6.10e-12; } 

        /**
         * Uncertainty of the INPOP06 value of the ratio of 324 Bamberga to solar mass (1-\sigma uncertainty from the direct INPOP06 fit)        
         * <p>
         * Source: A. Fienga, J. Laskar, H. Manche, M. Gastineau, 19 April 2007, 'Solar System Planetary Ephemeris Delivery: INPOP06', GAIA-CA-TN-IMC-AF-001, issue 1, revision 0<br/>
         * Status: DEPR<br/>
         * Basic : true<br/>
         * Scalar: true
         */
        @ParamMetaData (
        description = "Uncertainty of the INPOP06 value of the ratio of 324 Bamberga to solar mass (1-\\sigma uncertainty from the direct INPOP06 fit)", 
         source = "A. Fienga, J. Laskar, H. Manche, M. Gastineau, 19 April 2007, 'Solar System Planetary Ephemeris Delivery: INPOP06', GAIA-CA-TN-IMC-AF-001, issue 1, revision 0", 
         status = "DEPR", 
         basic = true, 
         scalar = true, 
         unit = "") 
        public static final double ASTEROID324BAMBERGA_SOLARMASSERROR; static { ASTEROID324BAMBERGA_SOLARMASSERROR = 2.00e-13; } 

        /**
         * Ratio of 4 Vesta to solar mass (INPOP06 value from a direct fit)        
         * <p>
         * Source: A. Fienga, J. Laskar, H. Manche, M. Gastineau, 19 April 2007, 'Solar System Planetary Ephemeris Delivery: INPOP06', GAIA-CA-TN-IMC-AF-001, issue 1, revision 0<br/>
         * Status: DEPR<br/>
         * Basic : true<br/>
         * Scalar: true
         */
        @ParamMetaData (
        description = "Ratio of 4 Vesta to solar mass (INPOP06 value from a direct fit)", 
         source = "A. Fienga, J. Laskar, H. Manche, M. Gastineau, 19 April 2007, 'Solar System Planetary Ephemeris Delivery: INPOP06', GAIA-CA-TN-IMC-AF-001, issue 1, revision 0", 
         status = "DEPR", 
         basic = true, 
         scalar = true, 
         unit = "") 
        public static final double ASTEROID4VESTAMASS_SOLARMASS; static { ASTEROID4VESTAMASS_SOLARMASS = 1.3190e-10; } 

        /**
         * Uncertainty of the INPOP06 value of the ratio of 4 Vesta to solar mass (1-\sigma uncertainty from the direct INPOP06 fit)        
         * <p>
         * Source: A. Fienga, J. Laskar, H. Manche, M. Gastineau, 19 April 2007, 'Solar System Planetary Ephemeris Delivery: INPOP06', GAIA-CA-TN-IMC-AF-001, issue 1, revision 0<br/>
         * Status: DEPR<br/>
         * Basic : true<br/>
         * Scalar: true
         */
        @ParamMetaData (
        description = "Uncertainty of the INPOP06 value of the ratio of 4 Vesta to solar mass (1-\\sigma uncertainty from the direct INPOP06 fit)", 
         source = "A. Fienga, J. Laskar, H. Manche, M. Gastineau, 19 April 2007, 'Solar System Planetary Ephemeris Delivery: INPOP06', GAIA-CA-TN-IMC-AF-001, issue 1, revision 0", 
         status = "DEPR", 
         basic = true, 
         scalar = true, 
         unit = "") 
        public static final double ASTEROID4VESTAMASS_SOLARMASSERROR; static { ASTEROID4VESTAMASS_SOLARMASSERROR = 2.00e-13; } 

        /**
         * Ratio of 7 Iris to solar mass (INPOP06 value from a direct fit)        
         * <p>
         * Source: A. Fienga, J. Laskar, H. Manche, M. Gastineau, 19 April 2007, 'Solar System Planetary Ephemeris Delivery: INPOP06', GAIA-CA-TN-IMC-AF-001, issue 1, revision 0<br/>
         * Status: DEPR<br/>
         * Basic : true<br/>
         * Scalar: true
         */
        @ParamMetaData (
        description = "Ratio of 7 Iris to solar mass (INPOP06 value from a direct fit)", 
         source = "A. Fienga, J. Laskar, H. Manche, M. Gastineau, 19 April 2007, 'Solar System Planetary Ephemeris Delivery: INPOP06', GAIA-CA-TN-IMC-AF-001, issue 1, revision 0", 
         status = "DEPR", 
         basic = true, 
         scalar = true, 
         unit = "") 
        public static final double ASTEROID7IRISMASS_SOLARMASS; static { ASTEROID7IRISMASS_SOLARMASS = 9.50e-12; } 

        /**
         * Uncertainty of the INPOP06 value of the ratio of 7 Iris to solar mass (1-\sigma uncertainty from the direct INPOP06 fit)        
         * <p>
         * Source: A. Fienga, J. Laskar, H. Manche, M. Gastineau, 19 April 2007, 'Solar System Planetary Ephemeris Delivery: INPOP06', GAIA-CA-TN-IMC-AF-001, issue 1, revision 0<br/>
         * Status: DEPR<br/>
         * Basic : true<br/>
         * Scalar: true
         */
        @ParamMetaData (
        description = "Uncertainty of the INPOP06 value of the ratio of 7 Iris to solar mass (1-\\sigma uncertainty from the direct INPOP06 fit)", 
         source = "A. Fienga, J. Laskar, H. Manche, M. Gastineau, 19 April 2007, 'Solar System Planetary Ephemeris Delivery: INPOP06', GAIA-CA-TN-IMC-AF-001, issue 1, revision 0", 
         status = "DEPR", 
         basic = true, 
         scalar = true, 
         unit = "") 
        public static final double ASTEROID7IRISMASS_SOLARMASSERROR; static { ASTEROID7IRISMASS_SOLARMASSERROR = 2.00e-13; } 

        /**
         * Barycentric distance (orbital semi-major axis) of the Krasinsky asteroid ring (INPOP06 value). Following G.A. Krasinsky, E.V. Pitjeva, M.V. Vasilyev, E.I. Yagudina, 1 February 2002, 'Hidden Mass in the Asteroid Belt', Icarus, 158, 98-105, the gravitational effect of all but the 300 heaviest asteroids can be modeled as an acceleration caused by a solid ring with this barycentric distance/radius in the ecliptic plane        
         * <p>
         * Source: A. Fienga, J. Laskar, H. Manche, M. Gastineau, 19 April 2007, 'Solar System Planetary Ephemeris Delivery: INPOP06', GAIA-CA-TN-IMC-AF-001, issue 1, revision 0<br/>
         * Status: DEPR<br/>
         * Unit: au<br/>
         * Basic : true<br/>
         * Scalar: true
         */
        @ParamMetaData (
        description = "Barycentric distance (orbital semi-major axis) of the Krasinsky asteroid ring (INPOP06 value). Following G.A. Krasinsky, E.V. Pitjeva, M.V. Vasilyev, E.I. Yagudina, 1 February 2002, 'Hidden Mass in the Asteroid Belt', Icarus, 158, 98-105, the gravitational effect of all but the 300 heaviest asteroids can be modeled as an acceleration caused by a solid ring with this barycentric distance/radius in the ecliptic plane", 
         source = "A. Fienga, J. Laskar, H. Manche, M. Gastineau, 19 April 2007, 'Solar System Planetary Ephemeris Delivery: INPOP06', GAIA-CA-TN-IMC-AF-001, issue 1, revision 0", 
         status = "DEPR", 
         basic = true, 
         scalar = true, 
         unit = "au") 
        public static final double ASTEROIDRING_ORBITALSEMIMAJORAXIS; static { ASTEROIDRING_ORBITALSEMIMAJORAXIS = 2.8; } // [au] 

        /**
         * Ratio of the Krasinsky asteroid ring to solar mass (INPOP06 value from a direct fit). Following G.A. Krasinsky, E.V. Pitjeva, M.V. Vasilyev, E.I. Yagudina, 1 February 2002, 'Hidden Mass in the Asteroid Belt', Icarus, 158, 98-105, the gravitational effect of all but the 300 heaviest asteroids can be modeled as an acceleration caused by a solid ring of this mass in the ecliptic plane        
         * <p>
         * Source: A. Fienga, J. Laskar, H. Manche, M. Gastineau, 19 April 2007, 'Solar System Planetary Ephemeris Delivery: INPOP06', GAIA-CA-TN-IMC-AF-001, issue 1, revision 0<br/>
         * Status: DEPR<br/>
         * Basic : true<br/>
         * Scalar: true
         */
        @ParamMetaData (
        description = "Ratio of the Krasinsky asteroid ring to solar mass (INPOP06 value from a direct fit). Following G.A. Krasinsky, E.V. Pitjeva, M.V. Vasilyev, E.I. Yagudina, 1 February 2002, 'Hidden Mass in the Asteroid Belt', Icarus, 158, 98-105, the gravitational effect of all but the 300 heaviest asteroids can be modeled as an acceleration caused by a solid ring of this mass in the ecliptic plane", 
         source = "A. Fienga, J. Laskar, H. Manche, M. Gastineau, 19 April 2007, 'Solar System Planetary Ephemeris Delivery: INPOP06', GAIA-CA-TN-IMC-AF-001, issue 1, revision 0", 
         status = "DEPR", 
         basic = true, 
         scalar = true, 
         unit = "") 
        public static final double ASTEROIDRINGMASS_SOLARMASS; static { ASTEROIDRINGMASS_SOLARMASS = 3.40e-11; } 

        /**
         * Uncertainty of the INPOP06 value of the ratio of the Krasinsky asteroid ring to solar mass (1-\sigma uncertainty from the direct INPOP06 fit). Following G.A. Krasinsky, E.V. Pitjeva, M.V. Vasilyev, E.I. Yagudina, 1 February 2002, 'Hidden Mass in the Asteroid Belt', Icarus, 158, 98-105, the gravitational effect of all but the 300 heaviest asteroids can be modeled as an acceleration caused by a solid ring with a certain mass (parameter :Nature:INPOP06:AsteroidRingMass_SolarMass) in the ecliptic plane at a certain barycentric distance (parameter :Nature:INPOP06:AsteroidRing_OrbitalSemiMajorAxis)        
         * <p>
         * Source: A. Fienga, J. Laskar, H. Manche, M. Gastineau, 19 April 2007, 'Solar System Planetary Ephemeris Delivery: INPOP06', GAIA-CA-TN-IMC-AF-001, issue 1, revision 0<br/>
         * Status: DEPR<br/>
         * Basic : true<br/>
         * Scalar: true
         */
        @ParamMetaData (
        description = "Uncertainty of the INPOP06 value of the ratio of the Krasinsky asteroid ring to solar mass (1-\\sigma uncertainty from the direct INPOP06 fit). Following G.A. Krasinsky, E.V. Pitjeva, M.V. Vasilyev, E.I. Yagudina, 1 February 2002, 'Hidden Mass in the Asteroid Belt', Icarus, 158, 98-105, the gravitational effect of all but the 300 heaviest asteroids can be modeled as an acceleration caused by a solid ring with a certain mass (parameter :Nature:INPOP06:AsteroidRingMass_SolarMass) in the ecliptic plane at a certain barycentric distance (parameter :Nature:INPOP06:AsteroidRing_OrbitalSemiMajorAxis)", 
         source = "A. Fienga, J. Laskar, H. Manche, M. Gastineau, 19 April 2007, 'Solar System Planetary Ephemeris Delivery: INPOP06', GAIA-CA-TN-IMC-AF-001, issue 1, revision 0", 
         status = "DEPR", 
         basic = true, 
         scalar = true, 
         unit = "") 
        public static final double ASTEROIDRINGMASS_SOLARMASSERROR; static { ASTEROIDRINGMASS_SOLARMASSERROR = 1.50e-11; } 

        /**
         * Astronomical unit (au) light time (TCB-compatible value; INPOP06 value)        
         * <p>
         * Source: A. Fienga, J. Laskar, H. Manche, M. Gastineau, 19 April 2007, 'Solar System Planetary Ephemeris Delivery: INPOP06', GAIA-CA-TN-IMC-AF-001, issue 1, revision 0<br/>
         * Status: DEPR<br/>
         * Unit: s<br/>
         * Basic : false<br/>
         * Scalar: true
         */
        @ParamMetaData (
        description = "Astronomical unit (au) light time (TCB-compatible value; INPOP06 value)", 
         source = "A. Fienga, J. Laskar, H. Manche, M. Gastineau, 19 April 2007, 'Solar System Planetary Ephemeris Delivery: INPOP06', GAIA-CA-TN-IMC-AF-001, issue 1, revision 0", 
         status = "DEPR", 
         basic = false, 
         scalar = true, 
         unit = "s") 
        public static final double ASTRONOMICALUNIT_SECOND; static { ASTRONOMICALUNIT_SECOND = 4.9900478380613566e+2; } // [s] 

        /**
         * Astronomical unit (au) length (TCB-compatible value; INPOP06 value)        
         * <p>
         * Source: A. Fienga, J. Laskar, H. Manche, M. Gastineau, 19 April 2007, 'Solar System Planetary Ephemeris Delivery: INPOP06', GAIA-CA-TN-IMC-AF-001, issue 1, revision 0<br/>
         * Status: DEPR<br/>
         * Unit: m<br/>
         * Basic : true<br/>
         * Scalar: true
         */
        @ParamMetaData (
        description = "Astronomical unit (au) length (TCB-compatible value; INPOP06 value)", 
         source = "A. Fienga, J. Laskar, H. Manche, M. Gastineau, 19 April 2007, 'Solar System Planetary Ephemeris Delivery: INPOP06', GAIA-CA-TN-IMC-AF-001, issue 1, revision 0", 
         statu