/**
* Copyright (C) 2006-2011 Gaia Data Processing and Analysis Consortium
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*             THIS IS AN AUTOMATICALLY GENERATED FILE - DO NOT EDIT!
*
*    The file has been automatically generated from the contents of the
*    Gaia Parameter Database at the URL
*        http://gaia.esac.esa.int/gpdb
*
*    Please report any problems arising from the usage of this file to
*    the Gaia Librarian gaialib@rssd.esa.int
*/
package gaia.cu1.params;

/** 
  * Wrapper class extending BasicParam. This class is intentionally empty and
  * simply provides the full functionality of BasicParam under the name 
  * GaiaParam. Users are requested to keep using GaiaParam for referencing GPDB
  * parameters as it was always done. 
  *
  * This wrapper was once designed for overloading of a small number of 
  * parameters for scientific experiments with altered Gaia configurations and
  * Nano-JASMINE. The mechanism proved to be unreliable and is therefore not
  * used anymore. The wrapping remains to avoid any kind of disturbance from a 
  * clean up action. See issue 25399 for details.
  * 
  * Daniel Michalik, 2014-04-02.
  * This applies not only to the root level of the GDPB hierarchy but also to all nested classes, 
  * defined in <code><a href="ftp://ftp.rssd.esa.int/pub/Gaia/docs/gaia-jdb-007.pdf">GAIA-JdB-007</a></code><br/>
  *
  * @author	dmichalik
  * @version 	$Id: GaiaParam.java 362146 2014-04-22 12:03:11Z ejoliet $	
  * @req CU1-GPDB-T-FUN-020
  */
final public class GaiaParam extends BasicParam {
	/*
	// Examples of how to overload parameters.	
	// Overloading of the version string:
	public static final String DBVersion = "-special-:2012-12-21T08:15:42";
	
	// Imitating the nested class structure, extending each single one of them, is required:
	public static class Nature extends BasicParam.Nature{

	    // Overloading of primitive data types.
		// Please note that run time evaluation of constants is required by issue 0007264.
		// "Pi is exactly 3" (Frink)
		public static final double PI_CONSTANT; static { PI_CONSTANT = 3.0; } 
	}

	// Deeper nested class structure:
	public static class Satellite extends BasicParam.Satellite {
		public static class AF extends BasicParam.Satellite.AF {
		    public static final int CCD_NUMBER; static { CCD_NUMBER = 42; } 
		}
		// Overloading of non primitive data types happens without the static block:
		public static final int CCD_TDIGATE_LENGTH[] = {2,  4,  8,  16,  32,  64,  128,  256,  512,  1024,  2048,  2900}; // [AL pixel]
	}
	*/
}
