/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.roe.wfau;

import javax.servlet.http.HttpSession;
import uk.ac.roe.wfau.ASASchema;
import uk.ac.roe.wfau.WSASchema;

public class ASASession {
    static final int UKIDSSTESTERCLASS = 0;
    static final int UKIDSSCLASS = 1;
    static final int WORLDCLASS = 2;
    static final int PRERELEASECLASS = 3;
    static final int NONSURVEYCLASS = 4;
    static final int VISTATESTERCLASS = 5;

    public static HttpSession setSession(HttpSession sess, boolean isPreRelease, String progID, String user, String community) {
        sess.setAttribute("asalogin", (Object)Boolean.TRUE);
        if (!ASASchema.isProprietary(community)) {
            sess.setAttribute("asauser", (Object)user.toLowerCase().trim());
        } else {
            sess.setAttribute("asauser", (Object)user.trim());
        }
        sess.setAttribute("asacommunity", (Object)community.toUpperCase());
        if (ASASchema.isProprietary(community)) {
            sess.setAttribute("asaProprietary", (Object)Boolean.TRUE);
        }
        sess.setAttribute("asaprogrammeID", (Object)progID);
        return sess;
    }

    public static String getDBUser(HttpSession sess) {
        String community = ASASession.getCommunity(sess);
        if (ASASession.getLoginBoolean(sess) && !ASASchema.isProprietary(community) && !community.equalsIgnoreCase("prerelease") && !community.equalsIgnoreCase("world")) {
            return "wsaro";
        }
        if (ASASession.getLoginBoolean(sess) && community.equalsIgnoreCase("prerelease")) {
            return "wsaro";
        }
        if (ASASession.getLoginBoolean(sess) && ASASchema.isProprietary(community)) {
            int iProgID = Integer.parseInt(ASASession.getProgID(sess));
            if (iProgID > 0 && iProgID < 1000) {
                return String.valueOf(ASASchema.getShortSurveyName(iProgID).toLowerCase()) + "ro";
            }
            return String.valueOf(ASASession.getUser(sess).toLowerCase()) + "ro";
        }
        return "worldwsaro";
    }

    public static int getSessionClass(HttpSession sess) {
        String community = ASASession.getCommunity(sess);
        if (ASASession.getLoginBoolean(sess)) {
            if (community.equalsIgnoreCase("nonsurvey") || community.equalsIgnoreCase("Proprietary") || ASASchema.isProprietary(community)) {
                return 4;
            }
            if (community.equalsIgnoreCase("prerelease")) {
                return 3;
            }
            if (community.equalsIgnoreCase("ukidsstester")) {
                return 0;
            }
            if (community.equalsIgnoreCase("vistatester")) {
                return 5;
            }
            return 1;
        }
        return 2;
    }

    public static String getProgID(HttpSession sess) {
        if (sess.getAttribute("asaprogrammeID") != null) {
            return ((String)sess.getAttribute("asaprogrammeID")).trim();
        }
        return "-999";
    }

    public static String getCommunity(HttpSession sess) {
        if (ASASession.getLoginBoolean(sess) && sess.getAttribute("asacommunity") != null) {
            String community = ((String)sess.getAttribute("asacommunity")).toLowerCase().trim();
            if (community != null) {
                return community;
            }
            return "world";
        }
        return "world";
    }

    public static String getMaskedCommunity(HttpSession sess) {
        if (ASASession.getLoginBoolean(sess) && sess.getAttribute("asacommunity") != null) {
            String community = ((String)sess.getAttribute("asacommunity")).toLowerCase().trim().replaceFirst("asa::".toLowerCase(), "");
            if (community != null) {
                return community;
            }
            return "world";
        }
        return "world";
    }

    public static String[] getNonSurveyDBName(HttpSession sess) {
        String[] nsDBs = null;
        if (sess.getAttribute("asareleasedDBs") != null) {
            nsDBs = (String[])sess.getAttribute("asareleasedDBs");
        } else if (sess.getAttribute("asadbName") != null && !((String)sess.getAttribute("asadbName")).toLowerCase().trim().equalsIgnoreCase("na")) {
            String[] dbName = new String[]{ASASession.getUser(sess)};
            nsDBs = dbName;
        }
        return nsDBs;
    }

    public static String getUser(HttpSession sess) {
        return ASASession.getUser(sess, false);
    }

    public static String getUser(HttpSession sess, boolean generic) {
        if (ASASession.getLoginBoolean(sess)) {
            if (!generic) {
                if (sess.getAttribute("asauser") != null) {
                    return ((String)sess.getAttribute("asauser")).toLowerCase().trim();
                }
                return "public";
            }
            int iProgID = Integer.parseInt(ASASession.getProgID(sess));
            if (iProgID > 0 && iProgID < 1000 && ASASchema.getShortSurveyName(iProgID) != null) {
                return ASASchema.getShortSurveyName(iProgID);
            }
            return ((String)sess.getAttribute("asauser")).toLowerCase().trim();
        }
        return "public";
    }

    public static String[] getDB(HttpSession sess, int progID) {
        return ASASession.getDB(sess, progID, false);
    }

    public static String[] getDB(HttpSession sess, int progID, boolean doRollingDB) {
        return ASASession.getDB(sess, progID, doRollingDB, true);
    }

    public static String[] getDB(HttpSession sess, int progID, boolean doRollingDB, boolean includeExtraDB) {
        return ASASession.getDB(sess, progID, doRollingDB, includeExtraDB, false);
    }

    public static String[] getDB(HttpSession sess, int progID, boolean doRollingDB, boolean includeExtraDB, boolean includeMoreDB) {
        String[] DB;
        int sessClass = ASASession.getSessionClass(sess);
        switch (sessClass) {
            case 2: {
                DB = ASASchema.getDBs(progID, true);
                if (!includeMoreDB) break;
                DB = ASASchema.getDBsPlusExtraDB(DB, WSASchema.moreDB);
                break;
            }
            case 1: {
                if (doRollingDB && progID != 0) {
                    DB = ASASchema.getDBsPlusRollingDB(ASASchema.getDBs(progID, false));
                    break;
                }
                DB = ASASchema.getDBs(progID, false);
                break;
            }
            case 4: {
                String[] nsdbs = ASASession.getNonSurveyDBName(sess);
                DB = doRollingDB ? (ASASession.getNonSurveyDBName(sess) != null ? ASASchema.getDBsPlusRollingDB(ASASession.getNonSurveyDBName(sess)) : new String[]{"ASA_DailySync"}) : (ASASession.getNonSurveyDBName(sess) != null ? ASASession.getNonSurveyDBName(sess) : new String[]{"sorry no access"});
                if (!includeExtraDB) break;
                DB = ASASchema.getDBsPlusExtraDB(DB, ASASchema.extraDB);
                break;
            }
            case 5: {
                DB = doRollingDB ? ASASchema.getDBsPlusRollingDB(ASASchema.getDBs(progID, false)) : ASASchema.getDBs(progID, false);
                if (includeExtraDB) {
                    DB = WSASchema.getDBsPlusExtraDB(DB, WSASchema.extraDB);
                }
                if (!includeMoreDB) break;
                DB = WSASchema.getDBsPlusExtraDB(DB, WSASchema.moreDB);
                break;
            }
            case 0: {
                DB = doRollingDB ? ASASchema.getDBsPlusRollingDB(ASASchema.getDBs(progID, false)) : ASASchema.getDBs(progID, false);
                if (!includeExtraDB) break;
                DB = WSASchema.getDBsPlusExtraDB(DB, WSASchema.extraDB);
                break;
            }
            case 3: {
                DB = ASASchema.PRERELEASEDB;
                break;
            }
            default: {
                DB = ASASchema.getDBs(progID, true);
            }
        }
        return DB;
    }

    public static int[] getProgs(HttpSession sess) {
        int[] progs;
        int sessClass = ASASession.getSessionClass(sess);
        switch (sessClass) {
            case 2: {
                progs = ASASchema.OMEGAPROGS;
                break;
            }
            case 1: {
                progs = ASASchema.OMEGAPROGS;
                break;
            }
            case 4: {
                progs = new int[]{};
                break;
            }
            case 0: {
                progs = ASASchema.OMEGAPROGS;
                break;
            }
            case 5: {
                progs = ASASchema.OMEGATESTERPROGS;
                break;
            }
            case 3: {
                progs = ASASchema.OMEGATESTERPROGS;
                break;
            }
            default: {
                progs = ASASchema.OMEGAPROGS;
            }
        }
        return progs;
    }

    public static String getSchemaVersion(HttpSession sess) {
        if (sess.getAttribute("asaschemaVersion") != null) {
            String schemaVersion = ((String)sess.getAttribute("asaschemaVersion")).toLowerCase().trim();
            if (schemaVersion != null) {
                return schemaVersion;
            }
            return "null";
        }
        return "null";
    }

    public static boolean getProprietaryBoolean(HttpSession sess) {
        if (sess.getAttribute("asaProprietary") != null) {
            return (Boolean)sess.getAttribute("asaProprietary");
        }
        return false;
    }

    public static boolean getSourceBoolean(HttpSession sess) {
        if (sess.getAttribute("asasource") != null) {
            return (Boolean)sess.getAttribute("asasource");
        }
        return false;
    }

    public static int[] getReqFilters(HttpSession sess) {
        try {
            return (int[])sess.getAttribute("asareqFilters");
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean getLoginBoolean(HttpSession sess) {
        if (sess.getAttribute("asalogin") != null) {
            try {
                return (Boolean)sess.getAttribute("asalogin");
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public static String getDefaultList(HttpSession sess, String table, String database, int progID) {
        if (database == null) {
            if (ASASession.getCommunity(sess).equalsIgnoreCase("nonsurvey")) {
                return WSASchema.getDefaultList(ASASession.getReqFilters(sess), table, ASASession.getSchemaVersion(sess));
            }
            if (ASASession.getLoginBoolean(sess)) {
                return WSASchema.getDefaultList(WSASchema.getReqFilters(progID), table, WSASchema.LATESTUKIDSSSCHEMA);
            }
            return WSASchema.getDefaultList(WSASchema.getReqFilters(progID), table, WSASchema.LATESTWORLDSCHEMA);
        }
        if (ASASession.getCommunity(sess).equalsIgnoreCase("nonsurvey")) {
            return WSASchema.getDefaultList(ASASession.getReqFilters(sess), table, ASASession.getSchemaVersion(sess));
        }
        if (ASASession.getLoginBoolean(sess)) {
            return WSASchema.getDefaultList(WSASchema.getReqFilters(progID), table, database);
        }
        return WSASchema.getDefaultList(WSASchema.getReqFilters(progID), table, database);
    }
}

