/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.roe.wfau;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Random;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import uk.ac.roe.wfau.DatabaseURL;
import uk.ac.roe.wfau.OSASession;
import uk.ac.roe.wfau.VDFSSession;
import uk.ac.roe.wfau.VSASession;
import uk.ac.roe.wfau.WSASession;
import uk.ac.roe.wfau.stack2string;

public class DatabaseConnection {
    static Logger logger = Logger.getLogger((String)"wsa.simple");
    public static Random rand;

    static {
        try {
            Class.forName("com.microsoft.jdbc.sqlserver.SQLServerDriver");
            Class.forName("net.sourceforge.jtds.jdbc.Driver");
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)("ImageList,SQLRetrieverThread::static(): Could not load SQLServerDriver class! " + stack2string.getString(e)));
        }
        rand = new Random();
    }

    public static Connection getConnection(String[] servers, String database, String archive, HttpSession sess) {
        return DatabaseConnection.getConnection(false, servers, database, archive, sess, null);
    }

    public static Connection getConnection(String[] servers, String database, String dbUser, String dbPasswd, String startServer) {
        return DatabaseConnection.getConnection(false, servers, database, dbUser, dbPasswd, startServer);
    }

    public static Connection getConnection(boolean serverSupplied, String[] servers, String database, String dbUser, String dbPasswd, String startServer) {
        int i;
        Object conn = null;
        if (!serverSupplied) {
            String[] vvvServers;
            if (database.toLowerCase().startsWith("vvvdr1") || database.toLowerCase().startsWith("vvvdr2") || database.toLowerCase().startsWith("vvvv20110928")) {
                vvvServers = new String[]{"ramses13"};
                servers = vvvServers;
            } else if (database.toLowerCase().startsWith("vvvdr4")) {
                vvvServers = new String[]{"ramses14"};
                servers = vvvServers;
            } else if (database.toLowerCase().startsWith("vvvdr5")) {
                vvvServers = new String[]{"ramses20"};
                servers = vvvServers;
            } else if (database.toLowerCase().startsWith("vvv") && !database.toLowerCase().startsWith("vvvx")) {
                vvvServers = new String[]{"ramses10"};
                servers = vvvServers;
            }
        }
        int noOfServers = servers.length;
        int server = rand.nextInt(noOfServers);
        if (startServer != null) {
            i = 0;
            while (i < noOfServers) {
                if (servers[i].equalsIgnoreCase(startServer)) {
                    server = i;
                }
                ++i;
            }
        }
        i = 0;
        while (i < noOfServers) {
            if ((server += i) >= noOfServers) {
                server = 0;
            }
            try {
                Connection connection = DriverManager.getConnection(DatabaseURL.getDatabaseURL(servers[server], database, dbUser, dbPasswd, true));
                return connection;
            }
            catch (SQLException se) {
                logger.error((Object)("databaseConnection ERROR " + se + " " + servers[server] + " " + database + " " + dbUser));
            }
            finally {
                logger.info((Object)("DBCONN_DBURL: " + DatabaseURL.getDatabaseURL(servers[server], database, dbUser, dbPasswd, true)));
            }
            ++i;
        }
        return null;
    }

    public static Connection getConnection(String[] servers, String database, String archive, HttpSession sess, String startServer) {
        return DatabaseConnection.getConnection(false, servers, database, archive, sess, startServer, false);
    }

    public static Connection getConnection(boolean serverSupplied, String[] servers, String database, String archive, HttpSession sess, String startServer) {
        return DatabaseConnection.getConnection(serverSupplied, servers, database, archive, sess, startServer, false);
    }

    public static Connection getConnection(boolean serverSupplied, String[] servers, String database, String archive, HttpSession sess, String startServer, boolean overideLoginForLoadServer) {
        String dbUser = null;
        dbUser = VDFSSession.getDBUser(sess, archive);
        if (dbUser.equals("uhsro") && !database.toLowerCase().contains("uhs")) {
            dbUser = "worldwsaro";
        }
        String dbPasswd = String.valueOf(dbUser) + "pw";
        if (!WSASession.getCommunity(sess).equalsIgnoreCase("prerelease") && database.equalsIgnoreCase("WSA") && VDFSSession.getLoginBoolean(sess, archive)) {
            dbUser = "wsaro";
            dbPasswd = "wsaropw";
            database = "WFCAMPROPRIETY";
        } else if (!VSASession.getCommunity(sess).equalsIgnoreCase("prerelease") && database.equalsIgnoreCase("VISTAPROPRIETY") && VDFSSession.getLoginBoolean(sess, archive)) {
            dbUser = "wsaro";
            dbPasswd = "wsaropw";
            database = "VISTAPROPRIETY";
        } else if (!OSASession.getCommunity(sess).equalsIgnoreCase("prerelease") && database.equalsIgnoreCase("OSAPROPRIETY") && VDFSSession.getLoginBoolean(sess, archive)) {
            dbUser = "wsaro";
            dbPasswd = "wsaropw";
            database = "OSAPROPRIETY";
        }
        if (servers[0].equalsIgnoreCase("ramses14") && database.equalsIgnoreCase("VSA")) {
            database = "VSAVVV";
        }
        return DatabaseConnection.getConnection(serverSupplied, servers, database, dbUser, dbPasswd, startServer);
    }

    public static void main(String[] args) {
        String[] servers = new String[]{"ramses1", "ramses2"};
        int i = 0;
        while (i < 100) {
            DatabaseConnection.getConnection(servers, null, null, null);
            ++i;
        }
    }
}

