/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.roe.wfau;

import java.text.BreakIterator;
import java.util.Locale;

public class FormatLines {
    int maxLength;
    int strLength;
    int returnP;
    String strToFormat;
    public int startP = 0;
    int lastGood = 0;

    public FormatLines(String strToFormat, int maxLength) {
        this.maxLength = maxLength;
        this.strToFormat = strToFormat;
        this.strLength = strToFormat.length();
    }

    public String getLine() {
        this.returnP = this.startP;
        if (this.startP + this.maxLength > this.strLength) {
            this.startP = -1;
            return this.strToFormat.substring(this.returnP);
        }
        int i = this.startP;
        while (i < this.startP + this.maxLength) {
            if (this.strToFormat.charAt(i) == ' ' || this.strToFormat.charAt(i) == ',') {
                this.lastGood = i;
            }
            ++i;
        }
        if (this.lastGood <= this.startP) {
            this.lastGood = this.startP + this.maxLength - 1;
        }
        this.startP = this.lastGood + 1;
        return this.strToFormat.substring(this.returnP, this.lastGood + 1);
    }

    public static void formatLines(String target, int maxLength, Locale currentLocale) {
        BreakIterator boundary = BreakIterator.getLineInstance(currentLocale);
        boundary.setText(target);
        int start = boundary.first();
        int end = boundary.next();
        int lineLength = 0;
        while (end != -1) {
            String word = target.substring(start, end);
            if ((lineLength += word.length()) >= maxLength) {
                lineLength = word.length();
            }
            start = end;
            end = boundary.next();
        }
    }

    public static String[] commaSeparatedStringToStringArray(String aString) {
        if (aString != null & aString.length() == 0) {
            String[] splittArray = new String[]{};
            return splittArray;
        }
        String[] splittArray = null;
        if (aString != null || !aString.equalsIgnoreCase("")) {
            splittArray = aString.trim().split(",");
        }
        return splittArray;
    }

    public static int[] commaSeparatedStringToIntArray(String aString) {
        String[] splittArray = null;
        if (aString == null && aString.equalsIgnoreCase("")) {
            return null;
        }
        splittArray = aString.trim().split(",");
        int[] iArray = new int[splittArray.length];
        int i = 0;
        while (i < splittArray.length) {
            iArray[i] = Integer.parseInt(splittArray[i]);
            ++i;
        }
        return iArray;
    }
}

