/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.roe.wfau;

import java.io.FileInputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import javax.servlet.http.HttpSession;
import uk.ac.roe.wfau.LoadGESProperties;
import uk.ac.roe.wfau.WSASchema;
import uk.ac.roe.wfau.WSASession;

public class GESSchema
extends WSASchema {
    public static String[] CUSERVER = new String[]{"ramses1"};
    public static String[] WORLDGESDB;
    public static String[] EQUIVWORLDGESDB;
    public static String[] GESDB;
    public static String[] BETAGESDB;
    public static String[] WORLDCOMMDB;
    public static String[] WORLDVHSDB;
    public static String[] WORLDVVVDB;
    public static String[] WORLDVMCDB;
    public static String[] WORLDVIKINGDB;
    public static String[] WORLDVIDEODB;
    public static String[] WORLDULTRAVISTADB;
    public static String[] WORLDSVORIONDB;
    public static String[] WORLDSVNGC253DB;
    public static String[] WORLDCALDB;
    public static String[] WORLDGCSDB;
    public static String GESCOMMUNITYPREFIX;
    public static String[] EQUIVWORLDCOMMDB;
    public static String[] EQUIVWORLDVHSDB;
    public static String[] EQUIVWORLDVVVDB;
    public static String[] EQUIVWORLDVMCDB;
    public static String[] EQUIVWORLDVIKINGDB;
    public static String[] EQUIVWORLDVIDEODB;
    public static String[] EQUIVWORLDULTRAVISTADB;
    public static String[] EQUIVWORLDSVORIONDB;
    public static String[] EQUIVWORLDSVNGC253DB;
    public static String[] EQUIVWORLDCALDB;
    public static String[] EQUIVWORLDGCSDB;
    public static final String LATESTUKIDSSDATABASE = "ukidssdr5plus";
    public static final String LATESTWORLDDATABASE = "ukidssdr3plus";
    public static final String[] SCEHMAVALIDDATABASES;
    public static final String LATESTUKIDSSSCHEMA = "ukidssdr5plus";
    public static final String LATESTWORLDSCHEMA = "ukidssdr3plus";
    public static final String LATESTNONSURVEYSCHEMA = "ukidssr2";
    public static final String PRERELEASESERVER = "ramses1";
    public static final String PRERELEASEDATABASE = "GES";
    public static final String PRERELEASECOMMUNITY = "prerelease";
    public static final String NONSURVEYCOMMUNITY = "nonSurvey";
    public static final String PROPRIETARYCOMMUNITY = "Proprietary";
    public static final String SESSIONPROPRIETARYCOMMUNITY = "gesProprietary";
    public static String NODBAVAILABLE;
    public static String[] COMMDB;
    public static String[] VHSDB;
    public static String[] VVVDB;
    public static String[] VMCDB;
    public static String[] VIKINGDB;
    public static String[] VIDEODB;
    public static String[] ULTRAVISTADB;
    public static String[] SVORIONDB;
    public static String[] SVNGC253DB;
    public static String[] CALDB;
    public static String[] GCSDB;
    public static String[] SURVEYACRONYMS;
    public static int GESVERISONSCHEMA;
    public static int COMMVERISONSCHEMA;
    public static int VHSVERISONSCHEMA;
    public static int VVVVERISONSCHEMA;
    public static int VMCVERISONSCHEMA;
    public static int VIKINGVERISONSCHEMA;
    public static int VIDEOVERISONSCHEMA;
    public static int ULTRAVISTAVERISONSCHEMA;
    public static int SVORIONVERISONSCHEMA;
    public static int SVNGC253VERISONSCHEMA;
    public static int CALVERSIONSCHEMA;
    public static String ASTROANALYSISWG13;
    public static String GIRAFFEASTROANALYSISWG10;
    public static String GIRAFFEASTROANALYSISWG12;
    public static String UVESASTROANALYSISWG11;
    public static String UVESASTROANALYSISWG12;
    public static String SINGLESPEC;
    public static String MANYSPEC;
    public static final String[] ALLUKIDSSRDB;
    public static final int[] UKIDSSVERSIONS;
    public static final String[] UKIDSSTESTERDB;
    public static final int VERSIONOFSOURCEVIEWS = 99;
    public static final String PTSDB = "Transit";
    public static final String OPENDB = "WFCAMOPENTIME";
    public static final String[] extraDB;
    public static final String[] moreDB;
    public static final boolean doExtraDB = true;
    public static final String[] UKIDSSDB;
    public static final String[] WORLDDB;
    public static final int[] WORLDVERSIONS;
    public static final String[] PRERELEASEDB;
    public static final boolean accessToRollingDB = true;
    public static final String rollingDB = "GES_DailySync";
    public static final String actualRollingDB = "GESPROPRIETY";
    public static final String prevRollingDB = "GES_DailySync";
    public static final String prevActualRollingDB = "GESPROPRIETY";
    public static final String[] rollingDBs;
    public static final String[] actualRollingDBs;
    public static final String rollingServer = "amenhotep";
    public static final String rollingDBUser = "wsaro";
    public static final String rollingDBPasswd = "wsaropw";
    public static final String noAccessDB = "sorry no access";
    public static final int COMMISSIONINGPROGRAMMEID = 1;
    public static final int CURATIONTESTPROGRAMMEID = 99;
    public static final int ALLPROGRAMMEID = 0;
    public static final int GESPROGRAMMEID = 75;
    public static final int VHSPROGRAMMEID = 110;
    public static final int VVVPROGRAMMEID = 120;
    public static final int VMCPROGRAMMEID = 130;
    public static final int VIKINGPROGRAMMEID = 140;
    public static final int VIDEOPROGRAMMEID = 150;
    public static final int ULTRAVISTAPROGRAMMEID = 160;
    public static final int SVORIONPROGRAMMEID = 100;
    public static final int SVNGC253PROGRAMMEID = 101;
    public static final int CALPROGRAMMEID = 200;
    public static final String ALLSURVEYS = "All GES surveys";
    public static final int MAXIMUMROWSTOFILE = 15000000;
    public static int FITS_OFFSET;
    public static final int VISTANONEFILTERID = 0;
    public static final int VISTAZFILTERID = 1;
    public static final int VISTAYFILTERID = 2;
    public static final int VISTAJFILTERID = 3;
    public static final int VISTAHFILTERID = 4;
    public static final int VISTAKFILTERID = 5;
    public static final int VISTAH2FILTERID = 6;
    public static final int VISTABRFILTERID = 7;
    public static final int VISTABLANKFILTERID = 8;
    public static final int VISTANB118FILTERID = 9;
    public static final int VISTANB980985FILTERID = 10;
    public static final int VISTANSUNBLINDFILTERID = 11;
    public static final int[] ALLFILTERID;
    public static final int[] UKIDSSTESTERPROGS;
    public static final int[] UKIDSSPROGS;
    public static final int[] WORLDPROGS;
    public static final int[] PRERELEASEPROGS;
    public static final int[] VISTAPROGS;
    public static final int[] GESPROGS;
    public static final int[] VISTATESTERPROGS;
    public static final int[] GESTESTERPROGS;
    public static final String GESDETECTIONTABLENAME = "gesDetection";
    public static final String COMMDETECTIONTABLENAME = "commDetection";
    public static final String VHSDETECTIONTABLENAME = "vhsDetection";
    public static final String VVVDETECTIONTABLENAME = "vvvDetection";
    public static final String VMCDETECTIONTABLENAME = "vmcDetection";
    public static final String VIKINGDETECTIONTABLENAME = "vikingDetection";
    public static final String VIDEODETECTIONTABLENAME = "videoDetection";
    public static final String ULTRAVISTADETECTIONTABLENAME = "ultravistaDetection";
    public static final String SVORIONDETECTIONTABLENAME = "svOrionDetection";
    public static final String SVNGC253DETECTIONTABLENAME = "svNgc253Detection";
    public static final String CALDETECTIONTABLENAME = "calDetection";
    public static final String GESSOURCETABLENAME = "gesSource";
    public static final String COMMSOURCETABLENAME = "commSource";
    public static final String VHSSOURCETABLENAME = "vhsSource";
    public static final String VVVSOURCETABLENAME = "vvvSource";
    public static final String VMCSOURCETABLENAME = "vmcSource";
    public static final String VIKINGSOURCETABLENAME = "vikingSource";
    public static final String VIDEOSOURCETABLENAME = "videoSource";
    public static final String ULTRAVISTASOURCETABLENAME = "ultravistaSource";
    public static final String SVORIONSOURCETABLENAME = "svOrionSource";
    public static final String SVNGC253SOURCETABLENAME = "svNgc253Source";
    public static final String CALSOURCETABLENAME = "NONE";
    public static final String GESSOURCEVIEWNAME = "undef";
    public static final String COMMSOURCEVIEWNAME = "undef";
    public static final String VHSSOURCEVIEWNAME = "undef";
    public static final String VVVSOURCEVIEWNAME = "undef";
    public static final String VMCSOURCEVIEWNAME = "undef";
    public static final String VIKINGSOURCEVIEWNAME = "undef";
    public static final String VIDEOSOURCEVIEWNAME = "undef";
    public static final String ULTRAVISTASOURCEVIEWNAME = "undef";
    public static final String SVORIONSOURCEVIEWNAME = "undef";
    public static final String SVNGC253SOURCEVIEWNAME = "undef";
    public static final String CALSOURCEVIEWNAME = "undef";
    public static final String UKIDSSLASSOURCEVIEWNAME = "lasYJHKsource";
    public static final String UKIDSSGPSSOURCEVIEWNAME = "gpsJHKsource";
    public static final String UKIDSSGCSSOURCEVIEWNAME = "gcsZYJHKsource";
    public static final String UKIDSSDXSSOURCEVIEWNAME = "dxsJKSource";
    public static final String UKIDSSUDSSOURCEVIEWNAME;
    public static final String PTSSOURCETABLENAME = "NONE";
    public static final String COMMISSIONINGMERGETABLENAME = "commMergeLog";
    public static final String UKIDSSLASMERGETABLENAME = "lasMergeLog";
    public static final String UKIDSSGPSMERGETABLENAME = "gpsMergeLog";
    public static final String UKIDSSGCSMERGETABLENAME = "gcsMergeLog";
    public static final String UKIDSSDXSMERGETABLENAME = "dxsMergeLog";
    public static final String UKIDSSUDSMERGETABLENAME = "udsMergeLog";
    public static final String UKIDSSPTSMERGETABLENAME = "NONE";
    public static final String GESMERGETABLENAME = "gesMergeLog";
    public static final String VHSMERGETABLENAME = "vhsMergeLog";
    public static final String VVVMERGETABLENAME = "vvvMergeLog";
    public static final String VMCMERGETABLENAME = "vmcMergeLog";
    public static final String VIKINGMERGETABLENAME = "vikingMergeLog";
    public static final String VIDEOMERGETABLENAME = "videoMergeLog";
    public static final String ULTRAVISTAMERGETABLENAME = "ultravistaMergeLog";
    public static final String SVORIONMERGETABLENAME = "svOrionMergeLog";
    public static final String SVNGC253MERGETABLENAME = "svNgc253MergeLog";
    public static final String DEFAULTSQLSERVER = "ramses5";
    public static final String UKIDSSLOGIN = "wsaro";
    public static final String WORLDLOGIN = "worldwsaro";
    public static final String[] WFCAMFILTERS;
    public static final String[] VISTAFILTERS;
    public static final String[] filters;
    public static final String[] COMMISSIONINGBands;
    public static final int[] COMMISSIONINGREQFILTERS;
    public static final int[] SVORIONREQFILTERS;
    public static final int[] SVNGC253REQFILTERS;
    public static final int[] VHSREQFILTERS;
    public static final int[] VVVREQFILTERS;
    public static final int[] VMCREQFILTERS;
    public static final int[] VIKINGREQFILTERS;
    public static final int[] VIDEOREQFILTERS;
    public static final int[] ULTRAVISTAREQFILTERS;
    public static final int[] CALREQFILTERS;
    public static final int[] GESREQFILTERS;
    public static final String[] LASRGB;
    public static final String[] GPSRGB;
    public static final String[] GCSRGB;
    public static final String[] DXSRGB;
    public static final String[] UDSRGB;
    public static final String[] VHSRGB;
    public static final String[] VVVRGB;
    public static final String[] VHSBands;
    public static final String[] VVVBands;
    public static final String[] LASBands;
    public static final int[] LASREQFILTERS;
    public static final String[] GPSBands;
    public static final int[] GPSREQFILTERS;
    public static final int[] GPSREQFILTERSDR2;
    public static final String[] GCSBands;
    public static final int[] GCSREQFILTERS;
    public static final String[] DXSBands;
    public static final int[] DXSREQFILTERS;
    public static final String[] UDSBands;
    public static final int[] UDSREQFILTERS;

    static {
        GESDB = new String[0];
        BETAGESDB = new String[0];
        GESCOMMUNITYPREFIX = "ges::";
        LoadGESProperties.getSingletonObject();
        SCEHMAVALIDDATABASES = new String[]{"ukidssdr5plus", "ukidssdr4plus", "ukidssdr3plus"};
        NODBAVAILABLE = "No database available";
        COMMDB = new String[0];
        VHSDB = new String[0];
        VVVDB = new String[0];
        VMCDB = new String[0];
        VIKINGDB = new String[0];
        VIDEODB = new String[0];
        ULTRAVISTADB = new String[0];
        SVORIONDB = new String[0];
        SVNGC253DB = new String[0];
        CALDB = new String[0];
        GCSDB = new String[]{"UKIDSSDR5PLUS", "UKIDSSDR3PLUS", "UKIDSSDR2PLUS"};
        SURVEYACRONYMS = new String[]{PRERELEASEDATABASE};
        GESVERISONSCHEMA = 0;
        COMMVERISONSCHEMA = 0;
        VHSVERISONSCHEMA = 0;
        VVVVERISONSCHEMA = 0;
        VMCVERISONSCHEMA = 0;
        VIKINGVERISONSCHEMA = 0;
        VIDEOVERISONSCHEMA = 0;
        ULTRAVISTAVERISONSCHEMA = 0;
        SVORIONVERISONSCHEMA = 0;
        SVNGC253VERISONSCHEMA = 0;
        CALVERSIONSCHEMA = 0;
        ASTROANALYSISWG13 = "AstroAnalysisWG13";
        GIRAFFEASTROANALYSISWG10 = "GiraffeAstroAnalysisWG10";
        GIRAFFEASTROANALYSISWG12 = "GiraffeAstroAnalysisWG12";
        UVESASTROANALYSISWG11 = "UvesAstroAnalysisWG11";
        UVESASTROANALYSISWG12 = "UvesAstroAnalysisWG12";
        SINGLESPEC = "SingleSpec";
        MANYSPEC = "ManySpec";
        ALLUKIDSSRDB = new String[]{"UKIDSSDR5PLUS", "UKIDSSDR4PLUS", "UKIDSSDR3PLUS", "UKIDSSDR2PLUS", "UKIDSSDR1PLUS", "UKIDSSDR1", "UKIDSSEDRPLUS", "UKIDSSEDR", "UKIDSSSV", "UKIDSSR1"};
        int[] nArray = new int[10];
        nArray[0] = 7;
        nArray[1] = 6;
        nArray[2] = 5;
        nArray[3] = 4;
        nArray[4] = 3;
        nArray[5] = 3;
        nArray[6] = 2;
        nArray[7] = 2;
        nArray[8] = 1;
        UKIDSSVERSIONS = nArray;
        UKIDSSTESTERDB = ALLUKIDSSRDB;
        extraDB = new String[]{PRERELEASEDATABASE};
        moreDB = new String[]{OPENDB};
        UKIDSSDB = new String[]{"UKIDSSDR5PLUS", "UKIDSSDR4PLUS", "UKIDSSDR3PLUS", "UKIDSSDR2PLUS", "UKIDSSDR1PLUS", "UKIDSSDR1", "UKIDSSEDRPLUS", "UKIDSSEDR", "UKIDSSSV"};
        WORLDDB = new String[]{"UKIDSSDR3PLUS", "UKIDSSDR2PLUS", "UKIDSSDR1PLUS", "UKIDSSDR1", "UKIDSSEDRPLUS", "UKIDSSEDR", "UKIDSSSV"};
        WORLDVERSIONS = new int[]{5, 4, 3, 3, 2, 2, 1};
        PRERELEASEDB = new String[]{PRERELEASEDATABASE};
        rollingDBs = new String[]{"GES_DailySync", "GES_DailySync"};
        actualRollingDBs = new String[]{"GESPROPRIETY", "GESPROPRIETY"};
        FITS_OFFSET = 1;
        int[] nArray2 = new int[10];
        nArray2[1] = 1;
        nArray2[2] = 2;
        nArray2[3] = 3;
        nArray2[4] = 4;
        nArray2[5] = 5;
        nArray2[6] = 8;
        nArray2[7] = 9;
        nArray2[8] = 10;
        nArray2[9] = 11;
        ALLFILTERID = nArray2;
        UKIDSSTESTERPROGS = new int[]{101, 102, 103, 104, 105, 11, 12, 13, 14, 15, 1};
        UKIDSSPROGS = new int[]{101, 102, 103, 104, 105};
        WORLDPROGS = UKIDSSPROGS;
        PRERELEASEPROGS = UKIDSSTESTERPROGS;
        VISTAPROGS = new int[]{110, 120, 130, 140, 150, 160, 200};
        GESPROGS = new int[]{75};
        VISTATESTERPROGS = new int[VISTAPROGS.length + 1];
        GESTESTERPROGS = GESPROGS;
        GESSchema.VISTATESTERPROGS[0] = 1;
        int i = 0;
        while (i < VISTAPROGS.length) {
            GESSchema.VISTATESTERPROGS[i + 1] = VISTAPROGS[i];
            ++i;
        }
        UKIDSSUDSSOURCEVIEWNAME = null;
        WFCAMFILTERS = new String[]{"NONE", "Z", "Y", "J", "H", "K", "H2", "Br", "BLNK", "NBJ", "NBH", "NBK"};
        VISTAFILTERS = new String[]{"NONE", "Z", "Y", "J", "H", "Ks", "H2", "Br", "BLNK", "NB118", "NB980", "SUNBLIND"};
        filters = WFCAMFILTERS;
        COMMISSIONINGBands = new String[]{"Z", "Y", "J", "H", "K", "H2", "Br"};
        int[] nArray3 = new int[10];
        nArray3[1] = 1;
        nArray3[2] = 1;
        nArray3[3] = 1;
        nArray3[4] = 1;
        nArray3[5] = 1;
        nArray3[9] = 1;
        COMMISSIONINGREQFILTERS = nArray3;
        int[] nArray4 = new int[10];
        nArray4[1] = 1;
        nArray4[2] = 1;
        nArray4[3] = 1;
        nArray4[4] = 1;
        nArray4[5] = 1;
        SVORIONREQFILTERS = nArray4;
        int[] nArray5 = new int[10];
        nArray5[1] = 1;
        nArray5[3] = 1;
        nArray5[9] = 1;
        SVNGC253REQFILTERS = nArray5;
        int[] nArray6 = new int[10];
        nArray6[2] = 1;
        nArray6[3] = 1;
        nArray6[4] = 1;
        nArray6[5] = 1;
        VHSREQFILTERS = nArray6;
        int[] nArray7 = new int[10];
        nArray7[1] = 1;
        nArray7[2] = 1;
        nArray7[3] = 1;
        nArray7[4] = 1;
        nArray7[5] = 1;
        VVVREQFILTERS = nArray7;
        int[] nArray8 = new int[10];
        nArray8[2] = 1;
        nArray8[3] = 1;
        nArray8[5] = 1;
        VMCREQFILTERS = nArray8;
        int[] nArray9 = new int[10];
        nArray9[1] = 1;
        nArray9[2] = 1;
        nArray9[3] = 1;
        nArray9[4] = 1;
        nArray9[5] = 1;
        VIKINGREQFILTERS = nArray9;
        int[] nArray10 = new int[10];
        nArray10[1] = 1;
        nArray10[2] = 1;
        nArray10[3] = 1;
        nArray10[4] = 1;
        nArray10[5] = 1;
        VIDEOREQFILTERS = nArray10;
        int[] nArray11 = new int[10];
        nArray11[1] = 1;
        nArray11[2] = 1;
        nArray11[3] = 1;
        nArray11[4] = 1;
        nArray11[5] = 1;
        ULTRAVISTAREQFILTERS = nArray11;
        int[] nArray12 = new int[10];
        nArray12[1] = 1;
        nArray12[2] = 1;
        nArray12[3] = 1;
        nArray12[4] = 1;
        nArray12[5] = 1;
        nArray12[9] = 1;
        CALREQFILTERS = nArray12;
        int[] nArray13 = new int[10];
        nArray13[1] = 1;
        nArray13[2] = 1;
        nArray13[3] = 1;
        nArray13[4] = 1;
        nArray13[5] = 1;
        nArray13[9] = 1;
        GESREQFILTERS = nArray13;
        LASRGB = new String[]{"K", "H", "Y"};
        GPSRGB = new String[]{"K", "H", "J"};
        GCSRGB = new String[]{"K", "H", "Z"};
        DXSRGB = new String[]{"K", "H", "J"};
        UDSRGB = new String[]{"K", "H", "J"};
        VHSRGB = new String[]{"K", "H", "Y"};
        VVVRGB = new String[]{"Ks", "H", "J"};
        VHSBands = new String[]{"Y", "J", "H", "K"};
        VVVBands = new String[]{"Z", "Y", "J", "H", "Ks"};
        LASBands = new String[]{"Y", "J_1", "J_2", "H", "K"};
        int[] nArray14 = new int[9];
        nArray14[2] = 1;
        nArray14[3] = 2;
        nArray14[4] = 1;
        nArray14[5] = 1;
        LASREQFILTERS = nArray14;
        GPSBands = new String[]{"J", "H", "K_1", "K_2", "H2"};
        int[] nArray15 = new int[9];
        nArray15[3] = 1;
        nArray15[4] = 1;
        nArray15[5] = 2;
        nArray15[6] = 1;
        GPSREQFILTERS = nArray15;
        int[] nArray16 = new int[8];
        nArray16[2] = 1;
        nArray16[3] = 1;
        nArray16[4] = 3;
        nArray16[5] = 3;
        GPSREQFILTERSDR2 = nArray16;
        GCSBands = new String[]{"Z", "Y", "J", "H", "K_1", "K_2"};
        int[] nArray17 = new int[9];
        nArray17[1] = 1;
        nArray17[2] = 1;
        nArray17[3] = 1;
        nArray17[4] = 1;
        nArray17[5] = 2;
        GCSREQFILTERS = nArray17;
        DXSBands = new String[]{"J", "H", "K"};
        int[] nArray18 = new int[9];
        nArray18[3] = 1;
        nArray18[4] = 1;
        nArray18[5] = 1;
        DXSREQFILTERS = nArray18;
        UDSBands = new String[]{"J", "H", "K"};
        int[] nArray19 = new int[9];
        nArray19[3] = 1;
        nArray19[4] = 1;
        nArray19[5] = 1;
        UDSREQFILTERS = nArray19;
    }

    public static String getPropertyFromFile(String property, String filename) {
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(filename));
            if (properties.getProperty(property) != null) {
                return properties.getProperty(property);
            }
            return "";
        }
        catch (IOException e) {
            return "";
        }
    }

    public static boolean getDoRollingDBFromFile(String filename) {
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(filename));
            return properties.getProperty("doRollingDB").equalsIgnoreCase("true");
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean isProgInDB(String db, int prog) {
        return GESSchema.getVersionNoOfRelease(db) >= GESSchema.getDetectionSchemaVersion(prog) && GESSchema.getVersionNoOfRelease(db) <= GESSchema.getLastSchemaVersion(prog);
    }

    public static boolean isSourceInDB(String db, int prog) {
        return GESSchema.getVersionNoOfRelease(db) >= GESSchema.getSourceSchemaVersion(prog);
    }

    public static int getVersionNoOfRelease(String schema, int surveyID) {
        String[] dbs = new String[]{};
        switch (surveyID) {
            case 75: {
                dbs = GESDB;
                break;
            }
            case 1: {
                dbs = COMMDB;
                break;
            }
            case 100: {
                dbs = SVORIONDB;
                break;
            }
            case 101: {
                dbs = SVNGC253DB;
                break;
            }
            case 110: {
                dbs = VHSDB;
                break;
            }
            case 120: {
                dbs = VVVDB;
                break;
            }
            case 130: {
                dbs = VMCDB;
                break;
            }
            case 140: {
                dbs = VIKINGDB;
                break;
            }
            case 150: {
                dbs = VIDEODB;
                break;
            }
            case 160: {
                dbs = ULTRAVISTADB;
                break;
            }
            case 200: {
                dbs = CALDB;
                break;
            }
        }
        int i = 0;
        while (i < dbs.length) {
            if (schema.equalsIgnoreCase(dbs[i])) {
                return i;
            }
            ++i;
        }
        if (schema.equalsIgnoreCase("GES_DailySync")) {
            return 9999;
        }
        return -1;
    }

    public static int[] getReqFilters(String database, int surveyID) {
        switch (surveyID) {
            case 75: {
                return GESREQFILTERS;
            }
            case 1: {
                return COMMISSIONINGREQFILTERS;
            }
            case 100: {
                return SVORIONREQFILTERS;
            }
            case 101: {
                return SVNGC253REQFILTERS;
            }
            case 110: {
                return VHSREQFILTERS;
            }
            case 120: {
                return VVVREQFILTERS;
            }
            case 130: {
                return VMCREQFILTERS;
            }
            case 140: {
                return VIKINGREQFILTERS;
            }
            case 150: {
                return VIDEOREQFILTERS;
            }
            case 160: {
                return ULTRAVISTAREQFILTERS;
            }
            case 200: {
                return CALREQFILTERS;
            }
            case 11: {
                return LASREQFILTERS;
            }
            case 102: {
                if (GESSchema.getVersionNoOfRelease(database) >= GESSchema.getVersionNoOfRelease("ukidssdr3plus") || database.equals("") || database == null) {
                    return GPSREQFILTERS;
                }
                return GPSREQFILTERSDR2;
            }
            case 12: {
                if (GESSchema.getVersionNoOfRelease(database) >= GESSchema.getVersionNoOfRelease("ukidssdr3plus")) {
                    return GPSREQFILTERS;
                }
                return GPSREQFILTERSDR2;
            }
        }
        return null;
    }

    public static int[] getReqFilters(int surveyID) {
        switch (surveyID) {
            case 75: {
                return GESREQFILTERS;
            }
            case 1: {
                return COMMISSIONINGREQFILTERS;
            }
            case 100: {
                return SVORIONREQFILTERS;
            }
            case 101: {
                return SVNGC253REQFILTERS;
            }
            case 110: {
                return VHSREQFILTERS;
            }
            case 120: {
                return VVVREQFILTERS;
            }
            case 130: {
                return VMCREQFILTERS;
            }
            case 140: {
                return VIKINGREQFILTERS;
            }
            case 150: {
                return VIDEOREQFILTERS;
            }
            case 160: {
                return ULTRAVISTAREQFILTERS;
            }
            case 200: {
                return CALREQFILTERS;
            }
        }
        return null;
    }

    public static String[] getDBs(String Community) {
        if (Community.indexOf("beta") >= 0) {
            return BETAGESDB;
        }
        return GESDB;
    }

    public static String[] getDBs(int sessionCLass) {
        switch (sessionCLass) {
            case 0: {
                return BETAGESDB;
            }
            case 1: {
                return GESDB;
            }
        }
        return WORLDGESDB;
    }

    public static String[] getDBs(int programmeid, boolean world) {
        switch (programmeid) {
            case 0: {
                if (world) {
                    return null;
                }
                return PRERELEASEDB;
            }
            case 75: {
                if (world) {
                    return WORLDGESDB;
                }
                return GESDB;
            }
            case 1: {
                if (world) {
                    return WORLDCOMMDB;
                }
                return COMMDB;
            }
            case 100: {
                if (world) {
                    return WORLDSVORIONDB;
                }
                return SVORIONDB;
            }
            case 101: {
                if (world) {
                    return WORLDSVNGC253DB;
                }
                return SVNGC253DB;
            }
            case 110: {
                if (world) {
                    return WORLDVHSDB;
                }
                return VHSDB;
            }
            case 120: {
                if (world) {
                    return WORLDVVVDB;
                }
                return VVVDB;
            }
            case 130: {
                if (world) {
                    return WORLDVMCDB;
                }
                return VMCDB;
            }
            case 140: {
                if (world) {
                    return WORLDVIKINGDB;
                }
                return VIKINGDB;
            }
            case 150: {
                if (world) {
                    return WORLDVIDEODB;
                }
                return VIDEODB;
            }
            case 160: {
                if (world) {
                    return WORLDULTRAVISTADB;
                }
                return ULTRAVISTADB;
            }
            case 200: {
                if (world) {
                    return WORLDCALDB;
                }
                return CALDB;
            }
            case 103: {
                if (world) {
                    return WORLDGCSDB;
                }
                return GCSDB;
            }
        }
        return null;
    }

    public static String[] getWorldDBs(int programmeid) {
        switch (programmeid) {
            case 0: {
                return null;
            }
            case 75: {
                return WORLDGESDB;
            }
            case 1: {
                return WORLDCOMMDB;
            }
            case 100: {
                return WORLDSVORIONDB;
            }
            case 101: {
                return WORLDSVNGC253DB;
            }
            case 110: {
                return WORLDVHSDB;
            }
            case 120: {
                return WORLDVVVDB;
            }
            case 130: {
                return WORLDVMCDB;
            }
            case 140: {
                return WORLDVIKINGDB;
            }
            case 150: {
                return WORLDVIDEODB;
            }
            case 160: {
                return WORLDULTRAVISTADB;
            }
            case 200: {
                return WORLDCALDB;
            }
            case 103: {
                return WORLDGCSDB;
            }
        }
        return null;
    }

    public static String[] getEquivWorldDBs(int programmeid) {
        switch (programmeid) {
            case 0: {
                return null;
            }
            case 75: {
                return EQUIVWORLDGESDB;
            }
            case 1: {
                return EQUIVWORLDCOMMDB;
            }
            case 100: {
                return EQUIVWORLDSVORIONDB;
            }
            case 101: {
                return EQUIVWORLDSVNGC253DB;
            }
            case 110: {
                return EQUIVWORLDVHSDB;
            }
            case 120: {
                return EQUIVWORLDVVVDB;
            }
            case 130: {
                return EQUIVWORLDVMCDB;
            }
            case 140: {
                return EQUIVWORLDVIKINGDB;
            }
            case 150: {
                return EQUIVWORLDVIDEODB;
            }
            case 160: {
                return EQUIVWORLDULTRAVISTADB;
            }
            case 200: {
                return EQUIVWORLDCALDB;
            }
            case 103: {
                return EQUIVWORLDGCSDB;
            }
        }
        return null;
    }

    public static String[] getDBsPlusRollingDB(String[] inDBs) {
        if (inDBs == null) {
            return null;
        }
        String[] retDBs = new String[inDBs.length + 1];
        int i = 0;
        while (i < inDBs.length) {
            retDBs[i] = inDBs[i];
            ++i;
        }
        retDBs[retDBs.length - 1] = "GES_DailySync";
        return retDBs;
    }

    public static String[] getDBsPlusExtraDB(String[] inDBs, String[] extraDBs) {
        String[] retDBs = new String[inDBs.length + extraDBs.length];
        int i = 0;
        while (i < inDBs.length) {
            retDBs[i] = inDBs[i];
            ++i;
        }
        i = 0;
        while (i < extraDBs.length) {
            retDBs[inDBs.length + i] = extraDBs[i];
            ++i;
        }
        return retDBs;
    }

    public static int getSchemaValidVersion(int progID) {
        switch (progID) {
            case 75: {
                return GESVERISONSCHEMA;
            }
            case 1: {
                return COMMVERISONSCHEMA;
            }
            case 100: {
                return SVORIONVERISONSCHEMA;
            }
            case 101: {
                return SVNGC253VERISONSCHEMA;
            }
            case 110: {
                return VHSVERISONSCHEMA;
            }
            case 120: {
                return VVVVERISONSCHEMA;
            }
            case 130: {
                return VMCVERISONSCHEMA;
            }
            case 140: {
                return VIKINGVERISONSCHEMA;
            }
            case 150: {
                return VIDEOVERISONSCHEMA;
            }
            case 160: {
                return ULTRAVISTAVERISONSCHEMA;
            }
        }
        return 9999;
    }

    public static String getDefaultList(int[] reqFilters, String table, String database, int progID) {
        boolean validSchema = false;
        if (GESSchema.getVersionNoOfRelease(database, progID) >= GESSchema.getSchemaValidVersion(progID)) {
            validSchema = true;
        }
        database = database.replaceAll("(?i)world", "ukidss");
        int i = 0;
        while (i < SCEHMAVALIDDATABASES.length) {
            if (database.equalsIgnoreCase(SCEHMAVALIDDATABASES[i])) {
                validSchema = true;
            }
            ++i;
        }
        if (table.toLowerCase().indexOf("detection") >= 0) {
            if (validSchema) {
                return "objID, multiframeID, filterID, RA, Dec, ell, pa, class, psfMag, hallMag,isoMag, petroMag, aperMag2, aperMag3";
            }
            return String.valueOf(table) + ".*";
        }
        if (table.toLowerCase().indexOf("source") >= 0) {
            if (validSchema) {
                StringBuffer sb = new StringBuffer("sourceID, framesetID, RA, Dec, mergedClass, priOrSec");
                if (reqFilters != null) {
                    sb.append(GESSchema.getReqMags(reqFilters));
                }
                return sb.toString();
            }
            return String.valueOf(table) + ".*";
        }
        return String.valueOf(table) + ".*";
    }

    public static String getDefaultList(int[] reqFilters, String table) {
        return GESSchema.getDefaultList(reqFilters, table, "ukidssdr5plus");
    }

    public static String getReqMags(int[] reqFilters) {
        StringBuffer sb1 = new StringBuffer("");
        int i = 0;
        while (i < reqFilters.length) {
            if (reqFilters[i] == 1) {
                sb1.append(", " + GESSchema.getFilterName(i) + "AperMag3");
                sb1.append(", " + GESSchema.getFilterName(i) + "AperMag3Err");
            }
            if (reqFilters[i] > 1) {
                int j = 0;
                while (j < reqFilters[i]) {
                    sb1.append(", " + GESSchema.getFilterName(i) + "_" + (j + 1) + "AperMag3");
                    sb1.append(", " + GESSchema.getFilterName(i) + "_" + (j + 1) + "AperMag3Err");
                    ++j;
                }
            }
            ++i;
        }
        return sb1.toString();
    }

    public static String[] getBands(int[] reqBands) {
        int noBands = 0;
        int i = 0;
        while (i < reqBands.length) {
            noBands += reqBands[i];
            ++i;
        }
        String[] bands = new String[noBands];
        int bandCount = 0;
        int i2 = 0;
        while (i2 < reqBands.length) {
            if (reqBands[i2] == 1) {
                bands[bandCount] = GESSchema.getFilterName(i2);
                ++bandCount;
            }
            if (reqBands[i2] > 1) {
                int j = 0;
                while (j < reqBands[i2]) {
                    bands[bandCount] = String.valueOf(GESSchema.getFilterName(i2)) + "_" + (j + 1);
                    ++bandCount;
                    ++j;
                }
            }
            ++i2;
        }
        return bands;
    }

    public static String[] getBands(String database, int surveyID) {
        int[] reqBands = GESSchema.getReqFilters(database, surveyID);
        int noBands = 0;
        int i = 0;
        while (i < reqBands.length) {
            noBands += reqBands[i];
            ++i;
        }
        String[] bands = new String[noBands];
        int bandCount = 0;
        int i2 = 0;
        while (i2 < reqBands.length) {
            if (reqBands[i2] == 1) {
                bands[bandCount] = GESSchema.getFilterName(i2);
                ++bandCount;
            }
            if (reqBands[i2] > 1) {
                int j = 0;
                while (j < reqBands[i2]) {
                    bands[bandCount] = String.valueOf(GESSchema.getFilterName(i2)) + "_" + (j + 1);
                    ++bandCount;
                    ++j;
                }
            }
            ++i2;
        }
        return bands;
    }

    public static String[] getBands(int surveyID) {
        switch (surveyID) {
            case 75: {
                return COMMISSIONINGBands;
            }
            case 1: {
                return COMMISSIONINGBands;
            }
            case 101: {
                return LASBands;
            }
            case 11: {
                return LASBands;
            }
            case 102: {
                return GPSBands;
            }
            case 12: {
                return GPSBands;
            }
            case 103: {
                return GCSBands;
            }
            case 13: {
                return GCSBands;
            }
            case 104: {
                return DXSBands;
            }
            case 14: {
                return DXSBands;
            }
            case 105: {
                return UDSBands;
            }
            case 15: {
                return UDSBands;
            }
        }
        return null;
    }

    public static String getMergeTableName(int surveyID) {
        String mergeTableName;
        switch (surveyID) {
            case 75: {
                mergeTableName = GESMERGETABLENAME;
                break;
            }
            case 1: {
                mergeTableName = COMMISSIONINGMERGETABLENAME;
                break;
            }
            case 110: {
                mergeTableName = VHSMERGETABLENAME;
                break;
            }
            case 120: {
                mergeTableName = VVVMERGETABLENAME;
                break;
            }
            case 130: {
                mergeTableName = VMCMERGETABLENAME;
                break;
            }
            case 140: {
                mergeTableName = VIKINGMERGETABLENAME;
                break;
            }
            case 150: {
                mergeTableName = VIDEOMERGETABLENAME;
                break;
            }
            case 160: {
                mergeTableName = ULTRAVISTAMERGETABLENAME;
                break;
            }
            case 100: {
                mergeTableName = SVORIONMERGETABLENAME;
                break;
            }
            case 101: {
                mergeTableName = SVNGC253MERGETABLENAME;
                break;
            }
            default: {
                mergeTableName = null;
            }
        }
        return mergeTableName;
    }

    public static int getSourceSchemaVersion(int surveyID) {
        int schemaVersion = -1;
        switch (surveyID) {
            case 106: {
                schemaVersion = 99999;
                break;
            }
            case 200: {
                schemaVersion = 99999;
                break;
            }
            default: {
                schemaVersion = -1;
            }
        }
        return schemaVersion;
    }

    public static int getDetectionSchemaVersion(int surveyID) {
        int schemaVersion = -1;
        switch (surveyID) {
            case 106: {
                schemaVersion = -1;
                break;
            }
            case 200: {
                schemaVersion = -1;
                break;
            }
            default: {
                schemaVersion = -1;
            }
        }
        return schemaVersion;
    }

    public static int getLastSchemaVersion(int surveyID) {
        int schemaVersion = 99999999;
        schemaVersion = 99999999;
        return schemaVersion;
    }

    public static String getSourceTableName(int surveyID) {
        switch (surveyID) {
            case 75: {
                return GESSOURCETABLENAME;
            }
            case 1: {
                return COMMSOURCETABLENAME;
            }
            case 110: {
                return VHSSOURCETABLENAME;
            }
            case 120: {
                return VVVSOURCETABLENAME;
            }
            case 130: {
                return VMCSOURCETABLENAME;
            }
            case 140: {
                return VIKINGSOURCETABLENAME;
            }
            case 150: {
                return VIDEOSOURCETABLENAME;
            }
            case 160: {
                return ULTRAVISTASOURCETABLENAME;
            }
            case 100: {
                return SVORIONSOURCETABLENAME;
            }
            case 101: {
                return SVNGC253SOURCETABLENAME;
            }
            case 200: {
                return "NONE";
            }
        }
        return null;
    }

    public static String[] getDefaultRGB(int surveyID) {
        String[] RGB = null;
        switch (surveyID) {
            case 110: {
                RGB = VHSRGB;
                break;
            }
            case 120: {
                RGB = VVVRGB;
                break;
            }
            case 101: {
                RGB = LASRGB;
                break;
            }
            case 102: {
                RGB = GPSRGB;
                break;
            }
            case 103: {
                RGB = GCSRGB;
                break;
            }
            case 104: {
                RGB = DXSRGB;
                break;
            }
            case 105: {
                RGB = UDSRGB;
                break;
            }
        }
        return RGB;
    }

    public static String getSourceViewName(int surveyID) {
        switch (surveyID) {
            case 1: {
                return "undef";
            }
            case 100: {
                return "undef";
            }
            case 101: {
                return "undef";
            }
            case 110: {
                return "undef";
            }
            case 120: {
                return "undef";
            }
            case 130: {
                return "undef";
            }
            case 140: {
                return "undef";
            }
            case 150: {
                return "undef";
            }
            case 160: {
                return "undef";
            }
            case 200: {
                return "undef";
            }
        }
        return null;
    }

    public static String getDetectionTableName(int surveyID) {
        switch (surveyID) {
            case 75: {
                return GESDETECTIONTABLENAME;
            }
            case 1: {
                return COMMDETECTIONTABLENAME;
            }
            case 110: {
                return VHSDETECTIONTABLENAME;
            }
            case 120: {
                return VVVDETECTIONTABLENAME;
            }
            case 130: {
                return VMCDETECTIONTABLENAME;
            }
            case 140: {
                return VIKINGDETECTIONTABLENAME;
            }
            case 150: {
                return VIDEODETECTIONTABLENAME;
            }
            case 160: {
                return ULTRAVISTADETECTIONTABLENAME;
            }
            case 100: {
                return SVORIONDETECTIONTABLENAME;
            }
            case 101: {
                return SVNGC253DETECTIONTABLENAME;
            }
            case 200: {
                return CALDETECTIONTABLENAME;
            }
        }
        return null;
    }

    public static String getShortSurveyName(int surveyID) {
        String shortSurveyName;
        switch (surveyID) {
            case 75: {
                shortSurveyName = PRERELEASEDATABASE;
                break;
            }
            case 1: {
                shortSurveyName = "comm";
                break;
            }
            case 110: {
                shortSurveyName = "VHS";
                break;
            }
            case 120: {
                shortSurveyName = "VVV";
                break;
            }
            case 130: {
                shortSurveyName = "VMC";
                break;
            }
            case 140: {
                shortSurveyName = "VIKING";
                break;
            }
            case 150: {
                shortSurveyName = "VIDEO";
                break;
            }
            case 160: {
                shortSurveyName = "UltraVista";
                break;
            }
            case 100: {
                shortSurveyName = "svOrion";
                break;
            }
            case 101: {
                shortSurveyName = "svNGC253";
                break;
            }
            case 200: {
                shortSurveyName = "cal";
                break;
            }
            default: {
                shortSurveyName = null;
            }
        }
        return shortSurveyName;
    }

    public static String getSurveyName(int surveyID) {
        String surveyName;
        switch (surveyID) {
            case 75: {
                surveyName = "GAIA-ESO Survey";
                break;
            }
            case 1: {
                surveyName = "Commissioning programme";
                break;
            }
            case 110: {
                surveyName = "VHS: VISTA Hemisphere Survey";
                break;
            }
            case 120: {
                surveyName = "VVV: VISTA Variables in the Via Lactea";
                break;
            }
            case 130: {
                surveyName = "VMC: VISTA Magellanic Clouds Survey";
                break;
            }
            case 140: {
                surveyName = "VIKING: VISTA Kilo-degree Infrared Galaxy Survey";
                break;
            }
            case 150: {
                surveyName = "VIDEO: VISTA Deep Extragalactic Observations";
                break;
            }
            case 160: {
                surveyName = "UltraVISTA: an ultra-deep survey with VISTA";
                break;
            }
            case 100: {
                surveyName = "ORION Science Verification data";
                break;
            }
            case 101: {
                surveyName = "NGC253 Science Verification data";
                break;
            }
            case 200: {
                surveyName = "Calibration data";
                break;
            }
            case 103: {
                surveyName = "GCS TEST";
                break;
            }
            default: {
                surveyName = "Survey name not found in lookup";
            }
        }
        return surveyName;
    }

    public static String getFilterName(int filterID) {
        if (filterID >= 0 && filterID <= VISTAFILTERS.length && VISTAFILTERS[filterID] != null) {
            return VISTAFILTERS[filterID];
        }
        return "NULL";
    }

    public static String getRequiredFiltersSQL() {
        return "select filterid,npass from requiredfilters";
    }

    public static String getProprietaryCommunity(int surveyID, String remoteUser) {
        switch (surveyID) {
            case 75: {
                return PRERELEASEDATABASE;
            }
            case 1: {
                return "COMM";
            }
            case 110: {
                return "VHS";
            }
            case 120: {
                if (remoteUser.toLowerCase().contains("vvve")) {
                    return "VVVE";
                }
                if (remoteUser.toLowerCase().contains("vvvs")) {
                    return "VVVS";
                }
                return "VVV";
            }
            case 130: {
                return "VMC";
            }
            case 140: {
                return "VIKING";
            }
            case 150: {
                return "VIDEO";
            }
            case 160: {
                return "ULTRAVISTA";
            }
            case 100: {
                return "SV_ORION";
            }
            case 101: {
                return "SV_NGC53";
            }
            case 200: {
                return "CAL";
            }
        }
        return null;
    }

    public static int getProgIDFromString(String str) {
        if (str != null) {
            if (str.toLowerCase().contains("ges")) {
                return 75;
            }
            if (str.toLowerCase().contains("vvv")) {
                return 120;
            }
            if (str.toLowerCase().contains("vmc")) {
                return 130;
            }
            if (str.toLowerCase().contains("viking")) {
                return 140;
            }
            if (str.toLowerCase().contains("vhs")) {
                return 110;
            }
            if (str.toLowerCase().contains("video")) {
                return 150;
            }
            if (str.toLowerCase().contains("ultravista")) {
                return 160;
            }
            return -9999;
        }
        return -9999;
    }

    public static StringBuffer getFramesetSQL(int[] fID, String mergelogTable, String multiframeTable) {
        StringBuffer sbSQL = new StringBuffer("");
        String mfidName = null;
        int row = 0;
        boolean first = true;
        int j = 0;
        while (j < fID.length) {
            int filterid = j;
            int npass = fID[j];
            row += npass;
            if (npass == 1) {
                mfidName = String.valueOf(GESSchema.getFilterName(filterid)) + "mfid";
                if (!first) {
                    sbSQL.append(" or ");
                }
                first = false;
                sbSQL.append(String.valueOf(mergelogTable) + "." + mfidName + "=" + multiframeTable + ".multiframeid");
            } else if (npass > 1) {
                int i = 0;
                while (i < npass) {
                    mfidName = String.valueOf(GESSchema.getFilterName(filterid)) + "_" + (i + 1) + "mfid";
                    if (!first) {
                        sbSQL.append(" or ");
                    }
                    first = false;
                    sbSQL.append(String.valueOf(mergelogTable) + "." + mfidName + "=" + multiframeTable + ".multiframeid");
                    ++i;
                }
            }
            ++j;
        }
        if (row > 0) {
            return sbSQL;
        }
        return null;
    }

    public static String getCrossIDTableTable(String community, String user, String baseTable, int intProgrammeID) {
        if (community.equalsIgnoreCase(NONSURVEYCOMMUNITY)) {
            return String.valueOf(user.trim()) + baseTable;
        }
        if (baseTable.equalsIgnoreCase("sourceView")) {
            return GESSchema.getSourceViewName(intProgrammeID);
        }
        if (baseTable.equalsIgnoreCase("source")) {
            return GESSchema.getSourceTableName(intProgrammeID);
        }
        if (baseTable.equalsIgnoreCase("detection")) {
            return GESSchema.getDetectionTableName(intProgrammeID);
        }
        return "";
    }

    public static String getCrossIDDefaultSelect(String community, String tableName, HttpSession session, int programmeID, String database) {
        if (community.equalsIgnoreCase(NONSURVEYCOMMUNITY)) {
            int[] reqFilters = null;
            if (session.getAttribute("gesreqFilters") != null) {
                reqFilters = (int[])session.getAttribute("gesreqFilters");
            }
            return GESSchema.getDefaultList(reqFilters, tableName, WSASession.getSchemaVersion(session));
        }
        return GESSchema.getDefaultList(GESSchema.getReqFilters(programmeID), tableName, database, programmeID);
    }

    public static boolean isInAcronyms(String str) {
        int i = 0;
        while (i < SURVEYACRONYMS.length) {
            if (str.equalsIgnoreCase(SURVEYACRONYMS[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isProprietary(String community) {
        return community != null && (GESSchema.isInAcronyms(community) || community.toLowerCase().contains(GESCOMMUNITYPREFIX.toLowerCase()) || community.toLowerCase().contains(PROPRIETARYCOMMUNITY.toLowerCase()));
    }

    public static StringBuffer getFramesetSQL(ResultSet rset, String mergelogTable, String multiframeTable) {
        StringBuffer sbSQL = new StringBuffer("");
        String mfidName = null;
        int row = 0;
        boolean first = true;
        try {
            while (rset.next()) {
                ++row;
                int filterid = rset.getInt("filterid");
                int npass = rset.getInt("npass");
                if (npass == 1) {
                    mfidName = String.valueOf(GESSchema.getFilterName(filterid)) + "mfid";
                    if (!first) {
                        sbSQL.append(" or ");
                    }
                    first = false;
                    sbSQL.append(String.valueOf(mergelogTable) + "." + mfidName + "=" + multiframeTable + ".multiframeid");
                    continue;
                }
                if (npass <= 1) continue;
                int i = 0;
                while (i < npass) {
                    mfidName = String.valueOf(GESSchema.getFilterName(filterid)) + "_" + (i + 1) + "mfid";
                    if (!first) {
                        sbSQL.append(" or ");
                    }
                    first = false;
                    sbSQL.append(String.valueOf(mergelogTable) + "." + mfidName + "=" + multiframeTable + ".multiframeid");
                    ++i;
                }
            }
            if (row > 0) {
                return sbSQL;
            }
            return null;
        }
        catch (SQLException se) {
            return null;
        }
    }
}

