/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.roe.wfau;

import javax.servlet.http.HttpSession;
import uk.ac.roe.wfau.GESSchema;
import uk.ac.roe.wfau.WSASchema;

public class GESSession {
    static final int UKIDSSTESTERCLASS = 0;
    static final int UKIDSSCLASS = 1;
    static final int WORLDCLASS = 2;
    static final int PRERELEASECLASS = 3;
    static final int NONSURVEYCLASS = 4;
    static final int VISTATESTERCLASS = 5;
    static final int GESCLASS = 1;
    static final int BETACLASS = 0;

    public static String getDBUser(HttpSession sess) {
        String community = GESSession.getCommunity(sess);
        if (GESSession.getLoginBoolean(sess) && !GESSchema.isProprietary(community) && !community.equalsIgnoreCase("prerelease") && !community.equalsIgnoreCase("world")) {
            return "wsaro";
        }
        if (GESSession.getLoginBoolean(sess) && community.equalsIgnoreCase("prerelease")) {
            return "wsaro";
        }
        if (GESSession.getLoginBoolean(sess) && GESSchema.isProprietary(community)) {
            int iProgID = Integer.parseInt(GESSession.getProgID(sess));
            if (iProgID > 0 && iProgID < 1000) {
                return String.valueOf(GESSchema.getShortSurveyName(iProgID).toLowerCase()) + "ro";
            }
            return String.valueOf(GESSession.getUser(sess).toLowerCase()) + "ro";
        }
        return "worldwsaro";
    }

    public static int getSessionClass(HttpSession sess) {
        String community = GESSession.getCommunity(sess);
        if (GESSession.getLoginBoolean(sess)) {
            if (community.toLowerCase().indexOf("beta") >= 0) {
                return 0;
            }
            return 1;
        }
        return 2;
    }

    public static String getProgID(HttpSession sess) {
        if (sess.getAttribute("gesprogrammeID") != null) {
            return ((String)sess.getAttribute("gesprogrammeID")).trim();
        }
        return "-999";
    }

    public static String getCommunity(HttpSession sess) {
        if (GESSession.getLoginBoolean(sess) && sess.getAttribute("gescommunity") != null) {
            String community = ((String)sess.getAttribute("gescommunity")).toLowerCase().trim();
            if (community != null) {
                return community;
            }
            return "world";
        }
        return "world";
    }

    public static String getMaskedCommunity(HttpSession sess) {
        if (GESSession.getLoginBoolean(sess) && sess.getAttribute("gescommunity") != null) {
            String community = ((String)sess.getAttribute("gescommunity")).toLowerCase().trim().replaceFirst(GESSchema.GESCOMMUNITYPREFIX.toLowerCase(), "");
            if (community != null) {
                return community;
            }
            return "world";
        }
        return "world";
    }

    public static String[] getNonSurveyDBName(HttpSession sess) {
        String[] nsDBs = null;
        if (sess.getAttribute("gesreleasedDBs") != null) {
            nsDBs = (String[])sess.getAttribute("gesreleasedDBs");
        } else if (sess.getAttribute("gesdbName") != null && !((String)sess.getAttribute("gesdbName")).toLowerCase().trim().equalsIgnoreCase("na")) {
            String[] dbName = new String[]{GESSession.getUser(sess)};
            nsDBs = dbName;
        }
        return nsDBs;
    }

    public static String getUser(HttpSession sess) {
        return GESSession.getUser(sess, false);
    }

    public static String getUser(HttpSession sess, boolean generic) {
        if (GESSession.getLoginBoolean(sess)) {
            if (!generic) {
                if (sess.getAttribute("gesuser") != null) {
                    return ((String)sess.getAttribute("gesuser")).toLowerCase().trim();
                }
                return "public";
            }
            int iProgID = Integer.parseInt(GESSession.getProgID(sess));
            if (iProgID > 0 && iProgID < 1000 && GESSchema.getShortSurveyName(iProgID) != null) {
                return GESSchema.getShortSurveyName(iProgID);
            }
            return ((String)sess.getAttribute("gesuser")).toLowerCase().trim();
        }
        return "public";
    }

    public static String[] getDB(HttpSession sess, int progID) {
        return GESSession.getDB(sess, progID, false);
    }

    public static String[] getDB(HttpSession sess, int progID, boolean doRollingDB) {
        return GESSession.getDB(sess, progID, doRollingDB, true);
    }

    public static String[] getDB(HttpSession sess, int progID, boolean doRollingDB, boolean includeExtraDB) {
        return GESSession.getDB(sess, progID, doRollingDB, includeExtraDB, false);
    }

    public static String[] getDB(HttpSession sess, int progID, boolean doRollingDB, boolean includeExtraDB, boolean includeMoreDB) {
        String[] DB;
        int sessClass = GESSession.getSessionClass(sess);
        System.out.println(sessClass);
        switch (sessClass) {
            case 2: {
                DB = GESSchema.WORLDGESDB;
                break;
            }
            case 1: {
                DB = GESSchema.GESDB;
                break;
            }
            case 0: {
                DB = GESSchema.BETAGESDB;
                break;
            }
            case 4: {
                String[] nsdbs = GESSession.getNonSurveyDBName(sess);
                DB = doRollingDB ? (GESSession.getNonSurveyDBName(sess) != null ? GESSchema.getDBsPlusRollingDB(GESSession.getNonSurveyDBName(sess)) : new String[]{"GES_DailySync"}) : (GESSession.getNonSurveyDBName(sess) != null ? GESSession.getNonSurveyDBName(sess) : new String[]{"sorry no access"});
                if (!includeExtraDB) break;
                DB = GESSchema.getDBsPlusExtraDB(DB, GESSchema.extraDB);
                break;
            }
            case 3: {
                DB = GESSchema.PRERELEASEDB;
                break;
            }
            default: {
                DB = GESSchema.getDBs(progID, true);
            }
        }
        return DB;
    }

    public static int[] getProgs(HttpSession sess) {
        int[] progs;
        int sessClass = GESSession.getSessionClass(sess);
        switch (sessClass) {
            case 2: {
                progs = GESSchema.GESPROGS;
                break;
            }
            case 1: {
                progs = GESSchema.GESPROGS;
                break;
            }
            case 0: {
                progs = GESSchema.GESPROGS;
                break;
            }
            default: {
                progs = GESSchema.GESPROGS;
            }
        }
        return progs;
    }

    public static String getSchemaVersion(HttpSession sess) {
        if (sess.getAttribute("gesschemaVersion") != null) {
            String schemaVersion = ((String)sess.getAttribute("gesschemaVersion")).toLowerCase().trim();
            if (schemaVersion != null) {
                return schemaVersion;
            }
            return "null";
        }
        return "null";
    }

    public static boolean getProprietaryBoolean(HttpSession sess) {
        if (sess.getAttribute("gesProprietary") != null) {
            return (Boolean)sess.getAttribute("gesProprietary");
        }
        return false;
    }

    public static boolean getSourceBoolean(HttpSession sess) {
        if (sess.getAttribute("gessource") != null) {
            return (Boolean)sess.getAttribute("gessource");
        }
        return false;
    }

    public static int[] getReqFilters(HttpSession sess) {
        try {
            return (int[])sess.getAttribute("gesreqFilters");
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean getLoginBoolean(HttpSession sess) {
        if (sess.getAttribute("geslogin") != null) {
            try {
                return (Boolean)sess.getAttribute("geslogin");
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public static String getDefaultList(HttpSession sess, String table, String database, int progID) {
        if (database == null) {
            if (GESSession.getCommunity(sess).equalsIgnoreCase("nonsurvey")) {
                return WSASchema.getDefaultList(GESSession.getReqFilters(sess), table, GESSession.getSchemaVersion(sess));
            }
            if (GESSession.getLoginBoolean(sess)) {
                return WSASchema.getDefaultList(WSASchema.getReqFilters(progID), table, WSASchema.LATESTUKIDSSSCHEMA);
            }
            return WSASchema.getDefaultList(WSASchema.getReqFilters(progID), table, WSASchema.LATESTWORLDSCHEMA);
        }
        if (GESSession.getCommunity(sess).equalsIgnoreCase("nonsurvey")) {
            return WSASchema.getDefaultList(GESSession.getReqFilters(sess), table, GESSession.getSchemaVersion(sess));
        }
        if (GESSession.getLoginBoolean(sess)) {
            return WSASchema.getDefaultList(WSASchema.getReqFilters(progID), table, database);
        }
        return WSASchema.getDefaultList(WSASchema.getReqFilters(progID), table, database);
    }
}

