/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.roe.wfau;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import net.mar.FormatRS;
import net.mar.ParseCoords;
import org.apache.log4j.Logger;
import uk.ac.roe.wfau.FitsWcs;
import uk.ac.roe.wfau.VDFSSchema;
import uk.ac.roe.wfau.WSAHTMLSchema;
import uk.ac.roe.wfau.WSASchema;
import uk.ac.starlink.ast.FitsChan;

public class ImageSelect {
    int archiveID = 1;
    int startID = 0;
    public static Logger logger = Logger.getLogger((String)"wsa.simple");
    PrintWriter out = null;
    static String[] blankColumns = new String[]{"filename", "cd11", "cd12", "cd22", "cd21", "axis1length", "axis2Length", "cTypeX", "cTypeY", "crValX", "crValY", "crPixX", "crPixY", "projP1", "projP3", "xpixsize", "ypixsize", "pv21", "pv22", "pv23", "catfile", "illumfile", "pv24", "pv25"};
    ResultSetMetaData md;
    ResultSet rs;
    int row = 0;
    int rc = 0;
    double userRA;
    double userDec;
    double userX;
    double userY;
    boolean filterIDAsObjNum = false;
    double distance = 0.0;
    double area = 0.0;
    double areaRequested = 0.0;
    int filenameCol;
    int multiframeIDCol;
    int filterIDCol;
    int extNumCol;
    int numaxesCol;
    int axis1lengthCol;
    int axis2lengthCol;
    int ctypeXCol;
    int ctypeYCol;
    int crpixXCol;
    int crvalXCol;
    int crpixYCol;
    int crvalYCol;
    int cd11Col;
    int cd12Col;
    int cd21Col;
    int cd22Col;
    int projp1Col = 0;
    int projp3Col = 0;
    int pv21Col = 0;
    int pv22Col = 0;
    int pv23Col = 0;
    int pv24Col = 0;
    int pv25Col = 0;
    int xpixelsizeCol;
    int ypixelsizeCol;
    int objNumCol;
    int userRACol;
    int userDecCol;
    int illumCol = -1;
    int catCol = -1;
    StringBuffer tableStart = new StringBuffer("<table border=\"1\"><tr bgcolor=\"#FFFFCC\"><td><b>Link</b></td>");
    FormatRS frs;
    String[] RSArray;
    boolean[] showCol;
    boolean doMap = false;
    String cgiURL = null;
    String uniqueID = "";
    Map map = new HashMap();
    boolean allFile = false;
    BufferedWriter resultsFile = null;
    double[] RAArray;
    double[] DecArray;
    String[] nameArray;
    String band = null;

    public ImageSelect() {
    }

    public ImageSelect(int archiveID) {
        this.archiveID = archiveID;
    }

    public void setBand(String band) {
        this.band = band;
    }

    public void setStartID(int startID) {
        this.startID = startID;
    }

    public void setAllFile(String allResultsFile, double[] RAArray, double[] DecArray, String[] nameArray) throws IOException {
        this.resultsFile = new BufferedWriter(new FileWriter(allResultsFile));
        this.RAArray = RAArray;
        this.DecArray = DecArray;
        this.nameArray = nameArray;
        this.allFile = true;
    }

    public void closeAllFile() throws IOException {
        this.resultsFile.close();
    }

    public void setUniqueID(String uniqueID) {
        this.uniqueID = uniqueID;
    }

    public void setFilterIDAsObjNum(boolean tf) {
        this.filterIDAsObjNum = tf;
    }

    public void setCgiURL(String cgiURL) {
        this.cgiURL = cgiURL;
    }

    public void setPrintWriter(PrintWriter out) {
        this.out = out;
    }

    public void setDoMap(boolean doMap) {
        this.doMap = doMap;
    }

    public int getMumberRows() {
        return this.row;
    }

    public static String getImageURL(String cgiName, String[] inArray) {
        return ImageSelect.getImageURL(cgiName, inArray, 1);
    }

    public static String getImageURL(String cgiName, String[] inArray, int archiveID) {
        StringBuffer jpegURL;
        int filtID = -1;
        try {
            filtID = Integer.valueOf(inArray[2]);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (cgiName.startsWith("http")) {
            jpegURL = new StringBuffer(cgiName);
        } else {
            jpegURL = new StringBuffer(WSAHTMLSchema.baseCGIURL);
            jpegURL.append(cgiName);
        }
        String parameters = "?file=" + inArray[0] + "&mfid=" + inArray[1] + "&extNo=" + inArray[3] + "&lx=" + inArray[4] + "&hx=" + inArray[5] + "&ly=" + inArray[6] + "&hy=" + inArray[7] + "&rf=" + inArray[16] + "&flip=" + inArray[17] + "&uniq=" + inArray[18] + "&xpos=" + inArray[8] + "&ypos=" + inArray[9] + "&band=" + VDFSSchema.getFilterName(filtID, archiveID);
        return jpegURL.append(parameters).toString();
    }

    public String getQueryString(String[] inArray) {
        int filtID = -1;
        try {
            filtID = Integer.valueOf(inArray[2]);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return "file=" + inArray[0] + "&mfid=" + inArray[1] + "&extNo=" + inArray[3] + "&lx=" + inArray[4] + "&hx=" + inArray[5] + "&ly=" + inArray[6] + "&hy=" + inArray[7] + "&rf=" + inArray[16] + "&flip=" + inArray[17] + "&uniq=" + inArray[18] + "&xpos=" + inArray[8] + "&ypos=" + inArray[9] + "&band=" + VDFSSchema.getFilterName(filtID, this.archiveID) + "&ra=" + ParseCoords.formatP((double)this.userRA, (int)7) + "&dec=" + ParseCoords.formatP((double)this.userDec, (int)6);
    }

    public boolean setRSMD(ResultSetMetaData md) {
        boolean isOK = false;
        this.md = md;
        try {
            this.showCol = new boolean[md.getColumnCount()];
            int i = 1;
            while (i <= md.getColumnCount()) {
                this.showCol[i - 1] = true;
                int j = 0;
                while (j < blankColumns.length) {
                    if (md.getColumnName(i).equalsIgnoreCase(blankColumns[j])) {
                        this.showCol[i - 1] = false;
                    }
                    ++j;
                }
                if (this.showCol[i - 1]) {
                    this.tableStart.append("<td><b>" + md.getColumnName(i) + "</b></td>");
                }
                if (md.getColumnName(i).equalsIgnoreCase("filename")) {
                    this.filenameCol = i;
                }
                if (md.getColumnName(i).equalsIgnoreCase("multiframeID")) {
                    this.multiframeIDCol = i;
                }
                if (md.getColumnName(i).equalsIgnoreCase("filterID")) {
                    this.filterIDCol = i;
                }
                if (md.getColumnName(i).equalsIgnoreCase("extnum")) {
                    this.extNumCol = i;
                }
                if (md.getColumnName(i).equalsIgnoreCase("numaxes")) {
                    this.numaxesCol = i;
                }
                if (md.getColumnName(i).equalsIgnoreCase("axis1length")) {
                    this.axis1lengthCol = i;
                }
                if (md.getColumnName(i).equalsIgnoreCase("axis2length")) {
                    this.axis2lengthCol = i;
                }
                if (md.getColumnName(i).equalsIgnoreCase("CTYPEX")) {
                    this.ctypeXCol = i;
                }
                if (md.getColumnName(i).equalsIgnoreCase("CTYPEY")) {
                    this.ctypeYCol = i;
                }
                if (md.getColumnName(i).equalsIgnoreCase("CRPIXX")) {
                    this.crpixXCol = i;
                }
                if (md.getColumnName(i).equalsIgnoreCase("CRVALX")) {
                    this.crvalXCol = i;
                }
                if (md.getColumnName(i).equalsIgnoreCase("CRPIXY")) {
                    this.crpixYCol = i;
                }
                if (md.getColumnName(i).equalsIgnoreCase("CRVALY")) {
                    this.crvalYCol = i;
                }
                if (md.getColumnName(i).equalsIgnoreCase("CD11")) {
                    this.cd11Col = i;
                }
                if (md.getColumnName(i).equalsIgnoreCase("CD12")) {
                    this.cd12Col = i;
                }
                if (md.getColumnName(i).equalsIgnoreCase("CD21")) {
                    this.cd21Col = i;
                }
                if (md.getColumnName(i).equalsIgnoreCase("CD22")) {
                    this.cd22Col = i;
                }
                if (md.getColumnName(i).equalsIgnoreCase("PROJP1")) {
                    this.projp1Col = i;
                }
                if (md.getColumnName(i).equalsIgnoreCase("PROJP3")) {
                    this.projp3Col = i;
                }
                if (md.getColumnName(i).equalsIgnoreCase("PV21")) {
                    this.pv21Col = i;
                }
                if (md.getColumnName(i).equalsIgnoreCase("PV22")) {
                    this.pv22Col = i;
                }
                if (md.getColumnName(i).equalsIgnoreCase("PV23")) {
                    this.pv23Col = i;
                }
                if (md.getColumnName(i).equalsIgnoreCase("PV24")) {
                    this.pv24Col = i;
                }
                if (md.getColumnName(i).equalsIgnoreCase("PV25")) {
                    this.pv25Col = i;
                }
                if (md.getColumnName(i).equalsIgnoreCase("XPIXSIZE")) {
                    this.xpixelsizeCol = i;
                }
                if (md.getColumnName(i).equalsIgnoreCase("YPIXSIZE")) {
                    this.ypixelsizeCol = i;
                }
                if (md.getColumnName(i).equalsIgnoreCase("objNum")) {
                    this.objNumCol = i;
                }
                if (md.getColumnName(i).equalsIgnoreCase("userRA")) {
                    this.userRACol = i;
                }
                if (md.getColumnName(i).equalsIgnoreCase("userDec")) {
                    this.userDecCol = i;
                }
                if (md.getColumnName(i).equalsIgnoreCase("catname")) {
                    this.catCol = i;
                }
                if (md.getColumnName(i).equalsIgnoreCase("illumfile")) {
                    this.illumCol = i;
                }
                ++i;
            }
            this.frs = new FormatRS();
            this.frs.setRSMD(md);
            this.RSArray = new String[md.getColumnCount()];
            isOK = true;
        }
        catch (Exception e) {
            isOK = false;
        }
        return isOK;
    }

    public String[][] setRS(ResultSet rs, double userRA, double userDec, double userX, double userY) {
        return this.setRS(rs, userRA, userDec, userX, userY, 1);
    }

    public String[][] setRS(ResultSet rs, double userRA, double userDec, double userX, double userY, int noObj) {
        int objNum = 0;
        this.userRA = userRA;
        this.userDec = userDec;
        this.userX = userX;
        this.userY = userY;
        Object bestFile = null;
        this.rs = rs;
        this.areaRequested = userX * userY * 3600.0;
        String filename = null;
        double xPixelSize = 0.0;
        double yPixelSize = 0.0;
        double nx = 0.0;
        double ny = 0.0;
        int lowx = 0;
        int highx = 0;
        int lowy = 0;
        int highy = 0;
        int extNum = 0;
        String multiframeID = null;
        String filterID = null;
        String filterName = null;
        String CD1_1 = null;
        String CD1_2 = null;
        String CD2_2 = null;
        String CD2_1 = null;
        String PROJP1 = null;
        String PROJP3 = null;
        String illumFile = null;
        String catName = null;
        Object options = null;
        String[][] bestArray = new String[noObj][25];
        double[] areaCovered = new double[noObj];
        double[] minDistance = new double[noObj];
        int i = 0;
        while (i < noObj) {
            minDistance[i] = 2.0E9;
            ++i;
        }
        int imflip = 0;
        int imrotFlag = 0;
        String RAString = null;
        String DecString = null;
        try {
            FitsChan fc;
            FitsWcs newfw = new FitsWcs();
            if (this.out != null) {
                this.out.println(this.tableStart);
            }
            DecimalFormat formatter = new DecimalFormat("000");
            while (rs.next()) {
                double[] crval = new double[2];
                double[] pv2 = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
                double[][] cd = new double[2][2];
                double[] crpix = new double[2];
                int projType = 6;
                if (rs.getString(this.ctypeXCol).indexOf("TAN") > 0) {
                    projType = 2;
                }
                try {
                    crval[0] = rs.getDouble(this.crvalXCol);
                    crval[1] = rs.getDouble(this.crvalYCol);
                    crpix[0] = rs.getDouble(this.crpixXCol);
                    crpix[1] = rs.getDouble(this.crpixYCol);
                    if (this.pv21Col > 0) {
                        pv2[1] = rs.getDouble(this.pv21Col);
                    }
                    if (this.pv22Col > 0) {
                        pv2[2] = rs.getDouble(this.pv22Col);
                    }
                    if (this.pv23Col > 0) {
                        pv2[3] = rs.getDouble(this.pv23Col);
                    }
                    if (this.pv24Col > 0) {
                        pv2[4] = rs.getDouble(this.pv24Col);
                    }
                    if (this.pv25Col > 0) {
                        pv2[5] = rs.getDouble(this.pv25Col);
                    }
                    logger.info((Object)("cd11 " + this.cd11Col));
                    logger.info((Object)(" pv21 " + pv2[1] + " pv22 " + pv2[2] + " pv23 " + pv2[3] + " pv24 " + pv2[4] + " pv25 " + pv2[5]));
                    cd[0][0] = rs.getDouble(this.cd11Col);
                    logger.info((Object)("cd12 " + this.cd12Col));
                    cd[0][1] = rs.getDouble(this.cd12Col);
                    logger.info((Object)("cd21 " + this.cd21Col));
                    cd[1][0] = rs.getDouble(this.cd21Col);
                    logger.info((Object)("cd22 " + this.cd22Col));
                    cd[1][1] = rs.getDouble(this.cd22Col);
                }
                catch (SQLException e2) {
                    logger.error((Object)("ImgSel " + e2));
                }
                String[] strArray = new String[25];
                try {
                    if (this.userRACol > 0) {
                        userRA = rs.getDouble(this.userRACol);
                    }
                    if (this.userDecCol > 0) {
                        userDec = rs.getDouble(this.userDecCol);
                    }
                }
                catch (SQLException se) {
                    userRA = 999.0;
                    userDec = 999.0;
                }
                RAString = ParseCoords.formatP((double)userRA, (int)7);
                DecString = ParseCoords.formatP((double)userDec, (int)6);
                if (noObj == 1) {
                    objNum = 0;
                } else if (this.filterIDAsObjNum) {
                    objNum = rs.getInt(this.filterIDCol);
                } else {
                    try {
                        objNum = rs.getInt(this.objNumCol);
                    }
                    catch (SQLException se) {
                        objNum = 0;
                    }
                }
                fc = null;
                fc = new FitsChan();
                ++this.rc;
                fc.setCard(1);
                filename = rs.getString(this.filenameCol);
                multiframeID = rs.getString(this.multiframeIDCol);
                filterID = rs.getString(this.filterIDCol);
                try {
                    WSASchema.getFilterName(Integer.valueOf(filterID));
                }
                catch (Exception e) {
                    filterName = "NULL";
                }
                extNum = rs.getInt(this.extNumCol);
                extNum -= WSASchema.FITS_OFFSET;
                try {
                    fc.putFits("NAXIS   = " + rs.getString(this.numaxesCol), true);
                }
                catch (Exception e) {
                    fc.putFits("NAXIS   = 2", true);
                }
                fc.putFits("NAXIS1  = " + rs.getString(this.axis1lengthCol), true);
                fc.putFits("NAXIS2  = " + rs.getString(this.axis2lengthCol), true);
                fc.putFits("CTYPE1  = '" + rs.getString(this.ctypeXCol) + "'", true);
                fc.putFits("CTYPE2  = '" + rs.getString(this.ctypeYCol) + "'", true);
                fc.putFits("CRPIX1  = " + rs.getString(this.crpixXCol), true);
                fc.putFits("CRVAL1  = " + rs.getString(this.crvalXCol), true);
                fc.putFits("CRPIX2  = " + rs.getString(this.crpixYCol), true);
                fc.putFits("CRVAL2  = " + rs.getString(this.crvalYCol), true);
                String CD11P = rs.getString(this.cd11Col);
                CD1_1 = "CD1_1   = " + CD11P + " / from database";
                fc.putFits(CD1_1, true);
                String CD12P = rs.getString(this.cd12Col);
                CD1_2 = "CD1_2   = " + CD12P + " / from database";
                fc.putFits(CD1_2, true);
                String CD21P = rs.getString(this.cd21Col);
                CD2_1 = "CD2_1   = " + CD21P + " / from database";
                fc.putFits(CD2_1, true);
                String CD22P = rs.getString(this.cd22Col);
                CD2_2 = "CD2_2   = " + CD22P + " / from database";
                fc.putFits(CD2_2, true);
                if (rs.getString(this.ctypeXCol).toLowerCase().indexOf("zpn") > 0 || rs.getString(this.ctypeYCol).toLowerCase().indexOf("zpn") > 0) {
                    if (this.illumCol > 0) {
                        illumFile = rs.getString(this.illumCol).replaceAll("illum_20", "illum_");
                    }
                    if (this.catCol > 0) {
                        catName = rs.getString(this.catCol);
                    }
                    if (this.projp1Col > 0) {
                        PROJP1 = "PROJP1  = " + rs.getString(this.projp1Col) + " / from database";
                        fc.putFits(PROJP1, true);
                    }
                    if (this.projp3Col > 0) {
                        PROJP3 = "PROJP3  = " + rs.getString(this.projp3Col) + " / from database";
                        fc.putFits(PROJP3, true);
                    }
                    if (this.pv21Col > 0) {
                        String PV21 = "PV2_1   = " + rs.getString(this.pv21Col) + " / from database";
                        fc.putFits(PV21, true);
                    }
                    if (this.pv22Col > 0) {
                        String PV22 = "PV2_2   = " + rs.getString(this.pv23Col) + " / from database";
                        fc.putFits(PV22, true);
                    }
                    if (this.pv23Col > 0) {
                        String PV23 = "PV2_3   = " + rs.getString(this.pv23Col) + " / from database";
                        fc.putFits(PV23, true);
                    }
                    if (this.pv24Col > 0) {
                        String PV24 = "PV2_4   = " + rs.getString(this.pv24Col) + " / from database";
                        fc.putFits(PV24, true);
                    }
                    if (this.pv25Col > 0) {
                        String PV25 = "PV2_5   = " + rs.getString(this.pv25Col) + " / from database";
                        fc.putFits(PV25, true);
                    }
                }
                xPixelSize = Double.valueOf(rs.getString(this.xpixelsizeCol));
                yPixelSize = Double.valueOf(rs.getString(this.ypixelsizeCol));
                fc.putFits("PCOUNT  =                    0 / required keyword; must = 0                    ", true);
                fc.putFits("GCOUNT  =                    1 / required keyword; must = 1                    ", true);
                fc.putFits("CRUNIT1 = 'deg     '           / Unit of right ascension co-ordinates          ", true);
                fc.putFits("CRUNIT2 = 'deg     '           / Unit of declination co-ordinates              ", true);
                newfw.setFits(fc);
                fc = null;
                nx = newfw.getNX();
                ny = newfw.getNY();
                double[] xypix = newfw.getXPixYPix(userRA, userDec);
                double[] centre = newfw.getRADec(nx / 2.0, ny / 2.0);
                if (xypix[0] > 0.0 & xypix[0] < nx & xypix[1] > 0.0 & xypix[1] < ny) {
                    double imrot;
                    logger.info((Object)("nx ny " + rs.getDouble(this.axis1lengthCol) + " : " + rs.getDouble(this.axis2lengthCol)));
                    ++this.row;
                    double CD11D = Double.valueOf(CD11P);
                    double CD12D = Double.valueOf(CD12P);
                    logger.info((Object)("cd12d and cd[0][1] " + CD12D + " : " + cd[0][1]));
                    double CD21D = Double.valueOf(CD21P);
                    logger.info((Object)("cd21d and cd[1][0] " + CD21D + " : " + cd[1][0]));
                    double CD22D = Double.valueOf(CD22P);
                    double xinc = Math.sqrt(CD11D * CD11D + CD21D * CD21D);
                    double yinc = Math.sqrt(CD22D * CD22D + CD12D * CD12D);
                    double[] xypixN = newfw.getXPixYPix(userRA, userDec + yinc);
                    double[] xypixE = newfw.getXPixYPix(userRA + xinc, userDec);
                    double paNorth = Math.atan2(xypixN[1] - xypix[1], xypixN[0] - xypix[0]) * 180.0 / Math.PI;
                    double paEast = Math.atan2(xypixE[1] - xypix[1], xypixE[0] - xypix[0]) * 180.0 / Math.PI;
                    imflip = 0;
                    if (paNorth < -90.0) {
                        paNorth += 360.0;
                    }
                    if (paEast < -90.0) {
                        paEast += 360.0;
                    }
                    if ((imrot = paNorth < -90.0 ? 270.0 + paNorth : paNorth - 90.0) < 0.0) {
                        imrot += 360.0;
                    }
                    if (imrot >= 360.0) {
                        imrot -= 360.0;
                    }
                    if (paEast - paNorth < -80.0 && paEast - paNorth > -100.0) {
                        imflip = 1;
                    }
                    if (paEast - paNorth < 280.0 && paEast - paNorth > 260.0) {
                        imflip = 1;
                    }
                    if (paNorth - paEast > 80.0 && paNorth - paEast < 100.0) {
                        imflip = 1;
                    }
                    if ((imrotFlag = Math.round((float)imrot)) >= 360) {
                        imrotFlag -= 360;
                    }
                    if (imrotFlag < 0) {
                        imrotFlag += 360;
                    }
                    double sizeX = userX;
                    double sizeY = userY;
                    if (Math.round((float)imrot / 90.0f) == 1 || Math.round((float)imrot / 90.0f) == 3) {
                        sizeX = userY;
                        sizeY = userX;
                    }
                    lowx = (int)Math.ceil(Math.max(1.0, xypix[0] - sizeX * 60.0 / (2.0 * xPixelSize) - 1.0));
                    highx = (int)Math.floor(Math.min(nx, xypix[0] + sizeX * 60.0 / (2.0 * xPixelSize) + 1.0));
                    lowy = (int)Math.ceil(Math.max(1.0, xypix[1] - sizeY * 60.0 / (2.0 * yPixelSize) - 1.0));
                    highy = (int)Math.floor(Math.min(ny, xypix[1] + sizeY * 60.0 / (2.0 * yPixelSize) + 1.0));
                    if (this.out != null || this.doMap || this.allFile) {
                        strArray[0] = filename.substring(filename.indexOf(":") + 1, filename.length()).trim().toString();
                        strArray[1] = multiframeID;
                        strArray[2] = filterID;
                        strArray[3] = String.valueOf(extNum);
                        strArray[4] = String.valueOf(lowx);
                        strArray[5] = String.valueOf(highx);
                        strArray[6] = String.valueOf(lowy);
                        strArray[7] = String.valueOf(highy);
                        strArray[8] = ParseCoords.formatP((double)(xypix[0] - (double)lowx + 1.0), (int)1);
                        strArray[9] = ParseCoords.formatP((double)(xypix[1] - (double)lowy + 1.0), (int)1);
                        strArray[10] = CD11P;
                        strArray[11] = CD12P;
                        strArray[12] = CD21P;
                        strArray[13] = CD22P;
                        strArray[14] = PROJP1;
                        strArray[15] = PROJP3;
                        strArray[16] = String.valueOf(imrotFlag);
                        strArray[17] = String.valueOf(imflip);
                        strArray[18] = String.valueOf(this.uniqueID) + "_" + this.row;
                        strArray[19] = RAString;
                        strArray[20] = DecString;
                        strArray[21] = ParseCoords.formatP((double)xPixelSize, (int)2);
                        strArray[22] = ParseCoords.formatP((double)yPixelSize, (int)2);
                        strArray[23] = catName;
                        strArray[24] = illumFile;
                        if (this.allFile) {
                            this.resultsFile.write(String.valueOf(this.RAArray[objNum]) + "," + this.DecArray[objNum]);
                            int al = 0;
                            while (al < strArray.length) {
                                this.resultsFile.write("," + strArray[al]);
                                this.resultsFile.flush();
                                ++al;
                            }
                            if (!this.band.equalsIgnoreCase("mfid")) {
                                this.resultsFile.write(",band=" + this.band + ",objName=" + this.nameArray[objNum] + ",upID=" + (objNum + 1 + this.startID) + "\n");
                            } else {
                                this.resultsFile.write(",band=" + VDFSSchema.getFilterName(Integer.valueOf(filterID), this.archiveID) + ",objName=" + this.nameArray[objNum] + ",upID=" + (objNum + 1 + this.startID) + "\n");
                            }
                        }
                    }
                    if (this.out != null) {
                        if (this.row % 2 == 0) {
                            this.out.println("<tr bgcolor=#DDDDDD>");
                        } else {
                            this.out.println("<tr bgcolor=#FFDDDD>");
                        }
                        this.out.println("<td><a href=\"" + this.cgiURL + this.getQueryString(strArray) + "\" target=show>show</a>" + "</td>");
                        this.RSArray = this.frs.setRS(rs);
                        int j = 0;
                        while (j < this.RSArray.length) {
                            if (this.showCol[j]) {
                                this.out.println("<td nowrap>" + this.RSArray[j].trim() + "</td>");
                            }
                            ++j;
                        }
                    }
                    if (this.doMap) {
                        this.map.put(formatter.format(this.row), strArray);
                    }
                    this.area = (double)((highx - lowx) * (highy - lowy)) * xPixelSize * yPixelSize;
                    this.distance = (xypix[0] - nx / 2.0) * (xypix[0] - nx / 2.0) + (xypix[1] - ny / 2.0) * (xypix[1] - ny / 2.0);
                    if (this.area > areaCovered[objNum] || this.area >= this.areaRequested) {
                        areaCovered[objNum] = this.area;
                        if (this.distance < minDistance[objNum]) {
                            minDistance[objNum] = this.distance;
                            bestArray[objNum][0] = filename.substring(filename.indexOf(":") + 1, filename.length()).trim().toString();
                            bestArray[objNum][1] = multiframeID;
                            bestArray[objNum][2] = filterID;
                            bestArray[objNum][3] = String.valueOf(extNum);
                            bestArray[objNum][4] = String.valueOf(lowx);
                            bestArray[objNum][5] = String.valueOf(highx);
                            bestArray[objNum][6] = String.valueOf(lowy);
                            bestArray[objNum][7] = String.valueOf(highy);
                            bestArray[objNum][8] = ParseCoords.formatP((double)(xypix[0] - (double)lowx + 1.0), (int)1);
                            bestArray[objNum][9] = ParseCoords.formatP((double)(xypix[1] - (double)lowy + 1.0), (int)1);
                            bestArray[objNum][10] = CD11P;
                            bestArray[objNum][11] = CD12P;
                            bestArray[objNum][12] = CD21P;
                            bestArray[objNum][13] = CD22P;
                            bestArray[objNum][14] = PROJP1;
                            bestArray[objNum][15] = PROJP3;
                            bestArray[objNum][16] = String.valueOf(imrotFlag);
                            bestArray[objNum][17] = String.valueOf(imflip);
                            bestArray[objNum][18] = String.valueOf(this.uniqueID) + "_" + this.row;
                            bestArray[objNum][19] = RAString;
                            bestArray[objNum][20] = DecString;
                            bestArray[objNum][21] = ParseCoords.formatP((double)xPixelSize, (int)2);
                            bestArray[objNum][22] = ParseCoords.formatP((double)yPixelSize, (int)2);
                            bestArray[objNum][23] = catName;
                            bestArray[objNum][24] = illumFile;
                        }
                    }
                }
                newfw.done();
            }
            formatter = null;
            if (this.out != null) {
                this.out.println("</table>");
                this.out.flush();
            }
            fc = null;
        }
        catch (Exception e) {
            System.out.println("AAA" + e);
            e.printStackTrace();
        }
        return bestArray;
    }

    public int getNoRows() {
        return this.row;
    }

    public Map getResMap() {
        return this.map;
    }
}

