/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.roe.wfau;

import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;
import uk.ac.roe.wfau.ASASchema;
import uk.ac.roe.wfau.FormatLines;

public class LoadASAProperties {
    private static LoadASAProperties singletonObject;
    public static Logger logger;

    static {
        logger = Logger.getLogger((String)"wsa.simple");
    }

    private LoadASAProperties() {
        try {
            InputStream inProp = this.getClass().getClassLoader().getResourceAsStream("ASA.properties");
            Properties properties = new Properties();
            logger.info((Object)"loading ASA.properites");
            properties.load(inProp);
            ASASchema.ATLASPASSTHROUGHPASSWORD = properties.getProperty("ATLASPASSTHROUGHPASSWORD");
            ASASchema.VPHASPASSTHROUGHPASSWORD = properties.getProperty("VPHASPASSTHROUGHPASSWORD");
            ASASchema.ATLASDB = FormatLines.commaSeparatedStringToStringArray(properties.getProperty("ATLASDB").trim());
            logger.info((Object)(String.valueOf(ASASchema.ATLASDB[0]) + " atlas0"));
            ASASchema.ATLASDBWITHCHILEAN = FormatLines.commaSeparatedStringToStringArray(properties.getProperty("ATLASDBWITHCHILEAN").trim());
            logger.info((Object)(String.valueOf(ASASchema.ATLASDBWITHCHILEAN[0]) + " atlas0"));
            ASASchema.WORLDATLASDB = FormatLines.commaSeparatedStringToStringArray(properties.getProperty("WORLDATLASDB").trim());
            logger.info((Object)(String.valueOf(ASASchema.WORLDATLASDB[0]) + " wordlatlas0"));
            ASASchema.VPHASDB = FormatLines.commaSeparatedStringToStringArray(properties.getProperty("VPHASDB").trim());
            logger.info((Object)(String.valueOf(ASASchema.VPHASDB[0]) + " vphas0"));
            ASASchema.WORLDVPHASDB = FormatLines.commaSeparatedStringToStringArray(properties.getProperty("WORLDVPHASDB").trim());
        }
        catch (Exception e) {
            logger.info((Object)("error in loading ASA.properites " + e));
            e.printStackTrace();
        }
    }

    public static synchronized void getSingletonObject() {
        if (singletonObject == null) {
            singletonObject = new LoadASAProperties();
        }
        logger.info((Object)("SOEX " + singletonObject));
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }
}

