/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.roe.wfau;

import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;
import uk.ac.roe.wfau.FormatLines;
import uk.ac.roe.wfau.OSASchema;

public class LoadOSAProperties {
    private static LoadOSAProperties singletonObject;
    public static Logger logger;

    static {
        logger = Logger.getLogger((String)"wsa.simple");
    }

    private LoadOSAProperties() {
        try {
            InputStream inProp = this.getClass().getClassLoader().getResourceAsStream("OSA.properties");
            Properties properties = new Properties();
            logger.info((Object)"loading OSA.properites");
            properties.load(inProp);
            OSASchema.ATLASPASSTHROUGHPASSWORD = properties.getProperty("ATLASPASSTHROUGHPASSWORD");
            OSASchema.VPHASPASSTHROUGHPASSWORD = properties.getProperty("VPHASPASSTHROUGHPASSWORD");
            OSASchema.ATLASDB = FormatLines.commaSeparatedStringToStringArray(properties.getProperty("ATLASDB").trim());
            logger.info((Object)(String.valueOf(OSASchema.ATLASDB[0]) + " atlas0"));
            OSASchema.ATLASDBWITHCHILEAN = FormatLines.commaSeparatedStringToStringArray(properties.getProperty("ATLASDBWITHCHILEAN").trim());
            logger.info((Object)(String.valueOf(OSASchema.ATLASDBWITHCHILEAN[0]) + " atlas0"));
            OSASchema.WORLDATLASDB = FormatLines.commaSeparatedStringToStringArray(properties.getProperty("WORLDATLASDB").trim());
            logger.info((Object)(String.valueOf(OSASchema.WORLDATLASDB[0]) + " wordlatlas0"));
            OSASchema.VPHASDB = FormatLines.commaSeparatedStringToStringArray(properties.getProperty("VPHASDB").trim());
            logger.info((Object)(String.valueOf(OSASchema.VPHASDB[0]) + " vphas0"));
            OSASchema.WORLDVPHASDB = FormatLines.commaSeparatedStringToStringArray(properties.getProperty("WORLDVPHASDB").trim());
        }
        catch (Exception e) {
            logger.info((Object)("error in loading OSA.properites " + e));
            e.printStackTrace();
        }
    }

    public static synchronized void getSingletonObject() {
        if (singletonObject == null) {
            singletonObject = new LoadOSAProperties();
        }
        logger.info((Object)("SOEX " + singletonObject));
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }
}

