/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.roe.wfau;

import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;
import uk.ac.roe.wfau.FormatLines;
import uk.ac.roe.wfau.QueryRetrieverThread;
import uk.ac.roe.wfau.WSAHTMLSchema;
import uk.ac.roe.wfau.WSASchema;

public class LoadWSAProperties {
    private static LoadWSAProperties singletonObject;
    public static Logger logger;

    static {
        logger = Logger.getLogger((String)"wsa.simple");
    }

    private LoadWSAProperties() {
        try {
            InputStream inProp = this.getClass().getClassLoader().getResourceAsStream("WSA.properties");
            Properties properties = new Properties();
            logger.info((Object)"loading this WSA.properites");
            properties.load(inProp);
            WSASchema.ALLUKIDSSRDB = FormatLines.commaSeparatedStringToStringArray(properties.getProperty("ALLUKIDSSRDB").trim());
            WSASchema.UKIDSSVERSIONS = FormatLines.commaSeparatedStringToIntArray(properties.getProperty("UKIDSSVERSIONS").trim());
            WSASchema.UKIDSSDB = FormatLines.commaSeparatedStringToStringArray(properties.getProperty("UKIDSSDB").trim());
            WSASchema.WORLDDB = FormatLines.commaSeparatedStringToStringArray(properties.getProperty("WORLDDB").trim());
            WSASchema.WORLDVERSIONS = FormatLines.commaSeparatedStringToIntArray(properties.getProperty("WORLDVERSIONS").trim());
            WSASchema.SCEHMAVALIDDATABASES = FormatLines.commaSeparatedStringToStringArray(properties.getProperty("SCEHMAVALIDDATABASES").trim());
            try {
                WSASchema.PRERELEASEDATABASE = properties.getProperty("PRERELEASEDATABASE").trim();
                logger.info((Object)(String.valueOf(WSASchema.PRERELEASEDATABASE) + " prereleaseDB"));
            }
            catch (Exception e) {
                logger.info((Object)e.toString());
            }
            try {
                WSASchema.MAILSERVER = properties.getProperty("MAILSERVER").trim();
                logger.info((Object)(String.valueOf(WSASchema.MAILSERVER) + " mailserver"));
            }
            catch (Exception e) {
                logger.info((Object)(String.valueOf(e.toString()) + "mailerror"));
            }
            try {
                WSAHTMLSchema.baseURL = properties.getProperty("baseURL").trim();
                WSAHTMLSchema.baseJSPURL = properties.getProperty("baseJSPURL").trim();
                WSAHTMLSchema.baseCGIURL = properties.getProperty("baseCGIURL").trim();
            }
            catch (Exception e) {
                logger.info((Object)e.toString());
            }
            try {
                WSASchema.MAILSERVER = properties.getProperty("MAILSERVER").trim();
            }
            catch (Exception e) {
                logger.info((Object)e.toString());
            }
            try {
                QueryRetrieverThread.ROWSWRITTEN_UPPERLIMIT = Integer.parseInt(properties.getProperty("ROWSWRITTEN_UPPERLIMIT").trim());
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            logger.info((Object)("error in loading WSA.properites " + e));
            e.printStackTrace();
        }
    }

    public static synchronized void getSingletonObject() {
        if (singletonObject == null) {
            singletonObject = new LoadWSAProperties();
        }
        logger.info((Object)("SOEX " + singletonObject));
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }
}

