/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.roe.wfau;

import javax.servlet.http.HttpSession;
import uk.ac.roe.wfau.OSASchema;
import uk.ac.roe.wfau.WSASchema;

public class OSASession {
    static final int UKIDSSTESTERCLASS = 0;
    static final int UKIDSSCLASS = 1;
    static final int WORLDCLASS = 2;
    static final int PRERELEASECLASS = 3;
    static final int NONSURVEYCLASS = 4;
    static final int VISTATESTERCLASS = 5;

    public static HttpSession setSession(HttpSession sess, boolean isPreRelease, String progID, String user, String community) {
        sess.setAttribute("osalogin", (Object)Boolean.TRUE);
        if (!OSASchema.isProprietary(community)) {
            sess.setAttribute("osauser", (Object)user.toLowerCase().trim());
        } else {
            sess.setAttribute("osauser", (Object)user.trim());
        }
        sess.setAttribute("osacommunity", (Object)community.toUpperCase());
        if (OSASchema.isProprietary(community)) {
            sess.setAttribute("osaProprietary", (Object)Boolean.TRUE);
        }
        sess.setAttribute("osaprogrammeID", (Object)progID);
        return sess;
    }

    public static String getDBUser(HttpSession sess) {
        String community = OSASession.getCommunity(sess);
        if (OSASession.getLoginBoolean(sess) && !OSASchema.isProprietary(community) && !community.equalsIgnoreCase("prerelease") && !community.equalsIgnoreCase("world")) {
            return "wsaro";
        }
        if (OSASession.getLoginBoolean(sess) && community.equalsIgnoreCase("prerelease")) {
            return "wsaro";
        }
        if (OSASession.getLoginBoolean(sess) && OSASchema.isProprietary(community)) {
            int iProgID = Integer.parseInt(OSASession.getProgID(sess));
            if (iProgID > 0 && iProgID < 1000) {
                return String.valueOf(OSASchema.getShortSurveyName(iProgID).toLowerCase()) + "ro";
            }
            return String.valueOf(OSASession.getUser(sess).toLowerCase()) + "ro";
        }
        return "worldwsaro";
    }

    public static int getSessionClass(HttpSession sess) {
        String community = OSASession.getCommunity(sess);
        if (OSASession.getLoginBoolean(sess)) {
            if (community.equalsIgnoreCase("nonsurvey") || community.equalsIgnoreCase("Proprietary") || OSASchema.isProprietary(community)) {
                return 4;
            }
            if (community.equalsIgnoreCase("prerelease")) {
                return 3;
            }
            if (community.equalsIgnoreCase("ukidsstester")) {
                return 0;
            }
            if (community.equalsIgnoreCase("vistatester")) {
                return 5;
            }
            return 1;
        }
        return 2;
    }

    public static String getProgID(HttpSession sess) {
        if (sess.getAttribute("osaprogrammeID") != null) {
            return ((String)sess.getAttribute("osaprogrammeID")).trim();
        }
        return "-999";
    }

    public static String getCommunity(HttpSession sess) {
        if (OSASession.getLoginBoolean(sess) && sess.getAttribute("osacommunity") != null) {
            String community = ((String)sess.getAttribute("osacommunity")).toLowerCase().trim();
            if (community != null) {
                return community;
            }
            return "world";
        }
        return "world";
    }

    public static String getMaskedCommunity(HttpSession sess) {
        if (OSASession.getLoginBoolean(sess) && sess.getAttribute("osacommunity") != null) {
            String community = ((String)sess.getAttribute("osacommunity")).toLowerCase().trim().replaceFirst("osa::".toLowerCase(), "");
            if (community != null) {
                return community;
            }
            return "world";
        }
        return "world";
    }

    public static String[] getNonSurveyDBName(HttpSession sess) {
        String[] nsDBs = null;
        if (sess.getAttribute("osareleasedDBs") != null) {
            nsDBs = (String[])sess.getAttribute("osareleasedDBs");
        } else if (sess.getAttribute("osadbName") != null && !((String)sess.getAttribute("osadbName")).toLowerCase().trim().equalsIgnoreCase("na")) {
            String[] dbName = new String[]{OSASession.getUser(sess)};
            nsDBs = dbName;
        }
        return nsDBs;
    }

    public static String getUser(HttpSession sess) {
        return OSASession.getUser(sess, false);
    }

    public static String getUser(HttpSession sess, boolean generic) {
        if (OSASession.getLoginBoolean(sess)) {
            if (!generic) {
                if (sess.getAttribute("osauser") != null) {
                    return ((String)sess.getAttribute("osauser")).toLowerCase().trim();
                }
                return "public";
            }
            int iProgID = Integer.parseInt(OSASession.getProgID(sess));
            if (iProgID > 0 && iProgID < 1000 && OSASchema.getShortSurveyName(iProgID) != null) {
                return OSASchema.getShortSurveyName(iProgID);
            }
            return ((String)sess.getAttribute("osauser")).toLowerCase().trim();
        }
        return "public";
    }

    public static String[] getDB(HttpSession sess, int progID) {
        return OSASession.getDB(sess, progID, false);
    }

    public static String[] getDB(HttpSession sess, int progID, boolean doRollingDB) {
        return OSASession.getDB(sess, progID, doRollingDB, true);
    }

    public static String[] getDB(HttpSession sess, int progID, boolean doRollingDB, boolean includeExtraDB) {
        return OSASession.getDB(sess, progID, doRollingDB, includeExtraDB, false);
    }

    public static String[] getDB(HttpSession sess, int progID, boolean doRollingDB, boolean includeExtraDB, boolean includeMoreDB) {
        String[] DB;
        int sessClass = OSASession.getSessionClass(sess);
        switch (sessClass) {
            case 2: {
                DB = OSASchema.getDBs(progID, true);
                if (!includeMoreDB) break;
                DB = OSASchema.getDBsPlusExtraDB(DB, WSASchema.moreDB);
                break;
            }
            case 1: {
                if (doRollingDB && progID != 0) {
                    DB = OSASchema.getDBsPlusRollingDB(OSASchema.getDBs(progID, false));
                    break;
                }
                DB = OSASchema.getDBs(progID, false);
                break;
            }
            case 4: {
                String[] nsdbs = OSASession.getNonSurveyDBName(sess);
                DB = doRollingDB ? (OSASession.getNonSurveyDBName(sess) != null ? OSASchema.getDBsPlusRollingDB(OSASession.getNonSurveyDBName(sess)) : new String[]{"OSA_DailySync"}) : (OSASession.getNonSurveyDBName(sess) != null ? OSASession.getNonSurveyDBName(sess) : new String[]{"sorry no access"});
                if (!includeExtraDB) break;
                DB = OSASchema.getDBsPlusExtraDB(DB, OSASchema.extraDB);
                break;
            }
            case 5: {
                DB = doRollingDB ? OSASchema.getDBsPlusRollingDB(OSASchema.getDBs(progID, false)) : OSASchema.getDBs(progID, false);
                if (includeExtraDB) {
                    DB = WSASchema.getDBsPlusExtraDB(DB, WSASchema.extraDB);
                }
                if (!includeMoreDB) break;
                DB = WSASchema.getDBsPlusExtraDB(DB, WSASchema.moreDB);
                break;
            }
            case 0: {
                DB = doRollingDB ? OSASchema.getDBsPlusRollingDB(OSASchema.getDBs(progID, false)) : OSASchema.getDBs(progID, false);
                if (!includeExtraDB) break;
                DB = WSASchema.getDBsPlusExtraDB(DB, WSASchema.extraDB);
                break;
            }
            case 3: {
                DB = OSASchema.PRERELEASEDB;
                break;
            }
            default: {
                DB = OSASchema.getDBs(progID, true);
            }
        }
        return DB;
    }

    public static int[] getProgs(HttpSession sess) {
        int[] progs;
        int sessClass = OSASession.getSessionClass(sess);
        switch (sessClass) {
            case 2: {
                progs = OSASchema.OMEGAPROGS;
                break;
            }
            case 1: {
                progs = OSASchema.OMEGAPROGS;
                break;
            }
            case 4: {
                progs = new int[]{};
                break;
            }
            case 0: {
                progs = OSASchema.OMEGAPROGS;
                break;
            }
            case 5: {
                progs = OSASchema.OMEGATESTERPROGS;
                break;
            }
            case 3: {
                progs = OSASchema.OMEGATESTERPROGS;
                break;
            }
            default: {
                progs = OSASchema.OMEGAPROGS;
            }
        }
        return progs;
    }

    public static String getSchemaVersion(HttpSession sess) {
        if (sess.getAttribute("osaschemaVersion") != null) {
            String schemaVersion = ((String)sess.getAttribute("osaschemaVersion")).toLowerCase().trim();
            if (schemaVersion != null) {
                return schemaVersion;
            }
            return "null";
        }
        return "null";
    }

    public static boolean getProprietaryBoolean(HttpSession sess) {
        if (sess.getAttribute("osaProprietary") != null) {
            return (Boolean)sess.getAttribute("osaProprietary");
        }
        return false;
    }

    public static boolean getSourceBoolean(HttpSession sess) {
        if (sess.getAttribute("osasource") != null) {
            return (Boolean)sess.getAttribute("osasource");
        }
        return false;
    }

    public static int[] getReqFilters(HttpSession sess) {
        try {
            return (int[])sess.getAttribute("osareqFilters");
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean getLoginBoolean(HttpSession sess) {
        if (sess.getAttribute("osalogin") != null) {
            try {
                return (Boolean)sess.getAttribute("osalogin");
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public static String getDefaultList(HttpSession sess, String table, String database, int progID) {
        if (database == null) {
            if (OSASession.getCommunity(sess).equalsIgnoreCase("nonsurvey")) {
                return WSASchema.getDefaultList(OSASession.getReqFilters(sess), table, OSASession.getSchemaVersion(sess));
            }
            if (OSASession.getLoginBoolean(sess)) {
                return WSASchema.getDefaultList(WSASchema.getReqFilters(progID), table, WSASchema.LATESTUKIDSSSCHEMA);
            }
            return WSASchema.getDefaultList(WSASchema.getReqFilters(progID), table, WSASchema.LATESTWORLDSCHEMA);
        }
        if (OSASession.getCommunity(sess).equalsIgnoreCase("nonsurvey")) {
            return WSASchema.getDefaultList(OSASession.getReqFilters(sess), table, OSASession.getSchemaVersion(sess));
        }
        if (OSASession.getLoginBoolean(sess)) {
            return WSASchema.getDefaultList(WSASchema.getReqFilters(progID), table, database);
        }
        return WSASchema.getDefaultList(WSASchema.getReqFilters(progID), table, database);
    }
}

