/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.roe.wfau;

import java.awt.geom.Point2D;
import java.util.StringTokenizer;
import javax.servlet.ServletRequest;
import jsky.coords.WorldCoords;
import jsky.coords.wcscon;
import net.mar.AnException;
import uk.ac.roe.wfau.Sesame;

public class SQLRegion {
    static float maxRadius = 90.0f;
    static float maxX = 60.0f;
    static float maxY = 60.0f;
    String ra2000 = null;
    String dec2000 = null;
    String longitude = null;
    String latitude = null;
    String sys = null;
    String ra = null;
    String dec = null;
    String name = null;
    String radius = "";
    String xSize = "";
    String ySize = "";

    public String setRequest(ServletRequest req) throws AnException {
        boolean errors;
        StringBuffer errorBuffer;
        String sql;
        block31: {
            String action;
            block30: {
                sql = "sql";
                errorBuffer = new StringBuffer("");
                errors = false;
                String select = null;
                action = null;
                String where = null;
                String from = null;
                action = req.getParameter("action");
                this.radius = req.getParameter("radius");
                this.xSize = req.getParameter("xSize");
                this.ySize = req.getParameter("ySize");
                this.ra = req.getParameter("ra");
                this.dec = req.getParameter("dec");
                this.name = req.getParameter("name");
                this.sys = req.getParameter("sys");
                select = req.getParameter("select");
                from = req.getParameter("from");
                where = req.getParameter("where");
                try {
                    if (!action.equals("radial") && !action.equals("box")) {
                        errors = true;
                        errorBuffer.append(" Invalid action supplied.");
                    }
                }
                catch (Exception e) {
                    errors = true;
                    errorBuffer.append(" Invalid action supplied.");
                }
                try {
                    if (!action.equals("radial")) break block30;
                    try {
                        if (Float.parseFloat(this.radius) > maxRadius || Float.parseFloat(this.radius) < 0.0f) {
                            errors = true;
                            errorBuffer.append(" Radius should be > 0 and < " + maxRadius + " arcmin.");
                        }
                    }
                    catch (Exception e) {
                        errors = true;
                        errorBuffer.append(" Invalid radius");
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            try {
                if (!action.equals("box")) break block31;
                try {
                    if (Float.parseFloat(this.xSize) > maxX || Float.parseFloat(this.xSize) < 0.0f || Float.parseFloat(this.ySize) > maxY || Float.parseFloat(this.ySize) < 0.0f) {
                        errors = true;
                        errorBuffer.append(" X-size should be > 0 and < " + maxX + " arcmin.");
                        errorBuffer.append(" Y-size should be > 0 and < " + maxY + " arcmin.");
                    }
                }
                catch (Exception e) {
                    errors = true;
                    errorBuffer.append(" Invalid box size");
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.ra.length() > 0 & this.dec.length() > 0 & this.name.length() > 0) {
            errors = true;
            errorBuffer.append(" Only supply coordinates OR name");
        }
        if (this.name.length() > 0) {
            this.sys = "J";
            String result = null;
            try {
                Sesame sesame = new Sesame();
                result = sesame.getNameResolved(this.name);
            }
            catch (Exception e) {
                errors = true;
                errorBuffer.append(" Unable to resolve supplied name into valid RA & Dec. Please try later or input coords directly.");
            }
            if (result == null) {
                errors = true;
                errorBuffer.append("  Unable to resolve supplied name into valid RA & Dec. Please try later or input coords directly.");
            }
            String sub = result.substring(result.indexOf("%J") + 2, result.indexOf("(", result.indexOf("%J")));
            sub = sub.trim();
            StringTokenizer st = new StringTokenizer(sub);
            this.ra = st.nextToken();
            this.dec = st.nextToken();
            double raValue = -100.0;
            double decValue = -100.0;
            try {
                raValue = Double.parseDouble(this.ra);
                decValue = Double.parseDouble(this.dec);
                if (raValue > 360.0 || raValue < 0.0 || decValue < -90.0 || decValue > 90.0) {
                    errors = true;
                    errorBuffer.append(" Unable to resolve supplied name into valid RA & Dec. Please try later or input coords directly.");
                }
            }
            catch (NumberFormatException nfe) {
                errors = true;
                errorBuffer.append(" Unable to resolve supplied name into valid RA & Dec. Please try later or input coords directly.");
            }
        } else if (this.ra == null || this.ra.equals("") || this.dec == null || this.dec.equals("")) {
            errors = true;
            errorBuffer.append(" Check values of supplied coordinates (blank or null).");
        }
        WorldCoords wc = new WorldCoords();
        try {
            wc = new WorldCoords(Double.parseDouble(this.ra), Double.parseDouble(this.dec));
        }
        catch (Exception e) {
            try {
                wc = new WorldCoords(this.ra, this.dec);
            }
            catch (Exception ee) {
                errors = true;
                errorBuffer.append(" Unable to parse coordinates.");
            }
        }
        this.longitude = String.valueOf(wc.getX());
        this.latitude = String.valueOf(wc.getY());
        Point2D.Double point = new Point2D.Double(wc.getX(), wc.getY());
        if (this.sys.equals("G")) {
            wcscon.gal2fk5((Point2D.Double)point);
        }
        if (this.sys.equals("B")) {
            wcscon.fk425((Point2D.Double)point);
        }
        this.ra2000 = String.valueOf(point.getX());
        this.dec2000 = String.valueOf(point.getY());
        this.ra2000 = this.ra2000.replace('+', ' ');
        this.dec2000 = this.dec2000.replace('+', ' ');
        System.out.println("lon " + this.longitude + " lat " + this.latitude + " ra2000 " + this.ra2000 + " dec2000 " + this.dec2000);
        if (errors) {
            throw new AnException(errorBuffer.toString());
        }
        return sql;
    }
}

