/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.roe.wfau;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.rmi.RemoteException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.rpc.ServiceException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class SesameClientWget {
    String ra;
    String dec;
    String sexagesimalRA;
    String sexagesimalDec;
    double raValue = -999.0;
    double decValue = -999.0;

    public SesameClientWget(String name) throws ServiceException, RemoteException, NumberFormatException, Exception {
        StringBuffer xmlResults = new StringBuffer("");
        String inputLine = null;
        try {
            URL sesameCDS = new URL("http://cdsweb.u-strasbg.fr/cgi-bin/nph-sesame/-oxp/NSV?" + URLEncoder.encode(name, "UTF-8"));
            URLConnection yc = sesameCDS.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(yc.getInputStream()));
            while ((inputLine = in.readLine()) != null) {
                xmlResults.append(inputLine);
            }
            in.close();
            System.out.println("here " + xmlResults.toString());
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            InputSource is = new InputSource(new StringReader(xmlResults.toString()));
            Document document = builder.parse(is);
            Element rootElement = document.getDocumentElement();
            this.ra = this.getString("jradeg", rootElement);
            this.dec = this.getString("jdedeg", rootElement);
            this.raValue = Double.parseDouble(this.ra);
            this.decValue = Double.parseDouble(this.dec);
        }
        catch (Exception e1) {
            throw new Exception("Unable to resolve name, " + name + ", into valid RA/Dec");
        }
    }

    public String getRA() {
        return this.ra;
    }

    public String getDec() {
        return this.dec;
    }

    protected String getString(String tagName, Element element) {
        NodeList subList;
        NodeList list = element.getElementsByTagName(tagName);
        if (list != null && list.getLength() > 0 && (subList = list.item(0).getChildNodes()) != null && subList.getLength() > 0) {
            return subList.item(0).getNodeValue();
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        new SesameClientWget("ngc300");
    }
}

