/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.roe.wfau;

import java.sql.Connection;
import java.sql.PreparedStatement;
import uk.ac.roe.wfau.GESSchema;
import uk.ac.roe.wfau.OSASchema;
import uk.ac.roe.wfau.VSASchema;

public class VDFSSQLStatements {
    public static PreparedStatement getDeleteUserPrepareStmt(Connection con, int archiveID, String remoteUser, String userName, String community) {
        try {
            if (archiveID == 1) {
                PreparedStatement pstmt = con.prepareStatement("delete from wsa_users where username=? and community=?");
                pstmt.setString(1, userName);
                pstmt.setString(2, community);
                return pstmt;
            }
            if (archiveID == 2) {
                PreparedStatement pstmt = con.prepareStatement("delete from wsa_nonSurveyUsers where username=? and community=? and archiveID=2");
                pstmt.setString(1, userName);
                pstmt.setString(2, VSASchema.getProprietaryCommunity(VSASchema.getProgIDFromString(remoteUser), remoteUser));
                return pstmt;
            }
            if (archiveID == 4 && remoteUser.toLowerCase().trim().startsWith("ges")) {
                PreparedStatement pstmt = con.prepareStatement("delete from wsa_nonSurveyUsers where username=? and community=? and archiveID=4");
                pstmt.setString(1, userName);
                pstmt.setString(2, String.valueOf(GESSchema.GESCOMMUNITYPREFIX) + community);
                return pstmt;
            }
            if (archiveID == 3 && OSASchema.isCommunityValidForUser(community, remoteUser)) {
                PreparedStatement pstmt = con.prepareStatement("delete from wsa_nonSurveyUsers where username=? and community=? and archiveID=3");
                pstmt.setString(1, userName);
                pstmt.setString(2, "osa::" + community);
                return pstmt;
            }
            return null;
        }
        catch (Exception e) {
            System.out.println(e);
            return null;
        }
    }

    public static PreparedStatement getDeleteUHSUserPrepareStmt(Connection con, int archiveID, String remoteUser, String userName, String community, String email) {
        try {
            if (archiveID == 1) {
                PreparedStatement pstmt = con.prepareStatement("delete from wsa_nonSurveyUsers where username=? and community=? and email=?");
                pstmt.setString(1, userName);
                pstmt.setString(2, "UHS");
                if (community.equalsIgnoreCase("arizona.edu")) {
                    pstmt.setString(3, email);
                } else {
                    pstmt.setString(3, community);
                }
                return pstmt;
            }
            return null;
        }
        catch (Exception e) {
            System.out.println(e);
            return null;
        }
    }

    public static PreparedStatement setDeleteUserPrepareStmt(PreparedStatement delPstmt, int archiveID, String remoteUser, String userName, String community) {
        try {
            if (archiveID == 1) {
                delPstmt.setString(1, userName);
                delPstmt.setString(2, community);
                delPstmt.addBatch();
                return delPstmt;
            }
            if (archiveID == 2) {
                delPstmt.setString(1, userName);
                delPstmt.setString(2, VSASchema.getProprietaryCommunity(VSASchema.getProgIDFromString(remoteUser), remoteUser));
                delPstmt.addBatch();
                return delPstmt;
            }
            return null;
        }
        catch (Exception e) {
            System.out.println(e);
            return null;
        }
    }

    public static PreparedStatement getDeleteUserPrepareStmt(Connection con, int archiveID) {
        try {
            if (archiveID == 1) {
                PreparedStatement delPstmt = con.prepareStatement("delete from wsa_users where username=? and community=?");
                return delPstmt;
            }
            if (archiveID == 2) {
                PreparedStatement delPstmt = con.prepareStatement("delete from wsa_nonSurveyUsers where username=? and community=?");
                return delPstmt;
            }
            return null;
        }
        catch (Exception e) {
            System.out.println(e);
            return null;
        }
    }

    public static PreparedStatement getAddUserPrepareStmt(Connection con, int archiveID, String remoteUser, String userName, String community, String lastName, String firstName, String passwd1, String email, String IPAddress) {
        try {
            if (archiveID == 1) {
                PreparedStatement pstmt = con.prepareStatement("insert into wsa_users (lastName,firstName,username,community,password,email,ipaddress) values (?,?,?,?,?,?,?)");
                pstmt.setString(1, lastName);
                pstmt.setString(2, firstName);
                pstmt.setString(3, userName);
                pstmt.setString(4, community);
                pstmt.setString(5, passwd1);
                pstmt.setString(6, email);
                pstmt.setString(7, IPAddress);
                return pstmt;
            }
            if (archiveID == 2) {
                PreparedStatement pstmt = con.prepareStatement("insert into wsa_nonSurveyUsers (firstName,lastName,username,password,community,email,programmeid,databasename,sourcetable,numfilterid1,numfilterid2,numfilterid3,numfilterid4,numfilterid5,numfilterid6,numfilterid7,numfilterid8,numfilterid9,numfilterid10,schemaversion,archiveID) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                pstmt.setString(1, firstName);
                pstmt.setString(2, lastName);
                pstmt.setString(3, userName);
                pstmt.setString(4, passwd1);
                pstmt.setString(5, VSASchema.getProprietaryCommunity(VSASchema.getProgIDFromString(remoteUser), remoteUser));
                pstmt.setString(6, email);
                pstmt.setInt(7, VSASchema.getProgIDFromString(remoteUser));
                pstmt.setString(8, "na");
                pstmt.setString(9, "y");
                int i = 0;
                while (i < 10) {
                    pstmt.setInt(10 + i, 0);
                    ++i;
                }
                pstmt.setNull(20, 12);
                pstmt.setInt(21, archiveID);
                return pstmt;
            }
            if (archiveID == 4 && remoteUser.toLowerCase().trim().startsWith("ges")) {
                PreparedStatement pstmt = con.prepareStatement("insert into wsa_nonSurveyUsers (firstName,lastName,username,password,community,email,programmeid,databasename,sourcetable,numfilterid1,numfilterid2,numfilterid3,numfilterid4,numfilterid5,numfilterid6,numfilterid7,numfilterid8,numfilterid9,numfilterid10,schemaversion,archiveID) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                pstmt.setString(1, firstName);
                pstmt.setString(2, lastName);
                pstmt.setString(3, userName);
                pstmt.setString(4, passwd1);
                pstmt.setString(5, String.valueOf(GESSchema.GESCOMMUNITYPREFIX) + community);
                pstmt.setString(6, email);
                pstmt.setInt(7, 75);
                pstmt.setString(8, "na");
                pstmt.setString(9, "y");
                int i = 0;
                while (i < 10) {
                    pstmt.setInt(10 + i, 0);
                    ++i;
                }
                pstmt.setNull(20, 12);
                pstmt.setInt(21, archiveID);
                return pstmt;
            }
            if (archiveID == 3 && OSASchema.isCommunityValidForUser(community, remoteUser)) {
                PreparedStatement pstmt = con.prepareStatement("insert into wsa_nonSurveyUsers (firstName,lastName,username,password,community,email,programmeid,databasename,sourcetable,numfilterid1,numfilterid2,numfilterid3,numfilterid4,numfilterid5,numfilterid6,numfilterid7,numfilterid8,numfilterid9,numfilterid10,schemaversion,archiveID) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                pstmt.setString(1, firstName);
                pstmt.setString(2, lastName);
                pstmt.setString(3, userName);
                pstmt.setString(4, passwd1);
                pstmt.setString(5, "osa::" + community);
                pstmt.setString(6, email);
                pstmt.setInt(7, OSASchema.getProgIDFromString(remoteUser));
                pstmt.setString(8, "na");
                pstmt.setString(9, "y");
                int i = 0;
                while (i < 10) {
                    pstmt.setInt(10 + i, 0);
                    ++i;
                }
                pstmt.setNull(20, 12);
                pstmt.setInt(21, archiveID);
                return pstmt;
            }
            return null;
        }
        catch (Exception e) {
            System.out.println(e);
            return null;
        }
    }

    public static PreparedStatement getAddUserUHSPrepareStmt(Connection con, int archiveID, String remoteUser, String userName, String community, String lastName, String firstName, String passwd1, String email, String IPAddress) {
        try {
            if (archiveID == 1) {
                PreparedStatement pstmt = con.prepareStatement("insert into wsa_nonSurveyUsers (firstName,lastName,username,password,community,email,programmeid,databasename,sourcetable,numfilterid1,numfilterid2,numfilterid3,numfilterid4,numfilterid5,numfilterid6,numfilterid7,numfilterid8,numfilterid9,numfilterid10,schemaversion,archiveID) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                pstmt.setString(1, firstName);
                pstmt.setString(2, lastName);
                pstmt.setString(3, userName);
                pstmt.setString(4, passwd1);
                pstmt.setString(5, "UHS");
                if (community.equalsIgnoreCase("arizona.edu")) {
                    pstmt.setString(6, email);
                } else {
                    pstmt.setString(6, community);
                }
                pstmt.setInt(7, 107);
                pstmt.setString(8, "na");
                pstmt.setString(9, "y");
                int i = 0;
                while (i < 10) {
                    pstmt.setInt(10 + i, 0);
                    ++i;
                }
                pstmt.setNull(20, 12);
                pstmt.setInt(21, archiveID);
                return pstmt;
            }
            if (archiveID == 2) {
                PreparedStatement pstmt = con.prepareStatement("insert into wsa_nonSurveyUsers (firstName,lastName,username,password,community,email,programmeid,databasename,sourcetable,numfilterid1,numfilterid2,numfilterid3,numfilterid4,numfilterid5,numfilterid6,numfilterid7,numfilterid8,numfilterid9,numfilterid10,schemaversion,archiveID) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                pstmt.setString(1, firstName);
                pstmt.setString(2, lastName);
                pstmt.setString(3, userName);
                pstmt.setString(4, passwd1);
                pstmt.setString(5, VSASchema.getProprietaryCommunity(VSASchema.getProgIDFromString(remoteUser), remoteUser));
                pstmt.setString(6, email);
                pstmt.setInt(7, VSASchema.getProgIDFromString(remoteUser));
                pstmt.setString(8, "na");
                pstmt.setString(9, "y");
                int i = 0;
                while (i < 10) {
                    pstmt.setInt(10 + i, 0);
                    ++i;
                }
                pstmt.setNull(20, 12);
                pstmt.setInt(21, archiveID);
                return pstmt;
            }
            return null;
        }
        catch (Exception e) {
            System.out.println(e);
            return null;
        }
    }

    public static PreparedStatement setAddUserPrepareStmt(PreparedStatement addPstmt, int archiveID, String remoteUser, String userName, String community, String lastName, String firstName, String passwd1, String email, String IPAddress) {
        try {
            if (archiveID == 1) {
                addPstmt.setString(1, lastName);
                addPstmt.setString(2, firstName);
                addPstmt.setString(3, userName);
                addPstmt.setString(4, community);
                addPstmt.setString(5, passwd1);
                addPstmt.setString(6, email);
                addPstmt.setString(7, IPAddress);
                addPstmt.addBatch();
                return addPstmt;
            }
            if (archiveID == 2) {
                addPstmt.setString(1, firstName);
                addPstmt.setString(2, lastName);
                addPstmt.setString(3, userName);
                addPstmt.setString(4, passwd1);
                addPstmt.setString(5, VSASchema.getProprietaryCommunity(VSASchema.getProgIDFromString(remoteUser), remoteUser));
                addPstmt.setString(6, email);
                addPstmt.setInt(7, VSASchema.getProgIDFromString(remoteUser));
                addPstmt.setString(8, "na");
                addPstmt.setString(9, "y");
                int i = 0;
                while (i < 10) {
                    addPstmt.setInt(10 + i, 0);
                    ++i;
                }
                addPstmt.setNull(20, 12);
                addPstmt.addBatch();
                return addPstmt;
            }
            return null;
        }
        catch (Exception e) {
            System.out.println(e);
            return null;
        }
    }

    public static PreparedStatement getAddUserPrepareStmt(Connection con, int archiveID) {
        try {
            if (archiveID == 1) {
                PreparedStatement addPstmt = con.prepareStatement("insert into wsa_users (lastName,firstName,username,community,password,email,ipaddress) values (?,?,?,?,?,?,?)");
                return addPstmt;
            }
            if (archiveID == 2) {
                PreparedStatement addPstmt = con.prepareStatement("insert into wsa_nonSurveyUsers (firstName,lastName,username,password,community,email,programmeid,databasename,sourcetable,numfilterid1,numfilterid2,numfilterid3,numfilterid4,numfilterid5,numfilterid6,numfilterid7,numfilterid8,numfilterid9,numfilterid10,schemaversion,archiveID) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                return addPstmt;
            }
            return null;
        }
        catch (Exception e) {
            System.out.println(e);
            return null;
        }
    }

    public static PreparedStatement getListUserPrepareStmt(Connection con, int archiveID, String remoteUser, String community, String userName) {
        try {
            if (archiveID == 1) {
                if (community.equalsIgnoreCase("arizona.edu")) {
                    PreparedStatement pstmt = con.prepareStatement("select top 500 lastName,firstName,username,email from wsa_nonsurveyusers where community=? and email like ? and (username like ? or firstname like ? or lastname like ? )");
                    pstmt.setString(1, "uhs");
                    pstmt.setString(2, "%arizona%");
                    pstmt.setString(3, "%" + userName + "%");
                    pstmt.setString(4, "%" + userName + "%");
                    pstmt.setString(5, "%" + userName + "%");
                    return pstmt;
                }
                PreparedStatement pstmt = con.prepareStatement("select top 500 lastName,firstName,username,email from wsa_users where community=? and (username like ? or firstname like ? or lastname like ? )");
                pstmt.setString(1, community);
                pstmt.setString(2, "%" + userName + "%");
                pstmt.setString(3, "%" + userName + "%");
                pstmt.setString(4, "%" + userName + "%");
                return pstmt;
            }
            if (archiveID == 2) {
                PreparedStatement pstmt = con.prepareStatement("select top 500 lastName,firstName,username,email from wsa_nonSurveyUsers where community=? and (username like ? or firstname like ? or lastname like ? )");
                pstmt.setString(1, VSASchema.getProprietaryCommunity(VSASchema.getProgIDFromString(remoteUser), remoteUser));
                pstmt.setString(2, "%" + userName + "%");
                pstmt.setString(3, "%" + userName + "%");
                pstmt.setString(4, "%" + userName + "%");
                return pstmt;
            }
            if (archiveID == 4 && remoteUser.toLowerCase().trim().startsWith("ges")) {
                PreparedStatement pstmt = con.prepareStatement("select top 500 lastName,firstName,username,email from wsa_nonSurveyUsers where archiveID=4 and community=? and (username like ? or firstname like ? or lastname like ? )");
                pstmt.setString(1, String.valueOf(GESSchema.GESCOMMUNITYPREFIX) + community);
                pstmt.setString(2, "%" + userName + "%");
                pstmt.setString(3, "%" + userName + "%");
                pstmt.setString(4, "%" + userName + "%");
                return pstmt;
            }
            if (archiveID == 3 && OSASchema.isCommunityValidForUser(community, remoteUser)) {
                PreparedStatement pstmt = con.prepareStatement("select top 500 lastName,firstName,username,email from wsa_nonSurveyUsers where archiveID=3 and community=? and (username like ? or firstname like ? or lastname like ? )");
                pstmt.setString(1, "osa::" + community);
                pstmt.setString(2, "%" + userName + "%");
                pstmt.setString(3, "%" + userName + "%");
                pstmt.setString(4, "%" + userName + "%");
                return pstmt;
            }
            return null;
        }
        catch (Exception e) {
            System.out.println(e);
            return null;
        }
    }

    public static PreparedStatement getCheckCommunityPrepareStmt(Connection con, int archiveID, String remoteUser, String community) {
        try {
            if (archiveID == 1) {
                PreparedStatement pstmt = con.prepareStatement("select * from wsa_community where community=?");
                pstmt.setString(1, community);
                return pstmt;
            }
            if (archiveID == 2) {
                PreparedStatement pstmt = con.prepareStatement("select top 1 * from wsa_community where community=?");
                pstmt.setString(1, VSASchema.getProprietaryCommunity(VSASchema.getProgIDFromString(remoteUser), remoteUser));
                return pstmt;
            }
            if (archiveID == 4 && remoteUser.toLowerCase().trim().startsWith("ges")) {
                PreparedStatement pstmt = con.prepareStatement("select top 1 * from wsa_community where community=?");
                pstmt.setString(1, String.valueOf(GESSchema.GESCOMMUNITYPREFIX) + community);
                return pstmt;
            }
            if (archiveID == 3 && OSASchema.isCommunityValidForUser(community, remoteUser)) {
                PreparedStatement pstmt = con.prepareStatement("select top 1 * from wsa_community where community=?");
                pstmt.setString(1, "osa::" + community);
                return pstmt;
            }
            return null;
        }
        catch (Exception e) {
            System.out.println(e);
            return null;
        }
    }

    public static PreparedStatement getAddCommunityPrepareStmt(Connection con, int archiveID, String community) {
        try {
            if (archiveID == 4) {
                PreparedStatement pstmt = con.prepareStatement("insert into wsa_community (community) values (?)");
                pstmt.setString(1, String.valueOf(GESSchema.GESCOMMUNITYPREFIX) + community);
                return pstmt;
            }
            if (archiveID == 1) {
                PreparedStatement pstmt = con.prepareStatement("insert into wsa_community (community) values (?)");
                pstmt.setString(1, community);
                return pstmt;
            }
            return null;
        }
        catch (Exception e) {
            System.out.println(e);
            return null;
        }
    }

    public static String getCheckCommunitySQL(int archiveID, String remoteUser, String community) {
        if (archiveID == 1) {
            return "select * from wsa_community where community='" + community + "'";
        }
        if (archiveID == 2) {
            return "select top 1 * from wsa_nonSurveyUsers where community='" + community + "'";
        }
        return null;
    }
}

