/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.roe.wfau;

import javax.servlet.http.HttpSession;
import uk.ac.roe.wfau.GESSession;
import uk.ac.roe.wfau.LegacySession;
import uk.ac.roe.wfau.OSASession;
import uk.ac.roe.wfau.VDFSSchema;
import uk.ac.roe.wfau.VSASession;
import uk.ac.roe.wfau.WSASession;

public class VDFSSession {
    static final int UKIDSSTESTERCLASS = 0;
    static final int UKIDSSCLASS = 1;
    static final int WORLDCLASS = 2;
    static final int PRERELEASECLASS = 3;
    static final int NONSURVEYCLASS = 4;
    static final int VISTATESTERCLASS = 5;

    public static String getProgID(HttpSession sess) {
        if (sess.getAttribute("programmeID") != null) {
            return ((String)sess.getAttribute("programmeID")).trim();
        }
        return "-999";
    }

    public static Object getAttribute(HttpSession sess, int archiveID, String attName) {
        switch (archiveID) {
            case 2: {
                return sess.getAttribute("vsa" + attName);
            }
            case 3: {
                return sess.getAttribute("osa" + attName);
            }
            case 4: {
                return sess.getAttribute("ges" + attName);
            }
            case 5: {
                return sess.getAttribute("legacy" + attName);
            }
        }
        return sess.getAttribute(attName);
    }

    public static String getProgID(HttpSession sess, int archiveID) {
        switch (archiveID) {
            case 2: {
                return VSASession.getProgID(sess);
            }
            case 3: {
                return OSASession.getProgID(sess);
            }
            case 4: {
                return GESSession.getProgID(sess);
            }
            case 5: {
                return LegacySession.getProgID(sess);
            }
        }
        return WSASession.getProgID(sess);
    }

    public static String getCommunity(HttpSession sess, int archiveID) {
        switch (archiveID) {
            case 2: {
                return VSASession.getCommunity(sess);
            }
            case 3: {
                return OSASession.getCommunity(sess);
            }
            case 4: {
                return GESSession.getCommunity(sess);
            }
            case 5: {
                return LegacySession.getCommunity(sess);
            }
        }
        return WSASession.getCommunity(sess);
    }

    public static String getUser(HttpSession sess, int archiveID, boolean generic) {
        switch (archiveID) {
            case 2: {
                return VSASession.getUser(sess, generic);
            }
            case 4: {
                return GESSession.getUser(sess, generic);
            }
            case 5: {
                return LegacySession.getUser(sess, generic);
            }
            case 3: {
                return OSASession.getUser(sess, generic);
            }
        }
        return WSASession.getUser(sess, generic);
    }

    public static String getUser(HttpSession sess, int archiveID) {
        return VDFSSession.getUser(sess, archiveID, false);
    }

    public static String getCommunity(HttpSession sess) {
        if (sess.getAttribute("community") != null) {
            String community = ((String)sess.getAttribute("community")).toLowerCase().trim();
            if (community != null) {
                return community;
            }
            return "world";
        }
        return "world";
    }

    public static boolean getLoginBoolean(HttpSession sess, String archive) {
        if (archive.equalsIgnoreCase("VSA")) {
            return VSASession.getLoginBoolean(sess);
        }
        if (archive.equalsIgnoreCase("GES")) {
            return GESSession.getLoginBoolean(sess);
        }
        if (archive.equalsIgnoreCase("Legacy")) {
            return LegacySession.getLoginBoolean(sess);
        }
        if (archive.equalsIgnoreCase("OSA")) {
            return OSASession.getLoginBoolean(sess);
        }
        return WSASession.getLoginBoolean(sess);
    }

    public static String getDBUser(HttpSession sess, String archive) {
        switch (VDFSSchema.getArchiveID(archive)) {
            case 1: {
                return WSASession.getDBUser(sess);
            }
            case 4: {
                return GESSession.getDBUser(sess);
            }
            case 5: {
                return LegacySession.getDBUser(sess);
            }
            case 2: {
                return VSASession.getDBUser(sess);
            }
            case 3: {
                return OSASession.getDBUser(sess);
            }
            case 0: {
                return "ssaro";
            }
        }
        return WSASession.getDBUser(sess);
    }

    public static int getSessionClass(HttpSession sess, String archive) {
        if (archive.equalsIgnoreCase("VSA")) {
            return VSASession.getSessionClass(sess);
        }
        return WSASession.getSessionClass(sess);
    }

    public static String getDefaultDatabase(HttpSession sess, String archive) {
        if (archive.equalsIgnoreCase("VSA")) {
            return null;
        }
        return null;
    }

    public static String[] getServers(String community, String archive, String[] WSASERVERS, String[] WSACUSERVERS, String[] VSASERVERS, String[] VSACUSERVERS, String[] WSANSSERVERS) {
        if (!community.equalsIgnoreCase("nonSurvey")) {
            return VDFSSession.getServers(community, archive, WSASERVERS, WSACUSERVERS, VSASERVERS, VSACUSERVERS);
        }
        return VDFSSession.getServers(community, archive, WSANSSERVERS, WSACUSERVERS, VSASERVERS, VSACUSERVERS);
    }

    public static String[] getServers(String community, String archive, String[] WSASERVERS, String[] WSACUSERVERS, String[] VSASERVERS, String[] VSACUSERVERS) {
        if (archive != null && archive.equalsIgnoreCase("vsa")) {
            if (!community.equalsIgnoreCase("prerelease")) {
                return VSASERVERS;
            }
            return VSACUSERVERS;
        }
        if (!community.equalsIgnoreCase("prerelease")) {
            return WSASERVERS;
        }
        return WSACUSERVERS;
    }

    public static String[] getServers(HttpSession sess, String archive, String[] WSASERVERS, String[] WSACUSERVERS, String[] VSASERVERS, String[] VSACUSERVERS) {
        return VDFSSession.getServers(WSASession.getCommunity(sess), archive, WSASERVERS, WSACUSERVERS, VSASERVERS, VSACUSERVERS);
    }
}

