/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.roe.wfau;

import java.io.FileInputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Properties;
import javax.servlet.http.HttpSession;
import uk.ac.roe.wfau.LoadVSAColumns;
import uk.ac.roe.wfau.LoadVSAProperties;
import uk.ac.roe.wfau.WSASchema;
import uk.ac.roe.wfau.WSASession;

public class VSASchema
extends WSASchema {
    public static String[] WORLDCOMMDB;
    public static String[] WORLDVHSDB;
    public static String[] WORLDVVVDB;
    public static String[] WORLDSHARKSDB;
    public static String[] WORLDVVVXDB;
    public static String[] WORLDGCAVDB;
    public static String[] WORLDVISIONSDB;
    public static String[] WORLDVEILSDB;
    public static String[] WORLDVINROUGEDB;
    public static String[] WORLDVMCDB;
    public static String[] WORLDVMCDEEPDB;
    public static String[] WORLDVIKINGDB;
    public static String[] WORLDVIDEODB;
    public static String[] WORLDULTRAVISTADB;
    public static String[] WORLDSVORIONDB;
    public static String[] WORLDSVNGC253DB;
    public static String[] WORLDCALDB;
    public static String[] WORLDGCSDB;
    public static String[] EQUIVWORLDCOMMDB;
    public static String[] EQUIVWORLDVHSDB;
    public static String[] EQUIVWORLDVVVDB;
    public static String[] EQUIVWORLDSHARKSDB;
    public static String[] EQUIVWORLDVVVXDB;
    public static String[] EQUIVWORLDGCAVDB;
    public static String[] EQUIVWORLDVISIONSDB;
    public static String[] EQUIVWORLDVEILSDB;
    public static String[] EQUIVWORLDVINROUGEDB;
    public static String[] EQUIVWORLDVMCDB;
    public static String[] EQUIVWORLDVMCDEEPDB;
    public static String[] EQUIVWORLDVIKINGDB;
    public static String[] EQUIVWORLDVIDEODB;
    public static String[] EQUIVWORLDULTRAVISTADB;
    public static String[] EQUIVWORLDSVORIONDB;
    public static String[] EQUIVWORLDSVNGC253DB;
    public static String[] EQUIVWORLDCALDB;
    public static String[] EQUIVWORLDGCSDB;
    public static HashMap colMap;
    public static HashMap vsaHM;
    public static String[] COMMDB;
    public static String[] VHSDB;
    public static String[] VVVDB;
    public static String[] SHARKSDB;
    public static String[] VVVXDB;
    public static String[] GCAVDB;
    public static String[] VISIONSDB;
    public static String[] VEILSDB;
    public static String[] VINROUGEDB;
    public static String[] VMCDB;
    public static String[] VMCDEEPDB;
    public static String[] VIKINGDB;
    public static String[] VIDEODB;
    public static String[] ULTRAVISTADB;
    public static String[] SVORIONDB;
    public static String[] SVNGC253DB;
    public static String[] CALDB;
    public static final String LATESTUKIDSSDATABASE = "ukidssdr5plus";
    public static final String LATESTWORLDDATABASE = "ukidssdr3plus";
    public static final String[] SCEHMAVALIDDATABASES;
    public static final String LATESTUKIDSSSCHEMA = "ukidssdr5plus";
    public static final String LATESTWORLDSCHEMA = "ukidssdr3plus";
    public static final String LATESTNONSURVEYSCHEMA = "ukidssr2";
    public static final String PRERELEASESERVER = "ramses2";
    public static final String PRERELEASEDATABASE = "VSA";
    public static final String PRERELEASECOMMUNITY = "prerelease";
    public static final String NONSURVEYCOMMUNITY = "nonSurvey";
    public static final String PROPRIETARYCOMMUNITY = "Proprietary";
    public static final String SESSIONPROPRIETARYCOMMUNITY = "vsaProprietary";
    public static String NODBAVAILABLE;
    public static String[] GCSDB;
    public static String[] SURVEYACRONYMS;
    public static int COMMVERISONSCHEMA;
    public static int VHSVERISONSCHEMA;
    public static int VVVVERISONSCHEMA;
    public static int SHARKSVERISONSCHEMA;
    public static int VVVXVERISONSCHEMA;
    public static int GCAVVERISONSCHEMA;
    public static int VISIONSVERISONSCHEMA;
    public static int VEILSVERISONSCHEMA;
    public static int VINROUGEVERISONSCHEMA;
    public static int VMCVERISONSCHEMA;
    public static int VMCDEEPVERISONSCHEMA;
    public static int VIKINGVERISONSCHEMA;
    public static int VIDEOVERISONSCHEMA;
    public static int ULTRAVISTAVERISONSCHEMA;
    public static int SVORIONVERISONSCHEMA;
    public static int SVNGC253VERISONSCHEMA;
    public static int CALVERSIONSCHEMA;
    public static final String[] ALLUKIDSSRDB;
    public static final int[] UKIDSSVERSIONS;
    public static final String[] UKIDSSTESTERDB;
    public static final int VERSIONOFSOURCEVIEWS = 99;
    public static final String PTSDB = "Transit";
    public static final String OPENDB = "VISTAOPENTIME";
    public static final String[] extraDB;
    public static final String[] moreDB;
    public static final boolean doExtraDB = true;
    public static final String[] UKIDSSDB;
    public static final String[] WORLDDB;
    public static final int[] WORLDVERSIONS;
    public static final String[] PRERELEASEDB;
    public static final boolean accessToRollingDB = true;
    public static final String rollingDB = "VSA_DailySync";
    public static final String actualRollingDB = "VISTAPROPRIETY";
    public static final String prevRollingDB = "VSA_DailySync";
    public static final String prevActualRollingDB = "VISTAPROPRIETY";
    public static final String[] rollingDBs;
    public static final String[] actualRollingDBs;
    public static final String rollingServer = "amenhotep";
    public static final String rollingDBUser = "wsaro";
    public static final String rollingDBPasswd = "wsaropw";
    public static final String noAccessDB = "sorry no access";
    public static final int COMMISSIONINGPROGRAMMEID = 1;
    public static final int CURATIONTESTPROGRAMMEID = 99;
    public static final int ALLPROGRAMMEID = 0;
    public static final int VHSPROGRAMMEID = 110;
    public static final int VVVPROGRAMMEID = 120;
    public static final int SHARKSPROGRAMMEID = 175;
    public static final int VVVXPROGRAMMEID = 170;
    public static final int GCAVPROGRAMMEID = 180;
    public static final int VISIONSPROGRAMMEID = 185;
    public static final int VEILSPROGRAMMEID = 190;
    public static final int VINROUGEPROGRAMMEID = 195;
    public static final int VMCPROGRAMMEID = 130;
    public static final int VMCDEEPPROGRAMMEID = 135;
    public static final int VIKINGPROGRAMMEID = 140;
    public static final int VIDEOPROGRAMMEID = 150;
    public static final int ULTRAVISTAPROGRAMMEID = 160;
    public static final int SVORIONPROGRAMMEID = 100;
    public static final int SVNGC253PROGRAMMEID = 101;
    public static final int CALPROGRAMMEID = 200;
    public static final String ALLSURVEYS = "All VISTA surveys";
    public static final int MAXIMUMROWSTOFILE = 15000000;
    public static int FITS_OFFSET;
    public static final int VISTANONEFILTERID = 0;
    public static final int VISTAZFILTERID = 1;
    public static final int VISTAYFILTERID = 2;
    public static final int VISTAJFILTERID = 3;
    public static final int VISTAHFILTERID = 4;
    public static final int VISTAKFILTERID = 5;
    public static final int VISTAH2FILTERID = 6;
    public static final int VISTABRFILTERID = 7;
    public static final int VISTABLANKFILTERID = 8;
    public static final int VISTANB118FILTERID = 9;
    public static final int VISTANB980985FILTERID = 10;
    public static final int VISTANSUNBLINDFILTERID = 11;
    public static final int[] ALLFILTERID;
    public static final int[] UKIDSSTESTERPROGS;
    public static final int[] UKIDSSPROGS;
    public static final int[] WORLDPROGS;
    public static final int[] PRERELEASEPROGS;
    public static final int[] VISTAPROGS;
    public static final int[] VISTATESTERPROGS;
    public static final String COMMDETECTIONTABLENAME = "commDetection";
    public static final String VHSDETECTIONTABLENAME = "vhsDetection";
    public static final String VVVDETECTIONTABLENAME = "vvvDetection";
    public static final String SHARKSDETECTIONTABLENAME = "sharksDetection";
    public static final String VVVXDETECTIONTABLENAME = "vvvxDetection";
    public static final String GCAVDETECTIONTABLENAME = "gcavDetection";
    public static final String VISIONSDETECTIONTABLENAME = "visionsDetection";
    public static final String VEILSDETECTIONTABLENAME = "veilsDetection";
    public static final String VINROUGEDETECTIONTABLENAME = "vinrougeDetection";
    public static final String VMCDETECTIONTABLENAME = "vmcDetection";
    public static final String VMCDEEPDETECTIONTABLENAME = "vmcdeepDetection";
    public static final String VIKINGDETECTIONTABLENAME = "vikingDetection";
    public static final String VIDEODETECTIONTABLENAME = "videoDetection";
    public static final String ULTRAVISTADETECTIONTABLENAME = "ultravistaDetection";
    public static final String SVORIONDETECTIONTABLENAME = "svOrionDetection";
    public static final String SVNGC253DETECTIONTABLENAME = "svNgc253Detection";
    public static final String CALDETECTIONTABLENAME = "calDetection";
    public static final String COMMSOURCETABLENAME = "commSource";
    public static final String VHSSOURCETABLENAME = "vhsSource";
    public static final String VVVSOURCETABLENAME = "vvvSource";
    public static final String SHARKSSOURCETABLENAME = "sharksSource";
    public static final String VVVXSOURCETABLENAME = "vvvxSource";
    public static final String GCAVSOURCETABLENAME = "gcavSource";
    public static final String VISIONSSOURCETABLENAME = "visionsSource";
    public static final String VEILSSOURCETABLENAME = "veilsSource";
    public static final String VINROUGESOURCETABLENAME = "vinrougeSource";
    public static final String VMCSOURCETABLENAME = "vmcSource";
    public static final String VMCDEEPSOURCETABLENAME = "vmcdeepSource";
    public static final String VIKINGSOURCETABLENAME = "vikingSource";
    public static final String VIDEOSOURCETABLENAME = "videoSource";
    public static final String ULTRAVISTASOURCETABLENAME = "ultravistaSource";
    public static final String SVORIONSOURCETABLENAME = "svOrionSource";
    public static final String SVNGC253SOURCETABLENAME = "svNgc253Source";
    public static final String CALSOURCETABLENAME = "NONE";
    public static final String VVVSYNOPTICSOURCETABLENAME = "vvvSynopticSource";
    public static final String VMCSYNOPTICSOURCETABLENAME = "vmcSynopticSource";
    public static final String VMCDEEPSYNOPTICSOURCETABLENAME = "vmcdeepSynopticSource";
    public static final String COMMSOURCEVIEWNAME = "undef";
    public static final String VHSSOURCEVIEWNAME = "undef";
    public static final String VVVSOURCEVIEWNAME = "undef";
    public static final String SHARKSSOURCEVIEWNAME = "undef";
    public static final String VVVXSOURCEVIEWNAME = "undef";
    public static final String GCAVSOURCEVIEWNAME = "undef";
    public static final String VISIONSSOURCEVIEWNAME = "undef";
    public static final String VEILSSOURCEVIEWNAME = "undef";
    public static final String VINROUGESOURCEVIEWNAME = "undef";
    public static final String VMCSOURCEVIEWNAME = "undef";
    public static final String VMCDEEPSOURCEVIEWNAME = "undef";
    public static final String VIKINGSOURCEVIEWNAME = "undef";
    public static final String VIDEOSOURCEVIEWNAME = "undef";
    public static final String ULTRAVISTASOURCEVIEWNAME = "undef";
    public static final String SVORIONSOURCEVIEWNAME = "undef";
    public static final String SVNGC253SOURCEVIEWNAME = "undef";
    public static final String CALSOURCEVIEWNAME = "undef";
    public static final String UKIDSSLASSOURCEVIEWNAME = "lasYJHKsource";
    public static final String UKIDSSGPSSOURCEVIEWNAME = "gpsJHKsource";
    public static final String UKIDSSGCSSOURCEVIEWNAME = "gcsZYJHKsource";
    public static final String UKIDSSDXSSOURCEVIEWNAME = "dxsJKSource";
    public static final String UKIDSSUDSSOURCEVIEWNAME;
    public static final String PTSSOURCETABLENAME = "NONE";
    public static final String COMMISSIONINGMERGETABLENAME = "commMergeLog";
    public static final String UKIDSSLASMERGETABLENAME = "lasMergeLog";
    public static final String UKIDSSGPSMERGETABLENAME = "gpsMergeLog";
    public static final String UKIDSSGCSMERGETABLENAME = "gcsMergeLog";
    public static final String UKIDSSDXSMERGETABLENAME = "dxsMergeLog";
    public static final String UKIDSSUDSMERGETABLENAME = "udsMergeLog";
    public static final String UKIDSSPTSMERGETABLENAME = "NONE";
    public static final String VHSMERGETABLENAME = "vhsMergeLog";
    public static final String VVVMERGETABLENAME = "vvvMergeLog";
    public static final String SHARKSMERGETABLENAME = "sharksMergeLog";
    public static final String VVVXMERGETABLENAME = "vvvxMergeLog";
    public static final String GCAVMERGETABLENAME = "gcavMergeLog";
    public static final String VISIONSMERGETABLENAME = "visionsMergeLog";
    public static final String VEILSMERGETABLENAME = "veilsMergeLog";
    public static final String VINROUGEMERGETABLENAME = "vinrougeMergeLog";
    public static final String VMCMERGETABLENAME = "vmcMergeLog";
    public static final String VMCDEEPMERGETABLENAME = "vmcdeepMergeLog";
    public static final String VIKINGMERGETABLENAME = "vikingMergeLog";
    public static final String VIDEOMERGETABLENAME = "videoMergeLog";
    public static final String ULTRAVISTAMERGETABLENAME = "ultravistaMergeLog";
    public static final String SVORIONMERGETABLENAME = "svOrionMergeLog";
    public static final String SVNGC253MERGETABLENAME = "svNgc253MergeLog";
    public static final String DEFAULTSQLSERVER = "amenhotep";
    public static final String UKIDSSLOGIN = "wsaro";
    public static final String WORLDLOGIN = "worldwsaro";
    public static final String[] WFCAMFILTERS;
    public static final String[] VISTAFILTERS;
    public static final String[] filters;
    public static final String[] COMMISSIONINGBands;
    public static final int[] COMMISSIONINGREQFILTERS;
    public static final int[] SVORIONREQFILTERS;
    public static final int[] SVNGC253REQFILTERS;
    public static final int[] VHSREQFILTERS;
    public static final int[] VVVREQFILTERS;
    public static final int[] SHARKSREQFILTERS;
    public static final int[] VVVXREQFILTERS;
    public static final int[] GCAVREQFILTERS;
    public static final int[] VISIONSREQFILTERS;
    public static final int[] VEILSREQFILTERS;
    public static final int[] VINROUGEREQFILTERS;
    public static final int[] VMCREQFILTERS;
    public static final int[] VMCDEEPREQFILTERS;
    public static final int[] VIKINGREQFILTERS;
    public static final int[] VIDEOREQFILTERS;
    public static final int[] ULTRAVISTAREQFILTERS;
    public static final int[] CALREQFILTERS;
    public static final String[] LASRGB;
    public static final String[] GPSRGB;
    public static final String[] GCSRGB;
    public static final String[] DXSRGB;
    public static final String[] UDSRGB;
    public static final String[] VHSRGB;
    public static final String[] VVVRGB;
    public static final String[] VIKINGRGB;
    public static final String[] VIDEORGB;
    public static final String[] VMCRGB;
    public static final String[] VMCDEEPRGB;
    public static final String[] VHSBands;
    public static final String[] VVVBands;
    public static final String[] SHARKSBands;
    public static final String[] VVVXBands;
    public static final String[] GCAVBands;
    public static final String[] VISIONSBands;
    public static final String[] VEILSBands;
    public static final String[] VINROUGEBands;
    public static final String[] LASBands;
    public static final int[] LASREQFILTERS;
    public static final String[] GPSBands;
    public static final int[] GPSREQFILTERS;
    public static final int[] GPSREQFILTERSDR2;
    public static final String[] GCSBands;
    public static final int[] GCSREQFILTERS;
    public static final String[] DXSBands;
    public static final int[] DXSREQFILTERS;
    public static final String[] UDSBands;
    public static final int[] UDSREQFILTERS;

    static {
        COMMDB = new String[0];
        VHSDB = new String[0];
        VVVDB = new String[0];
        SHARKSDB = new String[0];
        VVVXDB = new String[0];
        GCAVDB = new String[0];
        VISIONSDB = new String[0];
        VEILSDB = new String[0];
        VINROUGEDB = new String[0];
        VMCDB = new String[0];
        VMCDEEPDB = new String[0];
        VIKINGDB = new String[0];
        VIDEODB = new String[0];
        ULTRAVISTADB = new String[0];
        SVORIONDB = new String[0];
        SVNGC253DB = new String[0];
        CALDB = new String[0];
        LoadVSAProperties.getSingletonObject();
        LoadVSAColumns.getSingletonObject();
        SCEHMAVALIDDATABASES = new String[]{"ukidssdr5plus", "ukidssdr4plus", "ukidssdr3plus"};
        NODBAVAILABLE = "No database available";
        GCSDB = new String[]{"UKIDSSDR5PLUS", "UKIDSSDR3PLUS", "UKIDSSDR2PLUS"};
        SURVEYACRONYMS = new String[]{"VHS", "VVV", "VMC", "VIKING", "VIDEO", "ULTRAVISTA", "VVVE", "VVVS", "SHARKS", "VVVX", "GCAV", "VISIONS", "VEILS", "VINROUGE", "VVVXE", "VVVXS", "VMCDEEP"};
        COMMVERISONSCHEMA = 0;
        VHSVERISONSCHEMA = 0;
        VVVVERISONSCHEMA = 0;
        SHARKSVERISONSCHEMA = 0;
        VVVXVERISONSCHEMA = 0;
        GCAVVERISONSCHEMA = 0;
        VISIONSVERISONSCHEMA = 0;
        VEILSVERISONSCHEMA = 0;
        VINROUGEVERISONSCHEMA = 0;
        VMCVERISONSCHEMA = 0;
        VMCDEEPVERISONSCHEMA = 0;
        VIKINGVERISONSCHEMA = 0;
        VIDEOVERISONSCHEMA = 0;
        ULTRAVISTAVERISONSCHEMA = 0;
        SVORIONVERISONSCHEMA = 0;
        SVNGC253VERISONSCHEMA = 0;
        CALVERSIONSCHEMA = 0;
        ALLUKIDSSRDB = new String[]{"UKIDSSDR5PLUS", "UKIDSSDR4PLUS", "UKIDSSDR3PLUS", "UKIDSSDR2PLUS", "UKIDSSDR1PLUS", "UKIDSSDR1", "UKIDSSEDRPLUS", "UKIDSSEDR", "UKIDSSSV", "UKIDSSR1"};
        int[] nArray = new int[10];
        nArray[0] = 7;
        nArray[1] = 6;
        nArray[2] = 5;
        nArray[3] = 4;
        nArray[4] = 3;
        nArray[5] = 3;
        nArray[6] = 2;
        nArray[7] = 2;
        nArray[8] = 1;
        UKIDSSVERSIONS = nArray;
        UKIDSSTESTERDB = ALLUKIDSSRDB;
        extraDB = new String[]{PRERELEASEDATABASE};
        moreDB = new String[]{OPENDB};
        UKIDSSDB = new String[]{"UKIDSSDR5PLUS", "UKIDSSDR4PLUS", "UKIDSSDR3PLUS", "UKIDSSDR2PLUS", "UKIDSSDR1PLUS", "UKIDSSDR1", "UKIDSSEDRPLUS", "UKIDSSEDR", "UKIDSSSV"};
        WORLDDB = new String[]{"UKIDSSDR3PLUS", "UKIDSSDR2PLUS", "UKIDSSDR1PLUS", "UKIDSSDR1", "UKIDSSEDRPLUS", "UKIDSSEDR", "UKIDSSSV"};
        WORLDVERSIONS = new int[]{5, 4, 3, 3, 2, 2, 1};
        PRERELEASEDB = new String[]{PRERELEASEDATABASE};
        rollingDBs = new String[]{"VSA_DailySync", "VSA_DailySync"};
        actualRollingDBs = new String[]{"VISTAPROPRIETY", "VISTAPROPRIETY"};
        FITS_OFFSET = 1;
        int[] nArray2 = new int[10];
        nArray2[1] = 1;
        nArray2[2] = 2;
        nArray2[3] = 3;
        nArray2[4] = 4;
        nArray2[5] = 5;
        nArray2[6] = 8;
        nArray2[7] = 9;
        nArray2[8] = 10;
        nArray2[9] = 11;
        ALLFILTERID = nArray2;
        UKIDSSTESTERPROGS = new int[]{101, 102, 103, 104, 105, 11, 12, 13, 14, 15, 1};
        UKIDSSPROGS = new int[]{101, 102, 103, 104, 105};
        WORLDPROGS = UKIDSSPROGS;
        PRERELEASEPROGS = UKIDSSTESTERPROGS;
        VISTAPROGS = new int[]{110, 120, 130, 135, 140, 150, 175, 170, 180, 185, 190, 195, 160, 200};
        VISTATESTERPROGS = new int[VISTAPROGS.length + 1];
        VSASchema.VISTATESTERPROGS[0] = 1;
        int i = 0;
        while (i < VISTAPROGS.length) {
            VSASchema.VISTATESTERPROGS[i + 1] = VISTAPROGS[i];
            ++i;
        }
        UKIDSSUDSSOURCEVIEWNAME = null;
        WFCAMFILTERS = new String[]{"NONE", "Z", "Y", "J", "H", "K", "H2", "Br", "BLNK", "NBJ", "NBH", "NBK"};
        VISTAFILTERS = new String[]{"NONE", "Z", "Y", "J", "H", "Ks", "H2", "Br", "BLNK", "NB118", "NB980", "SUNBLIND"};
        filters = WFCAMFILTERS;
        COMMISSIONINGBands = new String[]{"Z", "Y", "J", "H", "K", "H2", "Br"};
        int[] nArray3 = new int[10];
        nArray3[1] = 1;
        nArray3[2] = 1;
        nArray3[3] = 1;
        nArray3[4] = 1;
        nArray3[5] = 1;
        nArray3[9] = 1;
        COMMISSIONINGREQFILTERS = nArray3;
        int[] nArray4 = new int[10];
        nArray4[1] = 1;
        nArray4[2] = 1;
        nArray4[3] = 1;
        nArray4[4] = 1;
        nArray4[5] = 1;
        SVORIONREQFILTERS = nArray4;
        int[] nArray5 = new int[10];
        nArray5[1] = 1;
        nArray5[3] = 1;
        nArray5[9] = 1;
        SVNGC253REQFILTERS = nArray5;
        int[] nArray6 = new int[10];
        nArray6[2] = 1;
        nArray6[3] = 1;
        nArray6[4] = 1;
        nArray6[5] = 1;
        VHSREQFILTERS = nArray6;
        int[] nArray7 = new int[10];
        nArray7[1] = 1;
        nArray7[2] = 1;
        nArray7[3] = 1;
        nArray7[4] = 1;
        nArray7[5] = 1;
        VVVREQFILTERS = nArray7;
        int[] nArray8 = new int[10];
        nArray8[5] = 1;
        SHARKSREQFILTERS = nArray8;
        int[] nArray9 = new int[10];
        nArray9[3] = 1;
        nArray9[4] = 1;
        nArray9[5] = 1;
        VVVXREQFILTERS = nArray9;
        int[] nArray10 = new int[10];
        nArray10[2] = 1;
        nArray10[3] = 1;
        nArray10[5] = 1;
        GCAVREQFILTERS = nArray10;
        int[] nArray11 = new int[10];
        nArray11[3] = 1;
        nArray11[4] = 1;
        nArray11[5] = 1;
        VISIONSREQFILTERS = nArray11;
        int[] nArray12 = new int[10];
        nArray12[3] = 1;
        nArray12[5] = 1;
        VEILSREQFILTERS = nArray12;
        int[] nArray13 = new int[10];
        nArray13[2] = 1;
        nArray13[3] = 1;
        nArray13[5] = 1;
        VINROUGEREQFILTERS = nArray13;
        int[] nArray14 = new int[10];
        nArray14[2] = 1;
        nArray14[3] = 1;
        nArray14[5] = 1;
        VMCREQFILTERS = nArray14;
        int[] nArray15 = new int[10];
        nArray15[2] = 1;
        nArray15[3] = 1;
        nArray15[5] = 1;
        VMCDEEPREQFILTERS = nArray15;
        int[] nArray16 = new int[10];
        nArray16[1] = 1;
        nArray16[2] = 1;
        nArray16[3] = 1;
        nArray16[4] = 1;
        nArray16[5] = 1;
        VIKINGREQFILTERS = nArray16;
        int[] nArray17 = new int[10];
        nArray17[1] = 1;
        nArray17[2] = 1;
        nArray17[3] = 1;
        nArray17[4] = 1;
        nArray17[5] = 1;
        VIDEOREQFILTERS = nArray17;
        int[] nArray18 = new int[10];
        nArray18[1] = 1;
        nArray18[2] = 1;
        nArray18[3] = 1;
        nArray18[4] = 1;
        nArray18[5] = 1;
        ULTRAVISTAREQFILTERS = nArray18;
        int[] nArray19 = new int[10];
        nArray19[1] = 1;
        nArray19[2] = 1;
        nArray19[3] = 1;
        nArray19[4] = 1;
        nArray19[5] = 1;
        nArray19[9] = 1;
        CALREQFILTERS = nArray19;
        LASRGB = new String[]{"K", "H", "Y"};
        GPSRGB = new String[]{"K", "H", "J"};
        GCSRGB = new String[]{"K", "H", "Z"};
        DXSRGB = new String[]{"K", "H", "J"};
        UDSRGB = new String[]{"K", "H", "J"};
        VHSRGB = new String[]{"Ks", "H", "Y"};
        VVVRGB = new String[]{"Ks", "H", "J"};
        VIKINGRGB = new String[]{"Ks", "H", "Y"};
        VIDEORGB = new String[]{"Ks", "H", "Y"};
        VMCRGB = new String[]{"Ks", "H", "Y"};
        VMCDEEPRGB = new String[]{"Ks", "H", "Y"};
        VHSBands = new String[]{"Y", "J", "H", "K"};
        VVVBands = new String[]{"Z", "Y", "J", "H", "Ks"};
        SHARKSBands = new String[]{"Ks"};
        VVVXBands = new String[]{"J", "H", "Ks"};
        GCAVBands = new String[]{"Y", "J", "Ks"};
        VISIONSBands = new String[]{"J", "H", "Ks"};
        VEILSBands = new String[]{"J", "Ks"};
        VINROUGEBands = new String[]{"Y", "J", "Ks"};
        LASBands = new String[]{"Y", "J_1", "J_2", "H", "K"};
        int[] nArray20 = new int[9];
        nArray20[2] = 1;
        nArray20[3] = 2;
        nArray20[4] = 1;
        nArray20[5] = 1;
        LASREQFILTERS = nArray20;
        GPSBands = new String[]{"J", "H", "K_1", "K_2", "H2"};
        int[] nArray21 = new int[9];
        nArray21[3] = 1;
        nArray21[4] = 1;
        nArray21[5] = 2;
        nArray21[6] = 1;
        GPSREQFILTERS = nArray21;
        int[] nArray22 = new int[8];
        nArray22[2] = 1;
        nArray22[3] = 1;
        nArray22[4] = 3;
        nArray22[5] = 3;
        GPSREQFILTERSDR2 = nArray22;
        GCSBands = new String[]{"Z", "Y", "J", "H", "K_1", "K_2"};
        int[] nArray23 = new int[9];
        nArray23[1] = 1;
        nArray23[2] = 1;
        nArray23[3] = 1;
        nArray23[4] = 1;
        nArray23[5] = 2;
        GCSREQFILTERS = nArray23;
        DXSBands = new String[]{"J", "H", "K"};
        int[] nArray24 = new int[9];
        nArray24[3] = 1;
        nArray24[4] = 1;
        nArray24[5] = 1;
        DXSREQFILTERS = nArray24;
        UDSBands = new String[]{"J", "H", "K"};
        int[] nArray25 = new int[9];
        nArray25[3] = 1;
        nArray25[4] = 1;
        nArray25[5] = 1;
        UDSREQFILTERS = nArray25;
    }

    public static String getPropertyFromFile(String property, String filename) {
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(filename));
            if (properties.getProperty(property) != null) {
                return properties.getProperty(property);
            }
            return "";
        }
        catch (IOException e) {
            return "";
        }
    }

    public static boolean getDoRollingDBFromFile(String filename) {
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(filename));
            return properties.getProperty("doRollingDB").equalsIgnoreCase("true");
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean isProgInDB(String db, int prog) {
        return VSASchema.getVersionNoOfRelease(db) >= VSASchema.getDetectionSchemaVersion(prog) && VSASchema.getVersionNoOfRelease(db) <= VSASchema.getLastSchemaVersion(prog);
    }

    public static boolean isSourceInDB(String db, int prog) {
        return VSASchema.getVersionNoOfRelease(db) >= VSASchema.getSourceSchemaVersion(prog);
    }

    public static int getVersionNoOfRelease(String schema, int surveyID) {
        String[] dbs = new String[]{};
        switch (surveyID) {
            case 1: {
                dbs = COMMDB;
                break;
            }
            case 100: {
                dbs = SVORIONDB;
                break;
            }
            case 101: {
                dbs = SVNGC253DB;
                break;
            }
            case 110: {
                dbs = VHSDB;
                break;
            }
            case 120: {
                dbs = VVVDB;
                break;
            }
            case 175: {
                dbs = SHARKSDB;
                break;
            }
            case 170: {
                dbs = VVVXDB;
                break;
            }
            case 180: {
                dbs = GCAVDB;
                break;
            }
            case 185: {
                dbs = VISIONSDB;
                break;
            }
            case 190: {
                dbs = VEILSDB;
                break;
            }
            case 195: {
                dbs = VINROUGEDB;
                break;
            }
            case 130: {
                dbs = VMCDB;
                break;
            }
            case 135: {
                dbs = VMCDEEPDB;
                break;
            }
            case 140: {
                dbs = VIKINGDB;
                break;
            }
            case 150: {
                dbs = VIDEODB;
                break;
            }
            case 160: {
                dbs = ULTRAVISTADB;
                break;
            }
            case 200: {
                dbs = CALDB;
                break;
            }
        }
        int i = 0;
        while (i < dbs.length) {
            if (schema.equalsIgnoreCase(dbs[i])) {
                return i;
            }
            ++i;
        }
        if (schema.equalsIgnoreCase("VSA_DailySync")) {
            return 9999;
        }
        return -1;
    }

    public static int[] getReqFilters(String database, int surveyID) {
        switch (surveyID) {
            case 1: {
                return COMMISSIONINGREQFILTERS;
            }
            case 100: {
                return SVORIONREQFILTERS;
            }
            case 101: {
                return SVNGC253REQFILTERS;
            }
            case 110: {
                return VHSREQFILTERS;
            }
            case 120: {
                return VVVREQFILTERS;
            }
            case 175: {
                return SHARKSREQFILTERS;
            }
            case 170: {
                return VVVXREQFILTERS;
            }
            case 180: {
                return GCAVREQFILTERS;
            }
            case 185: {
                return VISIONSREQFILTERS;
            }
            case 190: {
                return VEILSREQFILTERS;
            }
            case 195: {
                return VINROUGEREQFILTERS;
            }
            case 130: {
                return VMCREQFILTERS;
            }
            case 135: {
                return VMCDEEPREQFILTERS;
            }
            case 140: {
                return VIKINGREQFILTERS;
            }
            case 150: {
                return VIDEOREQFILTERS;
            }
            case 160: {
                return ULTRAVISTAREQFILTERS;
            }
            case 200: {
                return CALREQFILTERS;
            }
            case 11: {
                return LASREQFILTERS;
            }
            case 102: {
                if (VSASchema.getVersionNoOfRelease(database) >= VSASchema.getVersionNoOfRelease("ukidssdr3plus") || database.equals("") || database == null) {
                    return GPSREQFILTERS;
                }
                return GPSREQFILTERSDR2;
            }
            case 12: {
                if (VSASchema.getVersionNoOfRelease(database) >= VSASchema.getVersionNoOfRelease("ukidssdr3plus")) {
                    return GPSREQFILTERS;
                }
                return GPSREQFILTERSDR2;
            }
        }
        return null;
    }

    public static int[] getReqFilters(int surveyID) {
        switch (surveyID) {
            case 1: {
                return COMMISSIONINGREQFILTERS;
            }
            case 100: {
                return SVORIONREQFILTERS;
            }
            case 101: {
                return SVNGC253REQFILTERS;
            }
            case 110: {
                return VHSREQFILTERS;
            }
            case 120: {
                return VVVREQFILTERS;
            }
            case 175: {
                return SHARKSREQFILTERS;
            }
            case 170: {
                return VVVXREQFILTERS;
            }
            case 180: {
                return GCAVREQFILTERS;
            }
            case 185: {
                return VISIONSREQFILTERS;
            }
            case 190: {
                return VEILSREQFILTERS;
            }
            case 195: {
                return VINROUGEREQFILTERS;
            }
            case 130: {
                return VMCREQFILTERS;
            }
            case 135: {
                return VMCDEEPREQFILTERS;
            }
            case 140: {
                return VIKINGREQFILTERS;
            }
            case 150: {
                return VIDEOREQFILTERS;
            }
            case 160: {
                return ULTRAVISTAREQFILTERS;
            }
            case 200: {
                return CALREQFILTERS;
            }
        }
        return null;
    }

    public static String[] getDBs(int programmeid, boolean world) {
        switch (programmeid) {
            case 0: {
                if (world) {
                    return null;
                }
                return PRERELEASEDB;
            }
            case 1: {
                if (world) {
                    return WORLDCOMMDB;
                }
                return COMMDB;
            }
            case 100: {
                if (world) {
                    return WORLDSVORIONDB;
                }
                return SVORIONDB;
            }
            case 101: {
                if (world) {
                    return WORLDSVNGC253DB;
                }
                return SVNGC253DB;
            }
            case 110: {
                if (world) {
                    return WORLDVHSDB;
                }
                return VHSDB;
            }
            case 120: {
                if (world) {
                    return WORLDVVVDB;
                }
                return VVVDB;
            }
            case 175: {
                if (world) {
                    return WORLDSHARKSDB;
                }
                return SHARKSDB;
            }
            case 170: {
                if (world) {
                    return WORLDVVVXDB;
                }
                return VVVXDB;
            }
            case 180: {
                if (world) {
                    return WORLDGCAVDB;
                }
                return GCAVDB;
            }
            case 185: {
                if (world) {
                    return WORLDVISIONSDB;
                }
                return VISIONSDB;
            }
            case 190: {
                if (world) {
                    return WORLDVEILSDB;
                }
                return VEILSDB;
            }
            case 195: {
                if (world) {
                    return WORLDVINROUGEDB;
                }
                return VINROUGEDB;
            }
            case 130: {
                if (world) {
                    return WORLDVMCDB;
                }
                return VMCDB;
            }
            case 135: {
                if (world) {
                    return WORLDVMCDEEPDB;
                }
                return VMCDEEPDB;
            }
            case 140: {
                if (world) {
                    return WORLDVIKINGDB;
                }
                return VIKINGDB;
            }
            case 150: {
                if (world) {
                    return WORLDVIDEODB;
                }
                return VIDEODB;
            }
            case 160: {
                if (world) {
                    return WORLDULTRAVISTADB;
                }
                return ULTRAVISTADB;
            }
            case 200: {
                if (world) {
                    return WORLDCALDB;
                }
                return CALDB;
            }
            case 103: {
                if (world) {
                    return WORLDGCSDB;
                }
                return GCSDB;
            }
        }
        return null;
    }

    public static String[] getWorldDBs(int programmeid) {
        switch (programmeid) {
            case 0: {
                return null;
            }
            case 1: {
                return WORLDCOMMDB;
            }
            case 100: {
                return WORLDSVORIONDB;
            }
            case 101: {
                return WORLDSVNGC253DB;
            }
            case 110: {
                return WORLDVHSDB;
            }
            case 120: {
                return WORLDVVVDB;
            }
            case 175: {
                return WORLDSHARKSDB;
            }
            case 170: {
                return WORLDVVVXDB;
            }
            case 180: {
                return WORLDGCAVDB;
            }
            case 185: {
                return WORLDVISIONSDB;
            }
            case 190: {
                return WORLDVEILSDB;
            }
            case 195: {
                return WORLDVINROUGEDB;
            }
            case 130: {
                return WORLDVMCDB;
            }
            case 135: {
                return WORLDVMCDEEPDB;
            }
            case 140: {
                return WORLDVIKINGDB;
            }
            case 150: {
                return WORLDVIDEODB;
            }
            case 160: {
                return WORLDULTRAVISTADB;
            }
            case 200: {
                return WORLDCALDB;
            }
            case 103: {
                return WORLDGCSDB;
            }
        }
        return null;
    }

    public static String[] getEquivWorldDBs(int programmeid) {
        switch (programmeid) {
            case 0: {
                return null;
            }
            case 1: {
                return EQUIVWORLDCOMMDB;
            }
            case 100: {
                return EQUIVWORLDSVORIONDB;
            }
            case 101: {
                return EQUIVWORLDSVNGC253DB;
            }
            case 110: {
                return EQUIVWORLDVHSDB;
            }
            case 120: {
                return EQUIVWORLDVVVDB;
            }
            case 175: {
                return EQUIVWORLDSHARKSDB;
            }
            case 170: {
                return EQUIVWORLDVVVXDB;
            }
            case 180: {
                return EQUIVWORLDGCAVDB;
            }
            case 185: {
                return EQUIVWORLDVISIONSDB;
            }
            case 190: {
                return EQUIVWORLDVEILSDB;
            }
            case 195: {
                return EQUIVWORLDVINROUGEDB;
            }
            case 130: {
                return EQUIVWORLDVMCDB;
            }
            case 135: {
                return EQUIVWORLDVMCDEEPDB;
            }
            case 140: {
                return EQUIVWORLDVIKINGDB;
            }
            case 150: {
                return EQUIVWORLDVIDEODB;
            }
            case 160: {
                return EQUIVWORLDULTRAVISTADB;
            }
            case 200: {
                return EQUIVWORLDCALDB;
            }
            case 103: {
                return EQUIVWORLDGCSDB;
            }
        }
        return null;
    }

    public static String[] getDBsPlusRollingDB(String[] inDBs) {
        if (inDBs == null) {
            return null;
        }
        String[] retDBs = new String[inDBs.length + 1];
        int i = 0;
        while (i < inDBs.length) {
            retDBs[i] = inDBs[i];
            ++i;
        }
        retDBs[retDBs.length - 1] = "VSA_DailySync";
        return retDBs;
    }

    public static String[] getDBsPlusExtraDB(String[] inDBs, String[] extraDBs) {
        if (inDBs == null) {
            return extraDBs;
        }
        String[] retDBs = new String[inDBs.length + extraDBs.length];
        int i = 0;
        while (i < inDBs.length) {
            retDBs[i] = inDBs[i];
            ++i;
        }
        i = 0;
        while (i < extraDBs.length) {
            retDBs[inDBs.length + i] = extraDBs[i];
            ++i;
        }
        return retDBs;
    }

    public static int getSchemaValidVersion(int progID) {
        switch (progID) {
            case 1: {
                return COMMVERISONSCHEMA;
            }
            case 100: {
                return SVORIONVERISONSCHEMA;
            }
            case 101: {
                return SVNGC253VERISONSCHEMA;
            }
            case 110: {
                return VHSVERISONSCHEMA;
            }
            case 120: {
                return VVVVERISONSCHEMA;
            }
            case 175: {
                return SHARKSVERISONSCHEMA;
            }
            case 170: {
                return VVVXVERISONSCHEMA;
            }
            case 180: {
                return GCAVVERISONSCHEMA;
            }
            case 185: {
                return VISIONSVERISONSCHEMA;
            }
            case 190: {
                return VEILSVERISONSCHEMA;
            }
            case 195: {
                return VINROUGEVERISONSCHEMA;
            }
            case 130: {
                return VMCVERISONSCHEMA;
            }
            case 135: {
                return VMCDEEPVERISONSCHEMA;
            }
            case 140: {
                return VIKINGVERISONSCHEMA;
            }
            case 150: {
                return VIDEOVERISONSCHEMA;
            }
            case 160: {
                return ULTRAVISTAVERISONSCHEMA;
            }
        }
        return 9999;
    }

    public static String getDefaultList(int[] reqFilters, String table, String database, int progID) {
        boolean validSchema = false;
        if (VSASchema.getVersionNoOfRelease(database, progID) >= VSASchema.getSchemaValidVersion(progID)) {
            validSchema = true;
        }
        database = database.replaceAll("(?i)world", "ukidss");
        int i = 0;
        while (i < SCEHMAVALIDDATABASES.length) {
            if (database.equalsIgnoreCase(SCEHMAVALIDDATABASES[i])) {
                validSchema = true;
            }
            ++i;
        }
        if (table.toLowerCase().indexOf("detection") >= 0 && table.toLowerCase().indexOf("detections") < 0) {
            if (validSchema) {
                return "objID, multiframeID, filterID, RA, Dec, ell, pa, class, psfMag, isoMag, petroMag, aperMag2, aperMag3";
            }
            return String.valueOf(table) + ".*";
        }
        if (table.toLowerCase().indexOf("source") >= 0 && table.toLowerCase().indexOf("psf") < 0) {
            if (validSchema) {
                StringBuffer sb = new StringBuffer("");
                if (table.toLowerCase().indexOf("synopticsource") >= 0) {
                    sb.append("synopticID, synFrameSetID, RA, Dec, mergedClass");
                } else {
                    sb.append("sourceID, framesetID, RA, Dec, mergedClass, priOrSec");
                }
                if (reqFilters != null) {
                    sb.append(VSASchema.getReqMags(reqFilters));
                }
                return sb.toString();
            }
            return String.valueOf(table) + ".*";
        }
        return String.valueOf(table) + ".*";
    }

    public static String getDefaultList(int[] reqFilters, String table) {
        return VSASchema.getDefaultList(reqFilters, table, "ukidssdr5plus");
    }

    public static String getReqMags(int[] reqFilters) {
        StringBuffer sb1 = new StringBuffer("");
        int i = 0;
        while (i < reqFilters.length) {
            if (reqFilters[i] == 1) {
                sb1.append(", " + VSASchema.getFilterName(i) + "AperMag3");
                sb1.append(", " + VSASchema.getFilterName(i) + "AperMag3Err");
            }
            if (reqFilters[i] > 1) {
                int j = 0;
                while (j < reqFilters[i]) {
                    sb1.append(", " + VSASchema.getFilterName(i) + "_" + (j + 1) + "AperMag3");
                    sb1.append(", " + VSASchema.getFilterName(i) + "_" + (j + 1) + "AperMag3Err");
                    ++j;
                }
            }
            ++i;
        }
        return sb1.toString();
    }

    public static String[] getBands(int[] reqBands) {
        int noBands = 0;
        int i = 0;
        while (i < reqBands.length) {
            noBands += reqBands[i];
            ++i;
        }
        String[] bands = new String[noBands];
        int bandCount = 0;
        int i2 = 0;
        while (i2 < reqBands.length) {
            if (reqBands[i2] == 1) {
                bands[bandCount] = VSASchema.getFilterName(i2);
                ++bandCount;
            }
            if (reqBands[i2] > 1) {
                int j = 0;
                while (j < reqBands[i2]) {
                    bands[bandCount] = String.valueOf(VSASchema.getFilterName(i2)) + "_" + (j + 1);
                    ++bandCount;
                    ++j;
                }
            }
            ++i2;
        }
        return bands;
    }

    public static String[] getBands(String database, int surveyID) {
        int[] reqBands = VSASchema.getReqFilters(database, surveyID);
        int noBands = 0;
        int i = 0;
        while (i < reqBands.length) {
            noBands += reqBands[i];
            ++i;
        }
        String[] bands = new String[noBands];
        int bandCount = 0;
        int i2 = 0;
        while (i2 < reqBands.length) {
            if (reqBands[i2] == 1) {
                bands[bandCount] = VSASchema.getFilterName(i2);
                ++bandCount;
            }
            if (reqBands[i2] > 1) {
                int j = 0;
                while (j < reqBands[i2]) {
                    bands[bandCount] = String.valueOf(VSASchema.getFilterName(i2)) + "_" + (j + 1);
                    ++bandCount;
                    ++j;
                }
            }
            ++i2;
        }
        return bands;
    }

    public static String[] getBands(int surveyID) {
        switch (surveyID) {
            case 1: {
                return COMMISSIONINGBands;
            }
            case 101: {
                return LASBands;
            }
            case 11: {
                return LASBands;
            }
            case 102: {
                return GPSBands;
            }
            case 12: {
                return GPSBands;
            }
            case 103: {
                return GCSBands;
            }
            case 13: {
                return GCSBands;
            }
            case 104: {
                return DXSBands;
            }
            case 14: {
                return DXSBands;
            }
            case 105: {
                return UDSBands;
            }
            case 15: {
                return UDSBands;
            }
        }
        return null;
    }

    public static String getMergeTableName(int surveyID) {
        String mergeTableName;
        switch (surveyID) {
            case 1: {
                mergeTableName = COMMISSIONINGMERGETABLENAME;
                break;
            }
            case 110: {
                mergeTableName = VHSMERGETABLENAME;
                break;
            }
            case 120: {
                mergeTableName = VVVMERGETABLENAME;
                break;
            }
            case 175: {
                mergeTableName = SHARKSMERGETABLENAME;
                break;
            }
            case 170: {
                mergeTableName = VVVXMERGETABLENAME;
                break;
            }
            case 180: {
                mergeTableName = GCAVMERGETABLENAME;
                break;
            }
            case 185: {
                mergeTableName = VISIONSMERGETABLENAME;
                break;
            }
            case 190: {
                mergeTableName = VEILSMERGETABLENAME;
                break;
            }
            case 195: {
                mergeTableName = VINROUGEMERGETABLENAME;
                break;
            }
            case 130: {
                mergeTableName = VMCMERGETABLENAME;
                break;
            }
            case 135: {
                mergeTableName = VMCDEEPMERGETABLENAME;
                break;
            }
            case 140: {
                mergeTableName = VIKINGMERGETABLENAME;
                break;
            }
            case 150: {
                mergeTableName = VIDEOMERGETABLENAME;
                break;
            }
            case 160: {
                mergeTableName = ULTRAVISTAMERGETABLENAME;
                break;
            }
            case 100: {
                mergeTableName = SVORIONMERGETABLENAME;
                break;
            }
            case 101: {
                mergeTableName = SVNGC253MERGETABLENAME;
                break;
            }
            default: {
                mergeTableName = null;
            }
        }
        return mergeTableName;
    }

    public static int getSourceSchemaVersion(int surveyID) {
        int schemaVersion = -1;
        switch (surveyID) {
            case 106: {
                schemaVersion = 99999;
                break;
            }
            case 200: {
                schemaVersion = 99999;
                break;
            }
            default: {
                schemaVersion = -1;
            }
        }
        return schemaVersion;
    }

    public static int getDetectionSchemaVersion(int surveyID) {
        int schemaVersion = -1;
        switch (surveyID) {
            case 106: {
                schemaVersion = -1;
                break;
            }
            case 200: {
                schemaVersion = -1;
                break;
            }
            default: {
                schemaVersion = -1;
            }
        }
        return schemaVersion;
    }

    public static int getLastSchemaVersion(int surveyID) {
        int schemaVersion = 99999999;
        schemaVersion = 99999999;
        return schemaVersion;
    }

    public static String getSourceTableName(int surveyID) {
        switch (surveyID) {
            case 1: {
                return COMMSOURCETABLENAME;
            }
            case 110: {
                return VHSSOURCETABLENAME;
            }
            case 120: {
                return VVVSOURCETABLENAME;
            }
            case 175: {
                return SHARKSSOURCETABLENAME;
            }
            case 170: {
                return VVVXSOURCETABLENAME;
            }
            case 180: {
                return GCAVSOURCETABLENAME;
            }
            case 185: {
                return VISIONSSOURCETABLENAME;
            }
            case 190: {
                return VEILSSOURCETABLENAME;
            }
            case 195: {
                return VINROUGESOURCETABLENAME;
            }
            case 130: {
                return VMCSOURCETABLENAME;
            }
            case 135: {
                return VMCDEEPSOURCETABLENAME;
            }
            case 140: {
                return VIKINGSOURCETABLENAME;
            }
            case 150: {
                return VIDEOSOURCETABLENAME;
            }
            case 160: {
                return ULTRAVISTASOURCETABLENAME;
            }
            case 100: {
                return SVORIONSOURCETABLENAME;
            }
            case 101: {
                return SVNGC253SOURCETABLENAME;
            }
            case 200: {
                return "NONE";
            }
        }
        return null;
    }

    public static String getSynopticSourceTableName(int surveyID) {
        switch (surveyID) {
            case 120: {
                return VVVSYNOPTICSOURCETABLENAME;
            }
            case 130: {
                return VMCSYNOPTICSOURCETABLENAME;
            }
            case 135: {
                return VMCDEEPSYNOPTICSOURCETABLENAME;
            }
        }
        return null;
    }

    public static boolean isThisVVVDBHasTileAndPawprints(String dbname) {
        if (dbname == null) {
            return false;
        }
        return dbname.toLowerCase().contains("vvvdr5") || dbname.trim().equals("");
    }

    public static boolean isThisVVVDBSynoptic(String dbname) {
        if (dbname == null) {
            return false;
        }
        return !dbname.toLowerCase().contains("vvvdr5") && !dbname.trim().equals("");
    }

    public static String[] getDefaultRGB(int surveyID) {
        String[] RGB = null;
        switch (surveyID) {
            case 110: {
                RGB = VHSRGB;
                break;
            }
            case 120: {
                RGB = VVVRGB;
                break;
            }
            case 140: {
                RGB = VIKINGRGB;
                break;
            }
            case 150: {
                RGB = VIDEORGB;
                break;
            }
            case 130: {
                RGB = VMCRGB;
                break;
            }
            case 135: {
                RGB = VMCDEEPRGB;
                break;
            }
            case 101: {
                RGB = LASRGB;
                break;
            }
            case 102: {
                RGB = GPSRGB;
                break;
            }
            case 103: {
                RGB = GCSRGB;
                break;
            }
            case 104: {
                RGB = DXSRGB;
                break;
            }
            case 105: {
                RGB = UDSRGB;
                break;
            }
        }
        return RGB;
    }

    public static String getSourceViewName(int surveyID) {
        switch (surveyID) {
            case 1: {
                return "undef";
            }
            case 100: {
                return "undef";
            }
            case 101: {
                return "undef";
            }
            case 110: {
                return "undef";
            }
            case 120: {
                return "undef";
            }
            case 175: {
                return "undef";
            }
            case 170: {
                return "undef";
            }
            case 180: {
                return "undef";
            }
            case 185: {
                return "undef";
            }
            case 190: {
                return "undef";
            }
            case 195: {
                return "undef";
            }
            case 130: {
                return "undef";
            }
            case 135: {
                return "undef";
            }
            case 140: {
                return "undef";
            }
            case 150: {
                return "undef";
            }
            case 160: {
                return "undef";
            }
            case 200: {
                return "undef";
            }
        }
        return null;
    }

    public static String getDetectionTableName(int surveyID) {
        switch (surveyID) {
            case 1: {
                return COMMDETECTIONTABLENAME;
            }
            case 110: {
                return VHSDETECTIONTABLENAME;
            }
            case 120: {
                return VVVDETECTIONTABLENAME;
            }
            case 175: {
                return SHARKSDETECTIONTABLENAME;
            }
            case 170: {
                return VVVXDETECTIONTABLENAME;
            }
            case 180: {
                return GCAVDETECTIONTABLENAME;
            }
            case 185: {
                return VISIONSDETECTIONTABLENAME;
            }
            case 190: {
                return VEILSDETECTIONTABLENAME;
            }
            case 195: {
                return VINROUGEDETECTIONTABLENAME;
            }
            case 130: {
                return VMCDETECTIONTABLENAME;
            }
            case 135: {
                return VMCDEEPDETECTIONTABLENAME;
            }
            case 140: {
                return VIKINGDETECTIONTABLENAME;
            }
            case 150: {
                return VIDEODETECTIONTABLENAME;
            }
            case 160: {
                return ULTRAVISTADETECTIONTABLENAME;
            }
            case 100: {
                return SVORIONDETECTIONTABLENAME;
            }
            case 101: {
                return SVNGC253DETECTIONTABLENAME;
            }
            case 200: {
                return CALDETECTIONTABLENAME;
            }
        }
        return null;
    }

    public static String getShortSurveyName(int surveyID) {
        String shortSurveyName;
        switch (surveyID) {
            case 1: {
                shortSurveyName = "comm";
                break;
            }
            case 110: {
                shortSurveyName = "VHS";
                break;
            }
            case 120: {
                shortSurveyName = "VVV";
                break;
            }
            case 175: {
                shortSurveyName = "SHARKS";
                break;
            }
            case 170: {
                shortSurveyName = "VVVX";
                break;
            }
            case 180: {
                shortSurveyName = "GCAV";
                break;
            }
            case 185: {
                shortSurveyName = "VISIONS";
                break;
            }
            case 190: {
                shortSurveyName = "VEILS";
                break;
            }
            case 195: {
                shortSurveyName = "VINROUGE";
                break;
            }
            case 130: {
                shortSurveyName = "VMC";
                break;
            }
            case 135: {
                shortSurveyName = "VMCDEEP";
                break;
            }
            case 140: {
                shortSurveyName = "VIKING";
                break;
            }
            case 150: {
                shortSurveyName = "VIDEO";
                break;
            }
            case 160: {
                shortSurveyName = "UltraVista";
                break;
            }
            case 100: {
                shortSurveyName = "svOrion";
                break;
            }
            case 101: {
                shortSurveyName = "svNGC253";
                break;
            }
            case 200: {
                shortSurveyName = "cal";
                break;
            }
            default: {
                shortSurveyName = null;
            }
        }
        return shortSurveyName;
    }

    public static String getSurveyName(int surveyID) {
        String surveyName;
        switch (surveyID) {
            case 1: {
                surveyName = "Commissioning programme";
                break;
            }
            case 110: {
                surveyName = "VHS: VISTA Hemisphere Survey";
                break;
            }
            case 120: {
                surveyName = "VVV: VISTA Variables in the Via Lactea";
                break;
            }
            case 175: {
                surveyName = "SHARKS: Southern H-ATLAS Regions Ks-band Survey";
                break;
            }
            case 170: {
                surveyName = "VVVX: VVV eXtended";
                break;
            }
            case 180: {
                surveyName = "GCAV: Galaxy Clusters At Vircam ";
                break;
            }
            case 185: {
                surveyName = "VISIONS: VISTA Star Formation Atlas";
                break;
            }
            case 190: {
                surveyName = "VEILS: VISTA Extragalactic Infrared Survey";
                break;
            }
            case 195: {
                surveyName = "VINROUGE: Kilonova counterparts to Gravitational wave sources";
                break;
            }
            case 130: {
                surveyName = "VMC: VISTA Magellanic Clouds Survey";
                break;
            }
            case 135: {
                surveyName = "VMC: VISTA Magellanic Clouds Deep Survey";
                break;
            }
            case 140: {
                surveyName = "VIKING: VISTA Kilo-degree Infrared Galaxy Survey";
                break;
            }
            case 150: {
                surveyName = "VIDEO: VISTA Deep Extragalactic Observations";
                break;
            }
            case 160: {
                surveyName = "UltraVISTA: an ultra-deep survey with VISTA";
                break;
            }
            case 100: {
                surveyName = "ORION Science Verification data";
                break;
            }
            case 101: {
                surveyName = "NGC253 Science Verification data";
                break;
            }
            case 200: {
                surveyName = "Calibration data";
                break;
            }
            case 103: {
                surveyName = "GCS TEST";
                break;
            }
            default: {
                surveyName = "Survey name not found in lookup";
            }
        }
        return surveyName;
    }

    public static String getFilterName(int filterID) {
        if (filterID >= 0 && filterID <= VISTAFILTERS.length && VISTAFILTERS[filterID] != null) {
            return VISTAFILTERS[filterID];
        }
        return "NULL";
    }

    public static String getRequiredFiltersSQL() {
        return "select filterid,npass from requiredfilters";
    }

    public static String getProprietaryCommunity(int surveyID, String remoteUser) {
        switch (surveyID) {
            case 1: {
                return "COMM";
            }
            case 110: {
                return "VHS";
            }
            case 120: {
                if (remoteUser.toLowerCase().contains("vvve")) {
                    return "VVVE";
                }
                if (remoteUser.toLowerCase().contains("vvvs")) {
                    return "VVVS";
                }
                return "VVV";
            }
            case 175: {
                return "SHARKS";
            }
            case 170: {
                return "VVVX";
            }
            case 180: {
                return "GCAV";
            }
            case 185: {
                return "VISIONS";
            }
            case 190: {
                return "VEILS";
            }
            case 195: {
                return "VINROUGE";
            }
            case 130: {
                return "VMC";
            }
            case 135: {
                return "VMCDEEP";
            }
            case 140: {
                return "VIKING";
            }
            case 150: {
                return "VIDEO";
            }
            case 160: {
                return "ULTRAVISTA";
            }
            case 100: {
                return "SV_ORION";
            }
            case 101: {
                return "SV_NGC53";
            }
            case 200: {
                return "CAL";
            }
        }
        return null;
    }

    public static int getProgIDFromString(String str) {
        if (str != null) {
            if (str.toLowerCase().contains("vvvx")) {
                return 170;
            }
            if (str.toLowerCase().contains("vvv")) {
                return 120;
            }
            if (str.toLowerCase().contains("sharks")) {
                return 175;
            }
            if (str.toLowerCase().contains("gcav")) {
                return 180;
            }
            if (str.toLowerCase().contains("visions")) {
                return 185;
            }
            if (str.toLowerCase().contains("veils")) {
                return 190;
            }
            if (str.toLowerCase().contains("vinrouge")) {
                return 195;
            }
            if (str.toLowerCase().contains("vmcdeep")) {
                return 130;
            }
            if (str.toLowerCase().contains("vmc")) {
                return 135;
            }
            if (str.toLowerCase().contains("viking")) {
                return 140;
            }
            if (str.toLowerCase().contains("vhs")) {
                return 110;
            }
            if (str.toLowerCase().contains("video")) {
                return 150;
            }
            if (str.toLowerCase().contains("ultravista")) {
                return 160;
            }
            return -9999;
        }
        return -9999;
    }

    public static StringBuffer getFramesetSQL(int[] fID, String mergelogTable, String multiframeTable) {
        StringBuffer sbSQL = new StringBuffer("");
        String mfidName = null;
        int row = 0;
        boolean first = true;
        int j = 0;
        while (j < fID.length) {
            int filterid = j;
            int npass = fID[j];
            row += npass;
            if (npass == 1) {
                mfidName = String.valueOf(VSASchema.getFilterName(filterid)) + "mfid";
                if (!first) {
                    sbSQL.append(" or ");
                }
                first = false;
                sbSQL.append(String.valueOf(mergelogTable) + "." + mfidName + "=" + multiframeTable + ".multiframeid");
            } else if (npass > 1) {
                int i = 0;
                while (i < npass) {
                    mfidName = String.valueOf(VSASchema.getFilterName(filterid)) + "_" + (i + 1) + "mfid";
                    if (!first) {
                        sbSQL.append(" or ");
                    }
                    first = false;
                    sbSQL.append(String.valueOf(mergelogTable) + "." + mfidName + "=" + multiframeTable + ".multiframeid");
                    ++i;
                }
            }
            ++j;
        }
        if (row > 0) {
            return sbSQL;
        }
        return null;
    }

    public static String getCrossIDTableTable(String community, String user, String baseTable, int intProgrammeID) {
        if (community.equalsIgnoreCase(NONSURVEYCOMMUNITY)) {
            return String.valueOf(user.trim()) + baseTable;
        }
        if (baseTable.equalsIgnoreCase("sourceView")) {
            return VSASchema.getSourceViewName(intProgrammeID);
        }
        if (baseTable.equalsIgnoreCase("source")) {
            return VSASchema.getSourceTableName(intProgrammeID);
        }
        if (baseTable.equalsIgnoreCase("detection")) {
            return VSASchema.getDetectionTableName(intProgrammeID);
        }
        return "";
    }

    public static String getCrossIDDefaultSelect(String community, String tableName, HttpSession session, int programmeID, String database) {
        if (community.equalsIgnoreCase(NONSURVEYCOMMUNITY)) {
            int[] reqFilters = null;
            if (session.getAttribute("vsareqFilters") != null) {
                reqFilters = (int[])session.getAttribute("vsareqFilters");
            }
            return VSASchema.getDefaultList(reqFilters, tableName, WSASession.getSchemaVersion(session));
        }
        return VSASchema.getDefaultList(VSASchema.getReqFilters(programmeID), tableName, database, programmeID);
    }

    public static boolean isInAcronyms(String str) {
        int i = 0;
        while (i < SURVEYACRONYMS.length) {
            if (str.equalsIgnoreCase(SURVEYACRONYMS[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isProprietary(String community) {
        return community != null && (VSASchema.isInAcronyms(community) || community.toLowerCase().contains(PROPRIETARYCOMMUNITY.toLowerCase()) || community.toLowerCase().contains("nonsurvey"));
    }

    public static StringBuffer getFramesetSQL(ResultSet rset, String mergelogTable, String multiframeTable) {
        StringBuffer sbSQL = new StringBuffer("");
        String mfidName = null;
        int row = 0;
        boolean first = true;
        try {
            while (rset.next()) {
                ++row;
                int filterid = rset.getInt("filterid");
                int npass = rset.getInt("npass");
                if (npass == 1) {
                    mfidName = String.valueOf(VSASchema.getFilterName(filterid)) + "mfid";
                    if (!first) {
                        sbSQL.append(" or ");
                    }
                    first = false;
                    sbSQL.append(String.valueOf(mergelogTable) + "." + mfidName + "=" + multiframeTable + ".multiframeid");
                    continue;
                }
                if (npass <= 1) continue;
                int i = 0;
                while (i < npass) {
                    mfidName = String.valueOf(VSASchema.getFilterName(filterid)) + "_" + (i + 1) + "mfid";
                    if (!first) {
                        sbSQL.append(" or ");
                    }
                    first = false;
                    sbSQL.append(String.valueOf(mergelogTable) + "." + mfidName + "=" + multiframeTable + ".multiframeid");
                    ++i;
                }
            }
            if (row > 0) {
                return sbSQL;
            }
            return null;
        }
        catch (SQLException se) {
            return null;
        }
    }

    public static String getUCDofCol(String col) {
        if (colMap != null && colMap.containsKey(col.toUpperCase())) {
            String info = (String)colMap.get(col.toUpperCase());
            String[] bits = info.split("###");
            return bits[0];
        }
        return "UCD_unavailable";
    }

    public static String getDescofCol(String col) {
        if (colMap != null && colMap.containsKey(col.toUpperCase())) {
            String info = (String)colMap.get(col.toUpperCase());
            String[] dBits = info.split("###");
            return dBits[1];
        }
        return "description_unavailable";
    }
}

