/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.roe.wfau;

import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import uk.ac.roe.wfau.VSASchema;
import uk.ac.roe.wfau.WSASchema;

public class VSASession {
    public static Logger logger = Logger.getLogger((String)"wsa.simple");
    static final int UKIDSSTESTERCLASS = 0;
    static final int UKIDSSCLASS = 1;
    static final int WORLDCLASS = 2;
    static final int PRERELEASECLASS = 3;
    static final int NONSURVEYCLASS = 4;
    static final int VISTATESTERCLASS = 5;

    public static String getDBUser(HttpSession sess) {
        String community = VSASession.getCommunity(sess);
        if (VSASession.getLoginBoolean(sess) && !VSASchema.isProprietary(community) && !community.equalsIgnoreCase("prerelease") && !community.equalsIgnoreCase("world")) {
            return "wsaro";
        }
        if (VSASession.getLoginBoolean(sess) && community.equalsIgnoreCase("prerelease")) {
            return "wsaro";
        }
        if (VSASession.getLoginBoolean(sess) && VSASchema.isProprietary(community)) {
            int iProgID = Integer.parseInt(VSASession.getProgID(sess));
            if (iProgID > 0 && iProgID < 1000) {
                return String.valueOf(VSASchema.getShortSurveyName(iProgID).toLowerCase()) + "ro";
            }
            return String.valueOf(VSASession.getUser(sess).toLowerCase()) + "ro";
        }
        return "worldwsaro";
    }

    public static int getSessionClass(HttpSession sess) {
        String community = VSASession.getCommunity(sess);
        if (VSASession.getLoginBoolean(sess)) {
            if (community.equalsIgnoreCase("nonsurvey") || community.equalsIgnoreCase("Proprietary") || VSASchema.isProprietary(community)) {
                logger.info((Object)"VSA nonsurveyclass");
                return 4;
            }
            if (community.equalsIgnoreCase("prerelease")) {
                return 3;
            }
            if (community.equalsIgnoreCase("ukidsstester")) {
                return 0;
            }
            if (community.equalsIgnoreCase("vistatester")) {
                return 5;
            }
            return 1;
        }
        return 2;
    }

    public static String getProgID(HttpSession sess) {
        if (sess.getAttribute("vsaprogrammeID") != null) {
            return ((String)sess.getAttribute("vsaprogrammeID")).trim();
        }
        return "-999";
    }

    public static String getCommunity(HttpSession sess) {
        if (VSASession.getLoginBoolean(sess) && sess.getAttribute("vsacommunity") != null) {
            String community = ((String)sess.getAttribute("vsacommunity")).toLowerCase().trim();
            if (community != null) {
                return community;
            }
            return "world";
        }
        return "world";
    }

    public static String[] getNonSurveyDBName(HttpSession sess) {
        String[] nsDBs = null;
        if (sess.getAttribute("vsareleasedDBs") != null) {
            nsDBs = (String[])sess.getAttribute("vsareleasedDBs");
        } else if (sess.getAttribute("vsadbName") != null && !((String)sess.getAttribute("vsadbName")).toLowerCase().trim().equalsIgnoreCase("na")) {
            String[] dbName = new String[]{VSASession.getUser(sess)};
            nsDBs = dbName;
        }
        return nsDBs;
    }

    public static String getUser(HttpSession sess) {
        return VSASession.getUser(sess, false);
    }

    public static String getUser(HttpSession sess, boolean generic) {
        if (VSASession.getLoginBoolean(sess)) {
            if (!generic) {
                if (sess.getAttribute("vsauser") != null) {
                    return ((String)sess.getAttribute("vsauser")).toLowerCase().trim();
                }
                return "public";
            }
            int iProgID = Integer.parseInt(VSASession.getProgID(sess));
            if (iProgID > 0 && iProgID < 1000 && VSASchema.getShortSurveyName(iProgID) != null) {
                return VSASchema.getShortSurveyName(iProgID);
            }
            return ((String)sess.getAttribute("vsauser")).toLowerCase().trim();
        }
        return "public";
    }

    public static String[] getDB(HttpSession sess, int progID) {
        return VSASession.getDB(sess, progID, false);
    }

    public static String[] getDB(HttpSession sess, int progID, boolean doRollingDB) {
        return VSASession.getDB(sess, progID, doRollingDB, true);
    }

    public static String[] getDB(HttpSession sess, int progID, boolean doRollingDB, boolean includeExtraDB) {
        return VSASession.getDB(sess, progID, doRollingDB, includeExtraDB, false);
    }

    public static String[] getDB(HttpSession sess, int progID, boolean doRollingDB, boolean includeExtraDB, boolean includeMoreDB) {
        int sessClass = VSASession.getSessionClass(sess);
        logger.info((Object)("sessClass " + sessClass));
        String[] DB = null;
        switch (sessClass) {
            case 2: {
                DB = VSASchema.getDBs(progID, true);
                if (!includeMoreDB) break;
                DB = VSASchema.getDBsPlusExtraDB(DB, VSASchema.moreDB);
                break;
            }
            case 1: {
                if (doRollingDB && progID != 0) {
                    DB = VSASchema.getDBsPlusRollingDB(VSASchema.getDBs(progID, false));
                    break;
                }
                DB = VSASchema.getDBs(progID, false);
                break;
            }
            case 4: {
                String[] nsdbs = VSASession.getNonSurveyDBName(sess);
                if (doRollingDB) {
                    DB = VSASession.getNonSurveyDBName(sess) != null ? VSASchema.getDBsPlusRollingDB(VSASession.getNonSurveyDBName(sess)) : new String[]{"VSA_DailySync"};
                } else if (VSASession.getNonSurveyDBName(sess) != null) {
                    DB = VSASession.getNonSurveyDBName(sess);
                } else if (progID > 10000) {
                    DB = new String[]{"sorry no access"};
                }
                if (includeExtraDB && progID < 10000) {
                    DB = DB == null ? new String[]{VSASchema.extraDB[0]} : VSASchema.getDBsPlusExtraDB(DB, VSASchema.extraDB);
                }
                logger.info((Object)("sess DB[0] " + DB[0]));
                break;
            }
            case 5: {
                DB = doRollingDB ? VSASchema.getDBsPlusRollingDB(VSASchema.getDBs(progID, false)) : VSASchema.getDBs(progID, false);
                if (includeExtraDB) {
                    DB = WSASchema.getDBsPlusExtraDB(DB, WSASchema.extraDB);
                }
                if (!includeMoreDB) break;
                DB = WSASchema.getDBsPlusExtraDB(DB, VSASchema.moreDB);
                break;
            }
            case 0: {
                DB = doRollingDB ? VSASchema.getDBsPlusRollingDB(VSASchema.getDBs(progID, false)) : VSASchema.getDBs(progID, false);
                if (!includeExtraDB) break;
                DB = WSASchema.getDBsPlusExtraDB(DB, WSASchema.extraDB);
                break;
            }
            case 3: {
                DB = VSASchema.PRERELEASEDB;
                break;
            }
            default: {
                DB = VSASchema.getDBs(progID, true);
            }
        }
        return DB;
    }

    public static int[] getProgs(HttpSession sess) {
        int[] progs;
        int sessClass = VSASession.getSessionClass(sess);
        switch (sessClass) {
            case 2: {
                progs = VSASchema.VISTAPROGS;
                break;
            }
            case 1: {
                progs = VSASchema.VISTAPROGS;
                break;
            }
            case 4: {
                progs = new int[]{};
                break;
            }
            case 0: {
                progs = VSASchema.VISTAPROGS;
                break;
            }
            case 5: {
                progs = VSASchema.VISTATESTERPROGS;
                break;
            }
            case 3: {
                progs = VSASchema.VISTATESTERPROGS;
                break;
            }
            default: {
                progs = VSASchema.VISTAPROGS;
            }
        }
        return progs;
    }

    public static String getSchemaVersion(HttpSession sess) {
        if (sess.getAttribute("vsaschemaVersion") != null) {
            String schemaVersion = ((String)sess.getAttribute("vsaschemaVersion")).toLowerCase().trim();
            if (schemaVersion != null) {
                return schemaVersion;
            }
            return "null";
        }
        return "null";
    }

    public static boolean getProprietaryBoolean(HttpSession sess) {
        if (sess.getAttribute("vsaProprietary") != null) {
            return (Boolean)sess.getAttribute("vsaProprietary");
        }
        return false;
    }

    public static boolean getSourceBoolean(HttpSession sess) {
        if (sess.getAttribute("vsasource") != null) {
            return (Boolean)sess.getAttribute("vsasource");
        }
        return false;
    }

    public static int[] getReqFilters(HttpSession sess) {
        try {
            return (int[])sess.getAttribute("vsareqFilters");
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean getLoginBoolean(HttpSession sess) {
        if (sess.getAttribute("vsalogin") != null) {
            try {
                return (Boolean)sess.getAttribute("vsalogin");
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public static String getDefaultList(HttpSession sess, String table, String database, int progID) {
        if (database == null) {
            if (VSASession.getCommunity(sess).equalsIgnoreCase("nonsurvey")) {
                return WSASchema.getDefaultList(VSASession.getReqFilters(sess), table, VSASession.getSchemaVersion(sess));
            }
            if (VSASession.getLoginBoolean(sess)) {
                return WSASchema.getDefaultList(WSASchema.getReqFilters(progID), table, WSASchema.LATESTUKIDSSSCHEMA);
            }
            return WSASchema.getDefaultList(WSASchema.getReqFilters(progID), table, WSASchema.LATESTWORLDSCHEMA);
        }
        if (VSASession.getCommunity(sess).equalsIgnoreCase("nonsurvey")) {
            return WSASchema.getDefaultList(VSASession.getReqFilters(sess), table, VSASession.getSchemaVersion(sess));
        }
        if (VSASession.getLoginBoolean(sess)) {
            return WSASchema.getDefaultList(WSASchema.getReqFilters(progID), table, database);
        }
        return WSASchema.getDefaultList(WSASchema.getReqFilters(progID), table, database);
    }
}

