/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.roe.wfau;

import java.io.FileInputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Properties;
import javax.servlet.http.HttpSession;
import uk.ac.roe.wfau.LoadWSAColumns;
import uk.ac.roe.wfau.LoadWSAProperties;
import uk.ac.roe.wfau.WSASession;

public class WSASchema {
    public static String[] ALLUKIDSSRDB;
    public static int[] UKIDSSVERSIONS;
    public static String[] UKIDSSDB;
    public static String[] UHSDB;
    public static String[] WORLDDB;
    public static int[] WORLDVERSIONS;
    public static String[] SCEHMAVALIDDATABASES;
    public static HashMap colMap;
    public static String PRERELEASEDATABASE;
    public static String MAILSERVER;
    public static final String LATESTUKIDSSDATABASE;
    public static final String LATESTWORLDDATABASE;
    public static final String LATESTUKIDSSSCHEMA;
    public static final String LATESTWORLDSCHEMA;
    public static final String LATESTNONSURVEYSCHEMA = "ukidssr2";
    public static final String PRERELEASESERVER = "ahmose";
    public static final String PRERELEASECOMMUNITY = "prerelease";
    public static final String NONSURVEYCOMMUNITY = "nonSurvey";
    public static final String[] UKIDSSTESTERDB;
    public static final int VERSIONOFSOURCEVIEWS = 4;
    public static final String PTSDB = "Transit";
    public static final String CALDB = "WFCAMCAL08B";
    public static final String OPENDB = "WFCAMOPENTIME";
    public static final String[] extraDB;
    public static final String[] uhsDBs;
    public static final String[] calDBs;
    public static final String[] worldCalDBs;
    public static final String[] moreDB;
    public static final boolean doExtraDB = true;
    public static final String[] PRERELEASEDB;
    public static final boolean accessToRollingDB = true;
    public static final String rollingDB = "WSA";
    public static final String rollingServer = "amenhotep";
    public static final String rollingDBUser = "wsaro";
    public static final String rollingDBPasswd = "wsaropw";
    public static final String noAccessDB = "sorry no access";
    public static final String actualRollingDB = "WFCAMPROPRIETY";
    public static final String ALLSURVEYS = "All surveys";
    public static final int MAXIMUMROWSTOFILE = 15000000;
    public static int FITS_OFFSET;
    public static final int WFCAMNONEFILTERID = 0;
    public static final int WFCAMZFILTERID = 1;
    public static final int WFCAMYFILTERID = 2;
    public static final int WFCAMJFILTERID = 3;
    public static final int WFCAMHFILTERID = 4;
    public static final int WFCAMKFILTERID = 5;
    public static final int WFCAMH2FILTERID = 6;
    public static final int WFCAMBRFILTERID = 7;
    public static final int WFCAMBLANKFILTERID = 8;
    public static final int WFCAMNBJFILTERID = 9;
    public static final int WFCAMNBHFILTERID = 10;
    public static final int WFCAMNBKFILTERID = 11;
    public static final int[] ALLFILTERID;
    public static int[] UHSFilterIDs;
    public static final int COMMISSIONINGPROGRAMMEID = 1;
    public static final int CURATIONTESTPROGRAMMEID = 99;
    public static final int UKIDSSLASPROGRAMMEID = 101;
    public static final int UKIDSSGPSPROGRAMMEID = 102;
    public static final int UKIDSSGCSPROGRAMMEID = 103;
    public static final int UKIDSSDXSPROGRAMMEID = 104;
    public static final int UKIDSSUDSPROGRAMMEID = 105;
    public static final int PTSPROGRAMMEID = 106;
    public static final int UHSPROGRAMMEID = 107;
    public static final int CALPROGRAMMEID = 200;
    public static final int OTHERCALPROGRAMMEID = 201;
    public static final int UKIDSSLASSVPROGRAMMEID = 11;
    public static final int UKIDSSGPSSVPROGRAMMEID = 12;
    public static final int UKIDSSGCSSVPROGRAMMEID = 13;
    public static final int UKIDSSDXSSVPROGRAMMEID = 14;
    public static final int UKIDSSUDSSVPROGRAMMEID = 15;
    public static final String[] LASRGB;
    public static final String[] GPSRGB;
    public static final String[] GCSRGB;
    public static final String[] DXSRGB;
    public static final String[] UDSRGB;
    public static final String[] CALRGB;
    public static final String[] UHSRGB;
    public static final int[] UKIDSSTESTERPROGS;
    public static final int[] UKIDSSPROGS;
    public static final int[] UKIDSSUHSPROGS;
    public static final int[] WORLDPROGS;
    public static final int[] PRERELEASEPROGS;
    public static final String COMMISSIONINGDETECTIONTABLENAME = "commDetection";
    public static final String UKIDSSLASDETECTIONTABLENAME = "lasDetection";
    public static final String UKIDSSGPSDETECTIONTABLENAME = "gpsDetection";
    public static final String UKIDSSGCSDETECTIONTABLENAME = "gcsDetection";
    public static final String UKIDSSDXSDETECTIONTABLENAME = "dxsDetection";
    public static final String UKIDSSUDSDETECTIONTABLENAME = "udsDetection";
    public static final String UHSDETECTIONTABLENAME = "uhsDetection";
    public static final String PTSDETECTIONTABLENAME = "ptsDetection";
    public static final String CALDETECTIONTABLENAME = "calDetection";
    public static final String COMMISSIONINGSOURCETABLENAME = "commSource";
    public static final String UKIDSSLASSOURCETABLENAME = "lasSource";
    public static final String UKIDSSGPSSOURCETABLENAME = "gpsSource";
    public static final String UKIDSSGCSSOURCETABLENAME = "gcsSource";
    public static final String UKIDSSDXSSOURCETABLENAME = "dxsSource";
    public static final String UKIDSSUDSSOURCETABLENAME = "udsSource";
    public static final String UHSSOURCETABLENAME = "uhsSource";
    public static final String UKIDSSLASSOURCEVIEWNAME = "lasYJHKsource";
    public static final String UKIDSSGPSSOURCEVIEWNAME = "gpsJHKsource";
    public static final String UKIDSSGCSSOURCEVIEWNAME = "gcsZYJHKsource";
    public static final String UKIDSSDXSSOURCEVIEWNAME = "dxsJKSource";
    public static final String UKIDSSUDSSOURCEVIEWNAME;
    public static final String UHSSOURCEVIEWNAME;
    public static final String PTSSOURCETABLENAME = "NONE";
    public static final String CALSOURCETABLENAME = "calSource";
    public static final String CALMERGETABLENAME = "calMergeLog";
    public static final String COMMISSIONINGMERGETABLENAME = "commMergeLog";
    public static final String UKIDSSLASMERGETABLENAME = "lasMergeLog";
    public static final String UKIDSSGPSMERGETABLENAME = "gpsMergeLog";
    public static final String UKIDSSGCSMERGETABLENAME = "gcsMergeLog";
    public static final String UKIDSSDXSMERGETABLENAME = "dxsMergeLog";
    public static final String UKIDSSUDSMERGETABLENAME = "udsMergeLog";
    public static final String UHSMERGETABLENAME = "uhsMergeLog";
    public static final String UKIDSSPTSMERGETABLENAME = "NONE";
    public static final String DEFAULTSQLSERVER = "amenhotep";
    public static final String UKIDSSLOGIN = "wsaro";
    public static final String WORLDLOGIN = "worldwsaro";
    public static final String UHSLOGIN = "uhsro";
    public static final String[] WFCAMFILTERS;
    public static final String[] filters;
    public static final String[] COMMISSIONINGBands;
    public static final int[] COMMISSIONINGREQFILTERS;
    public static final String[] LASBands;
    public static final int[] LASREQFILTERS;
    public static final String[] GPSBands;
    public static final int[] GPSREQFILTERS;
    public static final int[] GPSREQFILTERSDR2;
    public static final String[] GCSBands;
    public static final int[] GCSREQFILTERS;
    public static final String[] DXSBands;
    public static final int[] DXSREQFILTERS;
    public static final String[] UDSBands;
    public static final int[] UDSREQFILTERS;
    public static final String[] UHSBands;
    public static final int[] UHSREQFILTERS;
    public static final int[] UHSREQFILTERS2;
    public static final int[] UHSREQFILTERS3;
    public static final int[] UHSPASSS;
    public static final String[] CALBands;
    public static final int[] CALREQFILTERS;

    static {
        UHSDB = new String[]{"UHSDR1"};
        PRERELEASEDATABASE = rollingDB;
        MAILSERVER = null;
        LoadWSAProperties.getSingletonObject();
        LoadWSAColumns.getSingletonObject();
        LATESTUKIDSSDATABASE = UKIDSSDB[0];
        LATESTWORLDDATABASE = WORLDDB[0];
        LATESTUKIDSSSCHEMA = UKIDSSDB[0];
        LATESTWORLDSCHEMA = WORLDDB[0];
        UKIDSSTESTERDB = new String[]{"UKIDSSDR11PLUS", "UKIDSSDR10PLUS"};
        extraDB = new String[]{PTSDB};
        uhsDBs = new String[]{"UHSDR3", "UHSDR2"};
        calDBs = new String[]{CALDB};
        worldCalDBs = new String[]{CALDB};
        moreDB = new String[]{OPENDB};
        PRERELEASEDB = new String[]{PRERELEASEDATABASE};
        FITS_OFFSET = 1;
        int[] nArray = new int[12];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        nArray[7] = 7;
        nArray[8] = 8;
        nArray[9] = 9;
        nArray[10] = 10;
        nArray[11] = 11;
        ALLFILTERID = nArray;
        int[] nArray2 = new int[12];
        nArray2[3] = 1;
        UHSFilterIDs = nArray2;
        LASRGB = new String[]{"K", "H", "Y"};
        GPSRGB = new String[]{"K", "H", "J"};
        GCSRGB = new String[]{"K", "H", "Z"};
        DXSRGB = new String[]{"K", "H", "J"};
        UDSRGB = new String[]{"K", "H", "J"};
        CALRGB = new String[]{"K", "H", "Z"};
        UHSRGB = new String[]{"K", "H", "J"};
        UKIDSSTESTERPROGS = new int[]{101, 102, 103, 104, 105, 107, 11, 12, 13, 14, 15, 1};
        UKIDSSPROGS = new int[]{101, 102, 103, 104, 105};
        UKIDSSUHSPROGS = new int[]{101, 102, 103, 104, 105, 107};
        WORLDPROGS = UKIDSSPROGS;
        PRERELEASEPROGS = UKIDSSTESTERPROGS;
        UKIDSSUDSSOURCEVIEWNAME = null;
        UHSSOURCEVIEWNAME = null;
        WFCAMFILTERS = new String[]{"NONE", "Z", "Y", "J", "H", "K", "H2", "Br", "BLNK", "NBJ", "NBH", "NBK"};
        filters = WFCAMFILTERS;
        COMMISSIONINGBands = new String[]{"Z", "Y", "J", "H", "K", "H2", "Br"};
        int[] nArray3 = new int[9];
        nArray3[1] = 1;
        nArray3[2] = 1;
        nArray3[3] = 1;
        nArray3[4] = 1;
        nArray3[5] = 1;
        nArray3[6] = 1;
        nArray3[7] = 1;
        COMMISSIONINGREQFILTERS = nArray3;
        LASBands = new String[]{"Y", "J_1", "J_2", "H", "K"};
        int[] nArray4 = new int[9];
        nArray4[2] = 1;
        nArray4[3] = 2;
        nArray4[4] = 1;
        nArray4[5] = 1;
        LASREQFILTERS = nArray4;
        GPSBands = new String[]{"J", "H", "K_1", "K_2", "H2"};
        int[] nArray5 = new int[9];
        nArray5[3] = 1;
        nArray5[4] = 1;
        nArray5[5] = 2;
        nArray5[6] = 1;
        GPSREQFILTERS = nArray5;
        int[] nArray6 = new int[8];
        nArray6[2] = 1;
        nArray6[3] = 1;
        nArray6[4] = 3;
        nArray6[5] = 3;
        GPSREQFILTERSDR2 = nArray6;
        GCSBands = new String[]{"Z", "Y", "J", "H", "K_1", "K_2"};
        int[] nArray7 = new int[9];
        nArray7[1] = 1;
        nArray7[2] = 1;
        nArray7[3] = 1;
        nArray7[4] = 1;
        nArray7[5] = 2;
        GCSREQFILTERS = nArray7;
        DXSBands = new String[]{"J", "H", "K"};
        int[] nArray8 = new int[9];
        nArray8[3] = 1;
        nArray8[4] = 1;
        nArray8[5] = 1;
        DXSREQFILTERS = nArray8;
        UDSBands = new String[]{"J", "H", "K"};
        int[] nArray9 = new int[9];
        nArray9[3] = 1;
        nArray9[4] = 1;
        nArray9[5] = 1;
        UDSREQFILTERS = nArray9;
        UHSBands = new String[]{"J"};
        int[] nArray10 = new int[9];
        nArray10[3] = 1;
        UHSREQFILTERS = nArray10;
        int[] nArray11 = new int[9];
        nArray11[3] = 1;
        nArray11[5] = 1;
        UHSREQFILTERS2 = nArray11;
        int[] nArray12 = new int[9];
        nArray12[3] = 1;
        nArray12[4] = 1;
        nArray12[5] = 1;
        UHSREQFILTERS3 = nArray12;
        int[] nArray13 = new int[9];
        nArray13[3] = 1;
        UHSPASSS = nArray13;
        CALBands = new String[]{"Z", "Y", "J", "H", "K", "H2", "Br", "NBJ"};
        int[] nArray14 = new int[10];
        nArray14[1] = 1;
        nArray14[2] = 1;
        nArray14[3] = 1;
        nArray14[4] = 1;
        nArray14[5] = 1;
        nArray14[6] = 1;
        nArray14[7] = 1;
        nArray14[9] = 1;
        CALREQFILTERS = nArray14;
    }

    public static String getPropertyFromFile(String property, String filename) {
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(filename));
            if (properties.getProperty(property) != null) {
                return properties.getProperty(property);
            }
            return "";
        }
        catch (IOException e) {
            return "";
        }
    }

    public static boolean getDoRollingDBFromFile(String filename) {
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(filename));
            return properties.getProperty("doRollingDB").equalsIgnoreCase("true");
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean isProgInDB(String db, int prog) {
        return WSASchema.getVersionNoOfRelease(db) >= WSASchema.getDetectionSchemaVersion(prog) && WSASchema.getVersionNoOfRelease(db) <= WSASchema.getLastSchemaVersion(prog);
    }

    public static boolean isSourceInDB(String db, int prog) {
        return WSASchema.getVersionNoOfRelease(db) >= WSASchema.getSourceSchemaVersion(prog);
    }

    public static int getVersionNoOfRelease(String schema) {
        int i = 0;
        while (i < ALLUKIDSSRDB.length) {
            if (schema.equalsIgnoreCase(ALLUKIDSSRDB[i])) {
                return UKIDSSVERSIONS[i];
            }
            ++i;
        }
        if (schema.equalsIgnoreCase(rollingDB)) {
            return 9999;
        }
        i = 0;
        while (i < WORLDDB.length) {
            if (schema.equalsIgnoreCase(WORLDDB[i])) {
                return WORLDVERSIONS[i];
            }
            ++i;
        }
        return -1;
    }

    public static int[] getReqFilters(String database, int surveyID) {
        switch (surveyID) {
            case 1: {
                return COMMISSIONINGREQFILTERS;
            }
            case 200: {
                return CALREQFILTERS;
            }
            case 101: {
                return LASREQFILTERS;
            }
            case 107: {
                if (database != null && database.toLowerCase().contains("dr3")) {
                    return UHSREQFILTERS3;
                }
                if (database != null && database.toLowerCase().contains("dr2")) {
                    return UHSREQFILTERS2;
                }
                return UHSREQFILTERS;
            }
            case 11: {
                return LASREQFILTERS;
            }
            case 102: {
                if (WSASchema.getVersionNoOfRelease(database) >= WSASchema.getVersionNoOfRelease("ukidssdr3plus") || database.equals("") || database == null) {
                    return GPSREQFILTERS;
                }
                return GPSREQFILTERSDR2;
            }
            case 12: {
                if (WSASchema.getVersionNoOfRelease(database) >= WSASchema.getVersionNoOfRelease("ukidssdr3plus")) {
                    return GPSREQFILTERS;
                }
                return GPSREQFILTERSDR2;
            }
            case 103: {
                return GCSREQFILTERS;
            }
            case 13: {
                return GCSREQFILTERS;
            }
            case 104: {
                return DXSREQFILTERS;
            }
            case 14: {
                return DXSREQFILTERS;
            }
            case 105: {
                return UDSREQFILTERS;
            }
            case 15: {
                return UDSREQFILTERS;
            }
        }
        return null;
    }

    public static int[] getReqFilters(int surveyID) {
        switch (surveyID) {
            case 1: {
                return COMMISSIONINGREQFILTERS;
            }
            case 200: {
                return CALREQFILTERS;
            }
            case 101: {
                return LASREQFILTERS;
            }
            case 107: {
                return UHSREQFILTERS;
            }
            case 11: {
                return LASREQFILTERS;
            }
            case 102: {
                return GPSREQFILTERS;
            }
            case 12: {
                return GPSREQFILTERS;
            }
            case 103: {
                return GCSREQFILTERS;
            }
            case 13: {
                return GCSREQFILTERS;
            }
            case 104: {
                return DXSREQFILTERS;
            }
            case 14: {
                return DXSREQFILTERS;
            }
            case 105: {
                return UDSREQFILTERS;
            }
            case 15: {
                return UDSREQFILTERS;
            }
        }
        return null;
    }

    public static String[] getDBsPlusRollingDB(String[] inDBs) {
        String[] retDBs = new String[inDBs.length + 1];
        int i = 0;
        while (i < inDBs.length) {
            retDBs[i] = inDBs[i];
            ++i;
        }
        retDBs[retDBs.length - 1] = rollingDB;
        return retDBs;
    }

    public static String[] getDBsPlusExtraDB(String[] inDBs, String[] extraDBs) {
        String[] retDBs = new String[inDBs.length + extraDBs.length];
        int i = 0;
        while (i < inDBs.length) {
            retDBs[i] = inDBs[i];
            ++i;
        }
        i = 0;
        while (i < extraDBs.length) {
            retDBs[inDBs.length + i] = extraDBs[i];
            ++i;
        }
        return retDBs;
    }

    public static String[] getDBsPlusExtraDBAtStart(String[] inDBs, String[] extraDBs) {
        String[] retDBs = new String[inDBs.length + extraDBs.length];
        int i = 0;
        while (i < extraDBs.length) {
            retDBs[i] = extraDBs[i];
            ++i;
        }
        i = 0;
        while (i < inDBs.length) {
            retDBs[inDBs.length + i] = inDBs[i];
            ++i;
        }
        return retDBs;
    }

    public static String getDefaultList(int[] reqFilters, String table, String database) {
        boolean validSchema = false;
        if (database.equalsIgnoreCase(PTSDB)) {
            database = LATESTUKIDSSDATABASE;
        }
        database = database.replaceAll("(?i)world", "ukidss");
        int i = 0;
        while (i < SCEHMAVALIDDATABASES.length) {
            if (database.equalsIgnoreCase(SCEHMAVALIDDATABASES[i])) {
                validSchema = true;
            }
            ++i;
        }
        if (table.toLowerCase().indexOf("detection") >= 0) {
            if (validSchema) {
                return "objID, multiframeID, filterID, RA, Dec, ell, pa, class, psfMag, hallMag,isoMag, petroMag, aperMag2, aperMag3";
            }
            return String.valueOf(table) + ".*";
        }
        if (table.toLowerCase().indexOf("source") >= 0) {
            if (validSchema) {
                StringBuffer sb = new StringBuffer("sourceID, framesetID, RA, Dec, mergedClass, priOrSec");
                if (reqFilters != null) {
                    sb.append(WSASchema.getReqMags(reqFilters));
                }
                return sb.toString();
            }
            return String.valueOf(table) + ".*";
        }
        return String.valueOf(table) + ".*";
    }

    public static String getDefaultList(int[] reqFilters, String table) {
        return WSASchema.getDefaultList(reqFilters, table, LATESTUKIDSSSCHEMA);
    }

    public static String getReqMags(int[] reqFilters) {
        StringBuffer sb1 = new StringBuffer("");
        int i = 0;
        while (i < reqFilters.length) {
            if (reqFilters[i] == 1) {
                sb1.append(", " + WSASchema.getFilterName(i) + "AperMag3");
                sb1.append(", " + WSASchema.getFilterName(i) + "AperMag3Err");
            }
            if (reqFilters[i] > 1) {
                int j = 0;
                while (j < reqFilters[i]) {
                    sb1.append(", " + WSASchema.getFilterName(i) + "_" + (j + 1) + "AperMag3");
                    sb1.append(", " + WSASchema.getFilterName(i) + "_" + (j + 1) + "AperMag3Err");
                    ++j;
                }
            }
            ++i;
        }
        return sb1.toString();
    }

    public static String[] getBands(int[] reqBands) {
        int noBands = 0;
        int i = 0;
        while (i < reqBands.length) {
            noBands += reqBands[i];
            ++i;
        }
        String[] bands = new String[noBands];
        int bandCount = 0;
        int i2 = 0;
        while (i2 < reqBands.length) {
            if (reqBands[i2] == 1) {
                bands[bandCount] = WSASchema.getFilterName(i2);
                ++bandCount;
            }
            if (reqBands[i2] > 1) {
                int j = 0;
                while (j < reqBands[i2]) {
                    bands[bandCount] = String.valueOf(WSASchema.getFilterName(i2)) + "_" + (j + 1);
                    ++bandCount;
                    ++j;
                }
            }
            ++i2;
        }
        return bands;
    }

    public static String[] getBands(String database, int surveyID) {
        int[] reqBands = WSASchema.getReqFilters(database, surveyID);
        int noBands = 0;
        int i = 0;
        while (i < reqBands.length) {
            noBands += reqBands[i];
            ++i;
        }
        String[] bands = new String[noBands];
        int bandCount = 0;
        int i2 = 0;
        while (i2 < reqBands.length) {
            if (reqBands[i2] == 1) {
                bands[bandCount] = WSASchema.getFilterName(i2);
                ++bandCount;
            }
            if (reqBands[i2] > 1) {
                int j = 0;
                while (j < reqBands[i2]) {
                    bands[bandCount] = String.valueOf(WSASchema.getFilterName(i2)) + "_" + (j + 1);
                    ++bandCount;
                    ++j;
                }
            }
            ++i2;
        }
        return bands;
    }

    public static String[] getBands(int surveyID) {
        switch (surveyID) {
            case 1: {
                return COMMISSIONINGBands;
            }
            case 101: {
                return LASBands;
            }
            case 11: {
                return LASBands;
            }
            case 102: {
                return GPSBands;
            }
            case 12: {
                return GPSBands;
            }
            case 103: {
                return GCSBands;
            }
            case 13: {
                return GCSBands;
            }
            case 104: {
                return DXSBands;
            }
            case 14: {
                return DXSBands;
            }
            case 105: {
                return UDSBands;
            }
            case 15: {
                return UDSBands;
            }
            case 107: {
                return UHSBands;
            }
        }
        return null;
    }

    public static String getMergeTableName(int surveyID) {
        String mergeTableName;
        switch (surveyID) {
            case 1: {
                mergeTableName = COMMISSIONINGMERGETABLENAME;
                break;
            }
            case 200: {
                mergeTableName = CALMERGETABLENAME;
                break;
            }
            case 101: {
                mergeTableName = UKIDSSLASMERGETABLENAME;
                break;
            }
            case 102: {
                mergeTableName = UKIDSSGPSMERGETABLENAME;
                break;
            }
            case 103: {
                mergeTableName = UKIDSSGCSMERGETABLENAME;
                break;
            }
            case 104: {
                mergeTableName = UKIDSSDXSMERGETABLENAME;
                break;
            }
            case 105: {
                mergeTableName = UKIDSSUDSMERGETABLENAME;
                break;
            }
            case 107: {
                mergeTableName = UHSMERGETABLENAME;
                break;
            }
            case 11: {
                mergeTableName = UKIDSSLASMERGETABLENAME;
                break;
            }
            case 12: {
                mergeTableName = UKIDSSGPSMERGETABLENAME;
                break;
            }
            case 13: {
                mergeTableName = UKIDSSGCSMERGETABLENAME;
                break;
            }
            case 14: {
                mergeTableName = UKIDSSDXSMERGETABLENAME;
                break;
            }
            case 15: {
                mergeTableName = UKIDSSUDSMERGETABLENAME;
                break;
            }
            default: {
                mergeTableName = null;
            }
        }
        return mergeTableName;
    }

    public static int getSourceSchemaVersion(int surveyID) {
        int schemaVersion = -1;
        switch (surveyID) {
            case 106: {
                schemaVersion = 99999;
                break;
            }
            case 200: {
                schemaVersion = 99999;
                break;
            }
            default: {
                schemaVersion = -1;
            }
        }
        return schemaVersion;
    }

    public static int getDetectionSchemaVersion(int surveyID) {
        int schemaVersion = -1;
        switch (surveyID) {
            case 106: {
                schemaVersion = -1;
                break;
            }
            case 200: {
                schemaVersion = -1;
                break;
            }
            default: {
                schemaVersion = -1;
            }
        }
        return schemaVersion;
    }

    public static int getLastSchemaVersion(int surveyID) {
        int schemaVersion = 99999999;
        schemaVersion = 99999999;
        return schemaVersion;
    }

    public static String getSourceTableName(int surveyID) {
        String sourceTableName;
        switch (surveyID) {
            case 1: {
                sourceTableName = COMMISSIONINGSOURCETABLENAME;
                break;
            }
            case 200: {
                sourceTableName = CALSOURCETABLENAME;
                break;
            }
            case 101: {
                sourceTableName = UKIDSSLASSOURCETABLENAME;
                break;
            }
            case 102: {
                sourceTableName = UKIDSSGPSSOURCETABLENAME;
                break;
            }
            case 103: {
                sourceTableName = UKIDSSGCSSOURCETABLENAME;
                break;
            }
            case 104: {
                sourceTableName = UKIDSSDXSSOURCETABLENAME;
                break;
            }
            case 105: {
                sourceTableName = UKIDSSUDSSOURCETABLENAME;
                break;
            }
            case 107: {
                sourceTableName = UHSSOURCETABLENAME;
                break;
            }
            case 11: {
                sourceTableName = UKIDSSLASSOURCETABLENAME;
                break;
            }
            case 12: {
                sourceTableName = UKIDSSGPSSOURCETABLENAME;
                break;
            }
            case 13: {
                sourceTableName = UKIDSSGCSSOURCETABLENAME;
                break;
            }
            case 14: {
                sourceTableName = UKIDSSDXSSOURCETABLENAME;
                break;
            }
            case 15: {
                sourceTableName = UKIDSSUDSSOURCETABLENAME;
                break;
            }
            default: {
                sourceTableName = null;
            }
        }
        return sourceTableName;
    }

    public static String[] getDefaultRGB(int surveyID) {
        String[] RGB = null;
        switch (surveyID) {
            case 101: {
                RGB = LASRGB;
                break;
            }
            case 102: {
                RGB = GPSRGB;
                break;
            }
            case 103: {
                RGB = GCSRGB;
                break;
            }
            case 104: {
                RGB = DXSRGB;
                break;
            }
            case 105: {
                RGB = UDSRGB;
                break;
            }
            case 107: {
                RGB = UHSRGB;
                break;
            }
            case 200: {
                RGB = CALRGB;
                break;
            }
        }
        return RGB;
    }

    public static String getSourceViewName(int surveyID) {
        String sourceViewName;
        switch (surveyID) {
            case 101: {
                sourceViewName = UKIDSSLASSOURCEVIEWNAME;
                break;
            }
            case 102: {
                sourceViewName = UKIDSSGPSSOURCEVIEWNAME;
                break;
            }
            case 103: {
                sourceViewName = UKIDSSGCSSOURCEVIEWNAME;
                break;
            }
            case 104: {
                sourceViewName = UKIDSSDXSSOURCEVIEWNAME;
                break;
            }
            case 105: {
                sourceViewName = UKIDSSUDSSOURCEVIEWNAME;
                break;
            }
            default: {
                sourceViewName = null;
            }
        }
        return sourceViewName;
    }

    public static String getDetectionTableName(int surveyID) {
        String detectionTableName;
        switch (surveyID) {
            case 1: {
                detectionTableName = COMMISSIONINGDETECTIONTABLENAME;
                break;
            }
            case 101: {
                detectionTableName = UKIDSSLASDETECTIONTABLENAME;
                break;
            }
            case 102: {
                detectionTableName = UKIDSSGPSDETECTIONTABLENAME;
                break;
            }
            case 103: {
                detectionTableName = UKIDSSGCSDETECTIONTABLENAME;
                break;
            }
            case 104: {
                detectionTableName = UKIDSSDXSDETECTIONTABLENAME;
                break;
            }
            case 105: {
                detectionTableName = UKIDSSUDSDETECTIONTABLENAME;
                break;
            }
            case 107: {
                detectionTableName = UHSDETECTIONTABLENAME;
                break;
            }
            case 106: {
                detectionTableName = PTSDETECTIONTABLENAME;
                break;
            }
            case 200: {
                detectionTableName = CALDETECTIONTABLENAME;
                break;
            }
            case 11: {
                detectionTableName = UKIDSSLASDETECTIONTABLENAME;
                break;
            }
            case 12: {
                detectionTableName = UKIDSSGPSDETECTIONTABLENAME;
                break;
            }
            case 13: {
                detectionTableName = UKIDSSGCSDETECTIONTABLENAME;
                break;
            }
            case 14: {
                detectionTableName = UKIDSSDXSDETECTIONTABLENAME;
                break;
            }
            case 15: {
                detectionTableName = UKIDSSUDSDETECTIONTABLENAME;
                break;
            }
            default: {
                detectionTableName = null;
            }
        }
        return detectionTableName;
    }

    public static String getSurveyName(int surveyID) {
        String surveyName;
        switch (surveyID) {
            case 1: {
                surveyName = "Commissioning programme";
                break;
            }
            case 99: {
                surveyName = "Curation test programme";
                break;
            }
            case 101: {
                surveyName = "UKIDSS Large Area Survey, LAS";
                break;
            }
            case 102: {
                surveyName = "UKIDSS Galactic Plane Survey, GPS";
                break;
            }
            case 103: {
                surveyName = "UKIDSS Galactic Clusters Survey, GCS";
                break;
            }
            case 104: {
                surveyName = "UKIDSS Deep Extragalactic Survey, DXS";
                break;
            }
            case 105: {
                surveyName = "UKIDSS Ultra Deep Survey, UDS";
                break;
            }
            case 107: {
                surveyName = "UKIRT Hemisphere Survey, UHS";
                break;
            }
            case 106: {
                surveyName = "Planetary Transit Survey, PTS";
                break;
            }
            case 200: {
                surveyName = "UKIRT Faint Standard Observations";
                break;
            }
            case 11: {
                surveyName = "UKIDSS Large Area Survey, LAS, Science Verification";
                break;
            }
            case 12: {
                surveyName = "UKIDSS Galactic Plane Survey, GPS, Science Verification";
                break;
            }
            case 13: {
                surveyName = "UKIDSS Galactic Clusters Survey, GCS, Science Verification";
                break;
            }
            case 14: {
                surveyName = "UKIDSS Deep Extragalactic Survey, DXS, Science Verification";
                break;
            }
            case 15: {
                surveyName = "UKIDSS Ultra Deep Survey, UDS, Science Verification";
                break;
            }
            default: {
                surveyName = "Survey name not found in lookup";
            }
        }
        return surveyName;
    }

    public static String getFilterName(int filterID) {
        if (filterID >= 0 && filterID <= WFCAMFILTERS.length && WFCAMFILTERS[filterID] != null) {
            return WFCAMFILTERS[filterID];
        }
        return "NULL";
    }

    public static String getRequiredFiltersSQL() {
        return "select filterid,npass from requiredfilters";
    }

    public static StringBuffer getFramesetSQL(int[] fID, String mergelogTable, String multiframeTable) {
        StringBuffer sbSQL = new StringBuffer("");
        String mfidName = null;
        int row = 0;
        boolean first = true;
        int j = 0;
        while (j < fID.length) {
            int filterid = j;
            int npass = fID[j];
            row += npass;
            if (npass == 1) {
                mfidName = String.valueOf(WSASchema.getFilterName(filterid)) + "mfid";
                if (!first) {
                    sbSQL.append(" or ");
                }
                first = false;
                sbSQL.append(String.valueOf(mergelogTable) + "." + mfidName + "=" + multiframeTable + ".multiframeid");
            } else if (npass > 1) {
                int i = 0;
                while (i < npass) {
                    mfidName = String.valueOf(WSASchema.getFilterName(filterid)) + "_" + (i + 1) + "mfid";
                    if (!first) {
                        sbSQL.append(" or ");
                    }
                    first = false;
                    sbSQL.append(String.valueOf(mergelogTable) + "." + mfidName + "=" + multiframeTable + ".multiframeid");
                    ++i;
                }
            }
            ++j;
        }
        if (row > 0) {
            return sbSQL;
        }
        return null;
    }

    public static String getCrossIDTableTable(String community, String user, String baseTable, int intProgrammeID) {
        if (community.equalsIgnoreCase(NONSURVEYCOMMUNITY)) {
            return String.valueOf(user.trim()) + baseTable;
        }
        if (baseTable.equalsIgnoreCase("sourceView")) {
            return WSASchema.getSourceViewName(intProgrammeID);
        }
        if (baseTable.equalsIgnoreCase("source")) {
            return WSASchema.getSourceTableName(intProgrammeID);
        }
        if (baseTable.equalsIgnoreCase("detection")) {
            return WSASchema.getDetectionTableName(intProgrammeID);
        }
        return "";
    }

    public static String getCrossIDDefaultSelect(String community, String tableName, HttpSession session, int programmeID, String database) {
        if (community.equalsIgnoreCase(NONSURVEYCOMMUNITY)) {
            int[] reqFilters = null;
            if (session.getAttribute("reqFilters") != null) {
                reqFilters = (int[])session.getAttribute("reqFilters");
            }
            return WSASchema.getDefaultList(reqFilters, tableName, WSASession.getSchemaVersion(session));
        }
        return WSASchema.getDefaultList(WSASchema.getReqFilters(programmeID), tableName, database);
    }

    public static StringBuffer getFramesetSQL(ResultSet rset, String mergelogTable, String multiframeTable) {
        StringBuffer sbSQL = new StringBuffer("");
        String mfidName = null;
        int row = 0;
        boolean first = true;
        try {
            while (rset.next()) {
                ++row;
                int filterid = rset.getInt("filterid");
                int npass = rset.getInt("npass");
                if (npass == 1) {
                    mfidName = String.valueOf(WSASchema.getFilterName(filterid)) + "mfid";
                    if (!first) {
                        sbSQL.append(" or ");
                    }
                    first = false;
                    sbSQL.append(String.valueOf(mergelogTable) + "." + mfidName + "=" + multiframeTable + ".multiframeid");
                    continue;
                }
                if (npass <= 1) continue;
                int i = 0;
                while (i < npass) {
                    mfidName = String.valueOf(WSASchema.getFilterName(filterid)) + "_" + (i + 1) + "mfid";
                    if (!first) {
                        sbSQL.append(" or ");
                    }
                    first = false;
                    sbSQL.append(String.valueOf(mergelogTable) + "." + mfidName + "=" + multiframeTable + ".multiframeid");
                    ++i;
                }
            }
            if (row > 0) {
                return sbSQL;
            }
            return null;
        }
        catch (SQLException se) {
            return null;
        }
    }

    public static String getUCDofCol(String col) {
        if (colMap != null && colMap.containsKey(col.toUpperCase())) {
            String info = (String)colMap.get(col.toUpperCase());
            String[] bits = info.split("###");
            return bits[0];
        }
        return "unknown";
    }

    public static boolean isCommunityUHS(String community) {
        String comm = community.toLowerCase().trim();
        return comm.endsWith(".uk") || comm.contains("hawaii") || comm.equalsIgnoreCase("arizona.edu");
    }

    public static String getDescofCol(String col) {
        if (colMap != null && colMap.containsKey(col.toUpperCase())) {
            String info = (String)colMap.get(col.toUpperCase());
            String[] dBits = info.split("###");
            return dBits[1];
        }
        return "unknown";
    }
}

