/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.roe.wfau;

import flanagan.complex.Complex;
import flanagan.complex.ComplexPoly;
import flanagan.math.Matrix;

public class WcsIDL {
    static final int ZPN_TYPE = 6;
    static final int TAN_TYPE = 2;
    static final double[] CDELT = new double[]{1.0, 1.0};
    static double[] ZEROS = new double[]{0.0, 0.0};
    static double[] DEFAULTS = new double[]{-9999.9999, -9999.9999};
    static final double[] NAN = new double[]{Double.NaN, Double.NaN};
    static final double TOL = 1.0E-12;
    static final double D2R = Math.PI / 180;
    static double NORTH_OFFSET = -6.0;
    static double SOUTH_OFFSET = -6.0;
    static double POLE_OFFSET = -6.0;
    static double RADEG = 57.29577951308232;
    static double PI2 = 1.5707963267948966;

    public static int getProjType(String cType) {
        if (cType.toLowerCase().indexOf("ZPN") >= 0) {
            return 6;
        }
        if (cType.toLowerCase().indexOf("TAN") >= 0) {
            return 2;
        }
        return -1;
    }

    public static double getW0(double[] pv) throws ArithmeticException {
        double w0 = Double.NaN;
        int k = pv.length - 1;
        while (k >= 0 && pv[k] == 0.0) {
            --k;
        }
        System.out.println("get W0 k " + k);
        if (k == 3) {
            if (pv[1] == 1.0 && pv[2] == 0.0) {
                if (pv[3] == -60.0) {
                    return 0.07453559924999299;
                }
                if (pv[3] == -50.0) {
                    return 0.08164965809277261;
                }
                if (pv[3] == -46.0) {
                    return 0.08512565307587486;
                }
                if (pv[3] == -45.0) {
                    return 0.08606629658238704;
                }
                if (pv[3] == -44.0) {
                    return 0.08703882797784891;
                }
            }
        } else if (k == 5 && pv[1] == 1.0 && pv[2] == 0.0 && pv[3] == 42.0 && pv[4] == 0.0 && pv[5] == -10000.0) {
            return 0.07685210339567314;
        }
        if (k < 0) {
            throw new ArithmeticException("Invalid PV polynomial");
        }
        if (k < 2) {
            w0 = Math.PI;
        } else {
            double zd1 = 0.0;
            double d1 = pv[1];
            if (d1 <= 0.0) {
                throw new ArithmeticException("PV, no solution");
            }
            double zd2 = 0.0;
            double d2 = 0.0;
            int j = 0;
            while (j < 180) {
                zd2 = (double)j * (Math.PI / 180);
                d2 = 0.0;
                int m = k;
                while (m > 0) {
                    d2 = d2 * zd2 + (double)m * pv[m];
                    --m;
                }
                if (d2 <= 0.0) break;
                zd1 = zd2;
                d1 = d2;
                ++j;
            }
            System.out.println(" j " + j);
            double zd = 0.0;
            if (j == 180) {
                zd = Math.PI;
            } else {
                j = 1;
                while (j <= 15) {
                    zd = zd1 - d1 * (zd2 - zd1) / (d2 - d1);
                    double d = 0.0;
                    int m = k;
                    while (m > 0) {
                        d = d * zd + (double)m * pv[m];
                        --m;
                    }
                    System.out.println(String.valueOf(j) + " get W0 d " + d);
                    if (Math.abs(d) < 1.0E-12) break;
                    if (d < 0.0) {
                        zd2 = zd;
                        d2 = d;
                    } else {
                        zd1 = zd;
                        d1 = d;
                    }
                    ++j;
                }
            }
            w0 = zd;
        }
        System.out.println("get W0 w0 " + w0);
        return Double.NaN;
    }

    public static double[] wcsRotate(double longitude, double latitude, double[] crval, double theta0, boolean reverse) {
        return WcsIDL.wcsRotate(longitude, latitude, crval, 180.0, theta0, reverse);
    }

    public static double[] wcsRotate(double longitude, double latitude, double[] crval, double longpole, double theta0, boolean reverse) {
        double theta1;
        double phi1;
        System.out.println("longpole " + longpole);
        double phi_p = longpole / RADEG;
        double sp = Math.sin(phi_p);
        double cp = Math.cos(phi_p);
        double alpha_p = 0.0;
        double delta_p = 0.0;
        double[] retValues = new double[2];
        if (theta0 == 90.0) {
            System.out.println("theta0 = 90");
            alpha_p = crval[0] / RADEG;
            delta_p = crval[1] / RADEG;
        }
        double sa = Math.sin(alpha_p);
        double ca = Math.cos(alpha_p);
        double sd = Math.sin(delta_p);
        double cd = Math.cos(delta_p);
        System.out.println("sa " + sa);
        System.out.println("ca " + ca);
        System.out.println("sd " + sd);
        System.out.println("cd " + cd);
        double[][] r = new double[][]{{-sa * sp - ca * cp * sd, sa * cp - ca * sp * sd, ca * cd}, {ca * sp - sa * cp * sd, -ca * cp - sa * sp * sd, sa * cd}, {cp * cd, sp * cd, sd}};
        if (reverse) {
            System.out.println("reverse ");
            phi1 = longitude / RADEG;
            theta1 = latitude / RADEG;
            int row = 0;
            while (row < 3) {
                int col = 0;
                while (col < row) {
                    double temp = r[row][col];
                    r[row][col] = r[col][row];
                    r[col][row] = temp;
                    ++col;
                }
                ++row;
            }
        } else {
            System.out.println("forward ");
            double phi = longitude;
            phi1 = longitude / RADEG;
            theta1 = latitude / RADEG;
        }
        System.out.println("phi1 " + phi1);
        System.out.println("theta1 " + theta1);
        double l = Math.cos(theta1) * Math.cos(phi1);
        double m = Math.cos(theta1) * Math.sin(phi1);
        double n = Math.sin(theta1);
        System.out.println("r00 " + r[0][0]);
        System.out.println("r01 " + r[0][1]);
        System.out.println("r02 " + r[0][2]);
        System.out.println("r10 " + r[1][0]);
        System.out.println("r11 " + r[1][1]);
        System.out.println("r12 " + r[1][2]);
        System.out.println("r20 " + r[2][0]);
        System.out.println("r21 " + r[2][1]);
        System.out.println("r22 " + r[2][2]);
        System.out.println("l " + l);
        System.out.println("m " + m);
        System.out.println("n " + n);
        double b0 = r[0][0] * l + r[1][0] * m + r[2][0] * n;
        double b1 = r[0][1] * l + r[1][1] * m + r[2][1] * n;
        double b2 = r[0][2] * l + r[1][2] * m + r[2][2] * n;
        if (b2 < -1.0) {
            b2 = -1.0;
        }
        if (b2 > 1.0) {
            b2 = 1.0;
        }
        System.out.println("b0 " + b0);
        System.out.println("b1 " + b1);
        System.out.println("b2 " + b2);
        if (reverse) {
            retValues[1] = Math.asin(b2) * RADEG;
            retValues[0] = Math.atan2(b1, b0) * RADEG;
        } else {
            retValues[1] = Math.asin(b2) * RADEG;
            retValues[0] = Math.atan2(b1, b0) * RADEG;
        }
        return retValues;
    }

    public static double[] xy2ad(double x, double y, int map_type, double[] crval, double[] crpix, double[][] cd, double[] pv2, boolean reverse) {
        return WcsIDL.xy2ad(x, y, map_type, crval, crpix, cd, pv2, CDELT, reverse);
    }

    public static double[] xy2ad(double x, double y, int map_type, double[] crval, double[] crpix, double[][] cd, double[] pv2, double[] cdelt, boolean reverse) {
        double[] ad = new double[2];
        if (cdelt[0] != 1.0) {
            cd[0][0] = cd[0][0] * cdelt[0];
            cd[0][1] = cd[0][1] * cdelt[0];
            cd[1][1] = cd[1][1] * cdelt[1];
            cd[1][0] = cd[1][0] * cdelt[1];
        }
        double xdif = x - (crpix[0] - 1.0);
        double ydif = y - (crpix[1] - 1.0);
        double xsi = cd[0][0] * xdif + cd[0][1] * ydif;
        double eta = cd[1][0] * xdif + cd[1][1] * ydif;
        if (reverse) {
            double temp = crval[0];
            crval[0] = crval[1];
            crval[1] = temp;
            temp = xsi;
            xsi = eta;
            eta = temp;
        }
        System.out.println("xsi " + xsi);
        System.out.println("eta " + eta);
        ad = WcsIDL.wcsXy2Sph(xsi, eta, map_type, crval, pv2);
        return ad;
    }

    public static double[] ad2xy(double longitude, double latitude, int map_type, double[] crval, double[] crpix, double[][] cd, double[] pv2, boolean reverse) {
        return WcsIDL.ad2xy(longitude, latitude, map_type, crval, crpix, cd, pv2, CDELT, reverse);
    }

    public static double[] ad2xy(double longitude, double latitude, int map_type, double[] crval, double[] crpix, double[][] cd, double[] pv2, double[] cdelt, boolean reverse) {
        double[] xyPix = new double[2];
        if (reverse) {
            double temp = crval[0];
            crval[0] = crval[1];
            crval[1] = temp;
        }
        System.out.println("crvals " + crval[0] + " : " + crval[1]);
        double[] xsiEta = WcsIDL.wcsSph2Xy(longitude, latitude, map_type, crval, pv2);
        if (Double.isNaN(xsiEta[0]) || Double.isNaN(xsiEta[1])) {
            System.out.println("NOT a number");
            return NAN;
        }
        double xsi = xsiEta[0];
        double eta = xsiEta[1];
        if (cdelt[0] != 1.0) {
            cd[0][0] = cd[0][0] * cdelt[0];
            cd[0][1] = cd[0][1] * cdelt[0];
            cd[1][1] = cd[1][1] * cdelt[1];
            cd[1][0] = cd[1][0] * cdelt[1];
        }
        System.out.println("CD11 " + cd[0][0]);
        System.out.println("CD11 " + cd[0][1]);
        System.out.println("CD21 " + cd[1][0]);
        System.out.println("CD22 " + cd[1][1]);
        if (reverse) {
            double temp = xsi;
            xsi = eta;
            eta = temp;
        }
        Matrix mat = new Matrix(cd);
        Matrix invMat = mat.inverse();
        double[][] cdinv = invMat.getArrayCopy();
        System.out.println("cdinv11 " + cdinv[0][0]);
        System.out.println("cdinv11 " + cdinv[0][1]);
        System.out.println("cdinv21 " + cdinv[1][0]);
        System.out.println("cdinv22 " + cdinv[1][1]);
        double xdif = cdinv[0][0] * xsi + cdinv[0][1] * eta;
        double ydif = cdinv[1][0] * xsi + cdinv[1][1] * eta;
        System.out.println("xdif " + xdif);
        System.out.println("ydif " + ydif);
        xyPix[0] = xdif + crpix[0];
        xyPix[1] = ydif + crpix[1];
        return xyPix;
    }

    public static double[] wcsXy2Sph(double xsi, double eta, int map_type, double[] crval) {
        return WcsIDL.wcsXy2Sph(xsi, eta, map_type, crval, ZEROS);
    }

    public static double[] wcsXy2Sph(double xsi, double eta, int map_type, double[] crval, double[] pv2) {
        double[] ad = new double[]{Double.NaN, Double.NaN};
        double x = xsi;
        double y = eta;
        double xx = x;
        double yy = y;
        switch (map_type) {
            case 6: {
                double rtheta = Math.sqrt(xx * xx + yy * yy) / RADEG;
                System.out.println("rtheta " + rtheta);
                double phi = Math.atan2(xx, -yy);
                System.out.println("phi " + phi);
                int np = 0;
                int nZ = 0;
                int i = 0;
                while (i < pv2.length) {
                    if (pv2[i] != 0.0) {
                        np = i + 1;
                        ++nZ;
                    }
                    ++i;
                }
                System.out.println("np " + np);
                System.out.println("nz " + nZ);
                if (nZ == 0) {
                    return NAN;
                }
                double[] pv2NZ = new double[np];
                double[] pv = new double[np];
                int i2 = 0;
                while (i2 < np) {
                    pv2NZ[i2] = pv2[i2];
                    pv[i2] = pv2[i2];
                    System.out.println("PV2NZ i " + pv2NZ[i2] + " : " + i2);
                    ++i2;
                }
                pv[0] = pv[0] - rtheta;
                System.out.println("PV2NZ 0 and Pv 0 " + pv2NZ[0] + " : " + pv[0]);
                ComplexPoly cp = new ComplexPoly(pv);
                Complex[] c = cp.roots();
                int i3 = 0;
                while (i3 < c.length) {
                    System.out.println("pv real imag " + c[i3].getReal() + " : " + c[i3].getImag());
                    System.out.println(c[i3].isRealperCent(1.0E-13));
                    ++i3;
                }
                break;
            }
            case 2: {
                break;
            }
            default: {
                ad[0] = Double.NaN;
                ad[1] = Double.NaN;
            }
        }
        return ad;
    }

    public static double[] wcsSph2Xy(double longitude, double latitude, int map_type, double[] crval) {
        return WcsIDL.wcsSph2Xy(longitude, latitude, map_type, crval, ZEROS);
    }

    public static double[] wcsSph2Xy(double longitude, double latitude, int map_type, double[] crval, double[] pv2) {
        double[] xy = new double[]{Double.NaN, Double.NaN};
        if (longitude >= 180.0) {
            longitude -= 360.0;
        }
        if (Math.abs(latitude - 90.0) < NORTH_OFFSET * RADEG) {
            latitude = 90.0 - NORTH_OFFSET * RADEG;
        }
        if (Math.abs(latitude + 90.0) < NORTH_OFFSET * RADEG) {
            latitude = SOUTH_OFFSET * RADEG * 90.0;
        }
        double pv2_1 = pv2[0];
        double pv2_2 = pv2[1];
        double theta0 = 0.0;
        if (map_type >= 1 && map_type <= 8) {
            theta0 = 90.0;
        } else if (map_type >= 13 && map_type <= 16) {
            theta0 = pv2_1;
        }
        double[] phiTheta = WcsIDL.wcsRotate(longitude, latitude, crval, theta0, false);
        double phi = phiTheta[0] / RADEG;
        double theta = phiTheta[1] / RADEG;
        System.out.println(" THETA " + theta);
        switch (map_type) {
            case 6: {
                double z = PI2 - theta;
                System.out.println(" Z " + z);
                int np = 0;
                int nZ = 0;
                int i = 0;
                while (i < pv2.length) {
                    if (pv2[i] != 0.0) {
                        np = i + 1;
                        ++nZ;
                    }
                    ++i;
                }
                System.out.println("np " + np + " nZ" + nZ);
                double[] par = new double[np];
                int i2 = 0;
                while (i2 < np) {
                    par[i2] = pv2[i2];
                    System.out.println("par " + i2 + " " + par[i2]);
                    ++i2;
                }
                boolean bad = false;
                double[] dpar = new double[np - 1];
                if (np > 3) {
                    int i3 = 0;
                    while (i3 < dpar.length) {
                        dpar[i3] = (double)(i3 + 1) * par[i3 + 1];
                        System.out.println("dpar " + i3 + " " + dpar[i3]);
                        ++i3;
                    }
                    ComplexPoly cp = new ComplexPoly(dpar);
                    Complex[] c = cp.roots();
                    boolean realPresent = false;
                    boolean positiveRoots = false;
                    double rlim = -9999.9999;
                    int j = 0;
                    while (j < c.length) {
                        System.out.println(c[j].getImag());
                        if (c[j].getImag() == 0.0) {
                            realPresent = true;
                            System.out.println(String.valueOf(j) + " real " + c[j].getReal());
                            if (c[j].getReal() > 0.0) {
                                if (positiveRoots) {
                                    rlim = Math.min(rlim, c[j].getReal());
                                } else {
                                    positiveRoots = true;
                                    rlim = c[j].getReal();
                                }
                            }
                        }
                        ++j;
                    }
                    System.out.println("rlim " + rlim);
                    if (z > rlim || !positiveRoots) {
                        bad = true;
                    }
                }
                if (bad) break;
                double r_theta = RADEG * WcsIDL.poly(z, par);
                System.out.println("poly " + WcsIDL.poly(z, par));
                System.out.println("r_theta " + r_theta);
                xy[0] = r_theta * Math.sin(phi);
                xy[1] = -r_theta * Math.cos(phi);
                System.out.println("xy " + xy[0] + " " + xy[1]);
                break;
            }
            case 2: {
                if (!(theta > 0.0)) break;
                double r_theta = RADEG / Math.tan(theta);
                xy[0] = r_theta * Math.sin(phi);
                xy[1] = -r_theta * Math.cos(phi);
                break;
            }
            default: {
                xy[0] = Double.NaN;
                xy[1] = Double.NaN;
            }
        }
        return xy;
    }

    private static double poly(double x, double[] c) {
        double rslt = 0.0;
        int i = 0;
        while (i < c.length) {
            rslt += c[i] * Math.pow(x, i);
            ++i;
        }
        return rslt;
    }

    public static void main(String[] args) {
        double[] pv2 = new double[]{0.0, 1.0, 0.0, 42.0, 0.0, -10000.0};
        double[] crpix = new double[]{5388.6, 6847.8};
        double[][] cd = new double[][]{{0.0, -9.47983333333333E-5}, {9.47983333333333E-5, 0.0}};
        double[] crval = new double[]{330.00055417128, -60.0058333318789};
        double longitude = 330.00055417128;
        double latitude = -61.0058333318789;
        int j = 1;
        while (j < 2) {
            System.out.println("jjj " + j);
            double[] xypix = WcsIDL.ad2xy(longitude, latitude, 6, crval, crpix, cd, pv2, false);
            System.out.println("xyPix " + xypix[0] + " " + xypix[1]);
            ++j;
        }
        double tt = Double.NaN;
        System.out.println(tt < 0.0);
        System.out.println("\n\n\n\n OTHER");
        double[] xypix = WcsIDL.xy2ad(100.0, 100.0, 6, crval, crpix, cd, pv2, false);
        double w0 = WcsIDL.getW0(pv2);
        System.out.println("\n\n\n\n w0000 " + w0);
    }
}

