/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.roe.wfau;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import uk.ac.roe.wfau.SQLMethods;

public class XMLSQL {
    public static void main(String[] args) throws SQLException, IOException {
        try {
            Class.forName("net.sourceforge.jtds.jdbc.Driver");
        }
        catch (ClassNotFoundException e) {
            System.out.println("Could not load the driver");
        }
        System.out.println("user, pass,database,server,sqlFile");
        String user = args[0];
        String pass = args[1];
        String database = args[2];
        String server = args[3];
        String sqlFile = args[4];
        String sqlStmt = XMLSQL.readFileAsString(sqlFile);
        Properties info = new Properties();
        int i = 0;
        try {
            String parsedSqlStmt = SQLMethods.parseSQL(sqlStmt);
            String durl = "jdbc:jtds:sqlserver://" + server + ":1433/" + database + ";user=" + user + ";password=" + pass;
            Connection conn = DriverManager.getConnection(durl);
            conn.setTransactionIsolation(1);
            Statement stmt = conn.createStatement();
            String qp = SQLMethods.checkQueryPlan(stmt, parsedSqlStmt);
            stmt.executeUpdate("set showplan_all off");
            ResultSetMetaData rsmd = SQLMethods.browseSQL(conn, parsedSqlStmt);
            System.out.println(rsmd);
            stmt.setMaxRows(300000001);
            stmt.setFetchSize(500);
            stmt.setQueryTimeout(3600);
            stmt.execute("set fmtonly off");
            stmt.executeUpdate("set showplan_xml on");
            System.out.println("fd " + stmt.getFetchDirection());
            System.out.println("fs " + stmt.getFetchSize());
            System.out.println("mfs " + stmt.getMaxFieldSize());
            System.out.println("mr " + stmt.getMaxRows());
            System.out.println("qt " + stmt.getQueryTimeout());
            System.out.println("rsc " + stmt.getResultSetConcurrency());
            System.out.println("rsh " + stmt.getResultSetHoldability());
            System.out.println("rst " + stmt.getResultSetType());
            System.out.println("parsed " + parsedSqlStmt);
            ResultSet results = stmt.executeQuery(parsedSqlStmt);
            while (results.next()) {
            }
            ResultSet rrs = stmt.executeQuery(parsedSqlStmt);
            int ii = 0;
            while (rrs.next()) {
                ++ii;
            }
            System.out.println(ii);
            stmt.close();
            stmt = null;
            conn.close();
        }
        catch (SQLException se) {
            System.out.println(se.getErrorCode());
            System.out.println(se.toString());
            System.out.println(se.getCause());
            System.out.println(se.toString().indexOf(" cancelled at the us"));
            System.out.println("rows " + i);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String readFileAsString(String filePath) throws IOException {
        StringBuffer fileData = new StringBuffer(1000);
        BufferedReader reader = new BufferedReader(new FileReader(filePath));
        char[] buf = new char[1024];
        int numRead = 0;
        while ((numRead = reader.read(buf)) != -1) {
            String readData = String.valueOf(buf, 0, numRead);
            fileData.append(readData);
            buf = new char[1024];
        }
        reader.close();
        return fileData.toString();
    }
}

