/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.roe.wfau.results;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.mar.ACSVWriter;
import net.mar.FormatRS;
import uk.ac.roe.wfau.results.ResultsFileWriter;

public class ResultsCSVWriter
extends ResultsFileWriter {
    FormatRS frs;
    PrintWriter CSVWriter = null;
    OutputStream CSVOutputStream = null;
    int noCols;
    String[] strArray;
    boolean doRADec = false;
    String[] raNames = null;
    String[] decNames = null;
    String[] comments = null;

    public void addComments(String[] comm) {
        this.comments = comm;
    }

    public ResultsCSVWriter(String baseDir, String subDir, String fileStem, int compressionType, String query, String database, ResultSetMetaData rsmd) {
        super(baseDir, subDir, fileStem, compressionType, query, database, rsmd);
    }

    public void setColsRADec(boolean doRADec, String[] raNames, String[] decNames) {
        this.doRADec = doRADec;
        this.raNames = raNames;
        this.decNames = decNames;
    }

    public String init() throws SQLException, Exception {
        this.frs = new FormatRS(this.doRADec, this.raNames, this.decNames);
        switch (this.compressionType) {
            case 0: {
                this.savedFilename = String.valueOf(this.fileStem) + ".csv";
                this.fileDescr = "CSV ASCII";
                try {
                    this.CSVOutputStream = new BufferedOutputStream(new FileOutputStream(String.valueOf(this.baseDir) + this.subDir + this.savedFilename), 524288);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.CSVOutputStream = null;
                }
                break;
            }
            case 1: {
                this.savedFilename = String.valueOf(this.fileStem) + ".zip";
                this.fileDescr = "zipped CSV ASCII";
                try {
                    this.CSVOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(String.valueOf(this.baseDir) + this.subDir + this.savedFilename), 524288));
                    ((ZipOutputStream)this.CSVOutputStream).setLevel(9);
                    ((ZipOutputStream)this.CSVOutputStream).putNextEntry(new ZipEntry(String.valueOf(this.fileStem) + ".csv"));
                }
                catch (Exception e) {
                    this.CSVOutputStream = null;
                    e.printStackTrace();
                }
                break;
            }
            case 2: {
                this.savedFilename = String.valueOf(this.fileStem) + ".csv.gz";
                this.fileDescr = "gzipped CSV ASCII";
                try {
                    this.CSVOutputStream = new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(String.valueOf(this.baseDir) + this.subDir + this.savedFilename), 524288));
                    break;
                }
                catch (Exception e) {
                    this.CSVOutputStream = null;
                    e.printStackTrace();
                }
            }
        }
        if (this.CSVOutputStream != null) {
            try {
                this.CSVWriter = new PrintWriter(this.CSVOutputStream, true);
            }
            catch (Exception e) {
                this.CSVWriter = null;
                e.printStackTrace();
            }
        }
        this.noCols = this.rsmd.getColumnCount();
        this.strArray = new String[this.noCols];
        this.frs.setRSMD(this.rsmd);
        this.CSVWriter.print(ACSVWriter.printHeader((ResultSetMetaData)this.rsmd, (String)this.query, (String)this.database, (String[])this.comments));
        return this.savedFilename;
    }

    public void writeRow(ResultSet rs) {
        this.strArray = this.frs.setRS(rs);
        int column = 1;
        while (column <= this.noCols) {
            if (this.CSVWriter != null) {
                if (column == this.noCols) {
                    this.CSVWriter.println(this.strArray[column - 1]);
                } else {
                    this.CSVWriter.print(String.valueOf(this.strArray[column - 1]) + ",");
                }
            }
            ++column;
        }
    }

    public void finishUp() throws IOException {
        if (this.CSVWriter != null) {
            this.CSVWriter.flush();
            if (this.compressionType == 1) {
                ((ZipOutputStream)this.CSVOutputStream).closeEntry();
            }
            this.CSVWriter.close();
        }
        this.CSVWriter = null;
        this.CSVOutputStream = null;
    }

    public String[] getStrArray() {
        return this.strArray;
    }
}

