/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.roe.wfau.results;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.zip.GZIPOutputStream;
import net.mar.FITSWriter;
import net.mar.FormatRS;
import uk.ac.roe.wfau.results.ResultsFileWriter;

public class ResultsFITSWriter
extends ResultsFileWriter {
    FITSWriter fw = null;
    FormatRS frs = new FormatRS();
    String[] comments = null;
    PrintWriter CSVWriter = null;
    OutputStream CSVOutputStream = null;
    int noCols;
    String[] strArray;

    public ResultsFITSWriter(String baseDir, String subDir, String fileStem, int compressionType, String query, String database, ResultSetMetaData rsmd) {
        super(baseDir, subDir, fileStem, compressionType, query, database, rsmd);
    }

    public String init() throws SQLException, Exception {
        try {
            this.fw = new FITSWriter(this.query, this.database, this.archiveID);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        if (this.comments != null) {
            this.fw.setComments(this.comments);
        }
        this.savedFilename = this.compressionType == 2 ? String.valueOf(this.fileStem) + ".fits.gz" : String.valueOf(this.fileStem) + ".fits";
        File FITSFile = new File(String.valueOf(this.baseDir) + this.subDir + this.savedFilename);
        if (FITSFile.exists()) {
            FITSFile.delete();
        }
        this.fw.setFileName(String.valueOf(this.baseDir) + this.subDir + this.fileStem + ".fits");
        this.fw.setRSMD(this.rsmd);
        return this.savedFilename;
    }

    public void addComments(String[] comm) {
        this.comments = comm;
    }

    public void writeRow(ResultSet rs) {
        this.fw.setRS(rs);
    }

    public void finishUp() throws IOException {
        this.fw.close();
        if (this.compressionType == 2) {
            try {
                int len;
                String outFilename = String.valueOf(this.baseDir) + this.subDir + this.fileStem + ".fits.gz";
                GZIPOutputStream out = new GZIPOutputStream(new FileOutputStream(outFilename));
                String inFilename = String.valueOf(this.baseDir) + this.subDir + this.fileStem + ".fits";
                FileInputStream in = new FileInputStream(inFilename);
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                in.close();
                out.finish();
                out.close();
                this.fileDescr = "gzipped FITS";
            }
            catch (IOException iOException) {}
        } else {
            this.fileDescr = "FITS";
        }
    }

    public String[] getStrArray() {
        return this.strArray;
    }
}

