/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.roe.wfau.results;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.mar.ParseVOT;
import uk.ac.roe.wfau.results.ResultsFileWriter;

public class ResultsVOTWriter
extends ResultsFileWriter {
    ParseVOT pVOT = null;
    String[] votArray;
    PrintWriter CSVWriter = null;
    OutputStream CSVOutputStream = null;
    int noCols;

    public ResultsVOTWriter(String baseDir, String subDir, String fileStem, int compressionType, String query, String database, ResultSetMetaData rsmd) {
        super(baseDir, subDir, fileStem, compressionType, query, database, rsmd);
    }

    public String init() throws Exception, SQLException {
        this.pVOT = new ParseVOT(this.query, this.database);
        this.pVOT.setRSMD(this.rsmd);
        switch (this.compressionType) {
            case 0: {
                this.savedFilename = String.valueOf(this.fileStem) + ".xml";
                this.fileDescr = "VOTable ASCIII";
                try {
                    this.CSVOutputStream = new BufferedOutputStream(new FileOutputStream(String.valueOf(this.baseDir) + this.subDir + this.savedFilename), 524288);
                }
                catch (Exception e) {
                    this.CSVOutputStream = null;
                }
                break;
            }
            case 1: {
                this.savedFilename = String.valueOf(this.fileStem) + ".zip";
                this.fileDescr = "zipped VOTable ASCII";
                try {
                    this.CSVOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(String.valueOf(this.baseDir) + this.subDir + this.savedFilename), 524288));
                    ((ZipOutputStream)this.CSVOutputStream).setLevel(9);
                    ((ZipOutputStream)this.CSVOutputStream).putNextEntry(new ZipEntry(String.valueOf(this.fileStem) + ".xml"));
                }
                catch (Exception e) {
                    this.CSVOutputStream = null;
                }
                break;
            }
            case 2: {
                this.savedFilename = String.valueOf(this.fileStem) + ".xml.gz";
                this.fileDescr = "gzipped VOTable ASCII";
                try {
                    this.CSVOutputStream = new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(String.valueOf(this.baseDir) + this.subDir + this.savedFilename), 524288));
                    break;
                }
                catch (Exception e) {
                    this.CSVOutputStream = null;
                }
            }
        }
        if (this.CSVOutputStream != null) {
            try {
                this.CSVWriter = new PrintWriter(this.CSVOutputStream, true);
            }
            catch (Exception e) {
                this.CSVWriter = null;
            }
        }
        this.CSVWriter.println(this.pVOT.getVOTHeader(this.fileStem));
        this.CSVWriter.println(this.pVOT.setRSMD(this.rsmd));
        this.noCols = this.rsmd.getColumnCount();
        this.votArray = new String[this.noCols];
        return this.savedFilename;
    }

    public void writeRow(ResultSet rs) {
        this.votArray = this.pVOT.setRS(rs);
        int column = 1;
        while (column <= this.noCols) {
            if (this.CSVWriter != null) {
                if (column == 1) {
                    this.CSVWriter.print("<TR>");
                }
                if (this.votArray[column - 1] != null) {
                    this.CSVWriter.print("<TD>" + this.votArray[column - 1] + "</TD>");
                } else {
                    this.CSVWriter.print("<TD></TD>");
                }
                if (column == this.noCols) {
                    this.CSVWriter.println("</TR>");
                }
            }
            ++column;
        }
    }

    public void finishUp() throws IOException {
        if (this.CSVWriter != null) {
            this.CSVWriter.print(this.pVOT.getFooter());
            this.CSVWriter.flush();
            if (this.compressionType == 1) {
                ((ZipOutputStream)this.CSVOutputStream).closeEntry();
            }
            this.CSVWriter.close();
        }
        this.CSVWriter = null;
        this.CSVOutputStream = null;
    }
}

