/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.roe.wfau;

import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import uk.ac.roe.wfau.VDFSSession;
import uk.ac.roe.wfau.VSASession;
import uk.ac.roe.wfau.WSASchema;
import uk.ac.roe.wfau.WSASession;

public class DatabaseURL {
    private static Logger logger = Logger.getLogger((String)"wsa.simple");

    public static String getDatabaseURL(HttpSession sess) {
        return DatabaseURL.getDatabaseURL(sess, true);
    }

    public static String getDatabaseURL(HttpSession sess, boolean useTDS) {
        return DatabaseURL.getDatabaseURL(sess, useTDS, "amenhotep");
    }

    public static String getDatabaseURL(HttpSession sess, boolean useTDS, String server) {
        boolean loginBoolean = false;
        boolean nonSurveyBoolean = false;
        if (sess.getAttribute("login") != null) {
            loginBoolean = (Boolean)sess.getAttribute("login");
        }
        if (sess.getAttribute("nonsurvey") != null) {
            nonSurveyBoolean = (Boolean)sess.getAttribute("nonsurvey");
        }
        String user = String.valueOf(sess.getAttribute("user"));
        if (loginBoolean && nonSurveyBoolean) {
            return DatabaseURL.getDatabaseURL(server, user, String.valueOf(user) + "ro", String.valueOf(user) + "ro" + "pw", useTDS);
        }
        if (loginBoolean && !nonSurveyBoolean) {
            return DatabaseURL.getDatabaseURL(server, WSASchema.LATESTUKIDSSDATABASE, "wsaro", "wsaropw", useTDS);
        }
        return DatabaseURL.getDatabaseURL(server, WSASchema.LATESTWORLDDATABASE, "worldwsaro", "worldwsaropw", useTDS);
    }

    public static String getDatabaseURLWSA(boolean login, String server, String databaseName, boolean useTDS) {
        String user = "worldwsaro";
        if (login) {
            user = "wsaro";
        }
        String passwd = String.valueOf(user) + "pw";
        return DatabaseURL.getDatabaseURL(server, databaseName, user, passwd, useTDS);
    }

    public static String getDatabaseURL(HttpSession sess, boolean useTDS, String server, String LoggedInDatabaseName, String WorldDatabaseName) {
        boolean loginBoolean = false;
        boolean nonSurveyBoolean = false;
        logger.info((Object)("DBURL " + WSASession.getCommunity(sess) + " " + server));
        if (WSASession.getCommunity(sess).equalsIgnoreCase("preRelease")) {
            server = "ahmose";
            LoggedInDatabaseName = WSASchema.PRERELEASEDATABASE;
        }
        if (sess.getAttribute("login") != null) {
            loginBoolean = (Boolean)sess.getAttribute("login");
            logger.info((Object)("DBURL loginboolean " + loginBoolean));
        }
        if (sess.getAttribute("nonsurvey") != null) {
            nonSurveyBoolean = (Boolean)sess.getAttribute("nonsurvey");
        }
        String user = String.valueOf(sess.getAttribute("user"));
        if (loginBoolean && nonSurveyBoolean) {
            return DatabaseURL.getDatabaseURL(server, LoggedInDatabaseName, String.valueOf(user) + "ro", String.valueOf(user) + "ro" + "pw", useTDS);
        }
        if (loginBoolean && !nonSurveyBoolean) {
            return DatabaseURL.getDatabaseURL(server, LoggedInDatabaseName, "wsaro", "wsaropw", useTDS);
        }
        return DatabaseURL.getDatabaseURL(server, WorldDatabaseName, "worldwsaro", "worldwsaropw", useTDS);
    }

    public static String getDatabaseURL(String server, String database, HttpSession sess, String archive, boolean useTDS) {
        String dbUser = null;
        dbUser = VDFSSession.getDBUser(sess, archive);
        if (dbUser.equals("uhsro") && !database.toLowerCase().contains("uhs")) {
            dbUser = "worldwsaro";
        }
        String dbPasswd = String.valueOf(dbUser) + "pw";
        if (!WSASession.getCommunity(sess).equalsIgnoreCase("prerelease") && database.equalsIgnoreCase("WSA") && VDFSSession.getLoginBoolean(sess, archive)) {
            dbUser = "wsaro";
            dbPasswd = "wsaropw";
            database = "WFCAMPROPRIETY";
        }
        if (!VSASession.getCommunity(sess).equalsIgnoreCase("prerelease") && database.equalsIgnoreCase("VISTAPROPRIETY") && VDFSSession.getLoginBoolean(sess, archive)) {
            dbUser = "wsaro";
            dbPasswd = "wsaropw";
            database = "VISTAPROPRIETY";
        }
        return DatabaseURL.getDatabaseURL(server, database, dbUser, dbPasswd, useTDS);
    }

    public static String getDatabaseURL(String server, String database, String user, String passwd, boolean useTDS) {
        String port = "1433";
        if (database.toLowerCase().contains("legacy")) {
            port = "8443";
        }
        String durl = useTDS ? "jdbc:jtds:sqlserver://" + server + ":" + port + "/" + database + ";user=" + user + ";password=" + passwd : "jdbc:microsoft:sqlserver://" + server + ":" + port + ";databaseName=" + database + ";user=" + user + ";password=" + passwd;
        return durl;
    }

    public static String getDatabaseNameFromURL(String url, boolean useTDS) {
        if (useTDS) {
            String startS = ":1433";
            if (url.toLowerCase().contains("legacy")) {
                startS = ":8443";
            }
            int startSL = startS.length() + 1;
            int startI = url.indexOf(startS);
            int endI = url.indexOf(";user=", startI + startSL);
            if (startI > 0 && endI >= startI) {
                return url.substring(startI + startSL, endI);
            }
            return "";
        }
        String startS = "DATABASENAME=";
        int startSL = startS.length();
        int startI = url.indexOf(startS);
        int endI = url.indexOf(";", startI + startSL);
        if (startI > 0 && endI >= startI) {
            return url.substring(startI + startSL, endI);
        }
        return "";
    }
}

