/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.roe.wfau;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import net.mar.SLALIB;

public class EQ2Survey {
    static final double surveyCenterRa = 185.0;
    static final double surveyCenterDec = 32.5;
    static final double deg2Rad = Math.PI / 180;
    static final double rad2Deg = 57.29577951308232;

    public static void main(String[] args) {
        try {
            String survey = "dxs";
            String outFile = "u:/" + survey + "Coverage.lis";
            BufferedWriter out = new BufferedWriter(new FileWriter(outFile));
            System.out.println("here");
            double[] cGCSRA = new double[]{56.75, 50.5, 130.0, 266.5, 67.5, 82.25, 242.5, 56.25, 66.75, 186.25};
            double[] cGCSDec = new double[]{24.116666667, 48.6166667, 19.666667, 5.7166667, 25.0, -2.6, -23.0, 32.283333, 15.8666667, 26.1};
            double[] cGCSR = new double[]{5.0, 4.0, 3.0, 0.5, 11.0, 10.0, 7.0, 2.0, 9.64, 5.0};
            double[] cDXSRA = new double[]{36.25, 164.25, 242.5, 334.25};
            double[] cDXSDec = new double[]{-4.5, 57.6666667, 54.0, 0.3333333};
            double[] cDXSSize = new double[]{2.958, 2.958, 2.958, 2.958};
            double[] cUDSRA = new double[]{34.5};
            double[] cUDSDec = new double[]{-5.0};
            double[] cUDSSize = new double[]{0.9};
            double sRA = 0.0;
            double eRA = 360.0;
            double sDec = -45.0;
            double eDec = 65.0;
            double decStep = 0.25;
            if (survey.equals("dxs")) {
                decStep = 0.05;
            }
            if (survey.equals("uds")) {
                decStep = 0.01;
                sRA = 30.0;
                eRA = 40.0;
                sDec = -7.0;
                eDec = 0.0;
            }
            if (survey.equals("gcs")) {
                decStep = 0.25;
            }
            System.out.println("here");
            double d = sDec;
            while (d <= eDec) {
                double raStep = decStep / Math.cos(d * (Math.PI / 180));
                double r = sRA;
                while (r <= eRA) {
                    int i;
                    double[] tp;
                    if (survey.equals("las")) {
                        tp = EQ2Survey.getEtaLambda(r, d);
                        if (tp[0] > -60.0 && tp[0] < 53.0 && tp[1] > -36.25 && tp[1] < -16.25) {
                            out.write(String.valueOf(r) + " " + d + "\n");
                        }
                        if (tp[0] > -60.0 && tp[0] < 53.0 && tp[1] > 6.25 && tp[1] < 26.25) {
                            out.write(String.valueOf(r) + " " + d + "\n");
                        }
                        if ((r > 0.0 && r < 60.0 || r < 360.0 && r > 335.0) && Math.abs(d) < 1.25) {
                            out.write(String.valueOf(r) + " " + d + "\n");
                        }
                    }
                    if (survey.equals("gps")) {
                        tp = SLALIB.EQGAL((double)(r * (Math.PI / 180)), (double)(d * (Math.PI / 180)));
                        tp[0] = tp[0] * 57.29577951308232;
                        tp[1] = tp[1] * 57.29577951308232;
                        if (Math.abs(tp[1]) <= 5.0 && (tp[0] >= 15.0 && tp[0] <= 107.0 || tp[0] >= 142.0 && tp[0] <= 230.0)) {
                            out.write(String.valueOf(r) + " " + d + " " + tp[0] + " " + tp[1] + "\n");
                        }
                        if (Math.abs(tp[1]) <= 2.0 && (tp[0] > 358.0 && tp[0] <= 360.0 || tp[0] >= 0.0 && tp[0] <= 15.5)) {
                            out.write(String.valueOf(r) + " " + d + " " + tp[0] + " " + tp[1] + "\n");
                        }
                        if (tp[1] <= 5.0 && tp[1] >= 0.0 && Math.abs(tp[0]) < 1.0) {
                            out.write(String.valueOf(r) + " " + d + " " + tp[0] + " " + tp[1] + "\n");
                        }
                        if (SLALIB.DSEP((double)1.1780972450961724, (double)0.4363323129985824, (double)(r * (Math.PI / 180)), (double)(d * (Math.PI / 180))) < 0.170518667919846) {
                            out.write(String.valueOf(r) + " " + d + " " + tp[0] + " " + tp[1] + "\n");
                        }
                    }
                    if (survey.equals("gcs")) {
                        i = 0;
                        while (i < cGCSRA.length) {
                            if (SLALIB.DSEP((double)(cGCSRA[i] * (Math.PI / 180)), (double)(cGCSDec[i] * (Math.PI / 180)), (double)(r * (Math.PI / 180)), (double)(d * (Math.PI / 180))) < cGCSR[i] * (Math.PI / 180)) {
                                out.write(String.valueOf(r) + " " + d + "\n");
                            }
                            ++i;
                        }
                    }
                    if (survey.equals("dxs")) {
                        i = 0;
                        while (i < cDXSRA.length) {
                            tp = SLALIB.DS2TP((double)(r * (Math.PI / 180)), (double)(d * (Math.PI / 180)), (double)(cDXSRA[i] * (Math.PI / 180)), (double)(cDXSDec[i] * (Math.PI / 180)));
                            if (Math.abs(d - cDXSDec[i]) <= cDXSSize[i] / 2.0 && Math.abs(r - cDXSRA[i]) <= cDXSSize[i] / 2.0) {
                                out.write(String.valueOf(r) + " " + d + ",1\n");
                            }
                            ++i;
                        }
                    }
                    if (survey.equals("uds")) {
                        i = 0;
                        while (i < cUDSRA.length) {
                            tp = SLALIB.DS2TP((double)(r * (Math.PI / 180)), (double)(d * (Math.PI / 180)), (double)(cUDSRA[i] * (Math.PI / 180)), (double)(cUDSDec[i] * (Math.PI / 180)));
                            if (Math.abs(d - cUDSDec[i]) <= cUDSSize[i] / 2.0 && Math.abs(r - cUDSRA[i]) <= cUDSSize[i] / 2.0) {
                                out.write(String.valueOf(r) + " " + d + ",1\n");
                            }
                            ++i;
                        }
                    }
                    r += raStep;
                }
                d += decStep;
            }
            out.flush();
            out.close();
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }

    public static double[] getEtaLambda(double ra, double dec) {
        double node = 95.0;
        double etaPole = 0.5672320068981571;
        double x1 = Math.cos((ra *= Math.PI / 180) - (node *= Math.PI / 180)) * Math.cos(dec *= Math.PI / 180);
        double y1 = Math.sin(ra - node) * Math.cos(dec);
        double z1 = Math.sin(dec);
        double lambda = -Math.asin(x1);
        double eta = Math.atan2(z1, y1) - etaPole;
        double[] tp = EQ2Survey.atbound2(lambda *= 57.29577951308232, eta *= 57.29577951308232);
        tp[1] = EQ2Survey.atbound(tp[1], -180.0, 180.0);
        if (tp[1] > 57.5) {
            tp[1] = tp[1] - 180.0;
            tp[0] = 180.0 - tp[0];
        }
        tp[0] = EQ2Survey.atbound(tp[0], -180.0, 180.0);
        return tp;
    }

    public static double atbound(double angle, double min, double max) {
        while (angle <= min) {
            angle += 360.0;
        }
        while (angle >= max) {
            angle -= 360.0;
        }
        return angle;
    }

    public static double[] atbound2(double theta, double phi) {
        if (Math.abs(theta = EQ2Survey.atbound(theta, -180.0, 180.0)) > 90.0) {
            theta = 180.0 - theta;
            phi += 180.0;
        }
        theta = EQ2Survey.atbound(theta, -180.0, 180.0);
        phi = EQ2Survey.atbound(phi, 0.0, 360.0);
        if (Math.abs(theta) == 90.0) {
            phi = 0.0;
        }
        double[] tp = new double[]{theta, phi};
        return tp;
    }
}

