/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.roe.wfau;

import nom.tam.fits.Fits;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.ImageHDU;
import nom.tam.util.Cursor;
import uk.ac.starlink.ast.AstObject;
import uk.ac.starlink.ast.FitsChan;
import uk.ac.starlink.ast.FrameSet;

public class FitsWcs {
    String FitsFile;
    double raDeg;
    double decDeg;
    AstObject ao;
    int ext;
    double nx = 0.0;
    double ny = 0.0;
    HeaderCard hc;
    FitsChan fc;

    public void setFits(FitsChan fchan) {
        this.ao = null;
        this.fc = fchan;
        try {
            this.fc.clear("Card");
            this.hc = new HeaderCard(this.fc.findFits("NAXIS1", true));
            this.nx = Double.valueOf(this.hc.getValue());
            this.fc.clear("Card");
            this.hc = new HeaderCard(this.fc.findFits("NAXIS2", true));
            this.ny = Double.valueOf(this.hc.getValue());
            this.fc.clear("Card");
            this.ao = this.fc.read();
        }
        catch (Exception e) {
            this.ao = null;
            this.nx = 0.0;
            this.ny = 0.0;
        }
    }

    public AstObject setFits(String filepath, int extnum) {
        this.ao = null;
        System.out.println("taree");
        this.FitsFile = filepath;
        this.ext = extnum;
        String cards = "";
        try {
            Fits f = new Fits(this.FitsFile);
            ImageHDU h = (ImageHDU)f.getHDU(this.ext);
            Header head = h.getHeader();
            System.out.println(head.getIntValue("NAXIS1"));
            int noc = head.getNumberOfCards();
            System.out.println(noc);
            FitsChan fc = new FitsChan();
            Cursor c = head.iterator();
            while (c.hasNext()) {
                HeaderCard card = (HeaderCard)c.next();
                fc.putFits(card.toString(), true);
                cards = String.valueOf(cards) + card.toString();
            }
            fc.clear("Card");
            HeaderCard hc = new HeaderCard(fc.findFits("NAXIS1", true));
            this.nx = Double.valueOf(hc.getValue());
            fc.clear("Card");
            hc = new HeaderCard(fc.findFits("NAXIS2", true));
            this.ny = Double.valueOf(hc.getValue());
            fc.clear("Card");
            this.ao = fc.read();
        }
        catch (Exception e) {
            this.ao = null;
            this.nx = 0.0;
            this.ny = 0.0;
        }
        return this.ao;
    }

    public double getNX() {
        return this.nx;
    }

    public double getNY() {
        return this.ny;
    }

    public double[] runGetXYSize() {
        return this.getXYSize(Math.round(this.nx / 2.0), Math.round(this.ny / 2.0));
    }

    public double[] runGetXYSize(double xCen, double yCen) {
        return this.getXYSize(xCen, yCen);
    }

    public double[] getXYSize(double centreX, double centreY) {
        double xSize = 0.0;
        double ySize = 0.0;
        double[] size = new double[]{0.0, 0.0};
        try {
            if (this.nx > 0.0 & this.ny > 0.0) {
                double[] xPixCorners = new double[4];
                double[] yPixCorners = new double[4];
                xPixCorners[0] = centreX;
                yPixCorners[0] = centreY;
                xPixCorners[1] = centreX;
                yPixCorners[1] = 1.0 + centreY;
                xPixCorners[2] = 1.0 + centreX;
                yPixCorners[2] = centreY;
                xPixCorners[3] = 1.0 + centreX;
                yPixCorners[3] = 1.0 + centreY;
                FrameSet wcsmap = (FrameSet)this.ao;
                double[][] result = wcsmap.tran2(4, xPixCorners, yPixCorners, true);
                double[] xSkyCorner = result[0];
                double[] ySkyCorner = result[1];
                double[] skyCorner0 = new double[]{xSkyCorner[0], ySkyCorner[0]};
                double[] skyCorner1 = new double[]{xSkyCorner[1], ySkyCorner[1]};
                double[] skyCorner2 = new double[]{xSkyCorner[2], ySkyCorner[2]};
                double[] skyCorner3 = new double[]{xSkyCorner[3], ySkyCorner[3]};
                size[0] = wcsmap.getFrame(FrameSet.AST__CURRENT).distance(skyCorner0, skyCorner2);
                size[1] = wcsmap.getFrame(FrameSet.AST__CURRENT).distance(skyCorner0, skyCorner1);
            }
        }
        catch (Exception e) {
            size[0] = 0.0;
            size[1] = 0.0;
        }
        return size;
    }

    public double[] getXPixYPix(double ra, double dec) {
        double[] xypix = new double[]{0.0, 0.0};
        try {
            FrameSet wcs = (FrameSet)this.ao;
            double[] RAin = new double[]{ra * Math.PI / 180.0};
            double[] Decin = new double[]{dec * Math.PI / 180.0};
            double[][] XYout = wcs.tran2(1, RAin, Decin, false);
            xypix[0] = XYout[0][0];
            xypix[1] = XYout[1][0];
        }
        catch (Exception e) {
            xypix[0] = 0.0;
            xypix[1] = 0.0;
        }
        return xypix;
    }

    public double[] getRADec(double xPix, double yPix) {
        double[] longLat = new double[]{0.0, 0.0};
        try {
            FrameSet wcs = (FrameSet)this.ao;
            double[] Xin = new double[]{xPix};
            double[] Yin = new double[]{yPix};
            double[][] longLatOut = wcs.tran2(1, Xin, Yin, true);
            longLat[0] = longLatOut[0][0] * 180.0 / Math.PI;
            if (longLat[0] < 0.0) {
                longLat[0] = 360.0 + longLat[0];
            }
            longLat[1] = longLatOut[1][0] * 180.0 / Math.PI;
        }
        catch (Exception e) {
            longLat[0] = 0.0;
            longLat[1] = 0.0;
        }
        return longLat;
    }

    public void done() {
        this.ao.annul();
        this.ao = null;
    }
}

