/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.roe.wfau;

import com.oreilly.servlet.MultipartRequest;
import java.io.IOException;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspWriter;
import uk.ac.roe.wfau.LegacySchema;
import uk.ac.roe.wfau.LegacySession;
import uk.ac.roe.wfau.WSAJsp;
import uk.ac.roe.wfau.WSASchema;
import uk.ac.roe.wfau.WSASession;

public class LegacyJsp
extends WSAJsp {
    public static final String selected = "selected";
    public static final String checked = "checked";
    public static final String[] MONTHSOFYEAR = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    public static final String[] LISTDRIVENAPERARRAY = new String[]{"aperMag3", "aperMag4", "aperMag6"};
    public static final String[] LISTDRIVENFILTERARRAY = new String[]{"Y", "J_1", "H", "K"};
    public static final String LISTDRIVENBASESELECT = "sourceID, framesetID, RA, Dec";

    public static String getOnChange(String[] params) {
        StringBuffer extra = new StringBuffer("");
        if (params != null) {
            int i = 0;
            while (i < params.length) {
                extra.append("+'&" + params[i] + "='+this.form." + params[i] + ".value");
                ++i;
            }
        }
        return extra.toString();
    }

    public static String getParamValue(HttpServletRequest request, String param) {
        return LegacyJsp.getParamValue(request, param, "");
    }

    public static String getQueryString(HttpServletRequest request, String omit) {
        if (request.getQueryString() == null) {
            return "";
        }
        if (omit != null) {
            StringBuffer sb = new StringBuffer(request.getQueryString());
            int strt = sb.indexOf(String.valueOf(omit) + "=");
            int end = sb.indexOf("&", strt);
            if (strt >= 0 && end > strt) {
                return sb.delete(strt, end).toString();
            }
            if (strt >= 0 && end <= strt) {
                return sb.delete(strt, sb.length()).toString();
            }
            return request.getQueryString();
        }
        return request.getQueryString();
    }

    public static String getParamValue(HttpServletRequest request, String param, String none) {
        if (request.getParameter(param) != null) {
            return request.getParameter(URLEncoder.encode(param));
        }
        return none;
    }

    public static String getParamChecked(HttpServletRequest request, String param, String value) {
        return LegacyJsp.getParamChecked(request, param, value, false);
    }

    public static String getParamChecked(HttpServletRequest request, String param, String value, boolean isDefault) {
        if (request.getParameter(param) != null) {
            if (request.getParameter(param).equalsIgnoreCase(value)) {
                return checked;
            }
            return "";
        }
        if (isDefault) {
            return checked;
        }
        return "";
    }

    public static String getParamSelected(HttpServletRequest request, String param, String value, boolean defaultSel) {
        if (request.getParameter(param) != null) {
            if (request.getParameter(param).equalsIgnoreCase(value)) {
                return selected;
            }
            if (defaultSel) {
                return selected;
            }
            return "";
        }
        if (defaultSel) {
            return selected;
        }
        return "";
    }

    public static String getParamSelected(HttpServletRequest request, String param, String value) {
        return LegacyJsp.getParamSelected(request, param, value, false);
    }

    public static void printDBList(JspWriter out, HttpSession session, int progID, HttpServletRequest request) {
        LegacyJsp.printDBList(out, session, progID, request, "");
    }

    public static String printDBList(JspWriter out, HttpSession session, int progID, HttpServletRequest request, String paramURL) {
        return LegacyJsp.printDBList(out, session, progID, request, paramURL, false);
    }

    public static String printDBList(JspWriter out, HttpSession session, int progID, HttpServletRequest request, String paramURL, boolean doRollingDB) {
        return LegacyJsp.printDBList(out, session, progID, request, paramURL, doRollingDB, false);
    }

    public static String printDBList(JspWriter out, HttpSession session, int progID, HttpServletRequest request, String paramURL, boolean doRollingDB, String[] params, int strtP) {
        return LegacyJsp.printDBList(out, session, progID, request, paramURL, doRollingDB, params, strtP, true);
    }

    public static String printDBList(JspWriter out, HttpSession session, int progID, HttpServletRequest request, String paramURL, boolean doRollingDB, String[] params, int strtP, boolean includeExtraDB) {
        return LegacyJsp.printDBList(out, session, progID, request, paramURL, doRollingDB, params, strtP, includeExtraDB, false);
    }

    public static String printDBList(JspWriter out, HttpSession session, int progID, HttpServletRequest request, String paramURL, boolean doRollingDB, String[] params, int strtP, boolean includeExtraDB, boolean includeMoreDB) {
        return LegacyJsp.printDBList(out, session, progID, request, paramURL, doRollingDB, params, strtP, includeExtraDB, includeMoreDB, -1);
    }

    public static String printDBList(JspWriter out, HttpSession session, int progID, HttpServletRequest request, String paramURL, boolean doRollingDB, String[] params, int strtP, boolean includeExtraDB, boolean includeMoreDB, int minRelease) {
        int i;
        String[] DBs = LegacySession.getDB(session, progID, doRollingDB, includeExtraDB, includeMoreDB);
        String[] equivDBs = null;
        if (DBs != null && DBs.length >= 1) {
            equivDBs = new String[DBs.length];
            int d = 0;
            while (d < DBs.length) {
                equivDBs[d] = "";
                ++d;
            }
            String[] wDBs = LegacySchema.getWorldDBs(progID);
            String[] eDBs = LegacySchema.getEquivWorldDBs(progID);
            if (wDBs != null && eDBs != null) {
                int d2 = 0;
                while (d2 < DBs.length) {
                    int w = 0;
                    while (w < wDBs.length) {
                        if (DBs[d2].equalsIgnoreCase(wDBs[w]) && !eDBs[w].equals(".")) {
                            equivDBs[d2] = "(" + eDBs[w] + ")";
                        }
                        ++w;
                    }
                    ++d2;
                }
            }
        }
        String thisDB = null;
        boolean LegacyShown = false;
        StringBuffer extra = new StringBuffer("");
        if (params != null) {
            i = strtP;
            while (i < params.length) {
                extra.append("+'&" + params[i] + "='+this.form." + params[i] + ".value");
                ++i;
            }
        }
        try {
            out.print("<select name=\"database\" ");
            if (paramURL != null) {
                out.print(" onchange=\"location = '" + paramURL + "' + this.options[this.selectedIndex ].value" + extra + ";\"");
            }
            out.print(">");
            if (DBs == null) {
                out.print("<option value=\"none\">Select programme/survey");
            } else if (DBs.length == 0) {
                out.print("<option value=\"none\">No database available");
            } else {
                thisDB = DBs[0];
                if (request.getParameter("database") != null && !request.getParameter("database").equals("")) {
                    thisDB = request.getParameter("database");
                }
                i = 0;
                while (i < DBs.length) {
                    if (WSASchema.getVersionNoOfRelease(DBs[i]) >= minRelease) {
                        out.print("<option value=\"" + DBs[i] + "\"");
                        if (thisDB.equalsIgnoreCase(DBs[i])) {
                            out.print(" selected");
                        }
                        out.print(">" + DBs[i] + " " + equivDBs[i]);
                        if (DBs[i].equalsIgnoreCase("Legacy")) {
                            out.print(" (QC)**");
                            LegacyShown = true;
                        }
                    }
                    ++i;
                }
            }
            out.print("</select>");
            if (LegacyShown) {
                out.print("&nbsp; &nbsp;  <a href=\"http://legacy.roe.ac.uk/theLegacyDatabase.html\">notes on Legacy (QC) database</a>");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return thisDB;
    }

    public static void printDBList(JspWriter out, HttpSession session, MultipartRequest request) {
        LegacyJsp.printDBList(out, session, request, "");
    }

    public static String printDBList(JspWriter out, HttpSession session, MultipartRequest request, String paramURL) {
        return LegacyJsp.printDBList(out, session, request, paramURL, false);
    }

    public static String printDBList(JspWriter out, HttpSession session, MultipartRequest request, String paramURL, boolean doRollingDB) {
        return LegacyJsp.printDBList(out, session, request, paramURL, doRollingDB, false);
    }

    public static String printDBList(JspWriter out, HttpSession session, MultipartRequest request, String paramURL, boolean doRollingDB, String[] params, int strtP) {
        return LegacyJsp.printDBList(out, session, request, paramURL, doRollingDB, params, strtP, true);
    }

    public static String printDBList(JspWriter out, HttpSession session, MultipartRequest request, String paramURL, boolean doRollingDB, String[] params, int strtP, boolean includeExtraDB) {
        int i;
        String[] DBs = WSASession.getDB(session, doRollingDB, includeExtraDB);
        String thisDB = DBs[0];
        StringBuffer extra = new StringBuffer("");
        if (params != null) {
            i = strtP;
            while (i < params.length) {
                extra.append("+'&" + params[i] + "='+this.form." + params[i] + ".value");
                ++i;
            }
        }
        try {
            if (request.getParameter("database") != null) {
                thisDB = request.getParameter("database");
            }
            out.print("<select name=\"database\" ");
            if (paramURL != null) {
                out.print(" onchange=\"location = '" + paramURL + "' + this.options[this.selectedIndex ].value" + extra + ";\"");
            }
            out.print(">");
            i = 0;
            while (i < DBs.length) {
                out.print("<option value=\"" + DBs[i] + "\"");
                if (thisDB.equalsIgnoreCase(DBs[i])) {
                    out.print(" selected");
                }
                out.print(">" + DBs[i]);
                ++i;
            }
            out.print("</select>");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return thisDB;
    }

    public static String printDBList(JspWriter out, HttpSession session, int progID, HttpServletRequest request, String paramURL, boolean doRollingDB, boolean doRADec) {
        String[] DBs = WSASession.getDB(session, doRollingDB);
        String thisDB = DBs[0];
        String extra = "";
        if (doRADec) {
            extra = "+'&ra='+this.form.ra.value+'&dec='+this.form.dec.value";
        }
        try {
            if (request.getParameter("database") != null) {
                thisDB = request.getParameter("database");
            }
            out.print("<select name=\"database\" ");
            if (paramURL != null) {
                out.print(" onchange=\"location = '" + paramURL + "' + this.options[this.selectedIndex ].value" + extra + ";\"");
            }
            out.print(">");
            int i = 0;
            while (i < DBs.length) {
                out.print("<option value=\"" + DBs[i] + "\"");
                if (thisDB.equalsIgnoreCase(DBs[i])) {
                    out.print(" selected");
                }
                out.print(">" + DBs[i]);
                ++i;
            }
            out.print("</select>");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return thisDB;
    }

    public static String printDBList(JspWriter out, HttpSession session, MultipartRequest request, String paramURL, boolean doRollingDB, boolean doRADec) {
        String[] DBs = WSASession.getDB(session, doRollingDB);
        String thisDB = DBs[0];
        String extra = "";
        if (doRADec) {
            extra = "+'&ra='+this.form.ra.value+'&dec='+this.form.dec.value";
        }
        try {
            if (request.getParameter("database") != null) {
                thisDB = request.getParameter("database");
            }
            out.print("<select name=\"database\" ");
            if (paramURL != null) {
                out.print(" onchange=\"location = '" + paramURL + "' + this.options[this.selectedIndex ].value" + extra + ";\"");
            }
            out.print(">");
            int i = 0;
            while (i < DBs.length) {
                out.print("<option value=\"" + DBs[i] + "\"");
                if (thisDB.equalsIgnoreCase(DBs[i])) {
                    out.print(" selected");
                }
                out.print(">" + DBs[i]);
                ++i;
            }
            out.print("</select>");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return thisDB;
    }

    public static String printVSurveyList(JspWriter out, HttpSession session, String database, String paramURL, boolean all) {
        return LegacyJsp.printVSurveyList(out, session, database, paramURL, all, false, null, false);
    }

    public static String printVSurveyList(JspWriter out, HttpSession session, String database, String paramURL, boolean all, boolean topNull, HttpServletRequest request) {
        return LegacyJsp.printVSurveyList(out, session, database, paramURL, all, topNull, request, false);
    }

    public static String printVSurveyList(JspWriter out, HttpSession session, String database, String paramURL, boolean all, boolean topNull, HttpServletRequest request, boolean sourceOnly) {
        return LegacyJsp.printVSurveyList(out, session, database, paramURL, all, topNull, request, sourceOnly, false);
    }

    public static String printVSurveyList(JspWriter out, HttpSession session, String database, String paramURL, boolean all, boolean topNull, HttpServletRequest request, boolean sourceOnly, String[] params, int strtP) {
        return LegacyJsp.printVSurveyList(out, session, database, paramURL, all, topNull, request, sourceOnly, params, strtP, false);
    }

    public static String printVSurveyList(JspWriter out, HttpSession session, String database, String paramURL, boolean all, boolean topNull, HttpServletRequest request, boolean sourceOnly, String[] params, int strtP, boolean standards) {
        return LegacyJsp.printVSurveyList(out, session, database, paramURL, all, topNull, request, sourceOnly, params, strtP, standards, null);
    }

    public static String printVSurveyList(JspWriter out, HttpSession session, String database, String paramURL, boolean all, boolean topNull, HttpServletRequest request, boolean sourceOnly, String[] params, int strtP, boolean standards, int[] progs) {
        String thisProgID = "-9999";
        StringBuffer extra = new StringBuffer("");
        if (params != null) {
            int i = strtP;
            while (i < params.length) {
                extra.append("+'&" + params[i] + "='+this.form." + params[i] + ".value");
                ++i;
            }
        }
        try {
            if (request != null && request.getParameter("programmeID") != null) {
                thisProgID = request.getParameter("programmeID");
            }
            out.print("<select name=\"programmeID\" ");
            if (request != null && !paramURL.equals("")) {
                out.print("onchange=\"location = '" + paramURL + "' + this.options[this.selectedIndex ].value" + extra + ";\"");
            }
            out.print(">");
            if (topNull && !database.equalsIgnoreCase("Transit") && !database.equalsIgnoreCase("WFCAMCAL08B")) {
                out.println("<option value=\"none\" >Choose survey from list");
            }
            if (all && LegacySession.getLoginBoolean(session) && !database.equalsIgnoreCase("Transit") && !database.equalsIgnoreCase("WFCAMCAL08B")) {
                out.println("<option value=\"all\" ");
                if (thisProgID.equals("all")) {
                    out.println(selected);
                }
                out.println(">All Legacy surveys");
            }
            if (progs == null) {
                progs = database != null && database.equalsIgnoreCase("Transit") ? new int[]{106} : (database != null && database.equalsIgnoreCase("WFCAMCAL08B") ? new int[]{200} : LegacySession.getProgs(session));
            }
            boolean show = true;
            String isSelected = "";
            int i = 0;
            while (i < progs.length) {
                isSelected = "";
                show = true;
                try {
                    if (Integer.valueOf(thisProgID) == progs[i]) {
                        isSelected = " selected";
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (show && database != null) {
                    out.println("<option value=\"" + progs[i] + "\"" + isSelected + ">" + LegacySchema.getSurveyName(progs[i]));
                }
                ++i;
            }
            out.print("</select>");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return thisProgID;
    }

    public static String printVSurveyList(JspWriter out, HttpSession session, String database, String paramURL, boolean all, boolean topNull, HttpServletRequest request, boolean sourceOnly, boolean doRADec) {
        String thisProgID = "-9999";
        String extra = "";
        if (doRADec) {
            extra = "+'&ra='+this.form.ra.value+'&dec='+this.form.dec.value";
        }
        try {
            if (request != null && request.getParameter("programmeID") != null) {
                thisProgID = request.getParameter("programmeID");
            }
            out.print("<select name=\"programmeID\" ");
            if (request != null && !paramURL.equals("")) {
                out.print("onchange=\"location = '" + paramURL + "' + this.options[this.selectedIndex ].value" + extra + ";\"");
            }
            out.print(">");
            if (topNull && !database.equalsIgnoreCase("Transit") && !database.equalsIgnoreCase("WFCAMCAL08B")) {
                out.println("<option value=\"null\">choose survey from list");
            }
            if (all && LegacySession.getLoginBoolean(session) && !database.equalsIgnoreCase("Transit") && !database.equalsIgnoreCase("WFCAMCAL08B")) {
                out.println("<option value=\"all\" selected>All UKIDSS surveys");
            }
            int[] progs = database != null && database.equalsIgnoreCase("Transit") ? new int[]{106} : (database != null && database.equalsIgnoreCase("WFCAMCAL08B") ? new int[]{200} : LegacySession.getProgs(session));
            boolean show = true;
            int i = 0;
            while (i < progs.length) {
                String selected = "";
                show = true;
                try {
                    if (Integer.valueOf(thisProgID) == progs[i]) {
                        selected = " selected";
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (sourceOnly && WSASchema.getSourceTableName(progs[i]) == null) {
                    show = false;
                }
                if (show) {
                    if (database != null) {
                        if (WSASchema.isProgInDB(database, progs[i])) {
                            out.print("<option value=\"" + progs[i] + "\"" + selected + ">" + WSASchema.getSurveyName(progs[i]));
                        }
                    } else {
                        out.print("<option value=\"" + progs[i] + "\">" + WSASchema.getSurveyName(progs[i]));
                    }
                }
                ++i;
            }
            out.print("</select>");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return thisProgID;
    }
}

