/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.roe.wfau;

import javax.servlet.http.HttpSession;
import uk.ac.roe.wfau.LegacySchema;
import uk.ac.roe.wfau.WSASchema;

public class LegacySession {
    static final int UKIDSSTESTERCLASS = 0;
    static final int UKIDSSCLASS = 1;
    static final int WORLDCLASS = 2;
    static final int PRERELEASECLASS = 3;
    static final int NONSURVEYCLASS = 4;
    static final int VISTATESTERCLASS = 5;
    static final int LegacyCLASS = 1;
    static final int BETACLASS = 0;

    public static String getDBUser(HttpSession sess) {
        String community = LegacySession.getCommunity(sess);
        if (LegacySession.getLoginBoolean(sess) && !LegacySchema.isProprietary(community) && !community.equalsIgnoreCase("prerelease") && !community.equalsIgnoreCase("world")) {
            return "wsaro";
        }
        if (LegacySession.getLoginBoolean(sess) && community.equalsIgnoreCase("prerelease")) {
            return "wsaro";
        }
        if (LegacySession.getLoginBoolean(sess) && LegacySchema.isProprietary(community)) {
            int iProgID = Integer.parseInt(LegacySession.getProgID(sess));
            if (iProgID > 0 && iProgID < 1000) {
                return String.valueOf(LegacySchema.getShortSurveyName(iProgID).toLowerCase()) + "ro";
            }
            return String.valueOf(LegacySession.getUser(sess).toLowerCase()) + "ro";
        }
        return "worldwsaro";
    }

    public static int getSessionClass(HttpSession sess) {
        String community = LegacySession.getCommunity(sess);
        if (LegacySession.getLoginBoolean(sess)) {
            if (community.toLowerCase().indexOf("beta") >= 0) {
                return 0;
            }
            return 1;
        }
        return 2;
    }

    public static String getProgID(HttpSession sess) {
        if (sess.getAttribute("legacyprogrammeID") != null) {
            return ((String)sess.getAttribute("legacyprogrammeID")).trim();
        }
        return "-999";
    }

    public static String getCommunity(HttpSession sess) {
        if (LegacySession.getLoginBoolean(sess) && sess.getAttribute("legacycommunity") != null) {
            String community = ((String)sess.getAttribute("legacycommunity")).toLowerCase().trim();
            if (community != null) {
                return community;
            }
            return "world";
        }
        return "world";
    }

    public static String getMaskedCommunity(HttpSession sess) {
        if (LegacySession.getLoginBoolean(sess) && sess.getAttribute("legacycommunity") != null) {
            String community = ((String)sess.getAttribute("legacycommunity")).toLowerCase().trim().replaceFirst(LegacySchema.LegacyCOMMUNITYPREFIX.toLowerCase(), "");
            if (community != null) {
                return community;
            }
            return "world";
        }
        return "world";
    }

    public static String[] getNonSurveyDBName(HttpSession sess) {
        String[] nsDBs = null;
        if (sess.getAttribute("legacyreleasedDBs") != null) {
            nsDBs = (String[])sess.getAttribute("legacyreleasedDBs");
        } else if (sess.getAttribute("legacydbName") != null && !((String)sess.getAttribute("legacydbName")).toLowerCase().trim().equalsIgnoreCase("na")) {
            String[] dbName = new String[]{LegacySession.getUser(sess)};
            nsDBs = dbName;
        }
        return nsDBs;
    }

    public static String getUser(HttpSession sess) {
        return LegacySession.getUser(sess, false);
    }

    public static String getUser(HttpSession sess, boolean generic) {
        if (LegacySession.getLoginBoolean(sess)) {
            if (!generic) {
                if (sess.getAttribute("legacyuser") != null) {
                    return ((String)sess.getAttribute("legacyuser")).toLowerCase().trim();
                }
                return "public";
            }
            int iProgID = Integer.parseInt(LegacySession.getProgID(sess));
            if (iProgID > 0 && iProgID < 1000 && LegacySchema.getShortSurveyName(iProgID) != null) {
                return LegacySchema.getShortSurveyName(iProgID);
            }
            return ((String)sess.getAttribute("legacyuser")).toLowerCase().trim();
        }
        return "public";
    }

    public static String[] getDB(HttpSession sess, int progID) {
        return LegacySession.getDB(sess, progID, false);
    }

    public static String[] getDB(HttpSession sess, int progID, boolean doRollingDB) {
        return LegacySession.getDB(sess, progID, doRollingDB, true);
    }

    public static String[] getDB(HttpSession sess, int progID, boolean doRollingDB, boolean includeExtraDB) {
        return LegacySession.getDB(sess, progID, doRollingDB, includeExtraDB, false);
    }

    public static String[] getDB(HttpSession sess, int progID, boolean doRollingDB, boolean includeExtraDB, boolean includeMoreDB) {
        String[] DB;
        int sessClass = LegacySession.getSessionClass(sess);
        System.out.println(sessClass);
        switch (sessClass) {
            case 2: {
                DB = LegacySchema.WORLDLegacyDB;
                break;
            }
            case 1: {
                DB = LegacySchema.LegacyDB;
                break;
            }
            case 0: {
                DB = LegacySchema.BETALegacyDB;
                break;
            }
            case 4: {
                String[] nsdbs = LegacySession.getNonSurveyDBName(sess);
                DB = doRollingDB ? (LegacySession.getNonSurveyDBName(sess) != null ? LegacySchema.getDBsPlusRollingDB(LegacySession.getNonSurveyDBName(sess)) : new String[]{"Legacy_DailySync"}) : (LegacySession.getNonSurveyDBName(sess) != null ? LegacySession.getNonSurveyDBName(sess) : new String[]{"sorry no access"});
                if (!includeExtraDB) break;
                DB = LegacySchema.getDBsPlusExtraDB(DB, LegacySchema.extraDB);
                break;
            }
            case 3: {
                DB = LegacySchema.PRERELEASEDB;
                break;
            }
            default: {
                DB = LegacySchema.getDBs(progID, true);
            }
        }
        return DB;
    }

    public static int[] getProgs(HttpSession sess) {
        int[] progs;
        int sessClass = LegacySession.getSessionClass(sess);
        switch (sessClass) {
            case 2: {
                progs = LegacySchema.LegacyPROGS;
                break;
            }
            case 1: {
                progs = LegacySchema.LegacyPROGS;
                break;
            }
            case 0: {
                progs = LegacySchema.LegacyPROGS;
                break;
            }
            default: {
                progs = LegacySchema.LegacyPROGS;
            }
        }
        return progs;
    }

    public static String getSchemaVersion(HttpSession sess) {
        if (sess.getAttribute("legacyschemaVersion") != null) {
            String schemaVersion = ((String)sess.getAttribute("legacyschemaVersion")).toLowerCase().trim();
            if (schemaVersion != null) {
                return schemaVersion;
            }
            return "null";
        }
        return "null";
    }

    public static boolean getProprietaryBoolean(HttpSession sess) {
        if (sess.getAttribute("legacyProprietary") != null) {
            return (Boolean)sess.getAttribute("legacyProprietary");
        }
        return false;
    }

    public static boolean getSourceBoolean(HttpSession sess) {
        if (sess.getAttribute("legacysource") != null) {
            return (Boolean)sess.getAttribute("legacysource");
        }
        return false;
    }

    public static int[] getReqFilters(HttpSession sess) {
        try {
            return (int[])sess.getAttribute("legacyreqFilters");
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean getLoginBoolean(HttpSession sess) {
        if (sess.getAttribute("legacylogin") != null) {
            try {
                return (Boolean)sess.getAttribute("legacylogin");
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public static String getDefaultList(HttpSession sess, String table, String database, int progID) {
        if (database == null) {
            if (LegacySession.getCommunity(sess).equalsIgnoreCase("nonsurvey")) {
                return WSASchema.getDefaultList(LegacySession.getReqFilters(sess), table, LegacySession.getSchemaVersion(sess));
            }
            if (LegacySession.getLoginBoolean(sess)) {
                return WSASchema.getDefaultList(WSASchema.getReqFilters(progID), table, WSASchema.LATESTUKIDSSSCHEMA);
            }
            return WSASchema.getDefaultList(WSASchema.getReqFilters(progID), table, WSASchema.LATESTWORLDSCHEMA);
        }
        if (LegacySession.getCommunity(sess).equalsIgnoreCase("nonsurvey")) {
            return WSASchema.getDefaultList(LegacySession.getReqFilters(sess), table, LegacySession.getSchemaVersion(sess));
        }
        if (LegacySession.getLoginBoolean(sess)) {
            return WSASchema.getDefaultList(WSASchema.getReqFilters(progID), table, database);
        }
        return WSASchema.getDefaultList(WSASchema.getReqFilters(progID), table, database);
    }
}

