/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.roe.wfau;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.servlet.http.HttpSession;
import net.alanmaxwell.html.HTMLStrings;
import net.alanmaxwell.sql.SQLDataFormatter;
import net.alanmaxwell.sql.SQLDataFormatterSexagecimal;
import net.alanmaxwell.sql.SQLServerInfoJDBC;
import net.mar.CancelThread;
import net.mar.FITSWriter;
import net.mar.FormatRS;
import net.mar.ParseCoords;
import net.mar.RetrieverManager;
import net.mar.RetrieverMapper;
import net.mar.UCDManager;
import org.apache.log4j.Logger;
import uk.ac.roe.wfau.DatabaseConnection;
import uk.ac.roe.wfau.HTMLFormatter;
import uk.ac.roe.wfau.LoadWSAProperties;
import uk.ac.roe.wfau.SQLMethods;
import uk.ac.roe.wfau.StringToRADec;
import uk.ac.roe.wfau.WSASchema;
import uk.ac.roe.wfau.results.ResultsCSVWriter;
import uk.ac.roe.wfau.results.ResultsFITSWriter;
import uk.ac.roe.wfau.results.ResultsVOTWriter;

public class QueryRetrieverThread
implements Runnable {
    public static Logger logger = Logger.getLogger((String)"wsa.simple");
    public static int ROWSWRITTEN_UPPERLIMIT = 30000000;
    public static String[][] showArray;
    boolean[] showBoolean = new boolean[1];
    static StringBuffer EMPTYSTRINGBUFFER;
    public static final int SQLROWS_DEFAULT = 30;
    public static final int HTMLROWS_UPPERLIMIT = 1000;
    public static final int MAXHTMLCELLS = 50000;
    public static final int MAXRESBUFFERSIZE = 0x500000;
    public static final int FACTOR = 2;
    public static final int MAXTIMEOUT = 18000;
    public static final int OUTPUT_NONE = 0;
    public static final int OUTPUT_CSV = 1;
    public static final int OUTPUT_FITS = 2;
    public static final int OUTPUT_VOT = 3;
    public static final int OUTPUT_MYDB = 4;
    public static final int COMPRESS_NONE = 0;
    public static final int COMPRESS_ZIP = 1;
    public static final int COMPRESS_GZIP = 2;
    public String uploadFile = null;
    ResultSetMetaData browsemd;
    public BufferedReader uploadBufferedReader;
    public static final int OUTPUT_BUFFERSIZE = 524288;
    private static UCDManager ucdMgr;
    private static RetrieverManager retMgr;
    private static RetrieverMapper retMap;
    protected Connection databaseConnection = null;
    protected Statement databaseQuery = null;
    protected ResultSet results = null;
    protected ResultSetMetaData resultsMetaData = null;
    protected int row = 0;
    protected long rowsTotalUpperLimit = 0L;
    protected int rowsWrittenUpperLimit = 0;
    protected int rowsWrittenToFile = 0;
    protected int rowsWrittenToHTML = 0;
    protected int resultsNumColumns = 0;
    String database = "database";
    protected String columnData = "";
    String resultsURL = "";
    int qID = -1;
    boolean AnySQLErrors = false;
    public String databaseURL = null;
    public static String[] showMFArr;
    public static String[] showGIFArr;
    public static String[] showGIMArr;
    public boolean doShowMF = true;
    public boolean doShowGIF = true;
    public boolean doShowGIM = true;
    boolean showMF = false;
    boolean showGIF = false;
    boolean showGIM = false;
    boolean listDriven = false;
    String listDrivenAper = null;
    String listDrivenURL = null;
    String listDrivenRes = null;
    public boolean showSQL = false;
    public String extraHTMLMsg = "";
    public boolean doCancelThread = false;
    public int timeout = 18000;
    public boolean updateWebqueries = false;
    protected String[] columnNames = null;
    protected SQLDataFormatter[] columnFormats = null;
    FormatRS frs;
    FITSWriter fw = null;
    String CSVName = "";
    String CSVFileName = "";
    String FITSName = "";
    String FITSFileName = "";
    String savedFilename = "";
    String fileDescr = null;
    String emailAddress = null;
    long startTime = 0L;
    String startTimeStr;
    private static final int CVSNUM_UPPERLIMIT = 60000;
    private static int CSVNumber;
    public boolean upNamePresent = false;
    protected SQLServerInfoJDBC serverInfo = null;
    String userTableFile = null;
    long userTableRows = 0L;
    String userTableColumns = null;
    String xDB;
    String xTable;
    String xSelect;
    String xWhere;
    String xID;
    double xRadius;
    int xNearest;
    String xOtherTables;
    String xOtherTableConstraints;
    protected boolean queryTerminated = false;
    protected boolean queryProcessing = true;
    boolean mightBeBackground = false;
    static String[] RANAMES;
    static String[] DECNAMES;
    boolean doSexagesimal = false;
    SQLDataFormatterSexagecimal sexagesimalRA;
    SQLDataFormatterSexagecimal sexagesimalDec;
    int[] colsRA = null;
    int[] colsDec = null;
    protected String radius = "0";
    protected String pair = "nearest";
    protected int rowsHTML = 30;
    protected boolean doRowTotal = true;
    protected String SQLQuery = null;
    String user = null;
    String ipAddress = null;
    protected int dataOutputFormat = 0;
    protected int dataOutputCompression = 0;
    protected StringBuffer htmlResults = new StringBuffer("");
    protected String HTMLTableRowColorHeader = "#FFFFCC";
    protected String HTMLTableRowColorOdd = "#FFDDDD";
    protected String HTMLTableRowColorEven = "#DDDDDD";
    protected String outputBaseDIR = "";
    protected String outputBaseURL = "";
    protected String outputAppendage = "";

    static {
        LoadWSAProperties.getSingletonObject();
        showArray = null;
        EMPTYSTRINGBUFFER = new StringBuffer("");
        showMFArr = new String[]{"multiframeid", "filename", "numdetectors", "compfile"};
        showGIFArr = new String[]{"framesetID", "ra", "dec"};
        showGIMArr = new String[]{"multiframeID", "ra", "dec"};
        try {
            Class.forName("com.microsoft.jdbc.sqlserver.SQLServerDriver");
            Class.forName("net.sourceforge.jtds.jdbc.Driver");
        }
        catch (ClassNotFoundException e) {
            System.err.println("SQLRetrieverThread::static(): Could not load SQLServerDriver class!");
        }
        CSVNumber = 0;
        RANAMES = new String[]{"ra"};
        DECNAMES = new String[]{"dec"};
    }

    public String getTopcatLaunchURL() {
        return "http://surveys.roe.ac.uk:8080/ssa/launch.jsp?file=";
    }

    public String getBaseURL() {
        return "http://surveys.roe.ac.uk/";
    }

    public StringBuffer getShowTitles() {
        return null;
    }

    public StringBuffer getShowLinks(ResultSet rs) {
        return null;
    }

    public String getFromEmail() {
        return "wsa-support@roe.ac.uk";
    }

    public String getTitle() {
        return "Database - SQL Query Results";
    }

    public int getArchiveID() {
        return 1;
    }

    public StringBuffer getLinkInfo() {
        return EMPTYSTRINGBUFFER;
    }

    public void setShowBoolean(ResultSetMetaData rsmd) {
        this.showBoolean = this.showArrayPresent(rsmd, showArray);
    }

    public boolean[] showArrayPresent(ResultSetMetaData rsmd, String[][] sArray) {
        if (sArray != null) {
            boolean isPresent = false;
            try {
                this.showBoolean = new boolean[sArray.length + 1];
                int i = 0;
                while (i < sArray.length) {
                    int j;
                    String[] tArray = sArray[i];
                    byte[] tBoolean = new byte[tArray.length];
                    int k = 1;
                    while (k <= rsmd.getColumnCount()) {
                        j = 0;
                        while (j < tArray.length) {
                            if (rsmd.getColumnName(k).equalsIgnoreCase(tArray[j])) {
                                tBoolean[j] = 1;
                            }
                            ++j;
                        }
                        ++k;
                    }
                    int tTot = 0;
                    j = 0;
                    while (j < tArray.length) {
                        tTot += tBoolean[j];
                        ++j;
                    }
                    if (tTot == tArray.length) {
                        this.showBoolean[i + 1] = true;
                        this.showBoolean[0] = true;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
        return this.showBoolean;
    }

    private static synchronized int getNextCSVNumber() {
        if (++CSVNumber > 60000) {
            CSVNumber = 0;
        }
        return CSVNumber;
    }

    public QueryRetrieverThread(SQLServerInfoJDBC newServerInfo) {
        this.setServerInfo(newServerInfo);
    }

    public void setQID(int qID) {
        this.qID = qID;
    }

    public void setListDriven(String aper, String url) {
        this.listDriven = true;
        this.listDrivenAper = aper;
        this.listDrivenURL = url;
    }

    public String getResultsURL() {
        return this.resultsURL;
    }

    public void setDatabaseName(String database) {
        this.database = database;
    }

    public QueryRetrieverThread(String dbURL) {
        this.databaseURL = dbURL;
    }

    protected synchronized void setServerInfo(SQLServerInfoJDBC newServerInfo) {
        this.serverInfo = newServerInfo;
    }

    public void setUserTable(String userTableFile, long userTableRows, String userTableColumns) {
        this.userTableFile = userTableFile;
        this.userTableRows = userTableRows;
        this.userTableColumns = userTableColumns;
    }

    public synchronized void setUploadFile(String newUploadFile) {
        this.uploadFile = newUploadFile;
    }

    public void setCrossIDParameters(String xDB, String xTable, String xSelect, String xWhere, String xID, double xRadius, int xNearest) {
        this.setCrossIDParameters(xDB, xTable, xSelect, xWhere, xID, xRadius, xNearest, null, null);
    }

    public void setCrossIDParameters(String xDB, String xTable, String xSelect, String xWhere, String xID, double xRadius, int xNearest, String xOtherTables, String xOtherTableConstraints) {
        this.xDB = xDB;
        this.xTable = xTable;
        this.xSelect = xSelect;
        this.xWhere = xWhere;
        this.xRadius = xRadius;
        this.xNearest = xNearest;
        this.xID = xID;
        this.xOtherTables = xOtherTables;
        this.xOtherTableConstraints = xOtherTableConstraints;
    }

    public synchronized void setUpBufferedReader(BufferedReader newUpBufferedReader) {
        BufferedReader uploadBufferedReader = newUpBufferedReader;
    }

    public synchronized void setQueryTerminated(boolean status) {
        this.queryTerminated = status;
    }

    public boolean isQueryTerminated() {
        return this.queryTerminated;
    }

    public void closeConnection() {
        if (this.databaseConnection != null) {
            try {
                this.databaseConnection.close();
                logger.info((Object)"ConnectionClosed");
            }
            catch (SQLException se) {
                logger.error((Object)se);
            }
        }
    }

    public synchronized void setDBConnectionClosed() {
        logger.info((Object)"setDBConnectionClosed");
        if (this.databaseConnection != null) {
            System.out.println("im closing");
            logger.info((Object)"setDBConnectionClosed");
            try {
                this.databaseQuery.setQueryTimeout(1);
            }
            catch (SQLException se) {
                System.out.println(se);
            }
        }
    }

    public synchronized void setQueryProcessing(boolean status) {
        this.queryProcessing = status;
    }

    public synchronized boolean isQueryProcessing() {
        return this.queryProcessing;
    }

    public synchronized void setMightBeBackground(boolean newMBB) {
        this.mightBeBackground = newMBB;
    }

    public synchronized boolean isMightBeBackground() {
        return this.mightBeBackground;
    }

    public synchronized void setEmailAddress(String newEmailAddress) {
        this.emailAddress = newEmailAddress;
    }

    public synchronized String getEmailAddress() {
        return this.emailAddress;
    }

    String[] getRANames() {
        return RANAMES;
    }

    String[] getDecNames() {
        return DECNAMES;
    }

    public synchronized void setRadius(String newRadius) {
        this.radius = newRadius;
    }

    public synchronized void setPair(String newPair) {
        this.pair = newPair;
    }

    public synchronized void setRowsHTML(int newRows) {
        this.rowsHTML = newRows > 1000 ? 1000 : (newRows < 0 ? 0 : newRows);
    }

    public synchronized int getRowsHTML() {
        return this.rowsHTML;
    }

    public synchronized int getRowsReturned() {
        return this.row;
    }

    public synchronized boolean getDoRowTotal() {
        return this.doRowTotal;
    }

    public void setDoSexagesimal(boolean doSexagesimal) {
        this.doSexagesimal = doSexagesimal;
    }

    public synchronized void setDoRowTotal(boolean status) {
        this.doRowTotal = status;
    }

    public synchronized void setSQLQuery(String newQuery) {
        this.SQLQuery = newQuery;
        this.setQueryProcessing(true);
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setIPAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public synchronized String getSQLQuery() {
        return this.SQLQuery;
    }

    public synchronized void setOutputFormat(int newFormat) {
        this.dataOutputFormat = newFormat;
    }

    public synchronized int getOutputFormat() {
        return this.dataOutputFormat;
    }

    public synchronized void setOutputCompression(int newCompression) {
        this.dataOutputCompression = newCompression;
    }

    public synchronized int getOutputCompression() {
        return this.dataOutputCompression;
    }

    protected synchronized void clearResultsHTML() {
        this.htmlResults = new StringBuffer("");
    }

    protected synchronized void addToResultsHTML(String newLine) {
        this.htmlResults.append(newLine);
    }

    public synchronized String getResultsHTML() {
        return this.htmlResults.toString();
    }

    public synchronized void setHTMLTableColorRowHeader(String newColor) {
        this.HTMLTableRowColorHeader = newColor;
    }

    public synchronized String getHTMLTableColorRowHeader() {
        return this.HTMLTableRowColorHeader;
    }

    public synchronized void setHTMLTableColorRowOdd(String newColor) {
        this.HTMLTableRowColorOdd = newColor;
    }

    public synchronized String getHTMLTableColorRowOdd() {
        return this.HTMLTableRowColorOdd;
    }

    public synchronized void setHTMLTableColorRowEven(String newColor) {
        this.HTMLTableRowColorEven = newColor;
    }

    public synchronized String getHTMLTableColorRowEven() {
        return this.HTMLTableRowColorEven;
    }

    public synchronized void setOutputBaseDIR(String newDir) {
        this.outputBaseDIR = newDir;
    }

    public synchronized String getOutputBaseDIR() {
        return this.outputBaseDIR;
    }

    public synchronized void setOutputBaseURL(String newUrl) {
        this.outputBaseURL = newUrl;
    }

    public synchronized String getOutputBaseURL() {
        return this.outputBaseURL;
    }

    public synchronized void setOutputAppendage(String newAppendage) {
        this.outputAppendage = newAppendage;
    }

    public synchronized String getOutputAppendage() {
        return this.outputAppendage;
    }

    protected void generateErrorHTML(String errorMessage) {
        this.clearResultsHTML();
        this.addToResultsHTML(HTMLStrings.getHTMLErrorFragment((String)errorMessage));
    }

    protected SQLDataFormatter getSQLDataFormatterForColumn(int column) {
        return new SQLDataFormatter();
    }

    private SQLDataFormatter[] getSQLDataFormatterArray() {
        SQLDataFormatter[] tempArray = new SQLDataFormatter[this.resultsNumColumns];
        int column = 1;
        while (column <= this.resultsNumColumns) {
            tempArray[column - 1] = this.getSQLDataFormatterForColumn(column);
            ++column;
        }
        return tempArray;
    }

    protected String getPreTableHTML() {
        return "";
    }

    protected void verifyQueryAndOptions() throws Exception {
    }

    protected String getExtraPostTableHTML() {
        return "";
    }

    protected String getPostTableHTML() {
        String firstPart;
        String secondPart = "";
        String extra = "";
        if ((long)this.row >= this.rowsTotalUpperLimit) {
            extra = " <b> at least (i.e. before it was halted) </b> ";
        }
        if (this.getDoRowTotal()) {
            firstPart = this.row == 1 ? "      (Query returned 1 result row, \n " : "      (Query returned " + extra + this.row + " result rows, \n";
            secondPart = this.rowsWrittenToHTML == 0 ? "      no rows are shown in the displayed table.) \n" : (this.row <= this.rowsWrittenToHTML ? "      all rows are shown in the displayed table.) \n" : (this.rowsWrittenToHTML == 1 ? "      only the first row is shown in the displayed table.) \n" : "      only the first " + this.rowsWrittenToHTML + " rows are shown in the displayed table.) \n"));
        } else if (this.row <= this.rowsWrittenToHTML) {
            firstPart = this.row == 1 ? "      (Query returned 1 result row, \n" : "      (Query returned " + this.row + " result rows, \n";
            secondPart = "      all rows are shown in the displayed table.) \n";
        } else if (this.rowsWrittenToHTML == 0) {
            firstPart = "      (Query returned more than 0 result rows, \n";
            secondPart = "      no rows are shown in the displayed table.) \n";
        } else if (this.rowsWrittenToHTML == 1) {
            firstPart = "      (Query returned more than 1 result row, \n";
            secondPart = "      only the first row is shown in the displayed table.) \n";
        } else {
            firstPart = "      (Query returned more than " + this.rowsWrittenToHTML + " result rows, \n";
            secondPart = "      only the first " + this.rowsWrittenToHTML + " rows are shown in the displayed table.) \n";
        }
        return "    <p> \n" + firstPart + secondPart + "    </p> \n\n";
    }

    protected String getInsertedTableCellsHeaderHTML() {
        return "        <th>&nbsp;</th> \n";
    }

    protected String getInsertedTableCellsDataHTML() {
        return "        <td nowrap class=\"RowHeader\" bgcolor=\"" + this.getHTMLTableColorRowHeader() + "\"><b>" + this.row + "</b></td> \n";
    }

    public Statement setConnection(String[] servers, String database, String archive, HttpSession sess, String startServer) {
        return this.setConnection(servers, database, archive, sess, startServer, false);
    }

    public Statement setConnection(String[] servers, String database, String archive, HttpSession sess, String startServer, boolean suppliedServer) {
        try {
            this.databaseConnection = DatabaseConnection.getConnection(suppliedServer, servers, database, archive, sess, startServer);
            this.databaseConnection.setTransactionIsolation(1);
            DatabaseMetaData dbmd = this.databaseConnection.getMetaData();
            this.databaseQuery = this.databaseConnection.createStatement();
            return this.databaseQuery;
        }
        catch (SQLException se) {
            logger.error((Object)("QueryRetrieverThread:setConnection: " + se));
            try {
                this.databaseConnection.close();
            }
            catch (Exception e) {
                return null;
            }
            return null;
        }
        catch (Exception e) {
            logger.error((Object)("QueryRetrieverThread:setConnectionE: " + e));
            try {
                this.databaseConnection.close();
            }
            catch (Exception e1) {
                return null;
            }
            return null;
        }
    }

    public Statement setConnection() {
        try {
            this.databaseConnection = DriverManager.getConnection(this.databaseURL);
            this.databaseConnection.setTransactionIsolation(1);
            DatabaseMetaData dbmd = this.databaseConnection.getMetaData();
            this.databaseQuery = this.databaseConnection.createStatement();
            return this.databaseQuery;
        }
        catch (SQLException se) {
            logger.error((Object)se);
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        block219: {
            block218: {
                block217: {
                    this.startTimeStr = Calendar.getInstance().getTime().toString();
                    QueryRetrieverThread.logger.debug((Object)"RetrieverThread,Status,Start of run");
                    this.setQueryProcessing(true);
                    this.setQueryTerminated(false);
                    resultsStringBuffer = new StringBuffer("");
                    runningNumber = QueryRetrieverThread.getNextCSVNumber();
                    uniqID = String.valueOf(String.valueOf(Calendar.getInstance().get(5))) + "_" + String.valueOf(Calendar.getInstance().get(11)) + "_" + String.valueOf(Calendar.getInstance().get(12)) + "_" + String.valueOf(Calendar.getInstance().get(13)) + "_" + runningNumber;
                    this.resultsURL = String.valueOf(this.getOutputBaseURL()) + this.getOutputAppendage() + "results" + uniqID + ".html";
                    QueryRetrieverThread.logger.debug((Object)uniqID);
                    resW = null;
                    OutputFormatCache = this.getOutputFormat();
                    if (OutputFormatCache != 0) {
                        testFile = new File(String.valueOf(this.getOutputBaseDIR()) + this.getOutputAppendage());
                        if (!testFile.exists() || !testFile.isDirectory()) {
                            this.generateErrorHTML("temp directory not available for writing.");
                            try {
                                this.databaseConnection.close();
                            }
                            catch (SQLException var7_7) {
                                // empty catch block
                            }
                            testFile = null;
                            return;
                        }
                        testFile = null;
                    }
                    cancelRunner = null;
                    CThread = null;
                    if (this.databaseURL != null) break block217;
                    this.generateErrorHTML("<b>Error in run():</b> No server/database URL provided.");
                    QueryRetrieverThread.logger.info((Object)"and finally....");
                    this.setQueryProcessing(false);
                    try {
                        this.databaseConnection.close();
                    }
                    catch (SQLException var31_9) {
                        // empty catch block
                    }
                    if (resW != null) {
                        try {
                            resW.finishUp();
                        }
                        catch (IOException var31_10) {
                            // empty catch block
                        }
                        resW = null;
                    }
                    resultsStringBuffer = null;
                    this.frs = null;
                    this.fw = null;
                    this.resultsMetaData = null;
                    if (this.results != null) {
                        try {
                            this.results.close();
                        }
                        catch (SQLException var31_12) {
                            // empty catch block
                        }
                    }
                    this.results = null;
                    if (this.databaseQuery != null) {
                        try {
                            this.databaseQuery.close();
                        }
                        catch (SQLException var31_13) {
                            // empty catch block
                        }
                    }
                    this.databaseQuery = null;
                    this.databaseConnection = null;
                    if (this.doCancelThread) {
                        try {
                            cancelRunner.interrupt();
                        }
                        catch (Exception var31_14) {
                            // empty catch block
                        }
                        cancelRunner = null;
                        CThread = null;
                    }
                    if (this.isMightBeBackground()) {
                        waitCount = 0;
                        while (this.getEmailAddress() == null && waitCount < 15) {
                            QueryRetrieverThread.logger.debug((Object)("hereibe " + waitCount));
                            ++waitCount;
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException var32_37) {
                                // empty catch block
                            }
                        }
                        if (this.listDriven) {
                            try {
                                url = new URL(String.valueOf(this.listDrivenURL) + "?file=" + this.getOutputBaseDIR() + this.getOutputAppendage() + this.savedFilename + "&email=" + this.getEmailAddress() + "&aperture=" + this.listDrivenAper);
                                QueryRetrieverThread.logger.info((Object)(String.valueOf(this.listDrivenURL) + url.getFile()));
                                uc = url.openConnection();
                                content = uc.getInputStream();
                                in = new BufferedReader(new InputStreamReader(content));
                                rsb = new StringBuffer("");
                                while ((wLine = in.readLine()) != null) {
                                    rsb.append(wLine);
                                }
                                this.listDrivenRes = rsb.toString();
                            }
                            catch (MalformedURLException e) {
                                QueryRetrieverThread.logger.error((Object)e.getMessage());
                                this.listDrivenRes = "URL ERROR " + e.getMessage();
                            }
                            catch (IOException e) {
                                QueryRetrieverThread.logger.error((Object)e.getMessage());
                                this.listDrivenRes = "IO ERROR " + e.getMessage();
                            }
                        }
                        if (this.getEmailAddress() != null && this.getEmailAddress().length() > 3) {
                            HTMLFileName = String.valueOf(this.getOutputBaseDIR()) + this.getOutputAppendage() + "results" + uniqID + ".html";
                            HTMLFile = new File(HTMLFileName);
                            try {
                                HTMLFile.createNewFile();
                                HTMLfw = new FileWriter(HTMLFile);
                                HTMLpw = new PrintWriter(HTMLfw);
                                HTMLpw.println(HTMLStrings.getHTMLHeadWithScript((String)this.getTitle(), (String)(String.valueOf(this.getOutputBaseURL()) + "/configurestyles.js")));
                                HTMLpw.println("<h3>" + this.getTitle() + "</h3>");
                                if (this.uploadFile != null) {
                                    HTMLpw.println("<p> CrossID parameters:");
                                    HTMLpw.println("<br> radius: " + this.xRadius);
                                    HTMLpw.println("<br> Nearby(0) or Nearest (1): " + this.xNearest);
                                    HTMLpw.println("\n<!--" + this.SQLQuery.trim() + "--><p>");
                                }
                                if (this.userTableFile != null) {
                                    HTMLpw.println("<p> #userTable file: " + this.userTableFile);
                                    HTMLpw.println("<br>#userTable rows: " + this.userTableRows);
                                    HTMLpw.println("<br>#userTable columns: " + this.userTableColumns + "<p>");
                                }
                                if (this.extraHTMLMsg.length() > 0) {
                                    HTMLpw.println("<p> " + this.extraHTMLMsg + "<p>");
                                }
                                if (this.showSQL) {
                                    HTMLpw.println("<p>Submitted query: " + HTMLFormatter.forHTMLTag(this.SQLQuery.trim()) + "<p>");
                                }
                                HTMLpw.println("<b>Start:</b> " + this.startTimeStr + " <b>End:</b> " + Calendar.getInstance().getTime() + "<p>Database: " + this.database + "<p>");
                                HTMLpw.println(this.htmlResults.toString());
                                HTMLpw.println("</body> </html>");
                                HTMLfw.close();
                            }
                            catch (IOException HTMLfw) {
                                // empty catch block
                            }
                            try {
                                properties = System.getProperties();
                                session = Session.getInstance((Properties)properties, null);
                                message = new MimeMessage(session);
                                message.setFrom((Address)new InternetAddress(this.getFromEmail()));
                                message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(this.getEmailAddress()));
                                message.addRecipient(Message.RecipientType.BCC, (Address)new InternetAddress("mar@roe.ac.uk"));
                                message.setSubject(this.getTitle());
                                if (this.listDriven) {
                                    message.setText("The intermediate results of your query are are\n" + this.getOutputBaseURL() + this.getOutputAppendage() + "results" + uniqID + ".html\nThese results have been forwarded to the list driven" + "photomtery service and you will receive another email when that has completed (this could take several hours).\n" + this.listDrivenRes);
                                } else {
                                    message.setText("The results of your query can be retrieved from \n" + this.getOutputBaseURL() + this.getOutputAppendage() + "results" + uniqID + ".html");
                                }
                                transport = session.getTransport("smtp");
                                if (WSASchema.MAILSERVER != null) {
                                    transport.connect(WSASchema.MAILSERVER, "", "");
                                } else {
                                    transport.connect("bulkmailrelay.ucs.ed.ac.uk", "", "");
                                }
                                transport.sendMessage((Message)message, message.getAllRecipients());
                                transport.close();
                            }
                            catch (MessagingException me) {
                                QueryRetrieverThread.logger.error((Object)me);
                                QueryRetrieverThread.logger.error((Object)("EMAILERROR " + this.getEmailAddress() + "\nThe results of your query can be retrieved from \n" + this.getOutputBaseURL() + this.getOutputAppendage() + "results" + uniqID + ".html"));
                            }
                            catch (Exception e) {
                                QueryRetrieverThread.logger.error((Object)e);
                                QueryRetrieverThread.logger.error((Object)("EMAILERROR " + this.getEmailAddress() + "\nThe results of your query can be retrieved from \n" + this.getOutputBaseURL() + this.getOutputAppendage() + "results" + uniqID + ".html"));
                            }
                        }
                    }
                    QueryRetrieverThread.logger.info((Object)"QueryThread GC");
                    System.gc();
                    return;
                }
                if (this.doCancelThread) {
                    CThread = new CancelThread(this.databaseQuery, Math.min(18000, this.timeout));
                    cancelRunner = new Thread((Runnable)CThread);
                    cancelRunner.start();
                } else {
                    this.databaseQuery.setQueryTimeout(Math.min(18000, this.timeout));
                }
                this.databaseQuery.setFetchSize(500);
                QueryRetrieverThread.logger.info((Object)("ROWSWRITTEN_UPPERLIMIT " + QueryRetrieverThread.ROWSWRITTEN_UPPERLIMIT));
                if (QueryRetrieverThread.ROWSWRITTEN_UPPERLIMIT >= 2100000000) {
                    QueryRetrieverThread.logger.info((Object)"here");
                    this.databaseQuery.setMaxRows(QueryRetrieverThread.ROWSWRITTEN_UPPERLIMIT + 1);
                } else {
                    QueryRetrieverThread.logger.info((Object)"there");
                    this.databaseQuery.setMaxRows(QueryRetrieverThread.ROWSWRITTEN_UPPERLIMIT * 2 + 1);
                }
                noBrowseCols = 0;
                if (this.uploadFile != null) ** GOTO lbl335
                this.browsemd = SQLMethods.browseSQL(this.databaseConnection, this.SQLQuery);
                if (this.doCancelThread && CThread.getCancelled()) {
                    throw new SQLException("Query statement cancelled by timeout.");
                }
                this.databaseQuery.execute("set fmtonly off");
                if (this.browsemd != null) {
                    noBrowseCols = this.browsemd.getColumnCount();
                    if (noBrowseCols > 0) {
                        QueryRetrieverThread.logger.info((Object)"everywhere");
                        if (QueryRetrieverThread.ROWSWRITTEN_UPPERLIMIT >= 2100000000) {
                            this.databaseQuery.setMaxRows((int)Math.ceil((double)QueryRetrieverThread.ROWSWRITTEN_UPPERLIMIT / ((double)noBrowseCols * 1000.0)) * 1000 * 1 + 2);
                        } else {
                            this.databaseQuery.setMaxRows((int)Math.ceil((double)QueryRetrieverThread.ROWSWRITTEN_UPPERLIMIT / ((double)noBrowseCols * 1000.0)) * 1000 * 2 + 2);
                        }
                    }
                } else {
                    QueryRetrieverThread.logger.info((Object)"null browsemd");
                }
                if (!this.isQueryTerminated()) break block218;
                QueryRetrieverThread.logger.info((Object)"and finally....");
                this.setQueryProcessing(false);
                try {
                    this.databaseConnection.close();
                }
                catch (SQLException waitCount) {
                    // empty catch block
                }
                if (resW != null) {
                    try {
                        resW.finishUp();
                    }
                    catch (IOException waitCount) {
                        // empty catch block
                    }
                    resW = null;
                }
                resultsStringBuffer = null;
                this.frs = null;
                this.fw = null;
                this.resultsMetaData = null;
                if (this.results != null) {
                    try {
                        this.results.close();
                    }
                    catch (SQLException waitCount) {
                        // empty catch block
                    }
                }
                this.results = null;
                if (this.databaseQuery != null) {
                    try {
                        this.databaseQuery.close();
                    }
                    catch (SQLException waitCount) {
                        // empty catch block
                    }
                }
                this.databaseQuery = null;
                this.databaseConnection = null;
                if (this.doCancelThread) {
                    try {
                        cancelRunner.interrupt();
                    }
                    catch (Exception waitCount) {
                        // empty catch block
                    }
                    cancelRunner = null;
                    CThread = null;
                }
                if (this.isMightBeBackground()) {
                    waitCount = 0;
                    while (this.getEmailAddress() == null && waitCount < 15) {
                        QueryRetrieverThread.logger.debug((Object)("hereibe " + waitCount));
                        ++waitCount;
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException HTMLFileName) {
                            // empty catch block
                        }
                    }
                    if (this.listDriven) {
                        try {
                            url = new URL(String.valueOf(this.listDrivenURL) + "?file=" + this.getOutputBaseDIR() + this.getOutputAppendage() + this.savedFilename + "&email=" + this.getEmailAddress() + "&aperture=" + this.listDrivenAper);
                            QueryRetrieverThread.logger.info((Object)(String.valueOf(this.listDrivenURL) + url.getFile()));
                            uc = url.openConnection();
                            content = uc.getInputStream();
                            in = new BufferedReader(new InputStreamReader(content));
                            rsb = new StringBuffer("");
                            while ((wLine = in.readLine()) != null) {
                                rsb.append(wLine);
                            }
                            this.listDrivenRes = rsb.toString();
                        }
                        catch (MalformedURLException e) {
                            QueryRetrieverThread.logger.error((Object)e.getMessage());
                            this.listDrivenRes = "URL ERROR " + e.getMessage();
                        }
                        catch (IOException e) {
                            QueryRetrieverThread.logger.error((Object)e.getMessage());
                            this.listDrivenRes = "IO ERROR " + e.getMessage();
                        }
                    }
                    if (this.getEmailAddress() != null && this.getEmailAddress().length() > 3) {
                        HTMLFileName = String.valueOf(this.getOutputBaseDIR()) + this.getOutputAppendage() + "results" + uniqID + ".html";
                        HTMLFile = new File(HTMLFileName);
                        try {
                            HTMLFile.createNewFile();
                            HTMLfw = new FileWriter(HTMLFile);
                            HTMLpw = new PrintWriter(HTMLfw);
                            HTMLpw.println(HTMLStrings.getHTMLHeadWithScript((String)this.getTitle(), (String)(String.valueOf(this.getOutputBaseURL()) + "/configurestyles.js")));
                            HTMLpw.println("<h3>" + this.getTitle() + "</h3>");
                            if (this.uploadFile != null) {
                                HTMLpw.println("<p> CrossID parameters:");
                                HTMLpw.println("<br> radius: " + this.xRadius);
                                HTMLpw.println("<br> Nearby(0) or Nearest (1): " + this.xNearest);
                                HTMLpw.println("\n<!--" + this.SQLQuery.trim() + "--><p>");
                            }
                            if (this.userTableFile != null) {
                                HTMLpw.println("<p> #userTable file: " + this.userTableFile);
                                HTMLpw.println("<br>#userTable rows: " + this.userTableRows);
                                HTMLpw.println("<br>#userTable columns: " + this.userTableColumns + "<p>");
                            }
                            if (this.extraHTMLMsg.length() > 0) {
                                HTMLpw.println("<p> " + this.extraHTMLMsg + "<p>");
                            }
                            if (this.showSQL) {
                                HTMLpw.println("<p>Submitted query: " + HTMLFormatter.forHTMLTag(this.SQLQuery.trim()) + "<p>");
                            }
                            HTMLpw.println("<b>Start:</b> " + this.startTimeStr + " <b>End:</b> " + Calendar.getInstance().getTime() + "<p>Database: " + this.database + "<p>");
                            HTMLpw.println(this.htmlResults.toString());
                            HTMLpw.println("</body> </html>");
                            HTMLfw.close();
                        }
                        catch (IOException HTMLfw) {
                            // empty catch block
                        }
                        try {
                            properties = System.getProperties();
                            session = Session.getInstance((Properties)properties, null);
                            message = new MimeMessage(session);
                            message.setFrom((Address)new InternetAddress(this.getFromEmail()));
                            message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(this.getEmailAddress()));
                            message.addRecipient(Message.RecipientType.BCC, (Address)new InternetAddress("mar@roe.ac.uk"));
                            message.setSubject(this.getTitle());
                            if (this.listDriven) {
                                message.setText("The intermediate results of your query are are\n" + this.getOutputBaseURL() + this.getOutputAppendage() + "results" + uniqID + ".html\nThese results have been forwarded to the list driven" + "photomtery service and you will receive another email when that has completed (this could take several hours).\n" + this.listDrivenRes);
                            } else {
                                message.setText("The results of your query can be retrieved from \n" + this.getOutputBaseURL() + this.getOutputAppendage() + "results" + uniqID + ".html");
                            }
                            transport = session.getTransport("smtp");
                            if (WSASchema.MAILSERVER != null) {
                                transport.connect(WSASchema.MAILSERVER, "", "");
                            } else {
                                transport.connect("bulkmailrelay.ucs.ed.ac.uk", "", "");
                            }
                            transport.sendMessage((Message)message, message.getAllRecipients());
                            transport.close();
                        }
                        catch (MessagingException me) {
                            QueryRetrieverThread.logger.error((Object)me);
                            QueryRetrieverThread.logger.error((Object)("EMAILERROR " + this.getEmailAddress() + "\nThe results of your query can be retrieved from \n" + this.getOutputBaseURL() + this.getOutputAppendage() + "results" + uniqID + ".html"));
                        }
                        catch (Exception e) {
                            QueryRetrieverThread.logger.error((Object)e);
                            QueryRetrieverThread.logger.error((Object)("EMAILERROR " + this.getEmailAddress() + "\nThe results of your query can be retrieved from \n" + this.getOutputBaseURL() + this.getOutputAppendage() + "results" + uniqID + ".html"));
                        }
                    }
                }
                QueryRetrieverThread.logger.info((Object)"QueryThread GC");
                System.gc();
                return;
            }
            try {
                try {
                    block220: {
                        this.startTime = System.currentTimeMillis();
                        this.results = this.databaseQuery.executeQuery(this.SQLQuery);
                        break block220;
lbl335:
                        // 1 sources

                        SQLQueryBuffer = null;
                        this.startTime = System.currentTimeMillis();
                        try {
                            checkSQL = null;
                            where = "";
                            otherTables = "";
                            if (this.xOtherTables != null && !this.xOtherTables.equals("")) {
                                otherTables = "," + this.xOtherTables;
                            }
                            if (this.xWhere != null && !this.xWhere.equals("")) {
                                checkSQL = "select " + this.xSelect + " from " + this.xTable + otherTables + " where " + this.xWhere;
                                where = " and " + this.xWhere;
                            } else {
                                checkSQL = "select " + this.xSelect + " from " + this.xTable;
                            }
                            SQLMethods.checkValidSQL(this.databaseConnection, checkSQL);
                            if (!this.upNamePresent) {
                                this.databaseQuery.executeUpdate("create table #upload  (upload_ID int,upload_RA float,upload_Dec float)");
                            } else {
                                this.databaseQuery.executeUpdate("create table #upload  (upload_ID int,upload_RA float,upload_Dec float,upload_name varchar(24))");
                            }
                            this.databaseQuery.executeUpdate("create table #proxtab  (upID int,archiveID bigint ,distance float primary key (upID,archiveID))");
                            SQLQueryBuffer = new StringBuffer("");
                            file = new File(this.uploadFile);
                            fr = new FileReader(file);
                            in = new BufferedReader(fr);
                            count = 0;
                            this.databaseConnection.setAutoCommit(false);
                            uploadIDPres = true;
                            if (this.upNamePresent) {
                                uploadIDPres = false;
                            }
                            sqlNoName = "insert into #upload values(?,?,?)";
                            sqlWithName = "insert into #upload values(?,?,?,?)";
                            crossPstmt = null;
                            crossPstmt = !this.upNamePresent ? this.databaseConnection.prepareStatement(sqlNoName) : this.databaseConnection.prepareStatement(sqlWithName);
                            while ((line = in.readLine()) != null && !this.isQueryTerminated()) {
                                ++count;
                                upCoords = StringToRADec.getRADec(line.trim(), uploadIDPres);
                                upRA = (Double)upCoords[0];
                                upDec = (Double)upCoords[1];
                                upMatchID = (Long)upCoords[2];
                                if (!(upRA >= 0.0) || !(upRA <= 360.0) || !(upDec >= -90.0) || !(upDec <= 90.0)) continue;
                                if (!this.upNamePresent) {
                                    crossPstmt.setInt(1, count);
                                    crossPstmt.setDouble(2, upRA);
                                    crossPstmt.setDouble(3, upDec);
                                    crossPstmt.addBatch();
                                    continue;
                                }
                                crossPstmt.setInt(1, count);
                                crossPstmt.setDouble(2, upRA);
                                crossPstmt.setDouble(3, upDec);
                                crossPstmt.setString(4, upCoords[3].toString());
                                crossPstmt.addBatch();
                            }
                            this.databaseConnection.commit();
                            QueryRetrieverThread.logger.info((Object)"starting batch execute");
                            updateCounts = crossPstmt.executeBatch();
                            crossPstmt = null;
                            QueryRetrieverThread.logger.info((Object)"finished batch execute, now null");
                            this.databaseConnection.setAutoCommit(true);
                            resultsStringBuffer.append("<br>" + updateCounts.length + " rows uploaded<p>");
                            this.databaseQuery.executeUpdate("EXEC master..spHTMCrossID " + this.xRadius / 60.0 + ",'" + this.xDB + ".." + this.xTable + " as " + this.xTable + "','" + this.xID + "'," + this.xNearest + ",' " + where + " '");
                            SQLQueryBuffer.append(this.SQLQuery);
                        }
                        catch (FileNotFoundException checkSQL) {
                            // empty catch block
                        }
                        this.results = this.databaseQuery.executeQuery(SQLQueryBuffer.toString());
                    }
                    this.resultsMetaData = this.results.getMetaData();
                    this.frs = new FormatRS(this.doSexagesimal, this.getRANames(), this.getDecNames());
                    this.frs.setRSMD(this.resultsMetaData);
                    this.setShowBoolean(this.resultsMetaData);
                    this.resultsNumColumns = this.resultsMetaData.getColumnCount();
                    row_size = 0;
                    this.rowsWrittenUpperLimit = (int)Math.ceil((double)QueryRetrieverThread.ROWSWRITTEN_UPPERLIMIT / ((double)this.resultsNumColumns * 1000.0)) * 1000 - 1;
                    if (this.rowsWrittenUpperLimit < 1) {
                        this.rowsWrittenUpperLimit = 2;
                    }
                    this.rowsTotalUpperLimit = 2L * ((long)this.rowsWrittenUpperLimit + 1L);
                    this.columnNames = new String[this.resultsNumColumns];
                    QueryRetrieverThread.logger.info((Object)("uniqID " + uniqID + " ofc " + OutputFormatCache));
                    QueryRetrieverThread.logger.info((Object)(String.valueOf(this.getOutputBaseDIR()) + " " + this.getOutputAppendage() + " " + this.FITSName + " " + this.getOutputCompression()));
                    QueryRetrieverThread.logger.info((Object)("rowsTotalUpperLimit " + this.rowsTotalUpperLimit));
                    QueryRetrieverThread.logger.info((Object)("rowsWrittenUpperLimit " + this.rowsWrittenUpperLimit));
                    switch (OutputFormatCache) {
                        case 0: {
                            this.fileDescr = "";
                            break;
                        }
                        case 2: {
                            if (this.resultsNumColumns > 999) {
                                resultsStringBuffer.append("<p><b>Warning: </b> The number of columns in the FITS files has been limited to 999.");
                            }
                            this.fileDescr = "FITS";
                            this.FITSName = "results" + uniqID;
                            resW = new ResultsFITSWriter(this.getOutputBaseDIR(), this.getOutputAppendage(), this.FITSName, this.getOutputCompression(), this.SQLQuery, this.database, this.resultsMetaData);
                            resW.setArchiveID(this.getArchiveID());
                            if (this.uploadFile == null) break;
                            comm = new String[]{"CROSSID radius: " + this.xRadius, "CROSSID NEARBY or NEAREST 0 or 1: " + this.xNearest, "CROSSID where: " + this.xWhere};
                            resW.addComments(comm);
                            break;
                        }
                        case 1: {
                            this.fileDescr = "CSV ASCII";
                            this.CSVName = "results" + uniqID;
                            resW = new ResultsCSVWriter(this.getOutputBaseDIR(), this.getOutputAppendage(), this.CSVName, this.getOutputCompression(), this.SQLQuery, this.database, this.resultsMetaData);
                            resW.setColsRADec(this.doSexagesimal, this.getRANames(), this.getDecNames());
                            if (this.uploadFile == null) break;
                            comm = new String[]{"CROSSID radius: " + this.xRadius, "CROSSID NEARBY or NEAREST 0 or 1: " + this.xNearest, "CROSSID where: " + this.xWhere};
                            resW.addComments(comm);
                            break;
                        }
                        case 3: {
                            this.fileDescr = "VOTable ASCIII";
                            this.CSVName = "results" + uniqID;
                            resW = new ResultsVOTWriter(this.getOutputBaseDIR(), this.getOutputAppendage(), this.CSVName, this.getOutputCompression(), this.SQLQuery, this.database, this.resultsMetaData);
                        }
                    }
                    if (resW != null) {
                        this.savedFilename = resW.init();
                    }
                    QueryRetrieverThread.logger.info((Object)("savedFilename " + this.savedFilename));
                    if (this.showBoolean[0]) {
                        resultsStringBuffer.append(this.getLinkInfo());
                    }
                    resultsStringBuffer.append(this.getPreTableHTML());
                    resultsStringBuffer.append("    <table border=\"1\" cellspacing=\"0\" cellpadding=\"3\" bgcolor=\"" + this.getHTMLTableColorRowOdd() + "\"> \n");
                    GenerateHTML = true;
                    doForm = false;
                    RAPresent = false;
                    DecPresent = false;
                    RACol = 0;
                    DecCol = 0;
                    if (this.resultsNumColumns > 0) {
                        if (GenerateHTML) {
                            resultsStringBuffer.append("      <tr bgcolor=\"" + this.getHTMLTableColorRowHeader() + "\"> \n");
                            resultsStringBuffer.append(this.getInsertedTableCellsHeaderHTML());
                        }
                        if (GenerateHTML && this.showBoolean[0]) {
                            resultsStringBuffer.append(this.getShowTitles());
                        }
                        row_size = SQLMethods.getSizeOfRS(this.resultsMetaData);
                        column = 1;
                        while (column <= this.resultsNumColumns) {
                            this.columnNames[column - 1] = this.resultsMetaData.getColumnName(column);
                            if (this.columnNames[column - 1].equalsIgnoreCase("RA")) {
                                RACol = column - 1;
                                RAPresent = true;
                            }
                            if (this.columnNames[column - 1].equalsIgnoreCase("DEC")) {
                                DecCol = column - 1;
                                DecPresent = true;
                            }
                            ++column;
                        }
                        if (!GenerateHTML || RAPresent) {
                            // empty if block
                        }
                        column = 1;
                        while (column <= this.resultsNumColumns) {
                            this.columnNames[column - 1] = this.resultsMetaData.getColumnName(column);
                            if (GenerateHTML) {
                                if (this.columnNames[column - 1].length() < 1) {
                                    resultsStringBuffer.append("        <th nowrap>&nbsp;</th> \n");
                                } else {
                                    resultsStringBuffer.append("        <th nowrap>" + this.columnNames[column - 1] + "</th> \n");
                                }
                            }
                            ++column;
                        }
                        if (GenerateHTML) {
                            resultsStringBuffer.append("      </tr> \n");
                        }
                    }
                    this.columnFormats = this.getSQLDataFormatterArray();
                    this.verifyQueryAndOptions();
                    this.row = 0;
                    strArray = new String[this.resultsNumColumns];
                    votArray = new String[this.resultsNumColumns];
                    maxRowsHTML = this.rowsHTML;
                    if (this.resultsNumColumns > 0) {
                        maxRowsHTML = Math.min(this.rowsHTML, 50000 / this.resultsNumColumns);
                    }
                    GenerateHTML = maxRowsHTML > 0;
                    if (!this.doCancelThread || !CThread.getCancelled()) ** GOTO lbl544
                    this.AnySQLErrors = true;
                    throw new SQLException("Query statement cancelled by timeout.");
lbl-1000:
                    // 1 sources

                    {
                        ++this.row;
                        if (resW != null) {
                            resW.writeRow(this.results);
                        }
                        if (!GenerateHTML) continue;
                        strArray = OutputFormatCache != 1 ? this.frs.setRS(this.results) : resW.getStrArray();
                        ++this.rowsWrittenToHTML;
                        if (this.row % 2 == 0) {
                            resultsStringBuffer.append("      <tr bgcolor=\"" + this.getHTMLTableColorRowEven() + "\" class=\"RowEven\"> \n");
                        } else {
                            resultsStringBuffer.append("      <tr bgcolor=\"" + this.getHTMLTableColorRowOdd() + "\" class=\"RowOdd\"> \n");
                        }
                        resultsStringBuffer.append(this.getInsertedTableCellsDataHTML());
                        if (this.showBoolean[0] && GenerateHTML) {
                            resultsStringBuffer.append(this.getShowLinks(this.results));
                        }
                        column = 1;
                        while (column <= this.resultsNumColumns) {
                            this.columnData = strArray[column - 1].trim();
                            resultsStringBuffer.append("<td align=\"right\" nowrap>" + this.columnFormats[column - 1].formatDataForHTML(this.columnData) + "</td> \n");
                            ++column;
                        }
                        resultsStringBuffer.append("</tr> \n");
                        v0 = GenerateHTML = this.row + 1 <= maxRowsHTML && resultsStringBuffer.length() < 0x500000;
lbl544:
                        // 3 sources

                        ** while (!this.isQueryTerminated() && (OutputFormatCache != 0 && this.row <= this.rowsWrittenUpperLimit || GenerateHTML) && this.results.next())
                    }
lbl545:
                    // 1 sources

                    this.rowsWrittenToFile = this.row;
                    while (!this.isQueryTerminated() && this.doRowTotal && this.results.next() && (long)this.row < this.rowsTotalUpperLimit) {
                        ++this.row;
                    }
                    if (this.doCancelThread && CThread.getCancelled()) {
                        throw new SQLException("Query statement cancelled by timeout.");
                    }
                    if (this.doCancelThread) {
                        CThread.setFinished();
                    }
                    if (this.isQueryTerminated()) {
                        resultsStringBuffer.insert(0, "WARNING: Stopped by request");
                    }
                    resultsStringBuffer.append("    </table>\n\n");
                    postTableStr = new StringBuffer(this.getPostTableHTML());
                    resultsStringBuffer.append(postTableStr);
                    resultsStringBuffer.append(this.getExtraPostTableHTML());
                    if (resW != null) {
                        resW.finishUp();
                        this.fileDescr = resW.getFileDescr();
                        resW = null;
                    }
                    if (OutputFormatCache != 0) {
                        rowtemp = this.rowsWrittenUpperLimit + 1;
                        if (this.row > this.rowsWrittenToFile) {
                            resultsStringBuffer.append("<p><b> NB The number of rows written to the output file reached the maximum allowed " + rowtemp + "</b>");
                            postTableStr.append("<p><b> NB The number of rows written to the output file reached the maximum allowed " + rowtemp + "</b><p>");
                        }
                    }
                    if (OutputFormatCache != 0) {
                        fileLink = String.valueOf(this.getOutputBaseURL()) + this.getOutputAppendage() + this.savedFilename;
                        resultsStringBuffer.append("<p> \n<table cellspacing=\"0\" cellpadding=\"3\"><tr><td align=\"right\"><a href=\"" + fileLink + "\"><img src=\"" + this.getOutputBaseURL() + "images/icons/save.gif\" border=\"0\"></a></td>" + "<td><a class=\"dl\" id=\"dl_id\" href=\"" + fileLink + "\">" + "Download Results File </a>, your results in a " + this.fileDescr + " file \n" + "(Contains <b>");
                        if (this.rowsWrittenToFile == 1) {
                            resultsStringBuffer.append("1 row</b>, ");
                        } else {
                            resultsStringBuffer.append(String.valueOf(this.rowsWrittenToFile) + " rows</b>, ");
                        }
                        sFile = new File(String.valueOf(this.getOutputBaseDIR()) + this.getOutputAppendage() + this.savedFilename);
                        sFileSize = sFile.length();
                        if (sFileSize > 1000000L) {
                            resultsStringBuffer.append(String.valueOf(HTMLStrings.numbersTo1DP.format((double)sFileSize / 1024.0 / 1024.0)) + " MB) \n");
                        } else if (sFileSize > 1000L) {
                            resultsStringBuffer.append(String.valueOf(HTMLStrings.numbersTo1DP.format((double)sFileSize / 1024.0)) + " KB) \n");
                        } else {
                            resultsStringBuffer.append(String.valueOf(sFileSize) + " bytes) \n");
                        }
                        resultsStringBuffer.append("</td> \n");
                        if (OutputFormatCache == 2 || OutputFormatCache == 3) {
                            resultsStringBuffer.append("<tr class=\"Normal\"  bgcolor=\"#FFFFFF\"><td align=\"right\">\n<a href=\"" + this.getTopcatLaunchURL() + fileLink + "\"><img src=\"" + this.getBaseURL() + "topcat.gif\" border=\"0\"></a> </td>" + "<td><a href=\"" + this.getTopcatLaunchURL() + fileLink + "\"" + ">Launch file in Topcat</a> (requires Java 1.5 and Java Web Start, approx 12Mb download for Topcat application)</td>");
                        }
                        resultsStringBuffer.append("</table>");
                    }
                    if (!RAPresent || DecPresent) {
                        // empty if block
                    }
                    this.databaseQuery.execute("select 1");
                    if (this.updateWebqueries && this.SQLQuery.toLowerCase().indexOf("listwebqueries") < 0) {
                        elapsedTime = System.currentTimeMillis() - this.startTime;
                        try {
                            this.databaseQuery.execute(SQLMethods.getWebqueriesString(this.SQLQuery, this.row, elapsedTime, this.user, this.ipAddress, this.database, row_size));
                        }
                        catch (SQLException se) {
                            this.AnySQLErrors = true;
                            resultsStringBuffer.append(se);
                        }
                    }
                    if (this.qID > 0) {
                        try {
                            this.databaseQuery.execute(SQLMethods.getUpdateQStatusSQLURL(this.qID, 2, this.resultsURL));
                        }
                        catch (SQLException se) {
                            resultsStringBuffer.append(se);
                        }
                    }
                    this.clearResultsHTML();
                    this.addToResultsHTML(this.extraHTMLMsg);
                    this.addToResultsHTML(postTableStr.toString());
                    this.addToResultsHTML(resultsStringBuffer.toString());
                }
                catch (SQLException se) {
                    this.AnySQLErrors = true;
                    if (this.qID > 0 && this.AnySQLErrors) {
                        try {
                            errStmt = this.databaseConnection.createStatement();
                            errStmt.execute(SQLMethods.getUpdateQStatusSQLURL(this.qID, 3, this.resultsURL));
                        }
                        catch (SQLException se1) {
                            QueryRetrieverThread.logger.info((Object)se1);
                        }
                    }
                    QueryRetrieverThread.logger.error((Object)("SQLRetrieverThread::run(): an SQLException -> " + se.getMessage() + se.getErrorCode()));
                    extraInfo = "";
                    if (se.getMessage().toLowerCase().indexOf("cancelled") >= 0) {
                        extraInfo = "<br>Query ran for " + ParseCoords.formatP((double)((double)(System.currentTimeMillis() - this.startTime) / 1000.0), (int)1) + " secs<br>Timeout set at " + this.timeout;
                    }
                    QueryRetrieverThread.logger.error((Object)"generating Error HTML");
                    this.generateErrorHTML("<b>SQL Error:</b> " + se.getMessage() + extraInfo);
                }
                catch (Exception e) {
                    System.err.println("SQLRetrieverThread::run(): Exception -> " + e.toString());
                    e.printStackTrace();
                    QueryRetrieverThread.logger.error((Object)e.toString());
                    this.generateErrorHTML("<b>Error in run():</b> " + e.toString());
                }
            }
            catch (Throwable var30_128) {}
            finally {
                QueryRetrieverThread.logger.info((Object)"and finally....");
                this.setQueryProcessing(false);
                try {
                    this.databaseConnection.close();
                }
                catch (SQLException waitCount) {}
                if (resW != null) {
                    try {
                        resW.finishUp();
                    }
                    catch (IOException waitCount) {}
                    resW = null;
                }
                resultsStringBuffer = null;
                this.frs = null;
                this.fw = null;
                this.resultsMetaData = null;
                if (this.results != null) {
                    try {
                        this.results.close();
                    }
                    catch (SQLException waitCount) {}
                }
                this.results = null;
                if (this.databaseQuery != null) {
                    try {
                        this.databaseQuery.close();
                    }
                    catch (SQLException waitCount) {}
                }
                this.databaseQuery = null;
                this.databaseConnection = null;
                if (this.doCancelThread) {
                    try {
                        cancelRunner.interrupt();
                    }
                    catch (Exception waitCount) {}
                    cancelRunner = null;
                    CThread = null;
                }
                if (!this.isMightBeBackground()) break block219;
                waitCount = 0;
                ** while (this.getEmailAddress() == null && waitCount < 15)
            }
lbl-1000:
            // 1 sources

            {
                QueryRetrieverThread.logger.debug((Object)("hereibe " + waitCount));
                ++waitCount;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException HTMLFileName) {
                    // empty catch block
                }
                continue;
            }
lbl702:
            // 1 sources

            if (this.listDriven) {
                try {
                    url = new URL(String.valueOf(this.listDrivenURL) + "?file=" + this.getOutputBaseDIR() + this.getOutputAppendage() + this.savedFilename + "&email=" + this.getEmailAddress() + "&aperture=" + this.listDrivenAper);
                    QueryRetrieverThread.logger.info((Object)(String.valueOf(this.listDrivenURL) + url.getFile()));
                    uc = url.openConnection();
                    content = uc.getInputStream();
                    in = new BufferedReader(new InputStreamReader(content));
                    rsb = new StringBuffer("");
                    while ((wLine = in.readLine()) != null) {
                        rsb.append(wLine);
                    }
                    this.listDrivenRes = rsb.toString();
                }
                catch (MalformedURLException e) {
                    QueryRetrieverThread.logger.error((Object)e.getMessage());
                    this.listDrivenRes = "URL ERROR " + e.getMessage();
                }
                catch (IOException e) {
                    QueryRetrieverThread.logger.error((Object)e.getMessage());
                    this.listDrivenRes = "IO ERROR " + e.getMessage();
                }
            }
            if (this.getEmailAddress() != null && this.getEmailAddress().length() > 3) {
                HTMLFileName = String.valueOf(this.getOutputBaseDIR()) + this.getOutputAppendage() + "results" + uniqID + ".html";
                HTMLFile = new File(HTMLFileName);
                try {
                    HTMLFile.createNewFile();
                    HTMLfw = new FileWriter(HTMLFile);
                    HTMLpw = new PrintWriter(HTMLfw);
                    HTMLpw.println(HTMLStrings.getHTMLHeadWithScript((String)this.getTitle(), (String)(String.valueOf(this.getOutputBaseURL()) + "/configurestyles.js")));
                    HTMLpw.println("<h3>" + this.getTitle() + "</h3>");
                    if (this.uploadFile != null) {
                        HTMLpw.println("<p> CrossID parameters:");
                        HTMLpw.println("<br> radius: " + this.xRadius);
                        HTMLpw.println("<br> Nearby(0) or Nearest (1): " + this.xNearest);
                        HTMLpw.println("\n<!--" + this.SQLQuery.trim() + "--><p>");
                    }
                    if (this.userTableFile != null) {
                        HTMLpw.println("<p> #userTable file: " + this.userTableFile);
                        HTMLpw.println("<br>#userTable rows: " + this.userTableRows);
                        HTMLpw.println("<br>#userTable columns: " + this.userTableColumns + "<p>");
                    }
                    if (this.extraHTMLMsg.length() > 0) {
                        HTMLpw.println("<p> " + this.extraHTMLMsg + "<p>");
                    }
                    if (this.showSQL) {
                        HTMLpw.println("<p>Submitted query: " + HTMLFormatter.forHTMLTag(this.SQLQuery.trim()) + "<p>");
                    }
                    HTMLpw.println("<b>Start:</b> " + this.startTimeStr + " <b>End:</b> " + Calendar.getInstance().getTime() + "<p>Database: " + this.database + "<p>");
                    HTMLpw.println(this.htmlResults.toString());
                    HTMLpw.println("</body> </html>");
                    HTMLfw.close();
                }
                catch (IOException HTMLfw) {
                    // empty catch block
                }
                try {
                    properties = System.getProperties();
                    session = Session.getInstance((Properties)properties, null);
                    message = new MimeMessage(session);
                    message.setFrom((Address)new InternetAddress(this.getFromEmail()));
                    message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(this.getEmailAddress()));
                    message.addRecipient(Message.RecipientType.BCC, (Address)new InternetAddress("mar@roe.ac.uk"));
                    message.setSubject(this.getTitle());
                    if (this.listDriven) {
                        message.setText("The intermediate results of your query are are\n" + this.getOutputBaseURL() + this.getOutputAppendage() + "results" + uniqID + ".html\nThese results have been forwarded to the list driven" + "photomtery service and you will receive another email when that has completed (this could take several hours).\n" + this.listDrivenRes);
                    } else {
                        message.setText("The results of your query can be retrieved from \n" + this.getOutputBaseURL() + this.getOutputAppendage() + "results" + uniqID + ".html");
                    }
                    transport = session.getTransport("smtp");
                    if (WSASchema.MAILSERVER != null) {
                        transport.connect(WSASchema.MAILSERVER, "", "");
                    } else {
                        transport.connect("bulkmailrelay.ucs.ed.ac.uk", "", "");
                    }
                    transport.sendMessage((Message)message, message.getAllRecipients());
                    transport.close();
                }
                catch (MessagingException me) {
                    QueryRetrieverThread.logger.error((Object)me);
                    QueryRetrieverThread.logger.error((Object)("EMAILERROR " + this.getEmailAddress() + "\nThe results of your query can be retrieved from \n" + this.getOutputBaseURL() + this.getOutputAppendage() + "results" + uniqID + ".html"));
                }
                catch (Exception e) {
                    QueryRetrieverThread.logger.error((Object)e);
                    QueryRetrieverThread.logger.error((Object)("EMAILERROR " + this.getEmailAddress() + "\nThe results of your query can be retrieved from \n" + this.getOutputBaseURL() + this.getOutputAppendage() + "results" + uniqID + ".html"));
                }
            }
        }
        QueryRetrieverThread.logger.info((Object)"QueryThread GC");
        System.gc();
    }

    public String getStackTraceAsString(Exception exception) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.print(" [ ");
        pw.print(exception.getClass().getName());
        pw.print(" ] ");
        pw.print(exception.getMessage());
        exception.printStackTrace(pw);
        return sw.toString();
    }
}

