/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.roe.wfau;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import uk.ac.roe.wfau.QueueRunner;

public class QueueManager {
    static Logger logger = Logger.getLogger((String)"wsa.simple");
    public static int numSSARunners = 0;
    public static int maxNumSSARunners = 2;
    public int numWSARunners = 0;
    public static boolean queueStopped = false;
    public static Thread[] threadArray;
    public static boolean isQStopped;
    static int maxNoQRunners;
    static int runnerID;
    public static Map threadHashMap;
    public static Map qIDMap;

    static {
        isQStopped = false;
        maxNoQRunners = 2;
        runnerID = 0;
        threadHashMap = new HashMap();
        qIDMap = new HashMap();
    }

    public static synchronized void setQIDStatus(int qID, int qStatus) {
        qIDMap.put(new Integer(qID), new Integer(qStatus));
    }

    public static void removeQIDStatus(int qID) {
        qIDMap.remove(new Integer(qID));
    }

    public static int getQIDStatus(int qID) {
        try {
            return (Integer)qIDMap.get(new Integer(qID));
        }
        catch (NullPointerException npe) {
            return -1;
        }
    }

    static void removeFromQ(int rID) {
        logger.info((Object)("removing runner " + rID));
        threadHashMap.remove(new Integer(rID));
        logger.info((Object)("no of runner threads " + threadHashMap.size()));
    }

    public static synchronized void startQ() {
        logger.info((Object)"starting Q");
        int i = 0;
        while (i < maxNoQRunners) {
            if (threadHashMap.size() < maxNoQRunners) {
                logger.info((Object)("starting runner " + ++runnerID));
                QueueManager.startRunner(runnerID);
            }
            ++i;
        }
    }

    public static synchronized void clearQ() {
        try {
            threadHashMap.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void nudgeRunners() {
        if (!isQStopped) {
            Thread tempThread;
            Set keys = threadHashMap.keySet();
            Iterator keyIter = keys.iterator();
            boolean foundDeadRunners = false;
            while (keyIter.hasNext()) {
                Object key = keyIter.next();
                tempThread = (Thread)threadHashMap.get(key);
                if (tempThread.isAlive()) {
                    logger.info((Object)(String.valueOf((Integer)key) + " is alive"));
                    logger.info((Object)"interupt runner");
                    tempThread.interrupt();
                    continue;
                }
                logger.info((Object)("found a dead runner,removing runner thread" + (Integer)key));
                QueueManager.removeFromQ((Integer)key);
                foundDeadRunners = true;
            }
            keys = null;
            keyIter = null;
            tempThread = null;
            logger.info((Object)"seeing if Q needs starting");
            QueueManager.startQ();
            logger.info((Object)"nudging runners");
        }
    }

    public static void startRunner(int id) {
        logger.info((Object)"begin startrunner");
        QueueRunner runnerThread = new QueueRunner(id);
        Thread rThread = new Thread(runnerThread);
        threadHashMap.put(new Integer(id), rThread);
        rThread.start();
        rThread = null;
        runnerThread = null;
        logger.info((Object)("end startrunner " + id));
    }

    public static synchronized int getNumRunners(int i) {
        Object runnerThread = null;
        if (numSSARunners < maxNumSSARunners && i > 0) {
            return (numSSARunners += i) - 1;
        }
        return numSSARunners;
    }
}

