/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.roe.wfau;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import net.alanmaxwell.sql.WSASQLRetrieverThread;
import uk.ac.roe.wfau.QueryRetrieverThread;
import uk.ac.roe.wfau.VDFSSchema;
import uk.ac.roe.wfau.WSASchema;

public class SQLMethods {
    static String doubleQuotes = "\"";
    private static int MAXLENGTH = 20000;
    private static int WEBQUERIESLENGTH = 4096;
    static String[] COLOURS = new String[]{"R", "G", "B"};

    public static String getGCDistanceSQL(double raD, double decD, double rD) {
        StringBuffer GCDistanceSQL = new StringBuffer("60.0*2.0*degrees(asin(sqrt(square(sin(radians(0.5*(" + decD + "-dec))))" + "+ cos(radians(" + decD + "))*cos(radians(dec))" + "*square(sin(radians(0.5*(" + raD + "-ra)))))))");
        return GCDistanceSQL.toString();
    }

    public static String getRadialSQL(double raD, double decD, double rD) {
        double minDec = Math.max(-90.0, decD - rD / 60.0);
        double maxDec = Math.min(90.0, decD + rD / 60.0);
        StringBuffer radialSQL = new StringBuffer("( dec between " + minDec + " and " + maxDec + ")");
        radialSQL.append(" and (" + SQLMethods.getGCDistanceSQL(raD, decD, rD) + " <= " + rD);
        return radialSQL.toString();
    }

    public static String getRequiredFiltersSQL() {
        return "select filterid,npass from requiredfilters";
    }

    public static String getRequiredFiltersSQLFromSysColumns() {
        return "select  c.name as bandMFID from sys.tables as t, sys.columns as c, Programme as p where t.name=p.mergeLogTable and t.object_id=c.object_id and c.name like '%mfid%' ";
    }

    public static StringBuffer getFramesetSQL(ResultSet rset, String mergelogTable, String multiframeTable) {
        return SQLMethods.getFramesetSQL(rset, mergelogTable, multiframeTable, 1);
    }

    public static StringBuffer getFramesetSQL(ResultSet rset, String mergelogTable, String multiframeTable, int archiveID) {
        StringBuffer sbSQL = new StringBuffer("");
        String mfidName = null;
        String extName = null;
        int row = 0;
        boolean first = true;
        try {
            while (rset.next()) {
                ++row;
                int filterid = rset.getInt("filterid");
                int npass = rset.getInt("npass");
                if (npass == 1) {
                    mfidName = String.valueOf(VDFSSchema.getFilterName(filterid, archiveID)) + "mfid";
                    extName = String.valueOf(VDFSSchema.getFilterName(filterid, archiveID)) + "enum";
                    if (!first) {
                        sbSQL.append(" or ");
                    }
                    first = false;
                    sbSQL.append("(" + mergelogTable + "." + mfidName + "=" + multiframeTable + ".multiframeid and " + mergelogTable + "." + extName + "=mfd.extnum) ");
                    continue;
                }
                if (npass <= 1) continue;
                int i = 0;
                while (i < npass) {
                    mfidName = String.valueOf(VDFSSchema.getFilterName(filterid, archiveID)) + "_" + (i + 1) + "mfid";
                    extName = String.valueOf(VDFSSchema.getFilterName(filterid, archiveID)) + "_" + (i + 1) + "enum";
                    if (!first) {
                        sbSQL.append(" or ");
                    }
                    first = false;
                    sbSQL.append("(" + mergelogTable + "." + mfidName + "=" + multiframeTable + ".multiframeid and " + mergelogTable + "." + extName + "=mfd.extnum) ");
                    ++i;
                }
            }
            if (row > 0) {
                return sbSQL;
            }
            return null;
        }
        catch (SQLException se) {
            return null;
        }
    }

    public static StringBuffer getFSIDSQL(ResultSet rset, String mergelogTable, String multiframeTable, int archiveID) {
        StringBuffer sbSQL = new StringBuffer("");
        Object mfidName = null;
        Object extName = null;
        String bandMFID = null;
        String bandEnum = null;
        int row = 0;
        boolean first = true;
        try {
            while (rset.next()) {
                ++row;
                bandMFID = rset.getString("bandMFID");
                bandEnum = bandMFID.toLowerCase().replaceAll("mfid", "enum");
                if (!first) {
                    sbSQL.append(" or ");
                }
                first = false;
                sbSQL.append("(" + mergelogTable + "." + bandMFID + "=" + multiframeTable + ".multiframeid and " + mergelogTable + "." + bandEnum + "=mfd.extnum) ");
            }
            if (row > 0) {
                return sbSQL;
            }
            return null;
        }
        catch (SQLException se) {
            return null;
        }
    }

    public static StringBuffer getFramesetSQL(ResultSet rset, String mergelogTable, String multiframeTable, int archiveID, String framesetID) {
        StringBuffer sbSQL = new StringBuffer("");
        String mfidName = null;
        String extName = null;
        int row = 0;
        boolean first = true;
        try {
            while (rset.next()) {
                ++row;
                int filterid = rset.getInt("filterid");
                int npass = rset.getInt("npass");
                if (npass == 1) {
                    mfidName = String.valueOf(VDFSSchema.getFilterName(filterid, archiveID)) + "mfid";
                    extName = String.valueOf(VDFSSchema.getFilterName(filterid, archiveID)) + "enum";
                    if (!first) {
                        sbSQL.append(" union ");
                    }
                    first = false;
                    sbSQL.append("select " + mfidName + " as mfid," + extName + " as eNum from " + mergelogTable + " where framesetID= " + framesetID);
                    continue;
                }
                if (npass <= 1) continue;
                int i = 0;
                while (i < npass) {
                    mfidName = String.valueOf(VDFSSchema.getFilterName(filterid, archiveID)) + "_" + (i + 1) + "mfid";
                    extName = String.valueOf(VDFSSchema.getFilterName(filterid, archiveID)) + "_" + (i + 1) + "enum";
                    if (!first) {
                        sbSQL.append(" union ");
                    }
                    first = false;
                    sbSQL.append("select " + mfidName + " as mfid," + extName + " as eNum from " + mergelogTable + " where framesetID= " + framesetID);
                    ++i;
                }
            }
            if (row > 0) {
                return sbSQL;
            }
            return null;
        }
        catch (SQLException se) {
            return null;
        }
    }

    public static StringBuffer getFSIDSQL(ResultSet rset, String mergelogTable, String multiframeTable, int archiveID, String framesetID) {
        StringBuffer sbSQL = new StringBuffer("");
        Object mfidName = null;
        Object extName = null;
        String bandMFID = null;
        String bandEnum = null;
        int row = 0;
        boolean first = true;
        try {
            while (rset.next()) {
                ++row;
                bandMFID = rset.getString("bandMFID");
                bandEnum = bandMFID.toLowerCase().replaceAll("mfid", "enum");
                if (!first) {
                    sbSQL.append(" union ");
                }
                first = false;
                sbSQL.append("select " + bandMFID + " as mfid," + bandEnum + " as eNum from " + mergelogTable + " where framesetID= " + framesetID);
            }
            if (row > 0) {
                return sbSQL;
            }
            return null;
        }
        catch (SQLException se) {
            return null;
        }
    }

    public static String getLoginDetailsSQL(String category, String emailAddress, String archive) {
        if (archive != null && archive.equalsIgnoreCase("VSA")) {
            return null;
        }
        if (category != null && category.equalsIgnoreCase("ukidss")) {
            return "select username,password,community from wsa_users where email like '" + emailAddress.trim() + "'";
        }
        if (category != null && category.equalsIgnoreCase("nonsurvey")) {
            return "select username,password,community from wsa_nonSurveyUsers where email like '" + emailAddress.trim() + "'";
        }
        return null;
    }

    public static String getNSDBs(String user, int archiveID) {
        if (archiveID == 2) {
            return SQLMethods.getProjectDBs(user);
        }
        return SQLMethods.getNSDBs(user);
    }

    public static String getProjectDBs(String user) {
        if (!user.equalsIgnoreCase("vvv")) {
            return "select name from master.dbo.sysdatabases where name like '" + user + "v2%'  order by name desc";
        }
        return "select name from master.dbo.sysdatabases where name like '" + user + "%'  order by crdate desc";
    }

    public static String getNSDBs(String user, int archiveID, String community) {
        if (archiveID == 4) {
            if (community.toLowerCase().indexOf("beta") >= 0) {
                return "select name from master.dbo.sysdatabases where name like '" + user + "%' or name like'" + user + "' order by name desc";
            }
            return "select name from master.dbo.sysdatabases where (name like '" + user + "%' or name like'" + user + "') and name not like '%beta%' order by crdate desc";
        }
        if (community.toLowerCase().indexOf("beta") >= 0) {
            return "select name from master.dbo.sysdatabases where name like '" + user + "v%' or name like'" + user + "' order by name desc";
        }
        return "select name from master.dbo.sysdatabases where (name like '" + user + "v%' or name like'" + user + "') and name not like '%beta%' order by name desc";
    }

    public static String getNSDBs(String user) {
        if (user != null && !user.equalsIgnoreCase("uhs")) {
            return "select name from master.dbo.sysdatabases where name like '" + user + "v2%' or name like'" + user + "' order by name desc";
        }
        return "select name from master.dbo.sysdatabases where name like '" + user + "v2%' or name like'" + user + "%' order by name desc";
    }

    public static String getNSFilterIDSQL(String database, String user) {
        return "select filterID,npass from " + database + "..programme as p," + database + "..requiredfilters as rf " + "where p.programmeid=rf.programmeid and detectionTable = '" + user + "Detection'";
    }

    public static String getNSFilterIDSQL(String database) {
        return "select filterID,npass from " + database + "..programme as p," + database + "..requiredfilters as rf " + "where p.programmeid=rf.programmeid and p.programmeid > 1000";
    }

    public static String getUpdateQStatusSQLURL(int qID, int qStatus, String resultsURL) {
        return "exec userInterface..spUpdateQStatusAndURL " + qID + "," + qStatus + ",'" + resultsURL + "'";
    }

    public static String getUpdateQStatusSQL(int qID, int qStatus) {
        return "exec userInterface..spUpdateQStatus " + qID + "," + qStatus;
    }

    public static String checkQueryPlan(Statement stmt, String SQL) throws SQLException {
        StringBuffer warnings = new StringBuffer("");
        stmt.executeUpdate("SET SHOWPLAN_ALL ON");
        ResultSet rs = stmt.executeQuery(SQL);
        ResultSetMetaData rsmd = rs.getMetaData();
        int noCols = rsmd.getColumnCount();
        long maxRows = 0L;
        while (rs.next()) {
            if (rs.getLong("estimaterows") > maxRows) {
                maxRows = rs.getLong("estimaterows");
            }
            if (rs.getString("warnings") == null) continue;
            if (rs.getString("warnings").indexOf("NO STATS") >= 0) {
                QueryRetrieverThread.logger.info((Object)("MISSING STATS: " + rs.getString("warnings")));
                continue;
            }
            warnings.append(" Warning: [");
            warnings.append(rs.getString("warnings"));
            warnings.append("] \n");
        }
        stmt.executeUpdate("SET SHOWPLAN_ALL OFF");
        if (maxRows > 100000000L && !SQL.matches("(?i).*count.*") || maxRows > 10000000000L) {
            warnings.append(" Warning: [Part of query estimated to return ");
            warnings.append(maxRows);
            warnings.append(" rows, check you have joined the tables in your query?] ");
        }
        if (warnings.length() > 1) {
            return warnings.toString();
        }
        return null;
    }

    public static void checkValidSQL(Statement stmt, String SQL) throws SQLException {
        stmt.executeUpdate("set noexec on");
        stmt.executeUpdate(SQL);
        stmt.executeUpdate("set noexec off");
        stmt = null;
    }

    public static void checkValidSQL(Connection conn, String SQL) throws SQLException {
        Statement stmt = conn.createStatement();
        stmt.executeUpdate("set noexec on");
        stmt.executeUpdate(SQL);
        stmt.executeUpdate("set noexec off");
        stmt = null;
        conn = null;
    }

    public static ResultSetMetaData browseSQL(Connection conn, String SQL) throws SQLException {
        try {
            String pSQL;
            int commentPos = SQL.indexOf("--");
            if (commentPos < 0) {
                commentPos = SQL.length();
            }
            if (!((pSQL = SQL.substring(0, commentPos)).matches("(?i).*amenhotep\\..*") || pSQL.matches("(?i).*thutmose\\..*") || pSQL.matches("(?i).*sql6df\\..*"))) {
                pSQL = String.valueOf(pSQL) + " for browse";
            }
            PreparedStatement pstmt = conn.prepareStatement(pSQL);
            conn = null;
            return pstmt.getMetaData();
        }
        catch (Exception e) {
            WSASQLRetrieverThread.logger.error((Object)e);
            return null;
        }
    }

    public static String parseSQL(String SQL) throws Exception {
        return SQLMethods.parseSQL(SQL, MAXLENGTH);
    }

    public static String removeComments(String tmpParsedSQL) {
        StringBuffer parsedSQLSB = new StringBuffer(tmpParsedSQL);
        boolean checkForComments = true;
        int sP = 0;
        while (checkForComments) {
            int sC = parsedSQLSB.indexOf("/*", sP);
            if (sC >= 0) {
                int eC = parsedSQLSB.indexOf("*/", sC);
                if (sC >= 0 && eC > sC) {
                    parsedSQLSB.delete(sC, eC + 2);
                    continue;
                }
                checkForComments = false;
                continue;
            }
            checkForComments = false;
        }
        return parsedSQLSB.toString().trim();
    }

    public static String parseSQL(String SQL, int maxLength) throws Exception {
        String tmpPSQL;
        boolean parsed = true;
        String parsedSQL = SQL.trim();
        parsedSQL = parsedSQL.replaceAll("\r?\n", " ");
        parsedSQL = parsedSQL.replace('\"', '\'');
        StringBuffer sb = new StringBuffer("");
        parsedSQL = parsedSQL.replaceAll("(?i)\\sxp_|\\ssp_|\\sfn_|\\sms_|\\sdt_|\\.xp_|\\.sp_|\\.fn_|\\.ms_|\\.dt_", " as#");
        if (SQL.length() > maxLength) {
            sb.append("SQL query string length greater than " + maxLength + " characters.");
            parsed = false;
        }
        if ((tmpPSQL = SQLMethods.removeComments(parsedSQL)).toLowerCase().indexOf("with") != 0 && tmpPSQL.toLowerCase().indexOf("select") != 0 && tmpPSQL.toLowerCase().indexOf("exec userinterface..") != 0) {
            sb.append("Query must start with a select statement");
            parsed = false;
        }
        tmpPSQL = null;
        if (!parsed) {
            throw new Exception(sb.toString());
        }
        return parsedSQL;
    }

    public static String getWebqueriesString(String SQLQuery, int row, long elapsedTime, String user, String ipAddress) {
        return "exec dbo.spUpdateWebqueries  '" + SQLQuery.substring(0, Math.min(SQLQuery.length(), WEBQUERIESLENGTH)).replaceAll("\r?\n", " ").replaceAll("'", "''") + " '," + row + "," + elapsedTime + ",'" + user + "','" + ipAddress + "'";
    }

    public static String getWebqueriesString(String SQLQuery, int row, long elapsedTime, String user, String ipAddress, String dbName) {
        return "exec userInterface..spUpdateWebqueries  '" + SQLQuery.substring(0, Math.min(SQLQuery.length(), WEBQUERIESLENGTH)).replaceAll("\r?\n", " ").replaceAll("'", "''") + " '," + row + "," + elapsedTime + ",'" + user + "','" + ipAddress + "','" + dbName + "'";
    }

    public static String getWebqueriesString(String SQLQuery, int row, long elapsedTime, String user, String ipAddress, String dbName, int row_size) {
        return "exec userInterface..spUpdateWebqueries  '" + SQLQuery.substring(0, Math.min(SQLQuery.length(), WEBQUERIESLENGTH)).replaceAll("\r?\n", " ").replaceAll("'", "''") + " '," + row + "," + elapsedTime + ",'" + user + "','" + ipAddress + "','" + dbName + "'," + row_size;
    }

    public static String getWSACrossIDSQL(String select, String tableName, String colID, String extraFrom, String extraWhere) {
        return "SELECT #upload.*,#proxtab.distance," + select + " \nFROM  #upload left outer join #proxtab on #upload.upload_id=upid " + "left outer join " + tableName + " on " + tableName + "." + colID + "=archiveID " + extraFrom + " " + extraWhere + " \norder by upload_id";
    }

    public static String getPhotomSQL(String select, String ra, String dec, int progID) {
        StringBuffer sb = new StringBuffer(select);
        sb.append(",illumfile,catname");
        sb.append(" from Multiframe as mf, Multiframedetector as mfd, currentastrometry as ca, filter as f, ");
        sb.append(String.valueOf(WSASchema.getMergeTableName(progID)) + " as ml ");
        sb.append(" where mf.multiframeId=mfd.multiframeId and mf.multiframeId=ca.multiframeId and mfd.extNum=ca.extNum and f.filterid=mf.filterid ");
        sb.append(" and ((" + ra + " >= minRA and " + ra + " <= maxRA)" + " or (" + ra + " + 360.0 >= minRA and " + ra + " + 360.0 <= maxRA))" + " and ( " + dec + " >= minDec and " + dec + " <= maxDec)");
        String[] bands = WSASchema.getBands(progID);
        sb.append(" and (");
        int i = 0;
        while (i < bands.length) {
            sb.append(" (ml." + bands[i] + "mfid=mfd.multiframeId and ml." + bands[i] + "enum=mfd.extnum) ");
            if (i < bands.length - 1) {
                sb.append(" or ");
            }
            ++i;
        }
        sb.append(") order by mf.filterID");
        return sb.toString();
    }

    public static String getColourRegionSQL(String raL, String raH, String decL, String decH, String[] RGB, String mergelog) {
        return SQLMethods.getColourRegionSQL(raL, raH, decL, decH, RGB, mergelog, 1);
    }

    public static String getColourRegionSQL(String raL, String raH, String decL, String decH, String[] RGB, String mergelog, int archiveID) {
        StringBuffer sb = new StringBuffer("select ml.framesetid");
        int i = 0;
        while (i < RGB.length) {
            sb.append(", mf" + COLOURS[i] + ".filename as " + COLOURS[i] + "file");
            sb.append(", mfd" + COLOURS[i] + ".extnum as " + COLOURS[i] + "extnum");
            sb.append(", mf" + COLOURS[i] + ".exptime as " + COLOURS[i] + "exptime");
            if (archiveID != 3) {
                sb.append(", mf" + COLOURS[i] + ".nustep as " + COLOURS[i] + "nustep");
            } else {
                sb.append(", 1  as " + COLOURS[i] + "nustep");
            }
            if (archiveID != 3) {
                sb.append(", mf" + COLOURS[i] + ".njitter as " + COLOURS[i] + "njitter");
            } else {
                sb.append(", 1 as " + COLOURS[i] + "njitter");
            }
            sb.append(", mfd" + COLOURS[i] + ".photzpcat as " + COLOURS[i] + "photzpcat ");
            sb.append(", mf" + COLOURS[i] + ".filterID as " + COLOURS[i] + "filterID \n");
            ++i;
        }
        sb.append("from ( select framesetid from currentastrometry as ca, " + mergelog + " as ml where ");
        i = 0;
        while (i < RGB.length) {
            sb.append(String.valueOf(RGB[i]) + "mfid > 0 and ");
            ++i;
        }
        sb.append("( (ca.multiframeid=ml." + RGB[0] + "mfid and ca.extnum=ml." + RGB[0] + "enum) and ( \n");
        sb.append("(minRA <= " + raL + " and maxRA >= " + raL + ") or (minRA >= " + raL + " and minRA <= " + raH + ") or (minRA <= " + raH + " and maxRA >= " + raH + ") or (minRA >= " + raL + "-360 and minRA <= " + raH + "-360) or (minRA <= " + raL + "+360 and maxRA >= " + raL + "+360) ) \n");
        sb.append(" and ( (minDec <= " + decL + " and maxDec >= " + decL + ") or (minDec >= " + decL + " and minDec <= " + decH + ") ) ) )as t , \n");
        sb.append(String.valueOf(mergelog) + " as ml ");
        i = 0;
        while (i < RGB.length) {
            sb.append(" ,multiframe as mf" + COLOURS[i]);
            sb.append(" ,multiframedetector as mfd" + COLOURS[i]);
            ++i;
        }
        sb.append(" where ml.framesetid=t.framesetid ");
        i = 0;
        while (i < RGB.length) {
            sb.append("  and mf" + COLOURS[i] + ".multiframeid=mfd" + COLOURS[i] + ".multiframeid ");
            sb.append(" and (ml." + RGB[i] + "mfid = mf" + COLOURS[i] + ".multiframeid and ml." + RGB[i] + "enum=mfd" + COLOURS[i] + ".extnum)");
            ++i;
        }
        return sb.toString();
    }

    public static int getSizeOfRS(ResultSetMetaData rsmd) {
        int recordLength = 0;
        try {
            int i = 0;
            while (i < rsmd.getColumnCount()) {
                switch (rsmd.getColumnType(i + 1)) {
                    case -6: {
                        ++recordLength;
                        break;
                    }
                    case 5: {
                        recordLength += 2;
                        break;
                    }
                    case 7: {
                        recordLength += 4;
                        break;
                    }
                    case 6: {
                        recordLength += 8;
                        break;
                    }
                    case 8: {
                        recordLength += 8;
                        break;
                    }
                    case 4: {
                        recordLength += 4;
                        break;
                    }
                    case 12: {
                        recordLength += rsmd.getPrecision(i + 1);
                        break;
                    }
                    case 1: {
                        recordLength += rsmd.getPrecision(i + 1);
                        break;
                    }
                    case -5: {
                        recordLength += 8;
                        break;
                    }
                    case 91: {
                        recordLength += 8;
                        break;
                    }
                    case 93: {
                        recordLength += 8;
                        break;
                    }
                    case 2: {
                        recordLength += 8;
                        break;
                    }
                    case 3: {
                        recordLength += 8;
                        break;
                    }
                    default: {
                        recordLength += 4;
                    }
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        rsmd = null;
        return recordLength;
    }
}

