/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.roe.wfau;

import java.util.Calendar;

public class SatelliteFunctions {
    private static final int YEAR = 0;
    private static final int MONTH = 1;
    private static final int DAY = 2;
    private static final int HOURS = 3;
    private static final int MINUTES = 4;
    private static final int SECONDS = 5;
    private static final int MILLIS = 6;

    public static double getEpochTLE(Calendar cal) {
        double tle_epoch = 0.0;
        int year = cal.get(1);
        if ((year -= 2000) < 0) {
            year += 100;
        }
        tle_epoch = (double)(year * 1000 + cal.get(6)) + (double)cal.get(11) / 24.0;
        return tle_epoch;
    }

    public static double toMJD(int[] ymd_hms) {
        int y = ymd_hms[0];
        int m = ymd_hms[1];
        double d = ymd_hms[2];
        d += (double)ymd_hms[3] / 24.0 + (double)ymd_hms[4] / 1440.0 + (double)ymd_hms[5] / 86400.0 + (double)ymd_hms[6] / 8.64E7;
        if (m == 1 || m == 2) {
            --y;
            m += 12;
        }
        double a = Math.floor(y / 100);
        double b = 2.0 - a + Math.floor(a / 4.0);
        return Math.floor(365.25 * ((double)y + 4716.0)) + Math.floor(30.6001 * (double)(m + 1)) + d + b - 1524.5 - 2400000.5;
    }

    public static int[] toTimestamp(double mjd) {
        int a;
        int[] ymd_hms = new int[]{-1, -1, -1, -1, -1, -1, -1};
        double jd = mjd + 2400000.5 + 0.5;
        int z = (int)Math.floor(jd);
        double f = jd - (double)z;
        if (z >= 2299161) {
            int alpha = (int)Math.floor(((double)z - 1867216.25) / 36524.25);
            a = z + 1 + alpha - (int)Math.floor(alpha / 4);
        } else {
            a = z;
        }
        int b = a + 1524;
        int c = (int)Math.floor(((double)b - 122.1) / 365.25);
        int d = (int)Math.floor(365.25 * (double)c);
        int e = (int)Math.floor((double)(b - d) / 30.6001);
        ymd_hms[2] = b - d - (int)Math.floor(30.6001 * (double)e);
        ymd_hms[1] = e < 14 ? e - 1 : e - 13;
        ymd_hms[0] = ymd_hms[1] > 2 ? c - 4716 : c - 4715;
        int i = 3;
        while (i <= 6) {
            switch (i) {
                case 3: {
                    f *= 24.0;
                    break;
                }
                case 4: 
                case 5: {
                    f *= 60.0;
                    break;
                }
                case 6: {
                    f *= 1000.0;
                }
            }
            double x = Math.floor(f);
            ymd_hms[i] = (int)x;
            f -= x;
            ++i;
        }
        return ymd_hms;
    }

    public static double LMST(double MJD, double longitude) {
        double MJD0 = Math.floor(MJD);
        double UT = (MJD - MJD0) * 24.0;
        double T = (MJD0 - 51544.5) / 36525.0;
        double GMST = 6.697374558 + 1.0027379093 * UT + (8640184.812866 + (0.093104 - 6.2E-6 * T) * T) * T / 3600.0;
        double LMST = 24.0 * SatelliteFunctions.FRAC((GMST + longitude / 15.0) / 24.0);
        return LMST;
    }

    public static double FRAC(double value) {
        double result = value - SatelliteFunctions.TRUNC(value);
        if (result < 0.0) {
            result += 1.0;
        }
        return result;
    }

    public static double TRUNC(double value) {
        double result = Math.floor(Math.abs(value));
        if (value < 0.0) {
            result = -result;
        }
        return result;
    }
}

