/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.roe.wfau;

import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class ScatterPlotToFile {
    private double[][] xydata;
    private String filename;

    public ScatterPlotToFile(double[][] xydata, String filename) {
        this.xydata = xydata;
        this.filename = filename;
    }

    public static void main(String[] args) {
        XYSeries series = new XYSeries((Comparable)((Object)"Test Data"));
        series.add(0.058333333333333334, 18.251567840576172);
        series.add(0.06666666666666667, 18.32216453552246);
        series.add(0.09166666666666666, 2.476291662324533E26);
        series.add(0.1, 18.553701400756836);
        series.add(0.10833333333333334, 18.60835838317871);
        series.add(0.11666666666666667, 18.66070556640625);
        XYSeriesCollection data = new XYSeriesCollection(series);
        JFreeChart chart = ChartFactory.createScatterPlot((String)"Scatter Plot Demo 3", (String)"X", (String)"Y", (XYDataset)data, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        NumberAxis domainAxis = (NumberAxis)chart.getXYPlot().getDomainAxis();
        domainAxis.setAutoRangeIncludesZero(false);
        ChartPanel chartPanel = new ChartPanel(chart);
        NumberAxis rangeAxis = (NumberAxis)chart.getXYPlot().getRangeAxis();
        rangeAxis.setAutoRange(true);
        rangeAxis.setVisible(true);
        domainAxis.setVisible(true);
        NumberTickUnit ntu = rangeAxis.getTickUnit();
        System.out.print(ntu.getSize());
        rangeAxis.setAutoTickUnitSelection(true);
        ntu = rangeAxis.getTickUnit();
        System.out.print(ntu.getSize());
        rangeAxis.setTickUnit(new NumberTickUnit(1.0E25, (NumberFormat)new DecimalFormat("0E0")));
        rangeAxis.setTickMarksVisible(true);
        chartPanel.setVerticalAxisTrace(true);
        chartPanel.setHorizontalAxisTrace(true);
        chartPanel.setRangeZoomable(true);
        File file = new File("d:/temp.png");
        try {
            ChartUtilities.saveChartAsPNG((File)file, (JFreeChart)chart, (int)800, (int)600);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

