/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.roe.wfau;

import net.mar.SLALIB;

public class TangentRectangle {
    double pi = 4.0 * Math.atan(1.0);
    static double RADIAN = 57.29577951308232;
    static double latitudeLimit = 90.0;
    double longitudeZ = 0.0;
    double latitudeZ = 0.0;
    double minLongitude = 0.0;
    double maxLongitude = 0.0;
    double minLatitude = 0.0;
    double maxLatitude = 0.0;

    public TangentRectangle(double longitude, double latitude, double radius) {
        this.longitudeZ = longitude / RADIAN;
        this.latitudeZ = latitude / RADIAN;
        double xi = Math.abs(radius / (RADIAN * 60.0));
        double eta = Math.abs(radius / (RADIAN * 60.0));
        double ratio = eta / Math.tan(eta);
        this.minLatitude = Math.max(-90.0, (this.latitudeZ - eta) * RADIAN);
        this.maxLatitude = Math.min(90.0, (this.latitudeZ + eta) * RADIAN);
        if (this.minLatitude <= -latitudeLimit || this.maxLatitude >= latitudeLimit) {
            this.minLongitude = 0.0;
            this.maxLongitude = 360.0;
        } else if (this.latitudeZ >= 0.0) {
            double[] topLeft = SLALIB.DTP2S((double)(-xi / ratio), (double)0.0, (double)this.longitudeZ, (double)(this.maxLatitude / RADIAN));
            double[] topRight = SLALIB.DTP2S((double)(xi / ratio), (double)0.0, (double)this.longitudeZ, (double)(this.maxLatitude / RADIAN));
            this.minLongitude = topLeft[0] * RADIAN;
            this.maxLongitude = topRight[0] * RADIAN;
        } else {
            double[] botLeft = SLALIB.DTP2S((double)(-xi / ratio), (double)0.0, (double)this.longitudeZ, (double)(this.minLatitude / RADIAN));
            double[] botRight = SLALIB.DTP2S((double)(xi / ratio), (double)0.0, (double)this.longitudeZ, (double)(this.minLatitude / RADIAN));
            this.minLongitude = botLeft[0] * RADIAN;
            this.maxLongitude = botRight[0] * RADIAN;
        }
    }

    public TangentRectangle(double longitude, double latitude, double x, double y) {
        this.longitudeZ = longitude / RADIAN;
        this.latitudeZ = latitude / RADIAN;
        double xi = Math.abs(0.5 * x / (RADIAN * 60.0));
        double eta = Math.abs(0.5 * y / (RADIAN * 60.0));
        double ratio = eta / Math.tan(eta);
        double[] topLeft = SLALIB.DTP2S((double)(-xi), (double)eta, (double)this.longitudeZ, (double)this.latitudeZ);
        double[] topRight = SLALIB.DTP2S((double)xi, (double)eta, (double)this.longitudeZ, (double)this.latitudeZ);
        double[] topMid = SLALIB.DTP2S((double)0.0, (double)eta, (double)this.longitudeZ, (double)this.latitudeZ);
        double[] botLeft = SLALIB.DTP2S((double)(-xi), (double)(-eta), (double)this.longitudeZ, (double)this.latitudeZ);
        double[] botRight = SLALIB.DTP2S((double)xi, (double)(-eta), (double)this.longitudeZ, (double)this.latitudeZ);
        double[] botMid = SLALIB.DTP2S((double)0.0, (double)(-eta), (double)this.longitudeZ, (double)this.latitudeZ);
        double topMidLat = this.latitudeZ + eta;
        double botMidLat = this.latitudeZ - eta;
        this.maxLatitude = Math.max(topMidLat, Math.max(topMid[1], Math.max(topLeft[1], topRight[1])));
        this.minLatitude = Math.min(botMidLat, Math.min(botMid[1], Math.min(botLeft[1], botRight[1])));
        this.minLatitude *= RADIAN;
        this.maxLatitude *= RADIAN;
        this.minLatitude = Math.max(-90.0, this.minLatitude);
        this.maxLatitude = Math.min(90.0, this.maxLatitude);
        if (this.minLatitude <= -latitudeLimit || this.maxLatitude >= latitudeLimit) {
            this.minLongitude = 0.0;
            this.maxLongitude = 360.0;
        } else if (this.latitudeZ >= 0.0) {
            this.minLongitude = topLeft[0] * RADIAN;
            this.maxLongitude = topRight[0] * RADIAN;
        } else {
            this.minLongitude = botLeft[0] * RADIAN;
            this.maxLongitude = botRight[0] * RADIAN;
        }
    }

    public double getMinLatitude() {
        return this.minLatitude;
    }

    public double getMaxLatitude() {
        return this.maxLatitude;
    }

    public double getMinLongitude() {
        return this.minLongitude;
    }

    public double getMaxLongitude() {
        return this.maxLongitude;
    }

    public String getRASQL() {
        if (this.minLongitude <= this.maxLongitude) {
            return "RA >= " + this.minLongitude + " and RA <= " + this.maxLongitude;
        }
        return "((RA >= " + this.minLongitude + " and RA <=360) or (RA >= 0 and RA <= " + this.maxLongitude + "))";
    }
}

