/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.roe.wfau;

import uk.ac.roe.wfau.OSASchema;
import uk.ac.roe.wfau.VSASchema;
import uk.ac.roe.wfau.WSASchema;

public class VDFSSchema {
    public static final String VSAARCHIVE = "VSA";
    public static final String WSAARCHIVE = "WSA";
    public static final String SSAARCHIVE = "SSA";
    public static final String OSAARCHIVE = "OSA";
    public static final String GESARCHIVE = "GES";
    public static final String LegacyARCHIVE = "Legacy";
    public static final int SSAARCHIVEID = 0;
    public static final int WSAARCHIVEID = 1;
    public static final int VSAARCHIVEID = 2;
    public static final int OSAARCHIVEID = 3;
    public static final int GESARCHIVEID = 4;
    public static final int LegacyARCHIVEID = 5;
    public static final String VSASUPPORT = "vsa-support@roe.ac.uk";
    public static final String WSASUPPORT = "wsa-support@roe.ac.uk";
    public static final String OSASUPPORT = "osa-support@roe.ac.uk";
    public static final String GESSUPPORT = "ges-support@roe.ac.uk";
    public static final String LegacySUPPORT = "mar@roe.ac.uk";
    public static final String[] EXTERNALSURVEYS = new String[]{"bestdr1..", "bestdr2..", "bestdr3..", "bestdr5..", "bestdr7..", "bestdr8..", "seguedr6..", "ssa.."};
    public static final String[] ALLSQLSERVERS = new String[]{"amenhotep", "ahmose", "thutmose", "hatshepsut", "ramses1", "ramses2", "ramses3", "ramses4", "ramses5", "ramses6", "ramses7", "ramses8", "ramses9", "ramses10", "ramses11", "ramses12", "ramses13", "ramses14", "ramses15", "ramses17", "ramses18", "ramses19", "ramses20", "ramses21", "ramses25", "ramses26", "ramses27", "blabheinn"};
    public static final String UPLOADTABLE = "#userTable";

    public static String getTempBaseURL(String tUrl, String archive) {
        if (archive.equalsIgnoreCase("vsa") && tUrl.contains("vsa")) {
            return String.valueOf(tUrl) + "tmp/";
        }
        if (archive.equalsIgnoreCase("wsa") && (tUrl.contains("wsa") || tUrl.contains("elara"))) {
            return String.valueOf(tUrl) + "tmp/";
        }
        if (archive.equalsIgnoreCase("legacy") && tUrl.contains("legacy")) {
            return String.valueOf(tUrl) + "tmp/";
        }
        if (archive.equalsIgnoreCase("osa") && tUrl.contains("vst")) {
            return String.valueOf(tUrl) + "tmp/";
        }
        return String.valueOf(tUrl) + archive.toLowerCase() + "/tmp/";
    }

    public static int getPositionInArray(String str, String[] strArray) {
        int i = 0;
        while (i < strArray.length) {
            if (strArray[i].equalsIgnoreCase(str)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int getPositionInArray(int si, int[] intArray) {
        int i = 0;
        while (i < intArray.length) {
            if (si == intArray[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static String getDateFromFile(String filename, int archiveID) {
        if (filename.toLowerCase().contains("_dp_")) {
            return "multi-epoch deep";
        }
        if (archiveID == 1) {
            int pos = filename.lastIndexOf("/w20");
            if (pos > 0) {
                return filename.substring(pos + 2, pos + 10);
            }
            return "";
        }
        if (archiveID == 2) {
            int pos = filename.lastIndexOf("/v20");
            if (pos > 0) {
                return filename.substring(pos + 2, pos + 10);
            }
            return "";
        }
        return "";
    }

    public static int getArchiveID(String archive) {
        if (archive.equalsIgnoreCase(VSAARCHIVE)) {
            return 2;
        }
        if (archive.equalsIgnoreCase(SSAARCHIVE)) {
            return 0;
        }
        if (archive.equalsIgnoreCase(OSAARCHIVE)) {
            return 3;
        }
        if (archive.equalsIgnoreCase(GESARCHIVE)) {
            return 4;
        }
        if (archive.equalsIgnoreCase(LegacyARCHIVE)) {
            return 5;
        }
        return 1;
    }

    public static String getUCDOfCol(int archiveID, String col) {
        switch (archiveID) {
            case 1: {
                return WSASchema.getUCDofCol(col);
            }
            case 2: {
                return VSASchema.getUCDofCol(col);
            }
            case 3: {
                return null;
            }
            case 4: {
                return null;
            }
            case 5: {
                return null;
            }
        }
        return null;
    }

    public static String getDescOfCol(int archiveID, String col) {
        switch (archiveID) {
            case 1: {
                return WSASchema.getDescofCol(col);
            }
            case 2: {
                return VSASchema.getDescofCol(col);
            }
            case 3: {
                return null;
            }
            case 4: {
                return null;
            }
            case 5: {
                return null;
            }
        }
        return null;
    }

    public static String getSupportEmail(int archiveID) {
        switch (archiveID) {
            case 1: {
                return WSASUPPORT;
            }
            case 2: {
                return VSASUPPORT;
            }
            case 3: {
                return OSASUPPORT;
            }
            case 4: {
                return GESSUPPORT;
            }
            case 5: {
                return LegacySUPPORT;
            }
        }
        return WSASUPPORT;
    }

    public static String getAllSurveys(int archiveID) {
        switch (archiveID) {
            case 2: {
                return "All VISTA surveys";
            }
            case 3: {
                return "All VST surveys";
            }
        }
        return "All surveys";
    }

    public static String getFilterName(int filterID, int archiveID) {
        switch (archiveID) {
            case 2: {
                return VSASchema.getFilterName(filterID);
            }
            case 3: {
                return OSASchema.getFilterName(filterID);
            }
        }
        return WSASchema.getFilterName(filterID);
    }

    public static String getSourceViewName(int progID, int archiveID) {
        switch (archiveID) {
            case 2: {
                return VSASchema.getSourceViewName(progID);
            }
        }
        return WSASchema.getSourceViewName(progID);
    }

    public static String getSourceTableName(int progID, int archiveID) {
        switch (archiveID) {
            case 2: {
                return VSASchema.getSourceTableName(progID);
            }
            case 3: {
                return OSASchema.getSourceTableName(progID);
            }
        }
        return WSASchema.getSourceTableName(progID);
    }

    public static String getSynopticSourceTableName(int progID, int archiveID) {
        switch (archiveID) {
            case 2: {
                return VSASchema.getSynopticSourceTableName(progID);
            }
        }
        return null;
    }

    public static String getDetectionTableName(int progID, int archiveID) {
        switch (archiveID) {
            case 2: {
                return VSASchema.getDetectionTableName(progID);
            }
            case 3: {
                return OSASchema.getDetectionTableName(progID);
            }
        }
        return WSASchema.getDetectionTableName(progID);
    }

    public static int[] getReqFilters(String db, int progID, int archiveID) {
        switch (archiveID) {
            case 2: {
                return VSASchema.getReqFilters(db, progID);
            }
        }
        return WSASchema.getReqFilters(db, progID);
    }

    public static String getDefaultList(int[] reqFilters, String table, String database, int progID, int archiveID) {
        switch (archiveID) {
            case 2: {
                return VSASchema.getDefaultList(reqFilters, table, database, progID);
            }
        }
        return WSASchema.getDefaultList(reqFilters, table, database);
    }

    public static String getMergeTableName(int surveyID, String archive) {
        if (archive.equalsIgnoreCase("vsa")) {
            return VSASchema.getMergeTableName(surveyID);
        }
        if (archive.equalsIgnoreCase("osa")) {
            return OSASchema.getMergeTableName(surveyID);
        }
        return WSASchema.getMergeTableName(surveyID);
    }

    public static String getSurveyName(int progID, int archiveID) {
        switch (archiveID) {
            case 2: {
                return VSASchema.getSurveyName(progID);
            }
            case 3: {
                return OSASchema.getSurveyName(progID);
            }
        }
        return WSASchema.getSurveyName(progID);
    }

    public static String getSurveyShortName(int progID, int archiveID) {
        switch (archiveID) {
            case 2: {
                return VSASchema.getShortSurveyName(progID);
            }
            case 3: {
                return OSASchema.getShortSurveyName(progID);
            }
        }
        return WSASchema.getSurveyName(progID);
    }

    public static boolean isProprietary(String community) {
        return VSASchema.isProprietary(community);
    }

    public static boolean isProprietary(String community, int archiveID) {
        switch (archiveID) {
            case 2: {
                return VSASchema.isProprietary(community);
            }
            case 3: {
                return OSASchema.isProprietary(community);
            }
        }
        VSASchema.isProprietary(community);
        return false;
    }

    public static boolean isReserved(String community) {
        return community != null && (VDFSSchema.isProprietary(community) || community.toLowerCase().contains("nonSurvey".toLowerCase()));
    }
}

