/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.roe.wfau;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.Properties;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import net.alanmaxwell.html.HTMLStrings;
import net.alanmaxwell.sql.SQLDataFormatter;
import net.alanmaxwell.sql.SQLServerInfoJDBC;
import net.mar.ACSVWriter;
import net.mar.CancelThread;
import net.mar.FITSWriter;
import net.mar.FormatRS;
import net.mar.ParseCoords;
import net.mar.ParseVOT;
import net.mar.RetrieverManager;
import net.mar.RetrieverMapper;
import net.mar.UCDManager;
import org.apache.log4j.Logger;
import uk.ac.roe.wfau.HTMLFormatter;
import uk.ac.roe.wfau.SQLMethods;
import uk.ac.roe.wfau.ShowCols;
import uk.ac.roe.wfau.StringToRADec;

public class WFAUSQLRetrieverThread
implements Runnable {
    public static final int SQLROWS_DEFAULT = 30;
    public static final int HTMLROWS_UPPERLIMIT = 1000;
    public static final int MAXHTMLCELLS = 10000;
    public static final int MAXRESBUFFERSIZE = 0x100000;
    public static final int ROWSWRITTEN_UPPERLIMIT = 15000000;
    public static final int FACTOR = 2;
    public static Logger logger = Logger.getLogger((String)"uk.ac.roe.wfau.WFAUSQLRetrieverThread");
    public static final int MAXTIMEOUT = 4800;
    public static final int OUTPUT_NONE = 0;
    public static final int OUTPUT_CSV = 1;
    public static final int OUTPUT_FITS = 2;
    public static final int OUTPUT_VOT = 3;
    public static final int COMPRESS_NONE = 0;
    public static final int COMPRESS_ZIP = 1;
    public static final int COMPRESS_GZIP = 2;
    public String uploadFile = null;
    public BufferedReader uploadBufferedReader;
    public static final int OUTPUT_BUFFERSIZE = 524288;
    private static UCDManager ucdMgr;
    private static RetrieverManager retMgr;
    private static RetrieverMapper retMap;
    protected Connection databaseConnection = null;
    protected Statement databaseQuery = null;
    protected ResultSet results = null;
    protected ResultSetMetaData resultsMetaData = null;
    protected int row = 0;
    protected int rowsTotalUpperLimit = 0;
    protected int rowsWrittenUpperLimit = 0;
    protected int rowsWrittenToFile = 0;
    protected int rowsWrittenToHTML = 0;
    protected int resultsNumColumns = 0;
    String database = "database";
    protected String columnData = "";
    String resultsURL = "";
    int qID = -1;
    boolean AnySQLErrors = false;
    public String databaseURL = null;
    boolean[] doShowBooleans;
    boolean[] showBooleans;
    String[][] showColumns;
    public static String[] showMFArr;
    public static String[] showGIFArr;
    public static String[] showGIMArr;
    public boolean doShowMF = true;
    public boolean doShowGIF = true;
    public boolean doShowGIM = true;
    boolean showMF = false;
    boolean showGIF = false;
    boolean showGIM = false;
    public boolean showSQL = false;
    public String extraHTMLMsg = "";
    public boolean doCancelThread = false;
    public int timeout = 4800;
    public boolean updateWebqueries = false;
    protected String[] columnNames = null;
    protected SQLDataFormatter[] columnFormats = null;
    FormatRS frs = new FormatRS();
    FITSWriter fw = null;
    String CSVName = "";
    String CSVFileName = "";
    String FITSName = "";
    String FITSFileName = "";
    String savedFilename = "";
    String fileDescr = null;
    String emailAddress = null;
    long startTime = 0L;
    String startTimeStr;
    private static final int CVSNUM_UPPERLIMIT = 60000;
    private static int CSVNumber;
    protected SQLServerInfoJDBC serverInfo = null;
    String xDB;
    String xTable;
    String xSelect;
    String xWhere;
    String xID;
    double xRadius;
    int xNearest;
    protected boolean queryTerminated = false;
    protected boolean queryProcessing = true;
    boolean mightBeBackground = false;
    protected String radius = "0";
    protected String pair = "nearest";
    protected int rowsHTML = 30;
    protected boolean doRowTotal = true;
    protected String SQLQuery = null;
    String user = null;
    String ipAddress = null;
    protected int dataOutputFormat = 0;
    protected int dataOutputCompression = 0;
    protected StringBuffer htmlResults = new StringBuffer("");
    protected String HTMLTableRowColorHeader = "#FFFFCC";
    protected String HTMLTableRowColorOdd = "#FFDDDD";
    protected String HTMLTableRowColorEven = "#DDDDDD";
    protected String outputBaseDIR = "";
    protected String outputBaseURL = "";
    protected String outputAppendage = "";

    static {
        showMFArr = new String[]{"multiframeid", "filename", "numdetectors", "compfile"};
        showGIFArr = new String[]{"framesetID", "ra", "dec"};
        showGIMArr = new String[]{"multiframeID", "ra", "dec"};
        try {
            Class.forName("com.microsoft.jdbc.sqlserver.SQLServerDriver");
            Class.forName("net.sourceforge.jtds.jdbc.Driver");
        }
        catch (ClassNotFoundException e) {
            System.err.println("SQLRetrieverThread::static(): Could not load SQLServerDriver class!");
        }
        CSVNumber = 0;
    }

    public void setDoShowBooleans(boolean[] doShowBooleans) {
        this.doShowBooleans = doShowBooleans;
    }

    public void setShowBooleans(boolean[] showBooleans) {
        this.showBooleans = showBooleans;
    }

    public void setShowColumns(String[][] showColumns) {
        this.showColumns = showColumns;
    }

    private static synchronized int getNextCSVNumber() {
        if (++CSVNumber > 60000) {
            CSVNumber = 0;
        }
        return CSVNumber;
    }

    public WFAUSQLRetrieverThread(SQLServerInfoJDBC newServerInfo) {
        this.setServerInfo(newServerInfo);
    }

    public void setQID(int qID) {
        this.qID = qID;
    }

    public String getResultsURL() {
        return this.resultsURL;
    }

    public void setDatabaseName(String database) {
        this.database = database;
    }

    public WFAUSQLRetrieverThread(String dbURL) {
        this.databaseURL = dbURL;
    }

    protected synchronized void setServerInfo(SQLServerInfoJDBC newServerInfo) {
        this.serverInfo = newServerInfo;
    }

    public synchronized void setUploadFile(String newUploadFile) {
        this.uploadFile = newUploadFile;
    }

    public void setCrossIDParameters(String xDB, String xTable, String xSelect, String xWhere, String xID, double xRadius, int xNearest) {
        this.xDB = xDB;
        this.xTable = xTable;
        this.xSelect = xSelect;
        this.xWhere = xWhere;
        this.xRadius = xRadius;
        this.xNearest = xNearest;
        this.xID = xID;
    }

    public synchronized void setUpBufferedReader(BufferedReader newUpBufferedReader) {
        BufferedReader uploadBufferedReader = newUpBufferedReader;
    }

    public synchronized void setQueryTerminated(boolean status) {
        this.queryTerminated = status;
    }

    public boolean isQueryTerminated() {
        return this.queryTerminated;
    }

    public synchronized void setDBConnectionClosed() {
        if (this.databaseConnection != null) {
            System.out.println("im closing");
            try {
                this.databaseQuery.setQueryTimeout(1);
            }
            catch (SQLException se) {
                System.out.println(se);
            }
        }
    }

    public synchronized void setQueryProcessing(boolean status) {
        this.queryProcessing = status;
    }

    public synchronized boolean isQueryProcessing() {
        return this.queryProcessing;
    }

    public synchronized void setMightBeBackground(boolean newMBB) {
        this.mightBeBackground = newMBB;
    }

    public synchronized boolean isMightBeBackground() {
        return this.mightBeBackground;
    }

    public synchronized void setEmailAddress(String newEmailAddress) {
        this.emailAddress = newEmailAddress;
    }

    public synchronized String getEmailAddress() {
        return this.emailAddress;
    }

    public synchronized void setRadius(String newRadius) {
        this.radius = newRadius;
    }

    public synchronized void setPair(String newPair) {
        this.pair = newPair;
    }

    public synchronized void setRowsHTML(int newRows) {
        this.rowsHTML = newRows > 1000 ? 1000 : (newRows < 0 ? 0 : newRows);
    }

    public synchronized int getRowsHTML() {
        return this.rowsHTML;
    }

    public synchronized int getRowsReturned() {
        return this.row;
    }

    public synchronized boolean getDoRowTotal() {
        return this.doRowTotal;
    }

    public synchronized void setDoRowTotal(boolean status) {
        this.doRowTotal = status;
    }

    public synchronized void setSQLQuery(String newQuery) {
        this.SQLQuery = newQuery;
        this.setQueryProcessing(true);
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setIPAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public synchronized String getSQLQuery() {
        return this.SQLQuery;
    }

    public synchronized void setOutputFormat(int newFormat) {
        this.dataOutputFormat = newFormat;
    }

    public synchronized int getOutputFormat() {
        return this.dataOutputFormat;
    }

    public synchronized void setOutputCompression(int newCompression) {
        this.dataOutputCompression = newCompression;
    }

    public synchronized int getOutputCompression() {
        return this.dataOutputCompression;
    }

    protected synchronized void clearResultsHTML() {
        this.htmlResults = new StringBuffer("");
    }

    protected synchronized void addToResultsHTML(String newLine) {
        this.htmlResults.append(newLine);
    }

    public synchronized String getResultsHTML() {
        return this.htmlResults.toString();
    }

    public synchronized void setHTMLTableColorRowHeader(String newColor) {
        this.HTMLTableRowColorHeader = newColor;
    }

    public synchronized String getHTMLTableColorRowHeader() {
        return this.HTMLTableRowColorHeader;
    }

    public synchronized void setHTMLTableColorRowOdd(String newColor) {
        this.HTMLTableRowColorOdd = newColor;
    }

    public synchronized String getHTMLTableColorRowOdd() {
        return this.HTMLTableRowColorOdd;
    }

    public synchronized void setHTMLTableColorRowEven(String newColor) {
        this.HTMLTableRowColorEven = newColor;
    }

    public synchronized String getHTMLTableColorRowEven() {
        return this.HTMLTableRowColorEven;
    }

    public synchronized void setOutputBaseDIR(String newDir) {
        this.outputBaseDIR = newDir;
    }

    public synchronized String getOutputBaseDIR() {
        return this.outputBaseDIR;
    }

    public synchronized void setOutputBaseURL(String newUrl) {
        this.outputBaseURL = newUrl;
    }

    public synchronized String getOutputBaseURL() {
        return this.outputBaseURL;
    }

    public synchronized void setOutputAppendage(String newAppendage) {
        this.outputAppendage = newAppendage;
    }

    public synchronized String getOutputAppendage() {
        return this.outputAppendage;
    }

    protected void generateErrorHTML(String errorMessage) {
        this.clearResultsHTML();
        this.addToResultsHTML(HTMLStrings.getHTMLErrorFragment((String)errorMessage));
    }

    protected SQLDataFormatter getSQLDataFormatterForColumn(int column) {
        return new SQLDataFormatter();
    }

    private SQLDataFormatter[] getSQLDataFormatterArray() {
        SQLDataFormatter[] tempArray = new SQLDataFormatter[this.resultsNumColumns];
        int column = 1;
        while (column <= this.resultsNumColumns) {
            tempArray[column - 1] = this.getSQLDataFormatterForColumn(column);
            ++column;
        }
        return tempArray;
    }

    protected String getPreTableHTML() {
        return "";
    }

    protected void verifyQueryAndOptions() throws Exception {
    }

    protected String getPostTableHTML() {
        String firstPart;
        String secondPart = "";
        String extra = "";
        if (this.row >= this.rowsTotalUpperLimit) {
            extra = " <b> at least (i.e. before it was halted) </b> ";
        }
        if (this.getDoRowTotal()) {
            firstPart = this.row == 1 ? "      (Query returned 1 result row, \n " : "      (Query returned " + extra + this.row + " result rows, \n";
            secondPart = this.rowsWrittenToHTML == 0 ? "      no rows are shown in the displayed table.) \n" : (this.row <= this.rowsWrittenToHTML ? "      all rows are shown in the displayed table.) \n" : (this.rowsWrittenToHTML == 1 ? "      only the first row is shown in the displayed table.) \n" : "      only the first " + this.rowsWrittenToHTML + " rows are shown in the displayed table.) \n"));
        } else if (this.row <= this.rowsWrittenToHTML) {
            firstPart = this.row == 1 ? "      (Query returned 1 result row, \n" : "      (Query returned " + this.row + " result rows, \n";
            secondPart = "      all rows are shown in the displayed table.) \n";
        } else if (this.rowsWrittenToHTML == 0) {
            firstPart = "      (Query returned more than 0 result rows, \n";
            secondPart = "      no rows are shown in the displayed table.) \n";
        } else if (this.rowsWrittenToHTML == 1) {
            firstPart = "      (Query returned more than 1 result row, \n";
            secondPart = "      only the first row is shown in the displayed table.) \n";
        } else {
            firstPart = "      (Query returned more than " + this.rowsWrittenToHTML + " result rows, \n";
            secondPart = "      only the first " + this.rowsWrittenToHTML + " rows are shown in the displayed table.) \n";
        }
        return "    <p> \n" + firstPart + secondPart + "    </p> \n\n";
    }

    protected String getInsertedTableCellsHeaderHTML() {
        return "        <th>&nbsp;</th> \n";
    }

    protected String getInsertedTableCellsDataHTML() {
        return "        <td nowrap class=\"RowHeader\" bgcolor=\"" + this.getHTMLTableColorRowHeader() + "\"><b>" + this.row + "</b></td> \n";
    }

    public Statement setConnection() {
        try {
            this.databaseConnection = DriverManager.getConnection(this.databaseURL);
            DatabaseMetaData dbmd = this.databaseConnection.getMetaData();
            this.databaseQuery = this.databaseConnection.createStatement();
            return this.databaseQuery;
        }
        catch (SQLException se) {
            logger.error((Object)se);
            return null;
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void run() {
        block214: {
            block213: {
                block212: {
                    this.startTimeStr = Calendar.getInstance().getTime().toString();
                    WFAUSQLRetrieverThread.logger.debug((Object)"RetrieverThread,Status,Start of run");
                    this.setQueryProcessing(true);
                    this.setQueryTerminated(false);
                    resultsStringBuffer = new StringBuffer("");
                    runningNumber = WFAUSQLRetrieverThread.getNextCSVNumber();
                    uniqID = String.valueOf(String.valueOf(Calendar.getInstance().get(5))) + "_" + String.valueOf(Calendar.getInstance().get(11)) + "_" + String.valueOf(Calendar.getInstance().get(12)) + "_" + String.valueOf(Calendar.getInstance().get(13)) + "_" + runningNumber;
                    this.resultsURL = String.valueOf(this.getOutputBaseURL()) + this.getOutputAppendage() + "results" + uniqID + ".html";
                    WFAUSQLRetrieverThread.logger.debug((Object)uniqID);
                    CSVWriter = null;
                    CSVOutputStream /* !! */  = null;
                    OutputFormatCache = this.getOutputFormat();
                    if (OutputFormatCache != 0) {
                        testFile = new File(String.valueOf(this.getOutputBaseDIR()) + this.getOutputAppendage());
                        if (!testFile.exists() || !testFile.isDirectory()) {
                            this.generateErrorHTML("temp directory not available for writing.");
                            try {
                                this.databaseConnection.close();
                            }
                            catch (SQLException var8_8) {
                                // empty catch block
                            }
                            testFile = null;
                            return;
                        }
                        testFile = null;
                    }
                    cancelRunner = null;
                    CThread = null;
                    if (this.databaseURL != null) break block212;
                    this.generateErrorHTML("<b>Error in run():</b> No server/database URL provided.");
                    WFAUSQLRetrieverThread.logger.debug((Object)"and finally....");
                    this.setQueryProcessing(false);
                    try {
                        this.databaseConnection.close();
                    }
                    catch (SQLException var28_10) {
                        // empty catch block
                    }
                    CSVWriter = null;
                    CSVOutputStream /* !! */  = null;
                    resultsStringBuffer = null;
                    this.frs = null;
                    this.fw = null;
                    this.resultsMetaData = null;
                    if (this.results != null) {
                        try {
                            this.results.close();
                        }
                        catch (SQLException var28_11) {
                            // empty catch block
                        }
                    }
                    this.results = null;
                    if (this.databaseQuery != null) {
                        try {
                            this.databaseQuery.close();
                        }
                        catch (SQLException var28_13) {
                            // empty catch block
                        }
                    }
                    this.databaseQuery = null;
                    this.databaseConnection = null;
                    if (this.doCancelThread) {
                        try {
                            cancelRunner.interrupt();
                        }
                        catch (Exception var28_14) {
                            // empty catch block
                        }
                        cancelRunner = null;
                        CThread = null;
                    }
                    if (this.isMightBeBackground()) {
                        waitCount = 0;
                        while (this.getEmailAddress() == null && waitCount < 15) {
                            WFAUSQLRetrieverThread.logger.debug((Object)("hereibe " + waitCount));
                            ++waitCount;
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException var29_34) {
                                // empty catch block
                            }
                        }
                        if (this.getEmailAddress() != null && this.getEmailAddress().length() > 3) {
                            HTMLFileName = String.valueOf(this.getOutputBaseDIR()) + this.getOutputAppendage() + "results" + uniqID + ".html";
                            HTMLFile = new File(HTMLFileName);
                            try {
                                HTMLFile.createNewFile();
                                HTMLfw = new FileWriter(HTMLFile);
                                HTMLpw = new PrintWriter(HTMLfw);
                                HTMLpw.println(HTMLStrings.getHTMLHeadWithScript((String)"WSA SQL Query Results", (String)"http://surveys.roe.ac.uk/wsa/configurestyles.js"));
                                HTMLpw.println("<h3>WSA Database - SQL Query Results</h3>");
                                if (this.extraHTMLMsg.length() > 0) {
                                    HTMLpw.println("<p> " + this.extraHTMLMsg + "<p>");
                                }
                                if (this.showSQL) {
                                    HTMLpw.println("<p>Submitted query: " + HTMLFormatter.forHTMLTag(this.SQLQuery.trim()) + "<p>");
                                }
                                HTMLpw.println("<b>Start:</b> " + this.startTimeStr + " <b>End:</b> " + Calendar.getInstance().getTime() + "<p>Database: " + this.database + "<p>");
                                HTMLpw.println(this.htmlResults.toString());
                                HTMLpw.println("</body> </html>");
                                HTMLfw.close();
                            }
                            catch (IOException HTMLfw) {
                                // empty catch block
                            }
                            try {
                                properties = System.getProperties();
                                session = Session.getInstance((Properties)properties, null);
                                message = new MimeMessage(session);
                                message.setFrom((Address)new InternetAddress("wsa-support@roe.ac.uk"));
                                message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(this.getEmailAddress()));
                                message.addRecipient(Message.RecipientType.BCC, (Address)new InternetAddress("mar@roe.ac.uk"));
                                message.setSubject("WFCAM Science Archive");
                                message.setText("The results of your query can be retrieved from \n" + this.getOutputBaseURL() + this.getOutputAppendage() + "results" + uniqID + ".html");
                                transport = session.getTransport("smtp");
                                transport.connect("bulkmailrelay.ucs.ed.ac.uk", "", "");
                                transport.sendMessage((Message)message, message.getAllRecipients());
                                transport.close();
                            }
                            catch (MessagingException properties) {
                                // empty catch block
                            }
                        }
                    }
                    System.gc();
                    return;
                }
                if (this.doCancelThread) {
                    CThread = new CancelThread(this.databaseQuery, Math.min(4800, this.timeout));
                    cancelRunner = new Thread((Runnable)CThread);
                    cancelRunner.start();
                } else {
                    this.databaseQuery.setQueryTimeout(Math.min(4800, this.timeout));
                }
                this.databaseQuery.setFetchSize(500);
                this.databaseQuery.setMaxRows(30000001);
                noBrowseCols = 0;
                if (this.uploadFile != null) ** GOTO lbl232
                browsemd = SQLMethods.browseSQL(this.databaseConnection, this.SQLQuery);
                if (this.doCancelThread && CThread.getCancelled()) {
                    throw new SQLException("Query statement cancelled by timeout.");
                }
                this.databaseQuery.execute("set fmtonly off");
                if (browsemd != null) {
                    noBrowseCols = browsemd.getColumnCount();
                    if (noBrowseCols > 0) {
                        this.databaseQuery.setMaxRows((int)Math.ceil(1.5E7 / ((double)noBrowseCols * 1000.0)) * 1000 * 2 + 2);
                    }
                } else {
                    WFAUSQLRetrieverThread.logger.info((Object)"null browsemd");
                }
                if (!this.isQueryTerminated()) break block213;
                WFAUSQLRetrieverThread.logger.debug((Object)"and finally....");
                this.setQueryProcessing(false);
                try {
                    this.databaseConnection.close();
                }
                catch (SQLException waitCount) {
                    // empty catch block
                }
                CSVWriter = null;
                CSVOutputStream /* !! */  = null;
                resultsStringBuffer = null;
                this.frs = null;
                this.fw = null;
                this.resultsMetaData = null;
                if (this.results != null) {
                    try {
                        this.results.close();
                    }
                    catch (SQLException waitCount) {
                        // empty catch block
                    }
                }
                this.results = null;
                if (this.databaseQuery != null) {
                    try {
                        this.databaseQuery.close();
                    }
                    catch (SQLException waitCount) {
                        // empty catch block
                    }
                }
                this.databaseQuery = null;
                this.databaseConnection = null;
                if (this.doCancelThread) {
                    try {
                        cancelRunner.interrupt();
                    }
                    catch (Exception waitCount) {
                        // empty catch block
                    }
                    cancelRunner = null;
                    CThread = null;
                }
                if (this.isMightBeBackground()) {
                    waitCount = 0;
                    while (this.getEmailAddress() == null && waitCount < 15) {
                        WFAUSQLRetrieverThread.logger.debug((Object)("hereibe " + waitCount));
                        ++waitCount;
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException HTMLFileName) {
                            // empty catch block
                        }
                    }
                    if (this.getEmailAddress() != null && this.getEmailAddress().length() > 3) {
                        HTMLFileName = String.valueOf(this.getOutputBaseDIR()) + this.getOutputAppendage() + "results" + uniqID + ".html";
                        HTMLFile = new File(HTMLFileName);
                        try {
                            HTMLFile.createNewFile();
                            HTMLfw = new FileWriter(HTMLFile);
                            HTMLpw = new PrintWriter(HTMLfw);
                            HTMLpw.println(HTMLStrings.getHTMLHeadWithScript((String)"WSA SQL Query Results", (String)"http://surveys.roe.ac.uk/wsa/configurestyles.js"));
                            HTMLpw.println("<h3>WSA Database - SQL Query Results</h3>");
                            if (this.extraHTMLMsg.length() > 0) {
                                HTMLpw.println("<p> " + this.extraHTMLMsg + "<p>");
                            }
                            if (this.showSQL) {
                                HTMLpw.println("<p>Submitted query: " + HTMLFormatter.forHTMLTag(this.SQLQuery.trim()) + "<p>");
                            }
                            HTMLpw.println("<b>Start:</b> " + this.startTimeStr + " <b>End:</b> " + Calendar.getInstance().getTime() + "<p>Database: " + this.database + "<p>");
                            HTMLpw.println(this.htmlResults.toString());
                            HTMLpw.println("</body> </html>");
                            HTMLfw.close();
                        }
                        catch (IOException HTMLfw) {
                            // empty catch block
                        }
                        try {
                            properties = System.getProperties();
                            session = Session.getInstance((Properties)properties, null);
                            message = new MimeMessage(session);
                            message.setFrom((Address)new InternetAddress("wsa-support@roe.ac.uk"));
                            message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(this.getEmailAddress()));
                            message.addRecipient(Message.RecipientType.BCC, (Address)new InternetAddress("mar@roe.ac.uk"));
                            message.setSubject("WFCAM Science Archive");
                            message.setText("The results of your query can be retrieved from \n" + this.getOutputBaseURL() + this.getOutputAppendage() + "results" + uniqID + ".html");
                            transport = session.getTransport("smtp");
                            transport.connect("bulkmailrelay.ucs.ed.ac.uk", "", "");
                            transport.sendMessage((Message)message, message.getAllRecipients());
                            transport.close();
                        }
                        catch (MessagingException properties) {
                            // empty catch block
                        }
                    }
                }
                System.gc();
                return;
            }
            try {
                try {
                    block215: {
                        this.startTime = System.currentTimeMillis();
                        this.results = this.databaseQuery.executeQuery(this.SQLQuery);
                        break block215;
lbl232:
                        // 1 sources

                        SQLQueryBuffer = null;
                        this.startTime = System.currentTimeMillis();
                        try {
                            checkSQL = null;
                            where = "";
                            if (this.xWhere != null && !this.xWhere.equals("")) {
                                checkSQL = "select " + this.xSelect + " from " + this.xTable + " where " + this.xWhere;
                                where = " and " + this.xWhere;
                            } else {
                                checkSQL = "select " + this.xSelect + " from " + this.xTable;
                            }
                            SQLMethods.checkValidSQL(this.databaseConnection, checkSQL);
                            this.databaseQuery.executeUpdate("create table #upload  (upload_ID int,upload_RA float,upload_Dec float)");
                            this.databaseQuery.executeUpdate("create table #proxtab  (upID int,archiveID bigint ,distance float)");
                            SQLQueryBuffer = new StringBuffer("");
                            file = new File(this.uploadFile);
                            fr = new FileReader(file);
                            in = new BufferedReader(fr);
                            count = 0;
                            this.databaseConnection.setAutoCommit(false);
                            while ((line = in.readLine()) != null && !this.isQueryTerminated()) {
                                ++count;
                                upCoords = StringToRADec.getRADec(line.trim());
                                upRA = (Double)upCoords[0];
                                upDec = (Double)upCoords[1];
                                upMatchID = (Long)upCoords[2];
                                if (!(upRA >= 0.0) || !(upRA <= 360.0) || !(upDec >= -90.0) || !(upDec <= 90.0)) continue;
                                this.databaseQuery.addBatch("insert into #upload  values (" + count + "," + upRA + "," + upDec + "\t)");
                            }
                            this.databaseConnection.commit();
                            updateCounts = this.databaseQuery.executeBatch();
                            this.databaseConnection.setAutoCommit(true);
                            resultsStringBuffer.append("<br>" + updateCounts.length + " rows uploaded<p>");
                            this.databaseQuery.executeUpdate("EXEC master..spWSACrossID " + this.xRadius / 60.0 + ",'" + this.xDB + ".." + this.xTable + "','" + this.xID + "'," + this.xNearest + ",' " + where + " '");
                            SQLQueryBuffer.append(this.SQLQuery);
                        }
                        catch (FileNotFoundException checkSQL) {
                            // empty catch block
                        }
                        this.results = this.databaseQuery.executeQuery(SQLQueryBuffer.toString());
                    }
                    this.resultsMetaData = this.results.getMetaData();
                    this.frs.setRSMD(this.resultsMetaData);
                    if (OutputFormatCache == 2) {
                        this.fw = new FITSWriter(this.SQLQuery);
                    }
                    pVOT = null;
                    this.resultsNumColumns = this.resultsMetaData.getColumnCount();
                    row_size = 0;
                    this.rowsWrittenUpperLimit = (int)Math.ceil(1.5E7 / ((double)this.resultsNumColumns * 1000.0)) * 1000 - 1;
                    if (this.rowsWrittenUpperLimit < 1) {
                        this.rowsWrittenUpperLimit = 2;
                    }
                    this.rowsTotalUpperLimit = 2 * (this.rowsWrittenUpperLimit + 1);
                    this.columnNames = new String[this.resultsNumColumns];
                    switch (OutputFormatCache) {
                        case 0: {
                            this.fileDescr = "";
                            break;
                        }
                        case 2: {
                            this.fileDescr = "FITS";
                            this.FITSName = "results" + uniqID;
                            this.savedFilename = String.valueOf(this.FITSName) + ".fits";
                            FITSFile = new File(String.valueOf(this.getOutputBaseDIR()) + this.getOutputAppendage() + this.savedFilename);
                            if (FITSFile.exists()) {
                                FITSFile.delete();
                            }
                            this.fw.setFileName(String.valueOf(this.getOutputBaseDIR()) + this.getOutputAppendage() + this.savedFilename);
                            this.fw.setRSMD(this.resultsMetaData);
                            break;
                        }
                        case 1: {
                            this.CSVName = "results" + uniqID;
                            switch (this.getOutputCompression()) {
                                case 0: {
                                    this.savedFilename = String.valueOf(this.CSVName) + ".csv";
                                    this.fileDescr = "CSV ASCII";
                                    try {
                                        CSVOutputStream /* !! */  = new BufferedOutputStream(new FileOutputStream(String.valueOf(this.getOutputBaseDIR()) + this.getOutputAppendage() + this.savedFilename), 524288);
                                    }
                                    catch (Exception e) {
                                        CSVOutputStream /* !! */  = null;
                                    }
                                    break;
                                }
                                case 1: {
                                    this.savedFilename = String.valueOf(this.CSVName) + ".zip";
                                    this.fileDescr = "zipped CSV ASCII";
                                    try {
                                        CSVOutputStream /* !! */  = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(String.valueOf(this.getOutputBaseDIR()) + this.getOutputAppendage() + this.savedFilename), 524288));
                                        ((ZipOutputStream)CSVOutputStream /* !! */ ).setLevel(9);
                                        ((ZipOutputStream)CSVOutputStream /* !! */ ).putNextEntry(new ZipEntry(String.valueOf(this.CSVName) + ".csv"));
                                    }
                                    catch (Exception e) {
                                        CSVOutputStream /* !! */  = null;
                                    }
                                    break;
                                }
                                case 2: {
                                    this.savedFilename = String.valueOf(this.CSVName) + ".csv.gz";
                                    this.fileDescr = "gzipped CSV ASCII";
                                    try {
                                        CSVOutputStream /* !! */  = new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(String.valueOf(this.getOutputBaseDIR()) + this.getOutputAppendage() + this.savedFilename), 524288));
                                        break;
                                    }
                                    catch (Exception e) {
                                        CSVOutputStream /* !! */  = null;
                                    }
                                }
                            }
                            if (CSVOutputStream /* !! */  == null) break;
                            try {
                                CSVWriter = new PrintWriter(CSVOutputStream /* !! */ , true);
                            }
                            catch (Exception e) {
                                CSVWriter = null;
                            }
                            break;
                        }
                        case 3: {
                            pVOT = new ParseVOT(this.SQLQuery);
                            this.frs.setVOT(true);
                            pVOT.setRSMD(this.resultsMetaData);
                            this.CSVName = "results" + uniqID;
                            switch (this.getOutputCompression()) {
                                case 0: {
                                    this.savedFilename = String.valueOf(this.CSVName) + ".xml";
                                    this.fileDescr = "VOTable ASCII";
                                    try {
                                        CSVOutputStream /* !! */  = new BufferedOutputStream(new FileOutputStream(String.valueOf(this.getOutputBaseDIR()) + this.getOutputAppendage() + this.savedFilename), 524288);
                                    }
                                    catch (Exception e) {
                                        CSVOutputStream /* !! */  = null;
                                    }
                                    break;
                                }
                                case 1: {
                                    this.savedFilename = String.valueOf(this.CSVName) + ".zip";
                                    this.fileDescr = "zipped VOTable ASCII";
                                    try {
                                        CSVOutputStream /* !! */  = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(String.valueOf(this.getOutputBaseDIR()) + this.getOutputAppendage() + this.savedFilename), 524288));
                                        ((ZipOutputStream)CSVOutputStream /* !! */ ).setLevel(9);
                                        ((ZipOutputStream)CSVOutputStream /* !! */ ).putNextEntry(new ZipEntry(String.valueOf(this.CSVName) + ".xml"));
                                    }
                                    catch (Exception e) {
                                        CSVOutputStream /* !! */  = null;
                                    }
                                    break;
                                }
                                case 2: {
                                    this.savedFilename = String.valueOf(this.CSVName) + ".xml.gz";
                                    this.fileDescr = "gzipped VOTable ASCII";
                                    try {
                                        CSVOutputStream /* !! */  = new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(String.valueOf(this.getOutputBaseDIR()) + this.getOutputAppendage() + this.savedFilename), 524288));
                                        break;
                                    }
                                    catch (Exception e) {
                                        CSVOutputStream /* !! */  = null;
                                    }
                                }
                            }
                            if (CSVOutputStream /* !! */  != null) {
                                try {
                                    CSVWriter = new PrintWriter(CSVOutputStream /* !! */ , true);
                                }
                                catch (Exception e) {
                                    CSVWriter = null;
                                }
                            }
                            CSVWriter.println(pVOT.getVOTHeader());
                            CSVWriter.println(pVOT.setRSMD(this.resultsMetaData));
                        }
                    }
                    if (this.doShowMF) {
                        this.showMF = ShowCols.areColsInRS(WFAUSQLRetrieverThread.showMFArr, this.resultsMetaData);
                        if (this.showMF) {
                            resultsStringBuffer.append("The mfLink column can be used to display and download the associated multiframe.<p>");
                        }
                    }
                    if (this.doShowGIF) {
                        this.showGIF = ShowCols.areColsInRS(WFAUSQLRetrieverThread.showGIFArr, this.resultsMetaData);
                        if (this.showGIF) {
                            resultsStringBuffer.append("The getFSLink column can be used to display 1 arcmin image cut-outs around the RA/Dec of the object.<p>");
                        }
                    }
                    if (this.doShowGIM) {
                        this.showGIM = ShowCols.areColsInRS(WFAUSQLRetrieverThread.showGIMArr, this.resultsMetaData);
                        if (this.showGIM) {
                            resultsStringBuffer.append("The getMFLink column can be used to display 1 arcmin image cut-outs around the RA/Dec of the object.<p>");
                        }
                    }
                    resultsStringBuffer.append(this.getPreTableHTML());
                    resultsStringBuffer.append("    <table border=\"1\" cellspacing=\"0\" cellpadding=\"3\" bgcolor=\"" + this.getHTMLTableColorRowOdd() + "\"> \n");
                    GenerateHTML = true;
                    doForm = false;
                    RAPresent = false;
                    DecPresent = false;
                    RACol = 0;
                    DecCol = 0;
                    if (this.resultsNumColumns > 0) {
                        if (GenerateHTML) {
                            resultsStringBuffer.append("      <tr bgcolor=\"" + this.getHTMLTableColorRowHeader() + "\"> \n");
                            resultsStringBuffer.append(this.getInsertedTableCellsHeaderHTML());
                        }
                        row_size = SQLMethods.getSizeOfRS(this.resultsMetaData);
                        column = 1;
                        while (column <= this.resultsNumColumns) {
                            this.columnNames[column - 1] = this.resultsMetaData.getColumnName(column);
                            if (this.columnNames[column - 1].equalsIgnoreCase("RA")) {
                                RACol = column - 1;
                                RAPresent = true;
                            }
                            if (this.columnNames[column - 1].equalsIgnoreCase("DEC")) {
                                DecCol = column - 1;
                                DecPresent = true;
                            }
                            ++column;
                        }
                        if (GenerateHTML && this.showMF) {
                            resultsStringBuffer.append("        <th nowrap=\"nowrap\">mfLink</th> \n");
                        }
                        if (GenerateHTML && this.showGIF) {
                            resultsStringBuffer.append("        <th nowrap=\"nowrap\">getFSLink</th> \n");
                        }
                        if (GenerateHTML && this.showGIM) {
                            resultsStringBuffer.append("        <th nowrap=\"nowrap\">getMFLink</th> \n");
                        }
                        if (!GenerateHTML || RAPresent) {
                            // empty if block
                        }
                        if (OutputFormatCache == 1 && CSVWriter != null) {
                            CSVWriter.print(ACSVWriter.printHeader((ResultSetMetaData)this.resultsMetaData, (String)this.SQLQuery));
                        }
                        column = 1;
                        while (column <= this.resultsNumColumns) {
                            this.columnNames[column - 1] = this.resultsMetaData.getColumnName(column);
                            if (GenerateHTML) {
                                if (this.columnNames[column - 1].length() < 1) {
                                    resultsStringBuffer.append("        <th nowrap>&nbsp;</th> \n");
                                } else {
                                    resultsStringBuffer.append("        <th nowrap>" + this.columnNames[column - 1] + "</th> \n");
                                }
                            }
                            ++column;
                        }
                        if (GenerateHTML) {
                            resultsStringBuffer.append("      </tr> \n");
                        }
                    }
                    this.columnFormats = this.getSQLDataFormatterArray();
                    this.verifyQueryAndOptions();
                    this.row = 0;
                    strArray = new String[this.resultsNumColumns];
                    votArray = new String[this.resultsNumColumns];
                    maxRowsHTML = this.rowsHTML;
                    if (this.resultsNumColumns > 0) {
                        maxRowsHTML = Math.min(this.rowsHTML, 10000 / this.resultsNumColumns);
                    }
                    GenerateHTML = maxRowsHTML > 0;
                    if (!this.doCancelThread || !CThread.getCancelled()) ** GOTO lbl519
                    this.AnySQLErrors = true;
                    throw new SQLException("Query statement cancelled by timeout.");
lbl-1000:
                    // 1 sources

                    {
                        ++this.row;
                        if (GenerateHTML || OutputFormatCache == 1) {
                            strArray = this.frs.setRS(this.results);
                        }
                        if (OutputFormatCache == 3) {
                            votArray = pVOT.setRS(this.results);
                        }
                        if (GenerateHTML) {
                            ++this.rowsWrittenToHTML;
                            if (this.row % 2 == 0) {
                                resultsStringBuffer.append("      <tr bgcolor=\"" + this.getHTMLTableColorRowEven() + "\" class=\"RowEven\"> \n");
                            } else {
                                resultsStringBuffer.append("      <tr bgcolor=\"" + this.getHTMLTableColorRowOdd() + "\" class=\"RowOdd\"> \n");
                            }
                            resultsStringBuffer.append(this.getInsertedTableCellsDataHTML());
                            if (GenerateHTML && this.showMF) {
                                resultsStringBuffer.append(ShowCols.getMFLinkCell(this.results));
                            }
                            if (GenerateHTML && this.showGIF) {
                                resultsStringBuffer.append(ShowCols.getGIFLinkCell(this.results, this.database));
                            }
                            if (GenerateHTML && this.showGIM) {
                                resultsStringBuffer.append(ShowCols.getGIMLinkCell(this.results, this.database));
                            }
                            column = 1;
                            while (column <= this.resultsNumColumns) {
                                this.columnData = strArray[column - 1].trim();
                                resultsStringBuffer.append("<td align=\"right\" nowrap>" + this.columnFormats[column - 1].formatDataForHTML(this.columnData) + "</td> \n");
                                ++column;
                            }
                            resultsStringBuffer.append("</tr> \n");
                            v0 = GenerateHTML = this.row + 1 <= maxRowsHTML && resultsStringBuffer.length() < 0x100000;
                        }
                        if (OutputFormatCache == 2) {
                            this.fw.setRS(this.results);
                        }
                        column = 1;
                        while (column <= this.resultsNumColumns) {
                            if (OutputFormatCache == 1 && CSVWriter != null) {
                                if (column == this.resultsNumColumns) {
                                    CSVWriter.println(strArray[column - 1]);
                                } else {
                                    CSVWriter.print(String.valueOf(strArray[column - 1]) + ",");
                                }
                            }
                            if (OutputFormatCache == 3 && CSVWriter != null) {
                                if (column == 1) {
                                    CSVWriter.print("<TR>");
                                }
                                CSVWriter.print("<TD>" + votArray[column - 1] + "</TD>");
                                if (column == this.resultsNumColumns) {
                                    CSVWriter.println("</TR>");
                                }
                            }
                            ++column;
                        }
lbl519:
                        // 2 sources

                        ** while (!this.isQueryTerminated() && (OutputFormatCache != 0 && this.row <= this.rowsWrittenUpperLimit || GenerateHTML) && this.results.next())
                    }
lbl520:
                    // 1 sources

                    this.rowsWrittenToFile = this.row;
                    while (!this.isQueryTerminated() && this.doRowTotal && this.results.next() && this.row < this.rowsTotalUpperLimit) {
                        ++this.row;
                    }
                    if (this.doCancelThread && CThread.getCancelled()) {
                        throw new SQLException("Query statement cancelled by timeout.");
                    }
                    if (this.doCancelThread) {
                        CThread.setFinished();
                    }
                    if (this.isQueryTerminated()) {
                        resultsStringBuffer.insert(0, "WARNING: Stopped by request");
                    }
                    resultsStringBuffer.append("    </table>\n\n");
                    resultsStringBuffer.append(this.getPostTableHTML());
                    if (OutputFormatCache == 2) {
                        this.fw.close();
                        if (this.dataOutputCompression == 2) {
                            try {
                                outFilename = String.valueOf(this.getOutputBaseDIR()) + this.getOutputAppendage() + this.savedFilename + ".gz";
                                out = new GZIPOutputStream(new FileOutputStream(outFilename));
                                inFilename = String.valueOf(this.getOutputBaseDIR()) + this.getOutputAppendage() + this.savedFilename;
                                in = new FileInputStream(inFilename);
                                buf = new byte[1024];
                                while ((len = in.read(buf)) > 0) {
                                    out.write(buf, 0, len);
                                }
                                in.close();
                                out.finish();
                                out.close();
                                this.savedFilename = String.valueOf(this.FITSName) + ".fits.gz";
                                this.fileDescr = "gzipped FITS";
                            }
                            catch (IOException outFilename) {
                                // empty catch block
                            }
                        }
                    }
                    if (OutputFormatCache == 1 && CSVWriter != null) {
                        CSVWriter.flush();
                        if (this.getOutputCompression() == 1) {
                            ((ZipOutputStream)CSVOutputStream /* !! */ ).closeEntry();
                        }
                        CSVWriter.close();
                    }
                    if (OutputFormatCache == 3 && CSVWriter != null) {
                        CSVWriter.print(pVOT.getFooter());
                        CSVWriter.flush();
                        if (this.getOutputCompression() == 1) {
                            ((ZipOutputStream)CSVOutputStream /* !! */ ).closeEntry();
                        }
                        CSVWriter.close();
                    }
                    if (OutputFormatCache != 0) {
                        rowtemp = this.rowsWrittenUpperLimit + 1;
                        if (this.row > this.rowsWrittenToFile) {
                            resultsStringBuffer.append("<p><b> NB The number of rows written to the output file reached the maximum allowed " + rowtemp + "</b>");
                        }
                    }
                    if (OutputFormatCache != 0) {
                        fileLink = String.valueOf(this.getOutputBaseURL()) + this.getOutputAppendage() + this.savedFilename;
                        resultsStringBuffer.append("<p> \n<table cellspacing=\"0\" cellpadding=\"3\"><tr><td align=\"right\"><a href=\"" + fileLink + "\"><img src=\"" + this.getOutputBaseURL() + "images/icons/save.gif\" border=\"0\"></a></td>" + "<td><a href=\"" + fileLink + "\">" + "Download Results File </a>, your results in a " + this.fileDescr + " file \n" + "(Contains <b>");
                        if (this.rowsWrittenToFile == 1) {
                            resultsStringBuffer.append("1 row</b>, ");
                        } else {
                            resultsStringBuffer.append(String.valueOf(this.rowsWrittenToFile) + " rows</b>, ");
                        }
                        sFile = new File(String.valueOf(this.getOutputBaseDIR()) + this.getOutputAppendage() + this.savedFilename);
                        sFileSize = sFile.length();
                        if (sFileSize > 1000000L) {
                            resultsStringBuffer.append(String.valueOf(HTMLStrings.numbersTo1DP.format((double)sFileSize / 1024.0 / 1024.0)) + " MB) \n");
                        } else if (sFileSize > 1000L) {
                            resultsStringBuffer.append(String.valueOf(HTMLStrings.numbersTo1DP.format((double)sFileSize / 1024.0)) + " KB) \n");
                        } else {
                            resultsStringBuffer.append(String.valueOf(sFileSize) + " bytes) \n");
                        }
                        resultsStringBuffer.append("</td> \n");
                        if (OutputFormatCache == 2 || OutputFormatCache == 3) {
                            resultsStringBuffer.append("<tr class=\"Normal\"  bgcolor=\"#FFFFFF\"><td align=\"right\">\n<a href=\"http://surveys.roe.ac.uk:8080/ssa/launch.jsp?file=" + fileLink + "\"><img src=\"http://surveys.roe.ac.uk/ssa/topcat.gif\" border=\"0\"></a> </td>" + "<td><a href=\"http://surveys.roe.ac.uk:8080/ssa/launch.jsp?file=" + fileLink + "\"" + ">Launch file in Topcat</a> (requires Java 1.5 and Java Web Start, approx 12Mb download for Topcat application)</td>");
                        }
                        resultsStringBuffer.append("<tr class=\"Normal\" bgcolor=\"#FFFFFF\"><td align=\"right\"> \n<a href=\"http://surveys.roe.ac.uk:8080/wsa/saveToMySpace.jsp?file=" + fileLink + "\"><img src=\"http://surveys.roe.ac.uk/wsa/ag.gif\" border=\"0\"></a></td>" + "<td><a href=\"http://surveys.roe.ac.uk:8080/wsa/saveToMySpace.jsp?file=" + fileLink + "\"" + ">Save file to MySpace</a> (requires an AstroGrid account, Java 1.5 and Java Web Start to launch, uses AstroGrid workbench, large first download)</td></table>");
                    }
                    if (!RAPresent || DecPresent) {
                        // empty if block
                    }
                    this.databaseQuery.execute("select 1");
                    if (this.updateWebqueries && this.SQLQuery.toLowerCase().indexOf("listwebqueries") < 0) {
                        elapsedTime = System.currentTimeMillis() - this.startTime;
                        try {
                            this.databaseQuery.execute(SQLMethods.getWebqueriesString(this.SQLQuery, this.row, elapsedTime, this.user, this.ipAddress, this.database, row_size));
                        }
                        catch (SQLException se) {
                            this.AnySQLErrors = true;
                            resultsStringBuffer.append(se);
                        }
                    }
                    if (this.qID > 0) {
                        try {
                            this.databaseQuery.execute(SQLMethods.getUpdateQStatusSQLURL(this.qID, 2, this.resultsURL));
                        }
                        catch (SQLException se) {
                            resultsStringBuffer.append(se);
                        }
                    }
                    this.clearResultsHTML();
                    this.addToResultsHTML(this.extraHTMLMsg);
                    this.addToResultsHTML(resultsStringBuffer.toString());
                }
                catch (SQLException se) {
                    this.AnySQLErrors = true;
                    if (this.qID > 0 && this.AnySQLErrors) {
                        try {
                            errStmt = this.databaseConnection.createStatement();
                            errStmt.execute(SQLMethods.getUpdateQStatusSQLURL(this.qID, 3, this.resultsURL));
                        }
                        catch (SQLException se1) {
                            WFAUSQLRetrieverThread.logger.info((Object)se1);
                        }
                    }
                    System.err.println("SQLRetrieverThread::run(): an SQLException -> " + se.getMessage() + se.getErrorCode());
                    extraInfo = "";
                    if (se.getMessage().toLowerCase().indexOf("cancelled") >= 0) {
                        extraInfo = "<br>Query ran for " + ParseCoords.formatP((double)((double)(System.currentTimeMillis() - this.startTime) / 1000.0), (int)1) + " secs<br>Timeout set at " + this.timeout;
                    }
                    this.generateErrorHTML("<b>SQL Error:</b> " + se.getMessage() + extraInfo);
                }
                catch (Exception e) {
                    System.err.println("SQLRetrieverThread::run(): Exception -> " + e.toString());
                    WFAUSQLRetrieverThread.logger.error((Object)e.toString());
                    this.generateErrorHTML("<b>Error in run():</b> " + e.toString());
                }
            }
            catch (Throwable var27_118) {}
            finally {
                WFAUSQLRetrieverThread.logger.debug((Object)"and finally....");
                this.setQueryProcessing(false);
                try {
                    this.databaseConnection.close();
                }
                catch (SQLException waitCount) {}
                CSVWriter = null;
                CSVOutputStream /* !! */  = null;
                resultsStringBuffer = null;
                this.frs = null;
                this.fw = null;
                this.resultsMetaData = null;
                if (this.results != null) {
                    try {
                        this.results.close();
                    }
                    catch (SQLException waitCount) {}
                }
                this.results = null;
                if (this.databaseQuery != null) {
                    try {
                        this.databaseQuery.close();
                    }
                    catch (SQLException waitCount) {}
                }
                this.databaseQuery = null;
                this.databaseConnection = null;
                if (this.doCancelThread) {
                    try {
                        cancelRunner.interrupt();
                    }
                    catch (Exception waitCount) {}
                    cancelRunner = null;
                    CThread = null;
                }
                if (!this.isMightBeBackground()) break block214;
                waitCount = 0;
                ** while (this.getEmailAddress() == null && waitCount < 15)
            }
lbl-1000:
            // 1 sources

            {
                WFAUSQLRetrieverThread.logger.debug((Object)("hereibe " + waitCount));
                ++waitCount;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException HTMLFileName) {
                    // empty catch block
                }
                continue;
            }
lbl692:
            // 1 sources

            if (this.getEmailAddress() != null && this.getEmailAddress().length() > 3) {
                HTMLFileName = String.valueOf(this.getOutputBaseDIR()) + this.getOutputAppendage() + "results" + uniqID + ".html";
                HTMLFile = new File(HTMLFileName);
                try {
                    HTMLFile.createNewFile();
                    HTMLfw = new FileWriter(HTMLFile);
                    HTMLpw = new PrintWriter(HTMLfw);
                    HTMLpw.println(HTMLStrings.getHTMLHeadWithScript((String)"WSA SQL Query Results", (String)"http://surveys.roe.ac.uk/wsa/configurestyles.js"));
                    HTMLpw.println("<h3>WSA Database - SQL Query Results</h3>");
                    if (this.extraHTMLMsg.length() > 0) {
                        HTMLpw.println("<p> " + this.extraHTMLMsg + "<p>");
                    }
                    if (this.showSQL) {
                        HTMLpw.println("<p>Submitted query: " + HTMLFormatter.forHTMLTag(this.SQLQuery.trim()) + "<p>");
                    }
                    HTMLpw.println("<b>Start:</b> " + this.startTimeStr + " <b>End:</b> " + Calendar.getInstance().getTime() + "<p>Database: " + this.database + "<p>");
                    HTMLpw.println(this.htmlResults.toString());
                    HTMLpw.println("</body> </html>");
                    HTMLfw.close();
                }
                catch (IOException HTMLfw) {
                    // empty catch block
                }
                try {
                    properties = System.getProperties();
                    session = Session.getInstance((Properties)properties, null);
                    message = new MimeMessage(session);
                    message.setFrom((Address)new InternetAddress("wsa-support@roe.ac.uk"));
                    message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(this.getEmailAddress()));
                    message.addRecipient(Message.RecipientType.BCC, (Address)new InternetAddress("mar@roe.ac.uk"));
                    message.setSubject("WFCAM Science Archive");
                    message.setText("The results of your query can be retrieved from \n" + this.getOutputBaseURL() + this.getOutputAppendage() + "results" + uniqID + ".html");
                    transport = session.getTransport("smtp");
                    transport.connect("bulkmailrelay.ucs.ed.ac.uk", "", "");
                    transport.sendMessage((Message)message, message.getAllRecipients());
                    transport.close();
                }
                catch (MessagingException var31_57) {
                    // empty catch block
                }
            }
        }
        System.gc();
    }
}

