/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.roe.wfau;

import javax.servlet.http.HttpSession;
import uk.ac.roe.wfau.WSASchema;

public class WSASession {
    public static final int UKIDSSTESTERCLASS = 0;
    public static final int UKIDSSCLASS = 1;
    public static final int WORLDCLASS = 2;
    public static final int PRERELEASECLASS = 3;
    public static final int NONSURVEYCLASS = 4;

    public static String getDBUser(HttpSession sess) {
        String community = WSASession.getCommunity(sess);
        if (community != null && community.equalsIgnoreCase("roe.ac.uk") && WSASession.getUser(sess).equalsIgnoreCase("gpsDR8")) {
            return "testro";
        }
        if (WSASession.getLoginBoolean(sess) && community.equalsIgnoreCase("uhs")) {
            return "uhsro";
        }
        if (WSASession.getLoginBoolean(sess) && !community.equalsIgnoreCase("nonSurvey") && !community.equalsIgnoreCase("prerelease") && !community.equalsIgnoreCase("world")) {
            return "wsaro";
        }
        if (WSASession.getLoginBoolean(sess) && community.equalsIgnoreCase("prerelease")) {
            return "wsaro";
        }
        if (WSASession.getLoginBoolean(sess) && community.equalsIgnoreCase("nonsurvey")) {
            return String.valueOf(WSASession.getUser(sess)) + "ro";
        }
        return "worldwsaro";
    }

    public static int getSessionClass(HttpSession sess) {
        String community = WSASession.getCommunity(sess);
        if (WSASession.getLoginBoolean(sess)) {
            if (community.equalsIgnoreCase("nonsurvey") || community.equalsIgnoreCase("uhs")) {
                return 4;
            }
            if (community.equalsIgnoreCase("prerelease")) {
                return 3;
            }
            if (community.equalsIgnoreCase("ukidsstester")) {
                return 0;
            }
            return 1;
        }
        return 2;
    }

    public static String getProgID(HttpSession sess) {
        if (sess.getAttribute("wsaprogrammeID") != null) {
            return ((String)sess.getAttribute("wsaprogrammeID")).trim();
        }
        return "-999";
    }

    public static String getCommunity(HttpSession sess) {
        if (sess.getAttribute("community") != null) {
            String community = ((String)sess.getAttribute("community")).toLowerCase().trim();
            if (community != null) {
                return community;
            }
            return "world";
        }
        return "world";
    }

    public static String[] getNonSurveyDBName(HttpSession sess) {
        String[] nsDBs = null;
        if (sess.getAttribute("wsareleasedDBs") != null) {
            nsDBs = (String[])sess.getAttribute("wsareleasedDBs");
        } else if (sess.getAttribute("wsadbName") != null && !((String)sess.getAttribute("wsadbName")).toLowerCase().trim().equalsIgnoreCase("na")) {
            String[] dbName = new String[]{WSASession.getUser(sess)};
            nsDBs = dbName;
        }
        return nsDBs;
    }

    public static String getUser(HttpSession sess) {
        return WSASession.getUser(sess, false);
    }

    public static String getUser(HttpSession sess, boolean generic) {
        if (sess.getAttribute("user") != null) {
            if (generic && WSASession.getCommunity(sess).equalsIgnoreCase("uhs")) {
                return "uhs";
            }
            String user = ((String)sess.getAttribute("user")).toLowerCase().trim();
            if (user != null) {
                return user;
            }
            return "public";
        }
        return "public";
    }

    public static String[] getDB(HttpSession sess) {
        return WSASession.getDB(sess, false);
    }

    public static String[] getDB(HttpSession sess, boolean doRollingDB) {
        return WSASession.getDB(sess, doRollingDB, true);
    }

    public static String[] getDB(HttpSession sess, boolean doRollingDB, boolean includeExtraDB) {
        return WSASession.getDB(sess, doRollingDB, includeExtraDB, false);
    }

    public static String[] getDB(HttpSession sess, boolean doRollingDB, boolean includeExtraDB, boolean includeMoreDB) {
        String[] DB;
        int sessClass = WSASession.getSessionClass(sess);
        switch (sessClass) {
            case 2: {
                DB = WSASchema.WORLDDB;
                DB = WSASchema.getDBsPlusExtraDB(DB, WSASchema.worldCalDBs);
                if (!includeMoreDB) break;
                DB = WSASchema.getDBsPlusExtraDB(DB, WSASchema.moreDB);
                break;
            }
            case 1: {
                DB = doRollingDB ? WSASchema.getDBsPlusRollingDB(WSASchema.UKIDSSDB) : WSASchema.UKIDSSDB;
                DB = WSASchema.getDBsPlusExtraDB(DB, WSASchema.calDBs);
                if (includeExtraDB) {
                    DB = WSASchema.getDBsPlusExtraDB(DB, WSASchema.extraDB);
                }
                if (!includeMoreDB) break;
                DB = WSASchema.getDBsPlusExtraDB(DB, WSASchema.moreDB);
                break;
            }
            case 4: {
                String[] nsdbs = WSASession.getNonSurveyDBName(sess);
                if (doRollingDB) {
                    if (WSASession.getNonSurveyDBName(sess) != null) {
                        DB = WSASchema.getDBsPlusRollingDB(WSASession.getNonSurveyDBName(sess));
                        break;
                    }
                    DB = new String[]{WSASchema.PRERELEASEDATABASE};
                    break;
                }
                if (WSASession.getNonSurveyDBName(sess) != null) {
                    DB = WSASession.getNonSurveyDBName(sess);
                    break;
                }
                DB = new String[]{"sorry no access"};
                break;
            }
            case 0: {
                DB = doRollingDB ? WSASchema.getDBsPlusRollingDB(WSASchema.UKIDSSTESTERDB) : WSASchema.UKIDSSTESTERDB;
                DB = WSASchema.getDBsPlusExtraDB(DB, WSASchema.calDBs);
                if (!includeExtraDB) break;
                DB = WSASchema.getDBsPlusExtraDB(DB, WSASchema.extraDB);
                break;
            }
            case 3: {
                DB = WSASchema.PRERELEASEDB;
                break;
            }
            default: {
                DB = WSASchema.WORLDDB;
            }
        }
        if (WSASession.getCommunity(sess).toLowerCase().contains("uhs")) {
            DB = doRollingDB ? WSASchema.getDBsPlusRollingDB(WSASchema.uhsDBs) : WSASchema.uhsDBs;
        }
        return DB;
    }

    public static int[] getProgs(HttpSession sess) {
        return WSASession.getProgs(sess, false);
    }

    public static int[] getProgs(HttpSession sess, boolean showUHS) {
        int[] progs;
        int sessClass = WSASession.getSessionClass(sess);
        switch (sessClass) {
            case 2: {
                if (showUHS) {
                    progs = WSASchema.UKIDSSUHSPROGS;
                    break;
                }
                progs = WSASchema.UKIDSSPROGS;
                break;
            }
            case 1: {
                if (showUHS) {
                    progs = WSASchema.UKIDSSUHSPROGS;
                    break;
                }
                progs = WSASchema.UKIDSSPROGS;
                break;
            }
            case 4: {
                progs = new int[]{};
                break;
            }
            case 0: {
                progs = WSASchema.UKIDSSTESTERPROGS;
                break;
            }
            case 3: {
                progs = WSASchema.PRERELEASEPROGS;
                break;
            }
            default: {
                progs = WSASchema.WORLDPROGS;
            }
        }
        return progs;
    }

    public static String getSchemaVersion(HttpSession sess) {
        if (sess.getAttribute("schemaVersion") != null) {
            String schemaVersion = ((String)sess.getAttribute("schemaVersion")).toLowerCase().trim();
            if (schemaVersion != null) {
                return schemaVersion;
            }
            return "null";
        }
        return "null";
    }

    public static boolean getSourceBoolean(HttpSession sess) {
        if (sess.getAttribute("wsasource") != null) {
            return (Boolean)sess.getAttribute("wsasource");
        }
        return false;
    }

    public static int[] getReqFilters(HttpSession sess) {
        try {
            return (int[])sess.getAttribute("wsareqFilters");
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean getLoginBoolean(HttpSession sess) {
        if (sess.getAttribute("login") != null) {
            try {
                return (Boolean)sess.getAttribute("login");
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public static String getDefaultList(HttpSession sess, String table, String database, int progID) {
        if (database == null) {
            if (WSASession.getCommunity(sess).equalsIgnoreCase("nonsurvey")) {
                return WSASchema.getDefaultList(WSASession.getReqFilters(sess), table, WSASession.getSchemaVersion(sess));
            }
            if (WSASession.getLoginBoolean(sess)) {
                return WSASchema.getDefaultList(WSASchema.getReqFilters(progID), table, WSASchema.LATESTUKIDSSSCHEMA);
            }
            return WSASchema.getDefaultList(WSASchema.getReqFilters(progID), table, WSASchema.LATESTWORLDSCHEMA);
        }
        if (WSASession.getCommunity(sess).equalsIgnoreCase("nonsurvey")) {
            return WSASchema.getDefaultList(WSASession.getReqFilters(sess), table, WSASession.getSchemaVersion(sess));
        }
        if (WSASession.getLoginBoolean(sess)) {
            return WSASchema.getDefaultList(WSASchema.getReqFilters(progID), table, database);
        }
        return WSASchema.getDefaultList(WSASchema.getReqFilters(progID), table, database);
    }
}

